/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.util.ComparisonUtil;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class NetCircuitNodeDataSource
extends AbstractRowDataSource
implements Observer {
    private INetCircuit ckt;
    private List cktNodeList;

    public NetCircuitNodeDataSource(INetCircuit iNetCircuit) {
        this.ckt = iNetCircuit;
        this.cktNodeList = NetCircuitNodeDataSource.getOrderedCircuitNodes(this.ckt);
        this.ckt.addObserver(this);
    }

    public void dispose() {
        this.cktNodeList = new ArrayList(0);
        this.ckt.deleteObserver(this);
        this.ckt = null;
    }

    public synchronized void update(Observable observable, Object object) {
        if (observable instanceof INetCircuit) {
            this.cktNodeList = NetCircuitNodeDataSource.getOrderedCircuitNodes((INetCircuit)((Object)observable));
            this.fireDataSourceChanged();
        }
    }

    public Collection getAllObjects() {
        return this.cktNodeList;
    }

    public Object getObjectAtRow(int n) {
        if (this.cktNodeList.size() > n) {
            return this.cktNodeList.get(n);
        }
        return null;
    }

    public int getRowCount() {
        return this.cktNodeList.size();
    }

    public Class getRowObjectClass() {
        return INetCircuitNode.class;
    }

    private static List getOrderedCircuitNodes(INetCircuit iNetCircuit) {
        List list = iNetCircuit.getCircuitNodes();
        INetCircuitNode iNetCircuitNode = iNetCircuit.getSrcCircuitNode();
        if (list.size() <= 1 || iNetCircuitNode == null) {
            return list;
        }
        List list2 = iNetCircuit.getCircuitSpans();
        ArrayList<BFSNode> arrayList = new ArrayList<BFSNode>(list.size());
        boolean bl = false;
        arrayList.add(new BFSNode(iNetCircuitNode, 0));
        for (int i = 0; i < arrayList.size(); ++i) {
            BFSNode bFSNode = (BFSNode)arrayList.get(i);
            INetElement iNetElement = bFSNode.node.getNetElement();
            int n = bFSNode.getCost() + 1;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                INetCircuitNode iNetCircuitNode2;
                INetLink iNetLink = ((INetCircuitSpan)iterator.next()).getLink();
                INetElement iNetElement2 = null;
                if (iNetLink.getSrc() != iNetElement) continue;
                iNetElement2 = iNetLink.getDst();
                iterator.remove();
                if (iNetElement2 == null || (iNetCircuitNode2 = iNetCircuit.getCircuitNodeFromNE(iNetElement2)) == null) continue;
                BFSNode bFSNode2 = new BFSNode(iNetCircuitNode2, n);
                int n2 = arrayList.indexOf(bFSNode2);
                if (n2 != -1) {
                    bl |= ((BFSNode)arrayList.get(n2)).updateCost(n);
                    continue;
                }
                arrayList.add(bFSNode2);
                bFSNode.addChild(bFSNode2);
            }
        }
        if (arrayList.size() != list.size()) {
            return list;
        }
        if (bl) {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ComparisonUtil.compare((int)((BFSNode)object).getCost(), (int)((BFSNode)object2).getCost());
                }
            });
        }
        return NetCircuitNodeDataSource.getNodeList(arrayList);
    }

    private static List getNodeList(List list) {
        ArrayList<INetCircuitNode> arrayList = new ArrayList<INetCircuitNode>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((BFSNode)iterator.next()).getNode());
        }
        return arrayList;
    }

    private static class BFSNode {
        private INetCircuitNode node;
        private int cost;
        private List children;

        public BFSNode(INetCircuitNode iNetCircuitNode, int n) {
            this.node = iNetCircuitNode;
            this.children = new LinkedList();
            this.cost = n;
        }

        public int getCost() {
            return this.cost;
        }

        public INetCircuitNode getNode() {
            return this.node;
        }

        public boolean equals(Object object) {
            return ((BFSNode)object).node == this.node;
        }

        public void addChild(BFSNode bFSNode) {
            this.children.add(bFSNode);
        }

        public boolean updateCost(int n) {
            if (this.cost < n) {
                this.cost = n++;
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    ((BFSNode)iterator.next()).updateCost(n);
                }
                return true;
            }
            return false;
        }
    }
}

