/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.model.circuits.OchncSpanRow;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.VirtualNetLink;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;

public class OchncSpanDataSource
extends AbstractRowDataSource
implements Observer {
    private final NetCircuitManager ncm = NetCircuitManager.instance();
    private final Network net = Network.instance();
    private INetLink forwardLink = null;
    private INetLink reverseLink = null;
    private List allCircuits = new ArrayList();
    private List circuits = new ArrayList();
    private List spanRows = Collections.synchronizedList(new ArrayList());
    private static SDebug db = new SDebug("OchncSpanDataSource");
    private OchncSdsDebug dumpDebug = new OchncSdsDebug("OchncSpanDataSourceDump");

    public OchncSpanDataSource() {
        this.ncm.addObserver(this);
    }

    public void setNetLink(INetLink iNetLink) {
        this.forwardLink = iNetLink;
        if (iNetLink instanceof VirtualNetLink) {
            this.reverseLink = this.net.findReverseLink(iNetLink);
        }
        this.update((Observable)((Object)this.ncm), null);
    }

    public void dispose() {
        this.dumpDebug.dispose();
        this.spanRows.clear();
        this.deleteCircuitObservers();
        this.circuits = new ArrayList();
        this.ncm.deleteObserver(this);
    }

    public synchronized void update(Observable observable, Object object) {
        if (observable == this.ncm) {
            this.refreshCircuits();
            this.registerWithAllCircuits();
        } else if (observable instanceof INetCircuit) {
            this.refreshCircuits();
        }
    }

    private void registerWithAllCircuits() {
        this.deleteCircuitObservers();
        this.allCircuits = this.ncm.getCircuits();
        Iterator iterator = this.allCircuits.iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = (INetCircuit)iterator.next();
            iNetCircuit.addObserver(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCircuits() {
        ArrayList arrayList;
        TreeSet treeSet = new TreeSet();
        if (OchncSpanDataSource.db.on) {
            db.println("refreshCircuits: processing forward link");
        }
        this.getLinkCircuits(treeSet, this.forwardLink);
        if (this.reverseLink != null) {
            this.getLinkCircuits(treeSet, this.reverseLink);
        }
        if (((Object)this.spanRows).equals(arrayList = new ArrayList(treeSet))) {
            if (OchncSpanDataSource.db.on) {
                db.println("no change in spanRows, returning");
            }
            this.fireDataSourceChanged();
            return;
        }
        this.spanRows.clear();
        this.spanRows.addAll(arrayList);
        this.circuits = new ArrayList(this.spanRows.size());
        List list = this.spanRows;
        synchronized (list) {
            Iterator iterator = this.spanRows.iterator();
            while (iterator.hasNext()) {
                OchncSpanRow ochncSpanRow = (OchncSpanRow)iterator.next();
                this.circuits.add(ochncSpanRow.circuit);
            }
        }
        this.fireDataSourceChanged();
    }

    private void deleteCircuitObservers() {
        Iterator iterator = this.allCircuits.iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = (INetCircuit)iterator.next();
            iNetCircuit.deleteObserver(this);
        }
    }

    private void getLinkCircuits(Set set, INetLink iNetLink) {
        INetCircuit iNetCircuit;
        Object object;
        if (iNetLink == null) {
            return;
        }
        List list = this.ncm.getCircuitSpans(iNetLink);
        List list2 = this.ncm.getEndpointsUseLink(iNetLink);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (INetCircuitSpan)iterator.next();
            iNetCircuit = object.getCircuit();
            if (OchncSpanDataSource.db.on) {
                db.println("adding new OchncSpanRow(" + iNetCircuit.getCircuitName() + ")");
            }
            if (!set.add(new OchncSpanRow(iNetCircuit, null)) && OchncSpanDataSource.db.on) {
                db.println("last add was a duplicate");
            }
            if (!iNetCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) continue;
            this.getLinkCircuits(set, iNetCircuit.getLotLink());
            this.getLinkCircuits(set, iNetCircuit.getReverseLotLink());
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (INetCircuitEnd)iterator.next();
            iNetCircuit = this.ncm.getCircuitFromCircuitEnd((INetCircuitEnd)object);
            if (OchncSpanDataSource.db.on) {
                db.println("adding new OchncSpanRow(" + iNetCircuit.getCircuitName() + ")");
            }
            if (set.add(new OchncSpanRow(iNetCircuit, null)) || !OchncSpanDataSource.db.on) continue;
            db.println("last add was a duplicate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllObjects() {
        HashSet hashSet;
        List list = this.spanRows;
        synchronized (list) {
            hashSet = new HashSet(this.spanRows);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObjectAtRow(int n) {
        List list = this.spanRows;
        synchronized (list) {
            if (n >= 0 && n < this.spanRows.size()) {
                return this.spanRows.get(n);
            }
            return null;
        }
    }

    public int getRowCount() {
        return this.spanRows.size();
    }

    public Class getRowObjectClass() {
        return OchncSpanRow.class;
    }

    public class OchncSdsDebug
    extends SDebug {
        OchncSdsDebug(String string) {
            super(string);
        }

        public final void dump() {
            Iterator iterator = OchncSpanDataSource.this.circuits.iterator();
            while (iterator.hasNext()) {
                INetCircuit iNetCircuit = (INetCircuit)iterator.next();
                if (iNetCircuit == null) continue;
                iNetCircuit.prettyPrint(db);
            }
        }
    }
}

