/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.model.circuits.SpanRow;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ui.CircuitOptDir;
import cerent.cms.ui.Wavelength;
import cerent.util.SDebug;

public class OchncSpanRow
implements Comparable {
    public INetCircuit circuit;
    public INetCircuitSpan span;
    private static SDebug db = new SDebug("OchncSpanRow");

    public OchncSpanRow(INetCircuit iNetCircuit, INetCircuitSpan iNetCircuitSpan) {
        this.init(iNetCircuit, iNetCircuitSpan);
    }

    protected void init(INetCircuit iNetCircuit, INetCircuitSpan iNetCircuitSpan) {
        if (iNetCircuit == null && iNetCircuitSpan != null) {
            throw new IllegalArgumentException("You can not have a span without a corresponding circuit!");
        }
        this.circuit = iNetCircuit;
        this.span = iNetCircuitSpan;
    }

    public OchncSpanRow duplicateOchncSpanRowWithoutSpan() {
        return new OchncSpanRow(this.getCircuit(), null);
    }

    public int compareTo(Object object) {
        OchncSpanRow ochncSpanRow = (OchncSpanRow)object;
        if (ochncSpanRow == null) {
            return -1;
        }
        int n = this.circuit.hashCode() < ochncSpanRow.circuit.hashCode() ? -1 : 1;
        return n;
    }

    public INetCircuit getCircuit() {
        return this.circuit;
    }

    public INetCircuitSpan getSpan() {
        return this.span;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SpanRow) {
            SpanRow spanRow = (SpanRow)object;
            if (this.circuit != null) {
                bl = this.circuit.equals(spanRow.getCircuit());
            }
            if (this.span != null) {
                bl = bl && this.span.equals(spanRow.getSpan());
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.circuit != null ? this.circuit.hashCode() : 0;
    }

    public String toString() {
        String string = "[Null circuit]";
        if (this.circuit != null) {
            string = this.circuit.getCircuitName();
        }
        return "Circuit " + string + " using Opt Ch: " + Wavelength.getWavelengthStringFromWavelength(this.circuit.getCircuitOptChannel()) + " Opt Dir: " + CircuitOptDir.getCktOptDirStringFromCktOptDir(this.circuit.getCircuitOptChannel());
    }

    public String prettyString() {
        return "Circuit=" + (this.circuit == null ? "null" : this.circuit.getCircuitName()) + ", span=" + this.span;
    }
}

