/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.model.circuits.SpanRowHoLoComparator;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoLoRange;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SpanRow
implements Comparable {
    protected static final HoLoComparator holoComp = SpanRowHoLoComparator.instance();
    protected IHoLoRange range;
    public INetCircuit circuit;
    public INetCircuitSpan span;
    private static SDebug db = new SDebug("SpanRow");

    public SpanRow(IHoLoNum iHoLoNum, IHoLoNum iHoLoNum2, INetCircuit iNetCircuit, INetCircuitSpan iNetCircuitSpan) {
        this.init(HoLoFactory.createRange(iHoLoNum, iHoLoNum2), iNetCircuit, iNetCircuitSpan);
    }

    public SpanRow(IHoNum iHoNum, ILoNum iLoNum, IHoNum iHoNum2, ILoNum iLoNum2, INetCircuit iNetCircuit, INetCircuitSpan iNetCircuitSpan) {
        IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
        IHoLoNum iHoLoNum2 = HoLoFactory.createHoLoNum(iHoNum2, iLoNum2);
        this.init(HoLoFactory.createRange(iHoLoNum, iHoLoNum2), iNetCircuit, iNetCircuitSpan);
    }

    public SpanRow(IHoNum iHoNum, IHoNum iHoNum2, INetCircuit iNetCircuit, INetCircuitSpan iNetCircuitSpan) {
        this(iHoNum, null, iHoNum2, null, iNetCircuit, iNetCircuitSpan);
    }

    public SpanRow(IHoLoRange iHoLoRange, INetCircuit iNetCircuit, INetCircuitSpan iNetCircuitSpan) {
        this.init(iHoLoRange, iNetCircuit, iNetCircuitSpan);
    }

    protected void init(IHoLoRange iHoLoRange, INetCircuit iNetCircuit, INetCircuitSpan iNetCircuitSpan) {
        this.range = HoLoFactory.createRange(iHoLoRange);
        if (iNetCircuit == null && iNetCircuitSpan != null) {
            throw new IllegalArgumentException("You can not have a span without a corresponding circuit!");
        }
        this.circuit = iNetCircuit;
        this.span = iNetCircuitSpan;
    }

    public SpanRow duplicateSpanRowWithoutSpan() {
        return new SpanRow(this.getFirstHo(), this.getFirstLo(), this.getLastHo(), this.getLastLo(), this.getCircuit(), null);
    }

    public int compareTo(Object object) {
        SpanRow spanRow = (SpanRow)object;
        int n = holoComp.compare(this.range, spanRow.range);
        if (n == 0 && this.circuit != spanRow.circuit) {
            n = this.circuit == null || spanRow.circuit == null ? (this.circuit == null ? -1 : 1) : (this.circuit.hashCode() < spanRow.circuit.hashCode() ? -1 : 1);
        }
        return n;
    }

    public IHoLoRange getRange() {
        return this.range;
    }

    public IHoLoNum getFirst() {
        return this.range == null ? null : this.range.getFirst();
    }

    public IHoLoNum getLast() {
        return this.range == null ? null : this.range.getLast();
    }

    public IHoNum getFirstHo() {
        IHoLoNum iHoLoNum = this.getFirst();
        return iHoLoNum == null ? null : iHoLoNum.getHoNum();
    }

    public IHoNum getLastHo() {
        IHoLoNum iHoLoNum = this.getLast();
        return iHoLoNum == null ? null : iHoLoNum.getHoNum();
    }

    public ILoNum getFirstLo() {
        IHoLoNum iHoLoNum = this.getFirst();
        return iHoLoNum == null ? null : iHoLoNum.getLoNum();
    }

    public ILoNum getLastLo() {
        IHoLoNum iHoLoNum = this.getLast();
        return iHoLoNum == null ? null : iHoLoNum.getLoNum();
    }

    public INetCircuit getCircuit() {
        return this.circuit;
    }

    public INetCircuitSpan getSpan() {
        return this.span;
    }

    public boolean doesContain(IHoNum iHoNum) {
        return holoComp.compare(iHoNum, this.getFirst()) >= 0 && holoComp.compare(iHoNum, this.getLast()) < 0;
    }

    public boolean doesStraddle(IHoNum iHoNum) {
        return holoComp.compare(this.getFirst(), iHoNum) < 0 && holoComp.compare(iHoNum, this.getLast()) < 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SpanRow) {
            SpanRow spanRow = (SpanRow)object;
            if (this.circuit != null) {
                bl = this.range.equals(spanRow.getRange()) && this.circuit.equals(spanRow.getCircuit());
            } else {
                bl = this.range.equals(spanRow.getRange());
                if (spanRow.getCircuit() != null) {
                    bl = false;
                }
            }
            if (this.span != null) {
                bl = bl && this.span.equals(spanRow.getSpan());
            } else if (spanRow.getSpan() != null) {
                bl = false;
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.range.hashCode();
        if (this.circuit != null) {
            n = 37 * n + this.circuit.hashCode();
        }
        if (this.span != null) {
            n = 37 * n + this.span.hashCode();
        }
        return n;
    }

    public Set findUnusedSpanRow(IHoLoNum iHoLoNum) {
        IHoNum iHoNum = this.getFirstHo();
        ILoNum iLoNum = this.getFirstLo();
        return SpanRow.findUnusedSpanRow(iHoNum, iLoNum, iHoLoNum);
    }

    public static Set findUnusedSpanRow(IHoNum iHoNum, ILoNum iLoNum, IHoLoNum iHoLoNum) {
        HashSet<SpanRow> hashSet = new HashSet<SpanRow>();
        int n = -1;
        int n2 = -1;
        IHoLoRange iHoLoRange = null;
        if (iHoLoNum == null) {
            return hashSet;
        }
        IHoNum iHoNum2 = iHoLoNum.getHoNum();
        ILoNum iLoNum2 = iHoLoNum.getLoNum();
        boolean bl = holoComp.isEqual(iHoNum2, iHoNum);
        if (!bl && (iHoLoRange = HoLoFactory.createGap(iHoNum2, iHoNum, holoComp)) != null) {
            hashSet.add(new SpanRow(iHoLoRange, null, null));
        }
        if (!bl) {
            List list = HoLoFactory.createGaps(null, iLoNum, holoComp);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                iHoLoRange = (IHoLoRange)iterator.next();
                iHoLoRange.getFirst().setHoNum(iHoNum);
                iHoLoRange.getLast().setHoNum(iHoNum);
                hashSet.add(new SpanRow(iHoLoRange, null, null));
            }
            iHoLoNum.setLoNum(iLoNum);
            list = HoLoFactory.createGaps(iLoNum2, null, holoComp);
            iterator = list.iterator();
            while (iterator.hasNext()) {
                iHoLoRange = (IHoLoRange)iterator.next();
                iHoLoRange.getFirst().setHoNum(iHoNum2);
                iHoLoRange.getLast().setHoNum(iHoNum2);
                hashSet.add(new SpanRow(iHoLoRange, null, null));
            }
        } else {
            List list = HoLoFactory.createGaps(iLoNum2, iLoNum, holoComp);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                iHoLoRange = (IHoLoRange)iterator.next();
                iHoLoRange.getFirst().setHoNum(iHoNum);
                iHoLoRange.getLast().setHoNum(iHoNum);
                hashSet.add(new SpanRow(iHoLoRange, null, null));
            }
        }
        return hashSet;
    }

    public String toString() {
        String string = "[Null circuit]";
        if (this.circuit != null) {
            string = this.circuit.getCircuitName();
        }
        return "Circuit '" + string + "' using HO " + this.getLastHo().getHoNum() + " through " + this.getFirstHo().getHoNum();
    }

    public String prettyString() {
        return "range=" + (this.range == null ? "null" : this.range.prettyString()) + ", circuit=" + (this.circuit == null ? "null" : this.circuit.getCircuitName()) + ", span=" + this.span;
    }
}

