/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.event;

import cerent.cms.model.CmsObservable;
import cerent.cms.model.event.EventFilter;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.IEventStore;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.UObservable;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observer;

public abstract class AbstractEventStore
extends AbstractRowDataSource
implements Observer,
IEventStore {
    protected static final String PROP_CTC = "ctc";
    protected String name;
    protected CmsObservable storeObservable;
    protected Preferences prefs;
    protected SDebug db;
    protected ArrayList arrayList = new ArrayList();
    protected ArrayList filteredArrayList = new ArrayList();
    protected EventFilter eventFilter = new EventFilter("AbstractEventStore", this, 2);
    protected HashMap children = null;

    public void addObserver(Observer observer) {
        this.storeObservable.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.storeObservable.deleteObserver(observer);
    }

    public UObservable getStoreObservable() {
        return this.storeObservable;
    }

    public String getName() {
        return this.name;
    }

    protected SDebug getDebug() {
        return this.db;
    }

    public synchronized AbstractEventStore getChild(Object object) {
        if (this.children != null) {
            return (AbstractEventStore)this.children.get(object);
        }
        return null;
    }

    protected synchronized AbstractEventStore createChild(Object object, String string) {
        if (this.db.on()) {
            this.db.println(this.name + " calling createChild(): " + string);
        }
        if (this.children == null) {
            this.children = new HashMap();
        }
        AbstractEventStore abstractEventStore = this.createInstance(string);
        this.children.put(object, abstractEventStore);
        return abstractEventStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChild(Object object) {
        if (this.children != null) {
            AbstractEventStore abstractEventStore = this;
            synchronized (abstractEventStore) {
                AbstractEventStore abstractEventStore2 = (AbstractEventStore)this.children.remove(object);
                if (abstractEventStore2 != null) {
                    abstractEventStore2.destroy();
                }
            }
        }
    }

    protected synchronized void removeChildren() {
        if (this.children != null) {
            if (this.db.on()) {
                this.db.println(this.name + " calling removeChildren()...");
            }
            Iterator iterator = this.children.values().iterator();
            while (iterator.hasNext()) {
                AbstractEventStore abstractEventStore = (AbstractEventStore)iterator.next();
                if (abstractEventStore == null) continue;
                abstractEventStore.destroy();
            }
            this.children.clear();
            this.children = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventInfo storeEvent(EventInfo eventInfo) {
        AbstractEventStore abstractEventStore = this;
        synchronized (abstractEventStore) {
            if (this.eventFilter.isEnabled() && this.eventFilter.doesMatch(eventInfo)) {
                this.filteredArrayList.add(eventInfo);
            }
            this.arrayList.add(eventInfo);
        }
        this.fireBulkRowAdded(0, eventInfo);
        return eventInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulkStoreEvent(ArrayList arrayList) {
        AbstractEventStore abstractEventStore = this;
        synchronized (abstractEventStore) {
            if (this.eventFilter.isEnabled()) {
                this.bulkStoreFilteredEvent(arrayList);
            }
            this.arrayList.addAll(arrayList);
        }
        this.fireBulkDataSourceChanged();
    }

    private void bulkStoreFilteredEvent(ArrayList arrayList) {
        EventInfo eventInfo = null;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            eventInfo = (EventInfo)arrayList.get(i);
            if (!this.eventFilter.doesMatch(eventInfo)) continue;
            this.filteredArrayList.add(eventInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushFilteredData() {
        AbstractEventStore abstractEventStore = this;
        synchronized (abstractEventStore) {
            this.filteredArrayList.clear();
            this.bulkStoreFilteredEvent(this.arrayList);
        }
        this.fireBulkDataSourceChanged();
        this.updateView();
    }

    public void setFilterActive(boolean bl) {
        this.fireBulkDataSourceChanged();
        this.updateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushData() {
        AbstractEventStore abstractEventStore = this;
        synchronized (abstractEventStore) {
            this.filteredArrayList.clear();
        }
        this.fireBulkDataSourceChanged();
        this.updateView();
    }

    protected boolean filterEvent(EventInfo eventInfo) {
        boolean bl = false;
        if (this.eventFilter.isEnabled() && this.eventFilter.doesMatch(eventInfo)) {
            this.filteredArrayList.add(eventInfo);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateView() {
        AbstractEventStore abstractEventStore = this;
        synchronized (abstractEventStore) {
            if (this.children != null) {
                Iterator iterator = this.children.values().iterator();
                while (iterator.hasNext()) {
                    AbstractEventStore abstractEventStore2 = (AbstractEventStore)iterator.next();
                    abstractEventStore2.updateView();
                }
            }
        }
        this.localUpdateView();
        this.fireBulkUpdateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushStore() {
        AbstractEventStore abstractEventStore = this;
        synchronized (abstractEventStore) {
            this.arrayList.clear();
        }
        this.localFlushStore();
        abstractEventStore = this;
        synchronized (abstractEventStore) {
            if (this.children != null) {
                Iterator iterator = this.children.values().iterator();
                while (iterator.hasNext()) {
                    AbstractEventStore abstractEventStore2 = (AbstractEventStore)iterator.next();
                    abstractEventStore2.flushStore();
                }
            }
        }
        this.flushFilteredData();
        this.fireDataSourceChanged();
    }

    public EventFilter getEventFilter() {
        return this.eventFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.db.on()) {
            this.db.println(this.name + " calling destroy: sz=" + this.getRowCount() + ", child=" + (this.children == null ? "No" : "Yes") + ", obs cnt=" + this.storeObservable.countObservers());
        }
        AbstractEventStore abstractEventStore = this;
        synchronized (abstractEventStore) {
            this.filteredArrayList.clear();
            this.arrayList.clear();
        }
        this.localFlushStore();
        this.resetRowDataSourceListenerList();
        abstractEventStore = this;
        synchronized (abstractEventStore) {
            if (this.children != null) {
                Iterator iterator = this.children.values().iterator();
                while (iterator.hasNext()) {
                    AbstractEventStore abstractEventStore2 = (AbstractEventStore)iterator.next();
                    abstractEventStore2.destroy();
                }
            }
        }
        this.storeObservable.deleteObservers();
        this.eventFilter.dispose();
        this.db.dispose();
    }

    public Object getObjectAtRow(int n) {
        try {
            if (this.eventFilter.isEnabled() && this.eventFilter.isActive()) {
                return this.filteredArrayList.get(this.translateRowIndex(n));
            }
            return this.arrayList.get(this.translateRowIndex(n));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getRowCount() {
        if (this.eventFilter.isEnabled() && this.eventFilter.isActive()) {
            return this.filteredArrayList.size();
        }
        return this.arrayList.size();
    }

    public Collection getAllObjects() {
        if (this.eventFilter.isEnabled() && this.eventFilter.isActive()) {
            return this.cloneList(this.filteredArrayList);
        }
        return this.cloneList(this.arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection cloneList(ArrayList arrayList) {
        ArrayList arrayList2 = arrayList;
        synchronized (arrayList2) {
            return (Collection)arrayList.clone();
        }
    }

    public Class getRowObjectClass() {
        return EventInfo.class;
    }

    protected void localUpdateView() {
    }

    protected void localFlushStore() {
    }

    protected AbstractEventStore createInstance(String string) {
        return null;
    }

    protected int translateRowIndex(int n) {
        if (this.eventFilter.isEnabled() && this.eventFilter.isActive()) {
            return this.filteredArrayList.size() - n - 1;
        }
        return this.arrayList.size() - n - 1;
    }

    public class EsDebug
    extends SDebug {
        public EsDebug(KDebug kDebug, String string) {
            super(kDebug, string);
        }

        public final void dump() {
            this.println("-- DUMPING EVENT STORE: " + AbstractEventStore.this.name);
            for (int i = 0; i < AbstractEventStore.this.getRowCount(); ++i) {
                if (AbstractEventStore.this.eventFilter.isEnabled() && AbstractEventStore.this.eventFilter.isActive()) {
                    this.println(AbstractEventStore.this.filteredArrayList.get(i).toString());
                    continue;
                }
                this.println(AbstractEventStore.this.arrayList.get(i).toString());
            }
            this.println("-- DUMPING EVENT STORE: " + AbstractEventStore.this.name + ":= end =:");
        }
    }
}

