/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ftg;

import cerent.cms.model.CircuitSize;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.ftg.OldEntityModelAdapter;
import cerent.cms.model.ftg.OldNodeModelDelegateAdapter;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import java.util.List;

public class OldModuleModelAdapter
extends OldEntityModelAdapter
implements IModuleModel {
    public OldModuleModelAdapter(IModuleModel iModuleModel, OldNodeModelDelegateAdapter oldNodeModelDelegateAdapter) {
        super((IEntityModel)iModuleModel, oldNodeModelDelegateAdapter);
    }

    public IModuleModel getOldModel() {
        return (IModuleModel)this.getOldEntityModel();
    }

    public void setPortGroupState(short s, boolean bl) throws UnsupportedOperation, ProvisionError {
        this.getOldModel().setPortGroupState(s, bl);
    }

    public boolean isPortGroupStateClosed(short s) throws UnsupportedOperation, ProvisionError {
        return this.getOldModel().isPortGroupStateClosed(s);
    }

    protected boolean isElectricalCard() {
        boolean bl = false;
        int n = this.getEqType();
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 83: {
                bl = true;
            }
        }
        return bl;
    }

    protected boolean doIncrementInInverseHierarchyOrder(int n) {
        return this.isElectricalCard() && (n == 5 || n == 6);
    }

    protected boolean doIncrementInNormalHierarchyOrder(int n) {
        return this.isElectricalCard() && n == 7;
    }

    protected int getNumPorts() {
        return this.getChildren().size();
    }

    protected void checkPortNumber(int n) {
        if (n <= 0 || n > this.getNumPorts()) {
            throw new IllegalArgumentException("invalid port #");
        }
    }

    public ILoNum getLoNumForPort(int n, int n2) {
        if (!this.isElectricalCard()) {
            return null;
        }
        this.checkPortNumber(n);
        ILoNum iLoNum = null;
        int n3 = this.getNodeModel().getFramingType();
        int n4 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
        int n5 = n - 1;
        IHoNum iHoNum = HoLoFactory.createFirstHoNum(n3);
        ILoNum iLoNum2 = HoLoFactory.createFirstLoNum(n3, n4);
        IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum2);
        iLoNum = HoLoFactory.addGroupOffset(iHoLoNum, n5).getLoNum();
        return iLoNum;
    }

    public IHoNum getHoNumForPort(int n, int n2) {
        if (!this.isElectricalCard()) {
            return null;
        }
        this.checkPortNumber(n);
        IHoNum iHoNum = null;
        int n3 = this.getNodeModel().getFramingType();
        int n4 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
        int n5 = n - 1;
        IHoNum iHoNum2 = HoLoFactory.createFirstHoNum(n3);
        ILoNum iLoNum = HoLoFactory.createFirstLoNum(n3, n4);
        IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum2, iLoNum);
        iHoLoNum = HoLoFactory.addGroupOffset(iHoLoNum, n5);
        iHoNum = iHoLoNum.getHoNum();
        return iHoNum;
    }

    public int getPortForPath(ILoNum iLoNum, IHoNum iHoNum) {
        int n;
        if (!this.isElectricalCard()) {
            return 0;
        }
        int n2 = this.getNumPorts();
        int n3 = this.getNodeModel().getFramingType();
        int n4 = n = iLoNum != null ? iLoNum.getLoPathWidth() : -1;
        if (iLoNum == null) {
            if (HoLoFactory.createFirstHoNum(n3).equals(iHoNum)) {
                return 1;
            }
            return 0;
        }
        if (iHoNum == null && n == 7) {
            return 0;
        }
        int n5 = 0;
        for (int i = 1; i <= n2; ++i) {
            IHoNum iHoNum2;
            ILoNum iLoNum2 = this.getLoNumForPort(i, n);
            if (iLoNum2 == null || !iLoNum2.equals(iLoNum) || iHoNum != null && ((iHoNum2 = this.getHoNumForPort(i, n)) == null || !iHoNum2.equals(iHoNum))) continue;
            n5 = i;
            break;
        }
        return n5;
    }

    public boolean isValidPGElectricalCard() {
        return this.getOldModel().isValidPGElectricalCard();
    }

    public boolean isOpticsCard() {
        return false;
    }

    public List getPortsInGroup(IPortModel iPortModel, int n) {
        throw new FeatureNotSupported("getPortsInGroup is not supported");
    }

    public boolean areInterfacesInited() {
        throw new FeatureNotSupported("areInterfacesInited()");
    }

    public boolean isIndustryMapped(IHoNum iHoNum) {
        return false;
    }

    public boolean isPreProvisioned() {
        return this.getOldModel().isPreProvisioned();
    }

    public boolean isRPRMode() {
        throw new FeatureNotSupported("inRPRMode()");
    }

    public boolean hasPPC() {
        throw new FeatureNotSupported("hasPPC");
    }

    public IPortModel getPortModelForPath(IEntityModel iEntityModel, ILoNum iLoNum, IHoNum iHoNum) {
        throw new FeatureNotSupported("getPortModelForPath()");
    }
}

