/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ohcircuits;

import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.circuits.CircuitUpgradeListener;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OhCircuitManager;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class OhCircuitDataSource
extends AbstractRowDataSource
implements Observer,
ActionListener {
    private OhCircuitManager ncm = OhCircuitManager.instance();
    private IModel uiModel = null;
    private IModel newScope = null;
    private List circuits = new ArrayList(0);
    private Set displayedCircuits = new HashSet(0);
    private Set allCircuits = new HashSet();
    private HashSet changedCircuits = new HashSet();
    private Timer updateTimer = null;
    private boolean refreshAllCircuits;
    private HashSet upgradableCircuits = new HashSet();
    private static SDebug db = new SDebug("OhCircuitDataSource");
    private static final int UPDATE_FREQUENCY = 2000;
    private EventListenerList circuitUpgradeListenerList = new EventListenerList();

    public OhCircuitDataSource(IModel iModel) {
        if (iModel instanceof NetworkModel) {
            iModel = null;
        }
        this.newScope = iModel;
        this.refreshAllCircuits = true;
        this.updateTimer = new Timer(2000, this);
        this.updateTimer.setCoalesce(true);
        this.updateTimer.setInitialDelay(0);
        this.updateTimer.start();
        this.ncm.addObserver(this);
    }

    public synchronized void dispose() {
        if (this.updateTimer != null) {
            this.updateTimer.stop();
        }
        this.ncm.deleteObserver(this);
        if (this.isEthernetCard(this.uiModel)) {
            this.uiModel.deleteObserver((Observer)this);
        }
        Iterator iterator = this.allCircuits.iterator();
        while (iterator.hasNext()) {
            ((OhCircuit)iterator.next()).deleteObserver(this);
        }
    }

    private Collection getCircuitsWithinScope() {
        Collection collection;
        if (this.uiModel instanceof INodeModel) {
            collection = this.ncm.getCircuits((INodeModel)this.uiModel);
        } else if (this.uiModel instanceof IModuleModel) {
            IModuleModel iModuleModel = (IModuleModel)this.uiModel;
            collection = new HashSet(this.ncm.getCircuits(iModuleModel.getConnectionsList()));
        } else {
            collection = this.ncm.getCircuits();
        }
        if (db.on()) {
            if (this.uiModel == null) {
                db.fine("Circuits in scope NET=" + collection.size());
            } else {
                db.fine("Circuits in scope " + this.uiModel.getClass().getName() + "=" + collection.size());
            }
        }
        return collection;
    }

    private void updateAllCircuits() {
        OhCircuit ohCircuit;
        if (db.on()) {
            db.fine("updateAllCircuits started");
        }
        boolean bl = false;
        Collection collection = this.getCircuitsWithinScope();
        HashSet hashSet = new HashSet(this.ncm.getCircuits());
        HashSet hashSet2 = collection instanceof HashSet ? (HashSet)collection : new HashSet(collection);
        Iterator iterator = this.allCircuits.iterator();
        while (iterator.hasNext()) {
            ohCircuit = (OhCircuit)iterator.next();
            if (hashSet.contains(ohCircuit)) continue;
            ohCircuit.deleteObserver(this);
            if (!this.displayedCircuits.contains(ohCircuit)) continue;
            this.upgradableCircuits.remove(ohCircuit);
            if (db.on()) {
                db.fine("delete displayed ckt " + ohCircuit.getCircuitName());
            }
            bl = true;
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ohCircuit = (OhCircuit)iterator.next();
            if (!this.allCircuits.contains(ohCircuit)) {
                ohCircuit.addObserver(this);
                if (hashSet2.contains(ohCircuit)) {
                    if (ohCircuit.getState() == 5) {
                        this.upgradableCircuits.add(ohCircuit);
                    }
                    if (db.on()) {
                        db.fine("add new displayed ckt " + ohCircuit.getCircuitName());
                    }
                    bl = true;
                    continue;
                }
                if (!db.on()) continue;
                db.fine("new non displayed ckt " + ohCircuit.getCircuitName());
                continue;
            }
            if ((!this.displayedCircuits.contains(ohCircuit) || hashSet2.contains(ohCircuit)) && (this.displayedCircuits.contains(ohCircuit) || !hashSet2.contains(ohCircuit))) continue;
            if (db.on()) {
                db.fine("ckt " + ohCircuit.getCircuitName() + " changed scope");
            }
            bl = true;
        }
        if (bl) {
            this.circuits = new ArrayList(hashSet2);
            this.displayedCircuits = hashSet2;
            this.changedCircuits.clear();
            this.fireDataSourceChanged();
        } else if (!this.changedCircuits.isEmpty()) {
            this.updateChangedCircuits();
        }
        this.refreshAllCircuits = false;
        this.allCircuits = hashSet;
        this.fireCircuitUpgradeChanged();
        if (db.on()) {
            db.fine("updateAllCircuits done");
        }
    }

    public synchronized void setCircuitScope(IModel iModel) {
        if (iModel instanceof NetworkModel) {
            iModel = null;
        }
        if (this.uiModel != iModel) {
            this.newScope = iModel;
            this.updateTimer.restart();
        }
    }

    public synchronized void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.updateTimer) {
            if (this.newScope != this.uiModel) {
                if (this.isEthernetCard(this.uiModel)) {
                    this.uiModel.deleteObserver((Observer)this);
                } else if (this.isEthernetCard(this.newScope)) {
                    this.newScope.addObserver((Observer)this);
                }
                this.uiModel = this.newScope;
                this.refreshAllCircuits = true;
            }
            if (this.refreshAllCircuits) {
                this.updateAllCircuits();
            } else if (!this.changedCircuits.isEmpty()) {
                this.updateChangedCircuits();
            }
        }
    }

    private boolean isEthernetCard(IModel iModel) {
        if (iModel instanceof IModuleModel) {
            int n = ((IModuleModel)iModel).getEqType();
            return n == 15 || n == 14;
        }
        return false;
    }

    public synchronized void update(Observable observable, Object object) {
        if (this.refreshAllCircuits) {
            if (db.on()) {
                db.info("update from " + observable + ": refresh all already requested");
            }
            return;
        }
        if (observable instanceof OhCircuit) {
            OhCircuit ohCircuit = (OhCircuit)((Object)observable);
            if (db.on()) {
                db.info("update ckt=" + ohCircuit.getCircuitName());
            }
            if (ohCircuit.isCircuitRefValid()) {
                if (this.displayedCircuits.contains(ohCircuit)) {
                    if (db.on()) {
                        db.info("adding ckt to changed list");
                    }
                    this.changedCircuits.add(ohCircuit);
                } else {
                    if (db.on()) {
                        db.info("ckt not displayed: refresh all requested");
                    }
                    this.refreshAllCircuits = true;
                }
            } else {
                if (db.on()) {
                    db.info("ckt deleted: refresh all requested");
                }
                this.refreshAllCircuits = true;
            }
        } else {
            this.refreshAllCircuits = true;
            if (db.on()) {
                db.info("update: refresh all requested:ncm/ethercard");
            }
        }
    }

    private void updateChangedCircuits() {
        if (db.on()) {
            db.fine("updateChangedCircuits started");
        }
        int n = this.changedCircuits.size();
        for (int i = 0; i < this.circuits.size() && n > 0; ++i) {
            OhCircuit ohCircuit = (OhCircuit)this.circuits.get(i);
            if (!this.changedCircuits.contains(ohCircuit)) continue;
            --n;
            this.fireBulkRowUpdated(i, ohCircuit, ohCircuit);
            if (ohCircuit.getState() == 5) {
                this.upgradableCircuits.add(ohCircuit);
            } else {
                this.upgradableCircuits.remove(ohCircuit);
            }
            if (!db.on()) continue;
            db.fine("updateChangedCircuits: update row  " + i);
        }
        this.changedCircuits.clear();
        this.fireBulkUpdateView();
        this.fireCircuitUpgradeChanged();
        if (db.on()) {
            db.finer("updateChangedCircuits done");
        }
    }

    public Collection getAllObjects() {
        return this.circuits;
    }

    public Object getObjectAtRow(int n) {
        try {
            return this.circuits.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public int getRowCount() {
        return this.circuits.size();
    }

    public void addCircuitUpgradeListener(CircuitUpgradeListener circuitUpgradeListener) {
        if (db.on()) {
            db.finer("addCircuitUpgradeListener " + circuitUpgradeListener);
        }
        this.circuitUpgradeListenerList.add(CircuitUpgradeListener.class, circuitUpgradeListener);
        circuitUpgradeListener.setCircuitsUpgradable(!this.upgradableCircuits.isEmpty());
    }

    public void removeCircuitUpgradeListener(CircuitUpgradeListener circuitUpgradeListener) {
        if (db.on()) {
            db.finer("removeCircuitUpgradeListener " + circuitUpgradeListener);
        }
        this.circuitUpgradeListenerList.remove(CircuitUpgradeListener.class, circuitUpgradeListener);
    }

    private void fireCircuitUpgradeChanged() {
        if (db.on()) {
            db.fine("fireCircuitUpgradeChanged: upgrade ckts=" + !this.upgradableCircuits.isEmpty());
        }
        Object[] objectArray = this.circuitUpgradeListenerList.getListenerList();
        boolean bl = !this.upgradableCircuits.isEmpty();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$cerent$cms$model$circuits$CircuitUpgradeListener == null ? OhCircuitDataSource.class$("cerent.cms.model.circuits.CircuitUpgradeListener") : class$cerent$cms$model$circuits$CircuitUpgradeListener)) continue;
            ((CircuitUpgradeListener)objectArray[i + 1]).setCircuitsUpgradable(bl);
        }
    }

    public void setEnabled(boolean bl) {
        if (db.on()) {
            db.finer("Enabled=" + bl);
        }
        if (bl) {
            this.updateTimer.restart();
        } else {
            this.updateTimer.stop();
        }
    }
}

