/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ucp;

import cerent.cms.model.CircuitIdStillInUse;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidParams;
import cerent.cms.model.LabelInUse;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetCmsCommFailException;
import cerent.cms.model.NoMoreCircuitOrigins;
import cerent.cms.model.NoMoreCircuitTerminations;
import cerent.cms.model.NoSuchCircuitOrigin;
import cerent.cms.model.NoSuchCircuitTermination;
import cerent.cms.model.NodeModel;
import cerent.cms.model.ucp.IEgressLabel;
import cerent.cms.model.ucp.ILabel;
import cerent.cms.model.ucp.ITnaAddr;
import cerent.cms.model.ucp.IUcpCircuitOriginModel;
import cerent.cms.model.ucp.IUcpCircuitTerminationModel;
import cerent.cms.model.ucp.IUcpCircuits;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;

public class NetUcpCircuits
extends Model
implements IUcpCircuits {
    private static final SDebug ucpCircuitsDb = new SDebug("NetUcpCircuits");
    IUcpCircuits delegate;
    NodeModel nodeModel = null;

    public NetUcpCircuits(NodeModel nodeModel) {
        super(ucpCircuitsDb);
        this.nodeModel = nodeModel;
    }

    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    public IUcpCircuitOriginModel createCircuitOrigin(ICircuitId iCircuitId, int n, ITnaAddr iTnaAddr, int n2, boolean bl, short s, short s2, ILabel iLabel, IEgressLabel iEgressLabel, short s3, int n3) throws LabelInUse, CircuitIdStillInUse, NoMoreCircuitOrigins, InvalidParams {
        return this.getDelegate().createCircuitOrigin(iCircuitId, n, iTnaAddr, n2, bl, s, s2, iLabel, iEgressLabel, s3, n3);
    }

    public IUcpCircuitOriginModel getCircuitOriginByIndex(int n) throws NoSuchCircuitOrigin {
        return this.getDelegate().getCircuitOriginByIndex(n);
    }

    public IUcpCircuitOriginModel[] getCircuitOriginList() {
        return this.delegate != null && this.nodeModel.provides(Feature.UCP_UNIC) ? this.delegate.getCircuitOriginList() : new IUcpCircuitOriginModel[]{};
    }

    public IUcpCircuitTerminationModel createCircuitTermination(ICircuitId iCircuitId, int n, ITnaAddr iTnaAddr, int n2, ILabel iLabel, int n3) throws LabelInUse, CircuitIdStillInUse, NoMoreCircuitTerminations, InvalidParams {
        return this.getDelegate().createCircuitTermination(iCircuitId, n, iTnaAddr, n2, iLabel, n3);
    }

    public IUcpCircuitTerminationModel getCircuitTerminationByIndex(int n) throws NoSuchCircuitTermination {
        return this.getDelegate().getCircuitTerminationByIndex(n);
    }

    public IUcpCircuitTerminationModel[] getCircuitTerminationList() {
        return this.delegate != null && this.nodeModel.provides(Feature.UCP_UNIC) ? this.delegate.getCircuitTerminationList() : new IUcpCircuitTerminationModel[]{};
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy");
        }
        super.destroy();
    }

    private void destroyDelegate() {
        if (this.db.on()) {
            this.db.println("destroyDelegate");
        }
        this.delegate.deleteObserver((Observer)this);
        this.delegate = null;
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose");
        }
        if (this.delegate != null) {
            this.destroyDelegate();
        }
        super.dispose();
    }

    public void setDelegate(IUcpCircuits iUcpCircuits) {
        if (this.db.on()) {
            this.db.println("setDelegate");
        }
        if (this.delegate != null) {
            this.destroyDelegate();
        }
        this.delegate = iUcpCircuits;
        this.delegate.addObserver((Observer)this);
        this.setChanged();
        this.notifyObservers(ModelUpdateType.ADDED);
    }

    public void update(Observable observable, Object object) {
        if (observable == this.delegate) {
            if (this.db.on) {
                this.db.println("Sending update Message " + object);
            }
            this.setChanged();
            this.notifyObservers(object);
        } else {
            IUcpCircuits iUcpCircuits;
            if (this.db.on()) {
                this.db.println("update from " + observable.getClass().toString());
            }
            if ((iUcpCircuits = this.delegate) != null) {
                iUcpCircuits.update(observable, object);
            }
        }
    }

    private IUcpCircuits getDelegate() {
        IUcpCircuits iUcpCircuits = this.delegate;
        if (iUcpCircuits == null) {
            throw new NetCmsCommFailException("No delegate for NetUcpCircuits");
        }
        if (!this.nodeModel.provides(Feature.UCP_UNIC)) {
            throw new NetCmsCommFailException("Delegate does not support UCP_UNIC");
        }
        return iUcpCircuits;
    }
}

