/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.CmsObservable;
import cerent.cms.ncp.Connection;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SelectorConnection;
import cerent.util.SDebug;
import java.util.Iterator;

public class BridgeConnection
extends Connection {
    private static final SDebug db = new SDebug("BridgeConnection");

    public BridgeConnection(String string) {
        super(string);
    }

    public boolean addInput(Object object) {
        if (this.inPuts.size() != 0) {
            if (this.dbgOn()) {
                db.println("ERROR! one input already present");
            }
            return false;
        }
        if (!this.checkEndPoint(object)) {
            return false;
        }
        this.inPuts.add(object);
        return true;
    }

    public boolean isBridge() {
        return true;
    }

    protected boolean isUpsrHead3Profile() {
        NetCircuitNode netCircuitNode = this.getNode();
        return netCircuitNode != null && netCircuitNode.isBlsrDriPrimary() && netCircuitNode.connections.size() == 1 && this.inPuts.size() + this.outPuts.size() == 4;
    }

    protected boolean isUpsrBlsrIdriPrimaryInternalBridge() {
        Iterator iterator = this.getOutSpans().iterator();
        while (iterator.hasNext()) {
            CmsObservable cmsObservable;
            Connection connection;
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (!netCircuitSpan.isInternalSpan() || (connection = netCircuitSpan.getPeerConnection(this)) == null || !connection.isSelector()) continue;
            SelectorConnection selectorConnection = (SelectorConnection)connection;
            boolean bl = false;
            if (selectorConnection.getSelectorHead() != null) {
                cmsObservable = selectorConnection.getSelectorHead().getNode();
                if (cmsObservable != null) {
                    bl = ((NetCircuitNode)cmsObservable).isBlsrDriHandoff();
                }
            } else if (this.inPuts.size() == 1 && this.inPuts.get(0) instanceof NetCircuitSpan) {
                cmsObservable = (NetCircuitSpan)this.inPuts.get(0);
                bl = ((NetCircuitSpan)cmsObservable).getLink().inBLSR();
            }
            cmsObservable = this.getNode();
            return cmsObservable != null && ((NetCircuitNode)cmsObservable).isBlsrDriPrimary() && ((NetCircuitNode)cmsObservable).totalSpans() == 4 && !bl;
        }
        return false;
    }

    protected boolean isOpenEndedOnewayBlsrDriPrimaryDrop() {
        if (this.outPuts.size() == 2 && (this.outPuts.get(0) instanceof NetCircuitEnd || this.outPuts.get(1) instanceof NetCircuitEnd)) {
            NetCircuitNode netCircuitNode = this.getNode();
            if (netCircuitNode == null || netCircuitNode.connections.size() != 1) {
                return false;
            }
            return netCircuitNode.isBlsrDriPrimary();
        }
        return false;
    }

    protected boolean hasValidUpsrDriHandoffInterconnect(Connection connection) {
        return false;
    }
}

