/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.CircuitMergeManager;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.IVlanModel;
import cerent.cms.ncp.CircuitMergeError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitMergeOperator;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.vlan.VlanInfoComparator;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.TreeSet;

public class CircuitMergeSplicer
extends NetCircuitSplicer {
    private static SDebug db = new SDebug("CircuitMergeSplicer");
    private static CircuitMergeManager mergeManager = CircuitMergeManager.instance();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean spliceAllowed(INetCircuit iNetCircuit, INetCircuit iNetCircuit2) {
        if (CircuitMergeSplicer.dbgOn()) {
            CircuitMergeSplicer.debug("spliceAllowed - circuit <" + iNetCircuit.getCircuitName() + "> to circuit <" + iNetCircuit2.getCircuitName() + ">");
        }
        if (!CircuitMergeManager.isCktInMerge(iNetCircuit)) return false;
        if (!CircuitMergeManager.isCktInMerge(iNetCircuit2)) return false;
        return true;
    }

    protected boolean spliceAllowed(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        if (CircuitMergeSplicer.dbgOn()) {
            CircuitMergeSplicer.debug("spliceAllowed - node to node");
        }
        if (netCircuitNode.isUpsrOverOnePluOne() || netCircuitNode2.isUpsrOverOnePluOne()) {
            if (CircuitMergeSplicer.dbgOn()) {
                CircuitMergeSplicer.debug("Circuit Merge denied on 1s/2d or 2s/1d UPSRover1+1 connections");
            }
            return false;
        }
        try {
            this.getSpliceDestinationCircuit(netCircuitNode, netCircuitNode2);
            return true;
        }
        catch (CircuitMergeError circuitMergeError) {
            if (CircuitMergeSplicer.dbgOn()) {
                CircuitMergeSplicer.debug(circuitMergeError.getMessage());
            }
            return false;
        }
    }

    private INetCircuit getSpliceDestinationCircuit(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) throws CircuitMergeError {
        NetCircuit netCircuit;
        NetCircuit netCircuit2 = (NetCircuit)netCircuitNode.getCircuit();
        if (netCircuit2 == (netCircuit = (NetCircuit)netCircuitNode2.getCircuit())) {
            return netCircuit2;
        }
        INetCircuit iNetCircuit = null;
        if (!this.spliceAllowed(netCircuit2, netCircuit)) {
            throw new CircuitMergeError("Two circuits could not be spliced.");
        }
        iNetCircuit = CircuitMergeSplicer.checkOchnc(netCircuit2, netCircuit, iNetCircuit);
        iNetCircuit = CircuitMergeSplicer.checkVlan(netCircuit2, netCircuit, iNetCircuit);
        iNetCircuit = CircuitMergeSplicer.checkSla(netCircuit2, netCircuit, iNetCircuit);
        iNetCircuit = CircuitMergeSplicer.checkMonitor(netCircuit2, netCircuit, iNetCircuit);
        iNetCircuit = this.checkLoTunnelNode(netCircuitNode, netCircuitNode2, netCircuit2, netCircuit, iNetCircuit);
        iNetCircuit = this.checkEtherStitchNode(netCircuitNode, netCircuitNode2, netCircuit2, netCircuit, iNetCircuit);
        if (mergeManager.getMasterCircuit() != null) {
            iNetCircuit = this.checkMasterCircuit(netCircuit2, netCircuit, iNetCircuit);
        }
        if (iNetCircuit == null) {
            iNetCircuit = this.checkCircuitModel(netCircuit2, netCircuit);
        }
        if (iNetCircuit == null) {
            iNetCircuit = this.checkCircuitSource(netCircuitNode, netCircuitNode2);
        }
        if (iNetCircuit == null) {
            iNetCircuit = netCircuit2;
        }
        return iNetCircuit;
    }

    protected static INetCircuit checkOchnc(NetCircuit netCircuit, NetCircuit netCircuit2, INetCircuit iNetCircuit) throws CircuitMergeError {
        if (netCircuit instanceof OchncCircuit ^ netCircuit instanceof OchncCircuit) {
            throw new CircuitMergeError("One connection is OCHNC connection but the other one is not");
        }
        if (!(netCircuit instanceof OchncCircuit)) {
            return iNetCircuit;
        }
        ICircuitInfo iCircuitInfo = netCircuit.getCircuitInfo();
        ICircuitInfo iCircuitInfo2 = netCircuit2.getCircuitInfo();
        if (iCircuitInfo.getCircuitSize() != iCircuitInfo2.getCircuitSize()) {
            throw new CircuitMergeError("The two OCHNC circuits do not have the same circuit size.");
        }
        if (iCircuitInfo.getCktOptDir() != iCircuitInfo2.getCktOptDir()) {
            throw new CircuitMergeError("The two OCHNC circuits do not have the same optical direction.");
        }
        if (iCircuitInfo.getCktOptChannel() != iCircuitInfo2.getCktOptChannel()) {
            throw new CircuitMergeError("The two OCHNC circuits do not use the same optical channel.");
        }
        return iNetCircuit;
    }

    protected static INetCircuit checkVlan(NetCircuit netCircuit, NetCircuit netCircuit2, INetCircuit iNetCircuit) throws CircuitMergeError {
        NetCircuit netCircuit3 = null;
        if (netCircuit.getVlans().length != 0 && netCircuit2.getVlans().length == 0) {
            netCircuit3 = netCircuit;
        } else if (netCircuit.getVlans().length == 0 && netCircuit2.getVlans().length != 0) {
            netCircuit3 = netCircuit2;
        } else if (netCircuit.getVlans().length != 0 && netCircuit2.getVlans().length != 0) {
            TreeSet<IVlanModel> treeSet = new TreeSet<IVlanModel>(new VlanInfoComparator());
            TreeSet<IVlanModel> treeSet2 = new TreeSet<IVlanModel>(new VlanInfoComparator());
            treeSet.addAll(Arrays.asList(netCircuit.getVlans()));
            treeSet2.addAll(Arrays.asList(netCircuit2.getVlans()));
            if (!treeSet.equals(treeSet2)) {
                throw new CircuitMergeError("The two circuits have different VLAN set.");
            }
        }
        return CircuitMergeSplicer.findCommonDestCircuit(netCircuit3, iNetCircuit);
    }

    protected static INetCircuit checkSla(NetCircuit netCircuit, NetCircuit netCircuit2, INetCircuit iNetCircuit) throws CircuitMergeError {
        NetCircuit netCircuit3 = null;
        short s = 0;
        ICircuitInfo iCircuitInfo = netCircuit.getCircuitInfo();
        ICircuitInfo iCircuitInfo2 = netCircuit2.getCircuitInfo();
        if (iCircuitInfo.getSla() != s && iCircuitInfo2.getSla() == s) {
            netCircuit3 = netCircuit;
        } else if (iCircuitInfo.getSla() == s && iCircuitInfo2.getSla() != s) {
            netCircuit3 = netCircuit2;
        } else if (iCircuitInfo.getSla() != s && iCircuitInfo2.getSla() != s && iCircuitInfo.getSla() != iCircuitInfo2.getSla()) {
            throw new CircuitMergeError("The two circuits have different SLA values.");
        }
        return CircuitMergeSplicer.findCommonDestCircuit(netCircuit3, iNetCircuit);
    }

    protected static INetCircuit checkMonitor(NetCircuit netCircuit, NetCircuit netCircuit2, INetCircuit iNetCircuit) throws CircuitMergeError {
        NetCircuit netCircuit3 = null;
        ICircuitInfo iCircuitInfo = netCircuit.getCircuitInfo();
        ICircuitInfo iCircuitInfo2 = netCircuit2.getCircuitInfo();
        if (iCircuitInfo.getMonitor() && !iCircuitInfo2.getMonitor()) {
            netCircuit3 = netCircuit;
        } else if (!iCircuitInfo.getMonitor() && iCircuitInfo2.getMonitor()) {
            netCircuit3 = netCircuit2;
        }
        return CircuitMergeSplicer.findCommonDestCircuit(netCircuit3, iNetCircuit);
    }

    private INetCircuit checkLoTunnelNode(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2, NetCircuit netCircuit, NetCircuit netCircuit2, INetCircuit iNetCircuit) throws CircuitMergeError {
        NetCircuitMergeOperator netCircuitMergeOperator = mergeManager.getMergeOperator(netCircuit);
        NetCircuitMergeOperator netCircuitMergeOperator2 = mergeManager.getMergeOperator(netCircuit2);
        NetCircuitMergeOperator.DisjointPart disjointPart = netCircuitMergeOperator.getDisjointPartOnNode(netCircuitNode);
        NetCircuitMergeOperator.DisjointPart disjointPart2 = netCircuitMergeOperator2.getDisjointPartOnNode(netCircuitNode2);
        NetCircuit netCircuit3 = null;
        if (disjointPart.containLoTunnelNode() && !disjointPart2.containLoTunnelNode()) {
            netCircuit3 = netCircuit;
        } else if (!disjointPart.containLoTunnelNode() && disjointPart2.containLoTunnelNode()) {
            netCircuit3 = netCircuit2;
        }
        return CircuitMergeSplicer.findCommonDestCircuit(netCircuit3, iNetCircuit);
    }

    private INetCircuit checkEtherStitchNode(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2, NetCircuit netCircuit, NetCircuit netCircuit2, INetCircuit iNetCircuit) throws CircuitMergeError {
        NetCircuitMergeOperator netCircuitMergeOperator = mergeManager.getMergeOperator(netCircuit);
        NetCircuitMergeOperator netCircuitMergeOperator2 = mergeManager.getMergeOperator(netCircuit2);
        NetCircuitMergeOperator.DisjointPart disjointPart = netCircuitMergeOperator.getDisjointPartOnNode(netCircuitNode);
        NetCircuitMergeOperator.DisjointPart disjointPart2 = netCircuitMergeOperator2.getDisjointPartOnNode(netCircuitNode2);
        NetCircuit netCircuit3 = null;
        if (disjointPart.containEtherStitchNode() && !disjointPart2.containEtherStitchNode()) {
            netCircuit3 = netCircuit;
        } else if (!disjointPart.containEtherStitchNode() && disjointPart2.containEtherStitchNode()) {
            netCircuit3 = netCircuit2;
        }
        return CircuitMergeSplicer.findCommonDestCircuit(netCircuit3, iNetCircuit);
    }

    private INetCircuit checkMasterCircuit(INetCircuit iNetCircuit, INetCircuit iNetCircuit2, INetCircuit iNetCircuit3) throws CircuitMergeError {
        INetCircuit iNetCircuit4 = null;
        if (iNetCircuit == mergeManager.getMasterCircuit()) {
            iNetCircuit4 = iNetCircuit;
        } else if (iNetCircuit2 == mergeManager.getMasterCircuit()) {
            iNetCircuit4 = iNetCircuit2;
        }
        return CircuitMergeSplicer.findCommonDestCircuit(iNetCircuit4, iNetCircuit3);
    }

    private INetCircuit checkCircuitModel(NetCircuit netCircuit, NetCircuit netCircuit2) {
        if (netCircuit.circuitModel() != null && netCircuit2.circuitModel() == null) {
            return netCircuit;
        }
        if (netCircuit.circuitModel() == null && netCircuit2.circuitModel() != null) {
            return netCircuit2;
        }
        return null;
    }

    private INetCircuit checkCircuitSource(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        NetCircuit netCircuit = (NetCircuit)netCircuitNode.getCircuit();
        NetCircuit netCircuit2 = (NetCircuit)netCircuitNode2.getCircuit();
        NetCircuitMergeOperator netCircuitMergeOperator = mergeManager.getMergeOperator(netCircuit);
        NetCircuitMergeOperator netCircuitMergeOperator2 = mergeManager.getMergeOperator(netCircuit2);
        if (netCircuitMergeOperator.connectToCircuitSource(netCircuitNode) && !netCircuitMergeOperator2.connectToCircuitSource(netCircuitNode2)) {
            return netCircuit;
        }
        if (!netCircuitMergeOperator.connectToCircuitSource(netCircuitNode) && netCircuitMergeOperator2.connectToCircuitSource(netCircuitNode2)) {
            return netCircuit2;
        }
        return null;
    }

    private static INetCircuit findCommonDestCircuit(INetCircuit iNetCircuit, INetCircuit iNetCircuit2) throws CircuitMergeError {
        if (iNetCircuit == iNetCircuit2) {
            return iNetCircuit;
        }
        if (iNetCircuit == null) {
            return iNetCircuit2;
        }
        if (iNetCircuit2 == null) {
            return iNetCircuit;
        }
        throw new CircuitMergeError("The desitination circuit can not be decided as 2 criteria direct different ways.");
    }

    protected void completeSplice(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        INetCircuit iNetCircuit = netCircuitNode.getCircuit();
        INetCircuit iNetCircuit2 = netCircuitNode2.getCircuit();
        INetCircuit iNetCircuit3 = iNetCircuit;
        if (iNetCircuit != iNetCircuit2) {
            if (!this.spliceAllowed(iNetCircuit, iNetCircuit2)) {
                throw new IllegalStateException("The 2 circuit nodes could not be unified.");
            }
            try {
                iNetCircuit3 = this.getSpliceDestinationCircuit(netCircuitNode, netCircuitNode2);
            }
            catch (CircuitMergeError circuitMergeError) {
                throw new IllegalStateException(circuitMergeError.getMessage());
            }
        }
        if (iNetCircuit3 == iNetCircuit) {
            mergeManager.getMergeOperator(iNetCircuit3).unify(netCircuitNode, netCircuitNode2);
        } else {
            mergeManager.getMergeOperator(iNetCircuit3).unify(netCircuitNode2, netCircuitNode);
        }
    }

    protected boolean alreadyConnected(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        boolean bl;
        NetCircuitMergeOperator netCircuitMergeOperator = mergeManager.getMergeOperator(netCircuitNode.getCircuit());
        boolean bl2 = bl = netCircuitMergeOperator.getDisjointPartOnNode(netCircuitNode) == netCircuitMergeOperator.getDisjointPartOnNode(netCircuitNode2);
        if (CircuitMergeSplicer.dbgOn()) {
            CircuitMergeSplicer.debug("connected = " + bl);
        }
        if (!bl) {
            return false;
        }
        if (netCircuitNode.getConnectionType() == 12) {
            return false;
        }
        NetCircuitMergeOperator.DisjointPart disjointPart = netCircuitMergeOperator.getDisjointPartOnNode(netCircuitNode);
        boolean bl3 = disjointPart.containUpsrNode();
        boolean bl4 = disjointPart.containEtherStitchNode();
        boolean bl5 = disjointPart.containDualConnectionNode();
        if (CircuitMergeSplicer.dbgOn()) {
            CircuitMergeSplicer.debug("containUpsrConn = " + bl3);
            CircuitMergeSplicer.debug("containEtherStitch = " + bl4);
            CircuitMergeSplicer.debug("containDualConn = " + bl5);
        }
        boolean bl6 = true;
        if (bl5) {
            if (!bl4 && !bl3) {
                bl6 = false;
            }
        } else if (bl4) {
            bl6 = false;
        } else if (bl3) {
            bl6 = false;
        }
        if (CircuitMergeSplicer.dbgOn()) {
            CircuitMergeSplicer.debug("fullyConnected=" + bl6);
        }
        return bl6;
    }

    protected boolean passedTwoConnsSameNECheck() {
        return true;
    }

    public void startSplice() {
        this.generateCallbacks();
    }
}

