/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.DeleteInstead;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionConversionModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IRollModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NetServiceState;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnectionPathNotFound;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.HoCircuitNode;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.IUpsrOps;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.ncp.OnewayConnection;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.INetElement;
import cerent.util.IHoNum;
import cerent.util.IObservable;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DualConnectionCircuitNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("DualConnectionCircuitNode");
    private NetCircuitNode fstCircuitNode;
    private NetCircuitNode secCircuitNode;
    private List internalSpliceLinkEnds;
    private boolean bothCktNodesAdminState = false;

    public DualConnectionCircuitNode(INetElement iNetElement, ICircuitType iCircuitType, NetCcatCircuit netCcatCircuit) {
        super(iNetElement, netCcatCircuit);
        this.internalSpliceLinkEnds = new LinkedList();
        this.pathWidth = iCircuitType.isOchTrailTunnelCircuitType() ? (short)netCcatCircuit.getCircuitSize() : netCcatCircuit.getCircuitSizeObj().size2widthOfHoCircuit();
        if (iCircuitType.isHoCircuitType()) {
            this.fstCircuitNode = new HoCircuitNode(iNetElement, (HoCcatCircuit)netCcatCircuit);
            this.secCircuitNode = new HoCircuitNode(iNetElement, (HoCcatCircuit)netCcatCircuit);
        } else if (iCircuitType.isLAPCircuitType()) {
            this.fstCircuitNode = new HoCircuitNode(iNetElement, (HoCcatCircuit)netCcatCircuit);
            this.secCircuitNode = new LoTunnelNode(iNetElement, (HoCcatCircuit)netCcatCircuit);
        } else if (iCircuitType.isOchTrailTunnelCircuitType()) {
            this.fstCircuitNode = new OchTrailTunnelNode(iNetElement, (OchncCircuit)netCcatCircuit);
            this.secCircuitNode = new OchncCircuitNode(iNetElement, (OchncCircuit)netCcatCircuit);
        } else {
            if (this.dbgOn()) {
                db.println("ERROR! Invalid circuit type for DualConnectionCircuitNode");
            }
            return;
        }
        if (this.fstCircuitNode.onXm()) {
            ((HoCircuitNode)this.fstCircuitNode).setIngressOnXm(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DualConnectionCircuitNode(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) throws AbstractCmsObjectNotExistException {
        super(netCircuitNode.getNetElement(), (NetCcatCircuit)netCircuitNode.getCircuit());
        this.fstCircuitNode = netCircuitNode;
        this.secCircuitNode = netCircuitNode2;
        this.internalSpliceLinkEnds = new LinkedList();
        if (this.circuit instanceof OchncCircuit) {
            if (this.secCircuitNode instanceof OchTrailTunnelNode) {
                this.fstCircuitNode = netCircuitNode2;
                this.secCircuitNode = netCircuitNode;
            }
            this.pathWidth = (short)this.circuit.getCircuitSize();
        } else {
            this.pathWidth = this.circuit.getCircuitSizeObj().size2widthOfHoCircuit();
        }
        if (this.circuit.getCircuitNodeFromNE(netCircuitNode.getNetElement()) != null) {
            this.circuit.removeCktNode(netCircuitNode);
        }
        this.circuit.insertCktNode(this);
        if (this.fstCircuitNode.getConn() != null && this.secCircuitNode.getConn() != null) {
            int n;
            if (this.circuit instanceof HoCcatCircuit && (n = this.getPathIndexOfXm(this.secCircuitNode)) != 0 && this.secCircuitNode.getConnectionType() != 2) {
                NetCircuitNode netCircuitNode3 = this.fstCircuitNode;
                this.fstCircuitNode = this.secCircuitNode;
                this.secCircuitNode = netCircuitNode3;
                ((HoCircuitNode)this.fstCircuitNode).setIngressOnXm(true);
            }
            this.addConnectionObserver();
            super.setConnectionType(this.getConnTypeFromConnModel());
            super.updateConnectionPathEnds(this.getConnectionPathEnds());
            this.setInternalSpliceLinkEnds();
            this.initState(2);
            this.cktId = this.getConnectionCircuitId();
        }
        this.inSpans.addAll(this.fstCircuitNode.inSpans());
        this.biSpans.addAll(this.fstCircuitNode.biSpans());
        this.outSpans.addAll(this.fstCircuitNode.outSpans());
        this.inSpans.addAll(this.secCircuitNode.inSpans());
        this.biSpans.addAll(this.secCircuitNode.biSpans());
        this.outSpans.addAll(this.secCircuitNode.outSpans());
        this.initSourceAndDrop();
        if (this.fstCircuitNode.isNodeDrop()) {
            this.insertDrop(this.fstCircuitNode.getNodeDrop());
        } else if (this.secCircuitNode.isNodeDrop()) {
            this.insertDrop(this.secCircuitNode.getNodeDrop());
        }
        if (netCircuitNode.getConn() == null) {
            this.setAdminState(netCircuitNode.getCircuit().getAdminState());
        } else {
            this.setAdminState(netCircuitNode.getAdminStateFromNE());
        }
        this.setServiceState(this.getServiceStateFromNE());
        this.circuit.setChanged();
        Object object = this.entitiesLockObject;
        synchronized (object) {
            this.updateUpsrEntities(true);
        }
    }

    public int getServiceStateFromNE() {
        if (this.isOchTrail()) {
            int n;
            int n2 = super.getServiceState();
            boolean bl = true;
            boolean bl2 = true;
            int n3 = this.fstCircuitNode.getConn() == null ? ((NetCcatCircuit)this.fstCircuitNode.getCircuit()).getServiceState() : this.fstCircuitNode.getServiceStateFromNE();
            if (!NetServiceState.isFormOfIS(n3)) {
                bl = false;
            }
            if (!NetServiceState.isFormOfOOS(n3)) {
                bl2 = false;
            }
            if (this.dbgOn()) {
                db.println("getServiceStateFromNE(). First cktNode: " + NetServiceState.getServiceStateStringFromServiceState(n3));
            }
            if (!NetServiceState.isFormOfIS(n = this.secCircuitNode.getConn() == null ? ((NetCcatCircuit)this.secCircuitNode.getCircuit()).getServiceState() : this.secCircuitNode.getServiceStateFromNE())) {
                bl = false;
            }
            if (!NetServiceState.isFormOfOOS(n)) {
                bl2 = false;
            }
            if (this.dbgOn()) {
                db.println("getServiceStateFromNE(). Second cktNode: " + NetServiceState.getServiceStateStringFromServiceState(n));
            }
            int n4 = bl ? 0 : (bl2 ? 1 : 2);
            if (this.dbgOn()) {
                db.println("getServiceStateFromNE(). allIS=" + bl + ", allOOS=" + bl2 + ", state=" + NetServiceState.getServiceStateStringFromServiceState(n4));
            }
            this.setServiceState(n4);
            if (n4 != n2) {
                this.circuit.setChanged();
            }
            return n4;
        }
        return super.getServiceState();
    }

    protected void addDropInfo(NetCircuitDropInfo netCircuitDropInfo) {
        NetCircuitEnd netCircuitEnd = netCircuitDropInfo.getNetCktEnd();
        if (netCircuitEnd.isNodeDrop()) {
            if (this.fstCircuitNode instanceof LoTunnelNode) {
                this.fstCircuitNode.insertDrop(netCircuitEnd);
            }
            if (this.secCircuitNode instanceof LoTunnelNode) {
                this.secCircuitNode.insertDrop(netCircuitEnd);
            }
        } else if (this.secCircuitNode instanceof HoCircuitNode) {
            this.secCircuitNode.insertDrop(netCircuitEnd);
        }
        super.addDropInfo(netCircuitDropInfo);
    }

    public void removeRoutedDrop(NetCircuitEnd netCircuitEnd) throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("Removing ROUTED drop at dual-node " + this.getName());
        }
        this.secCircuitNode.removeRoutedDrop(netCircuitEnd);
        if (this.fstCircuitNode.getDrops().contains(netCircuitEnd)) {
            this.fstCircuitNode.removeRoutedDrop(netCircuitEnd);
        }
        super.removeRoutedDrop(netCircuitEnd);
    }

    protected void removeDrop(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("removeDrop(" + netCircuitEnd.prettyString() + ") at dual-node " + this.getName());
        }
        this.secCircuitNode.removeDrop(netCircuitEnd);
        super.removeDrop(netCircuitEnd);
    }

    protected void changeSourceToDrop(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("changeSourceToDrop(" + netCircuitEnd.prettyString() + ") at " + this.getName());
        }
        if (this.fstCircuitNode.sources.contains(netCircuitEnd)) {
            this.fstCircuitNode.changeSourceToDrop(netCircuitEnd);
        } else if (this.secCircuitNode.sources.contains(netCircuitEnd)) {
            this.secCircuitNode.changeSourceToDrop(netCircuitEnd);
        } else {
            this.debug("Warning: no node contains given cktEnd!");
        }
        super.changeSourceToDrop(netCircuitEnd);
    }

    protected void changeDropToSource(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("changeDropToSource(" + netCircuitEnd.prettyString() + ") at " + this.getName());
        }
        if (this.fstCircuitNode.drops.contains(netCircuitEnd)) {
            this.fstCircuitNode.changeDropToSource(netCircuitEnd);
        } else if (this.secCircuitNode.drops.contains(netCircuitEnd)) {
            this.secCircuitNode.changeDropToSource(netCircuitEnd);
        } else {
            this.debug("Warning: no node contains given cktEnd!");
        }
        super.changeDropToSource(netCircuitEnd);
    }

    protected void deleteDropFromConnection(NetCircuitEnd netCircuitEnd) throws DeleteInstead, InvalidPath, PathInUse, ObjNotFound, NoMoreLoCapableHo, ConnectionTypeError, ConnectionInTopologyUpgrade, ConnectionInLoopback, ConnectionInTestAccess, ConnectionInRoll {
        if (netCircuitEnd.getStage() == 2) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("Deleting drop from connection");
        }
        this.secCircuitNode.removeOutputFromConnModel(netCircuitEnd);
        --this.numberOfPaths;
    }

    protected void deleteSpanFromConnection(NetCircuitSpan netCircuitSpan) throws DeleteInstead, InvalidPath, ConnectionTypeError, ObjNotFound, PathInUse, NoMoreLoCapableHo, ConnectionInTopologyUpgrade, ConnectionInLoopback, ConnectionInTestAccess, ConnectionInRoll {
        if (this.dbgOn()) {
            this.debug("Deleting span from connection");
        }
        this.secCircuitNode.removeOutputFromConnModel(netCircuitSpan);
        --this.numberOfPaths;
        if (netCircuitSpan.getLink().getSrc() == this.ne) {
            netCircuitSpan.setSrcState(0);
        } else {
            netCircuitSpan.setDstState(0);
        }
    }

    public IConnectionModel getConn() {
        return this.getFirstConn();
    }

    public String getConnNameFromNE() {
        block4: {
            if (this.getCircuit() instanceof OchncCircuit) {
                try {
                    if (this.getSecConn() != null) {
                        String string = this.getSecConn().getConnectionName();
                        db.info("For OCHNC (OCH-Trail Tunnel) CircuitName " + this.circuit.getCircuitName() + " Connection name is : " + string + " at node " + this.getName());
                        return string;
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!this.dbgOn()) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }
        return super.getConnNameFromNE();
    }

    private IConnectionModel getFirstConn() {
        return this.fstCircuitNode.getConn();
    }

    protected IConnectionModel getSecConn() {
        return this.secCircuitNode.getConn();
    }

    protected void setConn(IConnectionModel iConnectionModel) {
    }

    protected void setConnectionType(int n) {
        super.setConnectionType(n);
        if (this.circuit.isBidirectional()) {
            this.fstCircuitNode.setConnectionType(DualConnectionCircuitNode.findBiDirectionalConnType(this.fstCircuitNode));
            this.secCircuitNode.setConnectionType(DualConnectionCircuitNode.findBiDirectionalConnType(this.secCircuitNode));
        } else {
            this.fstCircuitNode.setConnectionType(DualConnectionCircuitNode.findUniDirectionalConnType(this.fstCircuitNode));
            this.secCircuitNode.setConnectionType(DualConnectionCircuitNode.findUniDirectionalConnType(this.secCircuitNode));
        }
    }

    protected void setCircuit(NetCcatCircuit netCcatCircuit) {
        super.setCircuit(netCcatCircuit);
        if (this.fstCircuitNode != null) {
            this.fstCircuitNode.setCircuit(netCcatCircuit);
        }
        if (this.secCircuitNode != null) {
            this.secCircuitNode.setCircuit(netCcatCircuit);
        }
    }

    public List getMonitorSourcePoints() throws SanityCheckFailed {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.fstCircuitNode.getMonitorSourcePoints());
        linkedList.addAll(this.secCircuitNode.getMonitorSourcePoints());
        return linkedList;
    }

    protected void activate() throws CircuitProvError {
        this.fstCircuitNode.activate();
        this.secCircuitNode.activate();
        super.activate();
    }

    protected void createConnection() throws CircuitProvError {
        this.setConnectionType(this.findConnType());
        if (this.getConnectionType() == 20) {
            if (this.dbgOn()) {
                db.println("Warning! createConnection at dual-node " + this.getName() + " connection type is unknown");
            }
            throw new CircuitProvError("Invalid connection type at " + this.getName());
        }
        this.cktId = this.circuit.getCircuitId();
        this.connName = this.circuit.getCircuitName();
        if (this.dbgOn()) {
            db.println("createConnection at dual-node " + this.getName() + "inCount=" + this.countNumInputs() + " outCount=" + this.countNumOutputs() + " pathWidth " + this.pathWidth);
        }
        this.addConnectionObserver();
        this.setState(1);
        this.setCreateStage(3);
        this.numberOfPaths = this.fstCircuitNode.countNumInputs() + this.fstCircuitNode.countNumOutputs() + this.fstCircuitNode.countNumOmniSpans() + (this.fstCircuitNode.onXm() ? 1 : 0) + this.secCircuitNode.countNumInputs() + this.secCircuitNode.countNumOutputs() + this.secCircuitNode.countNumOmniSpans() + (this.secCircuitNode.onXm() ? 1 : 0);
        super.updateConnectionPathEnds(this.getConnectionPathEnds());
    }

    protected void createSpliceListener(NetCircuitEnd netCircuitEnd) {
        if (this.fstCircuitNode.getConnectionPathEnds().contains(netCircuitEnd)) {
            this.fstCircuitNode.createSpliceListener(netCircuitEnd);
        } else if (this.secCircuitNode.getConnectionPathEnds().contains(netCircuitEnd)) {
            this.secCircuitNode.createSpliceListener(netCircuitEnd);
        }
    }

    protected void createSpliceListener(NetCircuitSplicer netCircuitSplicer, NetCircuitEnd netCircuitEnd, eSpanDirection eSpanDirection2) {
        if (this.fstCircuitNode.getConnectionPathEnds().contains(netCircuitEnd)) {
            this.fstCircuitNode.createSpliceListener(netCircuitSplicer, netCircuitEnd, eSpanDirection2);
        } else if (this.secCircuitNode.getConnectionPathEnds().contains(netCircuitEnd)) {
            this.secCircuitNode.createSpliceListener(netCircuitSplicer, netCircuitEnd, eSpanDirection2);
        }
    }

    protected void cleanupSpliceListeners() {
        this.fstCircuitNode.cleanupSpliceListeners();
        this.secCircuitNode.cleanupSpliceListeners();
    }

    protected void addRoutedSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        super.addRoutedSpan(netCircuitSpan, eSpanDirection2);
        if (this.fstCircuitNode.onXm() && this.secCircuitNode.onXm()) {
            if (netCircuitSpan.getLink().getDst() == this.getNetElement()) {
                if (this.dbgOn()) {
                    this.debug("Adding ingress span to fstCircuitNode");
                }
                this.fstCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection2);
            } else {
                if (this.dbgOn()) {
                    this.debug("Adding egress span to secCircuitNode");
                }
                this.secCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection2);
            }
        } else if (this.getCircuit().getCircuitTypeObj().isHoCircuitType()) {
            if (netCircuitSpan.getLink().getDst() == this.getNetElement()) {
                if (this.dbgOn()) {
                    this.debug("Adding span to secCircuitNode");
                }
                this.secCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection2);
            } else {
                if (this.dbgOn()) {
                    this.debug("Adding span to fstCircuitNode");
                }
                this.fstCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection2);
            }
        } else if (this.getCircuit().getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            if (this.dbgOn()) {
                this.debug("Adding span to secCircuitNode");
            }
            this.secCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection2);
        } else if (this.dbgOn()) {
            db.println("addRoutedSpan: Unsupported circuit type at dual-node " + this.getName());
        }
    }

    protected int removeRoutedSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        if (this.fstCircuitNode.onXm() && this.secCircuitNode.onXm()) {
            if (netCircuitSpan.getLink().getDst() == this.getNetElement()) {
                this.fstCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection2);
            } else {
                this.secCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection2);
            }
        } else if (this.fstCircuitNode instanceof LoTunnelNode && this.secCircuitNode instanceof LoTunnelNode) {
            NetCircuitNode netCircuitNode = null;
            NetCircuitNode netCircuitNode2 = null;
            if (this.fstCircuitNode.biSpans().contains(netCircuitSpan)) {
                this.fstCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection2);
                netCircuitNode = this.fstCircuitNode;
                netCircuitNode2 = this.secCircuitNode;
            } else if (this.secCircuitNode.biSpans().contains(netCircuitSpan)) {
                this.secCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection2);
                netCircuitNode = this.secCircuitNode;
                netCircuitNode2 = this.fstCircuitNode;
            }
            if (netCircuitNode != null && netCircuitNode2 != null && netCircuitNode.biSpans().isEmpty()) {
                boolean bl = false;
                if (this.circuit.srcCircuitNode != null && this.circuit.srcCircuitNode.equals(this)) {
                    bl = true;
                }
                this.circuit.removeCktNode(this);
                this.circuit.insertCktNode(netCircuitNode2);
                if (bl) {
                    this.circuit.setSrcCircuitNode();
                }
            }
        } else if (netCircuitSpan.getLink().getDst() == this.getNetElement()) {
            this.secCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection2);
        } else {
            this.fstCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection2);
        }
        return super.removeRoutedSpan(netCircuitSpan, eSpanDirection2);
    }

    protected void addActiveSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        if (this.dbgOn()) {
            db.println("Adding active span for circuit " + this.circuit.getCircuitName() + " " + NetCircuit.prettyString(this.circuit.getCircuitId()) + " at dual-node " + this.getName());
        }
        this.addSpan(netCircuitSpan, eSpanDirection2);
        this.circuit.addActiveSpan(netCircuitSpan);
        this.removeActiveEndpoint(netCircuitSpan);
        if (this.circuit instanceof OchncCircuit) {
            this.secCircuitNode.addSpan(netCircuitSpan, eSpanDirection2);
            this.secCircuitNode.removeActiveEndpoint(netCircuitSpan);
        } else if (this.fstCircuitNode.hasConnectionPath(netCircuitSpan)) {
            this.fstCircuitNode.addSpan(netCircuitSpan, eSpanDirection2);
            this.fstCircuitNode.removeActiveEndpoint(netCircuitSpan);
        } else {
            this.secCircuitNode.addSpan(netCircuitSpan, eSpanDirection2);
            this.secCircuitNode.removeActiveEndpoint(netCircuitSpan);
        }
        this.setupConnListOnDiscovery();
        if (this.circuit.circuitInfoActive()) {
            return;
        }
        this.initSourceAndDrop();
    }

    protected void disposeActiveSpan(NetCircuitSpan netCircuitSpan, boolean bl) {
        eSpanDirection eSpanDirection2;
        if (this.dbgOn()) {
            db.println("disposeActiveSpan at dual-node " + this.getName());
        }
        if ((eSpanDirection2 = this.findDir(netCircuitSpan)) != null) {
            this.removeSpan(netCircuitSpan, eSpanDirection2);
        }
        this.fstCircuitNode.disposeActiveSpan(netCircuitSpan, bl);
        this.secCircuitNode.disposeActiveSpan(netCircuitSpan, bl);
    }

    protected void conformToCircuitInfo() {
        if (this.dbgOn()) {
            db.println("conformToCircuitInfo at dual-node " + this.getName());
        }
        if (this.fstCircuitNode.getConn() == null || this.secCircuitNode.getConn() == null) {
            return;
        }
        this.fstCircuitNode.conformToCircuitInfo();
        this.secCircuitNode.conformToCircuitInfo();
        this.initSourceAndDrop();
        this.setCircuitInfoNodeDrop();
    }

    protected boolean isCircuitInfoSourceOrDrop(NetCircuitEnd netCircuitEnd) {
        return this.fstCircuitNode.isCircuitInfoSourceOrDrop(netCircuitEnd) || this.secCircuitNode.isCircuitInfoSourceOrDrop(netCircuitEnd);
    }

    protected void setCircuitInfoNodeDrop() {
        this.fstCircuitNode.setCircuitInfoNodeDrop();
        this.secCircuitNode.setCircuitInfoNodeDrop();
        if (this.fstCircuitNode.isNodeDrop() || this.secCircuitNode.isNodeDrop()) {
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.circuit.getCircuitType(), this.getNetElement());
            this.insertDrop(netCircuitEnd);
            return;
        }
        this.nodeDrop = null;
    }

    private void initSourceAndDrop() {
        NetCircuitEnd netCircuitEnd;
        int n;
        INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[2];
        if (this.dbgOn()) {
            db.println("initSourceAndDrop at dual-node " + this.getName());
        }
        this.sources.clear();
        this.drops.clear();
        Iterator iterator = this.fstCircuitNode.getSources().iterator();
        NetCircuitNode netCircuitNode = this.fstCircuitNode;
        for (n = 0; n < 2; ++n) {
            while (iterator.hasNext()) {
                netCircuitEnd = (NetCircuitEnd)iterator.next();
                if (netCircuitEnd.onXm()) {
                    iNetCircuitEndArray[n] = netCircuitEnd;
                }
                if (netCircuitEnd.onXm() || this.onInternalSpliceLink(netCircuitEnd)) {
                    netCircuitNode.removeSource(netCircuitEnd);
                    continue;
                }
                this.insertSource(netCircuitEnd);
            }
            iterator = this.secCircuitNode.getSources().iterator();
            netCircuitNode = this.secCircuitNode;
        }
        iterator = this.fstCircuitNode.getDrops().iterator();
        netCircuitNode = this.fstCircuitNode;
        for (n = 0; n < 2; ++n) {
            while (iterator.hasNext()) {
                netCircuitEnd = (NetCircuitEnd)iterator.next();
                if (netCircuitEnd.onXm()) {
                    iNetCircuitEndArray[n] = netCircuitEnd;
                }
                if (netCircuitEnd.onXm() || this.onInternalSpliceLink(netCircuitEnd)) {
                    netCircuitNode.removeDrop(netCircuitEnd);
                    continue;
                }
                this.insertDrop(netCircuitEnd);
            }
            iterator = this.secCircuitNode.getDrops().iterator();
            netCircuitNode = this.secCircuitNode;
        }
        if (this.circuit.getState() != 0 && !this.circuit.circuitInfoActive()) {
            this.circuit.setCircuitLevelSourcesAndDrops();
        }
        if (this.circuit.getCktOperation() != 1 && iNetCircuitEndArray[0] != null && iNetCircuitEndArray[1] != null) {
            ((HoCcatCircuit)this.circuit).setXmCircuitEnds(iNetCircuitEndArray);
        }
        if (this.circuit instanceof OchncCircuit) {
            List list;
            if (this.dbgOn()) {
                db.println("initSourceAndDrop at dual-node: check src/dst internalCktEnds setting");
            }
            if (this.internalSpliceLinkEnds.size() != 3) {
                this.internalSpliceLinkEnds.clear();
                this.internalSpliceLinkEnds = this.getOttInternalSpliceLinkEnds(this.fstCircuitNode);
                this.internalSpliceLinkEnds.addAll(this.getOttInternalSpliceLinkEnds(this.secCircuitNode));
            }
            if (this.internalSpliceLinkEnds.size() == 3 && (list = this.circuit.getSources()).size() != 0) {
                netCircuitEnd = (NetCircuitEnd)list.get(0);
                if (netCircuitEnd.getNodeId() == this.getNodeModel().getNodeId()) {
                    if (this.dbgOn()) {
                        db.println("initSourceAndDrop at dual-node: setSrcInternalSpliceLinkEnds");
                    }
                    ((OchncCircuit)this.circuit).setSrcInternalSpliceLinkEnds(this.internalSpliceLinkEnds);
                    List list2 = ((OchncCircuit)this.circuit).getDstInternalSpliceLinkEnds();
                    if (list2.size() != 0 && (netCircuitEnd = (NetCircuitEnd)list2.get(0)).getNodeId() == this.getNodeModel().getNodeId()) {
                        if (this.dbgOn()) {
                            db.println("Clear Dst internal cktEnds:");
                        }
                        ((OchncCircuit)this.circuit).clearInternalDstSpliceLinkEnds();
                    }
                } else {
                    if (this.dbgOn()) {
                        db.println("initSourceAndDrop at dual-node:  setDstInternalSpliceLinkEnds");
                    }
                    ((OchncCircuit)this.circuit).setDstInternalSpliceLinkEnds(this.internalSpliceLinkEnds);
                    List list3 = ((OchncCircuit)this.circuit).getSrcInternalSpliceLinkEnds();
                    if (list3.size() != 0 && (netCircuitEnd = (NetCircuitEnd)list3.get(0)).getNodeId() == this.getNodeModel().getNodeId()) {
                        if (this.dbgOn()) {
                            db.println("Clear Src internal cktEnds:");
                        }
                        ((OchncCircuit)this.circuit).clearInternalSrcSpliceLinkEnds();
                    }
                }
            }
        }
    }

    protected void modifyConnection() throws CircuitProvError {
        if (this.dbgOn()) {
            db.println("modifyConnection at dual-node  " + this.getName());
        }
        this.modifyConnectionType();
        super.updateConnectionPathEnds(this.getConnectionPathEnds());
        this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans() + (this.fstCircuitNode.onXm() ? 1 : 0) + (this.secCircuitNode.onXm() ? 1 : 0);
        this.setState(2);
    }

    protected int getConnTypeFromConnModel() {
        int n = 20;
        int n2 = this.fstCircuitNode.getConnTypeFromConnModel();
        int n3 = this.secCircuitNode.getConnTypeFromConnModel();
        if (n2 == 20 && n3 == 20) {
            return 20;
        }
        if (this.circuit.isBidirectional()) {
            if (n2 != 1 && n2 != 2 && n3 != 1 && n3 != 2 && n2 != 0 && n3 != 12) {
                if (this.dbgOn()) {
                    db.println("getConnTypeFromConnModel: dual-node " + this.getName() + " has invalid conn type");
                }
                return 20;
            }
            n = n2 == 2 && n3 == 2 ? 3 : (n2 == 2 ? n2 : (n3 == 2 ? n3 : (n2 == 0 && n3 == 12 ? n2 : 1)));
        } else {
            n = n2 != 0 ? n2 : (n3 != 0 ? n3 : 0);
        }
        return n;
    }

    protected void conformToConnection(NetCircuitSplicer netCircuitSplicer) {
        if (this.dbgOn()) {
            db.println("conformToConnection: dual-node " + this.getName());
        }
        if (this.fstCircuitNode instanceof HoCircuitNode || this.fstCircuitNode instanceof OchTrailTunnelNode) {
            this.fstCircuitNode.conformToConnection(netCircuitSplicer);
        }
        if (this.secCircuitNode instanceof HoCircuitNode || this.secCircuitNode instanceof OchncCircuitNode) {
            this.secCircuitNode.conformToConnection(netCircuitSplicer);
        }
        super.setConnectionType(this.getConnTypeFromConnModel());
        this.nodeRoutingDir.setNodeRoutingDirToForward();
        super.updateConnectionPathEnds(this.getConnectionPathEnds());
        int n = this.fstCircuitNode instanceof HoCircuitNode || this.fstCircuitNode instanceof OchTrailTunnelNode ? this.fstCircuitNode.getPathsFromConnModel().length : 1;
        int n2 = this.secCircuitNode instanceof HoCircuitNode || this.secCircuitNode instanceof OchncCircuitNode ? this.secCircuitNode.getPathsFromConnModel().length : 1;
        this.numberOfPaths = n + n2;
        this.initSourceAndDrop();
        this.setupConnListOnDiscovery();
    }

    protected Object[] getPathsFromConnModel() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.fstCircuitNode instanceof HoCircuitNode || this.fstCircuitNode instanceof OchTrailTunnelNode) {
            arrayList.addAll(Arrays.asList(this.fstCircuitNode.getPathsFromConnModel()));
        }
        if (this.secCircuitNode instanceof HoCircuitNode || this.secCircuitNode instanceof OchncCircuitNode) {
            arrayList.addAll(Arrays.asList(this.secCircuitNode.getPathsFromConnModel()));
        }
        return arrayList.toArray();
    }

    protected Object[] getPathsFromConnModelExcludeXms() {
        NetCircuitEnd netCircuitEnd;
        int n;
        Object[] objectArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.fstCircuitNode instanceof HoCircuitNode) {
            objectArray = this.fstCircuitNode.getPathsFromConnModel();
            for (n = 0; n < objectArray.length; ++n) {
                netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[n]);
                if (netCircuitEnd.onXm()) continue;
                arrayList.add(objectArray[n]);
            }
        }
        if (this.secCircuitNode instanceof HoCircuitNode) {
            objectArray = this.secCircuitNode.getPathsFromConnModel();
            for (n = 0; n < objectArray.length; ++n) {
                netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[n]);
                if (netCircuitEnd.onXm()) continue;
                arrayList.add(objectArray[n]);
            }
        }
        if (this.circuit.isBidirectional() && this.secCircuitNode.getConnectionType() != 1 && arrayList.size() == 3) {
            Object e = arrayList.remove(0);
            arrayList.add(e);
        }
        return arrayList.toArray();
    }

    protected void sanityCheckConnModel() {
        this.fstCircuitNode.sanityCheckConnModel();
        this.secCircuitNode.sanityCheckConnModel();
    }

    protected void destroySanityCheck() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("destroySanityCheck at dual-node " + this.getName());
        }
        this.fstCircuitNode.destroySanityCheck();
        this.secCircuitNode.destroySanityCheck();
    }

    public void destroy() {
        if (this.dbgOn()) {
            db.println("Destroy dual-node " + this.getName() + " object on exit of CTC");
        }
        this.fstCircuitNode.destroy();
        this.secCircuitNode.destroy();
        super.destroy();
    }

    protected void destroyCrossConnection() throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup {
        if (this.dbgOn()) {
            db.println("destroyCrossConnection(dual-node " + this.getName() + "): destroy connection");
        }
        this.fstCircuitNode.destroyCrossConnection();
        this.secCircuitNode.destroyCrossConnection();
        super.updateConnectionPathEnds(new LinkedList());
    }

    protected void cleanupLoAdits() {
        if (this.fstCircuitNode instanceof LoTunnelNode) {
            this.fstCircuitNode.cleanupLoAdits();
        }
        if (this.secCircuitNode instanceof LoTunnelNode) {
            this.secCircuitNode.cleanupLoAdits();
        }
    }

    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the connection circuit Id at dual-node " + this.getName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        this.fstCircuitNode.setConnectionCircuitId(iCircuitId);
        this.secCircuitNode.setConnectionCircuitId(iCircuitId);
    }

    public ICircuitId getConnectionCircuitId() {
        ICircuitId iCircuitId = this.fstCircuitNode.getConnectionCircuitId();
        if (NetCircuit.isNullCircuitId(iCircuitId)) {
            iCircuitId = this.secCircuitNode.getConnectionCircuitId();
        }
        return iCircuitId;
    }

    protected Object[] getActivePathsFromConnModel() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.fstCircuitNode instanceof HoCircuitNode) {
            arrayList.addAll(Arrays.asList(this.fstCircuitNode.getActivePathsFromConnModel()));
        }
        if (this.secCircuitNode instanceof HoCircuitNode) {
            arrayList.addAll(Arrays.asList(this.secCircuitNode.getActivePathsFromConnModel()));
        }
        return arrayList.toArray();
    }

    protected int getProtectionOpFromConnModel() {
        if (this.protectionOp != -1) {
            return this.protectionOp;
        }
        if (this.fstCircuitNode instanceof HoCircuitNode) {
            this.protectionOp = this.fstCircuitNode.getProtectionOpFromConnModel();
        }
        if (this.protectionOp != -1) {
            return this.protectionOp;
        }
        if (this.secCircuitNode instanceof HoCircuitNode) {
            this.protectionOp = this.secCircuitNode.getProtectionOpFromConnModel();
        }
        return this.protectionOp;
    }

    protected int getReverseProtectionOpFromConnModel() {
        if (this.reverseProtectionOp != -1) {
            return this.reverseProtectionOp;
        }
        if (this.fstCircuitNode instanceof HoCircuitNode) {
            this.reverseProtectionOp = this.fstCircuitNode.getReverseProtectionOpFromConnModel();
        }
        if (this.reverseProtectionOp != -1) {
            return this.reverseProtectionOp;
        }
        if (this.secCircuitNode instanceof HoCircuitNode) {
            this.reverseProtectionOp = this.secCircuitNode.getReverseProtectionOpFromConnModel();
        }
        return this.reverseProtectionOp;
    }

    protected boolean completeCheck() {
        int n;
        block8: {
            block7: {
                this.initSourceAndDrop();
                this.numberOfPaths = this.circuit instanceof OchncCircuit ? this.countNumInputs() + this.countNumOutputs() + (this.fstCircuitNode.isSrcCoLocatedCktNode() ? 2 : 0) + (this.fstCircuitNode.isDstCoLocatedCktNode() ? 2 : 0) + (this.secCircuitNode.isSrcCoLocatedCktNode() ? 2 : 0) + (this.secCircuitNode.isDstCoLocatedCktNode() ? 2 : 0) : this.countNumInputs() + this.countNumOutputs() + (this.fstCircuitNode.onXm() ? 1 : 0) + (this.secCircuitNode.onXm() ? 1 : 0);
                if (this.dbgOn()) {
                    db.println("completeCheck at dual-node " + this.getName() + " in = " + this.countNumInputs() + " out = " + this.countNumOutputs() + " numberOfPaths = " + this.numberOfPaths);
                }
                n = 0;
                try {
                    n = this.fstCircuitNode instanceof HoCircuitNode || this.fstCircuitNode instanceof OchTrailTunnelNode ? (n += this.fstCircuitNode.getPathsFromConnModel().length) : ++n;
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    if (!this.dbgOn()) break block7;
                    db.println("cmpleteCheck: node may have been deleted");
                }
            }
            try {
                n = this.secCircuitNode instanceof HoCircuitNode || this.secCircuitNode instanceof OchncCircuitNode ? (n += this.secCircuitNode.getPathsFromConnModel().length) : ++n;
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!this.dbgOn()) break block8;
                db.println("cmpleteCheck: node may have been deleted");
            }
        }
        if (n == this.numberOfPaths) {
            if (this.dbgOn()) {
                db.println("completeCheck passed");
            }
            return true;
        }
        return false;
    }

    protected int findConnType() {
        int n = 20;
        if (this.dbgOn()) {
            db.println("findConnType: at dual-node " + this.getName());
        }
        int n2 = this.fstCircuitNode.findConnType();
        int n3 = this.secCircuitNode.findConnType();
        if (this.circuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            if (n2 != 0 || n3 != 12) {
                if (this.dbgOn()) {
                    db.println("findConnType: at dual-node " + this.getName() + " has invalid conn type");
                }
                return 20;
            }
            n = n2;
        } else if (this.circuit.isBidirectional()) {
            if (n2 != 1 && n2 != 2 && n3 != 1 && n3 != 2) {
                if (this.dbgOn()) {
                    db.println("findConnType: at dual-node " + this.getName() + " has invalid conn type");
                }
                return 20;
            }
            n = n2 == 2 && n3 == 2 ? 3 : (n2 == 2 ? n2 : (n3 == 2 ? n3 : 1));
        } else {
            n = n2 != 0 ? n2 : (n3 != 0 ? n3 : 0);
        }
        return n;
    }

    protected int getConnDir() {
        if (this.circuit instanceof OchncCircuit) {
            return 1;
        }
        return super.getConnDir();
    }

    public boolean upsrBridgeOrSelector() {
        return this.fstCircuitNode.upsrBridgeOrSelector() || this.secCircuitNode.upsrBridgeOrSelector();
    }

    public boolean isUpsrSelector() {
        return this.fstCircuitNode.isUpsrSelector() || this.secCircuitNode.isUpsrSelector();
    }

    public List getUpsrConns() {
        LinkedList<IConnectionModel> linkedList = new LinkedList<IConnectionModel>();
        if (this.fstCircuitNode.isUpsrSelector()) {
            linkedList.add(this.fstCircuitNode.getConn());
        }
        if (this.secCircuitNode.isUpsrSelector()) {
            linkedList.add(this.secCircuitNode.getConn());
        }
        return linkedList;
    }

    protected void createUpsrOps() {
        if (this.fstCircuitNode.hasConnection()) {
            if (this.fstCircuitNode.isUpsrSelector() && this.fstCircuitNode.getUpsrOps() == null) {
                this.fstCircuitNode.createUpsrOps();
            }
        } else if (this.fstCircuitNode.isUpsrSelectorConn() && this.fstCircuitNode.getUpsrOps() == null) {
            this.fstCircuitNode.createUpsrOps();
        }
        if (this.secCircuitNode.hasConnection()) {
            if (this.secCircuitNode.isUpsrSelector() && this.secCircuitNode.getUpsrOps() == null) {
                this.secCircuitNode.createUpsrOps();
            }
        } else if (this.secCircuitNode.isUpsrSelectorConn() && this.secCircuitNode.getUpsrOps() == null) {
            this.secCircuitNode.createUpsrOps();
        }
    }

    protected IUpsrOps getUpsrOps(NetCircuitSpan netCircuitSpan) {
        if (this.fstCircuitNode.getAllSpansList().contains(netCircuitSpan)) {
            return this.fstCircuitNode.getUpsrOps();
        }
        if (this.secCircuitNode.getAllSpansList().contains(netCircuitSpan)) {
            return this.secCircuitNode.getUpsrOps();
        }
        return null;
    }

    public IUpsrOps getUpsrOps() {
        IUpsrOps iUpsrOps = this.fstCircuitNode.getUpsrOps();
        IUpsrOps iUpsrOps2 = this.secCircuitNode.getUpsrOps();
        if (iUpsrOps != null) {
            return iUpsrOps;
        }
        return iUpsrOps2;
    }

    public List getUpsrOpsList() {
        LinkedList<IUpsrOps> linkedList = new LinkedList<IUpsrOps>();
        IUpsrOps iUpsrOps = null;
        iUpsrOps = this.fstCircuitNode.getUpsrOps();
        for (int i = 0; i < 2; ++i) {
            if (iUpsrOps != null) {
                linkedList.add(iUpsrOps);
            }
            iUpsrOps = this.secCircuitNode.getUpsrOps();
        }
        return linkedList;
    }

    protected int getUpsrReversionMode() {
        int n = this.fstCircuitNode.getUpsrReversionMode();
        int n2 = this.secCircuitNode.getUpsrReversionMode();
        if (n != -1) {
            return n;
        }
        return n2;
    }

    protected boolean validateBiDirectionalConn() {
        if (this.dbgOn()) {
            db.println("validateBiDirectionalConn() at dual-node " + this.getName());
        }
        if (this.fstCircuitNode instanceof LoTunnelNode && this.secCircuitNode instanceof LoTunnelNode) {
            return false;
        }
        if (this.fstCircuitNode instanceof HoCircuitNode && this.secCircuitNode instanceof LoTunnelNode && this.totalSpans() == this.fstCircuitNode.totalSpans() && this.totalSpans() < 3) {
            return true;
        }
        return this.fstCircuitNode instanceof HoCircuitNode && this.secCircuitNode instanceof HoCircuitNode && this.totalSpans() == this.fstCircuitNode.totalSpans() + this.secCircuitNode.totalSpans() && this.totalSpans() < 5;
    }

    protected void markRoutedUpsrSpanOffBridge(NetCircuitSpan netCircuitSpan) throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("markRoutedUpsrSpanOffBridge called at dual-node " + this.getName());
        }
        if (this.fstCircuitNode instanceof LoTunnelNode && this.secCircuitNode instanceof LoTunnelNode) {
            throw new SanityCheckFailed("Can not provision protected VAP");
        }
        super.markRoutedUpsrSpanOffBridge(netCircuitSpan);
    }

    protected int biSpanUpsrCost(NetCircuitSpan netCircuitSpan) {
        if (this.fstCircuitNode.biSpans().contains(netCircuitSpan)) {
            return this.fstCircuitNode.biSpanUpsrCost(netCircuitSpan);
        }
        if (this.secCircuitNode.biSpans().contains(netCircuitSpan)) {
            return this.secCircuitNode.biSpanUpsrCost(netCircuitSpan);
        }
        return 0;
    }

    public List getWorkingSpans() {
        LinkedList linkedList = new LinkedList();
        if (this.fstCircuitNode instanceof HoCircuitNode) {
            linkedList.addAll(this.fstCircuitNode.getWorkingSpans());
        }
        if (this.secCircuitNode instanceof HoCircuitNode) {
            linkedList.addAll(this.secCircuitNode.getWorkingSpans());
        }
        return linkedList;
    }

    public List getProtectSpans() {
        LinkedList linkedList = new LinkedList();
        if (this.fstCircuitNode instanceof HoCircuitNode) {
            linkedList.addAll(this.fstCircuitNode.getProtectSpans());
        }
        if (this.secCircuitNode instanceof HoCircuitNode) {
            linkedList.addAll(this.secCircuitNode.getProtectSpans());
        }
        return linkedList;
    }

    protected void updateUpsrActiveEntities() {
        this.fstCircuitNode.updateUpsrActiveEntities();
        this.secCircuitNode.updateUpsrActiveEntities();
    }

    protected boolean isAnyChangeInUpsrSelector() {
        return this.fstCircuitNode.isAnyChangeInUpsrSelector() || this.secCircuitNode.isAnyChangeInUpsrSelector();
    }

    protected int getUpsrSpanState(NetCircuitSpan netCircuitSpan, int n) {
        if (this.fstCircuitNode.getAllSpansList().contains(netCircuitSpan)) {
            return this.fstCircuitNode.getUpsrSpanState(netCircuitSpan, n);
        }
        if (this.secCircuitNode.getAllSpansList().contains(netCircuitSpan)) {
            return this.secCircuitNode.getUpsrSpanState(netCircuitSpan, n);
        }
        return 3;
    }

    public List getPathList() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.fstCircuitNode.getPathList());
        linkedList.addAll(this.secCircuitNode.getPathList());
        return linkedList;
    }

    public List getActivePathList() {
        List list = this.fstCircuitNode.getActivePathList();
        if (this.secCircuitNode.isUpsrSelector()) {
            list.addAll(this.secCircuitNode.getActivePathList());
        }
        return list;
    }

    protected void addConnectionObserver() {
        if (this.dbgOn()) {
            db.println("addConnectionObservers at dual-node");
        }
        this.addConnectionObserver(this.fstCircuitNode.getConn());
        this.addConnectionObserver(this.secCircuitNode.getConn());
    }

    protected void deleteConnectionObserver() {
        if (this.dbgOn()) {
            db.println("deleteConnectionObservers at dual-node");
        }
        this.deleteConnectionObserver(this.fstCircuitNode.getConn());
        this.deleteConnectionObserver(this.secCircuitNode.getConn());
        this.fstCircuitNode.deleteConnectionObserver();
        this.secCircuitNode.deleteConnectionObserver();
    }

    private void addConnectionObserver(IConnectionModel iConnectionModel) {
        if (iConnectionModel != null) {
            if (this.dbgOn()) {
                db.println("addConnectionObserver at dual-node " + this.getName());
            }
            ModelIndirectObservable.instance().addObserver((IObservable)iConnectionModel, this);
        }
    }

    private void deleteConnectionObserver(IConnectionModel iConnectionModel) {
        if (iConnectionModel != null) {
            if (this.dbgOn()) {
                db.println("deleteConnectionObserver at dual-node " + this.getName());
            }
            try {
                ModelIndirectObservable.instance().deleteObserver((IObservable)iConnectionModel, this);
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                // empty catch block
            }
        }
    }

    protected void runUpdate() {
        if (this.dbgOn()) {
            db.println("Start --- DCN.runUpdate() at " + this.getName() + " ----");
        }
        this.fstCircuitNode.runUpdate();
        this.secCircuitNode.runUpdate();
        super.runUpdate();
        if (this.dbgOn()) {
            db.println("End ----- DCN.runUpdate() at " + this.getName() + " ----");
        }
    }

    protected void updateDeleted() {
        if (this.dbgOn()) {
            db.println("updateDeleted() at " + this.getNameAndClass());
        }
        this.parentDispose();
    }

    public void parentDispose() {
        if (this.dbgOn()) {
            db.println("parentDispose called at dual-node" + this.getName());
        }
        this.disposeConnection(false);
        this.deleteConnectionObserver(this.fstCircuitNode.getConn());
        this.deleteConnectionObserver(this.secCircuitNode.getConn());
        this.finalDispose();
    }

    protected boolean updateConnectionPathEnds(List list) {
        return super.updateConnectionPathEnds(this.getConnectionPathEnds());
    }

    public List getConnectionPathEnds() {
        NetCircuitEnd netCircuitEnd;
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        List list = this.fstCircuitNode.getConnectionPathEnds();
        Iterator iterator = list.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                netCircuitEnd = (NetCircuitEnd)iterator.next();
                if (!netCircuitEnd.onXm()) continue;
                iterator.remove();
            }
            linkedList.addAll(list);
            list = this.secCircuitNode.getConnectionPathEnds();
            iterator = list.iterator();
        }
        if (linkedList.isEmpty()) {
            return linkedList;
        }
        if (this.circuit.isBidirectional() && this.fstCircuitNode.getConnectionType() == 1 && this.secCircuitNode.getConnectionType() == 2) {
            netCircuitEnd = (NetCircuitEnd)linkedList.remove(0);
            linkedList.add(netCircuitEnd);
        }
        return linkedList;
    }

    protected int getConnectionPathIndex(NetCircuitEnd netCircuitEnd) throws ConnectionPathNotFound {
        int n = super.getConnectionPathIndex(netCircuitEnd);
        return this.convertConnectionPathIndex(n);
    }

    protected int convertConnectionPathIndex(int n) {
        if (this.circuit.getXmCircuitEnds().isEmpty() && !this.getSources().isEmpty() && !this.getDrops().isEmpty() && n > 1) {
            n -= 2;
        }
        return n;
    }

    protected void tentative2Active() {
        this.fstCircuitNode.tentative2Active();
        this.secCircuitNode.tentative2Active();
        this.setCreateStage(4);
        this.setState(2);
    }

    protected void tentative2Routed() throws DeletionError {
        this.fstCircuitNode.tentative2Routed();
        this.secCircuitNode.tentative2Routed();
        this.setState(0);
        this.setCreateStage(2);
    }

    protected void setCreateStage(int n) {
        this.fstCircuitNode.setCreateStage(n);
        this.secCircuitNode.setCreateStage(n);
        super.setCreateStage(n);
    }

    protected void setState(int n) {
        this.fstCircuitNode.setState(n);
        this.secCircuitNode.setState(n);
        super.setState(n);
    }

    protected boolean deleteDropCheck(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        if (super.deleteDropCheck(iNetCircuitEnd, bl)) {
            return this.drops.size() != 1 || bl;
        }
        return false;
    }

    protected void prettyPrint(SDebug sDebug) {
        sDebug.println(" ~~~~ Dual Connection Circuit Node ~~~~~~~~~");
        super.prettyPrint(sDebug);
        sDebug.print(" ----- First Circuit Node ");
        if (this.fstCircuitNode.isIngressOnXm()) {
            sDebug.println("(Ingress on XM)----");
        } else {
            sDebug.println("-------------------");
        }
        this.fstCircuitNode.prettyPrint(sDebug);
        sDebug.print(" ---- Second Circuit Node ");
        if (this.secCircuitNode.isIngressOnXm()) {
            sDebug.println("(Ingress on XM)----");
        } else {
            sDebug.println("-------------------");
        }
        this.secCircuitNode.prettyPrint(sDebug);
    }

    protected boolean hasAggregation() {
        return this.fstCircuitNode instanceof LoTunnelNode || this.secCircuitNode instanceof LoTunnelNode;
    }

    protected NetCircuitNode getLoTunnelNode() {
        if (this.fstCircuitNode instanceof LoTunnelNode) {
            return this.fstCircuitNode;
        }
        if (this.secCircuitNode instanceof LoTunnelNode) {
            return this.secCircuitNode;
        }
        return null;
    }

    protected List getAggregationNodes() {
        LinkedList<NetCircuitNode> linkedList = new LinkedList<NetCircuitNode>();
        if (this.fstCircuitNode instanceof LoTunnelNode) {
            linkedList.add(this.fstCircuitNode);
        }
        if (this.secCircuitNode instanceof LoTunnelNode) {
            linkedList.add(this.secCircuitNode);
        }
        return linkedList;
    }

    public NetCircuitNode getFstCircuitNode() {
        return this.fstCircuitNode;
    }

    public NetCircuitNode getSecCircuitNode() {
        return this.secCircuitNode;
    }

    protected int getTunnelEntityIndex() throws SanityCheckFailed {
        int n = -1;
        if (this.fstCircuitNode instanceof OchTrailTunnelNode) {
            n = this.fstCircuitNode.getTunnelEntityIndex();
        }
        if (this.secCircuitNode instanceof LoTunnelNode) {
            n = this.secCircuitNode.getTunnelEntityIndex();
        }
        return n;
    }

    public IHoNum getLotHo() throws SanityCheckFailed {
        IHoNum iHoNum = null;
        if (this.secCircuitNode instanceof LoTunnelNode) {
            iHoNum = this.secCircuitNode.getLotHo();
        }
        return iHoNum;
    }

    protected NetCircuitSpan findAlternateBiSpan(NetCircuitSpan netCircuitSpan) {
        if (this.fstCircuitNode instanceof LoTunnelNode && this.secCircuitNode instanceof LoTunnelNode) {
            return null;
        }
        return super.findAlternateBiSpan(netCircuitSpan);
    }

    protected boolean hasDualConnections() {
        return true;
    }

    protected static int findBiDirectionalConnType(NetCircuitNode netCircuitNode) {
        int n;
        int n2 = netCircuitNode.countNumInputs();
        int n3 = netCircuitNode.countNumOutputs();
        if (netCircuitNode instanceof OchTrailTunnelNode) {
            return 0;
        }
        if (netCircuitNode instanceof OchncCircuitNode) {
            return 12;
        }
        if (netCircuitNode.onXm()) {
            if (netCircuitNode.isIngressOnXm()) {
                ++n3;
            } else {
                ++n2;
            }
        }
        if ((n = n2 + n3) == 2) {
            if (n2 == 1 && n3 == 1) {
                return 1;
            }
        } else if (n == 3 && (n2 == 2 && n3 == 1 || n2 == 1 && n3 == 2)) {
            return 2;
        }
        if (netCircuitNode instanceof LoTunnelNode) {
            return 1;
        }
        db.println("Warning! findBiDirectionalConnType: Unknown Conn. Type, node: " + netCircuitNode.getName() + " total=" + n + " in: " + n2 + " out: " + n3);
        return 20;
    }

    protected static int findUniDirectionalConnType(NetCircuitNode netCircuitNode) {
        int n;
        int n2 = netCircuitNode.countNumInputs();
        int n3 = netCircuitNode.countNumOutputs();
        if (netCircuitNode.onXm()) {
            if (netCircuitNode.isIngressOnXm()) {
                ++n3;
            } else {
                ++n2;
            }
        }
        if ((n = n2 + n3) == 2) {
            if (n2 == 1 && n3 == 1) {
                return 0;
            }
        } else if (n == 3) {
            if (n2 == 2 && n3 == 1) {
                return 6;
            }
            if (n2 == 1 && n3 == 2) {
                return 0;
            }
        }
        db.println("Warning! findUniDirectionalConnType: Unknown Conn. Type, node: " + netCircuitNode.getName() + " total=" + n + " in: " + n2 + " out: " + n3);
        return 20;
    }

    public void setInternalSpliceLinkEnds() {
        if (this.dbgOn()) {
            this.debug("setInternalSpliceLinkEnds() at dual-node " + this.getName());
        }
        if (this.circuit instanceof OchncCircuit) {
            if (this.internalSpliceLinkEnds.size() != 3) {
                this.internalSpliceLinkEnds.clear();
                this.internalSpliceLinkEnds = this.getOttInternalSpliceLinkEnds(this.fstCircuitNode);
                this.internalSpliceLinkEnds.addAll(this.getOttInternalSpliceLinkEnds(this.secCircuitNode));
            }
            if (this.internalSpliceLinkEnds.size() == 3) {
                if (this.circuit.getSrcInternalSpliceLinkEnds().size() == 0) {
                    ((OchncCircuit)this.circuit).setSrcInternalSpliceLinkEnds(this.internalSpliceLinkEnds);
                } else if (this.circuit.getDstInternalSpliceLinkEnds().size() == 0) {
                    ((OchncCircuit)this.circuit).setDstInternalSpliceLinkEnds(this.internalSpliceLinkEnds);
                }
            }
        } else if (this.circuit instanceof HoCcatCircuit) {
            if (this.circuit.getCktOperation() == 1 && this.circuit.getXmCircuitEnds().size() == 2) {
                return;
            }
            INetCircuitEnd[] iNetCircuitEndArray = new INetCircuitEnd[]{this.getXmCircuitEnd(this.fstCircuitNode), this.getXmCircuitEnd(this.secCircuitNode)};
            if (iNetCircuitEndArray[0] != null && iNetCircuitEndArray[1] != null) {
                ((HoCcatCircuit)this.circuit).setXmCircuitEnds(iNetCircuitEndArray);
            }
        } else if (this.dbgOn()) {
            db.println("setInternalSpliceLinkEnds: Invalid circuit type for dual-conn");
        }
    }

    public boolean onInternalSpliceLink(NetCircuitEnd netCircuitEnd) {
        return this.internalSpliceLinkEnds.contains(netCircuitEnd);
    }

    private INetCircuitEnd getXmCircuitEnd(NetCircuitNode netCircuitNode) {
        if (netCircuitNode instanceof HoCircuitNode) {
            Object[] objectArray = netCircuitNode.getPathsFromConnModel();
            for (int i = 0; i < objectArray.length; ++i) {
                NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(netCircuitNode.getNetElement(), objectArray[i]);
                if (!netCircuitEnd.onXm()) continue;
                return netCircuitEnd;
            }
        } else {
            IHoPathDefModel iHoPathDefModel = ((ILoAditModel)netCircuitNode.getConn()).getHo();
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(netCircuitNode.getNetElement(), iHoPathDefModel);
            if (netCircuitEnd.onXm()) {
                return netCircuitEnd;
            }
        }
        return null;
    }

    private int getPathIndexOfXm(NetCircuitNode netCircuitNode) {
        if (netCircuitNode.getConn() == null) {
            return -1;
        }
        int n = 0;
        Iterator iterator = netCircuitNode.getPathEndsFromPathDefs(netCircuitNode.getConnectionPathDefs()).iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.onXm()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private List getOttInternalSpliceLinkEnds(NetCircuitNode netCircuitNode) {
        NetCircuitEnd netCircuitEnd;
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        Object[] objectArray = netCircuitNode.getPathsFromConnModel();
        if (netCircuitNode instanceof OchncCircuitNode) {
            for (int i = 0; i < objectArray.length; i += 3) {
                NetCircuitEnd netCircuitEnd2 = NetCircuitEndFactory.createCircuitEndFromConn(netCircuitNode.getNetElement(), objectArray[i]);
                if (netCircuitEnd2 == null) continue;
                linkedList.add(netCircuitEnd2);
            }
        } else if (netCircuitNode instanceof OchTrailTunnelNode && (netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(netCircuitNode.getNetElement(), objectArray[0])) != null) {
            linkedList.add(netCircuitEnd);
        }
        if (this.dbgOn()) {
            this.debug("getOttInternalSpliceLinkEnds() for " + netCircuitNode.getClass().getName() + " at " + netCircuitNode.getName() + " returning " + linkedList.size() + " int splice link ends");
        }
        return linkedList;
    }

    protected void setupConnListOnCreation(int n) {
        if (this.circuit.getXmCircuitEnds().isEmpty() && !this.getSources().isEmpty() && !this.getDrops().isEmpty()) {
            this.connections.clear();
            if (this.dbgOn()) {
                db.println("setupConnList on dual-node " + this.getName());
            }
            LinkedList linkedList = this.getOrigSpans();
            LinkedList linkedList2 = this.getTermSpans();
            if (linkedList.size() < 1 || linkedList2.size() < 1 || this.sources.size() < 1 || this.drops.size() < 1) {
                return;
            }
            switch (n) {
                case 0: {
                    OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                    this.connections.add(onewayConnection);
                    OnewayConnection onewayConnection2 = new OnewayConnection("oneway2");
                    this.connections.add(onewayConnection2);
                    onewayConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    onewayConnection.addOutput((NetCircuitSpan)linkedList.get(0));
                    onewayConnection2.addInput((NetCircuitSpan)linkedList2.get(0));
                    onewayConnection2.addOutput((NetCircuitEnd)this.drops.get(0));
                    break;
                }
                case 1: {
                    OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                    this.connections.add(onewayConnection);
                    OnewayConnection onewayConnection3 = new OnewayConnection("oneway2");
                    this.connections.add(onewayConnection3);
                    OnewayConnection onewayConnection4 = new OnewayConnection("oneway3");
                    this.connections.add(onewayConnection4);
                    OnewayConnection onewayConnection5 = new OnewayConnection("oneway4");
                    this.connections.add(onewayConnection5);
                    onewayConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    onewayConnection3.addOutput((NetCircuitEnd)this.sources.get(0));
                    onewayConnection.addOutput((NetCircuitSpan)linkedList.get(0));
                    onewayConnection3.addInput((NetCircuitSpan)linkedList.get(0));
                    onewayConnection4.addInput((NetCircuitSpan)linkedList2.get(0));
                    onewayConnection5.addOutput((NetCircuitSpan)linkedList2.get(0));
                    onewayConnection4.addOutput((NetCircuitEnd)this.drops.get(0));
                    onewayConnection5.addInput((NetCircuitEnd)this.drops.get(0));
                }
            }
        } else {
            super.setupConnListOnCreation(n);
        }
    }

    protected void setupConnListOnDiscovery() {
        if (this.circuit.getXmCircuitEnds().isEmpty() && !this.getSources().isEmpty() && !this.getDrops().isEmpty()) {
            int n;
            NetCircuitEnd[] netCircuitEndArray;
            Object[] objectArray;
            if (this.dbgOn()) {
                db.println("setupConnListOnDiscovery at dual-node " + this.getName());
            }
            NetCircuitEnd netCircuitEnd = null;
            NetCircuitSpan netCircuitSpan = null;
            int n2 = -1;
            try {
                objectArray = this.getPathsFromConnModel();
                netCircuitEndArray = new NetCircuitEnd[objectArray.length];
                for (n = 0; n < objectArray.length; ++n) {
                    netCircuitEndArray[n] = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[n]);
                }
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                return;
            }
            this.connections.clear();
            switch (this.connType) {
                case 0: {
                    OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                    this.connections.add(onewayConnection);
                    OnewayConnection onewayConnection2 = new OnewayConnection("oneway2");
                    this.connections.add(onewayConnection2);
                    block7: for (n = 0; n < objectArray.length; ++n) {
                        netCircuitEnd = netCircuitEndArray[n];
                        if (this.sources.indexOf(netCircuitEnd) != -1) {
                            n2 = this.sources.indexOf(netCircuitEnd);
                            if (n != 0) continue;
                            onewayConnection.addInput(this.sources.get(n2));
                            continue;
                        }
                        if (this.drops.indexOf(netCircuitEnd) != -1) {
                            n2 = this.drops.indexOf(netCircuitEnd);
                            if (n != 3) continue;
                            onewayConnection2.addOutput(this.drops.get(n2));
                            continue;
                        }
                        int n3 = this.getEntityIndexFromPathDef(objectArray[n]);
                        Iterator iterator = this.getAllSpansList().iterator();
                        while (iterator.hasNext()) {
                            netCircuitSpan = (NetCircuitSpan)iterator.next();
                            if (n3 != netCircuitSpan.getEntityIndex(this.getNetElement())) continue;
                            if (this.dbgOn()) {
                                db.println("Found span for path def " + netCircuitSpan.prettyString());
                            }
                            if (n == 1) {
                                onewayConnection.addOutput(netCircuitSpan);
                                continue block7;
                            }
                            if (n != 2) continue block7;
                            onewayConnection2.addInput(netCircuitSpan);
                            continue block7;
                        }
                    }
                    break;
                }
                case 1: {
                    OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                    this.connections.add(onewayConnection);
                    OnewayConnection onewayConnection3 = new OnewayConnection("oneway2");
                    this.connections.add(onewayConnection3);
                    OnewayConnection onewayConnection4 = new OnewayConnection("oneway3");
                    this.connections.add(onewayConnection4);
                    OnewayConnection onewayConnection5 = new OnewayConnection("oneway4");
                    this.connections.add(onewayConnection5);
                    block9: for (n = 0; n < objectArray.length; ++n) {
                        netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[n]);
                        if (this.sources.indexOf(netCircuitEnd) != -1) {
                            n2 = this.sources.indexOf(netCircuitEnd);
                            if (n == 0) {
                                onewayConnection.addInput(this.sources.get(n2));
                                onewayConnection3.addOutput(this.sources.get(n2));
                                continue;
                            }
                            if (n == 1) {
                                onewayConnection.addOutput(this.sources.get(n2));
                                onewayConnection3.addInput(this.sources.get(n2));
                                continue;
                            }
                            if (n == 2) {
                                onewayConnection4.addInput(this.sources.get(n2));
                                onewayConnection5.addOutput(this.sources.get(n2));
                                continue;
                            }
                            if (n != 3) continue;
                            onewayConnection4.addOutput(this.sources.get(n2));
                            onewayConnection5.addInput(this.sources.get(n2));
                            continue;
                        }
                        if (this.drops.indexOf(netCircuitEnd) != -1) {
                            n2 = this.drops.indexOf(netCircuitEnd);
                            if (n == 3) {
                                onewayConnection4.addOutput(this.drops.get(n2));
                                onewayConnection5.addInput(this.drops.get(n2));
                                continue;
                            }
                            if (n == 2) {
                                onewayConnection4.addInput(this.drops.get(n2));
                                onewayConnection5.addOutput(this.drops.get(n2));
                                continue;
                            }
                            if (n == 1) {
                                onewayConnection.addOutput(this.drops.get(n2));
                                onewayConnection3.addInput(this.drops.get(n2));
                                continue;
                            }
                            if (n != 0) continue;
                            onewayConnection.addInput(this.drops.get(n2));
                            onewayConnection3.addOutput(this.drops.get(n2));
                            continue;
                        }
                        int n4 = this.getEntityIndexFromPathDef(objectArray[n]);
                        Iterator iterator = this.getAllSpansList().iterator();
                        while (iterator.hasNext()) {
                            netCircuitSpan = (NetCircuitSpan)iterator.next();
                            if (n4 != netCircuitSpan.getEntityIndex(this.getNetElement())) continue;
                            if (this.dbgOn()) {
                                db.println("Found span for path def " + netCircuitSpan.prettyString());
                            }
                            if (n == 0) {
                                onewayConnection.addInput(netCircuitSpan);
                                onewayConnection3.addOutput(netCircuitSpan);
                                continue block9;
                            }
                            if (n == 1) {
                                onewayConnection.addOutput(netCircuitSpan);
                                onewayConnection3.addInput(netCircuitSpan);
                                continue block9;
                            }
                            if (n == 2) {
                                onewayConnection4.addInput(netCircuitSpan);
                                onewayConnection5.addOutput(netCircuitSpan);
                                continue block9;
                            }
                            if (n != 3) continue block9;
                            onewayConnection4.addOutput(netCircuitSpan);
                            onewayConnection5.addInput(netCircuitSpan);
                            continue block9;
                        }
                    }
                    break;
                }
            }
            this.prettyPrintConnectionList(db);
        } else {
            super.setupConnListOnDiscovery();
        }
    }

    public NetCircuitNode getOtherNode(NetCircuitNode netCircuitNode) {
        if (this.fstCircuitNode == netCircuitNode) {
            return this.secCircuitNode;
        }
        if (this.secCircuitNode == netCircuitNode) {
            return this.fstCircuitNode;
        }
        return null;
    }

    public boolean doesCircuitNodeUseConn(IConnectionModel iConnectionModel) {
        return this.fstCircuitNode.getConn() == iConnectionModel || this.secCircuitNode.getConn() == iConnectionModel;
    }

    protected NetCircuitNode getChildCktNode(List list) {
        NetCircuitNode netCircuitNode = null;
        NetCircuitNode netCircuitNode2 = this.fstCircuitNode;
        for (int i = 0; i < 2; ++i) {
            Iterator iterator = netCircuitNode2.getAllSpansList().iterator();
            while (iterator.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                if (!list.contains(netCircuitSpan.getLink()) && !list.contains(netCircuitSpan.getReverseLink())) continue;
                netCircuitNode = netCircuitNode2;
            }
            netCircuitNode2 = this.secCircuitNode;
        }
        return netCircuitNode;
    }

    protected NetCircuitNode[] getChildCktNodes() {
        return new NetCircuitNode[]{this.fstCircuitNode, this.secCircuitNode};
    }

    public void setConnName(String string) throws CircuitProvError {
        this.fstCircuitNode.setConnName(string);
        this.secCircuitNode.setConnName(string);
        this.connName = string;
    }

    public String getConnName() {
        if (this.getCircuit() instanceof OchncCircuit) {
            return this.secCircuitNode.getConnName();
        }
        return this.fstCircuitNode.getConnName();
    }

    protected int getAdminStateFromNE() {
        if (this.isOchTrail()) {
            int n = this.fstCircuitNode.getAdminState();
            int n2 = this.secCircuitNode.getAdminState();
            int n3 = n;
            if (NetCcatCircuit.getAdminStatePriority(n2) > NetCcatCircuit.getAdminStatePriority(n3)) {
                n3 = n2;
            }
            if (this.dbgOn()) {
                this.debug("deriveAdminState(" + this.getName() + "): " + this.translateAdminState(this.getAdminState()) + " --> " + this.translateAdminState(n3) + " [1st: " + this.translateAdminState(n) + ", 2nd: " + this.translateAdminState(n2) + ")");
            }
            return n3;
        }
        return super.getAdminStateFromNE();
    }

    protected void setAdminState(int n) {
        if (this.fstCircuitNode != null) {
            this.fstCircuitNode.setAdminState(n);
        }
        if (this.secCircuitNode != null) {
            this.secCircuitNode.setAdminState(n);
        }
        super.setAdminState(n);
    }

    protected void setConnAdminState(int n) throws AdminStateProvisioningError {
        this.bothCktNodesAdminState = false;
        if (this.dbgOn()) {
            this.debug("setConnAdminState() called on first node with " + NetAdminState.getAdminStateStringFromAdminState(n));
        }
        this.fstCircuitNode.setConnAdminState(n);
        super.setState(3);
        if (this.dbgOn()) {
            this.debug("setConnAdminState() called on second node with " + NetAdminState.getAdminStateStringFromAdminState(n));
        }
        this.secCircuitNode.setConnAdminState(n);
        this.bothCktNodesAdminState = true;
    }

    protected void revertAdminState() throws AdminStateProvisioningError {
        if (this.dbgOn()) {
            db.println("revertAdminState at " + this.getName());
        }
        this.fstCircuitNode.revertAdminState();
        if (this.bothCktNodesAdminState) {
            this.secCircuitNode.revertAdminState();
        }
        this.setState(2);
    }

    protected boolean inConnectionConversion() {
        if (this.getNodeModel().provides(Feature.ISTU) && this.fstCircuitNode.getConn() != null) {
            boolean bl = this.fstCircuitNode.getConn().inConnectionConversion();
            if (this.dbgOn()) {
                db.println("inConnectionConversion: DCN " + this.getName() + "state => " + bl);
            }
            if (bl) {
                return bl;
            }
            if (this.secCircuitNode.getConn() != null) {
                bl = this.secCircuitNode.getConn().inConnectionConversion();
                if (this.dbgOn()) {
                    db.println("inConnectionConversion: DCN " + this.getName() + "state => " + bl);
                }
                return bl;
            }
        }
        return false;
    }

    protected IConnectionConversionModel getConnectionConversionModel() {
        IConnectionConversionModel iConnectionConversionModel = null;
        IConnectionModel iConnectionModel = this.fstCircuitNode.getConn();
        if (iConnectionModel != null && iConnectionModel.inConnectionConversion()) {
            try {
                iConnectionConversionModel = iConnectionModel.getConnectionConversionModel();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                iConnectionConversionModel = null;
            }
        } else {
            iConnectionModel = this.secCircuitNode.getConn();
            if (iConnectionModel != null && iConnectionModel.inConnectionConversion()) {
                try {
                    iConnectionConversionModel = iConnectionModel.getConnectionConversionModel();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    iConnectionConversionModel = null;
                }
            }
        }
        return iConnectionConversionModel;
    }

    protected boolean inRoll() {
        return this.fstCircuitNode.inRoll() || this.secCircuitNode.inRoll();
    }

    protected Object getRollFromPath(IRollModel iRollModel) {
        if (this.fstCircuitNode.inRoll()) {
            this.fstCircuitNode.getRollFromPath(iRollModel);
        } else if (this.secCircuitNode.inRoll()) {
            this.secCircuitNode.getRollFromPath(iRollModel);
        }
        return null;
    }

    protected Object getRollToPath(IRollModel iRollModel) {
        if (this.fstCircuitNode.inRoll()) {
            this.fstCircuitNode.getRollToPath(iRollModel);
        } else if (this.secCircuitNode.inRoll()) {
            this.secCircuitNode.getRollToPath(iRollModel);
        }
        return null;
    }

    protected boolean isCompletedRollToPath(Object object, IRollModel iRollModel) {
        if (this.fstCircuitNode.inRoll()) {
            return this.fstCircuitNode.isCompletedRollToPath(object, iRollModel);
        }
        if (this.secCircuitNode.inRoll()) {
            return this.secCircuitNode.isCompletedRollToPath(object, iRollModel);
        }
        return false;
    }

    protected IRollModel getRoll() {
        if (this.fstCircuitNode.inRoll()) {
            return this.fstCircuitNode.getRoll();
        }
        if (this.secCircuitNode.inRoll()) {
            return this.secCircuitNode.getRoll();
        }
        return null;
    }

    private boolean isOchTrail() {
        return this.fstCircuitNode instanceof OchTrailTunnelNode && this.secCircuitNode instanceof OchncCircuitNode;
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }

    protected String prettyString(IPathDefModel iPathDefModel) {
        return this.fstCircuitNode != null ? this.fstCircuitNode.prettyString(iPathDefModel) + (this.secCircuitNode != null ? " AND " + this.secCircuitNode.prettyString(iPathDefModel) : "") : (this.secCircuitNode != null ? this.secCircuitNode.prettyString(iPathDefModel) : "");
    }
}

