/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.topo.INetElement;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;

public class HoCircuitEnd
extends NetCircuitEnd {
    private static SDebug db = new SDebug("HoCircuitEnd");

    public HoCircuitEnd() {
    }

    public HoCircuitEnd(INodeModel iNodeModel, ICircuitEnd iCircuitEnd) {
        super(iNodeModel, iCircuitEnd);
    }

    public HoCircuitEnd(INodeModel iNodeModel, IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum, boolean bl) {
        super(iNodeModel, iEntityModel, iHoNum, iLoNum, bl);
    }

    public HoCircuitEnd(INodeModel iNodeModel, IEntityModel iEntityModel, IHoLoNum iHoLoNum, boolean bl) {
        super(iNodeModel, iEntityModel, iHoLoNum, bl);
    }

    public HoCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        super(iNetCircuitEnd);
        this.setLoNum(null);
    }

    public HoCircuitEnd(INetElement iNetElement, Object object) {
        int n;
        IHoPathDefModel iHoPathDefModel;
        IHoNum iHoNum = null;
        int n2 = 0;
        INodeModel iNodeModel = iNetElement.getNodeModel();
        int n3 = 0;
        int n4 = 0;
        if (object instanceof IHoPathDefModel) {
            iHoPathDefModel = (IHoPathDefModel)object;
            n2 = iHoPathDefModel.getPool().getEntityIndex();
            iHoNum = HoPathDefModel.physicalHo(iHoPathDefModel);
            n3 = 4;
            n4 = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.VCAT) ? (int)iHoPathDefModel.getPathIdentifier() : 0;
        } else if (this.dbgOn()) {
            this.debug("Warning! NetCircuitEnd constructor unknown object type");
        }
        this.setCircuitEnd(new CircuitEnd(iNodeModel.getNodeId(), n2, iHoNum, null, false, n4));
        try {
            iHoPathDefModel = iNodeModel.getEntityTable().getEntityModelByIndex(n2);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            iHoPathDefModel = null;
        }
        if (iHoPathDefModel != null && ((n = iHoPathDefModel.getPayloadType()) == 8 || n == 14 || n == 13 || n == 17 || n == 18)) {
            this.setHoNum(null);
        }
        this.setStage(n3);
    }

    public Object getPathDef(short s) throws ObjNotFound {
        IPoolModel iPoolModel = this.getHoPool();
        if (iPoolModel == null) {
            throw new ObjNotFound("unable to get hoPool");
        }
        HoPathDefModel hoPathDefModel = new HoPathDefModel(iPoolModel, s, this.getRelativeHoNum(iPoolModel), (short)this.getPathIdentifier());
        return hoPathDefModel;
    }

    protected void createEtherBridge(ICircuitId iCircuitId, IVlanModel[] iVlanModelArray) throws CTCUserException, AbstractCmsIOException {
    }

    protected void destroyEtherBridge(ICircuitId iCircuitId) throws SanityCheckFailed {
    }

    protected void changeVlanSet(ICircuitId iCircuitId, IVlanModel[] iVlanModelArray) {
    }

    protected boolean changeVlanSetCheck(ICircuitId iCircuitId, IVlanModel[] iVlanModelArray) {
        return false;
    }

    protected boolean onXm() {
        if (Feature.provides((INodeModel)this.getNodeModel(), (Feature)Feature.DS3XM12)) {
            try {
                if (this.getEntityModel().onPortlessPort()) {
                    return true;
                }
            }
            catch (ObjNotFound objNotFound) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean usePairPortlessPorts(NetCircuitEnd netCircuitEnd) {
        if (this.getNodeId() != netCircuitEnd.getNodeId()) {
            return false;
        }
        if (!Feature.provides((INodeModel)this.getNodeModel(), (Feature)Feature.DS3XM12)) {
            return false;
        }
        try {
            if (this.dbgOn()) {
                this.debug("usePairPortlessPorts(" + netCircuitEnd.prettyString() + ")");
            }
            if (this.getEntityModel().onPairPortlessPorts(netCircuitEnd.getEntityModel())) {
                if (this.dbgOn()) {
                    this.debug("usePairPortlessPorts() => true");
                }
                return true;
            }
        }
        catch (ObjNotFound objNotFound) {
            // empty catch block
        }
        return false;
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }
}

