/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AdminStateOpt;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ConnCreateAttrs;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.DeleteInstead;
import cerent.cms.model.DriNodeTypeOpt;
import cerent.cms.model.DuplicateCircuit;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.IBridgePortInfo;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IDriNodeType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEtherBridgeModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoRollModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IRollModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.InsufficientBandwidth;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.NoMoreEtherBandwidth;
import cerent.cms.model.NoMoreEtherCircuit;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.NoMoreSpanningTree;
import cerent.cms.model.NoSuchCircuit;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchVlan;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathNotSupported;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SelectorAttrsOpt;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.model.VlanSpanningTreeViolation;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.EtherNodeDropCircuitEnd;
import cerent.cms.ncp.EtherP2PCircuitEnd;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.ncp.VlanStpSanityCheckFailed;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.MemberPrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.vlan.IoError;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.EnumStrings;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class HoCircuitNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("HoCircuitNode");
    private IHoConnectionModel hoConn;
    private List bridgeInfo;
    private Object bridgeInfoLockObject;
    private boolean ingressOnXm;

    public HoCircuitNode(INetElement iNetElement, HoCcatCircuit hoCcatCircuit) {
        super(iNetElement, hoCcatCircuit);
        this.connName = hoCcatCircuit.getCircuitName();
        this.cktId = new CircuitId(0, 0);
        this.serviceState = -2;
        this.bridgeInfoLockObject = new Object();
        this.bridgeInfo = null;
        this.pathWidth = hoCcatCircuit.getCircuitSizeObj().size2widthOfHoCircuit();
        this.ingressOnXm = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HoCircuitNode(INetElement iNetElement, HoCcatCircuit hoCcatCircuit, Object object) throws AbstractCmsObjectNotExistException {
        super(iNetElement, hoCcatCircuit, object);
        this.connName = this.getConnNameFromNE();
        this.driNodeType = this.getDriNodeTypeFromModelLayer();
        if (this.driNodeType == 1 || this.driNodeType == 2) {
            this.setDri(true);
        }
        if (this.dbgOn()) {
            db.println(" driNodeType " + EnumStrings.getString((Class)IDriNodeType.class, (int)this.driNodeType));
        }
        hoCcatCircuit.setChanged();
        this.bridgeInfoLockObject = new Object();
        this.bridgeInfo = null;
        this.pathWidth = hoCcatCircuit.getCircuitSizeObj().size2widthOfHoCircuit();
        this.ingressOnXm = false;
        Object object2 = this.entitiesLockObject;
        synchronized (object2) {
            this.updateUpsrEntities(true);
        }
    }

    protected void sanityCheckConnModel() {
        this.getConnTypeFromConnModel();
    }

    protected int getConnTypeFromConnModel() {
        IHoConnectionModel iHoConnectionModel = this.hoConn;
        if (iHoConnectionModel != null) {
            return iHoConnectionModel.getIntendedType();
        }
        return 20;
    }

    protected void setConnTypeInConnModel(int n) throws ConnectionTypeError, ConnectionInTopologyUpgrade, ConnectionInLoopback, ConnectionInTestAccess, ConnectionInRoll {
        if (this.hoConn != null) {
            if (this.dbgOn()) {
                db.println("changing intended type for HO connection");
            }
            this.hoConn.changeIntendedType(n);
        }
    }

    protected void addOutputToConnModel(NetCircuitEnd netCircuitEnd) throws CTCUserException {
        if (this.hoConn != null) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)((HoCircuitEnd)netCircuitEnd).getPathDef(this.pathWidth);
            this.hoConn.addOutput(iHoPathDefModel);
        }
    }

    protected void addOutputToConnModel(NetCircuitSpan netCircuitSpan) throws CTCUserException {
        if (this.hoConn != null) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)netCircuitSpan.getPathDef(this.getNetElement(), this.pathWidth);
            this.hoConn.addOutput(iHoPathDefModel);
        }
    }

    protected void removeOutputFromConnModel(NetCircuitEnd netCircuitEnd) throws InvalidPath, DeleteInstead, ConnectionTypeError, ObjNotFound {
        if (this.hoConn != null) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)((HoCircuitEnd)netCircuitEnd).getPathDef(this.pathWidth);
            this.hoConn.removeOutput(iHoPathDefModel);
        }
    }

    protected void removeOutputFromConnModel(NetCircuitSpan netCircuitSpan) throws InvalidPath, DeleteInstead, ConnectionTypeError, ObjNotFound, PathInUse, NoMoreLoCapableHo {
        if (this.hoConn != null) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)netCircuitSpan.getPathDef(this.getNetElement(), this.pathWidth);
            this.hoConn.removeOutput(iHoPathDefModel);
        }
    }

    protected List getOrderedPathDefs(int n) throws CTCUserException {
        Object object;
        int n2 = this.countNumInputs();
        int n3 = this.countNumOutputs();
        int n4 = this.countNumOmniSpans();
        ArrayList<IHoPathDefModel> arrayList = new ArrayList<IHoPathDefModel>();
        ArrayList<IHoPathDefModel> arrayList2 = new ArrayList<IHoPathDefModel>();
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitEnd)iterator.next();
            arrayList.add((IHoPathDefModel)((NetCircuitEnd)object).getPathDef(this.pathWidth));
        }
        iterator = this.drops.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitEnd)iterator.next();
            arrayList2.add((IHoPathDefModel)((NetCircuitEnd)object).getPathDef(this.pathWidth));
        }
        iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitSpan)iterator.next();
            if (this.findRoutingDir((NetCircuitSpan)object) == eSpanDirection.ORIGINATING) {
                arrayList2.add((IHoPathDefModel)((NetCircuitSpan)object).getPathDef(this.getNetElement(), this.pathWidth));
                continue;
            }
            if (this.findRoutingDir((NetCircuitSpan)object) != eSpanDirection.TERMINATING) continue;
            arrayList.add((IHoPathDefModel)((NetCircuitSpan)object).getPathDef(this.getNetElement(), this.pathWidth));
        }
        iterator = this.inSpans.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitSpan)iterator.next();
            arrayList.add((IHoPathDefModel)((NetCircuitSpan)object).getPathDef(this.getNetElement(), this.pathWidth));
        }
        iterator = this.outSpans.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitSpan)iterator.next();
            arrayList2.add((IHoPathDefModel)((NetCircuitSpan)object).getPathDef(this.getNetElement(), this.pathWidth));
        }
        if (this.dbgOn()) {
            this.debug("getOrderedPathDefs: in => " + arrayList.size() + ", out => " + arrayList2.size());
        }
        object = new LinkedList();
        if (n == 0) {
            ((LinkedList)object).add(arrayList.get(0));
            ((LinkedList)object).add(arrayList2.get(0));
        } else if (n == 1) {
            ((LinkedList)object).add(arrayList.get(0));
            ((LinkedList)object).add(arrayList2.get(0));
        } else if (n == 2) {
            if (arrayList.size() == 2) {
                ((LinkedList)object).add(arrayList.get(0));
                ((LinkedList)object).add(arrayList.get(1));
                ((LinkedList)object).add(arrayList2.get(0));
            } else if (arrayList2.size() == 2) {
                ((LinkedList)object).add(arrayList2.get(0));
                ((LinkedList)object).add(arrayList2.get(1));
                ((LinkedList)object).add(arrayList.get(0));
            } else if (this.dbgOn()) {
                this.debug("calculateOrderedPathList: WARNING - bad UPSR case");
            }
        } else if (n == 3) {
            ((LinkedList)object).add(arrayList.get(0));
            ((LinkedList)object).add(arrayList.get(1));
            ((LinkedList)object).add(arrayList2.get(0));
            ((LinkedList)object).add(arrayList2.get(1));
        } else if (n == 4) {
            ((LinkedList)object).add(arrayList2.get(0));
            ((LinkedList)object).add(arrayList2.get(1));
            ((LinkedList)object).add(arrayList.get(0));
        } else if (n == 6) {
            ((LinkedList)object).add(arrayList.get(0));
            ((LinkedList)object).add(arrayList.get(1));
            ((LinkedList)object).add(arrayList2.get(0));
            if (arrayList2.size() == 2) {
                ((LinkedList)object).add(arrayList2.get(1));
            }
        }
        return object;
    }

    protected Object[] getPathsFromConnModel() {
        IHoConnectionModel iHoConnectionModel = this.hoConn;
        if (iHoConnectionModel != null) {
            Object[] objectArray = iHoConnectionModel.getPaths();
            IRollModel iRollModel = this.getRoll();
            if (iRollModel == null) {
                if (this.dbgOn()) {
                    db.println("the connection is NOT involved in the roll");
                }
                return objectArray;
            }
            if (this.dbgOn()) {
                db.println("the connection is involved in the roll");
            }
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = this.isCompletedRollToPath(objectArray[i], iRollModel) ? this.getRollFromPath(iRollModel) : objectArray[i];
            }
            return objectArray2;
        }
        if (this.dbgOn()) {
            db.println("getPathsFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return new LinkedList().toArray();
    }

    protected Object[] getActivePathsFromConnModel() {
        IHoConnectionModel iHoConnectionModel = this.hoConn;
        if (iHoConnectionModel != null) {
            return iHoConnectionModel.getActivePaths();
        }
        if (this.dbgOn()) {
            db.println("getActivePathsFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return new LinkedList().toArray();
    }

    protected int getProtectionOpFromConnModel() {
        IHoConnectionModel iHoConnectionModel = this.hoConn;
        if (iHoConnectionModel != null) {
            return iHoConnectionModel.getProtectionOp();
        }
        if (this.dbgOn()) {
            db.println("getProtectionOpFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return -1;
    }

    protected int getReverseProtectionOpFromConnModel() {
        IHoConnectionModel iHoConnectionModel = this.hoConn;
        if (iHoConnectionModel != null) {
            return iHoConnectionModel.getReverseProtectionOp();
        }
        if (this.dbgOn()) {
            db.println("getProtectionOpFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return -1;
    }

    protected boolean hasP2pEtherCktEnd() {
        Iterator iterator = this.sources.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                HoCircuitEnd hoCircuitEnd = (HoCircuitEnd)iterator.next();
                if (!hoCircuitEnd.isEtherP2PCircuitEnd()) continue;
                return true;
            }
            iterator = this.drops.iterator();
        }
        return false;
    }

    private List getP2pEtherCktEnd() {
        LinkedList<HoCircuitEnd> linkedList = new LinkedList<HoCircuitEnd>();
        Iterator iterator = this.sources.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                HoCircuitEnd hoCircuitEnd = (HoCircuitEnd)iterator.next();
                if (!hoCircuitEnd.isEtherP2PCircuitEnd()) continue;
                linkedList.add(hoCircuitEnd);
            }
            iterator = this.drops.iterator();
        }
        return linkedList;
    }

    public boolean eligibleForEtherHoDropAdd() {
        return this.getConnectionType() == 8 && this.biSpans.size() + this.drops.size() < 2;
    }

    public int totalSpans() {
        return this.inSpans.size() + this.outSpans.size() + this.biSpans.size();
    }

    protected int findUpgradedConnType() {
        if (this.dbgOn()) {
            db.println("finding upgraded connection type for Node " + this.getName());
        }
        if (this.circuit.isBidirectional()) {
            if (this.biSpans.size() > 2) {
                return 20;
            }
            if (this.nodeDrop != null) {
                return 8;
            }
            return this.getConnectionType();
        }
        int n = this.countRoutedOutputs();
        if (this.getConnectionType() == 1 && n > 0) {
            return 6;
        }
        return this.getConnectionType();
    }

    protected int findBiDirectionalConnType() {
        int n = this.countNumInputs();
        int n2 = this.countNumOutputs();
        int n3 = n + n2;
        if (this.nodeDrop != null && this.circuit.getCircuitTypeObj().isEthernetCircuitType()) {
            if (n3 > 2) {
                return 20;
            }
            if (n3 == 0 && this.circuit.getCktNodeListSize() != 1) {
                return 20;
            }
            return 8;
        }
        return super.findBiDirectionalConnType();
    }

    protected boolean validateBiDirectionalConn() {
        int n = this.countNumInputs();
        int n2 = this.countNumOutputs();
        int n3 = n + n2;
        if (this.nodeDrop != null && this.circuit.getCircuitTypeObj().isEthernetCircuitType()) {
            if (n3 > 2) {
                return false;
            }
            if (n3 == 2 && n != 1) {
                return false;
            }
            if (n3 == 0) {
                return this.circuit.getCktNodeListSize() == 1;
            }
            return true;
        }
        return super.validateBiDirectionalConn();
    }

    protected void modifyConnection() throws CircuitProvError {
        if (this.dbgOn()) {
            db.println("modifyConnection @ Node " + this.getName());
        }
        this.modifyConnectionType();
        this.modifyConnectionDropsAndSpans();
        if (this.getConnectionType() == 8 && this.nodeDrop != null && this.nodeDrop.getStage() == 2) {
            boolean bl = false;
            try {
                ((HoCircuitEnd)this.nodeDrop).createEtherBridge(this.cktId, this.circuit.getVlans());
            }
            catch (CTCUserException cTCUserException) {
                bl = true;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                bl = true;
            }
            if (bl) {
                block8: {
                    try {
                        this.deleteNodeDrop();
                    }
                    catch (DeletionError deletionError) {
                        if (!this.dbgOn()) break block8;
                        db.println("unable to reverse, circuit state may be incorrect due to " + deletionError.getMessage());
                    }
                }
                this.setState(2);
                throw new CircuitProvError("Unable to assign VLANs to circuit at " + this.getName());
            }
            this.nodeDrop.setStage(3);
        }
        this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans() + (this.onXm() ? 1 : 0);
        this.setState(2);
    }

    protected void destroyConnection() throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, DeletionError {
        try {
            this.destroyEtherBridgeCkt();
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            throw new DeletionError(sanityCheckFailed.toString());
        }
        super.destroyConnection();
    }

    private void destroyEtherBridgeCkt() throws SanityCheckFailed {
        if (this.hoConn == null) {
            return;
        }
        try {
            if (this.getConnTypeFromConnModel() != 8 && !this.hoConn.isUnstitchedEthernet()) {
                return;
            }
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            return;
        }
        if (this.nodeDrop != null) {
            ((HoCircuitEnd)this.nodeDrop).destroyEtherBridge(this.cktId);
        }
        Iterator iterator = this.getP2pEtherCktEnd().iterator();
        while (iterator.hasNext()) {
            EtherP2PCircuitEnd etherP2PCircuitEnd = (EtherP2PCircuitEnd)iterator.next();
            etherP2PCircuitEnd.destroyEtherBridge(this.cktId);
        }
    }

    protected void destroyCrossConnection() throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup {
        block6: {
            if (this.hoConn != null) {
                if (this.dbgOn()) {
                    db.println("destroyCrossConnection(" + this.getName() + "): destroy hoConn");
                }
                try {
                    if (this.getNodeModel().provides(Feature.FORCE_DESTROY)) {
                        this.hoConn.localDestroy(true);
                    } else {
                        this.hoConn.localDestroy();
                    }
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    if (!this.dbgOn()) break block6;
                    db.println("hoConn already deleted");
                }
            }
        }
        this.updateConnectionPathEnds(new LinkedList());
    }

    protected void createConnection() throws CircuitProvError {
        this.setConnectionType(this.findConnType());
        if (this.getConnectionType() == 20) {
            if (this.dbgOn()) {
                db.println("Warning! createConnection at " + this.getName() + " connection type is unknown");
            }
            throw new CircuitProvError("Invalid connection type at " + this.getName());
        }
        this.cktId = this.circuit.getCircuitId();
        this.connName = this.circuit.getCircuitName();
        if (this.dbgOn()) {
            this.debug("createConnection(" + this.getName() + ")" + "; connType=" + EnumStrings.getString((Class)IConnectionType.class, (int)this.getConnectionType()) + "; cktId=" + NetCcatCircuit.prettyString(this.cktId));
        }
        ICircuitType iCircuitType = this.circuit.getCircuitTypeObj();
        try {
            if (iCircuitType.isHoCircuitType() || iCircuitType.isTunnelCircuitType() || iCircuitType.isLAPCircuitType()) {
                this.createConnection(this.cktId);
            } else if (iCircuitType.isEthernetCircuitType()) {
                this.createEtherConnection(this.cktId);
            }
        }
        catch (CTCUserException cTCUserException) {
            if (this.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            String string = "Unable to create connection at " + this.getName();
            if (cTCUserException instanceof NoMoreLoCapableHo) {
                string = string + "\n- " + this.getNoLoCapableHoMessage();
            } else if (cTCUserException instanceof PathInUse) {
                string = string + "\n- Path already in use";
            } else if (cTCUserException instanceof InsufficientBandwidth) {
                string = string + "\n- Insufficient Bandwidth";
            } else if (cTCUserException instanceof PathNotSupported) {
                string = string + "\n- Path Not Supported";
            } else if (cTCUserException instanceof InvalidState) {
                string = string + "\n- Invalid Admin State";
            } else if (cTCUserException instanceof ProvisionError) {
                string = string + "\n" + ((ProvisionError)((Object)cTCUserException)).getEIDMsg();
            }
            throw new CircuitProvError(string);
        }
        catch (AdminStateProvisioningError adminStateProvisioningError) {
            if (this.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)adminStateProvisioningError);
            }
            String string = "Unable to create connection at " + this.getName();
            string = string + "\n" + adminStateProvisioningError.getMessage();
            throw new CircuitProvError(string);
        }
        if (this.hoConn == null) {
            if (this.dbgOn()) {
                db.println("Connection Models returned NULL connection ");
            }
            throw new CircuitProvError("Error while creating connection object at " + this.getName());
        }
        this.addConnectionObserver();
        this.setState(1);
        this.setCreateStage(3);
        this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans() + (this.onXm() ? 1 : 0);
        this.updateConnectionPathEnds(this.getPathEndsFromPathDefs(this.getConnectionPathDefs()));
    }

    protected String prettyString(IPathDefModel iPathDefModel) {
        IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)iPathDefModel;
        int n = iHoPathDefModel.getPool().getEntityIndex();
        short s = 0;
        if (this.getNodeModel().provides(Feature.VCAT)) {
            s = iHoPathDefModel.getPathIdentifier();
        }
        return this.getName() + "::" + Integer.toHexString(n) + "::" + HoPathDefModel.physicalHo(iHoPathDefModel) + "::" + s;
    }

    protected String prettyString(IHoPathDefModel iHoPathDefModel) {
        int n = iHoPathDefModel.getPool().getEntityIndex();
        IHoNum iHoNum = HoPathDefModel.physicalHo(iHoPathDefModel);
        short s = 0;
        if (iHoPathDefModel.getNodeModel().provides(Feature.VCAT)) {
            s = iHoPathDefModel.getPathIdentifier();
        }
        return this.getName() + "::" + Integer.toHexString(n) + "::" + iHoNum + "::null::" + s;
    }

    protected void prettyPrint(IHoPathDefModel[] iHoPathDefModelArray, String string) {
        for (int i = 0; i < iHoPathDefModelArray.length; ++i) {
            if (!this.dbgOn()) continue;
            this.debug(string + " HoPath #" + i + " " + this.prettyString(iHoPathDefModelArray[i]));
        }
    }

    protected void createConn(ICircuitId iCircuitId, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, int n2, ArrayList arrayList4, ArrayList arrayList5) throws CircuitProvError, InvalidPath, PathInUse, CTCUserException, InsufficientBandwidth, NoMoreLoCapableHo, ConnectionTypeError, ObjNotFound, InvalidState, AdminStateProvisioningError {
        this.prettyPrint(arrayList.toArray(new IHoPathDefModel[0]), "input");
        this.prettyPrint(arrayList2.toArray(new IHoPathDefModel[0]), "output");
        this.prettyPrint(arrayList3.toArray(new IHoPathDefModel[0]), "omni");
        IHoPathDefModel[][] iHoPathDefModelArrayArray = new IHoPathDefModel[][]{arrayList.toArray(new IHoPathDefModel[0]), arrayList2.toArray(new IHoPathDefModel[0]), arrayList3.toArray(new IHoPathDefModel[0])};
        int[] nArray = new int[arrayList4.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList4.get(i);
        }
        boolean[] blArray = new boolean[arrayList5.size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = (Boolean)arrayList5.get(i);
        }
        this.hoConn = this.createHoConnOnNE(iCircuitId, iHoPathDefModelArrayArray, n, n2, nArray, blArray);
        if (this.hoConn == null) {
            return;
        }
        if (this.circuit.getVlans().length == 0) {
            return;
        }
        Iterator iterator = this.getP2pEtherCktEnd().iterator();
        while (iterator.hasNext()) {
            String string;
            block17: {
                EtherP2PCircuitEnd etherP2PCircuitEnd = (EtherP2PCircuitEnd)iterator.next();
                boolean bl = this.circuit.createWithStpEnabled();
                if (this.dbgOn()) {
                    db.println("creating circuit with STP " + (bl ? "enabled" : "disabled"));
                }
                boolean bl2 = false;
                string = "";
                try {
                    if (bl) {
                        etherP2PCircuitEnd.createEtherBridge(iCircuitId, this.circuit.getVlans());
                        this.enableSpanningTree();
                    } else {
                        etherP2PCircuitEnd.createEtherBridge(iCircuitId, new IVlanModel[0]);
                        this.hoConn.setStpEnabled(false);
                        etherP2PCircuitEnd.changeVlanSet(iCircuitId, this.circuit.getVlans());
                    }
                }
                catch (NoMoreEtherCircuit noMoreEtherCircuit) {
                    bl2 = true;
                    string = noMoreEtherCircuit.getPrettyMessage();
                }
                catch (NoMoreSpanningTree noMoreSpanningTree) {
                    bl2 = true;
                    string = noMoreSpanningTree.getPrettyMessage();
                }
                catch (NoSuchVlan noSuchVlan) {
                    bl2 = true;
                    string = noSuchVlan.getPrettyMessage();
                }
                catch (VlanSpanningTreeViolation vlanSpanningTreeViolation) {
                    bl2 = true;
                    string = vlanSpanningTreeViolation.getPrettyMessage();
                }
                catch (DuplicateCircuit duplicateCircuit) {
                    bl2 = true;
                    string = duplicateCircuit.getPrettyMessage();
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    bl2 = true;
                    string = "CTC comm failure";
                }
                if (!bl2) continue;
                try {
                    this.destroyCrossConnection();
                }
                catch (CTCUserException cTCUserException) {
                    if (!this.dbgOn()) break block17;
                    db.println("Exception while destroying a connection");
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
            }
            throw new CircuitProvError("Ethernet bridge creation failure at " + this.getName() + "\n " + string);
        }
    }

    private void enableSpanningTree() throws NoMoreSpanningTree, VlanSpanningTreeViolation {
        if (this.hoConn == null) {
            return;
        }
        String string = this.hoConn.getNodeModel().getSwVersion();
        if (this.dbgOn()) {
            this.debug("NE has version " + string + " at " + this.getName());
        }
        if (string.charAt(0) == '0' && string.charAt(1) < '5') {
            return;
        }
        if (this.dbgOn()) {
            this.debug("Enabling spanning tree at " + this.getName());
        }
        this.hoConn.setStpEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IHoConnectionModel createHoConnOnNE(ICircuitId iCircuitId, IHoPathDefModel[][] iHoPathDefModelArray, int n, int n2, int[] nArray, boolean[] blArray) throws CircuitProvError, InvalidPath, PathInUse, CTCUserException, ConnectionTypeError, ObjNotFound, InvalidState, InsufficientBandwidth, AdminStateProvisioningError {
        IHoPathDefModel[] iHoPathDefModelArray2 = iHoPathDefModelArray[0];
        IHoPathDefModel[] iHoPathDefModelArray3 = iHoPathDefModelArray[1];
        IHoPathDefModel[] iHoPathDefModelArray4 = iHoPathDefModelArray[2];
        IHoPathDefModel[] iHoPathDefModelArray5 = null;
        IConnectionModels iConnectionModels = this.getNodeModel().getConnectionModels();
        if (this.dbgOn()) {
            db.println("createHoConnOnNE:connType=" + EnumStrings.getString((Class)IConnectionType.class, (int)this.getConnectionType()) + " numIn: " + n + " numOut: " + n2 + " numOmni: " + iHoPathDefModelArray4.length + " (" + this.getName() + ")");
        }
        int n3 = this.getConnectionType();
        INetElement iNetElement = this.getNetElement();
        if (!iNetElement.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL) && 0 != this.getAdminState()) {
            db.info("PreOdin node " + this.getName() + " does not support admin state provisioning");
            throw new AdminStateProvisioningError("Node " + this.getName() + " does not support circuit state " + this.translateAdminState(this.getAdminState()) + ": use " + this.translateAdminState(0));
        }
        AdminStateOpt adminStateOpt = new AdminStateOpt();
        adminStateOpt.setAdminState(this.getAdminState());
        ConnCreateAttrs connCreateAttrs = new ConnCreateAttrs();
        connCreateAttrs.setCktName(this.connName);
        connCreateAttrs.setAdminStateOpt(adminStateOpt);
        connCreateAttrs.setSelectorAttrsOpt(null);
        DriNodeTypeOpt driNodeTypeOpt = new DriNodeTypeOpt(this.driNodeType);
        connCreateAttrs.setDriNodeTypeOpt(driNodeTypeOpt);
        Map map = TL1ObjectManager.instance().getTL1Conns();
        synchronized (map) {
            block73: {
                block88: {
                    block87: {
                        block86: {
                            block85: {
                                block84: {
                                    block81: {
                                        block82: {
                                            block74: {
                                                block83: {
                                                    block80: {
                                                        block79: {
                                                            block78: {
                                                                block77: {
                                                                    block76: {
                                                                        block75: {
                                                                            int n4;
                                                                            NetCircuitSpan netCircuitSpan;
                                                                            if (n3 != 0) break block75;
                                                                            int n5 = 1 + iHoPathDefModelArray3.length + iHoPathDefModelArray4.length;
                                                                            iHoPathDefModelArray5 = new IHoPathDefModel[n5];
                                                                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                                            if (iHoPathDefModelArray3.length == 2 && (netCircuitSpan = this.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray3[1])) != null && netCircuitSpan.getBlsrDriInterConnect()) {
                                                                                IHoPathDefModel iHoPathDefModel = iHoPathDefModelArray3[1];
                                                                                iHoPathDefModelArray3[1] = iHoPathDefModelArray3[0];
                                                                                iHoPathDefModelArray3[0] = iHoPathDefModel;
                                                                            }
                                                                            for (n4 = 0; n4 < iHoPathDefModelArray3.length; ++n4) {
                                                                                iHoPathDefModelArray5[n4 + 1] = iHoPathDefModelArray3[n4];
                                                                            }
                                                                            for (n4 = 0; n4 < iHoPathDefModelArray4.length; ++n4) {
                                                                                iHoPathDefModelArray5[n4 + iHoPathDefModelArray3.length + 1] = iHoPathDefModelArray4[n4];
                                                                            }
                                                                            break block73;
                                                                        }
                                                                        if (n3 != 9) break block76;
                                                                        int n6 = 1 + iHoPathDefModelArray3.length;
                                                                        iHoPathDefModelArray5 = new IHoPathDefModel[n6];
                                                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                                        for (int i = 0; i < iHoPathDefModelArray3.length; ++i) {
                                                                            iHoPathDefModelArray5[i + 1] = iHoPathDefModelArray3[i];
                                                                        }
                                                                        break block73;
                                                                    }
                                                                    if (n3 != 1) break block77;
                                                                    iHoPathDefModelArray5 = new IHoPathDefModel[2];
                                                                    if (iHoPathDefModelArray4.length == 2) {
                                                                        if (this.dbgOn()) {
                                                                            db.println("DRI circuit: invoking createTwoWay");
                                                                        }
                                                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray4[0];
                                                                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[1];
                                                                        break block73;
                                                                    } else {
                                                                        if (this.dbgOn()) {
                                                                            this.debug("InputPathWidth=" + iHoPathDefModelArray2[0].getPathWidth() + ", OutputPathWidth=" + iHoPathDefModelArray3[0].getPathWidth() + " (" + this.getName() + ")");
                                                                        }
                                                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                                        iHoPathDefModelArray5[1] = iHoPathDefModelArray3[0];
                                                                    }
                                                                    break block73;
                                                                }
                                                                if (n3 != 2) break block78;
                                                                SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                                                selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                                                                connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                                                iHoPathDefModelArray5 = new IHoPathDefModel[3];
                                                                MemberPrefs memberPrefs = this.circuit.getMemberPrefs();
                                                                if (memberPrefs.isBlsrDriNode(this.getNetElement())) {
                                                                    if (iHoPathDefModelArray2.length == 2) {
                                                                        this.arrangePathDefsForBlsrDri((IPathDefModel[])iHoPathDefModelArray2);
                                                                    } else if (iHoPathDefModelArray3.length == 2) {
                                                                        this.arrangePathDefsForBlsrDri((IPathDefModel[])iHoPathDefModelArray3);
                                                                    }
                                                                }
                                                                if (n == 2) {
                                                                    iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                                    iHoPathDefModelArray5[1] = iHoPathDefModelArray2[1];
                                                                    iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                                                                    break block73;
                                                                } else {
                                                                    if (n2 != 2) {
                                                                        if (!this.dbgOn()) return null;
                                                                        db.println("Warning! createHoConnection: bad UPSR case");
                                                                        return null;
                                                                    }
                                                                    iHoPathDefModelArray5[0] = iHoPathDefModelArray3[0];
                                                                    iHoPathDefModelArray5[1] = iHoPathDefModelArray3[1];
                                                                    iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                                                                }
                                                                break block73;
                                                            }
                                                            if (n3 != 4) break block79;
                                                            iHoPathDefModelArray5 = new IHoPathDefModel[]{iHoPathDefModelArray3[0], iHoPathDefModelArray3[1], iHoPathDefModelArray2[0]};
                                                            break block73;
                                                        }
                                                        if (n3 != 3) break block80;
                                                        SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                                        selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                                                        connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                                        iHoPathDefModelArray5 = new IHoPathDefModel[]{iHoPathDefModelArray2[0], iHoPathDefModelArray2[1], iHoPathDefModelArray3[0], iHoPathDefModelArray3[1]};
                                                        break block73;
                                                    }
                                                    if (n3 != 6) break block81;
                                                    SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                                    selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                                                    connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                                    MemberPrefs memberPrefs = this.circuit.getMemberPrefs();
                                                    if (memberPrefs.isBlsrDriNode(this.getNetElement())) {
                                                        if (iHoPathDefModelArray2.length == 2) {
                                                            this.arrangePathDefsForBlsrDri((IPathDefModel[])iHoPathDefModelArray2);
                                                        } else if (iHoPathDefModelArray3.length == 2) {
                                                            this.arrangePathDefsForBlsrDri((IPathDefModel[])iHoPathDefModelArray3);
                                                        }
                                                    }
                                                    int n7 = 2 + iHoPathDefModelArray3.length;
                                                    iHoPathDefModelArray5 = new IHoPathDefModel[n7];
                                                    if (iHoPathDefModelArray4.length <= 0) break block82;
                                                    if (iHoPathDefModelArray4.length != 2) break block83;
                                                    if (blArray[1] && !blArray[0]) {
                                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[1];
                                                        for (int i = 0; i < iHoPathDefModelArray3.length; ++i) {
                                                            iHoPathDefModelArray5[2 + i] = iHoPathDefModelArray3[i];
                                                        }
                                                        break block74;
                                                    } else if (blArray[0] && !blArray[1]) {
                                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                                        for (int i = 0; i < iHoPathDefModelArray3.length; ++i) {
                                                            iHoPathDefModelArray5[2 + i] = iHoPathDefModelArray3[i];
                                                        }
                                                        break block74;
                                                    } else {
                                                        if (!this.dbgOn()) return null;
                                                        db.println("Error: Both omnispans cannot be in the source ring");
                                                        return null;
                                                    }
                                                }
                                                iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                                iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                                for (int i = 0; i < iHoPathDefModelArray3.length; ++i) {
                                                    iHoPathDefModelArray5[2 + i] = iHoPathDefModelArray3[i];
                                                }
                                            }
                                            if (this.dbgOn()) {
                                                db.println("Unidir DRI circuit: UPSR_DC");
                                            }
                                            break block73;
                                        }
                                        if (nArray.length == 2 && nArray[0] > nArray[1]) {
                                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[1];
                                            iHoPathDefModelArray5[1] = iHoPathDefModelArray2[0];
                                            for (int i = 0; i < iHoPathDefModelArray3.length; ++i) {
                                                iHoPathDefModelArray5[2 + i] = iHoPathDefModelArray3[i];
                                            }
                                            break block73;
                                        } else {
                                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                            iHoPathDefModelArray5[1] = iHoPathDefModelArray2[1];
                                            for (int i = 0; i < iHoPathDefModelArray3.length; ++i) {
                                                iHoPathDefModelArray5[2 + i] = iHoPathDefModelArray3[i];
                                            }
                                        }
                                        break block73;
                                    }
                                    if (n3 != 10) break block84;
                                    if (this.dbgOn()) {
                                        db.println("createUpsrDri(), omniSize=" + iHoPathDefModelArray4.length + " inSize=" + iHoPathDefModelArray2.length + " outSize=" + iHoPathDefModelArray3.length);
                                    }
                                    SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                    selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                                    connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                    iHoPathDefModelArray5 = new IHoPathDefModel[3];
                                    MemberPrefs memberPrefs = this.circuit.getMemberPrefs();
                                    if (memberPrefs.isBlsrDriNode(this.getNetElement())) {
                                        NetCircuitSpan netCircuitSpan = this.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray2[0]);
                                        if (netCircuitSpan.getBlsrDriInterConnect()) {
                                            iHoPathDefModelArray5[0] = iHoPathDefModelArray3[0];
                                            iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                            iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                                            break block73;
                                        } else {
                                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                            iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                            iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                                        }
                                        break block73;
                                    } else if (!blArray[0]) {
                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray3[0];
                                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                        iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                                        break block73;
                                    } else {
                                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                        iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                                    }
                                    break block73;
                                }
                                if (n3 != 11) break block85;
                                if (this.dbgOn()) {
                                    db.println("invoking createUpsrIdri()");
                                }
                                SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                                connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                iHoPathDefModelArray5 = new IHoPathDefModel[4];
                                if (blArray[1] && !blArray[0]) {
                                    iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                    iHoPathDefModelArray5[1] = iHoPathDefModelArray4[1];
                                    iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                                    iHoPathDefModelArray5[3] = iHoPathDefModelArray4[0];
                                    break block73;
                                } else if (blArray[0] && !blArray[1]) {
                                    iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                    iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                                    iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                                    iHoPathDefModelArray5[3] = iHoPathDefModelArray4[1];
                                    break block73;
                                } else {
                                    if (!this.dbgOn()) return null;
                                    db.println("Error: Both omnispans cannot be in the source ring");
                                    return null;
                                }
                            }
                            if (n3 != 13) break block86;
                            if (this.dbgOn()) {
                                db.println("creating BLSR_IDRI connection");
                            }
                            SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                            selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                            connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                            iHoPathDefModelArray5 = new IHoPathDefModel[4];
                            NetCircuitSpan netCircuitSpan = this.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray2[0]);
                            if (netCircuitSpan != null && netCircuitSpan.getBlsrDriInterConnect()) {
                                iHoPathDefModelArray5[0] = iHoPathDefModelArray2[1];
                                iHoPathDefModelArray5[3] = iHoPathDefModelArray2[0];
                            } else {
                                iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                                iHoPathDefModelArray5[3] = iHoPathDefModelArray2[1];
                            }
                            netCircuitSpan = this.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray3[1]);
                            if (netCircuitSpan != null && netCircuitSpan.getBlsrDriInterConnect()) {
                                iHoPathDefModelArray5[1] = iHoPathDefModelArray3[1];
                                iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                                break block73;
                            } else {
                                iHoPathDefModelArray5[1] = iHoPathDefModelArray3[0];
                                iHoPathDefModelArray5[2] = iHoPathDefModelArray3[1];
                            }
                            break block73;
                        }
                        if (n3 != 15) break block87;
                        if (this.dbgOn()) {
                            db.println("creating BLSR_DC connection");
                        }
                        SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                        selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                        connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                        iHoPathDefModelArray5 = new IHoPathDefModel[4];
                        NetCircuitSpan netCircuitSpan = this.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray2[0]);
                        if (netCircuitSpan == null && this.dbgOn()) {
                            db.println("null span ");
                        }
                        if (netCircuitSpan != null && netCircuitSpan.getBlsrDriInterConnect()) {
                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[1];
                            iHoPathDefModelArray5[3] = iHoPathDefModelArray2[0];
                        } else {
                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                            iHoPathDefModelArray5[3] = iHoPathDefModelArray2[1];
                        }
                        netCircuitSpan = this.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray3[0]);
                        if (netCircuitSpan != null && netCircuitSpan.getBlsrDriInterConnect()) {
                            iHoPathDefModelArray5[1] = iHoPathDefModelArray3[0];
                            iHoPathDefModelArray5[2] = iHoPathDefModelArray3[1];
                            break block73;
                        } else {
                            iHoPathDefModelArray5[1] = iHoPathDefModelArray3[1];
                            iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                        }
                        break block73;
                    }
                    if (n3 != 14) break block88;
                    if (this.dbgOn()) {
                        db.println("creating UPSR_BLSR_IDRI connection");
                    }
                    SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                    selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                    connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                    iHoPathDefModelArray5 = new IHoPathDefModel[4];
                    if (iHoPathDefModelArray2.length == 2) {
                        NetCircuitSpan netCircuitSpan = this.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray2[0]);
                        if (netCircuitSpan.getBlsrDriInterConnect()) {
                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[1];
                            iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                            iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                            iHoPathDefModelArray5[3] = iHoPathDefModelArray2[0];
                            break block73;
                        } else {
                            iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                            iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                            iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                            iHoPathDefModelArray5[3] = iHoPathDefModelArray2[1];
                        }
                        break block73;
                    } else {
                        NetCircuitSpan netCircuitSpan = this.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray3[0]);
                        if (netCircuitSpan.getBlsrDriInterConnect()) {
                            iHoPathDefModelArray5[0] = iHoPathDefModelArray3[1];
                            iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                            iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                            iHoPathDefModelArray5[3] = iHoPathDefModelArray3[0];
                            break block73;
                        } else {
                            iHoPathDefModelArray5[0] = iHoPathDefModelArray3[0];
                            iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                            iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                            iHoPathDefModelArray5[3] = iHoPathDefModelArray3[1];
                        }
                    }
                    break block73;
                }
                if (n3 != 16) {
                    if (!this.dbgOn()) return null;
                    db.println("Circuit Node: createHoConnection Unknown connection type " + this.getConnectionType());
                    return null;
                }
                if (this.dbgOn()) {
                    db.println("creating UPSR_BLSR_DC connection");
                }
                SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                iHoPathDefModelArray5 = new IHoPathDefModel[4];
                if (iHoPathDefModelArray2.length == 2) {
                    NetCircuitSpan netCircuitSpan = this.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray2[0]);
                    if (netCircuitSpan.getBlsrDriInterConnect()) {
                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[1];
                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                        iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                        iHoPathDefModelArray5[3] = iHoPathDefModelArray2[0];
                    } else {
                        iHoPathDefModelArray5[0] = iHoPathDefModelArray2[0];
                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                        iHoPathDefModelArray5[2] = iHoPathDefModelArray3[0];
                        iHoPathDefModelArray5[3] = iHoPathDefModelArray2[1];
                    }
                } else {
                    NetCircuitSpan netCircuitSpan = this.getSpanFromPathDef((IPathDefModel)iHoPathDefModelArray3[0]);
                    if (netCircuitSpan.getBlsrDriInterConnect()) {
                        iHoPathDefModelArray5[0] = iHoPathDefModelArray3[1];
                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                        iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                        iHoPathDefModelArray5[3] = iHoPathDefModelArray3[0];
                    } else {
                        iHoPathDefModelArray5[0] = iHoPathDefModelArray3[0];
                        iHoPathDefModelArray5[1] = iHoPathDefModelArray4[0];
                        iHoPathDefModelArray5[2] = iHoPathDefModelArray2[0];
                        iHoPathDefModelArray5[3] = iHoPathDefModelArray3[1];
                    }
                }
            }
            this.prettyPrint(iHoPathDefModelArray5, "path");
            this.hoConn = iConnectionModels.createHoConnection(iCircuitId, n3, iHoPathDefModelArray5, (IConnCreateAttrs)connCreateAttrs);
            if (this.hoConn == null) return this.hoConn;
            if (!NetCcatCircuit.isNullCircuitId(iCircuitId)) return this.hoConn;
            this.registerNullCircuitConnection(this.getNetElement(), this.hoConn);
            return this.hoConn;
        }
    }

    protected void createEtherConnection(ICircuitId iCircuitId) throws CircuitProvError, ConnectionTypeError, ObjNotFound, PathInUse, InvalidPath, CTCUserException, NoMoreLoCapableHo, NoMoreEtherBandwidth, InsufficientBandwidth, AdminStateProvisioningError {
        NetCircuitSpan netCircuitSpan;
        if (this.dbgOn()) {
            db.println("createEtherConnection");
        }
        if (this.getAdminState() != 0) {
            throw new AdminStateProvisioningError("Stitched ethernet does not support circuit state " + this.translateAdminState(this.getAdminState()) + " use " + this.translateAdminState(0));
        }
        if (this.nodeDrop == null) {
            this.createConnection(iCircuitId);
            return;
        }
        int n = 0;
        IHoPathDefModel[] iHoPathDefModelArray = new IHoPathDefModel[this.biSpans.size()];
        if (this.biSpans.size() == 2 && this.findRoutingDir((netCircuitSpan = (NetCircuitSpan)this.biSpans.getFirst()).getLink()) == eSpanDirection.ORIGINATING) {
            this.biSpans.removeFirst();
            this.biSpans.add(netCircuitSpan);
        }
        Iterator iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            iHoPathDefModelArray[n++] = (IHoPathDefModel)netCircuitSpan.getPathDef(this.getNetElement(), this.pathWidth);
        }
        if (n > 2) {
            if (this.dbgOn()) {
                db.println("Warning! createEtherConnection: spans > 2");
            }
            throw new CircuitProvError("Invalid number of circuit spans at " + this.getName());
        }
        if (this.dbgOn()) {
            db.println("Creating ether stitch at Node " + this.getName() + " number of spans = " + n);
        }
        IConnectionModels iConnectionModels = this.getNodeModel().getConnectionModels();
        if (this.dbgOn()) {
            db.println("createEtherConnection:: pathWidth " + this.pathWidth);
        }
        if (n == 0) {
            this.hoConn = iConnectionModels.ftgCreateEtherStitch(iCircuitId, this.pathWidth);
        } else if (n == 1) {
            this.hoConn = iConnectionModels.createEtherStitchEnd(iCircuitId, iHoPathDefModelArray[0]);
        } else if (n == 2) {
            this.hoConn = iConnectionModels.createEtherStitchThrough(iCircuitId, iHoPathDefModelArray[0], iHoPathDefModelArray[1]);
        }
        boolean bl = false;
        try {
            ((HoCircuitEnd)this.nodeDrop).createEtherBridge(iCircuitId, this.circuit.getVlans());
        }
        catch (CTCUserException cTCUserException) {
            bl = true;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            bl = true;
        }
        if (bl) {
            block26: {
                try {
                    this.destroyCrossConnection();
                }
                catch (ConnectionInTestAccess connectionInTestAccess) {
                    if (this.dbgOn()) {
                        db.println("ConectionInTestAccess destroying a connection in createEtherConnection.");
                        SDebug.printStackTrace((Throwable)connectionInTestAccess);
                    }
                }
                catch (ConnectionInRoll connectionInRoll) {
                    if (this.dbgOn()) {
                        db.println("ConnectionInRoll destroying a connection in createEtherConnection.");
                        SDebug.printStackTrace((Throwable)connectionInRoll);
                    }
                }
                catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                    if (this.dbgOn()) {
                        db.println("ConnectionInTopologyUpgrade destroying a connection in createEtherConnection.");
                        SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                    }
                }
                catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                    if (!this.dbgOn()) break block26;
                    db.println("VcatMemberNotOutOfGroup destroying a connection in createEtherConnection.");
                    SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                }
            }
            throw new CircuitProvError("Unable to create the VLANs for the circuit at " + this.getName());
        }
    }

    protected void destroySanityCheck() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("destroy sanity check at " + this.getName());
        }
        if (!this.hasConnection()) {
            return;
        }
        if (this.hoConn != null && (this.getConnTypeFromConnModel() == 8 || this.hoConn.isUnstitchedEthernet())) {
            if (this.isNodeDrop()) {
                ((EtherNodeDropCircuitEnd)this.nodeDrop).destroySanityCheck(this.cktId);
            } else if (this.hasP2pEtherCktEnd()) {
                Iterator iterator = this.getP2pEtherCktEnd().iterator();
                while (iterator.hasNext()) {
                    HoCircuitEnd hoCircuitEnd = (HoCircuitEnd)iterator.next();
                    ((EtherP2PCircuitEnd)hoCircuitEnd).destroySanityCheck(this.cktId);
                }
            }
        }
    }

    protected void deleteNodeDrop() throws DeletionError {
        if (this.dbgOn()) {
            db.println("deleteNodeDrop at Node " + this.getName());
        }
        if (this.biSpans.size() == 1) {
            block22: {
                try {
                    this.destroyConnection();
                }
                catch (Busy busy) {
                    if (this.dbgOn()) {
                        db.println("Busy exception occured in deleteNodeDrop()");
                        SDebug.printStackTrace((Throwable)busy);
                    }
                }
                catch (ConnectionInTestAccess connectionInTestAccess) {
                    if (this.dbgOn()) {
                        db.println("ConnectionInTestAccess exception occured in deleteNodeDrop()");
                        SDebug.printStackTrace((Throwable)connectionInTestAccess);
                    }
                }
                catch (ConnectionInRoll connectionInRoll) {
                    if (this.dbgOn()) {
                        db.println("ConnectionInRoll exception occured in deleteNodeDrop()");
                        SDebug.printStackTrace((Throwable)connectionInRoll);
                    }
                }
                catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                    if (this.dbgOn()) {
                        db.println("ConnectionInTopologyUpgrade exception occured in deleteNodeDrop()");
                        SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                    }
                }
                catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                    if (!this.dbgOn()) break block22;
                    db.println("VcatMemberNotOutOfGroup exception occured in deleteNodeDrop()");
                    SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                }
            }
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)this.biSpans.getFirst();
            if (this.findRoutingDir(netCircuitSpan) == eSpanDirection.TERMINATING) {
                netCircuitSpan.setDstState(0);
            } else {
                netCircuitSpan.setSrcState(0);
            }
            NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan);
            netCircuitNode.deleteBiSpan(netCircuitSpan);
            this.biSpans.remove(netCircuitSpan);
        } else if (this.biSpans.size() == 2) {
            try {
                if (this.dbgOn()) {
                    db.println("changing the intended type to 2 way");
                }
                this.setConnTypeInConnModel(1);
                this.setConnectionType(1);
            }
            catch (CTCUserException cTCUserException) {
                if (this.dbgOn()) {
                    db.println("Unable to change intended type");
                }
            }
        } else if (this.dbgOn()) {
            db.println("deleteNodeDrop: invalid conn. type");
        }
        this.nodeDrop = null;
    }

    protected NetCircuitSpan findNextBiSpanOnRoute(NetCircuitSpan netCircuitSpan) {
        IEntityModel[] iEntityModelArray = null;
        if (this.hoConn != null) {
            iEntityModelArray = this.hoConn.getPathEntities();
        }
        return this.findNextBiSpanOnRoute(iEntityModelArray, netCircuitSpan);
    }

    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws DeletionError, SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("Deleting drop: ckt. node: " + this.getName());
        }
        if (this.circuit.getCircuitTypeObj().isEthernetCircuitType() && ((NetCircuitEnd)iNetCircuitEnd).isNodeDrop() || ((NetCircuitEnd)iNetCircuitEnd).isEtherP2PCircuitEnd()) {
            ((HoCircuitEnd)iNetCircuitEnd).destroyEtherBridge(this.cktId);
        }
        if (this.circuit.getCircuitTypeObj().isEthernetCircuitType() && ((NetCircuitEnd)iNetCircuitEnd).isNodeDrop()) {
            this.deleteNodeDrop();
            return;
        }
        super.deleteDrop(iNetCircuitEnd);
    }

    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the connection circuit Id at " + this.getName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        ICircuitId iCircuitId2 = this.cktId;
        if (this.hoConn != null) {
            boolean bl = false;
            boolean bl2 = false;
            if (this.isEtherStitched()) {
                try {
                    ((EtherNodeDropCircuitEnd)this.nodeDrop).destroyEtherBridge(iCircuitId2);
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    bl = true;
                }
                if (!bl) {
                    this.hoConn.setCircuitId(iCircuitId);
                    this.cktId = iCircuitId;
                    try {
                        ((EtherNodeDropCircuitEnd)this.nodeDrop).createEtherBridge(iCircuitId, this.circuit.getVlans());
                    }
                    catch (CTCUserException cTCUserException) {
                        bl2 = true;
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        bl2 = true;
                    }
                }
            } else if (this.hasP2pEtherCktEnd()) {
                Iterator iterator = this.getP2pEtherCktEnd().iterator();
                while (iterator.hasNext()) {
                    EtherP2PCircuitEnd etherP2PCircuitEnd = (EtherP2PCircuitEnd)iterator.next();
                    try {
                        etherP2PCircuitEnd.destroyEtherBridge(iCircuitId2);
                    }
                    catch (SanityCheckFailed sanityCheckFailed) {
                        bl = true;
                    }
                    if (bl) continue;
                    this.hoConn.setCircuitId(iCircuitId);
                    this.cktId = iCircuitId;
                    try {
                        etherP2PCircuitEnd.createEtherBridge(iCircuitId, this.circuit.getVlans());
                    }
                    catch (CTCUserException cTCUserException) {
                        bl2 = true;
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        bl2 = true;
                    }
                }
            } else {
                this.hoConn.setCircuitId(iCircuitId);
                this.cktId = iCircuitId;
            }
            if (bl) {
                if (this.dbgOn()) {
                    db.println("Unable to destroy ether bridge");
                }
            } else if (bl2 && this.dbgOn()) {
                db.println("Able to destroy ether bridge, but unable to create new one with new circuit id");
            }
            if (!NetCircuit.isNullCircuitId(iCircuitId)) {
                this.deregisterNullCircuitConnection(this.getNetElement(), this.hoConn);
            }
        }
    }

    public ICircuitId getConnectionCircuitId() {
        ICircuitId iCircuitId = null;
        try {
            if (this.hoConn != null) {
                iCircuitId = this.hoConn.getCircuitId();
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            // empty catch block
        }
        if (this.dbgOn() && iCircuitId == null) {
            db.println("getConnectionCircuitId: node " + this.getName() + " with connection object deleted");
        }
        return iCircuitId;
    }

    protected void sanityCheckVlan(int n) throws SanityCheckFailed {
        if (this.getConnectionType() != n && (n == 8 || this.hasP2pEtherCktEnd())) {
            IConnectionModels iConnectionModels = this.getNodeModel().getConnectionModels();
            if (n == 8 && this.pathWidth > iConnectionModels.getBiggestEtherpathAvailable()) {
                throw new SanityCheckFailed("Unable to support Ether connection size at Node " + this.getName());
            }
            IVlanModel[] iVlanModelArray = this.circuit.getVlans();
            VlanSetManager vlanSetManager = VlanSetManager.instance();
            if (vlanSetManager != null) {
                try {
                    if (this.dbgOn()) {
                        db.println("vsm.ensureVlansExist() at " + this.getName());
                    }
                    vlanSetManager.ensureVlansExist(this.getNodeModel(), iVlanModelArray);
                }
                catch (IoError ioError) {
                    if (this.dbgOn()) {
                        db.println("IO error ensuring VLAN set at " + this.getName());
                    }
                    throw new SanityCheckFailed("Unable to ensure VLANs exist for the circuit at " + this.getName());
                }
            }
            IEtherBridgeModel iEtherBridgeModel = this.getNodeModel().getEtherBridgeModel();
            Throwable throwable = null;
            if (n == 8) {
                if (this.dbgOn()) {
                    db.println("bridge.createCircuitTest() at node " + this.getName());
                }
                try {
                    boolean bl = iEtherBridgeModel.createCircuitTest(iVlanModelArray);
                    if (!bl) {
                        throwable = new VlanSpanningTreeViolation("");
                    }
                }
                catch (NoMoreEtherCircuit noMoreEtherCircuit) {
                    throwable = noMoreEtherCircuit;
                }
                catch (NoMoreSpanningTree noMoreSpanningTree) {
                    throwable = noMoreSpanningTree;
                }
                catch (NoSuchVlan noSuchVlan) {
                    throwable = noSuchVlan;
                }
                catch (VlanSpanningTreeViolation vlanSpanningTreeViolation) {
                    throwable = vlanSpanningTreeViolation;
                }
                catch (DuplicateCircuit duplicateCircuit) {
                    throwable = duplicateCircuit;
                }
            } else if (this.hasP2pEtherCktEnd()) {
                if (this.dbgOn()) {
                    db.println("bridge.createPointToPointCircuitTest() at node " + this.getName());
                }
                try {
                    boolean bl;
                    if (this.circuit.createWithStpEnabled()) {
                        db.println("STP is Enabled");
                        bl = iEtherBridgeModel.createPointToPointCircuitTest(iVlanModelArray);
                    } else {
                        db.println("STP is Disabled");
                        bl = iEtherBridgeModel.createPointToPointCircuitTest(new IVlanModel[0]);
                    }
                    if (!bl) {
                        throwable = new VlanSpanningTreeViolation("");
                    }
                }
                catch (NoSuchVlan noSuchVlan) {
                    throwable = noSuchVlan;
                }
                catch (NoMoreSpanningTree noMoreSpanningTree) {
                    throwable = noMoreSpanningTree;
                }
                catch (VlanSpanningTreeViolation vlanSpanningTreeViolation) {
                    throwable = vlanSpanningTreeViolation;
                }
                catch (NoSuchCircuit noSuchCircuit) {
                    throwable = noSuchCircuit;
                }
            }
            if (throwable != null) {
                if (throwable instanceof VlanSpanningTreeViolation) {
                    throw new VlanStpSanityCheckFailed(this.getNodeModel());
                }
                throw new SanityCheckFailed("Circuit sanity check failed on Node " + this.getName() + ".\n" + "Either the spanning tree limit has been reached," + "\n" + "or one of the circuit VLANs does not exist on " + this.getName());
            }
        }
    }

    protected int getUpsrReversionMode() {
        if (this.hoConn != null) {
            return this.hoConn.getUpsrReversion().getReversionMode();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAnyChangeInEtherStpState() {
        IBridgePortInfo[] iBridgePortInfoArray;
        boolean bl = false;
        if (!this.hasConnection()) {
            return bl;
        }
        if (this.hoConn == null) {
            return bl;
        }
        try {
            iBridgePortInfoArray = this.hoConn.getBridgePortInfoList();
        }
        catch (NoSuchInterface noSuchInterface) {
            db.println("Exception caught in isAnyChangeInEtherStpState");
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return bl;
        }
        if (iBridgePortInfoArray == null) {
            if (this.dbgOn()) {
                db.println("isAnyChangeInEtherStpState: null portInfo at " + this.getName());
            }
            return bl;
        }
        Object object = this.bridgeInfoLockObject;
        synchronized (object) {
            if (this.bridgeInfo == null) {
                this.bridgeInfo = new LinkedList();
            }
            if (iBridgePortInfoArray.length != this.bridgeInfo.size()) {
                bl = true;
            }
            if (!bl) {
                IBridgePortInfo[] iBridgePortInfoArray2 = this.bridgeInfo.toArray(new IBridgePortInfo[0]);
                for (int i = 0; i < iBridgePortInfoArray.length; ++i) {
                    if (iBridgePortInfoArray[i].getPortState() == iBridgePortInfoArray2[i].getPortState()) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.bridgeInfo.clear();
                this.bridgeInfo.addAll(Arrays.asList(iBridgePortInfoArray));
            }
        }
        return bl;
    }

    public IConnectionModel getConn() {
        return this.hoConn;
    }

    protected void setConn(IConnectionModel iConnectionModel) {
        this.hoConn = (IHoConnectionModel)iConnectionModel;
    }

    public boolean isUpsr() {
        return this.upsrOps != null;
    }

    protected boolean isEtherStitched() {
        return this.getConnectionType() == 8;
    }

    protected boolean isForwardingSpan(NetCircuitSpan netCircuitSpan, NetCircuitNode netCircuitNode) {
        return this.isForwardingSpan(netCircuitSpan, (HoCircuitNode)netCircuitNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isForwardingSpan(NetCircuitSpan netCircuitSpan, HoCircuitNode hoCircuitNode) {
        IEntityModel[] iEntityModelArray;
        ICircuitId iCircuitId;
        if (hoCircuitNode == this) {
            if (this.dbgOn()) {
                db.println("isFwdSpan: Checking node " + this.getName() + " has already been visited");
            }
            return true;
        }
        if (hoCircuitNode == null) {
            hoCircuitNode = this;
        }
        if ((iCircuitId = this.circuit.getCircuitId()) == null) {
            return true;
        }
        if (this.hoConn == null) {
            if (this.dbgOn()) {
                db.println("isForwardingSpan: hoConn is null!");
            }
            return true;
        }
        NetCircuitNode netCircuitNode = null;
        IBridgePortInfo iBridgePortInfo = null;
        IBridgePortInfo iBridgePortInfo2 = null;
        Object object = this.bridgeInfoLockObject;
        synchronized (object) {
            if (this.bridgeInfo == null) {
                this.bridgeInfo = new LinkedList();
                this.isAnyChangeInEtherStpState();
            }
            if ((iEntityModelArray = this.bridgeInfo.iterator()).hasNext()) {
                iBridgePortInfo = (IBridgePortInfo)iEntityModelArray.next();
            }
            if (iEntityModelArray.hasNext()) {
                iBridgePortInfo2 = (IBridgePortInfo)iEntityModelArray.next();
            }
        }
        if (iBridgePortInfo2 != null || iBridgePortInfo != null) {
            int n = netCircuitSpan.getEntityIndex(this.getNetElement());
            iEntityModelArray = this.hoConn.getPathEntities();
            Iterator<IEntityModel> iterator = Arrays.asList(iEntityModelArray).iterator();
            int n2 = 0;
            boolean bl = false;
            while (iterator.hasNext()) {
                IEntityModel iEntityModel = iterator.next();
                if (iEntityModel.getEntityIndex() == n) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            IBridgePortInfo iBridgePortInfo3 = null;
            if (!bl) {
                if (this.dbgOn()) {
                    db.println("isForwardingSpan: No nodeIndex match!!");
                }
                return true;
            }
            if (n2 == 0) {
                iBridgePortInfo3 = iBridgePortInfo;
            } else if (n2 == 1) {
                iBridgePortInfo3 = iBridgePortInfo2;
            } else {
                if (this.dbgOn()) {
                    db.println("isForwardingSpan: invalid nodeIndex match!! " + n2);
                }
                return true;
            }
            if (iBridgePortInfo3 == null && this.circuit.isEthernet() && !this.circuit.getCircuitTypeObj().isEthernetCircuitType()) {
                iBridgePortInfo3 = iBridgePortInfo != null ? iBridgePortInfo : iBridgePortInfo2;
            }
            if (iBridgePortInfo3 != null) {
                return iBridgePortInfo3.getPortState() == 5;
            }
            if (this.dbgOn()) {
                db.println("isFwdSpan: Index match " + n2 + ", but portInfo is null! ");
            }
            return true;
        }
        NetCircuitSpan netCircuitSpan2 = this.findNextBiSpanOnRoute(netCircuitSpan);
        if (netCircuitSpan2 == null) {
            return true;
        }
        netCircuitNode = this.spanGetPeer(netCircuitSpan2);
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                db.println("isForwardingSpan: no peernode for " + netCircuitSpan2.prettyString());
            }
            return true;
        }
        return netCircuitNode.isForwardingSpan(netCircuitSpan2, hoCircuitNode);
    }

    public boolean getCktNodeStpEnabled() {
        if (!Network.instance().getNetElem(this.hoConn.getNodeModel().getNodeId()).getNodeModel().provides(Feature.BACKEND_STP)) {
            if (this.dbgOn()) {
                db.println("disabling TDM port STP not supported");
            }
            return true;
        }
        return this.hoConn != null && this.hoConn.getStpEnabled();
    }

    public boolean hasXcLoopback() {
        boolean bl;
        block5: {
            bl = false;
            if (this.hoConn != null && this.getNodeModel().provides(Feature.HASXCLPBK_IFACE)) {
                try {
                    bl = this.hoConn.hasXcLoopback();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.on()) {
                        db.println("Caught exception in hasXcLoopback!");
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                catch (InvalidPath invalidPath) {
                    if (!db.on()) break block5;
                    db.println("Caught exception in hasXcLoopback!");
                    SDebug.printStackTrace((Throwable)invalidPath);
                }
            }
        }
        return bl;
    }

    protected Object getRollFromPath(IRollModel iRollModel) {
        IHoRollModel iHoRollModel = (IHoRollModel)iRollModel;
        if (iHoRollModel != null) {
            return iHoRollModel.getRollFromPath();
        }
        return null;
    }

    protected Object getRollToPath(IRollModel iRollModel) {
        IHoRollModel iHoRollModel = (IHoRollModel)iRollModel;
        if (iHoRollModel != null) {
            return iHoRollModel.getRollToPath();
        }
        return null;
    }

    protected boolean isCompletedRollToPath(Object object, IRollModel iRollModel) {
        IHoRollModel iHoRollModel = (IHoRollModel)iRollModel;
        if (iHoRollModel == null) {
            return false;
        }
        try {
            if (iHoRollModel.getRollFinish() == 3) {
                NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), this.getRollToPath((IRollModel)iHoRollModel));
                NetCircuitEnd netCircuitEnd2 = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), object);
                if (netCircuitEnd2.equals(netCircuitEnd)) {
                    this.rollHasCompleted = true;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    protected IRollModel getRoll() {
        IHoRollModel iHoRollModel = null;
        if (this.inRoll()) {
            try {
                iHoRollModel = this.getConn().getNodeModel().getConnectionModels().getHoRollModels(this.getConn().getIndex());
            }
            catch (NoSuchConnection noSuchConnection) {
                iHoRollModel = null;
            }
        }
        return iHoRollModel;
    }

    protected boolean isIngressOnXm() {
        return this.ingressOnXm;
    }

    protected void setIngressOnXm(boolean bl) {
        this.ingressOnXm = bl;
    }

    protected boolean onXm() {
        return !this.circuit.getXmCircuitEnds().isEmpty() && ((NetCircuitEnd)this.circuit.getXmCircuitEnds().get(0)).getNodeId() == this.getNodeModel().getNodeId();
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }
}

