/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.ncp.IInServiceUpgradeMgr;
import cerent.cms.ncp.InServiceUpgradeError;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.Unprot2UpsrInServiceUpgradeMgr;
import cerent.cms.ncp.Upsr2BlsrInServiceUpgradeMgr;
import cerent.cms.topo.Network;
import cerent.util.SDebug;
import java.util.LinkedList;
import java.util.List;

public abstract class InServiceUpgradeMgr
implements IInServiceUpgradeMgr {
    protected static SDebug dbg = new SDebug("ISTU");
    protected NetCircuitManager ncm = NetCircuitManager.instance();
    protected Network net = Network.instance();

    public static IInServiceUpgradeMgr createInServiceUpgradeMgr(int n) throws InServiceUpgradeError {
        if (n == 0) {
            InServiceUpgradeMgr.debug("Creating a unprot to UPSR upgrade manager");
            return new Unprot2UpsrInServiceUpgradeMgr();
        }
        if (n == 1) {
            InServiceUpgradeMgr.debug("Creating a UPSR to BLSR upgrade manager");
            return new Upsr2BlsrInServiceUpgradeMgr();
        }
        throw new InServiceUpgradeError("Invalid operation");
    }

    protected InServiceUpgradeMgr() {
    }

    public abstract int getInServiceUpgradeOp();

    public void setUpsrRingLinks(List list) throws SanityCheckFailed {
    }

    public List getPreferredLinks() {
        return new LinkedList();
    }

    public int upsr2BlsrConversionCheck() throws SanityCheckFailed {
        return 0;
    }

    public void switchTraffic2ShortestPaths() throws InServiceUpgradeError {
    }

    public abstract void convert() throws InServiceUpgradeError;

    public void cancel() throws InServiceUpgradeError {
    }

    protected static void debug(String string) {
        if (InServiceUpgradeMgr.dbg.on) {
            dbg.println(string);
        }
    }

    protected static void printStackTrace(Exception exception) {
        SDebug.printStackTrace((Throwable)exception);
    }
}

