/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.IPathDefModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.Connection;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.util.SDebug;

public class InternalCircuitSpan
extends NetCircuitSpan {
    private static final SDebug db = new SDebug("InternalCircuitSpan");
    private Connection srcConnection;
    private Connection dstConnection;

    public InternalCircuitSpan(Connection connection, Connection connection2) {
        this.srcConnection = connection;
        this.dstConnection = connection2;
    }

    public boolean isInternalSpan() {
        return true;
    }

    protected static boolean isLineProtected(NetCircuitSpan netCircuitSpan) {
        return true;
    }

    public Connection getDstConn() {
        return this.dstConnection;
    }

    public Connection getSrcConn() {
        return this.srcConnection;
    }

    protected IPathDefModel getPathDef(INetElement iNetElement, short s) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        throw new InvalidPath("InternalCircuitSpan does not have pathDefs");
    }

    protected Connection getPeerConnection(Connection connection) {
        if (connection.equals(this.dstConnection)) {
            return this.srcConnection;
        }
        if (connection.equals(this.srcConnection)) {
            return this.dstConnection;
        }
        if (this.dbgOn()) {
            db.println("getPeerConnection: no peer connection for conn " + connection.getName() + " on node " + connection.getNodeName());
        }
        return null;
    }

    public INetLink getLink() {
        return null;
    }

    private boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public String prettyString() {
        return this.srcConnection.getName() + "->" + this.dstConnection.getName();
    }
}

