/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AdminStateOpt;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ConnCreateAttrs;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.DeleteInstead;
import cerent.cms.model.DriNodeTypeOpt;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoRollModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IRollModel;
import cerent.cms.model.InsufficientBandwidth;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoDefModel;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathNotSupported;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SelectorAttrsOpt;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.OnewayConnection;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.INetElement;
import cerent.util.EnumStrings;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LoCircuitNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("LoCircuitNode");
    private ILoConnectionModel loConn;

    public LoCircuitNode(INetElement iNetElement, LoCcatCircuit loCcatCircuit) {
        super(iNetElement, loCcatCircuit);
        this.connName = loCcatCircuit.getCircuitName();
        this.cktId = new CircuitId(0, 0);
        this.serviceState = -2;
        this.pathWidth = loCcatCircuit.getCircuitSizeObj().size2widthOfLoCircuit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoCircuitNode(INetElement iNetElement, LoCcatCircuit loCcatCircuit, Object object) throws AbstractCmsObjectNotExistException {
        super(iNetElement, loCcatCircuit, object);
        this.connName = this.getConnNameFromNE();
        loCcatCircuit.setChanged();
        this.pathWidth = loCcatCircuit.getCircuitSizeObj().size2widthOfLoCircuit();
        Object object2 = this.entitiesLockObject;
        synchronized (object2) {
            this.updateUpsrEntities(true);
        }
    }

    protected void sanityCheckConnModel() {
        this.loConn.getConnectionType();
    }

    protected int getConnTypeFromConnModel() {
        ILoConnectionModel iLoConnectionModel = this.loConn;
        int n = iLoConnectionModel != null ? iLoConnectionModel.getConnectionType() : 20;
        if (this.dbgOn()) {
            this.debug("getConnTypeFromConnModel: " + this.circuit.getCircuitName() + "::" + this.getName() + "::" + EnumStrings.getString((Class)IConnectionType.class, (int)n));
        }
        return n;
    }

    protected void setConnTypeInConnModel(int n) throws ConnectionTypeError, ConnectionInTopologyUpgrade, ConnectionInLoopback, ConnectionInTestAccess, ConnectionInRoll {
        if (this.loConn != null) {
            if (this.dbgOn()) {
                db.println("changing intended type for LO connection");
            }
            this.loConn.changeIntendedType(n);
        }
    }

    protected void addOutputToConnModel(NetCircuitEnd netCircuitEnd) throws CTCUserException {
        if (this.loConn != null) {
            ILoDefModel iLoDefModel = (ILoDefModel)((LoCircuitEnd)netCircuitEnd).getPathDef(this.getPathWidth());
            this.loConn.addOutput(iLoDefModel);
        }
    }

    protected void addOutputToConnModel(NetCircuitSpan netCircuitSpan) throws CTCUserException {
        if (this.loConn != null) {
            ILoDefModel iLoDefModel = (ILoDefModel)netCircuitSpan.getPathDef(this.getNetElement(), this.getPathWidth());
            this.loConn.addOutput(iLoDefModel);
        }
    }

    protected void removeOutputFromConnModel(NetCircuitEnd netCircuitEnd) throws InvalidPath, DeleteInstead, ConnectionTypeError, ObjNotFound, PathInUse, NoMoreLoCapableHo {
        if (this.loConn != null) {
            ILoDefModel iLoDefModel = (ILoDefModel)((LoCircuitEnd)netCircuitEnd).getPathDef(this.getPathWidth());
            this.loConn.removeOutput(iLoDefModel);
        }
        netCircuitEnd.cleanupLoAditIfOldNe();
    }

    protected void removeOutputFromConnModel(NetCircuitSpan netCircuitSpan) throws InvalidPath, DeleteInstead, ConnectionTypeError, ObjNotFound, PathInUse, NoMoreLoCapableHo {
        if (this.loConn != null) {
            ILoDefModel iLoDefModel = (ILoDefModel)netCircuitSpan.getPathDef(this.getNetElement(), this.getPathWidth());
            this.loConn.removeOutput(iLoDefModel);
        }
        netCircuitSpan.cleanupLoAditIfOldNe(this.getNetElement());
    }

    protected List getOrderedPathDefs(int n) throws CTCUserException {
        Object object;
        int n2 = this.countNumInputs();
        int n3 = this.countNumOutputs();
        int n4 = this.countNumOmniSpans();
        ArrayList<ILoDefModel> arrayList = new ArrayList<ILoDefModel>();
        ArrayList<ILoDefModel> arrayList2 = new ArrayList<ILoDefModel>();
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitEnd)iterator.next();
            arrayList.add((ILoDefModel)((NetCircuitEnd)object).getPathDef(this.pathWidth));
        }
        iterator = this.drops.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitEnd)iterator.next();
            arrayList2.add((ILoDefModel)((NetCircuitEnd)object).getPathDef(this.pathWidth));
        }
        iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitSpan)iterator.next();
            if (this.findRoutingDir((NetCircuitSpan)object) == eSpanDirection.ORIGINATING) {
                arrayList2.add((ILoDefModel)((NetCircuitSpan)object).getPathDef(this.getNetElement(), this.pathWidth));
                continue;
            }
            if (this.findRoutingDir((NetCircuitSpan)object) != eSpanDirection.TERMINATING) continue;
            arrayList.add((ILoDefModel)((NetCircuitSpan)object).getPathDef(this.getNetElement(), this.pathWidth));
        }
        iterator = this.inSpans.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitSpan)iterator.next();
            arrayList.add((ILoDefModel)((NetCircuitSpan)object).getPathDef(this.getNetElement(), this.pathWidth));
        }
        iterator = this.outSpans.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitSpan)iterator.next();
            arrayList2.add((ILoDefModel)((NetCircuitSpan)object).getPathDef(this.getNetElement(), this.pathWidth));
        }
        if (this.dbgOn()) {
            this.debug("getOrderedPathDefs: in => " + arrayList.size() + ", out => " + arrayList2.size());
        }
        object = new LinkedList();
        if (n == 0) {
            ((LinkedList)object).add(arrayList.get(0));
            ((LinkedList)object).add(arrayList2.get(0));
        } else if (n == 1) {
            ((LinkedList)object).add(arrayList.get(0));
            ((LinkedList)object).add(arrayList2.get(0));
        } else if (n == 2) {
            if (arrayList.size() == 2) {
                ((LinkedList)object).add(arrayList.get(0));
                ((LinkedList)object).add(arrayList.get(1));
                ((LinkedList)object).add(arrayList2.get(0));
            } else if (arrayList2.size() == 2) {
                ((LinkedList)object).add(arrayList2.get(0));
                ((LinkedList)object).add(arrayList2.get(1));
                ((LinkedList)object).add(arrayList.get(0));
            } else if (this.dbgOn()) {
                this.debug("calculateOrderedPathList: WARNING - bad UPSR case");
            }
        } else if (n == 3) {
            ((LinkedList)object).add(arrayList.get(0));
            ((LinkedList)object).add(arrayList.get(1));
            ((LinkedList)object).add(arrayList2.get(0));
            ((LinkedList)object).add(arrayList2.get(1));
        } else if (n == 4) {
            ((LinkedList)object).add(arrayList2.get(0));
            ((LinkedList)object).add(arrayList2.get(1));
            ((LinkedList)object).add(arrayList.get(0));
        } else if (n == 6) {
            ((LinkedList)object).add(arrayList.get(0));
            ((LinkedList)object).add(arrayList.get(1));
            ((LinkedList)object).add(arrayList2.get(0));
            if (arrayList2.size() == 2) {
                ((LinkedList)object).add(arrayList2.get(1));
            }
        }
        return object;
    }

    protected Object[] getPathsFromConnModel() {
        ILoConnectionModel iLoConnectionModel = this.loConn;
        if (iLoConnectionModel != null) {
            Object[] objectArray = iLoConnectionModel.getPaths();
            if (objectArray == null) {
                if (this.dbgOn()) {
                    db.println("getPathsFromConnModel() hit object not exist exception");
                }
                return new Object[0];
            }
            if (this.connType == 18 && objectArray.length == 1) {
                LinkedList<ILoDefModel> linkedList = new LinkedList<ILoDefModel>(Arrays.asList(objectArray));
                Iterator iterator = linkedList.iterator();
                ILoDefModel iLoDefModel = (ILoDefModel)iterator.next();
                LoDefModel loDefModel = new LoDefModel(this.getNodeModel(), null, null, iLoDefModel.getLoPathWidth(), iLoDefModel.getPathIdentifier(), 0);
                linkedList.add(0, loDefModel);
                return linkedList.toArray();
            }
            Object[] objectArray2 = objectArray;
            IRollModel iRollModel = this.getRoll();
            if (iRollModel == null) {
                if (this.dbgOn()) {
                    db.println("the connection is NOT involved in the roll");
                }
                return objectArray2;
            }
            if (this.dbgOn()) {
                db.println("the connection is involved in the roll");
            }
            Object[] objectArray3 = new Object[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray3[i] = this.isCompletedRollToPath(objectArray2[i], iRollModel) ? this.getRollFromPath(iRollModel) : objectArray2[i];
            }
            return objectArray3;
        }
        if (this.dbgOn()) {
            db.println("getPathsFromConnModel() hit object not exist exception");
        }
        return new LinkedList().toArray();
    }

    protected Object[] getActivePathsFromConnModel() {
        ILoConnectionModel iLoConnectionModel = this.loConn;
        if (iLoConnectionModel != null) {
            return iLoConnectionModel.getActivePaths();
        }
        if (this.dbgOn()) {
            db.println("getActivePathsFromConnModel() hit object not exist exception");
        }
        return new LinkedList().toArray();
    }

    protected int getProtectionOpFromConnModel() {
        ILoConnectionModel iLoConnectionModel = this.loConn;
        if (this.loConn != null) {
            return this.loConn.getProtectionOp();
        }
        if (this.dbgOn()) {
            db.println("getProtectionOpFromConnModel() hit object not exist exception");
        }
        return -1;
    }

    protected int getReverseProtectionOpFromConnModel() {
        ILoConnectionModel iLoConnectionModel = this.loConn;
        if (iLoConnectionModel != null) {
            return iLoConnectionModel.getReverseProtectionOp();
        }
        if (this.dbgOn()) {
            db.println("getProtectionOpFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return -1;
    }

    protected void modifyConnection() throws CircuitProvError {
        if (this.dbgOn()) {
            db.println("modifyConnection @ Node " + this.getName());
        }
        this.modifyConnectionType();
        this.modifyConnectionDropsAndSpans();
        this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
        this.setState(2);
    }

    protected void destroySanityCheck() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("destroy sanity check at " + this.getName());
        }
        if (!this.hasConnection()) {
            return;
        }
    }

    protected void destroyCrossConnection() throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup {
        if (this.loConn != null) {
            block6: {
                if (this.dbgOn()) {
                    db.println("destroyCrossConnection(" + this.getName() + "): destroy loConn");
                }
                try {
                    if (this.getNodeModel().provides(Feature.FORCE_DESTROY)) {
                        this.loConn.localDestroy(true);
                    } else {
                        this.loConn.localDestroy();
                    }
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    if (!this.dbgOn()) break block6;
                    db.println("loConn already deleted");
                }
            }
            this.cleanupLoAditsIfOldNe();
        }
        this.updateConnectionPathEnds(new LinkedList());
    }

    protected void cleanupLoAditsIfOldNe() {
        if (!this.ne.getNodeModel().provides(Feature.TCCU)) {
            this.cleanupLoAdits();
        }
    }

    protected void cleanupLoAdits() {
        Object object;
        Iterator iterator;
        int n;
        if (this.dbgOn()) {
            db.println("Cleanup LO Adits at " + this.getName());
        }
        LinkedList linkedList = this.sources;
        for (n = 0; n < 2; ++n) {
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = (LoCircuitEnd)iterator.next();
                ((LoCircuitEnd)object).cleanupLoAdit();
            }
            linkedList = this.drops;
        }
        n = 0;
        linkedList = this.inSpans;
        while (n < 3) {
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = (NetCircuitSpan)iterator.next();
                ((NetCircuitSpan)object).cleanupLoAdit(this.getNetElement());
            }
            linkedList = ++n == 1 ? this.outSpans : this.biSpans;
        }
    }

    protected void createConnection() throws CircuitProvError {
        this.setConnectionType(this.findConnType());
        if (this.getConnectionType() == 20) {
            if (this.dbgOn()) {
                db.println("Warning! createConnection at " + this.getName() + " connection type is unknown");
            }
            throw new CircuitProvError("Invalid connection type at " + this.getName());
        }
        INetCircuit iNetCircuit = this.circuit.useLAP();
        if (iNetCircuit != null && this.getNetElement().getNodeId() == iNetCircuit.getPrimarySource().getNodeId()) {
            if (this.dbgOn()) {
                db.println("This circuit node is on LAP STS grooming end, no LO cross-connect needs to be created");
            }
            this.setState(1);
            this.setCreateStage(3);
            this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
            this.simulateConnection();
            return;
        }
        this.cktId = this.circuit.getCircuitId();
        this.connName = this.circuit.getCircuitName();
        if (this.dbgOn()) {
            this.debug("createConnection(" + this.getName() + ")" + "; connType=" + EnumStrings.getString((Class)IConnectionType.class, (int)this.getConnectionType()) + "; cktId=" + NetCcatCircuit.prettyString(this.cktId));
        }
        try {
            this.createConnection(this.cktId);
        }
        catch (CTCUserException cTCUserException) {
            if (this.dbgOn()) {
                db.println("Exception while creating lo connection at " + this.getName());
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            String string = "Unable to create connection at " + this.getName();
            if (cTCUserException instanceof NoMoreLoCapableHo) {
                string = string + "\n- " + this.getNoLoCapableHoMessage();
            } else if (cTCUserException instanceof PathInUse) {
                string = string + "\n- Path already in use";
            } else if (cTCUserException instanceof PathNotSupported) {
                string = string + "\n- Path Not Supported";
            } else if (cTCUserException instanceof InsufficientBandwidth) {
                string = string + "\n- Insufficient Bandwidth";
            } else if (cTCUserException instanceof InvalidState) {
                string = string + "\n- Invalid Admin State";
            } else if (cTCUserException instanceof ProvisionError) {
                string = string + "\n" + ((ProvisionError)((Object)cTCUserException)).getEIDMsg();
            }
            this.cleanupLoAdits();
            throw new CircuitProvError(string);
        }
        catch (AdminStateProvisioningError adminStateProvisioningError) {
            if (this.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)adminStateProvisioningError);
            }
            String string = "Unable to create connection at " + this.getName();
            string = string + "\n" + adminStateProvisioningError.getMessage();
            this.cleanupLoAdits();
            throw new CircuitProvError(string);
        }
        if (this.loConn == null) {
            if (this.dbgOn()) {
                db.println("Connection Models returned NULL connection ");
            }
            throw new CircuitProvError("Error while creating connection object at " + this.getName());
        }
        this.addConnectionObserver();
        this.setState(1);
        this.setCreateStage(3);
        this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
        this.updateConnectionPathEnds(this.getPathEndsFromPathDefs(this.getConnectionPathDefs()));
    }

    protected void createSpliceListenersForSourcesAndDrops() {
        if (this.getConn() != null) {
            super.createSpliceListenersForSourcesAndDrops();
        }
    }

    protected void createSpliceListener(NetCircuitEnd netCircuitEnd) {
        if (this.getConn() != null) {
            super.createSpliceListener(netCircuitEnd);
        }
    }

    protected String prettyString(IPathDefModel iPathDefModel) {
        ILoDefModel iLoDefModel = (ILoDefModel)iPathDefModel;
        short s = 0;
        if (this.getNodeModel().provides(Feature.VCAT)) {
            s = iLoDefModel.getPathIdentifier();
        }
        return this.getName() + "::" + Integer.toHexString(iLoDefModel.getPortIndex()) + "::" + LoDefModel.physicalHo(iLoDefModel) + "::" + s;
    }

    private String prettyString(ILoDefModel iLoDefModel) {
        int n = LoCircuitNode.getEntityIndexFromLoDef(this.getNodeModel(), iLoDefModel);
        IHoPathDefModel iHoPathDefModel = iLoDefModel.getLoAdit().getHo();
        IHoNum iHoNum = HoPathDefModel.physicalHo(iHoPathDefModel);
        ILoNum iLoNum = iLoDefModel.getLoNum();
        short s = 0;
        if (iHoPathDefModel.getNodeModel().provides(Feature.VCAT)) {
            s = iLoDefModel.getPathIdentifier();
        }
        return this.getName() + "::" + Integer.toHexString(n) + "::" + iHoNum + "::" + iLoNum + "::" + s;
    }

    protected void prettyPrint(ILoDefModel[] iLoDefModelArray, String string) {
        for (int i = 0; i < iLoDefModelArray.length; ++i) {
            if (!this.dbgOn()) continue;
            this.debug(string + " LoPath #" + i + " " + this.prettyString(iLoDefModelArray[i]));
        }
    }

    protected void createConn(ICircuitId iCircuitId, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, int n2, ArrayList arrayList4, ArrayList arrayList5) throws CircuitProvError, ConnectionTypeError, ObjNotFound, InvalidState, InvalidPath, PathInUse, CTCUserException, NoMoreLoCapableHo, InsufficientBandwidth, AdminStateProvisioningError {
        this.prettyPrint(arrayList.toArray(new ILoDefModel[0]), "input");
        this.prettyPrint(arrayList2.toArray(new ILoDefModel[0]), "output");
        this.prettyPrint(arrayList3.toArray(new ILoDefModel[0]), "omni");
        ILoDefModel[][] iLoDefModelArrayArray = new ILoDefModel[][]{arrayList.toArray(new ILoDefModel[0]), arrayList2.toArray(new ILoDefModel[0]), arrayList3.toArray(new ILoDefModel[0])};
        int[] nArray = new int[arrayList4.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList4.get(i);
        }
        boolean[] blArray = new boolean[arrayList5.size()];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = (Boolean)arrayList5.get(i);
        }
        this.createLoConnOnNE(iCircuitId, iLoDefModelArrayArray, n, n2, nArray, blArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createLoConnOnNE(ICircuitId iCircuitId, ILoDefModel[][] iLoDefModelArray, int n, int n2, int[] nArray, boolean[] blArray) throws CircuitProvError, ConnectionTypeError, ObjNotFound, InvalidPath, PathInUse, CTCUserException, InvalidState, NoMoreLoCapableHo, AdminStateProvisioningError, InsufficientBandwidth {
        ILoDefModel[] iLoDefModelArray2 = iLoDefModelArray[0];
        ILoDefModel[] iLoDefModelArray3 = iLoDefModelArray[1];
        ILoDefModel[] iLoDefModelArray4 = iLoDefModelArray[2];
        ILoDefModel[] iLoDefModelArray5 = null;
        IConnectionModels iConnectionModels = this.getNodeModel().getConnectionModels();
        if (this.dbgOn()) {
            db.println("createLoConnOnNE:connType=" + EnumStrings.getString((Class)IConnectionType.class, (int)this.getConnectionType()));
        }
        int n3 = this.getConnectionType();
        AdminStateOpt adminStateOpt = new AdminStateOpt();
        adminStateOpt.setAdminState(this.getAdminState());
        ConnCreateAttrs connCreateAttrs = new ConnCreateAttrs();
        connCreateAttrs.setCktName(this.connName);
        connCreateAttrs.setAdminStateOpt(adminStateOpt);
        connCreateAttrs.setSelectorAttrsOpt(null);
        DriNodeTypeOpt driNodeTypeOpt = new DriNodeTypeOpt(this.driNodeType);
        connCreateAttrs.setDriNodeTypeOpt(driNodeTypeOpt);
        INetElement iNetElement = this.getNetElement();
        if (!iNetElement.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL) && 0 != this.getAdminState()) {
            db.info("PreOdin node " + this.getName() + " does not support admin state provisioning");
            throw new AdminStateProvisioningError("Node " + this.getName() + " does not support circuit state " + this.translateAdminState(this.getAdminState()) + ": use " + this.translateAdminState(0));
        }
        Map map = TL1ObjectManager.instance().getTL1Conns();
        synchronized (map) {
            block37: {
                block46: {
                    block47: {
                        block38: {
                            block48: {
                                block45: {
                                    block44: {
                                        block43: {
                                            block42: {
                                                block41: {
                                                    block40: {
                                                        block39: {
                                                            if (n3 != 0) break block39;
                                                            int n4 = 1 + iLoDefModelArray3.length;
                                                            iLoDefModelArray5 = new ILoDefModel[n4];
                                                            iLoDefModelArray5[0] = iLoDefModelArray2[0];
                                                            for (int i = 0; i < iLoDefModelArray3.length; ++i) {
                                                                iLoDefModelArray5[i + 1] = iLoDefModelArray3[i];
                                                            }
                                                            break block37;
                                                        }
                                                        if (n3 != 9) break block40;
                                                        int n5 = 1 + iLoDefModelArray3.length;
                                                        iLoDefModelArray5 = new ILoDefModel[n5];
                                                        iLoDefModelArray5[0] = iLoDefModelArray2[0];
                                                        for (int i = 0; i < iLoDefModelArray3.length; ++i) {
                                                            iLoDefModelArray5[i + 1] = iLoDefModelArray3[i];
                                                        }
                                                        break block37;
                                                    }
                                                    if (n3 != 1) break block41;
                                                    iLoDefModelArray5 = new ILoDefModel[2];
                                                    if (this.dbgOn()) {
                                                        db.println("Create LO Connection: createLoTwoWay");
                                                    }
                                                    if (iLoDefModelArray4.length == 2) {
                                                        iLoDefModelArray5[0] = iLoDefModelArray4[0];
                                                        iLoDefModelArray5[1] = iLoDefModelArray4[1];
                                                        break block37;
                                                    } else {
                                                        iLoDefModelArray5[0] = iLoDefModelArray2[0];
                                                        iLoDefModelArray5[1] = iLoDefModelArray3[0];
                                                    }
                                                    break block37;
                                                }
                                                if (n3 != 18) break block42;
                                                iLoDefModelArray5 = new ILoDefModel[1];
                                                if (this.dbgOn()) {
                                                    db.println("Create LO Connection: DIAGNOSTIC");
                                                }
                                                iLoDefModelArray5[0] = iLoDefModelArray3[0];
                                                if (!this.getNodeModel().provides(Feature.DIAGNOSTIC_CONNECTION)) throw new ConnectionTypeError("PRBS Generator feature not supported on " + this.getName());
                                                if (!this.getNodeModel().provides(Feature.XCVXC)) {
                                                    throw new ConnectionTypeError("PRBS Generator feature not supported on " + this.getName());
                                                }
                                                break block37;
                                            }
                                            if (n3 != 2) break block43;
                                            SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                            selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                                            connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                            iLoDefModelArray5 = new ILoDefModel[3];
                                            if (n == 2) {
                                                iLoDefModelArray5[0] = iLoDefModelArray2[0];
                                                iLoDefModelArray5[1] = iLoDefModelArray2[1];
                                                iLoDefModelArray5[2] = iLoDefModelArray3[0];
                                                break block37;
                                            } else {
                                                if (n2 != 2) {
                                                    if (!this.dbgOn()) return;
                                                    db.println("Warning! createLoConnection: bad UPSR case");
                                                    return;
                                                }
                                                iLoDefModelArray5[0] = iLoDefModelArray3[0];
                                                iLoDefModelArray5[1] = iLoDefModelArray3[1];
                                                iLoDefModelArray5[2] = iLoDefModelArray2[0];
                                            }
                                            break block37;
                                        }
                                        if (n3 != 4) break block44;
                                        iLoDefModelArray5 = new ILoDefModel[]{iLoDefModelArray3[0], iLoDefModelArray3[1], iLoDefModelArray2[0]};
                                        break block37;
                                    }
                                    if (n3 != 3) break block45;
                                    SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                    selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                                    connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                    iLoDefModelArray5 = new ILoDefModel[]{iLoDefModelArray2[0], iLoDefModelArray2[1], iLoDefModelArray3[0], iLoDefModelArray3[1]};
                                    break block37;
                                }
                                if (n3 != 6) break block46;
                                SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                                selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                                connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                                int n6 = 2 + iLoDefModelArray3.length;
                                iLoDefModelArray5 = new ILoDefModel[n6];
                                if (iLoDefModelArray4.length <= 0) break block47;
                                if (iLoDefModelArray4.length != 2) break block48;
                                if (blArray[1] && !blArray[0]) {
                                    iLoDefModelArray5[0] = iLoDefModelArray2[0];
                                    iLoDefModelArray5[1] = iLoDefModelArray4[1];
                                    for (int i = 0; i < iLoDefModelArray3.length; ++i) {
                                        iLoDefModelArray5[i + 2] = iLoDefModelArray3[i];
                                    }
                                    break block38;
                                } else if (blArray[0] && !blArray[1]) {
                                    iLoDefModelArray5[0] = iLoDefModelArray2[0];
                                    iLoDefModelArray5[1] = iLoDefModelArray4[0];
                                    for (int i = 0; i < iLoDefModelArray3.length; ++i) {
                                        iLoDefModelArray5[i + 2] = iLoDefModelArray3[i];
                                    }
                                    break block38;
                                } else {
                                    if (!this.dbgOn()) return;
                                    db.println("Error: Both omnispans cannot be in the source ring");
                                    return;
                                }
                            }
                            iLoDefModelArray5[0] = iLoDefModelArray2[0];
                            iLoDefModelArray5[1] = iLoDefModelArray4[0];
                            for (int i = 0; i < iLoDefModelArray3.length; ++i) {
                                iLoDefModelArray5[2 + i] = iLoDefModelArray3[i];
                            }
                        }
                        if (this.dbgOn()) {
                            db.println("Unidir DRI circuit: UPSR_DC");
                        }
                        break block37;
                    }
                    if (nArray.length == 2 && nArray[0] > nArray[1]) {
                        iLoDefModelArray5[0] = iLoDefModelArray2[1];
                        iLoDefModelArray5[1] = iLoDefModelArray2[0];
                        for (int i = 0; i < iLoDefModelArray3.length; ++i) {
                            iLoDefModelArray5[i + 2] = iLoDefModelArray3[i];
                        }
                        break block37;
                    } else {
                        iLoDefModelArray5[0] = iLoDefModelArray2[0];
                        iLoDefModelArray5[1] = iLoDefModelArray2[1];
                        for (int i = 0; i < iLoDefModelArray3.length; ++i) {
                            iLoDefModelArray5[i + 2] = iLoDefModelArray3[i];
                        }
                    }
                    break block37;
                }
                if (n3 == 10) {
                    SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                    selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                    connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                    iLoDefModelArray5 = new ILoDefModel[3];
                    if (this.dbgOn()) {
                        db.println("createUpsrDri(), omniSize=" + iLoDefModelArray4.length + " inSize=" + iLoDefModelArray2.length + " outSize=" + iLoDefModelArray3.length);
                    }
                    if (!blArray[0]) {
                        iLoDefModelArray5[0] = iLoDefModelArray3[0];
                        iLoDefModelArray5[1] = iLoDefModelArray4[0];
                        iLoDefModelArray5[2] = iLoDefModelArray2[0];
                    } else {
                        iLoDefModelArray5[0] = iLoDefModelArray2[0];
                        iLoDefModelArray5[1] = iLoDefModelArray4[0];
                        iLoDefModelArray5[2] = iLoDefModelArray3[0];
                    }
                } else {
                    if (n3 != 11) {
                        if (!this.dbgOn()) return;
                        db.println("circuit Node: createLoConnection: Unknown connection type " + this.getConnectionType());
                        return;
                    }
                    SelectorAttrsOpt selectorAttrsOpt = new SelectorAttrsOpt();
                    selectorAttrsOpt.setHoUpsrAttributes(this.getUpsrAttributes());
                    connCreateAttrs.setSelectorAttrsOpt(selectorAttrsOpt);
                    iLoDefModelArray5 = new ILoDefModel[4];
                    if (this.dbgOn()) {
                        db.println("invoking createUpsrIdri()");
                    }
                    if (blArray[1] && !blArray[0]) {
                        iLoDefModelArray5[0] = iLoDefModelArray2[0];
                        iLoDefModelArray5[1] = iLoDefModelArray4[1];
                        iLoDefModelArray5[2] = iLoDefModelArray3[0];
                        iLoDefModelArray5[3] = iLoDefModelArray4[0];
                    } else if (blArray[0] && !blArray[1]) {
                        iLoDefModelArray5[0] = iLoDefModelArray2[0];
                        iLoDefModelArray5[1] = iLoDefModelArray4[0];
                        iLoDefModelArray5[2] = iLoDefModelArray3[0];
                        iLoDefModelArray5[3] = iLoDefModelArray4[1];
                    } else {
                        if (!this.dbgOn()) return;
                        db.println("Error: Both omnispans cannot be in the source ring");
                        return;
                    }
                }
            }
            this.loConn = iConnectionModels.createLoConnection(iCircuitId, n3, iLoDefModelArray5, (IConnCreateAttrs)connCreateAttrs);
            if (!NetCcatCircuit.isNullCircuitId(iCircuitId)) return;
            if (this.loConn == null) return;
            this.registerNullCircuitConnection(this.getNetElement(), this.loConn);
            return;
        }
    }

    protected NetCircuitSpan findNextBiSpanOnRoute(NetCircuitSpan netCircuitSpan) {
        IEntityModel[] iEntityModelArray = null;
        if (this.loConn != null) {
            iEntityModelArray = this.loConn.getPathEntities();
        }
        return this.findNextBiSpanOnRoute(iEntityModelArray, netCircuitSpan);
    }

    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the connection circuit Id at " + this.getName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        if (this.loConn != null) {
            this.loConn.setCircuitId(iCircuitId);
            this.cktId = iCircuitId;
            if (!NetCircuit.isNullCircuitId(iCircuitId)) {
                this.deregisterNullCircuitConnection(this.getNetElement(), this.loConn);
            }
        }
    }

    public ICircuitId getConnectionCircuitId() {
        try {
            if (this.loConn != null) {
                return this.loConn.getCircuitId();
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return null;
        }
        return null;
    }

    public int getUpsrReversionMode() {
        if (this.loConn != null) {
            return this.loConn.getUpsrReversion().getReversionMode();
        }
        return -1;
    }

    public IConnectionModel getConn() {
        return this.loConn;
    }

    protected void setConn(IConnectionModel iConnectionModel) {
        this.loConn = (ILoConnectionModel)iConnectionModel;
    }

    protected Object getRollFromPath(IRollModel iRollModel) {
        ILoRollModel iLoRollModel = (ILoRollModel)iRollModel;
        if (iLoRollModel != null) {
            return iLoRollModel.getRollFromPath();
        }
        return null;
    }

    protected Object getRollToPath(IRollModel iRollModel) {
        ILoRollModel iLoRollModel = (ILoRollModel)iRollModel;
        if (iLoRollModel != null) {
            return iLoRollModel.getRollToPath();
        }
        return null;
    }

    protected boolean isCompletedRollToPath(Object object, IRollModel iRollModel) {
        ILoRollModel iLoRollModel = (ILoRollModel)iRollModel;
        if (iLoRollModel == null) {
            return false;
        }
        try {
            if (iLoRollModel.getRollFinish() == 3) {
                NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), this.getRollToPath((IRollModel)iLoRollModel));
                NetCircuitEnd netCircuitEnd2 = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), object);
                if (netCircuitEnd2.equals(netCircuitEnd)) {
                    this.rollHasCompleted = true;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    protected IRollModel getRoll() {
        ILoRollModel iLoRollModel = null;
        if (this.inRoll()) {
            try {
                iLoRollModel = this.getConn().getNodeModel().getConnectionModels().getLoRollModels(this.getConn().getIndex());
            }
            catch (NoSuchConnection noSuchConnection) {
                iLoRollModel = null;
            }
        }
        return iLoRollModel;
    }

    protected boolean completeCheck() {
        if (this.getConn() == null) {
            if (this.dbgOn()) {
                db.println("this is the node on LAP HO grooming end which has no LO cross-connect");
            }
            return true;
        }
        return super.completeCheck();
    }

    protected boolean isDropLinkEndpoint() {
        Iterator iterator = this.sources.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                Iterator iterator2 = this.getAllSpans().keySet().iterator();
                while (iterator2.hasNext()) {
                    NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator2.next();
                    if (netCircuitEnd.getEntityIndex() != netCircuitSpan.getEntityIndex(this.getNetElement()) || netCircuitSpan.getLink().isLAP()) continue;
                    return true;
                }
            }
            iterator = this.drops.iterator();
        }
        return false;
    }

    protected int findConnType() {
        INetCircuit iNetCircuit = this.circuit.useLAP();
        if (iNetCircuit != null && this.getNetElement().getNodeId() == iNetCircuit.getPrimarySource().getNodeId() && this.totalSpans() > 1) {
            if (this.dbgOn()) {
                db.println("One than one span on this LO circuit node of LAP STS grooming end");
            }
            return -1;
        }
        return super.findConnType();
    }

    protected void removeActiveEndpoint(NetCircuitSpan netCircuitSpan) {
        if (this.getConn() == null) {
            return;
        }
        super.removeActiveEndpoint(netCircuitSpan);
    }

    protected void simulateConnection() {
        this.simulateConnection(null);
    }

    protected void simulateConnection(INetElement iNetElement, int n, IHoNum iHoNum, ILoNum iLoNum) {
        NetCircuitEnd netCircuitEnd = new NetCircuitEnd(iNetElement.getNodeId(), n, iHoNum, iLoNum, false);
        netCircuitEnd = NetCircuitEndFactory.convertCircuitEnd(this, netCircuitEnd);
        this.simulateConnection(netCircuitEnd);
    }

    protected void simulateConnection(NetCircuitEnd netCircuitEnd) {
        NetCircuitEnd netCircuitEnd2;
        NetCircuitEnd netCircuitEnd3;
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        if (this.numberOfPaths != 2 && this.dbgOn()) {
            this.debug("simulateConnection():ERROR! paths != 2  at " + this.getName());
        }
        if (this.getSources().size() != 0) {
            netCircuitEnd3 = (NetCircuitEnd)this.getSources().get(0);
            netCircuitEnd2 = netCircuitEnd == null ? this.getSpanEndpoint((NetCircuitSpan)this.getOrigSpans().get(0)) : netCircuitEnd;
        } else {
            netCircuitEnd3 = netCircuitEnd == null ? this.getSpanEndpoint((NetCircuitSpan)this.getTermSpans().get(0)) : netCircuitEnd;
            netCircuitEnd2 = (NetCircuitEnd)this.getDrops().get(0);
        }
        linkedList.add(netCircuitEnd3);
        linkedList.add(netCircuitEnd2);
        this.updateConnectionPathEnds(linkedList);
    }

    protected void setupConnListOnDiscovery() {
        if (this.circuit.getCktOperation() == 1) {
            return;
        }
        if (this.getConn() == null) {
            if (this.dbgOn()) {
                this.debug("setupConnListOnDiscovery at " + this.getName());
            }
            this.connections.clear();
            if (this.sources.size() + this.drops.size() != 1 || this.getAllSpansList().size() != 1) {
                db.println("setupConnListOnDiscovery: ERROR - invalid LAP connection on " + this.getName());
                return;
            }
            if (this.connType == 0) {
                OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                this.connections.add(onewayConnection);
                if (this.sources.size() > 0) {
                    onewayConnection.addInput(this.sources.get(0));
                    onewayConnection.addOutput(this.getAllSpansList().get(0));
                } else if (this.drops.size() > 0) {
                    onewayConnection.addOutput(this.drops.get(0));
                    onewayConnection.addInput(this.getAllSpansList().get(0));
                }
            } else if (this.connType == 1) {
                OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                this.connections.add(onewayConnection);
                OnewayConnection onewayConnection2 = new OnewayConnection("oneway2");
                this.connections.add(onewayConnection2);
                if (this.sources.size() > 0) {
                    onewayConnection.addInput(this.sources.get(0));
                    onewayConnection.addOutput(this.getAllSpansList().get(0));
                    onewayConnection2.addOutput(this.sources.get(0));
                    onewayConnection2.addInput(this.getAllSpansList().get(0));
                } else if (this.drops.size() > 0) {
                    onewayConnection.addOutput(this.drops.get(0));
                    onewayConnection.addInput(this.getAllSpansList().get(0));
                    onewayConnection2.addInput(this.drops.get(0));
                    onewayConnection2.addOutput(this.getAllSpansList().get(0));
                }
            }
            this.prettyPrintConnectionList(db);
        } else {
            super.setupConnListOnDiscovery();
        }
    }

    protected String validateConnAdminState(int n) {
        if (this.loConn == null) {
            return null;
        }
        return super.validateConnAdminState(n);
    }

    protected void setConnAdminState(int n) throws AdminStateProvisioningError {
        if (this.loConn != null) {
            super.setConnAdminState(n);
        }
    }

    public int getAdminState() {
        INetCircuitEnd iNetCircuitEnd;
        INetCircuit iNetCircuit = this.circuit.useLAP();
        if (iNetCircuit != null && (iNetCircuitEnd = iNetCircuit.getPrimarySource()) != null && this.getNetElement().getNodeId() == iNetCircuitEnd.getNodeId()) {
            return iNetCircuit.getSrcCircuitNode().getAdminState();
        }
        return super.getAdminState();
    }

    public int getServiceState() {
        INetCircuitEnd iNetCircuitEnd;
        INetCircuit iNetCircuit = this.circuit.useLAP();
        if (iNetCircuit != null && (iNetCircuitEnd = iNetCircuit.getPrimarySource()) != null && this.getNetElement().getNodeId() == iNetCircuitEnd.getNodeId()) {
            return iNetCircuit.getSrcCircuitNode().getServiceState();
        }
        return super.getServiceState();
    }

    protected boolean validateUniDirectionalConn() {
        if (this.getState() == 3 && this.getConn() == null) {
            return false;
        }
        return super.validateUniDirectionalConn();
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }
}

