/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.circuits.NetCircuitModel;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DeletionWarning;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.util.SDebug;
import cerent.util.job.IJobControl;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class NetCircuitDeleteWorker
implements IJobControl {
    INetCircuit ckt;
    int unusedPortsState;
    public static final SDebug db = new SDebug("NetCircuitDeleteWorker");

    public NetCircuitDeleteWorker(INetCircuit iNetCircuit, int n) {
        this.unusedPortsState = n;
        this.ckt = iNetCircuit;
    }

    private IPortModel[] getPortModelsForPortStateManipulation(INetCircuit iNetCircuit, String string, StringBuffer stringBuffer, Map map) {
        IPortModel[] iPortModelArray = new IPortModel[]{};
        String string2 = iNetCircuit.getCircuitName();
        if (this.unusedPortsState != -1) {
            if (NetAdminState.circuitAllowsStateApplicationToDrops(iNetCircuit)) {
                iPortModelArray = NetCircuitModel.getIndependentEndpoints(iNetCircuit, map);
            } else {
                db.info("Apply to ports ignored on " + string2);
                if (iNetCircuit.getCircuitTypeObj().isOchncType()) {
                    stringBuffer.append(string2).append(": OCHNC drops are controlled independently of the Change drop port admin state option\n");
                } else {
                    stringBuffer.append(string2).append(": Circuit type does not allow setting drop ports ").append(string).append("\n");
                }
            }
        }
        return iPortModelArray;
    }

    private Set manipulatePortStates(String string, String string2, IPortModel[] iPortModelArray, Map map) throws DeletionWarning {
        ArrayList<IPortModel> arrayList;
        StringBuffer stringBuffer;
        block8: {
            stringBuffer = new StringBuffer();
            if (this.unusedPortsState == -1 || iPortModelArray == null || map == null) {
                return new HashSet();
            }
            arrayList = new ArrayList<IPortModel>(iPortModelArray.length);
            for (int i = 0; i < iPortModelArray.length; ++i) {
                arrayList.add(iPortModelArray[i]);
            }
            if (this.unusedPortsState != -1) {
                try {
                    NetCircuitModel.setUnusedPortsState(iPortModelArray, this.unusedPortsState, map);
                }
                catch (Exception exception) {
                    stringBuffer.append(string).append(": ").append(exception.toString());
                    if (!db.on()) break block8;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        if (map.size() > 0) {
            db.info(map.size() + " ports in use and so not set to " + string2 + " on " + string);
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                IPortModel iPortModel = (IPortModel)iterator.next();
                arrayList.remove(iPortModel);
            }
        }
        HashSet hashSet = new HashSet(arrayList);
        if (map.size() > 0 || stringBuffer.length() > 0) {
            db.info("Warning on setting ports to " + string2 + " on " + string + ": set " + hashSet.size() + "; not set " + map.size() + "; " + stringBuffer.toString());
            throw new DeletionWarning(stringBuffer.toString(), string2, hashSet, map);
        }
        db.info("No trouble on " + string + " " + hashSet.size() + " ports");
        return hashSet;
    }

    public JobStatus executeJob() throws Exception {
        boolean bl = false;
        String string = NetAdminState.getAdminStateStringFromAdminState(this.unusedPortsState);
        String string2 = this.ckt.getCircuitName();
        String string3 = "Error Deleting Circuit " + string2 + ": ";
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("NCDW DEL:circuit deleting......");
        }
        HashMap hashMap = new HashMap();
        IPortModel[] iPortModelArray = this.getPortModelsForPortStateManipulation(this.ckt, string, stringBuffer, hashMap);
        try {
            this.ckt.destroyCircuit();
            this.ckt = null;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            bl = true;
            string3 = string3 + abstractCmsIOException.toString();
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            bl = true;
            string3 = string3 + incorrectCircuitState.getMessage();
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            bl = true;
            string3 = string3 + sanityCheckFailed.getMessage();
        }
        catch (DeletionError deletionError) {
            bl = true;
            string3 = string3 + deletionError.getMessage();
        }
        catch (Exception exception) {
            NetCircuitManager.debug(exception);
            bl = true;
            string3 = string3 + exception.toString();
        }
        if (bl) {
            string3 = string3 + "\n";
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("NCDW DEL:" + string3);
            }
            this.ckt.setDeletionFailureState();
            throw new DeletionError(string3);
        }
        if (stringBuffer.length() > 0) {
            db.info("Pro-forma message on " + string2);
            throw new DeletionWarning(stringBuffer.toString(), string, new HashSet(), hashMap);
        }
        db.info("Starting port manipulation on " + string2);
        Set set = this.manipulatePortStates(string2, string, iPortModelArray, hashMap);
        db.info("Job complete without error or warning on " + string2 + ": " + set.size() + " ports");
        return new JobStatus(4, (Object)set);
    }

    public String getName() {
        return "NetCktDeleteWorker";
    }

    public void abortJob() {
    }
}

