/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.EtherNodeDropCircuitEnd;
import cerent.cms.ncp.EtherP2PCircuitEnd;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.HoCircuitNode;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.LoCircuitNode;
import cerent.cms.ncp.LoTunnelCircuitEnd;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.OchTrailTunnelCircuitEnd;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchccCircuitEnd;
import cerent.cms.ncp.OchccCircuitNode;
import cerent.cms.ncp.OchncCircuitEnd;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.topo.INetElement;
import cerent.util.SDebug;

public class NetCircuitEndFactory {
    private static final SDebug db = new SDebug("NetCircuitEndFactory");

    public static NetCircuitEnd createCircuitEnd(ICircuitModel iCircuitModel, ICircuitEnd iCircuitEnd) {
        int n = iCircuitModel.getType();
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n);
        if (iCircuitType.isHoCircuitType() || iCircuitType.isHoVcatCircuitType()) {
            if (iCircuitModel.getVlanList().length > 0 && iCircuitEnd.getHoLoNum().getHoNum() == null) {
                return new EtherP2PCircuitEnd(iCircuitModel.getNodeModel(), iCircuitEnd);
            }
            return new HoCircuitEnd(iCircuitModel.getNodeModel(), iCircuitEnd);
        }
        if (iCircuitType.isEthernetCircuitType()) {
            if (NetCircuit.cktEndIsNodeDrop(iCircuitEnd)) {
                return new EtherNodeDropCircuitEnd(iCircuitModel.getNodeModel(), iCircuitEnd);
            }
            return new HoCircuitEnd(iCircuitModel.getNodeModel(), iCircuitEnd);
        }
        if (iCircuitType.isTunnelCircuitType()) {
            return new LoTunnelCircuitEnd(iCircuitModel.getNodeModel(), iCircuitEnd);
        }
        if (iCircuitType.isLAPCircuitType()) {
            return new HoCircuitEnd(iCircuitModel.getNodeModel(), iCircuitEnd);
        }
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
            return new LoCircuitEnd(iCircuitModel.getNodeModel(), iCircuitEnd);
        }
        if (iCircuitType.isOchncType()) {
            return new OchncCircuitEnd(iCircuitModel.getNodeModel(), iCircuitEnd, iCircuitModel.getCktOptChannel());
        }
        if (iCircuitType.isOchTrailTunnelCircuitType()) {
            return new OchTrailTunnelCircuitEnd(iCircuitModel.getNodeModel(), iCircuitEnd);
        }
        if (iCircuitType.isOchccCircuitType()) {
            return new OchccCircuitEnd(iCircuitModel.getNodeModel(), iCircuitEnd);
        }
        return null;
    }

    public static NetCircuitEnd createCircuitEnd(int n, INetCircuitEnd iNetCircuitEnd) {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n);
        if (iCircuitType.isHoCircuitType() || iCircuitType.isHoVcatCircuitType()) {
            if (NetCircuitEndFactory.isEtherP2PCircuitEnd(iNetCircuitEnd)) {
                return new EtherP2PCircuitEnd(iNetCircuitEnd);
            }
            return new HoCircuitEnd(iNetCircuitEnd);
        }
        if (iCircuitType.isEthernetCircuitType()) {
            if (NetCircuit.cktEndIsNodeDrop(iNetCircuitEnd)) {
                return new EtherNodeDropCircuitEnd(iNetCircuitEnd);
            }
            return new HoCircuitEnd(iNetCircuitEnd);
        }
        if (iCircuitType.isTunnelCircuitType()) {
            return new LoTunnelCircuitEnd(iNetCircuitEnd);
        }
        if (iCircuitType.isLAPCircuitType()) {
            return new HoCircuitEnd(iNetCircuitEnd);
        }
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
            return new LoCircuitEnd(iNetCircuitEnd);
        }
        if (iCircuitType.isOchTrailTunnelCircuitType()) {
            return new OchTrailTunnelCircuitEnd(iNetCircuitEnd);
        }
        if (iCircuitType.isOchncType()) {
            return new OchncCircuitEnd(iNetCircuitEnd);
        }
        if (iCircuitType.isOchccCircuitType()) {
            return new OchccCircuitEnd(iNetCircuitEnd);
        }
        return null;
    }

    public static NetCircuitEnd createCircuitEndFromConn(INetElement iNetElement, Object object) {
        if (object instanceof IHoPathDefModel) {
            int n = ((IHoPathDefModel)object).getPool().getEntityIndex();
            if (NetCircuitEndFactory.isEtherP2PCircuitEnd(iNetElement, n)) {
                return new EtherP2PCircuitEnd(iNetElement, n);
            }
            return new HoCircuitEnd(iNetElement, object);
        }
        if (object instanceof ILoDefModel) {
            return new LoCircuitEnd(iNetElement, object);
        }
        if (object instanceof IOchncPathDefModel) {
            return new OchncCircuitEnd(iNetElement, object);
        }
        if (object instanceof IOchccPathDefModel) {
            return new OchccCircuitEnd(iNetElement, object);
        }
        if (db.on()) {
            db.println("WARNING! createCircuitEndFromConn: unknown PathDefModel");
        }
        return null;
    }

    public static NetCircuitEnd convertCircuitEnd(NetCircuitNode netCircuitNode, NetCircuitEnd netCircuitEnd) {
        if (netCircuitNode instanceof HoCircuitNode) {
            int n = netCircuitEnd.getEntityIndex();
            INetElement iNetElement = netCircuitEnd.getNetElement();
            if (NetCircuitEndFactory.isEtherP2PCircuitEnd(iNetElement, n)) {
                if (!(netCircuitEnd instanceof EtherP2PCircuitEnd)) {
                    return new EtherP2PCircuitEnd(netCircuitEnd);
                }
            } else if (!(netCircuitEnd instanceof HoCircuitEnd)) {
                return new HoCircuitEnd(netCircuitEnd);
            }
        } else if (netCircuitNode instanceof LoCircuitNode) {
            if (!(netCircuitEnd instanceof LoCircuitEnd)) {
                return new LoCircuitEnd(netCircuitEnd);
            }
        } else if (netCircuitNode instanceof LoTunnelNode) {
            if (!(netCircuitEnd instanceof HoCircuitEnd)) {
                return new HoCircuitEnd(netCircuitEnd);
            }
        } else if (netCircuitNode instanceof OchncCircuitNode) {
            if (!(netCircuitEnd instanceof OchncCircuitEnd)) {
                return new OchncCircuitEnd(netCircuitEnd);
            }
        } else if (netCircuitNode instanceof OchTrailTunnelNode) {
            if (!(netCircuitEnd instanceof OchncCircuitEnd)) {
                return new OchncCircuitEnd(netCircuitEnd);
            }
        } else if (netCircuitNode instanceof OchccCircuitNode) {
            if (!(netCircuitEnd instanceof OchccCircuitEnd)) {
                return new OchccCircuitEnd(netCircuitEnd);
            }
        } else {
            if (netCircuitNode instanceof DualConnectionCircuitNode) {
                DualConnectionCircuitNode dualConnectionCircuitNode = (DualConnectionCircuitNode)netCircuitNode;
                return NetCircuitEndFactory.convertCircuitEnd(dualConnectionCircuitNode.getFstCircuitNode(), netCircuitEnd);
            }
            if (db.on()) {
                db.println("ERROR! createCircuitEnd: unknown NetCircuitNode subclass");
            }
            return null;
        }
        return netCircuitEnd;
    }

    public static NetCircuitEnd createNodeDrop(int n, INetElement iNetElement) {
        CircuitEnd circuitEnd = new CircuitEnd(iNetElement.getNodeId(), 0, null, null, false, 0);
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n);
        if (iCircuitType.isTunnelCircuitType() || iCircuitType.isLAPCircuitType()) {
            return new LoTunnelCircuitEnd(iNetElement.getNodeModel(), circuitEnd);
        }
        if (iCircuitType.isEthernetCircuitType()) {
            return new EtherNodeDropCircuitEnd(iNetElement.getNodeModel(), circuitEnd);
        }
        if (iCircuitType.isOchTrailTunnelCircuitType()) {
            return new OchTrailTunnelCircuitEnd(iNetElement.getNodeModel(), circuitEnd);
        }
        if (iCircuitType.isOchccCircuitType()) {
            return new OchccCircuitEnd(iNetElement.getNodeModel(), circuitEnd);
        }
        return null;
    }

    public static NetCircuitEnd createLoTunnelCircuitEnd(ICircuitModel iCircuitModel, ICircuitEnd iCircuitEnd) {
        return new LoTunnelCircuitEnd(iCircuitModel.getNodeModel(), iCircuitEnd);
    }

    private static boolean isEtherP2PCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        if (iNetCircuitEnd.getHoNum() == null) {
            IEntityModel iEntityModel;
            try {
                iEntityModel = iNetCircuitEnd.getEntityModel();
            }
            catch (ObjNotFound objNotFound) {
                return false;
            }
            return NetCircuitEndFactory.isEtherP2PCircuitEnd(iEntityModel);
        }
        return false;
    }

    private static boolean isEtherP2PCircuitEnd(INetElement iNetElement, int n) {
        IEntityTableModel iEntityTableModel;
        if (iNetElement == null) {
            return false;
        }
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel != null && (iEntityTableModel = iNodeModel.getEntityTable()) != null) {
            IEntityModel iEntityModel;
            try {
                iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(n);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
            return NetCircuitEndFactory.isEtherP2PCircuitEnd(iEntityModel);
        }
        return false;
    }

    private static boolean isEtherP2PCircuitEnd(IEntityModel iEntityModel) {
        if (iEntityModel == null) {
            return false;
        }
        try {
            return iEntityModel.getPayloadType() == 6;
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            return false;
        }
    }
}

