/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.CoreNodeModel;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitDirection;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoVcatTermModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoPathInfo;
import cerent.cms.model.ILoVcatTermModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IVcatTermAttributes;
import cerent.cms.model.IVcatTermModel;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.VcatTermAttributes;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitCounterThread;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.ConnectionPathNotFound;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DeletionWarning;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitManager;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.InvalidArgument;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.LoTunnelInfo;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.MissingLinks;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDeleteWorker;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitPath;
import cerent.cms.ncp.NetCircuitProtectionSwitchWorker;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.NetModelMemorySizer;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.ProtectionSwitchError;
import cerent.cms.ncp.ProtectionSwitchHelper;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.INetwork;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.ui.helper.PortHelper;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.AnnotatedException;
import cerent.util.ComparisonUtil;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IAsyncObserver;
import cerent.util.IDebugDiag;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.IMetrics;
import cerent.util.PluralisationUtil;
import cerent.util.SDebug;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobGroupListener;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;

public class NetCircuitManager
extends CmsObservable
implements INetCircuitManager,
IJobGroupListener {
    private static final SDebug db = new SDebug("NetCircuitManager");
    private static final SDebug pkgDb = new SDebug("NcpPackage");
    private static boolean pkgDbgSuppressed = false;
    public DumpDebug dumpDb;
    protected static final HoLoComparator holoComp = HoLoComparator.instance();
    private static NetCircuitManager manager;
    private Map cktList;
    private Set nullIdCktList;
    private Map vcatMemCktList;
    private Set nullIdVcatMemCktList;
    private Map lapCktList;
    private Set nullIdLapCktList;
    private Object masterCktListLock;
    private Network net;
    private VlanSetManager vlanSetManager;
    private NetCircuitSplicer splicer;
    private NetCircuitWatchDog watchDog;
    private HashMap circuitNameMap;
    private JobController createJobController;
    private JobGroup deleteJobGroup;
    private JobController deleteJobController;
    private JobGroup protectionSwitchJobGroup;
    private JobController protectionSwitchJobController;
    private JobGroup provAdminStateJobGroup;
    private int targetUnusedPortsState;
    private Thread protectionSwitchThread = null;

    public static synchronized NetCircuitManager instance() {
        if (manager == null) {
            VlanSetManager vlanSetManager;
            Network network = Network.instance();
            if (network == null) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("Unable to instantiate Circuit Manager- null network");
                }
                return null;
            }
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Obtained ref. to network. creating circuit manager");
            }
            if ((vlanSetManager = VlanSetManager.instance()) == null) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("Unable to get VLAN set manager instance");
                }
                return null;
            }
            manager = new NetCircuitManager(network, vlanSetManager);
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Network Circuit Manager created ");
            }
        }
        return manager;
    }

    public void init() {
        this.dumpDb = new DumpDebug("Circuits");
        if (IMetrics.circuitDb.on()) {
            this.dumpDb.enableCircuitCounter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.dumpDb.dispose();
        Object object = this.masterCktListLock;
        synchronized (object) {
            NetCircuit netCircuit;
            Iterator<Object> iterator = this.cktList.values().iterator();
            while (iterator.hasNext()) {
                netCircuit = (NetCircuit)iterator.next();
                netCircuit.dispose();
                iterator.remove();
            }
            iterator = this.nullIdCktList.iterator();
            while (iterator.hasNext()) {
                netCircuit = (NetCircuit)iterator.next();
                netCircuit.dispose();
                iterator.remove();
            }
            iterator = this.lapCktList.values().iterator();
            while (iterator.hasNext()) {
                netCircuit = (NetCircuit)iterator.next();
                netCircuit.dispose();
                iterator.remove();
            }
            iterator = this.nullIdLapCktList.iterator();
            while (iterator.hasNext()) {
                netCircuit = (NetCircuit)iterator.next();
                netCircuit.dispose();
                iterator.remove();
            }
            iterator = this.vcatMemCktList.values().iterator();
            while (iterator.hasNext()) {
                netCircuit = (NetCircuit)iterator.next();
                netCircuit.dispose();
                iterator.remove();
            }
            iterator = this.nullIdVcatMemCktList.iterator();
            while (iterator.hasNext()) {
                netCircuit = (NetCircuit)iterator.next();
                netCircuit.dispose();
                iterator.remove();
            }
        }
    }

    private NetCircuitManager(Network network, VlanSetManager vlanSetManager) {
        this.init();
        this.net = network;
        this.vlanSetManager = vlanSetManager;
        this.createJobController = null;
        this.deleteJobGroup = null;
        this.deleteJobController = null;
        this.provAdminStateJobGroup = null;
        this.cktList = new TreeMap(new CircuitIdComparator());
        this.nullIdCktList = new HashSet();
        this.lapCktList = new TreeMap(new CircuitIdComparator());
        this.nullIdLapCktList = new HashSet();
        this.vcatMemCktList = new TreeMap(new CircuitIdComparator());
        this.nullIdVcatMemCktList = new HashSet();
        this.masterCktListLock = new Object();
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Circuit Manager- Creating Splicer object");
        }
        this.splicer = NetCircuitSplicer.instance();
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Circuit Manager- Creating WatchDog object");
        }
        this.watchDog = NetCircuitWatchDog.instance();
        this.circuitNameMap = new HashMap();
    }

    public void dumpCircuitCount() {
        this.dumpDb.circuitCount();
    }

    protected int connCircuitSize(Object object) {
        if (object instanceof IHoConnectionModel) {
            IHoConnectionModel iHoConnectionModel = (IHoConnectionModel)object;
            IHoPathDefModel[] iHoPathDefModelArray = iHoConnectionModel.getPaths();
            if (iHoPathDefModelArray.length == 0) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("connCircuitSize: Warning! empty path array");
                }
                return -1;
            }
            return CircuitSize.width2sizeOfHoCircuit((int)iHoPathDefModelArray[0].getPathWidth(), (int)iHoPathDefModelArray[0].getStartingHo().getFramingType()).getEnum();
        }
        if (object instanceof ILoAditModel) {
            INodeModel iNodeModel = ((ILoAditModel)object).getNodeModel();
            int n = iNodeModel.getFramingType();
            return CircuitSize.getLoTunnelSize((int)n).getEnum();
        }
        if (object instanceof ILoConnectionModel) {
            ILoConnectionModel iLoConnectionModel = (ILoConnectionModel)object;
            ILoDefModel[] iLoDefModelArray = iLoConnectionModel.getPaths();
            ILoNum iLoNum = iLoDefModelArray[0].getLoNum();
            if (iLoDefModelArray.length == 0) {
                if (NetCircuitManager.dbgOn()) {
                    db.println("connCircuitSize: Warning! empty path array");
                }
                return -1;
            }
            return CircuitSize.width2sizeOfLoCircuit((int)iLoNum.getLoPathWidth()).getEnum();
        }
        if (object instanceof IOchncConnectionModel) {
            IOchncConnectionModel iOchncConnectionModel = (IOchncConnectionModel)object;
            IOchncPathDefModel[] iOchncPathDefModelArray = iOchncConnectionModel.getPaths();
            if (iOchncPathDefModelArray.length == 0) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("connCircuitSize: Warning! empty path array");
                }
                return -1;
            }
            return iOchncPathDefModelArray[0].getCircuitSize();
        }
        if (object instanceof IOchccConnectionModel) {
            IOchccConnectionModel iOchccConnectionModel = (IOchccConnectionModel)object;
            IOchccPathDefModel[] iOchccPathDefModelArray = iOchccConnectionModel.getPaths();
            if (iOchccPathDefModelArray.length == 0) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("connCircuitSize: Warning! empty path array");
                }
                return -1;
            }
            return iOchccPathDefModelArray[0].getService();
        }
        if (object instanceof IOchTrailAditModel) {
            IOchTrailAditModel iOchTrailAditModel = (IOchTrailAditModel)object;
            IOchncPathDefModel[] iOchncPathDefModelArray = iOchTrailAditModel.getPaths();
            if (iOchncPathDefModelArray.length == 0) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("connCircuitSize: Warning! empty path array");
                }
                return -1;
            }
            return iOchncPathDefModelArray[0].getCircuitSize();
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Warning! connCircuitSize: unknown connection type");
        }
        return -1;
    }

    protected int connCircuitType(Object object) {
        int n = -1;
        if (object instanceof IModel) {
            INodeModel iNodeModel = ((IModel)object).getNodeModel();
            int n2 = iNodeModel.getFramingType();
            IFramingType iFramingType = FramingType.getFramingType((int)n2);
            if (object instanceof IHoConnectionModel) {
                IHoConnectionModel iHoConnectionModel = (IHoConnectionModel)object;
                n = iHoConnectionModel.getIntendedType() == 8 ? 0 : iFramingType.getHoCircuitType();
            } else if (object instanceof ILoConnectionModel) {
                n = iFramingType.getLoCircuitType();
            } else if (object instanceof ILoAditModel) {
                n = iFramingType.getAggCircuitType();
            } else if (object instanceof IOchncConnectionModel) {
                n = 9;
            } else if (object instanceof IOchTrailAditModel) {
                n = 15;
            } else if (object instanceof IOchccConnectionModel) {
                n = 14;
            } else if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Warning! connCircuitType: unknown connection type");
            }
        }
        return n;
    }

    protected int connCircuitDir(Object object) {
        int n = -1;
        if (object instanceof IHoConnectionModel) {
            IHoConnectionModel iHoConnectionModel = (IHoConnectionModel)object;
            n = iHoConnectionModel.getIntendedType();
        } else if (object instanceof ILoConnectionModel) {
            ILoConnectionModel iLoConnectionModel = (ILoConnectionModel)object;
            n = iLoConnectionModel.getConnectionType();
        } else {
            if (object instanceof ILoAditModel) {
                return 1;
            }
            if (object instanceof IOchTrailAditModel) {
                return 1;
            }
            if (object instanceof IOchccConnectionModel) {
                return 1;
            }
            if (object instanceof IOchncConnectionModel) {
                IOchncConnectionModel iOchncConnectionModel = (IOchncConnectionModel)object;
                n = iOchncConnectionModel.getConnectionType();
            } else if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Warning! connCircuitDir: unknown connection type");
            }
        }
        return NetCircuitNode.getConnDir(n);
    }

    protected int connCircuitAdminState(Object object) {
        block3: {
            IConnectionModel iConnectionModel;
            INodeModel iNodeModel;
            if (object instanceof IConnectionModel && Feature.provides((INodeModel)(iNodeModel = (iConnectionModel = (IConnectionModel)object).getNodeModel()), (Feature)Feature.ENHANCED_STATE_MODEL)) {
                try {
                    return iConnectionModel.getAdminState();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (!NetCircuitManager.dbgOn()) break block3;
                    NetCircuitManager.debug("unknown admin state" + exception.getMessage());
                }
            }
        }
        return -1;
    }

    protected String connCircuitName(Object object) {
        block3: {
            IConnectionModel iConnectionModel;
            INodeModel iNodeModel;
            if (object instanceof IConnectionModel && Feature.provides((INodeModel)(iNodeModel = (iConnectionModel = (IConnectionModel)object).getNodeModel()), (Feature)Feature.TCCU)) {
                try {
                    return iConnectionModel.getConnectionName();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (!NetCircuitManager.dbgOn()) break block3;
                    NetCircuitManager.debug("Problem getting connection name" + exception.getMessage());
                }
            }
        }
        return "";
    }

    protected int vcatTermCircuitSize(Object object) {
        if (object instanceof IHoVcatTermModel) {
            IHoVcatTermModel iHoVcatTermModel = (IHoVcatTermModel)object;
            int n = iHoVcatTermModel.getNodeModel().getFramingType();
            return CircuitSize.width2sizeOfHoCircuit((int)iHoVcatTermModel.getHoPathWidth(), (int)n).getEnum();
        }
        if (object instanceof ILoVcatTermModel) {
            ILoVcatTermModel iLoVcatTermModel = (ILoVcatTermModel)object;
            return CircuitSize.width2sizeOfLoCircuit((int)iLoVcatTermModel.getLoPathWidth()).getEnum();
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Warning! connCircuitSize: unknown connection type");
        }
        return -1;
    }

    protected int vcatTermCircuitType(Object object) {
        if (object instanceof IModel) {
            int n = ((IModel)object).getNodeModel().getFramingType();
            IFramingType iFramingType = FramingType.getFramingType((int)n);
            if (object instanceof IHoVcatTermModel) {
                return iFramingType.getHoVcatCircuitType();
            }
            if (object instanceof ILoVcatTermModel) {
                return iFramingType.getLoVcatCircuitType();
            }
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Warning! connCircuitType: unknown connection type");
            }
        }
        return -1;
    }

    protected int vcatTermCircuitDir(Object object) {
        if (object instanceof IVcatTermModel) {
            return ((IVcatTermModel)object).getDirection();
        }
        return -1;
    }

    protected int vcatTermCircuitAdminState(Object object) {
        block3: {
            IVcatTermModel iVcatTermModel;
            INodeModel iNodeModel;
            if (object instanceof IVcatTermModel && Feature.provides((INodeModel)(iNodeModel = (iVcatTermModel = (IVcatTermModel)object).getNodeModel()), (Feature)Feature.ENHANCED_STATE_MODEL)) {
                try {
                    return iVcatTermModel.getAdminState();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (!NetCircuitManager.dbgOn()) break block3;
                    NetCircuitManager.debug("unknown admin state" + exception.getMessage());
                }
            }
        }
        return -1;
    }

    protected String vcatTermCircuitName(Object object) {
        block3: {
            IVcatTermModel iVcatTermModel;
            INodeModel iNodeModel;
            if (object instanceof IVcatTermModel && Feature.provides((INodeModel)(iNodeModel = (iVcatTermModel = (IVcatTermModel)object).getNodeModel()), (Feature)Feature.TCCU)) {
                try {
                    return iVcatTermModel.getVcatName();
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    if (!NetCircuitManager.dbgOn()) break block3;
                    NetCircuitManager.debug("Problem getting vcat term name" + exception.getMessage());
                }
            }
        }
        return "";
    }

    public int[] deleteCheck(INetCircuit[] iNetCircuitArray) {
        int[] nArray = null;
        int[] nArray2 = new int[iNetCircuitArray.length];
        int n = 0;
        int n2 = 0;
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("DEL: deleteCheck entered......");
        }
        for (n2 = 0; n2 < iNetCircuitArray.length; ++n2) {
            try {
                iNetCircuitArray[n2].circuitDeleteCheck();
                continue;
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("DEL: invalid index " + n2);
                }
                nArray2[n++] = n2;
            }
        }
        if (n > 0) {
            nArray = new int[n];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("DEL: invalid count is " + n);
            }
            for (n2 = 0; n2 < n; ++n2) {
                nArray[n2] = nArray2[n2];
                if (!NetCircuitManager.dbgOn()) continue;
                NetCircuitManager.debug("DEL: invalid index " + nArray[n2]);
            }
        }
        return nArray;
    }

    public INetCircuit[] getOchccsForTunnel(INetCircuit iNetCircuit) {
        Object object;
        Object object2;
        Object object3;
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Retrieving OCHCC's for circuit " + iNetCircuit.getCircuitName());
        }
        if (iNetCircuit.getState() == 1 || iNetCircuit.getState() == 5) {
            INetCircuit iNetCircuit2;
            object3 = this.getCircuits(iNetCircuit.getSrcCircuitNode().getNodeModel());
            object2 = this.getCircuits(((NetCircuitDropInfo)iNetCircuit.getDrops().get(0)).getNodeModel());
            object = new LinkedList();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                iNetCircuit2 = (INetCircuit)iterator.next();
                if (!iNetCircuit2.getCircuitTypeObj().isOchccCircuitType() || !object2.contains(iNetCircuit2)) continue;
                object.add(iNetCircuit2);
            }
            iterator = object.iterator();
            block1: while (iterator.hasNext()) {
                iNetCircuit2 = (INetCircuit)iterator.next();
                List list = iNetCircuit2.getCircuitSpans();
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    OchTrailTunnelNetLink ochTrailTunnelNetLink;
                    INetCircuit iNetCircuit3;
                    INetCircuitSpan iNetCircuitSpan = (INetCircuitSpan)iterator2.next();
                    INetLink iNetLink = iNetCircuitSpan.getLink();
                    if (iNetLink == null || !(iNetLink instanceof OchTrailTunnelNetLink) || (iNetCircuit3 = (ochTrailTunnelNetLink = (OchTrailTunnelNetLink)iNetLink).getLotCircuit()) == null || !iNetCircuit3.equals(iNetCircuit)) continue;
                    if (NetCircuitManager.dbgOn()) {
                        NetCircuitManager.debug("OCHCC added: " + iNetCircuit2.getCircuitName());
                    }
                    linkedList.add(iNetCircuit2);
                    continue block1;
                }
            }
        }
        if (NetCircuitManager.dbgOn()) {
            object3 = new StringBuffer("OCHCC's for circuit " + iNetCircuit.getCircuitName() + ": ");
            object2 = linkedList.iterator();
            while (object2.hasNext()) {
                object = (INetCircuit)object2.next();
                ((StringBuffer)object3).append(" " + object.getCircuitName());
            }
            NetCircuitManager.debug(((StringBuffer)object3).toString());
        }
        return linkedList.toArray(new INetCircuit[0]);
    }

    private INetCircuit[] adjustedCircuitsToDelete(INetCircuit[] iNetCircuitArray) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Starting adjustedCircuitsToDelete (" + iNetCircuitArray.length + " circuits)");
        }
        List<INetCircuit> list = Arrays.asList(iNetCircuitArray);
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        Iterator<INetCircuit> iterator = list.iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = iterator.next();
            if (iNetCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                INetCircuit[] iNetCircuitArray2 = this.getOchccsForTunnel(iNetCircuit);
                boolean bl = true;
                for (int i = 0; bl && i < iNetCircuitArray2.length; ++i) {
                    if (list.contains(iNetCircuitArray2[i])) continue;
                    if (NetCircuitManager.dbgOn()) {
                        NetCircuitManager.debug("Cannot find OCHCC " + iNetCircuitArray2[i].getCircuitName() + " - OTT not removed");
                    }
                    bl = false;
                }
                if (iNetCircuitArray2.length == 0 || !bl) {
                    if (NetCircuitManager.dbgOn()) {
                        NetCircuitManager.debug("OTT " + iNetCircuit.getCircuitName() + " added to adjusted list");
                    }
                    linkedList.add(iNetCircuit);
                    continue;
                }
                if (!NetCircuitManager.dbgOn()) continue;
                NetCircuitManager.debug("OTT " + iNetCircuit.getCircuitName() + " removed since all its OCHCCs are already in");
                continue;
            }
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Adding non OTT circuit " + iNetCircuit.getCircuitName());
            }
            linkedList.add(iNetCircuit);
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Exiting adjustedCircuitsToDelete (" + linkedList.size() + " circuits)");
        }
        return linkedList.toArray(new INetCircuit[0]);
    }

    public boolean deleteSelectedCircuits(INetCircuit[] iNetCircuitArray, int n, IAsyncObserver iAsyncObserver) throws DeletionError {
        iNetCircuitArray = this.adjustedCircuitsToDelete(iNetCircuitArray);
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        String string = null;
        String string2 = null;
        int n2 = iNetCircuitArray.length;
        if (n2 < 1) {
            return false;
        }
        if (this.deleteJobGroup != null) {
            throw new DeletionError("Another delete job already in progress.\nPlease wait until that job completes");
        }
        if (this.deleteJobController == null) {
            this.deleteJobController = JobControllerFactory.createJC((int)5);
        }
        if (this.deleteJobController == null) {
            throw new DeletionError("Unable to create jobs");
        }
        for (int i = 0; i < n2; ++i) {
            boolean bl = false;
            if (iNetCircuitArray[i].getState() == 2) continue;
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("DEL: sanity check......");
            }
            try {
                iNetCircuitArray[i].destroySanityCheck();
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                bl = true;
                string2 = sanityCheckFailed.toString();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                bl = true;
                string2 = abstractCmsIOException.toString();
            }
            if (bl) {
                if (string == null) {
                    string = "Following Circuits Could Not Be Scheduled For Deletion\n";
                }
                string = string + "Error deleting circuit " + iNetCircuitArray[i].getCircuitName() + ": ";
                string = string + string2 + "\n";
                if (!NetCircuitManager.dbgOn()) continue;
                NetCircuitManager.debug("deleteSelectedCircuits: " + string);
                continue;
            }
            linkedList.add(iNetCircuitArray[i]);
        }
        INetCircuit[] iNetCircuitArray2 = new INetCircuit[linkedList.size()];
        iNetCircuitArray2 = linkedList.toArray(iNetCircuitArray2);
        n2 = iNetCircuitArray2.length;
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("NCP said delete " + n2 + " circuits");
        }
        if (n2 < 1) {
            if (string != null) {
                throw new DeletionError(string);
            }
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            iNetCircuitArray2[i].setState(2);
        }
        IJobControl[] iJobControlArray = new IJobControl[n2];
        for (int i = 0; i < n2; ++i) {
            iJobControlArray[i] = new NetCircuitDeleteWorker(iNetCircuitArray2[i], n);
        }
        this.targetUnusedPortsState = n;
        this.deleteJobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)this, (Object)iAsyncObserver);
        this.deleteJobController.submitJob(this.deleteJobGroup);
        if (string != null) {
            throw new DeletionError(string);
        }
        return true;
    }

    public boolean deleteSelectedCircuits(INetCircuit[] iNetCircuitArray, IAsyncObserver iAsyncObserver) throws DeletionError {
        return this.deleteSelectedCircuits(iNetCircuitArray, -1, iAsyncObserver);
    }

    protected JobController getCreateJc() {
        if (this.createJobController == null) {
            this.createJobController = JobControllerFactory.createJC((int)5);
        }
        return this.createJobController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertCircuit(INetCircuit iNetCircuit, boolean bl) {
        if (!iNetCircuit.isCircuitRefValid() || iNetCircuit.getCircuitId() == null) {
            return;
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("insertCircuit(" + iNetCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
        }
        Object object = this.masterCktListLock;
        synchronized (object) {
            if (iNetCircuit.isMemberOfVcat()) {
                if (iNetCircuit.hasNullCircuitId()) {
                    this.nullIdVcatMemCktList.add(iNetCircuit);
                } else {
                    this.nullIdVcatMemCktList.remove(iNetCircuit);
                    this.vcatMemCktList.put(iNetCircuit.getCircuitId(), iNetCircuit);
                }
            } else if (iNetCircuit.hasNullCircuitId()) {
                this.nullIdCktList.add(iNetCircuit);
                this.insertCircuitIfLAP(iNetCircuit);
            } else {
                this.nullIdCktList.remove(iNetCircuit);
                this.cktList.put(iNetCircuit.getCircuitId(), iNetCircuit);
                this.insertCircuitIfLAP(iNetCircuit);
            }
        }
        if (bl) {
            this.notifyChanged(iNetCircuit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertCircuitIfLAP(INetCircuit iNetCircuit) {
        Object object = this.masterCktListLock;
        synchronized (object) {
            if (iNetCircuit.getCircuitTypeObj().isLAPCircuitType()) {
                if (iNetCircuit.hasNullCircuitId()) {
                    this.nullIdLapCktList.add(iNetCircuit);
                } else {
                    this.lapCktList.put(iNetCircuit.getCircuitId(), iNetCircuit);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCircuitIfLAP(INetCircuit iNetCircuit) {
        Object object = this.masterCktListLock;
        synchronized (object) {
            if (iNetCircuit.getCircuitTypeObj().isLAPCircuitType()) {
                if (iNetCircuit.hasNullCircuitId()) {
                    this.nullIdLapCktList.remove(iNetCircuit);
                } else {
                    this.lapCktList.remove(iNetCircuit.getCircuitId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCircuit(INetCircuit iNetCircuit) {
        if (iNetCircuit.getCircuitId() == null) {
            return;
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("removeCircuit(" + iNetCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
        }
        Object object = this.masterCktListLock;
        synchronized (object) {
            if (iNetCircuit.isMemberOfVcat()) {
                if (iNetCircuit.hasNullCircuitId()) {
                    this.nullIdVcatMemCktList.remove(iNetCircuit);
                } else {
                    this.vcatMemCktList.remove(iNetCircuit.getCircuitId());
                }
            } else if (iNetCircuit.hasNullCircuitId()) {
                this.nullIdCktList.remove(iNetCircuit);
                this.removeCircuitIfLAP(iNetCircuit);
            } else {
                this.cktList.remove(iNetCircuit.getCircuitId());
                this.removeCircuitIfLAP(iNetCircuit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertCcatToMember(INetCircuit iNetCircuit) {
        if (!iNetCircuit.isCircuitRefValid() || iNetCircuit.getCircuitId() == null) {
            return;
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("convertCcatToMember(" + iNetCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
        }
        Object object = this.masterCktListLock;
        synchronized (object) {
            if (iNetCircuit.hasNullCircuitId()) {
                this.nullIdCktList.remove(iNetCircuit);
                this.nullIdVcatMemCktList.add(iNetCircuit);
            } else {
                this.cktList.remove(iNetCircuit.getCircuitId());
                this.vcatMemCktList.put(iNetCircuit.getCircuitId(), iNetCircuit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertMemberToCcat(INetCircuit iNetCircuit) {
        if (!iNetCircuit.isCircuitRefValid() || iNetCircuit.getCircuitId() == null) {
            return;
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("convertMemberToCcat(" + iNetCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
        }
        Object object = this.masterCktListLock;
        synchronized (object) {
            if (iNetCircuit.hasNullCircuitId()) {
                this.nullIdVcatMemCktList.remove(iNetCircuit);
                this.nullIdCktList.add(iNetCircuit);
            } else {
                this.vcatMemCktList.remove(iNetCircuit.getCircuitId());
                this.cktList.put(iNetCircuit.getCircuitId(), iNetCircuit);
            }
        }
    }

    public Set getAffectedNodes(int n, int n2) {
        HashSet hashSet = new HashSet();
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getAffectedNodes: oldNodeId = " + n + "New NodeID = " + n2);
            NetCircuitManager.debug("Examining each Circuit ... ");
        }
        LinkedList linkedList = this.getAllCTCCircuits(n2);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetCircuit netCircuit = (NetCircuit)iterator.next();
            Set set = netCircuit.getAffectedNodes(n, n2);
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAffectedNodes for Circuit: " + NetCircuit.prettyString(netCircuit.getCircuitId()));
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    NetCircuitManager.debug("getAffectedNodes: Node " + ((INodeModel)iterator2.next()).getName());
                }
            }
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public int repairCircuits(int n, int n2) throws CircuitProvError {
        int n3 = 0;
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("repairCircuits: oldNodeId = " + n + " newNodeId = " + n2);
            NetCircuitManager.debug("Examining each Circuit ... ");
        }
        LinkedList linkedList = this.getAllCTCCircuits(n2);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetCircuit netCircuit = (NetCircuit)iterator.next();
            if (netCircuit.isMemberOfVcat() || !netCircuit.repairCircuit(n, n2)) continue;
            ++n3;
        }
        return n3;
    }

    protected List getAvailSourcePorts(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo, boolean bl, IEntityModel iEntityModel) {
        List list = this.getAvailSourcePorts(iNodeModel, circuitCreatInfo, bl);
        if (iEntityModel == null) {
            return list;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel2 = (IEntityModel)iterator.next();
            if (iEntityModel2.getPayloadType() == iEntityModel.getPayloadType()) continue;
            iterator.remove();
        }
        return list;
    }

    public List getAvailSourcePorts(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo, boolean bl) {
        LinkedList linkedList = new LinkedList();
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getAvailSourcePorts node is " + iNodeModel);
        }
        if (circuitCreatInfo == null) {
            return linkedList;
        }
        linkedList.addAll(this.getAvailPortEntities(iNodeModel, circuitCreatInfo, bl, null));
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAvailSourcePorts: looking for LAP circuit");
            }
            List list = this.getAvailLAPEntities(iNodeModel, circuitCreatInfo.size(), bl, null);
            linkedList.addAll(list);
        }
        return linkedList;
    }

    public List getFirstAvailPairPPorts(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo) {
        List list = new LinkedList();
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getFirstAvailPairPPorts on node " + iNodeModel);
        }
        if (circuitCreatInfo == null) {
            return list;
        }
        if (iNodeModel == null || !iNodeModel.getConnectionState()) {
            return list;
        }
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        if (iEntityTableModel == null) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("unable to find entity table model");
            }
            return list;
        }
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)circuitCreatInfo.size());
        if (iCircuitType.isHoCircuitType() || iCircuitType.isLAPCircuitType()) {
            short s = iCircuitSize.size2widthOfHoCircuit();
            if (iNodeModel.provides(Feature.DS3XM12)) {
                list = iEntityTableModel.getFirstAvailPairPPorts(s);
            }
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getFirstAvailPairPPorts(" + iNodeModel.getName() + "): returning " + list.size() + " entities");
        }
        return list;
    }

    protected List getAvailPortEntities(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo, boolean bl, INetCircuit iNetCircuit) {
        int n = circuitCreatInfo.type();
        int n2 = circuitCreatInfo.size();
        int n3 = circuitCreatInfo.dir();
        int n4 = circuitCreatInfo.cktOptChannel();
        int n5 = circuitCreatInfo.lcasMode();
        int n6 = circuitCreatInfo.forwardMembers();
        int n7 = circuitCreatInfo.reverseMembers();
        boolean bl2 = circuitCreatInfo.isDiag();
        List list = new LinkedList();
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getAvailPortEntities(" + iNodeModel.getName() + "):" + " " + EnumStrings.getString((Class)ICircuitType.class, (int)n) + " " + EnumStrings.getString((Class)ICircuitSize.class, (int)n2) + " " + EnumStrings.getString((Class)ICircuitDirection.class, (int)n3) + (bl2 ? " Diagnostic Circuit" : "") + (bl ? " protectedOnly" : ""));
        }
        if (iNodeModel == null || !iNodeModel.getConnectionState()) {
            return list;
        }
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        if (iEntityTableModel == null) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("unable to find entity table model");
            }
            return list;
        }
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n);
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n2);
        if (iCircuitType.isLoCircuitType()) {
            short s = iCircuitSize.size2widthOfLoCircuit();
            list = iEntityTableModel.getAvailEntitiesForLo((int)s, bl);
            if (bl2) {
                this.filterDiagPorts(list);
            }
        } else if (iCircuitType.isLoVcatCircuitType()) {
            if (iNodeModel.provides(Feature.VCAT)) {
                VcatTermAttributes vcatTermAttributes = new VcatTermAttributes((short)n6, (short)n7, n5, n3, false);
                short s = iCircuitSize.size2widthOfLoCircuit();
                list = iEntityTableModel.getAvailEntitiesForLoVcat((int)s, (IVcatTermAttributes)vcatTermAttributes, bl);
            }
        } else if (iCircuitType.isHoVcatCircuitType()) {
            if (iNodeModel.provides(Feature.VCAT)) {
                VcatTermAttributes vcatTermAttributes = new VcatTermAttributes((short)n6, (short)n7, n5, n3, false);
                short s = iCircuitSize.size2widthOfHoCircuit();
                list = iEntityTableModel.getAvailEntitiesForHoVcat(s, (IVcatTermAttributes)vcatTermAttributes, bl);
            }
        } else if (circuitCreatInfo.isEnhancedOchnc()) {
            list = iNetCircuit == null ? OchPortsHelper.getAddPortsForOchnc(iNodeModel, n4) : OchPortsHelper.getDropPortsForOchnc(iNodeModel, n4);
        } else if (iCircuitType.isOchccCircuitType()) {
            List list2 = OchTrailHelper.filterNodeForOchTrail(circuitCreatInfo, iNetCircuit, iNodeModel);
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("Found " + list2.size() + "OCHCC entities for " + " node " + iNodeModel);
            }
            list.addAll(list2);
        } else {
            short s = iCircuitSize.size2widthOfHoCircuit();
            list = iEntityTableModel.getAvailEntitiesForHo(s, n3, bl);
            if (iCircuitType.isLAPCircuitType()) {
                LinkedList linkedList = new LinkedList();
                iEntityTableModel.lapFilterEntities(list, linkedList);
                return linkedList;
            }
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getAvailPortEntities(" + iNodeModel.getName() + "): returning " + list.size() + " entities");
        }
        return list;
    }

    public List getAvailSourcePoints(INodeModel iNodeModel, IEntityModel iEntityModel, CircuitCreatInfo circuitCreatInfo) {
        ArrayList arrayList = new ArrayList();
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getAvailSourcePoints @ " + iNodeModel);
        }
        if (circuitCreatInfo == null) {
            return arrayList;
        }
        arrayList.addAll(this.getAvailPortPaths(iNodeModel, iEntityModel, circuitCreatInfo.type(), circuitCreatInfo.size(), circuitCreatInfo.forwardMembers(), new ArrayList()));
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
            List list = this.getAvailLAPPaths(iNodeModel, iEntityModel, circuitCreatInfo.size(), null);
            arrayList.addAll(list);
        }
        return arrayList;
    }

    protected List getAvailPortPaths(INodeModel iNodeModel, IEntityModel iEntityModel, int n, int n2, int n3, List list) {
        ArrayList arrayList = new ArrayList();
        if (iNodeModel == null || iEntityModel == null || !iNodeModel.canSupportCircuitSize(n2)) {
            return arrayList;
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getAvailPortPaths(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ") excluded endpts=" + list.size());
        }
        if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.PARTIAL_PCA_CIRCUITS)) {
            IPoolModel iPoolModel = iNodeModel.getPoolModels().getPoolModel(iEntityModel.getEntityIndex());
            return this.getAvailPoolPaths(iPoolModel, iNodeModel, iEntityModel, n, n2, n3, list);
        }
        IPoolModel[] iPoolModelArray = iNodeModel.getPoolModels().getPoolModels(iEntityModel.getEntityIndex());
        if (iPoolModelArray == null || iPoolModelArray.length == 0) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAvailPortPaths: null PoolModel array");
            }
            return arrayList;
        }
        Iterator<IPoolModel> iterator = Arrays.asList(iPoolModelArray).iterator();
        while (iterator.hasNext()) {
            IPoolModel iPoolModel = iterator.next();
            arrayList.addAll(this.getAvailPoolPaths(iPoolModel, iNodeModel, iEntityModel, n, n2, n3, list));
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getAvailPortPaths(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ") returning " + arrayList.size() + " endpts");
        }
        return arrayList;
    }

    private List getAvailPoolPaths(IPoolModel iPoolModel, INodeModel iNodeModel, IEntityModel iEntityModel, int n, int n2, int n3, List list) {
        short s;
        IPathInfo[] iPathInfoArray;
        ArrayList arrayList = new ArrayList();
        if (iPoolModel == null || iNodeModel == null || iEntityModel == null) {
            return arrayList;
        }
        IHoNum iHoNum = iPoolModel.includedPath().getStartingHo();
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getAvailPoolPaths(" + iNodeModel.getName() + "::" + Integer.toHexString(iEntityModel.getEntityIndex()) + ")" + " baseHo=" + iHoNum + ", excluded endpts=" + list.size());
        }
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        int n4 = iNodeModel.getFramingType();
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n);
        ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n2);
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
            iPathInfoArray = CircuitSize.getLoTunnelSize((int)n4);
            s = iPathInfoArray.size2widthOfHoCircuit();
        } else {
            s = iCircuitSize.size2widthOfHoCircuit();
        }
        iPathInfoArray = !iCircuitType.isVcatCircuitType() ? iPoolModel.getAvailablePaths(s) : iPoolModel.getAvailableVcatPaths(s, (short)n3);
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("pathInfoList size is " + iPathInfoArray.length);
        }
        if (iCircuitType.isLoCircuitType() || iCircuitType.isLoVcatCircuitType()) {
            ILoNum iLoNum;
            LoCircuitEnd loCircuitEnd;
            Object object;
            IHoNum iHoNum2;
            ILoAditModel[] iLoAditModelArray = null;
            short s2 = iCircuitSize.size2widthOfLoCircuit();
            iLoAditModelArray = iConnectionModels.getLoAditsInPool(iPoolModel);
            Iterator<ILoAditModel> iterator = Arrays.asList(iLoAditModelArray).iterator();
            while (iterator.hasNext()) {
                ILoAditModel iLoAditModel = iterator.next();
                iHoNum2 = HoPathDefModel.physicalHo(iLoAditModel.getHo());
                object = iLoAditModel.getAvailableLos((int)s2);
                Iterator<ILoPathInfo> iterator2 = Arrays.asList(object).iterator();
                while (iterator2.hasNext()) {
                    ILoPathInfo iLoPathInfo = iterator2.next();
                    loCircuitEnd = this.getAutoAssignedLoCktEnd(iNodeModel, iEntityModel);
                    if (loCircuitEnd != null) {
                        this.addToReturnList(loCircuitEnd, arrayList, list);
                        if (NetCircuitManager.dbgOn()) {
                            NetCircuitManager.debug("getAvailPoolPaths() returning " + arrayList.size() + " endpts");
                        }
                        return arrayList;
                    }
                    iLoNum = iLoPathInfo.getLoNum();
                    loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoNum2, iLoNum, false);
                    this.addToReturnList(loCircuitEnd, arrayList, list);
                }
            }
            iterator = Arrays.asList(iPathInfoArray).iterator();
            while (iterator.hasNext()) {
                IPathInfo iPathInfo = (IPathInfo)iterator.next();
                loCircuitEnd = this.getAutoAssignedLoCktEnd(iNodeModel, iEntityModel);
                if (loCircuitEnd != null) {
                    this.addToReturnList(loCircuitEnd, arrayList, list);
                    break;
                }
                iHoNum2 = HoPathDefModel.physicalHo(iPoolModel, iPathInfo.getStartingHo());
                object = HoLoFactory.getAllLoNums(iEntityModel.getMaxLo(n2), n4, n2);
                for (int i = 0; i < object.size(); ++i) {
                    iLoNum = (ILoNum)object.get(i);
                    loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoNum2, iLoNum, false);
                    this.addToReturnList(loCircuitEnd, arrayList, list);
                }
            }
        } else {
            Iterator<IPathInfo> iterator = Arrays.asList(iPathInfoArray).iterator();
            while (iterator.hasNext()) {
                IPathInfo iPathInfo = iterator.next();
                HoCircuitEnd hoCircuitEnd = this.getAutoAssignedHoCktEnd(iNodeModel, iEntityModel);
                if (hoCircuitEnd != null) {
                    this.addToReturnList(hoCircuitEnd, arrayList, list);
                    break;
                }
                IHoNum iHoNum3 = HoPathDefModel.physicalHo(iPoolModel, iPathInfo.getStartingHo());
                hoCircuitEnd = new HoCircuitEnd(iNodeModel, iEntityModel, iHoNum3, null, false);
                this.addToReturnList(hoCircuitEnd, arrayList, list);
            }
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getAvailPoolPaths() returning " + arrayList.size() + " endpts");
        }
        return arrayList;
    }

    private void addToReturnList(NetCircuitEnd netCircuitEnd, List list, List list2) {
        if (!list2.contains(netCircuitEnd)) {
            list.add(netCircuitEnd);
        }
    }

    public LoCircuitEnd getAutoAssignedLoCktEnd(INodeModel iNodeModel, IEntityModel iEntityModel) {
        LoCircuitEnd loCircuitEnd = null;
        if (iEntityModel.getPayloadType() == 14 || iEntityModel.getPayloadType() == 17 || iEntityModel.getPayloadType() == 18) {
            IHoNum iHoNum = null;
            ILoNum iLoNum = null;
            loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoNum, iLoNum, false);
        }
        return loCircuitEnd;
    }

    public HoCircuitEnd getAutoAssignedHoCktEnd(INodeModel iNodeModel, IEntityModel iEntityModel) {
        HoCircuitEnd hoCircuitEnd = null;
        if (iEntityModel.getPayloadType() == 6 || iEntityModel.getPayloadType() == 8 || iEntityModel.getPayloadType() == 14 || iEntityModel.getPayloadType() == 13 || iEntityModel.getPayloadType() == 17 || iEntityModel.getPayloadType() == 18) {
            IHoNum iHoNum = null;
            ILoNum iLoNum = null;
            hoCircuitEnd = new HoCircuitEnd(iNodeModel, iEntityModel, iHoNum, iLoNum, false);
        }
        return hoCircuitEnd;
    }

    protected List getAvailLAPEntities(INodeModel iNodeModel, int n, boolean bl, NetCircuit netCircuit) {
        Object object;
        ILoAditModel iLoAditModel;
        Object object2;
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        List list = this.getLAPHoNode(iNodeModel);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ICircuitSize iCircuitSize;
            short s;
            ILoPathInfo[] iLoPathInfoArray;
            object2 = (HoCcatCircuit)iterator.next();
            if (netCircuit != null && netCircuit.getState() == 1 && netCircuit.isCircuitProtected() && !((NetCircuit)object2).isCircuitProtected() || (iLoPathInfoArray = (iLoAditModel = (ILoAditModel)((LoTunnelNode)(object = (LoTunnelNode)((HoCcatCircuit)object2).getLoTunnelNodes().get(0))).getConn()).getAvailableLos((int)(s = (iCircuitSize = CircuitSize.getCircuitSize((int)n)).size2widthOfLoCircuit()))).length == 0) continue;
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAvailLAPEntities find available path " + ((NetCircuit)object2).getCircuitName());
            }
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)((NetCircuit)object2).getCktSources().get(0);
            try {
                IEntityModel iEntityModel = netCircuitEnd.getEntityModel();
                linkedList.add(iEntityModel);
            }
            catch (ObjNotFound objNotFound) {
                if (!NetCircuitManager.dbgOn()) continue;
                NetCircuitManager.debug("getAvailLAPEntities hit exception with LAP " + ((NetCircuit)object2).getCircuitName());
            }
        }
        object2 = iNodeModel.getEntityTable();
        object = linkedList.toArray();
        iLoAditModel = new IEntityModel[linkedList.size()];
        for (int i = 0; i < linkedList.size(); ++i) {
            iLoAditModel[i] = (IEntityModel)object[i];
        }
        LinkedList linkedList2 = new LinkedList();
        if (iNodeModel.provides(Feature.SCREEN_ENTITIES)) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("screenAvailEntities called");
            }
            object2.screenAvailEntities((IEntityModel[])iLoAditModel, linkedList2, bl);
            return linkedList2;
        }
        return linkedList;
    }

    protected List getAvailLAPPaths(INodeModel iNodeModel, IEntityModel iEntityModel, int n, NetCircuit netCircuit) {
        LinkedList<LoCircuitEnd> linkedList = new LinkedList<LoCircuitEnd>();
        List list = this.getLAPHoEntity(iNodeModel, iEntityModel);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            HoCcatCircuit hoCcatCircuit = (HoCcatCircuit)iterator.next();
            if (netCircuit != null && netCircuit.getState() == 1 && netCircuit.isCircuitProtected() && !hoCcatCircuit.isCircuitProtected()) continue;
            LoTunnelNode loTunnelNode = (LoTunnelNode)hoCcatCircuit.getLoTunnelNodes().get(0);
            ILoAditModel iLoAditModel = (ILoAditModel)loTunnelNode.getConn();
            ICircuitSize iCircuitSize = CircuitSize.getCircuitSize((int)n);
            short s = iCircuitSize.size2widthOfLoCircuit();
            ILoPathInfo[] iLoPathInfoArray = iLoAditModel.getAvailableLos((int)s);
            IHoNum iHoNum = ((NetCircuitEnd)hoCcatCircuit.getCktSources().get(0)).getHoNum();
            if (iLoPathInfoArray.length == 0) continue;
            Iterator<ILoPathInfo> iterator2 = Arrays.asList(iLoPathInfoArray).iterator();
            while (iterator2.hasNext()) {
                ILoPathInfo iLoPathInfo = iterator2.next();
                LoCircuitEnd loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoNum, iLoPathInfo.getLoNum(), false);
                linkedList.add(loCircuitEnd);
            }
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("getAvailLAPPaths: return " + linkedList.size() + " paths");
        }
        return linkedList;
    }

    public boolean canCreateStitchedCircuit(INodeModel iNodeModel, CircuitCreatInfo circuitCreatInfo) {
        boolean bl = false;
        if (iNodeModel instanceof CoreNodeModel) {
            return false;
        }
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        if ((iCircuitType.isEthernetCircuitType() || iCircuitType.isHoCircuitType()) && circuitCreatInfo.dir() == 1) {
            short s = circuitCreatInfo.sizeObj().size2widthOfHoCircuit();
            IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
            bl = iConnectionModels.getBiggestEtherpathAvailable() >= s;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoTunnelNeeded(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs) {
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        boolean bl = false;
        INetElement iNetElement = ((INetCircuitEnd)list.get(0)).getNetElement();
        if (list.size() > 1) {
            routePrefs2.setSecDst(((INetCircuitEnd)list.get(1)).getNetElement());
        }
        if (iNetCircuit.doesCircuitUseNetElem(iNetElement)) {
            if (NetCircuitManager.dbgOn()) {
                db.println("isLoTunnelNeeded: Circuit Node already in circuit. No tunnel is needed");
            }
            return false;
        }
        boolean bl2 = false;
        routePrefs2.setSrc(iNetCircuit.getPrimarySource().getNetElement());
        if (iNetCircuit.getSecondarySource() != null && iNetCircuit.getSecondarySource().getNodeId() != iNetCircuit.getPrimarySource().getNodeId()) {
            routePrefs2.setSecSrc(iNetCircuit.getSecondarySource().getNetElement());
        }
        INetCircuit iNetCircuit2 = iNetCircuit;
        synchronized (iNetCircuit2) {
            block16: {
                try {
                    ((NetCircuit)iNetCircuit).routeCurrentDrop(iNetElement, routePrefs2, false);
                    if (NetCircuitManager.dbgOn()) {
                        db.println("isLoTunnelNeeded: Able to find LO route. No tunnel is required");
                    }
                }
                catch (CTCUserException cTCUserException) {
                    bl2 = true;
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    if (!NetCircuitManager.dbgOn()) break block16;
                    db.println("isLoTunnelNeeded: hit exception on the circuit" + sanityCheckFailed);
                    SDebug.printStackTrace((Throwable)sanityCheckFailed);
                }
            }
            if (bl2) {
                if (routePrefs2.getPathProt() != 5) {
                    if (NetCircuitManager.dbgOn()) {
                        db.println("isLoTunnelNeeded: Unable to find LO route. Tunnel is required");
                    }
                    bl = true;
                } else if (NetCircuitManager.dbgOn()) {
                    db.println("isLoTunnelNeeded: Unable to find LO route. For DRI protection Tunnel will not help");
                }
            }
            return bl;
        }
    }

    public boolean canHaveOptionalLot(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs) {
        boolean bl;
        block15: {
            bl = false;
            if (NetCircuitManager.dbgOn()) {
                db.println("canHaveOptionalLot:");
            }
            if (iNetCircuit.useLAP() != null) {
                return bl;
            }
            if (list.size() == 1) {
                INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)list.get(0);
                try {
                    if (this.getLAPHo(iNetCircuitEnd.getNodeModel(), iNetCircuitEnd.getEntityModel(), iNetCircuitEnd.getHoNum()) != null) {
                        return bl;
                    }
                }
                catch (ObjNotFound objNotFound) {
                    if (NetCircuitManager.dbgOn()) {
                        db.println("canHaveOptionalLot checking LAP availability failed on exception");
                    }
                    return bl;
                }
            }
            try {
                NetCircuitPath netCircuitPath = this.loTunnelGetCircuitPath(iNetCircuit, list, routePrefs);
                if (netCircuitPath == null) {
                    if (NetCircuitManager.dbgOn()) {
                        db.println("loTunnelGetCircuitPath does not find LOT");
                    }
                    bl = false;
                } else {
                    int n = iNetCircuit instanceof NetVcatCircuit && ((NetVcatCircuit)iNetCircuit).getRoutePrefs().getFwdDropPrefs().isCommonFiber() ? ((NetVcatCircuit)iNetCircuit).getAllMemberCircuits().size() : 1;
                    bl = !netCircuitPath.singleHopOrExistingLotHavingBw(iNetCircuit.getCircuitSize(), iNetCircuit.getCircuitType(), iNetCircuit.getSla(), n);
                }
            }
            catch (NoRoute noRoute) {
                if (NetCircuitManager.dbgOn()) {
                    db.println("Caught an exception");
                }
            }
            catch (AllocFailed allocFailed) {
                if (!NetCircuitManager.dbgOn()) break block15;
                db.println("Caught an exception");
            }
        }
        if (NetCircuitManager.dbgOn()) {
            db.println("canHaveOptionalLot returns " + bl);
        }
        return bl;
    }

    private NetCircuitPath loTunnelGetCircuitPath(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs) throws NoRoute, AllocFailed {
        INetElement iNetElement = ((INetCircuitEnd)list.get(0)).getNetElement();
        if (iNetCircuit.doesCircuitUseNetElem(iNetElement)) {
            return null;
        }
        INetElement iNetElement2 = iNetCircuit.getSrcNetElement();
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        routePrefs2.setSrc(iNetCircuit.getPrimarySource().getNetElement());
        if (iNetCircuit.getSecondarySource() != null) {
            routePrefs2.setSecSrc(iNetCircuit.getSecondarySource().getNetElement());
        }
        routePrefs2.setDst(iNetElement);
        if (list.size() > 1) {
            routePrefs2.setSecDst(((INetCircuitEnd)list.get(1)).getNetElement());
        }
        int n = iNetElement2.getNodeModel().getFramingType();
        routePrefs2.setCircuitSizeToAllMembers(CircuitSize.getLoTunnelSize((int)n).getEnum());
        routePrefs2.setRequiredSpans(iNetCircuit.getRequiredSpans());
        routePrefs2.setCircuitType(CircuitType.getCircuitType((int)n).getEnum());
        routePrefs2.setPathOnly(false);
        routePrefs2.setTunnel(true);
        if (iNetCircuit.getCircuitTypeObj().isVcatCircuitType()) {
            int n2 = 0;
            int n3 = routePrefs2.getActiveDropPrefs().isCommonFiber() ? routePrefs2.getMemberCount() : routePrefs2.getActiveDropPrefs().getMemberGroupPrefs().size();
            int n4 = HoLoFactory.getAllLoNums(n, iNetCircuit.getCircuitSize()).size();
            int n5 = n3 % n4;
            n2 = n5 == 0 ? n3 / n4 + 1 : (n3 - n5) / n4 + 1;
            if (routePrefs2.getActiveDropPrefs().isCommonFiber()) {
                routePrefs2.getActiveDropPrefs().getActiveMemberGroupPrefs().setMemberCount(n2);
            } else {
                LinkedList linkedList = new LinkedList();
                Iterator iterator = routePrefs2.getActiveDropPrefs().getMemberGroupPrefs().iterator();
                for (n5 = n2; iterator.hasNext() && n5 > 0; --n5) {
                    linkedList.add(iterator.next());
                }
                routePrefs2.getActiveDropPrefs().setMemberGroupPrefs(linkedList);
            }
        }
        NetCircuitPath netCircuitPath = new NetCircuitPath(routePrefs2, null);
        netCircuitPath.computeCircuitPath();
        return netCircuitPath;
    }

    public List createLoTunnel(INetCircuit iNetCircuit, INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs, boolean bl) throws Exception {
        LinkedList<INetCircuitEnd> linkedList = new LinkedList<INetCircuitEnd>();
        linkedList.add(iNetCircuitEnd);
        return this.createLoTunnel(iNetCircuit, linkedList, routePrefs, bl);
    }

    public List createLoTunnel(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs, boolean bl) throws Exception {
        if (NetCircuitManager.dbgOn()) {
            db.println("createLoTunnels: ");
        }
        List list2 = this.createLoTunnels(iNetCircuit, list, routePrefs);
        if (NetCircuitManager.dbgOn()) {
            db.info("createLoTunnel " + bl + " got " + list2.size() + " tunnel");
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            LoTunnelInfo loTunnelInfo = (LoTunnelInfo)iterator.next();
            boolean bl2 = true;
            AnnotatedException annotatedException = null;
            if (!loTunnelInfo.required() && !bl) continue;
            try {
                db.info("createLoTunnel: provisioning required Lo tunnel");
                loTunnelInfo.tunnel().provision();
                bl2 = false;
            }
            catch (Exception exception) {
                annotatedException = new AnnotatedException("Unable to create required LO tunnel", exception);
            }
            if (!bl2) continue;
            try {
                db.info("createLoTunnel: destroying LO tunnel");
                loTunnelInfo.tunnel().destroyCircuit();
            }
            catch (Exception exception) {
                throw new AnnotatedException("Unable to destroy LO tunnel", exception);
            }
            if (annotatedException == null) continue;
            throw annotatedException;
        }
        return list2;
    }

    public List createLoTunnels(INetCircuit iNetCircuit, INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws NoRoute, AllocFailed {
        LinkedList<INetCircuitEnd> linkedList = new LinkedList<INetCircuitEnd>();
        linkedList.add(iNetCircuitEnd);
        return this.createLoTunnels(iNetCircuit, linkedList, routePrefs);
    }

    public List createLoTunnels(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs) throws NoRoute, AllocFailed {
        if (NetCircuitManager.dbgOn()) {
            db.println("createLoTunnels: ");
        }
        LinkedList linkedList = new LinkedList();
        NetCircuitPath netCircuitPath = this.loTunnelGetCircuitPath(iNetCircuit, list, routePrefs);
        if (netCircuitPath == null) {
            if (NetCircuitManager.dbgOn()) {
                db.println("loTunnelGetCircuitPath does not find LOT");
            }
            return linkedList;
        }
        try {
            int n = iNetCircuit instanceof NetVcatCircuit && ((NetVcatCircuit)iNetCircuit).getRoutePrefs().getFwdDropPrefs().isCommonFiber() ? ((NetVcatCircuit)iNetCircuit).getAllMemberCircuits().size() : 1;
            linkedList = netCircuitPath.getLoTunnels(iNetCircuit.getCircuitSize(), iNetCircuit.getCircuitType(), iNetCircuit.getSla(), iNetCircuit.tl1Compatible(), n);
            if (NetCircuitManager.dbgOn()) {
                db.println("Found a route for the LO Tunnels");
            }
        }
        catch (NoRoute noRoute) {
            throw new NoRoute("Unable to route VT Circuit: possible reasons: \n1) VT Tunnel required and cannot route due to XCs in the path from source to destination\n2) Cannot find route that satisfies given requirements");
        }
        return linkedList;
    }

    public List findLoTunnels(INetElement iNetElement, INetElement iNetElement2) {
        return this.findLoTunnels(iNetElement, iNetElement2, true);
    }

    public List findLoTunnels(INetElement iNetElement, INetElement iNetElement2, boolean bl) {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        List list = this.net.findAllLoTunnelNetLinks(iNetElement, iNetElement2, bl);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetLink netLink = (NetLink)iterator.next();
            NetCircuit netCircuit = (NetCircuit)netLink.getLotCircuit();
            linkedList.add(netCircuit);
        }
        return linkedList;
    }

    protected NetCircuit findLoTunnel(INetLink iNetLink, IHoNum iHoNum, IHoNum iHoNum2) {
        INetElement iNetElement = iNetLink.getSrc();
        INetElement iNetElement2 = iNetLink.getDst();
        if (NetCircuitManager.dbgOn()) {
            db.println("findLoTunnel: on " + iNetLink.prettyString());
        }
        Iterator iterator = this.findLoTunnels(iNetElement, iNetElement2, true).iterator();
        while (iterator.hasNext()) {
            NetCircuit netCircuit = (NetCircuit)iterator.next();
            NetCircuitNode netCircuitNode = (NetCircuitNode)netCircuit.getCircuitNodeFromNE(iNetElement);
            NetCircuitNode netCircuitNode2 = (NetCircuitNode)netCircuit.getCircuitNodeFromNE(iNetElement2);
            if (netCircuitNode == null || netCircuitNode2 == null) continue;
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)netCircuitNode.biSpans().get(0);
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)netCircuitNode2.biSpans().get(0);
            if (netCircuitSpan.getEntityIndex(iNetElement) != iNetLink.getSrcEntityIndex() || netCircuitSpan2.getEntityIndex(iNetElement2) != iNetLink.getDstEntityIndex() || !holoComp.isEqual(netCircuitSpan.getSrcHoNum(), iHoNum) || !holoComp.isEqual(netCircuitSpan2.getDstHoNum(), iHoNum2)) continue;
            if (NetCircuitManager.dbgOn()) {
                db.println("findLoTunnel: on " + iNetLink.prettyString() + " with srcHo " + iHoNum.getHoNum() + " with dstHo " + iHoNum2.getHoNum());
            }
            return netCircuit;
        }
        return null;
    }

    public List createOchTrailTunnel(INetCircuit iNetCircuit, RoutePrefs routePrefs, int n) throws NoRoute, AllocFailed, Exception {
        Object object;
        Object object2;
        Object object3;
        IEntityModel[] iEntityModelArray;
        IEntityModel[] iEntityModelArray2;
        LinkedList<INetCircuit> linkedList;
        block25: {
            linkedList = new LinkedList<INetCircuit>();
            if (NetCircuitManager.dbgOn()) {
                db.println("createOchTrailTunnel using Channel " + iNetCircuit.getCircuitOptChannel());
            }
            iEntityModelArray2 = new IEntityModel[]{};
            iEntityModelArray = new IEntityModel[]{};
            try {
                iEntityModelArray2 = OchTrailHelper.getTrunkPorts(routePrefs.getSrc().getNodeModel(), routePrefs.getcktSrcEntityIndex());
                iEntityModelArray = OchTrailHelper.getTrunkPorts(routePrefs.getDst().getNodeModel(), routePrefs.getcktDstEntityIndex());
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (NetCircuitManager.dbgOn()) {
                    db.println("Exception getting trunk ports " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
            catch (NoSuchEquipment noSuchEquipment) {
                if (!NetCircuitManager.dbgOn()) break block25;
                db.println("Exception getting trunk ports " + (Object)((Object)noSuchEquipment));
            }
        }
        if (iEntityModelArray2.length != 0 || iEntityModelArray.length != 0) {
            object3 = this.findOchTrailTunnel(routePrefs.getSrc(), iEntityModelArray2[0].getEntityIndex());
            if (object3 != null) {
                if (n == 3) {
                    int n2;
                    INetCircuit iNetCircuit2 = ((NetLink)object3).getLotCircuit();
                    if (NetCircuitManager.dbgOn()) {
                        db.println("OTT ckt for link " + object3 + " is " + (iNetCircuit2 == null ? "null" : iNetCircuit2.getCircuitName()));
                    }
                    if (iNetCircuit2 != null && (n2 = iNetCircuit2.getAdminState()) != 0 && n2 != 3) {
                        if (NetCircuitManager.dbgOn()) {
                            db.println("Forcing OTT circuit " + iNetCircuit2.getCircuitName() + " to IS, AINS");
                        }
                        iNetCircuit2.setAdminState(n);
                    }
                }
                return linkedList;
            }
        } else {
            throw new NoRoute("Unable to route OchTrail Circuit, trunk ports unavailable");
        }
        List list = this.getCircuitPathForOchTrailTunnel(routePrefs, iEntityModelArray2, iEntityModelArray);
        object3 = list.iterator();
        while (object3.hasNext()) {
            try {
                object2 = (NetCircuitPath)object3.next();
                object = ((NetCircuitPath)object2).getOchTrailTunnel(n);
                if (object == null) continue;
                linkedList.add((INetCircuit)object);
            }
            catch (NoRoute noRoute) {
                if (!linkedList.isEmpty()) {
                    object = (INetCircuit)linkedList.get(0);
                    object.destroyCircuit();
                }
                throw new NoRoute("Unable to route OchTrail Circuit");
            }
        }
        if (!linkedList.isEmpty()) {
            object2 = linkedList.iterator();
            while (object2.hasNext()) {
                if (NetCircuitManager.dbgOn()) {
                    db.println("OchTrail Tunnel Circuit Provisioning");
                }
                object = null;
                boolean bl = true;
                INetCircuit iNetCircuit3 = (INetCircuit)object2.next();
                try {
                    iNetCircuit3.provision();
                    bl = false;
                }
                catch (Exception exception) {
                    object = new AnnotatedException("Unable to create required OchTrail tunnel", exception);
                }
                if (!bl) continue;
                try {
                    if (NetCircuitManager.dbgOn()) {
                        db.println("createOchTrailTunnel: destroying OchTrail tunnel");
                    }
                    object2 = linkedList.iterator();
                    while (object2.hasNext()) {
                        iNetCircuit3 = (INetCircuit)object2.next();
                        iNetCircuit3.destroyCircuit();
                    }
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Unable to destroy OchTrail tunnel", exception);
                }
                if (object == null) continue;
                throw object;
            }
        }
        return linkedList;
    }

    private List getCircuitPathForOchTrailTunnel(RoutePrefs routePrefs, IEntityModel[] iEntityModelArray, IEntityModel[] iEntityModelArray2) throws NoRoute, AllocFailed {
        LinkedList<NetCircuitPath> linkedList = new LinkedList<NetCircuitPath>();
        NetCircuitPath netCircuitPath = null;
        NetCircuitPath netCircuitPath2 = null;
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        routePrefs2.setCircuitSize(CircuitSize.SIZE_OCHNC_ENS.getEnum());
        routePrefs2.setCircuitType(15);
        routePrefs2.setDirectionality(3);
        routePrefs2.setTunnel(true);
        routePrefs2.setcktSrcEntityIndex(iEntityModelArray[0].getEntityIndex());
        routePrefs2.setcktDstEntityIndex(iEntityModelArray2[0].getEntityIndex());
        netCircuitPath = new NetCircuitPath(routePrefs2, null);
        netCircuitPath.computeCircuitPath();
        if (iEntityModelArray.length == 2 && iEntityModelArray2.length == 2) {
            RoutePrefs routePrefs3 = new RoutePrefs(routePrefs2);
            routePrefs3.setcktSrcEntityIndex(iEntityModelArray[1].getEntityIndex());
            routePrefs3.setcktDstEntityIndex(iEntityModelArray2[1].getEntityIndex());
            netCircuitPath2 = new NetCircuitPath(routePrefs3, null);
            netCircuitPath2.computeCircuitPath();
        }
        linkedList.add(netCircuitPath);
        if (netCircuitPath2 != null) {
            linkedList.add(netCircuitPath2);
        }
        return linkedList;
    }

    public INetLink findOchTrailTunnel(INetElement iNetElement, int n) {
        INetLink iNetLink = this.net.findOchTrailTunnelNetLink(iNetElement, n);
        if (iNetLink != null) {
            if (NetCircuitManager.dbgOn()) {
                db.println("OchTrail tunnel already exists " + iNetLink.prettyString());
            }
        } else if (NetCircuitManager.dbgOn()) {
            db.println("No OchTrail tunnels for given requirements");
        }
        return iNetLink;
    }

    protected Object getMasterCktListLock() {
        return this.masterCktListLock;
    }

    public LinkedList getAllCTCCircuits(int n) {
        INetCircuit iNetCircuit;
        INetCircuit iNetCircuit2;
        INetCircuit iNetCircuit3;
        INetCircuit iNetCircuit4;
        INetCircuit iNetCircuit5;
        INetCircuit iNetCircuit6;
        INetCircuit iNetCircuit7;
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        INetElement iNetElement = this.net.findNetElem(n);
        if (iNetElement == null) {
            return linkedList;
        }
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel == null) {
            return linkedList;
        }
        IHoConnectionModel[] iHoConnectionModelArray = iNodeModel.getConnectionModels().getHoConnectionModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of Ho Connections: " + iHoConnectionModelArray.length);
        }
        for (int i = 0; i < iHoConnectionModelArray.length; ++i) {
            IHoConnectionModel iHoConnectionModel = iHoConnectionModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetCircuit.prettyString(iHoConnectionModel.getCircuitId()) + ")");
            }
            if (NetCircuit.isNullCircuitId(iHoConnectionModel.getCircuitId())) continue;
            iNetCircuit7 = this.getCircuitFromId(iHoConnectionModel.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit7.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit7.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit7);
        }
        IOchncConnectionModel[] iOchncConnectionModelArray = iNodeModel.getConnectionModels().getOchncConnectionModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of OCHNC Connections: " + iOchncConnectionModelArray.length);
        }
        for (int i = 0; i < iOchncConnectionModelArray.length; ++i) {
            iNetCircuit7 = iOchncConnectionModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetCircuit.prettyString(iNetCircuit7.getCircuitId()) + ")");
            }
            if (NetCircuit.isNullCircuitId(iNetCircuit7.getCircuitId())) continue;
            iNetCircuit6 = this.getCircuitFromId(iNetCircuit7.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit6.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit6.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit6);
        }
        IOchTrailAditModel[] iOchTrailAditModelArray = iNodeModel.getConnectionModels().getOchTrailAditModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of OchTrail Adits: " + iOchTrailAditModelArray.length);
        }
        for (int i = 0; i < iOchTrailAditModelArray.length; ++i) {
            iNetCircuit6 = iOchTrailAditModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetCircuit.prettyString(iNetCircuit6.getCircuitId()) + ")");
            }
            if (iNetCircuit6.getCircuitId().getUniquePart().getUniqueId() == 0) continue;
            iNetCircuit5 = this.getCircuitFromId(iNetCircuit6.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit5.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit5.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit5);
        }
        IOchccConnectionModel[] iOchccConnectionModelArray = iNodeModel.getConnectionModels().getOchccConnectionModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of OCHCC Connections: " + iOchccConnectionModelArray.length);
        }
        for (int i = 0; i < iOchccConnectionModelArray.length; ++i) {
            iNetCircuit5 = iOchccConnectionModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetCircuit.prettyString(iNetCircuit5.getCircuitId()) + ")");
            }
            if (NetCircuit.isNullCircuitId(iNetCircuit5.getCircuitId())) continue;
            iNetCircuit4 = this.getCircuitFromId(iNetCircuit5.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit4.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit4.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit4);
        }
        ILoConnectionModel[] iLoConnectionModelArray = iNodeModel.getConnectionModels().getLoConnectionModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of Lo Connections: " + iLoConnectionModelArray.length);
        }
        for (int i = 0; i < iLoConnectionModelArray.length; ++i) {
            iNetCircuit4 = iLoConnectionModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetCircuit.prettyString(iNetCircuit4.getCircuitId()) + ")");
            }
            if (NetCircuit.isNullCircuitId(iNetCircuit4.getCircuitId())) continue;
            iNetCircuit3 = this.getCircuitFromId(iNetCircuit4.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit3.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit3.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit3);
        }
        ILoAditModel[] iLoAditModelArray = iNodeModel.getConnectionModels().getLoAditModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of Lo Adits: " + iLoAditModelArray.length);
        }
        for (int i = 0; i < iLoAditModelArray.length; ++i) {
            iNetCircuit3 = iLoAditModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetCircuit.prettyString(iNetCircuit3.getCircuitId()) + ")");
            }
            if (iNetCircuit3.getCircuitId().getUniquePart().getUniqueId() == 0) continue;
            iNetCircuit2 = this.getCircuitFromId(iNetCircuit3.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit2.getCircuitName() + ", " + NetCircuit.prettyString(iNetCircuit2.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit2);
        }
        IHoVcatTermModel[] iHoVcatTermModelArray = iNodeModel.getVcatTermModels().getHoVcatTermModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of vcat terms: " + iHoVcatTermModelArray.length);
        }
        for (int i = 0; i < iHoVcatTermModelArray.length; ++i) {
            iNetCircuit2 = iHoVcatTermModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetVcatCircuit.prettyString(iNetCircuit2.getCircuitId()) + ")");
            }
            if (NetVcatCircuit.isNullCircuitId(iNetCircuit2.getCircuitId())) continue;
            iNetCircuit = this.getCircuitFromId(iNetCircuit2.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit.getCircuitName() + ", " + NetVcatCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit);
        }
        ILoVcatTermModel[] iLoVcatTermModelArray = iNodeModel.getVcatTermModels().getLoVcatTermModels();
        if (NetCircuitManager.dbgOn()) {
            db.println("Number of vcat terms: " + iLoVcatTermModelArray.length);
        }
        for (int i = 0; i < iLoVcatTermModelArray.length; ++i) {
            iNetCircuit = iLoVcatTermModelArray[i];
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits: ( Circuit ID" + NetVcatCircuit.prettyString(iNetCircuit.getCircuitId()) + ")");
            }
            if (NetVcatCircuit.isNullCircuitId(iNetCircuit.getCircuitId())) continue;
            INetCircuit iNetCircuit8 = this.getCircuitFromId(iNetCircuit.getCircuitId());
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("getAllCTCCircuits(" + iNetCircuit8.getCircuitName() + ", " + NetVcatCircuit.prettyString(iNetCircuit8.getCircuitId()) + ")");
            }
            linkedList.add(iNetCircuit8);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCircuits() {
        LinkedList linkedList;
        Object object = this.masterCktListLock;
        synchronized (object) {
            linkedList = new LinkedList(this.cktList.values());
            linkedList.addAll(this.nullIdCktList);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getLAPCircuits() {
        LinkedList linkedList;
        Object object = this.masterCktListLock;
        synchronized (object) {
            linkedList = new LinkedList(this.lapCktList.values());
            linkedList.addAll(this.nullIdLapCktList);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getMemberCircuits() {
        LinkedList linkedList;
        Object object = this.masterCktListLock;
        synchronized (object) {
            linkedList = new LinkedList(this.vcatMemCktList.values());
            linkedList.addAll(this.nullIdVcatMemCktList);
        }
        return linkedList;
    }

    public INetCircuit getCircuitFromCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        INetLink iNetLink = this.getNetLinkFromEndpoint(iNetCircuitEnd, false);
        Iterator iterator = this.getCircuits().iterator();
        while (iterator.hasNext()) {
            NetCircuit netCircuit = (NetCircuit)iterator.next();
            Iterator iterator2 = netCircuit.getCktSources().iterator();
            for (int i = 0; i < 2; ++i) {
                while (iterator2.hasNext()) {
                    NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator2.next();
                    if (!netCircuitEnd.equals(iNetCircuitEnd)) continue;
                    return netCircuit;
                }
                iterator2 = netCircuit.getDropCktEnds().iterator();
            }
            NetCircuitNode netCircuitNode = (NetCircuitNode)netCircuit.getCircuitNodeFromNE(iNetCircuitEnd.getNetElement());
            if (netCircuitNode == null || iNetLink == null) continue;
            if (netCircuitNode.getSpliceListener(iNetCircuitEnd, false) != null) {
                return netCircuit;
            }
            if (!netCircuitNode.isRollToCktEnd((NetCircuitEnd)iNetCircuitEnd)) continue;
            return netCircuit;
        }
        return null;
    }

    public List getCircuits(INodeModel iNodeModel) {
        List list = new LinkedList();
        INetElement iNetElement = null;
        if (iNodeModel != null) {
            iNetElement = this.net.findNetElem(iNodeModel);
        }
        if (iNetElement != null) {
            list = this.getCircuits();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NetCircuit netCircuit = (NetCircuit)iterator.next();
                if (netCircuit.usesNetElement(iNetElement)) continue;
                iterator.remove();
            }
        }
        return list;
    }

    public List getCircuits(INodeModel iNodeModel, int n) {
        NetCircuit netCircuit = null;
        INetElement iNetElement = null;
        List list = this.getCircuits(iNodeModel);
        ArrayList<NetCircuit> arrayList = new ArrayList<NetCircuit>();
        if (iNodeModel != null) {
            iNetElement = this.net.findNetElem(iNodeModel);
        }
        Iterator iterator = list.iterator();
        block2: while (iterator.hasNext()) {
            netCircuit = (NetCircuit)iterator.next();
            INetCircuitNode iNetCircuitNode = netCircuit.getCircuitNodeFromNE(iNetElement);
            List list2 = iNetCircuitNode.getPathList();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                IPathDefModel iPathDefModel = (IPathDefModel)iterator2.next();
                try {
                    IEntityModel iEntityModel;
                    IOchccPathDefModel iOchccPathDefModel;
                    if (iPathDefModel instanceof IOchccPathDefModel) {
                        iOchccPathDefModel = (IOchccPathDefModel)iPathDefModel;
                        if (!iOchccPathDefModel.getNodeModel().equals(iNodeModel) || (iEntityModel = iOchccPathDefModel.getNodeModel().getEntityTable().getEntityModelByIndex(iOchccPathDefModel.getPortEntityIdx())).getShelfId() != n) continue;
                        arrayList.add(netCircuit);
                        continue block2;
                    }
                    if (!(iPathDefModel instanceof IOchncPathDefModel) || !(iOchccPathDefModel = (IOchncPathDefModel)iPathDefModel).getNodeModel().equals(iNodeModel) || (iEntityModel = iOchccPathDefModel.getNodeModel().getEntityTable().getEntityModelByIndex(iOchccPathDefModel.getPortEntityIdx())).getShelfId() != n) continue;
                    arrayList.add(netCircuit);
                    continue block2;
                }
                catch (Exception exception) {
                    if (!NetCircuitManager.dbgOn()) continue;
                    db.println("getCircuits path error: " + iPathDefModel);
                }
            }
        }
        return arrayList;
    }

    public List getCircuits(List list) {
        INodeModel iNodeModel = null;
        IConnectionModel iConnectionModel = null;
        INetElement iNetElement = null;
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        Iterator iterator = list.iterator();
        block0: while (iterator.hasNext()) {
            iConnectionModel = null;
            iNodeModel = null;
            iNetElement = null;
            iConnectionModel = (IConnectionModel)iterator.next();
            if (iConnectionModel != null) {
                iNodeModel = iConnectionModel.getNodeModel();
            }
            if (iNodeModel != null) {
                iNetElement = this.net.findNetElem(iNodeModel);
            }
            if (iNetElement == null) continue;
            Iterator iterator2 = this.getCircuits(iNodeModel).iterator();
            while (iterator2.hasNext()) {
                NetCircuit netCircuit = (NetCircuit)iterator2.next();
                if (!netCircuit.doesCircuitUseConn(iNetElement, iConnectionModel)) continue;
                linkedList.add(netCircuit);
                if (!netCircuit.getCircuitTypeObj().isLAPCircuitType()) continue block0;
                linkedList.addAll(this.getCircuitsUseLAP(netCircuit));
                continue block0;
            }
        }
        return linkedList;
    }

    public void provisionLoTunnels(List list) throws CircuitProvError, NoRoute, SanityCheckFailed, ConnTypeUnsupported, IncorrectCircuitState, DeletionError, AnnotatedException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LoTunnelInfo loTunnelInfo = (LoTunnelInfo)iterator.next();
            INetCircuit iNetCircuit = loTunnelInfo.tunnel();
            try {
                iNetCircuit.provision();
            }
            catch (CircuitProvError circuitProvError) {
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    loTunnelInfo = (LoTunnelInfo)iterator.next();
                    iNetCircuit = loTunnelInfo.tunnel();
                    iNetCircuit.destroyCircuit();
                }
                throw circuitProvError;
            }
        }
    }

    protected INetCircuit[] generateTable() {
        return null;
    }

    public List getCircuitSpans(INetLink iNetLink) {
        return this.getCircuitSpans(this.getCircuits(), iNetLink);
    }

    private List getCircuitSpans(List list, INetLink iNetLink) {
        LinkedList<INetCircuitSpan> linkedList = new LinkedList<INetCircuitSpan>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = (INetCircuit)iterator.next();
            if (iNetCircuit.getCircuitTypeObj().isVcatCircuitType()) {
                linkedList.addAll(this.getCircuitSpans(((NetVcatCircuit)iNetCircuit).getAllMemberCircuits(), iNetLink));
                continue;
            }
            INetCircuitSpan iNetCircuitSpan = iNetCircuit.getCircuitSpanFromNetLink(iNetLink);
            if (iNetCircuitSpan == null) continue;
            linkedList.add(iNetCircuitSpan);
        }
        return linkedList;
    }

    public List getCircuits(INetLink iNetLink) {
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        Iterator iterator = this.getCircuits().iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = (INetCircuit)iterator.next();
            if (!iNetCircuit.doesCircuitUseNetLink(iNetLink)) continue;
            linkedList.add(iNetCircuit);
        }
        return linkedList;
    }

    public INetwork getNetwork() {
        return this.net;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INetCircuit getCircuitFromId(ICircuitId iCircuitId) {
        if (NetCircuit.isNullCircuitId(iCircuitId)) {
            return null;
        }
        Object object = this.masterCktListLock;
        synchronized (object) {
            INetCircuit iNetCircuit = (INetCircuit)this.cktList.get(iCircuitId);
            if (iNetCircuit == null) {
                iNetCircuit = (INetCircuit)this.vcatMemCktList.get(iCircuitId);
            }
            return iNetCircuit;
        }
    }

    public INetCircuit getCircuitFromConn(INetElement iNetElement, Object object) {
        ICircuitId iCircuitId = NetCircuitNode.getConnCircuitId(object);
        if (!NetCircuit.isNullCircuitId(iCircuitId)) {
            return null;
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)TL1ObjectManager.instance().getTL1Object(iNetElement, object);
        if (netCircuitNode != null) {
            return netCircuitNode.getCircuit();
        }
        return null;
    }

    protected void insertPrepElement(INetLink iNetLink, INetElement iNetElement, int n, int n2) {
    }

    protected void notifyChanged(INetCircuit iNetCircuit) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("notifyChanged(ncMgr)");
        }
        this.setChanged();
        this.notifyObservers(iNetCircuit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCircuitNameMap(ICircuitId iCircuitId, String string) {
        String string2;
        if (NetCircuit.isNullCircuitId(iCircuitId)) {
            return;
        }
        HashMap hashMap = this.circuitNameMap;
        synchronized (hashMap) {
            string2 = string == null ? (String)this.circuitNameMap.remove(new Long(iCircuitId.longValue())) : this.circuitNameMap.put(new Long(iCircuitId.longValue()), string);
        }
        if (string2 == null || string2 != null && !string2.equals(string)) {
            this.watchDog.queueCircuitNameMapUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setNodeCircuitNameMap(INodeModel iNodeModel) {
        HashMap hashMap;
        HashMap hashMap2 = this.circuitNameMap;
        synchronized (hashMap2) {
            hashMap = new HashMap(this.circuitNameMap);
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("setNodeCircuitNameMap(" + iNodeModel.getName() + "): numCkts=" + this.circuitNameMap.size());
        }
        try {
            IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
            if (iConnectionModels != null) {
                iConnectionModels.setCircuitNameMap(hashMap);
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("IO Exception in setNodeCircuitNameMap " + (Object)((Object)abstractCmsIOException));
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            return false;
        }
        return true;
    }

    public int addNodeToNetwork(INetElement iNetElement, Observer observer) throws InvalidArgument, MissingLinks, AnnotatedException {
        if (iNetElement == null) {
            throw new InvalidArgument("Invalid network element");
        }
        if (this.splicer == null) {
            this.splicer = NetCircuitSplicer.instance();
        }
        if (this.splicer != null) {
            return this.splicer.addNeToRing(iNetElement, observer);
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Couldn't get splicer");
        }
        return 0;
    }

    public int addNodeToNetwork(INetElement iNetElement) throws InvalidArgument, MissingLinks, AnnotatedException {
        return this.addNodeToNetwork(iNetElement, null);
    }

    private String makePortString(IPortModel iPortModel) {
        return iPortModel.getNodeModel().getName() + ", Slot " + iPortModel.getSlot() + ", Port " + PortHelper.getPortNumString((IPortModel)iPortModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCircuitDeleteJobGroup(JobGroup jobGroup) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("DEL: delete JobGroup finished");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        HashSet hashSet = new HashSet();
        ArrayList<Map> arrayList = new ArrayList<Map>();
        if (jobGroup == this.deleteJobGroup) {
            IPortModel iPortModel;
            Object object;
            Object object2;
            Iterator<Object> iterator;
            HashMap<IPortModel, String> hashMap;
            try {
                JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
                for (int i = 0; i < jobStatusArray.length; ++i) {
                    hashMap = jobStatusArray[i].getResult();
                    if (jobStatusArray[i].value() == 2) {
                        if (hashMap == null) {
                            db.fine("DEL: Unexplained Circuit deletion error");
                            ++n3;
                            continue;
                        }
                        if (hashMap instanceof DeletionError) {
                            db.fine("DEL: Circuit deletion error");
                            ++n3;
                            iterator = (DeletionError)((Object)hashMap);
                            string = string + ((Throwable)((Object)iterator)).getMessage();
                            continue;
                        }
                        if (hashMap instanceof DeletionWarning) {
                            db.fine("DEL: Circuit deletion warning");
                            ++n;
                            iterator = (DeletionWarning)((Object)hashMap);
                            object2 = ((Throwable)((Object)iterator)).getMessage();
                            if (((String)object2).length() > 0) {
                                stringBuffer.append(((Throwable)((Object)iterator)).getMessage()).append("\n");
                            }
                            hashSet.addAll(((DeletionWarning)((Object)iterator)).getPortSuccesses());
                            arrayList.add(((DeletionWarning)((Object)iterator)).getPortFailures());
                            continue;
                        }
                        db.severe("handleCircuitDeleteJobGroup(): unexpected resultObj " + hashMap);
                        if (!(hashMap instanceof Exception)) continue;
                        SDebug.printStackTrace((Throwable)((Exception)((Object)hashMap)));
                        continue;
                    }
                    db.fine("DEL: Circuit deletion full success");
                    ++n;
                    if (hashMap instanceof Set) {
                        hashSet.addAll((Set)((Object)hashMap));
                    } else {
                        db.severe("Unexpected result object: " + hashMap);
                    }
                    if (jobStatusArray[i].value() == 4) continue;
                    db.severe("handleCircuitDeleteJobGroup(): unexpected status");
                }
            }
            catch (Exception exception) {
                db.severe("handleCircuitDeleteJobGroup(): ");
                SDebug.printStackTrace((Throwable)exception);
            }
            finally {
                this.deleteJobGroup = null;
            }
            int n4 = hashSet.size();
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                hashMap = (IPortModel)iterator2.next();
                db.info("Success: " + this.makePortString((IPortModel)hashMap));
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object2 = (Map)iterator.next();
                    object2.remove(hashMap);
                }
            }
            hashMap = new HashMap<IPortModel, String>();
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object2 = (Map)iterator.next();
                object = object2.keySet().iterator();
                while (object.hasNext()) {
                    iPortModel = (IPortModel)object.next();
                    String string2 = (String)object2.get(iPortModel);
                    String string3 = (String)hashMap.get(iPortModel);
                    if (string3 == null) {
                        hashMap.put(iPortModel, string2);
                        continue;
                    }
                    if (string3.indexOf(string2) >= 0) continue;
                    hashMap.put(iPortModel, string3 + ";\n" + string2);
                }
            }
            n2 = hashMap.size();
            iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (IPortModel)iterator.next();
                object = this.makePortString((IPortModel)object2);
                stringBuffer2.append((String)object).append(": ").append(hashMap.get(object2)).append("\n\n");
            }
            db.info("Circuit failures " + n3 + "; circuit successes " + n + "; port warnings " + n2);
            object2 = NetAdminState.getAdminStateStringFromAdminState(this.targetUnusedPortsState);
            string = string + (n3 > 0 ? n3 + " " + PluralisationUtil.s("circuit", n3) + " " + PluralisationUtil.s("was", n3) + " not deleted.\n" : "") + (n > 0 ? n + " " + PluralisationUtil.s("circuit", n) + " " + PluralisationUtil.s("was", n) + " successfully deleted.\n" : "") + (n2 > 0 ? "\nCircuit state " + (String)object2 + " cannot be applied to " + n2 + " " + PluralisationUtil.s("port", n2) + ".\n\n" + stringBuffer2.toString() + "\n" : "") + (stringBuffer.length() > 0 ? stringBuffer.toString() + "\n" : "");
            object = new JobStatus(4);
            if (n3 > 0) {
                object.setResult((Object)new DeletionError(string));
            } else if (n2 > 0) {
                object.setResult((Object)new DeletionWarning(string, (String)object2, hashSet, hashMap));
            } else {
                object.setResult((Object)string);
            }
            iPortModel = (IAsyncObserver)jobGroup.getUserObject();
            if (iPortModel != null) {
                if (NetCircuitManager.dbgOn()) {
                    db.println("Circuit Deletion results displayed by " + iPortModel.getClass().getName());
                }
                iPortModel.asyncUpdate(null, (JobStatus)object);
            }
            db.info("DEL: End Circuit Deletion Job Group");
        }
    }

    public int addNodeToOnePlusOne(INetElement iNetElement, IEntityModel iEntityModel, IEntityModel iEntityModel2, INetElement iNetElement2, IEntityModel iEntityModel3, INetElement iNetElement3, IEntityModel iEntityModel4, Observer observer) throws InvalidArgument, MissingLinks, AnnotatedException {
        if (iNetElement == null || iEntityModel == null || iEntityModel2 == null || iNetElement2 == null || iEntityModel3 == null || iNetElement3 == null || iEntityModel4 == null) {
            throw new InvalidArgument("Invalid network element or entity model");
        }
        if (this.splicer == null) {
            this.splicer = NetCircuitSplicer.instance();
        }
        if (this.splicer != null) {
            return this.splicer.addNeToOnePlusOne(iNetElement, iEntityModel, iEntityModel2, iNetElement2, iEntityModel3, iNetElement3, iEntityModel4, observer);
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("Couldn't get splicer");
        }
        return 0;
    }

    public int addNodeToOnePlusOne(INetElement iNetElement, IEntityModel iEntityModel, IEntityModel iEntityModel2, INetElement iNetElement2, IEntityModel iEntityModel3, INetElement iNetElement3, IEntityModel iEntityModel4) throws InvalidArgument, MissingLinks, AnnotatedException {
        return this.addNodeToOnePlusOne(iNetElement, iEntityModel, iEntityModel2, iNetElement2, iEntityModel3, iNetElement3, iEntityModel4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProvAdminStateJobGroup(JobGroup jobGroup) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("provAdminState JobGroup finished");
        }
        try {
            String string = "provisioning admin state completed\n";
            JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
            for (int i = 0; i < jobStatusArray.length; ++i) {
                if (jobStatusArray[i].value() != 2) continue;
                string = "Provisioning admin state failed\n";
                AdminStateProvisioningError adminStateProvisioningError = (AdminStateProvisioningError)jobStatusArray[i].getResult();
                if (adminStateProvisioningError == null) continue;
                string = string + adminStateProvisioningError.toString();
            }
            JobStatus jobStatus = new JobStatus(4);
            jobStatus.setResult((Object)string);
            IAsyncObserver iAsyncObserver = (IAsyncObserver)jobGroup.getUserObject();
            if (iAsyncObserver != null) {
                iAsyncObserver.asyncUpdate(null, jobStatus);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        finally {
            this.provAdminStateJobGroup = null;
        }
    }

    public void jobGroupFinished(JobGroup jobGroup) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("DEL: delete JobGroup finished");
        }
        if (jobGroup == this.deleteJobGroup) {
            this.handleCircuitDeleteJobGroup(jobGroup);
        } else if (jobGroup == this.provAdminStateJobGroup) {
            this.handleProvAdminStateJobGroup(jobGroup);
        } else {
            db.info("Unknown type of job group finished");
        }
    }

    public List getEndpointsUseLink(INetLink iNetLink) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.getCircuits().iterator();
        while (iterator.hasNext()) {
            NetCircuit netCircuit = (NetCircuit)iterator.next();
            List list = netCircuit.getLinkEndpoints(iNetLink);
            if (list.isEmpty()) continue;
            linkedList.addAll(list);
        }
        return linkedList;
    }

    protected INetLink getNetLinkFromEndpoint(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        INetLink iNetLink = null;
        if (iNetCircuitEnd != null) {
            iNetLink = this.net.findNetLinkFromSource(bl, iNetCircuitEnd.getNetElement(), iNetCircuitEnd.getEntityIndex(), iNetCircuitEnd.getHoNum(), iNetCircuitEnd.getLoNum());
        }
        return iNetLink;
    }

    public void performProtectionOp(INetCircuitSpan[] iNetCircuitSpanArray, int n, String string, IAsyncObserver iAsyncObserver) throws ProtectionSwitchError {
        if (NetCircuitManager.dbgOn()) {
            db.println("performProtectionOp: No of spans = " + iNetCircuitSpanArray.length);
            db.println("performProtectionOp: Operation = " + n);
        }
        ProtectionSwitchRun protectionSwitchRun = new ProtectionSwitchRun(iNetCircuitSpanArray, n, string, iAsyncObserver);
        if (this.protectionSwitchThread != null) {
            throw new ProtectionSwitchError("Another protection switch request is already in progress.\nPlease wait until that request completes.");
        }
        this.protectionSwitchThread = new Thread(protectionSwitchRun);
        this.protectionSwitchThread.start();
    }

    private List getLAPHoNode(INodeModel iNodeModel) {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        Iterator iterator = this.getLAPCircuits().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd;
            NetCircuit netCircuit = (NetCircuit)iterator.next();
            if (netCircuit.getState() != 1 && netCircuit.getState() != 5 || (netCircuitEnd = (NetCircuitEnd)netCircuit.getCktSources().get(0)).getNodeModel().getDelegate() != iNodeModel.getDelegate()) continue;
            linkedList.add(netCircuit);
        }
        return linkedList;
    }

    public List getLAPHoEntity(INodeModel iNodeModel, IEntityModel iEntityModel) {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        Iterator iterator = this.getLAPHoNode(iNodeModel).iterator();
        while (iterator.hasNext()) {
            NetCircuit netCircuit = (NetCircuit)iterator.next();
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)netCircuit.getCktSources().get(0);
            try {
                if (netCircuitEnd.getEntityModel() != iEntityModel) continue;
                linkedList.add(netCircuit);
            }
            catch (ObjNotFound objNotFound) {
                if (!NetCircuitManager.dbgOn()) continue;
                NetCircuitManager.debug("getLAP hits exception " + netCircuit.getCircuitName());
            }
        }
        return linkedList;
    }

    public INetCircuit getLAPHo(INodeModel iNodeModel, IEntityModel iEntityModel, IHoNum iHoNum) {
        Iterator iterator = this.getLAPHoEntity(iNodeModel, iEntityModel).iterator();
        while (iterator.hasNext()) {
            NetCircuit netCircuit = (NetCircuit)iterator.next();
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)netCircuit.getCktSources().get(0);
            if (!holoComp.isEqual(netCircuitEnd.getHoNum(), iHoNum)) continue;
            return netCircuit;
        }
        return null;
    }

    private List getLAPLoGrooming(INodeModel iNodeModel) {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        Iterator iterator = this.getLAPCircuits().iterator();
        while (iterator.hasNext()) {
            NetCircuit netCircuit = (NetCircuit)iterator.next();
            if (netCircuit.getState() != 1 && netCircuit.getState() != 5) continue;
            Iterator iterator2 = netCircuit.getCktDrops().iterator();
            while (iterator2.hasNext()) {
                NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator2.next();
                if (netCircuitDropInfo.getNodeModel().getNodeId() != iNodeModel.getNodeId()) continue;
                linkedList.add(netCircuit);
            }
        }
        return linkedList;
    }

    public NetCcatCircuit getLAPLoGrooming(INodeModel iNodeModel, IEntityModel iEntityModel, IHoNum iHoNum) {
        Iterator iterator = this.getLAPLoGrooming(iNodeModel).iterator();
        while (iterator.hasNext()) {
            HoCcatCircuit hoCcatCircuit = (HoCcatCircuit)iterator.next();
            Iterator iterator2 = hoCcatCircuit.getLoTunnelNodes().iterator();
            while (iterator2.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator2.next();
                if (netCircuitNode.getNodeModel().getNodeId() != iNodeModel.getNodeId()) continue;
                if (!netCircuitNode.hasDualConnections()) {
                    try {
                        if (netCircuitNode.getTunnelEntityIndex() != iEntityModel.getEntityIndex() || !holoComp.isEqual(netCircuitNode.getLotHo(), iHoNum)) continue;
                        return hoCcatCircuit;
                    }
                    catch (SanityCheckFailed sanityCheckFailed) {
                        if (!NetCircuitManager.dbgOn()) continue;
                        NetCircuitManager.debug("getLAPLoGrooming hits exception " + hoCcatCircuit.getCircuitName());
                        continue;
                    }
                }
                Iterator iterator3 = ((DualConnectionCircuitNode)netCircuitNode).getAggregationNodes().iterator();
                while (iterator3.hasNext()) {
                    LoTunnelNode loTunnelNode = (LoTunnelNode)iterator3.next();
                    try {
                        if (loTunnelNode.getTunnelEntityIndex() != iEntityModel.getEntityIndex() || !holoComp.isEqual(loTunnelNode.getLotHo(), iHoNum)) continue;
                        return hoCcatCircuit;
                    }
                    catch (SanityCheckFailed sanityCheckFailed) {
                        if (!NetCircuitManager.dbgOn()) continue;
                        NetCircuitManager.debug("getLAPLoGrooming hits exception " + hoCcatCircuit.getCircuitName());
                    }
                }
            }
        }
        return null;
    }

    public boolean capableOfLAPHoConnection(INodeModel iNodeModel, IEntityModel iEntityModel, IHoNum iHoNum) {
        if (iNodeModel == null || iEntityModel == null || iHoNum == null) {
            return false;
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("capableOfLAPHoConnection called on node " + iNodeModel.getName() + " entity index " + iEntityModel.getEntityIndex() + " hoNum " + iHoNum.getHoNum());
        }
        if (!iNodeModel.provides(Feature.VT_GROOMING)) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("capableOfLAPHoConnection: node doesn't support VT_GROOMING, returns false");
            }
            return false;
        }
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        LinkedList<IEntityModel> linkedList = new LinkedList<IEntityModel>();
        LinkedList linkedList2 = new LinkedList();
        linkedList.add(iEntityModel);
        iEntityTableModel.lapFilterEntities(linkedList, linkedList2);
        if (linkedList2.isEmpty()) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("capableOfLAPHoConnection: filteredEntities is empty, returns false");
            }
            return false;
        }
        int n = iNodeModel.getFramingType();
        ICircuitSize iCircuitSize = CircuitSize.getLoAggSize((int)n);
        short s = iCircuitSize.size2widthOfHoCircuit();
        IPoolModel[] iPoolModelArray = iNodeModel.getPoolModels().getPoolModels(iEntityModel.getEntityIndex());
        Iterator<IPoolModel> iterator = Arrays.asList(iPoolModelArray).iterator();
        while (iterator.hasNext()) {
            IPoolModel iPoolModel = iterator.next();
            IPathInfo[] iPathInfoArray = iPoolModel.getAvailablePaths(s);
            for (int i = 0; i < iPathInfoArray.length; ++i) {
                IHoNum iHoNum2 = HoPathDefModel.physicalHo(iPoolModel, iPathInfoArray[i].getStartingHo());
                if (!holoComp.isEqual(iHoNum2, iHoNum)) continue;
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("capableOfLAPHoConnection returns true");
                }
                return true;
            }
        }
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("capableOfLAPHoConnection returns false");
        }
        return false;
    }

    public List getCircuitsUseLAP(INetCircuit iNetCircuit) {
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        Iterator iterator = this.getCircuits().iterator();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit2;
            INetCircuit iNetCircuit3 = (INetCircuit)iterator.next();
            if (!iNetCircuit3.getCircuitTypeObj().isLoCircuitType() || (iNetCircuit2 = iNetCircuit3.useLAP()) == null || iNetCircuit2 != iNetCircuit) continue;
            linkedList.add(iNetCircuit3);
        }
        return linkedList;
    }

    public boolean canAddToNodeList(INodeModel iNodeModel, INetCircuit iNetCircuit, ICircuitType iCircuitType) {
        return iCircuitType.isLoCircuitType() && (this.getLAPHoNode(iNodeModel).size() != 0 && iNetCircuit == null || this.getLAPHoNode(iNodeModel).size() != 0 && iNetCircuit.useLAP() == null && iNetCircuit.getState() == 0);
    }

    public boolean canAddToNodeList(INodeModel iNodeModel, INetCircuit iNetCircuit, CircuitCreatInfo circuitCreatInfo) {
        if (NetCircuitManager.dbgOn()) {
            NetCircuitManager.debug("canAddToNodeList on node " + iNodeModel.getName());
        }
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        INetCircuit iNetCircuit2 = null;
        INetElement iNetElement = this.net.getNetElem(iNodeModel.getNodeId());
        if (iNetElement == null) {
            if (NetCircuitManager.dbgOn()) {
                NetCircuitManager.debug("ERROR: canAddToNodeList: Can't find ne");
            }
            return false;
        }
        if (iCircuitType.isLoCircuitType()) {
            if (iNetElement.canSupportCircuitSize(circuitCreatInfo.size()) && iNetElement.loXCon()) {
                if (iNetCircuit == null) {
                    if (!circuitCreatInfo.isDiag()) {
                        return true;
                    }
                    if (iNodeModel.provides(Feature.DIAGNOSTIC_CONNECTION) && iNodeModel.provides(Feature.XCVXC) && iNodeModel.getConnectionModels().diagGeneratorAvailable()) {
                        return true;
                    }
                } else {
                    iNetCircuit2 = iNetCircuit.useLAP();
                    if (iNetCircuit2 == null) {
                        return true;
                    }
                    if (iNetCircuit2.getSrcCircuitNode().getNodeModel().getNodeId() != iNodeModel.getNodeId()) {
                        return true;
                    }
                }
            } else {
                if (this.getLAPHoNode(iNodeModel).size() != 0 && iNetCircuit == null) {
                    return true;
                }
                if (this.getLAPHoNode(iNodeModel).size() != 0 && iNetCircuit.useLAP() == null && iNetCircuit.getState() == 0) {
                    return true;
                }
            }
        }
        return false;
    }

    private void filterDiagPorts(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel = (IEntityModel)iterator.next();
            if (iEntityModel.getPayloadType() == 1) continue;
            if (NetCircuitManager.dbgOn()) {
                db.println("Found an non OCN entity to remove" + iEntityModel);
            }
            iterator.remove();
        }
    }

    public INetCircuitSpan getLAPSpan(INetCircuit iNetCircuit) {
        INetLink iNetLink = null;
        NetLinkSpan netLinkSpan = null;
        NetCircuitSpan netCircuitSpan = null;
        if (iNetCircuit.getState() != 0 && iNetCircuit.getState() != 3) {
            return netCircuitSpan;
        }
        if (!(iNetCircuit instanceof LoCcatCircuit)) {
            return netCircuitSpan;
        }
        NetCcatCircuit netCcatCircuit = ((LoCcatCircuit)iNetCircuit).useLAPOnSource();
        if (netCcatCircuit != null) {
            Iterator iterator = iNetCircuit.getSources().iterator();
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                try {
                    if (NetCircuitManager.instance().getLAPHo(netCircuitEnd.getNodeModel(), netCircuitEnd.getEntityModel(), netCircuitEnd.getHoNum()) == null) continue;
                    iNetLink = netCcatCircuit.getLapLink();
                    netLinkSpan = new NetLinkSpan(iNetLink, iNetLink.getReverseLink(), iNetLink.getSrcHo(), iNetLink.getDstHo(), netCircuitEnd.getLoNum());
                }
                catch (ObjNotFound objNotFound) {
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
        } else {
            netCcatCircuit = ((LoCcatCircuit)iNetCircuit).useLAPOnDrop();
            if (netCcatCircuit != null) {
                Iterator iterator = iNetCircuit.getDrops().iterator();
                while (iterator.hasNext()) {
                    NetCircuitEnd netCircuitEnd = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
                    try {
                        if (NetCircuitManager.instance().getLAPHo(netCircuitEnd.getNodeModel(), netCircuitEnd.getEntityModel(), netCircuitEnd.getHoNum()) == null) continue;
                        iNetLink = netCcatCircuit.getReverseLapLink();
                        netLinkSpan = new NetLinkSpan(iNetLink, iNetLink.getReverseLink(), iNetLink.getSrcHo(), iNetLink.getDstHo(), netCircuitEnd.getLoNum());
                    }
                    catch (ObjNotFound objNotFound) {
                        SDebug.printStackTrace((Throwable)objNotFound);
                    }
                }
            }
        }
        if (netLinkSpan != null) {
            netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(iNetCircuit, netLinkSpan);
        }
        return netCircuitSpan;
    }

    protected static boolean pkgDbgOn() {
        return pkgDb.on();
    }

    protected static void suppressPkgDbg() {
        pkgDbgSuppressed = true;
    }

    protected static void permitPkgDbg() {
        pkgDbgSuppressed = false;
    }

    protected static boolean pkgDbgSuppressed() {
        return pkgDbgSuppressed;
    }

    protected static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected static void debug(String string) {
        db.println(string);
    }

    protected static void debug(Exception exception) {
        SDebug.printStackTrace((Throwable)exception);
    }

    class ProtectionSwitchRun
    implements Runnable,
    IJobGroupListener {
        private INetCircuitSpan[] spansToSwitch;
        private int op;
        private String opStr;
        private IAsyncObserver actionObserver;
        private String errorMessage = null;
        private LinkedList invalidCircuitList;

        public ProtectionSwitchRun(INetCircuitSpan[] iNetCircuitSpanArray, int n, String string, IAsyncObserver iAsyncObserver) {
            this.spansToSwitch = new INetCircuitSpan[iNetCircuitSpanArray.length];
            System.arraycopy(iNetCircuitSpanArray, 0, this.spansToSwitch, 0, iNetCircuitSpanArray.length);
            this.op = n;
            this.opStr = string;
            this.actionObserver = iAsyncObserver;
            this.invalidCircuitList = new LinkedList();
        }

        public void run() {
            if (NetCircuitManager.dbgOn()) {
                db.println("ProtectionSwitchRun thread started");
            }
            try {
                this.executeProtectionSwitch();
            }
            catch (ProtectionSwitchError protectionSwitchError) {
                this.errorMessage = protectionSwitchError.getMessage();
                this.jobGroupFinished(NetCircuitManager.this.protectionSwitchJobGroup);
            }
            catch (Exception exception) {
                this.errorMessage = exception.getMessage();
                this.jobGroupFinished(NetCircuitManager.this.protectionSwitchJobGroup);
                db.println("Unknown Exception caught in ProtectionSwitchRun thread");
                db;
                SDebug.printStackTrace((Throwable)exception);
            }
            if (NetCircuitManager.dbgOn()) {
                db.println("ProtectionSwitchRun thread completed");
            }
        }

        private void interleavedSort(ProtectionSwitchHelper[] protectionSwitchHelperArray) throws ProtectionSwitchError {
            int n;
            if (protectionSwitchHelperArray.length == 0) {
                if (NetCircuitManager.dbgOn()) {
                    db.println("interleavedSort: called with 0 items, returning");
                }
                throw new ProtectionSwitchError("No Protection Switch items");
            }
            if (NetCircuitManager.dbgOn()) {
                db.println("interleavedSort called containing " + protectionSwitchHelperArray.length + " items");
                db.println("BEFORE: ");
                for (n = 0; n < protectionSwitchHelperArray.length; ++n) {
                    db.println(protectionSwitchHelperArray[n].getNode().getName());
                }
            }
            n = protectionSwitchHelperArray.length;
            Arrays.sort(protectionSwitchHelperArray);
            LinkedList<ProtectionSwitchHelper> linkedList = new LinkedList<ProtectionSwitchHelper>(Arrays.asList(protectionSwitchHelperArray));
            int n2 = 0;
            boolean bl = false;
            ProtectionSwitchHelper[] protectionSwitchHelperArray2 = new ProtectionSwitchHelper[n];
            protectionSwitchHelperArray2[n2] = linkedList.removeFirst();
            while (!linkedList.isEmpty()) {
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    ProtectionSwitchHelper protectionSwitchHelper = (ProtectionSwitchHelper)iterator.next();
                    String string = protectionSwitchHelper.getNode().getName();
                    String string2 = protectionSwitchHelperArray2[n2].getNode().getName();
                    if (string2.compareTo(string) >= 0) continue;
                    protectionSwitchHelperArray2[++n2] = protectionSwitchHelper;
                    iterator.remove();
                }
                if (linkedList.isEmpty()) continue;
                protectionSwitchHelperArray2[++n2] = linkedList.removeFirst();
            }
            System.arraycopy(protectionSwitchHelperArray2, 0, protectionSwitchHelperArray, 0, protectionSwitchHelperArray2.length);
            if (NetCircuitManager.dbgOn()) {
                db.println("\nAFTER: ");
                for (int i = 0; i < protectionSwitchHelperArray.length; ++i) {
                    db.println(protectionSwitchHelperArray[i].getNode().getName());
                }
            }
        }

        private void executeProtectionSwitch() throws ProtectionSwitchError {
            Object object;
            LinkedList linkedList = new LinkedList();
            if (NetCircuitManager.this.protectionSwitchJobGroup != null) {
                throw new ProtectionSwitchError("Another protection switch request already in progress.\nPlease wait until that request completes.");
            }
            if (NetCircuitManager.this.protectionSwitchJobController == null) {
                NetCircuitManager.this.protectionSwitchJobController = JobControllerFactory.createJC((int)5);
            }
            if (NetCircuitManager.this.protectionSwitchJobController == null) {
                throw new ProtectionSwitchError("Unable to create jobs");
            }
            if (NetCircuitManager.dbgOn()) {
                db.println("executeProtSwtch: spansToSwitch loop" + this.spansToSwitch.length);
            }
            for (int i = 0; i < this.spansToSwitch.length; ++i) {
                INetCircuit iNetCircuit;
                Object object2;
                try {
                    INetElement iNetElement = this.spansToSwitch[i].getLink().getSrc();
                    object = this.spansToSwitch[i].findSelectorNodeForNe(iNetElement, this.op);
                    linkedList.addAll(object);
                    object2 = this.spansToSwitch[i].getLink().getDst();
                    object = this.spansToSwitch[i].findSelectorNodeForNe((INetElement)object2, this.op);
                    linkedList.addAll(object);
                    continue;
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    iNetCircuit = this.spansToSwitch[i].getCircuit();
                    object2 = iNetCircuit.getCircuitName() + " (" + incorrectCircuitState.getMessage() + ")\n";
                    this.invalidCircuitList.add(object2);
                    if (!NetCircuitManager.dbgOn()) continue;
                    db.println("executeProtectionSwitch: caught IncorrectCircuitState exception: " + incorrectCircuitState.getMessage());
                    continue;
                }
                catch (ConnectionPathNotFound connectionPathNotFound) {
                    iNetCircuit = this.spansToSwitch[i].getCircuit();
                    object2 = iNetCircuit.getCircuitName() + " (" + connectionPathNotFound.getMessage() + ")\n";
                    this.invalidCircuitList.add(object2);
                    if (!NetCircuitManager.dbgOn()) continue;
                    db.println("executeProtectionSwitch: caught ConnectionPathNotFound exception: " + connectionPathNotFound.getMessage());
                }
            }
            ProtectionSwitchHelper[] protectionSwitchHelperArray = linkedList.toArray(new ProtectionSwitchHelper[0]);
            this.interleavedSort(protectionSwitchHelperArray);
            object = new IJobControl[protectionSwitchHelperArray.length];
            if (NetCircuitManager.dbgOn()) {
                db.println("executeProtSwtch: protSwitchHelpers loop" + protectionSwitchHelperArray.length);
            }
            for (int i = 0; i < protectionSwitchHelperArray.length; ++i) {
                object[i] = new NetCircuitProtectionSwitchWorker(protectionSwitchHelperArray[i]);
            }
            NetCircuitManager.this.protectionSwitchJobGroup = new JobGroup(object, (IJobGroupListener)this, (Object)this.actionObserver);
            NetCircuitManager.this.protectionSwitchJobController.submitJob(NetCircuitManager.this.protectionSwitchJobGroup);
        }

        public void jobGroupFinished(JobGroup jobGroup) {
            JobStatus jobStatus = new JobStatus(4);
            if (jobGroup == NetCircuitManager.this.protectionSwitchJobGroup) {
                if (this.errorMessage != null) {
                    String string = "Could not apply " + this.opStr + " request because:\n";
                    string = string + this.errorMessage;
                    if (this.invalidCircuitList.size() > 0) {
                        string = string + "\n";
                        Iterator iterator = this.invalidCircuitList.iterator();
                        while (iterator.hasNext()) {
                            string = string + (String)iterator.next();
                        }
                    }
                    jobStatus.setResult((Object)string);
                    this.actionObserver.asyncUpdate((Object)("Protection Switch operation " + this.opStr + " failed"), jobStatus);
                } else {
                    Object object;
                    if (NetCircuitManager.dbgOn()) {
                        NetCircuitManager.debug("Protection Switch JobGroup finished");
                    }
                    String string = "";
                    NetCircuitNode netCircuitNode = null;
                    String string2 = "";
                    String string3 = "";
                    String string4 = "";
                    String string5 = "";
                    IJobControl[] iJobControlArray = jobGroup.getJobList();
                    JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
                    if (iJobControlArray != null || jobStatusArray != null) {
                        object = new LinkedList();
                        for (int i = 0; i < jobStatusArray.length; ++i) {
                            ProtectionSwitchError protectionSwitchError;
                            NetCircuitProtectionSwitchWorker netCircuitProtectionSwitchWorker = (NetCircuitProtectionSwitchWorker)iJobControlArray[i];
                            netCircuitNode = netCircuitProtectionSwitchWorker.getNode();
                            string2 = netCircuitNode.getCircuit().getCircuitName();
                            if (((LinkedList)object).contains(string2)) continue;
                            boolean bl = false;
                            boolean bl2 = false;
                            String string6 = "        ";
                            if (jobStatusArray[i].value() == 2) {
                                if (NetCircuitManager.dbgOn()) {
                                    db.println("jobGroupFinished: Failed span switch for circuit: " + string2);
                                }
                                if ((protectionSwitchError = (ProtectionSwitchError)jobStatusArray[i].getResult()) != null) {
                                    string5 = string5 + string2 + ": \n";
                                    string5 = string5 + string6 + "at node " + netCircuitNode.getName() + "\n";
                                    bl2 = true;
                                }
                            } else {
                                if (NetCircuitManager.dbgOn()) {
                                    db.println("jobGroupFinished: Passed span switch for circuit: " + string2);
                                }
                                string4 = string4 + string2 + ": \n";
                                string4 = string4 + string6 + "at node " + netCircuitNode.getName() + "\n";
                                bl = true;
                            }
                            LinkedList<NetCircuitNode> linkedList = new LinkedList<NetCircuitNode>();
                            linkedList.add(netCircuitNode);
                            for (int j = i; j < jobStatusArray.length; ++j) {
                                NetCircuitProtectionSwitchWorker netCircuitProtectionSwitchWorker2 = (NetCircuitProtectionSwitchWorker)iJobControlArray[j];
                                NetCircuitNode netCircuitNode2 = netCircuitProtectionSwitchWorker2.getNode();
                                String string7 = netCircuitNode2.getCircuit().getCircuitName();
                                if (!string2.equals(string7) || linkedList.contains(netCircuitNode2)) continue;
                                if (jobStatusArray[j].value() == 2) {
                                    if (NetCircuitManager.dbgOn()) {
                                        db.println("jobGroupFinished: Failed span switch for circuit: " + string2);
                                    }
                                    if ((protectionSwitchError = (ProtectionSwitchError)jobStatusArray[j].getResult()) != null) {
                                        if (!bl2) {
                                            bl2 = true;
                                            string5 = string5 + string2 + ": \n";
                                        }
                                        string5 = string5 + string6 + "at node " + netCircuitNode2.getName() + "\n";
                                    }
                                } else {
                                    if (NetCircuitManager.dbgOn()) {
                                        db.println("jobGroupFinished: Passed span switch for circuit: " + string2);
                                    }
                                    if (!bl) {
                                        bl = true;
                                        string4 = string4 + string2 + ": \n";
                                    }
                                    string4 = string4 + string6 + "at node " + netCircuitNode2.getName() + "\n";
                                }
                                linkedList.add(netCircuitNode2);
                            }
                            ((LinkedList)object).add(string2);
                        }
                    }
                    if (NetCircuitManager.dbgOn()) {
                        NetCircuitManager.debug("Protection Switch completed");
                    }
                    if (!string4.equals("")) {
                        string = "Successfully applied " + this.opStr + " request to these circuits:\n";
                        string = string + string4 + "\n";
                        string3 = "Protection switch " + this.opStr + " completed successfully with no errors";
                    }
                    if (!string5.equals("")) {
                        string = string + "\nFailed to apply " + this.opStr + " request to these circuits:\n";
                        string = string + string5;
                        string3 = "Protection switch " + this.opStr + " completed with some errors";
                    }
                    if (this.invalidCircuitList.size() > 0) {
                        string = string + "\n";
                        object = this.invalidCircuitList.iterator();
                        while (object.hasNext()) {
                            string = string + (String)object.next();
                        }
                    }
                    jobStatus.setResult((Object)string);
                    object = (IAsyncObserver)jobGroup.getUserObject();
                    if (object != null) {
                        object.asyncUpdate((Object)string3, jobStatus);
                    }
                    if (NetCircuitManager.dbgOn()) {
                        db.println("\n" + string3);
                        db.println((String)jobStatus.getResult());
                    }
                }
                if (NetCircuitManager.dbgOn()) {
                    NetCircuitManager.debug("resetting protectionSwtichJobGroup to null");
                }
                NetCircuitManager.this.protectionSwitchJobGroup = null;
                NetCircuitManager.this.protectionSwitchThread = null;
            }
        }
    }

    public class CircuitIdComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            ICircuitId iCircuitId = (ICircuitId)object;
            ICircuitId iCircuitId2 = (ICircuitId)object2;
            return ComparisonUtil.compare((long)iCircuitId.longValue(), (long)iCircuitId2.longValue());
        }
    }

    public class DumpDebug
    extends SDebug
    implements IDebugDiag {
        boolean circuitCounterEnabled;
        int circuitCounterSleepTime;
        CircuitCounterThread circuitCounterThread;

        public DumpDebug(String string) {
            super(string);
            this.circuitCounterEnabled = false;
            this.circuitCounterSleepTime = 10000;
            this.circuitCounterThread = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    if (!this.on()) {
                        this.set();
                    }
                    Iterator iterator = NetCircuitManager.this.getCircuits().iterator();
                    while (iterator.hasNext()) {
                        INetCircuit iNetCircuit = (INetCircuit)iterator.next();
                        iNetCircuit.prettyPrint(this);
                        this.println("==========================================================");
                    }
                }
            }
        }

        public final void deconstructionDump() {
            this.deconstructionDump(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void deconstructionDump(String string) {
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    if (!this.on()) {
                        this.set();
                        this.println("");
                    }
                    this.println("Circuit Connection Deconstruction Dump");
                    this.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                    this.println("");
                    Iterator iterator = NetCircuitManager.this.getCircuits().iterator();
                    while (iterator.hasNext()) {
                        INetCircuit iNetCircuit = (INetCircuit)iterator.next();
                        if (string != null && (string == null || !iNetCircuit.getCircuitName().equals(string))) continue;
                        iNetCircuit.prettyPrintDeconstruction(this);
                        this.println("==========================================================");
                        this.println("");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpMember() {
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    if (!this.on()) {
                        this.set();
                    }
                    Iterator iterator = NetCircuitManager.this.getMemberCircuits().iterator();
                    while (iterator.hasNext()) {
                        INetCircuit iNetCircuit = (INetCircuit)iterator.next();
                        iNetCircuit.prettyPrint(this);
                        this.println("==========================================================");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpCkt(String string) {
            if (manager != null) {
                NetCircuitManager netCircuitManager = manager;
                synchronized (netCircuitManager) {
                    if (!this.on()) {
                        this.set();
                    }
                    Iterator iterator = NetCircuitManager.this.getCircuits().iterator();
                    while (iterator.hasNext()) {
                        NetCircuit netCircuit = (NetCircuit)iterator.next();
                        if (!netCircuit.getCircuitName().equals(string)) continue;
                        netCircuit.prettyPrint(this);
                        this.println("==========================================================");
                        break;
                    }
                }
            }
        }

        public final void circuitCount() {
            List list = NetCircuitManager.this.getCircuits();
            int n = list.size();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NetCircuit netCircuit = (NetCircuit)iterator.next();
                if (netCircuit.getState() == 1) {
                    ++n2;
                    continue;
                }
                if (netCircuit.getState() == 5) {
                    ++n3;
                    continue;
                }
                if (netCircuit.getState() == 0) {
                    ++n4;
                    continue;
                }
                if (netCircuit.getState() == 4) {
                    ++n5;
                    continue;
                }
                ++n6;
            }
            IMetrics.circuitDb.println("Total circuit count : " + n);
            IMetrics.circuitDb.println("Active : " + n2);
            IMetrics.circuitDb.println("TL1-Active : " + n3);
            IMetrics.circuitDb.println("Creating : " + n4);
            IMetrics.circuitDb.println("Incomplete : " + n5);
            IMetrics.circuitDb.println("Other : " + n6);
        }

        public final void setCircuitCounterTimer(int n) {
            this.circuitCounterSleepTime = n;
            if (this.circuitCounterThread != null) {
                this.circuitCounterThread.setTimer(this.circuitCounterSleepTime);
            }
        }

        public final void enableCircuitCounter() {
            if (this.circuitCounterThread == null) {
                this.circuitCounterThread = new CircuitCounterThread(this.circuitCounterSleepTime);
                this.circuitCounterThread.start();
                IMetrics.circuitDb.println("Circuit Counter Monitor started");
            }
        }

        public final void disableCircuitCounter() {
            if (this.circuitCounterThread != null) {
                this.circuitCounterThread.cancel();
                IMetrics.circuitDb.println("Circuit Counter Monitor stopped");
            }
            this.circuitCounterThread = null;
        }

        public void dumpDiag() {
            this.dump();
        }

        public final void reportMemorySize(boolean bl, boolean bl2) {
            db.display("It may take a few minutes for this operation to complete. Please be patient");
            NetModelMemorySizer netModelMemorySizer = new NetModelMemorySizer(this, bl2 ? 8 : 4, false, bl);
            netModelMemorySizer.enableCleanupState(false);
            NetCircuitManager netCircuitManager = NetCircuitManager.instance();
            int n = netModelMemorySizer.sizeOf(netCircuitManager);
            Network network = Network.instance();
            netModelMemorySizer.reportClassCount(bl);
            netModelMemorySizer.cleanupState(true);
            this.println("*** total size: " + (n += netModelMemorySizer.sizeOf(network)));
        }

        public final void reportMemorySize() {
            this.reportMemorySize(true, false);
        }

        public final void reverseRoutingDir(String string) {
            NetCircuit netCircuit = this.getCircuit(string);
            if (netCircuit != null && netCircuit instanceof NetCcatCircuit) {
                try {
                    ((NetCcatCircuit)netCircuit).reverseRoutingDir();
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    this.println("Invalid ckt operation, incorrect circuit state");
                }
            }
        }

        public NetCircuit getCircuit(String string) {
            NetCircuit netCircuit = null;
            Iterator iterator = NetCircuitManager.this.getCircuits().iterator();
            while (iterator.hasNext() && !(netCircuit = (NetCircuit)iterator.next()).getCircuitName().equals(string)) {
            }
            return netCircuit;
        }
    }
}

