/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.DeleteInstead;
import cerent.cms.model.DropsExceedMax;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.HoUpsrAttributes;
import cerent.cms.model.IAdminState;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionConversionModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IDriNodeType;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoUpsrAttributes;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IOnePlusOneModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRollModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.InServiceUpgradeState;
import cerent.cms.model.InsufficientBandwidth;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.NoSuchDefault;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathListIncomplete;
import cerent.cms.model.TestAccessActive;
import cerent.cms.model.TopologyUpgradeNotAllowed;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.BridgeConnection;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.Connection;
import cerent.cms.ncp.ConnectionPathNotFound;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.EtherNodeDropCircuitEnd;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitProvState;
import cerent.cms.ncp.IUpsrOps;
import cerent.cms.ncp.IUpsrSpanState;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.InternalCircuitSpan;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.NetUpsrOps;
import cerent.cms.ncp.NodeRoutingDirection;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OnewayConnection;
import cerent.cms.ncp.PathDefsHolder;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SelectorConnection;
import cerent.cms.ncp.SpliceLinkIndex;
import cerent.cms.ncp.SpliceListener;
import cerent.cms.ncp.SpliceListenerEntry;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.ncp.UpdateEventCollector;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkComparator;
import cerent.cms.ui.NetworkDefaults;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

public abstract class NetCircuitNode
extends CmsObservable
implements INetCircuitNode,
IObserver {
    private static final SDebug db = new SDebug("NetCircuitNode");
    protected INetElement ne;
    private INodeModel node;
    protected NetCcatCircuit circuit;
    protected LinkedList spliceListeners;
    protected LinkedList sources;
    protected LinkedList drops;
    protected NetCircuitEnd nodeDrop;
    private boolean isNodeRefValid;
    protected LinkedList inSpans;
    protected LinkedList outSpans;
    protected LinkedList biSpans;
    private List workingEntities;
    private List protectEntities;
    private List activeEntities;
    protected IUpsrOps upsrOps = null;
    protected int protectionOp = -1;
    protected int reverseProtectionOp = -1;
    protected List connections = null;
    protected Object entitiesLockObject;
    private int state;
    protected int connType;
    protected String connName;
    protected ICircuitId cktId;
    protected int numberOfPaths;
    private boolean registeredNullCircuitConnection;
    private List connectionPathEnds;
    private boolean currConversionStatus = false;
    private boolean loopFlag = false;
    private boolean dri = false;
    protected int adminState;
    protected int serviceState;
    protected short pathWidth;
    protected NodeRoutingDirection nodeRoutingDir;
    protected int driNodeType = 0;
    protected boolean currRollStatus = false;
    protected boolean rollHasCompleted = false;
    protected static final String node_disconnected = "Node is disconnected ";
    protected static final String connection_missing = "Connection is missing ";
    protected static final String pre_odin = "Full state model is not supported on this node ";
    protected static final String node_rejection = "Node does not allow this state transition; check for loopbacks, test access, state range ";
    protected boolean allowUpsrOver1Plus1 = false;
    private UpdateEvent updateEvent;

    public NetCircuitNode(INetElement iNetElement) {
        if (this.dbgOn()) {
            db.println("Creating " + this.getClass().getName() + " at " + iNetElement.getName());
        }
        this.ne = iNetElement;
        this.node = this.ne.getNodeModel();
        this.spliceListeners = new LinkedList();
        this.drops = new LinkedList();
        this.sources = new LinkedList();
        this.nodeDrop = null;
        this.inSpans = new LinkedList();
        this.outSpans = new LinkedList();
        this.biSpans = new LinkedList();
        this.connType = 20;
        this.setConn(null);
        this.entitiesLockObject = new Object();
        this.workingEntities = null;
        this.protectEntities = null;
        this.activeEntities = null;
        this.isNodeRefValid = true;
        this.updateEvent = new UpdateEvent();
        this.initState(0);
        this.numberOfPaths = 0;
        this.registeredNullCircuitConnection = false;
        this.connections = new LinkedList();
        this.connectionPathEnds = new LinkedList();
        this.nodeRoutingDir = new NodeRoutingDirection(this);
        this.setUpsrOver1Plus1Flag();
    }

    public NetCircuitNode(INetElement iNetElement, NetCcatCircuit netCcatCircuit) {
        this(iNetElement);
        this.setCircuit(netCcatCircuit);
        if (netCcatCircuit.getAdminState() != 0 && !iNetElement.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL)) {
            db.info("PreOdin node" + this.getName() + " does not support admin state provisioning");
        }
        this.setAdminState(netCcatCircuit.getAdminState());
    }

    public NetCircuitNode(INetElement iNetElement, NetCcatCircuit netCcatCircuit, Object object) throws AbstractCmsObjectNotExistException {
        this(iNetElement, netCcatCircuit);
        this.setConnection(object);
        this.cktId = this.getConnectionCircuitId();
        if (object != null && NetCircuit.isNullCircuitId(this.cktId)) {
            this.registerNullCircuitConnection(iNetElement, object);
        }
        this.setAdminState(this.getAdminStateFromNE());
        this.setServiceState(this.getServiceStateFromNE());
        this.currRollStatus = this.inRoll();
    }

    protected void setUpsrOver1Plus1Flag() {
        try {
            String string = this.node.getDefaultValue("NODE.circuits.upsr.AllowUpsrOverOnePlusOne");
            this.allowUpsrOver1Plus1 = string.equalsIgnoreCase("true");
            db.fine("Setting AllowUpsrOverOnePlusOne to " + string + " at Node " + this.node.getName());
        }
        catch (NoSuchDefault noSuchDefault) {
            db.severe("NODE.circuits.upsr.AllowUpsrOverOnePlusOne not supported on " + this.node.getName());
        }
    }

    public boolean isUpsrOver1Plus1Enabled() {
        return this.allowUpsrOver1Plus1;
    }

    private boolean checkListenerOnSamePort(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("Checking for sameSpan listener for cktEnd " + this.getName());
        }
        if (!this.isUpsrOver1Plus1Enabled()) {
            if (this.dbgOn()) {
                this.debug(" UPSRover1Plus1 is not Enabled on this node. ");
            }
            return false;
        }
        if (this.dbgOn()) {
            this.debug("UPSR:1+1 Node: #sources= " + this.sources.size() + " #drops= " + this.drops.size() + " #paths= " + this.numberOfPaths);
        }
        Iterator iterator = this.spliceListeners.iterator();
        while (iterator.hasNext()) {
            SpliceListenerEntry spliceListenerEntry = (SpliceListenerEntry)iterator.next();
            NetCircuitEnd netCircuitEnd2 = this.getSpliceListenerEndpoint(spliceListenerEntry);
            if (netCircuitEnd2.getNodeId() != netCircuitEnd.getNodeId() || netCircuitEnd2.getEntityIndex() != netCircuitEnd.getEntityIndex()) continue;
            this.deleteSpliceListener(spliceListenerEntry);
            return true;
        }
        return false;
    }

    protected void setConnection(Object object) {
        if (this.getState() != 0) {
            return;
        }
        this.setConn((IConnectionModel)object);
        this.addConnectionObserver();
        try {
            this.sanityCheckConnModel();
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            this.deleteConnectionObserver();
            throw abstractCmsObjectNotExistException;
        }
        this.conformToConnection();
        this.updateConnectionPathEnds();
        this.initState(2);
    }

    protected IUpsrOps getUpsrOps(NetCircuitSpan netCircuitSpan) {
        return this.getUpsrOps();
    }

    public IUpsrOps getUpsrOps() {
        return this.upsrOps;
    }

    public List getUpsrOpsList() {
        LinkedList<IUpsrOps> linkedList = new LinkedList<IUpsrOps>();
        if (this.isUpsrSelector()) {
            linkedList.add(this.getUpsrOps());
        }
        return linkedList;
    }

    protected IHoUpsrAttributes getUpsrAttributes() throws ConnectionTypeError {
        IHoUpsrAttributes iHoUpsrAttributes = this.circuit.getUpsrAttributes();
        if (iHoUpsrAttributes == null) {
            IUpsrOps iUpsrOps = this.getUpsrOps();
            if (iUpsrOps == null) {
                return null;
            }
            iHoUpsrAttributes = new HoUpsrAttributes(iUpsrOps.getUpsrSfBerLevel(), iUpsrOps.getUpsrSdBerLevel(), iUpsrOps.getUpsrReversion(), iUpsrOps.getUpsrSwitchOnPdiP());
        }
        return iHoUpsrAttributes;
    }

    protected void setConnAdminState(int n) throws AdminStateProvisioningError {
        if (this.dbgOn()) {
            this.debug("setConnAdminState() called");
        }
        if (!this.ne.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL) && n != 0) {
            db.info("PreOdin node" + this.getName() + " called for admin state " + this.translateAdminState(n));
            throw new AdminStateProvisioningError("Node " + this.getName() + " does not support circuit state " + this.translateAdminState(n) + ": use " + this.translateAdminState(0));
        }
        this.preCheckSetConnAdminState();
        if (this.getConn() != null) {
            try {
                this.getConn().setAdminState(n);
            }
            catch (ConnectionInLoopback connectionInLoopback) {
                SDebug.printStackTrace((Throwable)connectionInLoopback);
                throw new AdminStateProvisioningError(this.getName() + ": " + "One of the " + NetCircuitNode.getTDMTerminology(this.getNodeModel()).getGeneralTerms(0) + " is in XC Loopback.\n" + "The XC Loopback must be removed before the circuit state can be changed.");
            }
            catch (TestAccessActive testAccessActive) {
                SDebug.printStackTrace((Throwable)testAccessActive);
                throw new AdminStateProvisioningError(this.getName() + ": " + "One of the " + NetCircuitNode.getTDMTerminology(this.getNodeModel()).getGeneralTerms(0) + " is in test access.\n" + "The test access must be removed before the circuit state can be changed.");
            }
            catch (InvalidState invalidState) {
                SDebug.printStackTrace((Throwable)invalidState);
                throw new AdminStateProvisioningError(this.getName() + ": " + "Invalid state transition.");
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                throw new AdminStateProvisioningError(this.getName() + ": " + exception.getMessage());
            }
        } else {
            throw new AdminStateProvisioningError("NULL reference to connection object on " + this.getName());
        }
        this.setState(3);
    }

    protected boolean isConnPartofBlsrDri() {
        LinkedList linkedList = new LinkedList();
        NetCircuitSpan netCircuitSpan = null;
        switch (this.findConnType()) {
            case 10: {
                linkedList.addAll(this.getTermSpans());
                linkedList.addAll(this.getOrigSpans());
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    netCircuitSpan = (NetCircuitSpan)iterator.next();
                    if (!netCircuitSpan.getBlsrDriInterConnect()) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    protected String validateConnAdminState(int n) {
        try {
            this.preCheckSetConnAdminState();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return node_disconnected;
        }
        if (!this.ne.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL)) {
            if (this.getAdminState() == 0) {
                return null;
            }
            return pre_odin;
        }
        if (this.getConn() != null) {
            try {
                if (!this.getConn().validateNewAdminState(n)) {
                    return node_rejection;
                }
                return null;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                return node_rejection;
            }
        }
        return connection_missing;
    }

    public void setConnName(String string) throws CircuitProvError {
        try {
            if (this.ne.getNodeModel().provides(Feature.TCCU) && this.getConn() != null) {
                db.info("TCCU : For CircuitName " + this.circuit.getCircuitName() + "Connection name : " + string + "being set at node " + this.getName());
                this.getConn().setConnectionName(string);
                this.connName = string;
            }
        }
        catch (InvalidCircuitName invalidCircuitName) {
            throw new CircuitProvError("setConnName: Invalid connection name");
        }
    }

    public String getConnName() {
        if (this.isNodeDrop() && this.nodeDrop instanceof EtherNodeDropCircuitEnd) {
            return "";
        }
        return this.connName;
    }

    public ICircuitId getCircuitId() {
        return this.cktId;
    }

    public String getConnNameFromNE() {
        if (this.ne.getNodeModel().provides(Feature.TCCU) && this.getConn() != null) {
            try {
                String string = this.getConn().getConnectionName();
                db.info("TCCU : For CircuitName " + this.circuit.getCircuitName() + "Connection name is : " + string + " at node " + this.getName());
                return string;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
                return "";
            }
        }
        return "";
    }

    protected void revertAdminState() throws AdminStateProvisioningError {
        if (this.dbgOn()) {
            db.println("revertAdminState at " + this.getName());
        }
        if (this.getConn() != null) {
            try {
                this.getConn().setAdminState(this.getAdminState());
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
                throw new AdminStateProvisioningError(this.getName() + ": " + exception.getMessage());
            }
        } else {
            throw new AdminStateProvisioningError("NULL reference to connection object on " + this.getName());
        }
        this.setState(2);
    }

    protected void setCircuit(NetCcatCircuit netCcatCircuit) {
        this.circuit = netCcatCircuit;
        LinkedList linkedList = (LinkedList)this.inSpans.clone();
        linkedList.addAll((Collection)this.outSpans.clone());
        linkedList.addAll((Collection)this.biSpans.clone());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ((NetCircuitSpan)iterator.next()).setCircuit(netCcatCircuit);
        }
    }

    public int getDriNodeType() {
        return this.getState() == 0 ? this.driNodeType : this.getDriNodeTypeFromModelLayer();
    }

    void resetDriNodeType() {
        this.driNodeType = 0;
    }

    protected int getDriNodeTypeFromModelLayer() {
        if (this.ne.getNodeModel().provides(Feature.BLSR_UPSR_DRI) && this.getConn() instanceof IHoConnectionModel) {
            return ((IHoConnectionModel)this.getConn()).getDriNodeType();
        }
        return 0;
    }

    public String getName() {
        return this.ne.getName();
    }

    public String getNameAndClass() {
        return this.getName() + "(" + this.getClass().getName() + ")";
    }

    protected void preCheckSetConnAdminState() throws AdminStateProvisioningError {
        if (this.state != 2) {
            throw new AdminStateProvisioningError("Cannot change circuit state: node " + this.getName() + " not DISCOVERED");
        }
    }

    protected void integratePath(Object object, eSpanDirection eSpanDirection2, eSpanDirection eSpanDirection3, NetCircuitSplicer netCircuitSplicer) {
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), object);
        if (this.isCircuitInfoSourceOrDrop(netCircuitEnd)) {
            return;
        }
        if (netCircuitSplicer != null) {
            this.createSpliceListener(netCircuitSplicer, netCircuitEnd, eSpanDirection2);
        }
        if (!this.circuit.circuitInfoActive()) {
            this.assumeSourceOrDrop(eSpanDirection3, netCircuitEnd);
        }
    }

    protected boolean updateNumberOfPaths() {
        Object[] objectArray = this.getPathsFromConnModel();
        int n = objectArray.length;
        if (n != this.numberOfPaths) {
            if (this.dbgOn()) {
                db.println(" updateNumberOfPaths: " + this.numberOfPaths + " -> " + n);
            }
            this.numberOfPaths = n;
            return true;
        }
        return false;
    }

    protected abstract void sanityCheckConnModel();

    protected abstract int getConnTypeFromConnModel();

    protected void setConnTypeInConnModel(int n) throws ConnectionTypeError, ConnectionInTopologyUpgrade, ConnectionInLoopback, ConnectionInTestAccess, ConnectionInRoll {
    }

    protected void addOutputToConnModel(NetCircuitEnd netCircuitEnd) throws CTCUserException {
    }

    protected void addOutputToConnModel(NetCircuitSpan netCircuitSpan) throws CTCUserException {
    }

    protected void removeOutputFromConnModel(NetCircuitEnd netCircuitEnd) throws InvalidPath, DeleteInstead, ConnectionTypeError, ObjNotFound, PathInUse, NoMoreLoCapableHo {
    }

    protected void removeOutputFromConnModel(NetCircuitSpan netCircuitSpan) throws InvalidPath, DeleteInstead, ConnectionTypeError, ObjNotFound, PathInUse, NoMoreLoCapableHo {
    }

    protected abstract Object[] getPathsFromConnModel();

    protected Object[] getConnectionPathDefs() {
        return this.getPathsFromConnModel();
    }

    protected abstract Object[] getActivePathsFromConnModel();

    protected abstract int getProtectionOpFromConnModel();

    protected abstract int getReverseProtectionOpFromConnModel();

    protected IRollModel getRoll() {
        return null;
    }

    protected Object getRollFromPath(IRollModel iRollModel) {
        return null;
    }

    protected Object getRollToPath(IRollModel iRollModel) {
        return null;
    }

    public int getConnectionType() {
        return this.connType;
    }

    protected void setConnectionType(int n) {
        this.connType = n;
        if (this.dbgOn()) {
            db.println("setConnectionType: connType = " + EnumStrings.getString((Class)IConnectionType.class, (int)this.connType));
        }
    }

    protected int getConnDir() {
        return NetCircuitNode.getConnDir(this.getConnectionType());
    }

    public static int getConnDir(int n) {
        if (n == 20) {
            return -1;
        }
        if (NetCircuitNode.isUnidirectionalConnType(n)) {
            return 0;
        }
        if (NetCircuitNode.isBidirectionalConnType(n)) {
            return 1;
        }
        return -1;
    }

    protected boolean isBidirectionalConnType() {
        return NetCircuitNode.isBidirectionalConnType(this.getConnectionType());
    }

    protected boolean isUnidirectionalConnType() {
        return NetCircuitNode.isUnidirectionalConnType(this.getConnectionType());
    }

    protected static boolean isBidirectionalConnType(int n) {
        return n == 1 || n == 2 || n == 3 || n == 8 || n == 10 || n == 11 || n == 13 || n == 14 || n == 12 || n == 18;
    }

    private static boolean isUnidirectionalConnType(int n) {
        return n == 0 || n == 4 || n == 5 || n == 6 || n == 7 || n == 9 || n == 15 || n == 16;
    }

    protected boolean hasTl1ConnType() {
        return this.connType == 0 || this.connType == 1 || this.connType == 2 || this.connType == 3 || this.connType == 9 || this.connType == 10 || this.connType == 11 || this.connType == 12 || this.connType == 18 || this.connType == 13 || this.connType == 14 || this.connType == 15 || this.connType == 16;
    }

    protected boolean is1wayUpsrConnType() {
        if (this.connType == 4 || this.connType == 0) {
            if (this.connections.size() == 1) {
                NetCircuitSpan netCircuitSpan;
                Connection connection = (Connection)this.connections.get(0);
                List list = connection.getInSpans();
                NetCircuitSpan netCircuitSpan2 = netCircuitSpan = list.size() == 0 ? null : (NetCircuitSpan)list.get(0);
                if (connection.isInputLineProtected(netCircuitSpan)) {
                    return false;
                }
                if (netCircuitSpan == null) {
                    db.println("is1wayUpsrConnType: Error in connection input on node " + this.getName());
                    return true;
                }
                return netCircuitSpan.getUpsrLink();
            }
            if (this.circuit.getState() == 1) {
                db.println("is1wayUpsrConnType: Error in connection list on node " + this.getName());
            }
            return true;
        }
        return this.connType == 5 || this.connType == 7;
    }

    protected int getEntityIndexFromPathDef(Object object) {
        if (object instanceof IHoPathDefModel) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)object;
            return iHoPathDefModel.getPool().getEntityIndex();
        }
        if (object instanceof ILoDefModel) {
            ILoDefModel iLoDefModel = (ILoDefModel)object;
            return NetCircuitNode.getEntityIndexFromLoDef(this.node, iLoDefModel);
        }
        return 0;
    }

    protected static int getEntityIndexFromLoDef(INodeModel iNodeModel, ILoDefModel iLoDefModel) {
        if (iNodeModel.provides(Feature.VCAT)) {
            return iLoDefModel.getPortIndex();
        }
        if (iLoDefModel.getLoAdit() != null) {
            return iLoDefModel.getLoAdit().getHo().getPool().getEntityIndex();
        }
        return 0;
    }

    private IHoNum getHoNumFromPathDef(Object object) {
        if (object instanceof IHoPathDefModel) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)object;
            return HoPathDefModel.physicalHo(iHoPathDefModel);
        }
        if (object instanceof ILoDefModel) {
            ILoDefModel iLoDefModel = (ILoDefModel)object;
            return HoPathDefModel.physicalHo(iLoDefModel.getLoAdit().getHo());
        }
        return null;
    }

    private ILoNum getLoNumFromPathDef(Object object) {
        if (object instanceof ILoDefModel) {
            ILoDefModel iLoDefModel = (ILoDefModel)object;
            return iLoDefModel.getLoNum();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getConnectionPathEnds() {
        LinkedList linkedList;
        List list = this.connectionPathEnds;
        synchronized (list) {
            linkedList = new LinkedList(this.connectionPathEnds);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetCircuitEnd getConnectionPathEnd(int n) {
        NetCircuitEnd netCircuitEnd;
        List list = this.connectionPathEnds;
        synchronized (list) {
            netCircuitEnd = (NetCircuitEnd)this.connectionPathEnds.get(n);
        }
        return netCircuitEnd;
    }

    protected List getPathEndsFromPathDefs(Object[] objectArray) {
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[i]);
            linkedList.add(netCircuitEnd);
        }
        return linkedList;
    }

    protected boolean updateConnectionPathEnds(List list) {
        if (!((Object)this.connectionPathEnds).equals(list)) {
            this.connectionPathEnds = list;
            if (this.dbgOn()) {
                this.debug("updateConnectionPathEnds: path ends changed for " + this.getName() + ", count = " + this.connectionPathEnds.size());
            }
            return true;
        }
        return false;
    }

    protected boolean updateConnectionPathEnds() {
        if (this.dbgOn()) {
            this.debug("updateConnectionPathEnds: updating connection paths from CM for " + this.getName());
        }
        List list = this.getPathEndsFromPathDefs(this.getConnectionPathDefs());
        return this.updateConnectionPathEnds(list);
    }

    protected void addConnectionPathEnd(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("Adding connection path end: " + netCircuitEnd.prettyString());
        }
        this.connectionPathEnds.add(netCircuitEnd);
        try {
            if (this.circuit.isTl1Ckt()) {
                this.createSpliceListener(netCircuitEnd);
            }
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            // empty catch block
        }
    }

    protected void addConnectionPathEnd(NetCircuitSpan netCircuitSpan) {
        this.addConnectionPathEnd(this.getSpanEndpoint(netCircuitSpan));
    }

    protected int getConnectionPathIndex(NetCircuitSpan netCircuitSpan) throws ConnectionPathNotFound {
        return this.getConnectionPathIndex(this.getSpanEndpoint(netCircuitSpan));
    }

    protected int getConnectionPathIndex(NetCircuitEnd netCircuitEnd) throws ConnectionPathNotFound {
        NetCircuitEnd netCircuitEnd2;
        NetCircuitEnd netCircuitEnd3 = NetCircuitEndFactory.convertCircuitEnd(this, netCircuitEnd);
        int n = 0;
        Iterator iterator = this.getConnectionPathEnds().iterator();
        while (iterator.hasNext()) {
            netCircuitEnd2 = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd3.equals(netCircuitEnd2)) {
                return n;
            }
            ++n;
        }
        if (this.dbgOn()) {
            this.debug("getConnectionPathIndex: ERROR! Could not find path:");
            this.debug("  " + netCircuitEnd.prettyString());
            this.debug(" which was converted to:");
            this.debug("  " + netCircuitEnd3.prettyString());
            this.debug(" Connection Paths: ");
            iterator = this.getConnectionPathEnds().iterator();
            while (iterator.hasNext()) {
                netCircuitEnd2 = (NetCircuitEnd)iterator.next();
                this.debug("  " + netCircuitEnd2.prettyString());
            }
        }
        throw new ConnectionPathNotFound("Connection path endpoint not found on node " + this.getName());
    }

    protected boolean hasConnectionPath(NetCircuitSpan netCircuitSpan) {
        return this.hasConnectionPath(this.getSpanEndpoint(netCircuitSpan));
    }

    protected boolean hasConnectionPath(NetCircuitEnd netCircuitEnd) {
        NetCircuitEnd netCircuitEnd2 = NetCircuitEndFactory.convertCircuitEnd(this, netCircuitEnd);
        Iterator iterator = this.getConnectionPathEnds().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd3 = (NetCircuitEnd)iterator.next();
            if (!netCircuitEnd2.equals(netCircuitEnd3)) continue;
            return true;
        }
        return false;
    }

    protected IConnectionConversionModel getConnectionConversionModel() {
        IConnectionConversionModel iConnectionConversionModel = null;
        if (this.inConnectionConversion()) {
            try {
                iConnectionConversionModel = this.getConn().getConnectionConversionModel();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                iConnectionConversionModel = null;
            }
        }
        return iConnectionConversionModel;
    }

    protected int getConversionOp() {
        int n;
        if (this.inConnectionConversion()) {
            return -1;
        }
        try {
            n = this.getConnectionConversionModel().getUpgradeOperation();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            n = -1;
        }
        return n;
    }

    protected void conformToPaths(Object[] objectArray, NetCircuitSplicer netCircuitSplicer) {
        if (objectArray == null) {
            return;
        }
        this.numberOfPaths = objectArray.length;
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        if (this.dbgOn()) {
            db.println("conformToPaths: " + this.getName() + " connType: " + EnumStrings.getString((Class)IConnectionType.class, (int)this.connType) + " no. of paths:" + this.numberOfPaths);
        }
        this.nodeRoutingDir.setNodeRoutingDirToForward();
        if (NetCircuitNode.isBidirectionalConnType(this.connType)) {
            if (this.connType == 1 || this.connType == 18) {
                if (this.numberOfPaths == 2) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid TWOWAY");
                }
            } else if (this.connType == 2) {
                if (this.numberOfPaths == 3) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid UPSR");
                }
            } else if (this.connType == 3) {
                if (this.numberOfPaths == 4) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid UPSR_UPSR");
                }
            } else if (this.connType == 12) {
                if (this.numberOfPaths == 4) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid OCHNC_TWOWAY");
                }
            } else if (this.connType == 8) {
                eSpanDirection eSpanDirection2 = eSpanDirection.TERMINATING;
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection2, netCircuitSplicer);
                    eSpanDirection2 = NodeRoutingDirection.getOppositeRoutingDir(eSpanDirection2);
                }
            } else if (this.connType == 10) {
                if (this.numberOfPaths == 3) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid no. of paths " + this.numberOfPaths + " for UPSR_DRI");
                }
            } else if (this.connType == 11) {
                if (this.numberOfPaths == 4) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid no. of paths " + this.numberOfPaths + " for UPSR_IDRI");
                }
            } else if (this.connType == 13) {
                if (this.numberOfPaths == 4) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid no. of paths " + this.numberOfPaths + " for BLSR_IDRI");
                }
            } else if (this.connType == 14) {
                if (this.numberOfPaths == 4) {
                    Object object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                } else if (this.dbgOn()) {
                    db.println("conformToPath: invalid no. of paths " + this.numberOfPaths + " for UPSR_BLSR_IDRI");
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: Unsupported BIDIRECTIONAL connType");
            }
            return;
        }
        if (this.connType == 0 || this.connType == 9) {
            if (this.numberOfPaths >= 2) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, this.connType == 0 ? netCircuitSplicer : null);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: invalid 1Way/Monitor connection");
            }
        } else if (this.connType == 4) {
            if (this.numberOfPaths >= 3) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            }
        } else if (this.connType == 17) {
            if (this.numberOfPaths >= 3) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.BIDIRECTIONAL, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: invalid UPSR_HEAD_3");
            }
        } else if (this.connType == 6) {
            if (this.numberOfPaths >= 2) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: invalid UPSR_DC");
            }
        } else if (this.connType == 5) {
            if (this.numberOfPaths >= 2) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: invalid UPSR_DROP");
            }
        } else if (this.connType == 7) {
            if (this.numberOfPaths >= 2) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: invalid UPSR_EN");
            }
        } else if (this.connType == 15) {
            if (this.numberOfPaths >= 4) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: Invalid BLSR_DC");
            }
        } else if (this.connType == 16) {
            if (this.numberOfPaths >= 4) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
                }
            } else if (this.dbgOn()) {
                db.println("conformToPath: Invalid UPSR_BLSR_DC");
            }
        } else if (this.dbgOn()) {
            db.println("conformToPath: Unsupported UNIDIRECTIONAL connType");
        }
    }

    public boolean isNodeDrop() {
        return this.nodeDrop != null;
    }

    public boolean eligibleForEtherHoDropAdd() {
        return false;
    }

    protected boolean isCircuitInfoSourceOrDrop(NetCircuitEnd netCircuitEnd) {
        if (!this.circuit.circuitInfoActive()) {
            return false;
        }
        boolean bl = false;
        if (this.circuit.isSource(netCircuitEnd)) {
            if (!this.sources.contains(netCircuitEnd)) {
                if (this.dbgOn()) {
                    db.println("adding circuit end as source");
                }
                this.insertSource(netCircuitEnd);
            }
            bl = true;
        }
        if (this.circuit.isDrop(netCircuitEnd)) {
            if (!this.drops.contains(netCircuitEnd)) {
                if (this.dbgOn()) {
                    db.println("adding circuit end as drop");
                }
                this.insertDrop(netCircuitEnd);
                Iterator iterator = this.circuit.getDrops().iterator();
                while (iterator.hasNext()) {
                    NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
                    NetCircuitEnd netCircuitEnd2 = netCircuitDropInfo.getNetCktEnd();
                    if (!netCircuitEnd2.equals(netCircuitEnd) || netCircuitEnd2 == netCircuitEnd) continue;
                    this.circuit.removeDrop(netCircuitDropInfo);
                    this.circuit.insertDrop(new NetCircuitDropInfo(netCircuitEnd, netCircuitDropInfo.getPathProt()));
                }
            }
            bl = true;
        }
        return bl;
    }

    protected void assumeSourceOrDrop(eSpanDirection eSpanDirection2, NetCircuitEnd netCircuitEnd) {
        if (eSpanDirection2 == eSpanDirection.TERMINATING) {
            if (this.dbgOn()) {
                db.println("adding active source");
            }
            this.insertSource(netCircuitEnd);
        } else {
            if (this.dbgOn()) {
                db.println("adding active drop");
            }
            this.insertDrop(netCircuitEnd);
        }
    }

    public INetElement getNetElement() {
        return this.ne;
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSources() {
        LinkedList linkedList;
        LinkedList linkedList2 = this.sources;
        synchronized (linkedList2) {
            linkedList = new LinkedList(this.sources);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDrops() {
        LinkedList linkedList;
        LinkedList linkedList2 = this.drops;
        synchronized (linkedList2) {
            linkedList = new LinkedList(this.drops);
        }
        return linkedList;
    }

    protected List getRoutedDrops() {
        List list = this.getDrops();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.getStage() == 2) continue;
            iterator.remove();
        }
        return list;
    }

    public int totalSpans() {
        return this.inSpans.size() + this.outSpans.size() + this.biSpans.size();
    }

    protected LinkedList getBiSpans() {
        return new LinkedList(this.biSpans);
    }

    protected LinkedList getTermSpans() {
        LinkedList<NetCircuitSpan> linkedList = new LinkedList<NetCircuitSpan>();
        Iterator iterator = this.inSpans.iterator();
        while (iterator.hasNext()) {
            linkedList.add((NetCircuitSpan)iterator.next());
        }
        iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (this.findRoutingDir(netCircuitSpan) != eSpanDirection.TERMINATING) continue;
            linkedList.add(netCircuitSpan);
        }
        return linkedList;
    }

    protected LinkedList getOrigSpans() {
        LinkedList<NetCircuitSpan> linkedList = new LinkedList<NetCircuitSpan>();
        Iterator iterator = this.outSpans.iterator();
        while (iterator.hasNext()) {
            linkedList.add((NetCircuitSpan)iterator.next());
        }
        iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (this.findRoutingDir(netCircuitSpan) != eSpanDirection.ORIGINATING) continue;
            linkedList.add(netCircuitSpan);
        }
        return linkedList;
    }

    protected LinkedList getRoutedOrigSpans() {
        LinkedList linkedList = this.getOrigSpans();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getSrcState() == 2) continue;
            iterator.remove();
        }
        return linkedList;
    }

    protected LinkedList getOmniSpans() {
        LinkedList<NetCircuitSpan> linkedList = new LinkedList<NetCircuitSpan>();
        Iterator iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (!netCircuitSpan.getNetLinkSpan().getOmni()) continue;
            linkedList.add(netCircuitSpan);
        }
        return linkedList;
    }

    protected int countNumTermSpans() {
        return this.getTermSpans().size();
    }

    protected int countNumOrigSpans() {
        return this.getOrigSpans().size();
    }

    protected int countNumInputs() {
        return this.sources.size() + this.countNumTermSpans();
    }

    protected int countNumOutputs() {
        return this.drops.size() + this.countNumOrigSpans();
    }

    public int countRoutedOrigSpans() {
        int n = 0;
        Iterator iterator = this.getOrigSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getSrcState() != 2) continue;
            ++n;
        }
        return n;
    }

    public int countRoutedTermSpans() {
        int n = 0;
        Iterator iterator = this.getTermSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getDstState() != 2) continue;
            ++n;
        }
        return n;
    }

    protected int countNumOmniSpans() {
        int n = 0;
        return n += this.getOmniSpans().size();
    }

    protected int countRoutedSources() {
        int n = 0;
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.getStage() != 2) continue;
            ++n;
        }
        return n;
    }

    protected int countRoutedDrops() {
        int n = 0;
        Iterator iterator = this.drops.iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.getStage() != 2) continue;
            ++n;
        }
        return n;
    }

    protected int countRoutedOutputs() {
        return this.countRoutedDrops() + this.countRoutedOrigSpans();
    }

    protected int countRoutedInputs() {
        return this.countRoutedSources() + this.countRoutedTermSpans();
    }

    protected int countActiveInputs() {
        int n = 0;
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.getStage() != 4) continue;
            ++n;
        }
        iterator = this.getTermSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getDstState() != 4) continue;
            ++n;
        }
        return n;
    }

    protected int countActiveOutputs() {
        int n = 0;
        Iterator iterator = this.drops.iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.getStage() != 4) continue;
            ++n;
        }
        iterator = this.getOrigSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getSrcState() != 4) continue;
            ++n;
        }
        return n;
    }

    protected int calculateConnectionType(SDebug sDebug) {
        int n = 0;
        n = this.circuit.isBidirectional() ? this.calculateBidirectionalConnType(this.countNumInputs(), this.countNumOutputs(), this.biSpans().size(), this.countNumOmniSpans(), true, sDebug) : this.calculateUnidirectionalConnType(this.countNumInputs(), this.countNumOutputs(), this.biSpans().size(), this.countNumOmniSpans(), true, sDebug);
        if (sDebug.on()) {
            sDebug.println("calculateConnectionType: old conn type => " + EnumStrings.getString((Class)IConnectionType.class, (int)this.getConnectionType()) + ", new conn type => " + EnumStrings.getString((Class)IConnectionType.class, (int)n));
        }
        return n;
    }

    private int calculateBidirectionalConnType(int n, int n2, int n3, int n4, boolean bl, SDebug sDebug) {
        int n5 = n + n2 + n4;
        if (sDebug.on()) {
            sDebug.println("calculateBiConnType: inSpans => " + n + ", outSpans => " + n2 + ", biSpans => " + n3 + ", omniSpans => " + n4 + ", isUpsr => " + bl);
        }
        if (n5 == 2) {
            if (n == 1 && n2 == 1 && n4 == 0 || n4 == 2 && n == 0 && n2 == 0) {
                return 1;
            }
        } else if (n5 == 3) {
            if (n == 2 && n2 == 1 || n == 1 && n2 == 2) {
                return 2;
            }
            if (n == 1 && n2 == 1 && n4 == 1) {
                return 10;
            }
        } else if (n5 == 4) {
            if (n == 2 && n2 == 2 && n4 == 0) {
                return 3;
            }
            if (n == 1 && n2 == 1 && n4 == 2) {
                return 11;
            }
        }
        if (sDebug.on()) {
            sDebug.println("calculateBidirectionalConnType: WARNING - unknown Conn. Type, node => " + this.getNetElement().getHostName() + ", total => " + n5 + ", in => " + n + ", out => " + n2 + ", omni => " + n4);
        }
        return 20;
    }

    private int calculateUnidirectionalConnType(int n, int n2, int n3, int n4, boolean bl, SDebug sDebug) {
        int n5 = n + n2;
        if (sDebug.on()) {
            sDebug.println("calculateUniConnType: inSpans => " + n + ", outSpans => " + n2 + ", biSpans => " + n3 + ", omniSpans => " + n4 + ", isUpsr => " + bl);
        }
        if (n == 1 && n2 == 1) {
            if (bl) {
                return 1;
            }
            return 0;
        }
        if (n == 1 && n2 == 2) {
            return 0;
        }
        if (n == 2 && n2 == 1) {
            return 6;
        }
        if (n == 2 && n2 >= 2) {
            return 6;
        }
        if (n == 1 && n2 == 1 && n4 > 0 && n4 < 3) {
            return 6;
        }
        if (sDebug.on()) {
            sDebug.println("calculateUnidirectionalConnType: WARNING - unknown Conn. Type, node => " + this.getNetElement().getHostName() + ", total => " + n5 + ", in => " + n + ", out => " + n2 + ", omni => " + n4);
        }
        return 20;
    }

    protected int findUpgradedConnType() {
        if (this.dbgOn()) {
            db.println("finding upgraded connection type for Node " + this.getName());
        }
        if (this.circuit.isBidirectional()) {
            if (this.biSpans.size() > 2) {
                return 20;
            }
            return this.connType;
        }
        int n = this.countRoutedOutputs();
        if (this.connType == 1 && n > 0) {
            return 6;
        }
        return this.connType;
    }

    protected int findDowngradedConnType() {
        if (this.circuit.getCircuitDir() == 1) {
            if (this.dbgOn()) {
                db.println("Downgrade of bi-direc nodes not allowed");
            }
            return 20;
        }
        int n = this.countNumOutputs();
        if (this.connType == 6 && n == 1) {
            return 1;
        }
        return this.connType;
    }

    protected eSpanDirection findDir(NetCircuitSpan netCircuitSpan) {
        if (this.inSpans.contains(netCircuitSpan)) {
            return eSpanDirection.TERMINATING;
        }
        if (this.outSpans.contains(netCircuitSpan)) {
            return eSpanDirection.ORIGINATING;
        }
        if (this.biSpans.contains(netCircuitSpan)) {
            return eSpanDirection.BIDIRECTIONAL;
        }
        if (this.dbgOn()) {
            db.println("findDir: Span not found at " + this.getName());
        }
        return null;
    }

    protected eSpanDirection findRoutingDir(NetCircuitSpan netCircuitSpan) {
        if (this.findDir(netCircuitSpan) == eSpanDirection.BIDIRECTIONAL) {
            return netCircuitSpan.biSpanDir(this.ne);
        }
        return this.findDir(netCircuitSpan);
    }

    protected eSpanDirection findRoutingDir(INetLink iNetLink) {
        eSpanDirection eSpanDirection2 = eSpanDirection.TERMINATING;
        if (this.ne == iNetLink.getSrc()) {
            eSpanDirection2 = eSpanDirection.ORIGINATING;
        } else if (this.ne == iNetLink.getDst()) {
            eSpanDirection2 = eSpanDirection.TERMINATING;
        } else if (this.dbgOn()) {
            this.debug("findRoutingDir: ERROR! Link does not touch node " + this.getName());
        }
        return eSpanDirection2;
    }

    protected int findConnType() {
        if (this.equals(this.circuit.getSrcCircuitNode()) && this.circuit.isDiag()) {
            return 18;
        }
        if (this.circuit.getCircuitDir() == 1) {
            return this.findBiDirectionalConnType();
        }
        return this.findUniDirectionalConnType();
    }

    protected int getTotalInOuts() {
        int n = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
        return n;
    }

    protected int findBiDirectionalConnType() {
        int n;
        int n2;
        int n3 = this.countNumInputs();
        int n4 = n3 + (n2 = this.countNumOutputs()) + (n = this.countNumOmniSpans());
        if (n4 == 2) {
            if (n3 == 1 && n2 == 1 && n == 0 || n == 2 && n3 == 0 && n2 == 0) {
                return 1;
            }
        } else if (n4 == 3) {
            if (n3 == 2 && n2 == 1 || n3 == 1 && n2 == 2) {
                return 2;
            }
            if (n3 == 1 && n2 == 1 && n == 1) {
                return 10;
            }
        } else if (n4 == 4) {
            if (n3 == 2 && n2 == 2 && n == 0) {
                if (this.areSpansBlsrProtected()) {
                    return 13;
                }
                return 3;
            }
            if (n3 == 1 && n2 == 1 && n == 2) {
                return 11;
            }
            if ((n3 == 2 && n2 == 1 || n3 == 1 && n2 == 2) && n == 1 && this.upsrBlsrHandoffProtCheck()) {
                return 14;
            }
        }
        if (this.onXm()) {
            return DualConnectionCircuitNode.findBiDirectionalConnType(this);
        }
        if (this.dbgOn()) {
            db.println("Warning! findBiDirectionalConnType: Unknown Conn. Type, node: " + this.getName() + " total=" + n4 + " in: " + n3 + " out: " + n2 + " omni: " + n);
        }
        return 20;
    }

    private boolean upsrBlsrHandoffProtCheck() {
        String string;
        LinkedList linkedList;
        LinkedList linkedList2;
        boolean bl = false;
        if (this.countNumTermSpans() == 2 && this.countNumOrigSpans() == 1 && this.countNumOmniSpans() == 1) {
            linkedList2 = this.getTermSpans();
            linkedList = this.getOrigSpans();
        } else if (this.countNumTermSpans() == 1 && this.countNumOrigSpans() == 2 && this.countNumOmniSpans() == 1) {
            linkedList2 = this.getOrigSpans();
            linkedList = this.getTermSpans();
        } else {
            return false;
        }
        if (((NetCircuitSpan)linkedList2.get(0)).getLink().inBLSR() && !((NetCircuitSpan)linkedList2.get(1)).getLink().isProtected()) {
            string = ((NetCircuitSpan)linkedList2.get(0)).getLink().blsrRingName();
        } else if (!((NetCircuitSpan)linkedList2.get(0)).getLink().isProtected() && ((NetCircuitSpan)linkedList2.get(1)).getLink().inBLSR()) {
            string = ((NetCircuitSpan)linkedList2.get(1)).getLink().blsrRingName();
        } else {
            if (this.dbgOn()) {
                db.println("upsrBlsrHandoffProtCheck: inSpans prot check failed");
            }
            return false;
        }
        LinkedList linkedList3 = this.getOmniSpans();
        if (((NetCircuitSpan)linkedList3.get(0)).getLink().isProtected()) {
            if (this.dbgOn()) {
                db.println("upsrBlsrHandoffProtCheck: omniSpans prot check failed");
            }
            return false;
        }
        if (!((NetCircuitSpan)linkedList.get(0)).getLink().inWorkingBLSR()) {
            if (this.dbgOn()) {
                db.println("upsrBlsrHandoffProtCheck: outSpans prot check failed");
            }
            return false;
        }
        if (!string.equals(((NetCircuitSpan)linkedList.get(0)).getLink().blsrRingName())) {
            if (this.dbgOn()) {
                db.println("upsrBlsrHandoffProtCheck: inSpan-outSpan ring mismatch");
            }
            return false;
        }
        return true;
    }

    private boolean blsrUpsrHandoffProtCheck() {
        String string;
        boolean bl = false;
        if (this.dbgOn()) {
            db.println("blsUpsrHandoffCheck");
        }
        if (this.countNumTermSpans() != 1 || this.countNumOrigSpans() != 2 || this.countNumOmniSpans() != 1) {
            return false;
        }
        LinkedList linkedList = this.getOrigSpans();
        if (((NetCircuitSpan)linkedList.get(0)).getLink().inBLSR() && !((NetCircuitSpan)linkedList.get(1)).getLink().isProtected()) {
            string = ((NetCircuitSpan)linkedList.get(0)).getLink().blsrRingName(this.getNetElement());
        } else if (!((NetCircuitSpan)linkedList.get(0)).getLink().isProtected() && ((NetCircuitSpan)linkedList.get(1)).getLink().inBLSR()) {
            string = ((NetCircuitSpan)linkedList.get(1)).getLink().blsrRingName(this.getNetElement());
        } else {
            if (this.dbgOn()) {
                db.println("blsUpsrHandoffCheck: outspan protection check failed");
            }
            return false;
        }
        LinkedList linkedList2 = this.getOmniSpans();
        if (((NetCircuitSpan)linkedList2.get(0)).getLink().isProtected()) {
            if (this.dbgOn()) {
                db.println("blsUpsrHandoffCheck: omnispan protection check failed");
            }
            return false;
        }
        LinkedList linkedList3 = this.getTermSpans();
        if (!((NetCircuitSpan)linkedList3.get(0)).getLink().inWorkingBLSR()) {
            return false;
        }
        if (!string.equals(((NetCircuitSpan)linkedList3.get(0)).getLink().blsrRingName(this.getNetElement()))) {
            if (this.dbgOn()) {
                db.println("blsUpsrHandoffCheck: in out span ring mismatch");
            }
            return false;
        }
        if (this.dbgOn()) {
            db.println("blsUpsrHandoffCheck: passed");
        }
        return true;
    }

    protected int findUniDirectionalConnType() {
        int n = this.countNumInputs();
        int n2 = this.countNumOutputs();
        int n3 = this.countNumOmniSpans();
        int n4 = n + n2 + n3;
        if (n3 > 2) {
            if (this.dbgOn()) {
                db.println("FindUniDirectionalConnType: too many omni spans: " + n3);
            }
            return 20;
        }
        if (this.biSpans.size() != 0) {
            if (n4 == 2 && n3 == 0) {
                return 1;
            }
            if (n4 == 2 && n3 == 2) {
                return 1;
            }
            if (n4 == 3 && n3 == 1) {
                return 6;
            }
        }
        if (this.circuit.isMonitorCircuit() && this.circuit.srcCircuitNode.equals(this)) {
            if (n == 1 && n2 == 1) {
                return 9;
            }
            if (this.dbgOn()) {
                db.println("Unknown conn type at " + this.getName());
            }
            return 20;
        }
        if (n4 == 2 && n == 1 && n2 == 1) {
            return 0;
        }
        if (n4 == 3) {
            if (n == 2 && n2 == 1) {
                return 6;
            }
            if (n == 1 && n2 == 1 && n3 == 1) {
                return 6;
            }
            if (n == 1 && n2 == 2) {
                return 0;
            }
        }
        if (n4 == 4) {
            if (n == 2 && n2 == 2) {
                if (this.areSpansBlsrProtected()) {
                    return 15;
                }
                return 6;
            }
            if (n == 2 && n2 == 1 && n3 == 1) {
                if (this.upsrBlsrHandoffProtCheck()) {
                    return 16;
                }
            } else if (n == 1 && n2 == 2 && n3 == 1 && this.blsrUpsrHandoffProtCheck()) {
                return 0;
            }
        }
        if (this.onXm()) {
            return DualConnectionCircuitNode.findUniDirectionalConnType(this);
        }
        if (this.dbgOn()) {
            db.println("Unknown conn type at " + this.getName());
        }
        return 20;
    }

    private boolean areSpansBlsrProtected() {
        NetCircuitSpan netCircuitSpan;
        NetLinkSpan netLinkSpan;
        INetLink iNetLink;
        INetLink iNetLink2;
        Iterator iterator;
        String[] stringArray = new String[4];
        if (this.dbgOn()) {
            db.println("areSpansBlsrProtected");
        }
        if (this.countNumInputs() != 2 || this.countNumOutputs() != 2 || this.countNumOmniSpans() != 0) {
            return false;
        }
        LinkedList linkedList = this.getTermSpans();
        LinkedList linkedList2 = this.getOrigSpans();
        if (linkedList.size() != 2) {
            if (this.getSources().isEmpty()) {
                return false;
            }
            iterator = (NetCircuitEnd)this.getSources().get(0);
            iNetLink2 = this.circuit.getNetwork().findNetLinkFromSource(false, ((NetCircuitEnd)((Object)iterator)).getNetElement(), ((NetCircuitEnd)((Object)iterator)).getEntityIndex(), ((NetCircuitEnd)((Object)iterator)).getHoNum(), ((NetCircuitEnd)((Object)iterator)).getLoNum());
            if (iNetLink2 == null) {
                return false;
            }
            iNetLink = iNetLink2.getReverseLink();
            if (iNetLink == null) {
                return false;
            }
            netLinkSpan = new NetLinkSpan(iNetLink, iNetLink2, ((NetCircuitEnd)((Object)iterator)).getHoNum(), ((NetCircuitEnd)((Object)iterator)).getHoNum(), ((NetCircuitEnd)((Object)iterator)).getLoNum());
            netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this.circuit, netLinkSpan);
            linkedList.addFirst(netCircuitSpan);
        }
        if (linkedList2.size() != 2) {
            if (this.getDrops().isEmpty()) {
                return false;
            }
            iterator = (NetCircuitEnd)this.getDrops().get(0);
            iNetLink2 = this.circuit.getNetwork().findNetLinkFromSource(false, ((NetCircuitEnd)((Object)iterator)).getNetElement(), ((NetCircuitEnd)((Object)iterator)).getEntityIndex(), ((NetCircuitEnd)((Object)iterator)).getHoNum(), ((NetCircuitEnd)((Object)iterator)).getLoNum());
            if (iNetLink2 == null) {
                return false;
            }
            iNetLink = iNetLink2.getReverseLink();
            if (iNetLink == null) {
                return false;
            }
            netLinkSpan = new NetLinkSpan(iNetLink2, iNetLink, ((NetCircuitEnd)((Object)iterator)).getHoNum(), ((NetCircuitEnd)((Object)iterator)).getHoNum(), ((NetCircuitEnd)((Object)iterator)).getLoNum());
            netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this.circuit, netLinkSpan);
            linkedList2.addLast(netCircuitSpan);
        }
        if (linkedList.size() != 2 || linkedList2.size() != 2) {
            return false;
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan2.getLink().inBLSR()) continue;
            return false;
        }
        if (((NetCircuitSpan)linkedList.get(0)).getLink().blsrRingName(this.getNetElement()).equals(((NetCircuitSpan)linkedList.get(1)).getLink().blsrRingName(this.getNetElement()))) {
            return false;
        }
        stringArray[0] = ((NetCircuitSpan)linkedList.get(0)).getLink().blsrRingName();
        stringArray[1] = ((NetCircuitSpan)linkedList.get(1)).getLink().blsrRingName();
        iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan3 = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan3.getLink().inBLSR()) continue;
            return false;
        }
        if (((NetCircuitSpan)linkedList2.get(0)).getLink().blsrRingName().equals(((NetCircuitSpan)linkedList2.get(1)).getLink().blsrRingName())) {
            return false;
        }
        stringArray[2] = ((NetCircuitSpan)linkedList2.get(0)).getLink().blsrRingName();
        stringArray[3] = ((NetCircuitSpan)linkedList2.get(1)).getLink().blsrRingName();
        if (!(stringArray[0].equals(stringArray[2]) && stringArray[1].equals(stringArray[3]) || stringArray[0].equals(stringArray[3]) && stringArray[1].equals(stringArray[2]))) {
            return false;
        }
        if (this.dbgOn()) {
            db.println("areSpansBlsrProtected: true");
        }
        return true;
    }

    protected boolean validateConn() {
        if (this.circuit.getCircuitDir() == 1) {
            return this.validateBiDirectionalConn();
        }
        return this.validateUniDirectionalConn();
    }

    protected boolean validateBiDirectionalConn() {
        MemberPrefs memberPrefs;
        if (this.dbgOn()) {
            db.println("validateBiDirectionalConn() at " + this.getName());
        }
        int n = this.countNumInputs();
        int n2 = this.countNumOutputs();
        int n3 = this.countNumOmniSpans();
        int n4 = n + n2 + n3;
        boolean bl = false;
        if (this.dbgOn()) {
            db.println("validateBiDirConn: " + this.getName() + " numIn=" + n + " numOut=" + n2 + " numOmni=" + n3);
            db.println("                   sources=" + this.sources.size() + " drops=" + this.drops.size());
        }
        if ((memberPrefs = this.circuit.getMemberPrefs()) != null && memberPrefs.getDriNodePrefs().size() != 0 && memberPrefs.isBlsrDriNode(this.ne)) {
            int n5 = this.findBiDirectionalConnType();
            if (this.dbgOn()) {
                db.println("validateBiDirConn: connType: " + EnumStrings.getString((Class)IConnectionType.class, (int)n5));
            }
            switch (n5) {
                case 2: 
                case 13: 
                case 14: {
                    return true;
                }
            }
        }
        if (n3 > 0 && n < 3) {
            bl = this.validateOmniSpanProtection();
            if (n == 1 && n2 == 1) {
                if (this.sources.size() == 0 && this.drops.size() == 0) {
                    return this.validateOrigSpanProtection() && this.validateTermSpanProtection() && bl;
                }
                if (this.sources.size() == n && this.drops.size() == 0) {
                    return this.validateOrigSpanProtection() && bl;
                }
                if (this.sources.size() == 0 && this.drops.size() == n2) {
                    return this.validateTermSpanProtection() && bl;
                }
            } else if (n3 == 2 && n == 0 && n2 == 0) {
                return bl;
            }
            if (this.dbgOn()) {
                db.println("Cannot find a valid combo for omni spans " + n3);
            }
            return false;
        }
        if (n4 == 2) {
            return n == 1 && n2 == 1;
        }
        if (n4 == 3) {
            if (this.sources.size() > 0) {
                LinkedList linkedList = this.getTermSpans();
                if (this.sources.size() + linkedList.size() == n) {
                    if (this.sources.size() == 1 && linkedList.size() == 0) {
                        return this.validateOrigSpanProtection();
                    }
                    if (this.sources.size() == 1 && linkedList.size() == 1) {
                        return this.validateCircuitEndsUnProt(this.sources) && this.validateTermSpanProtection();
                    }
                    return this.validateCircuitEndsUnProt(this.sources);
                }
                return this.drops.size() > 0 && this.sources.size() == 1 && this.drops.size() == 1 && n == 2;
            }
            if (this.drops.size() > 0) {
                LinkedList linkedList = this.getOrigSpans();
                if (this.drops.size() + linkedList.size() == n2) {
                    if (this.drops.size() == 1 && linkedList.size() == 0) {
                        return this.validateTermSpanProtection();
                    }
                    if (this.drops.size() == 1 && linkedList.size() == 1) {
                        return this.validateCircuitEndsUnProt(this.drops) && this.validateOrigSpanProtection();
                    }
                    return this.validateCircuitEndsUnProt(this.drops);
                }
                return false;
            }
            if (n == 2) {
                return this.validateTermSpanProtection();
            }
            if (n == 1) {
                return this.validateOrigSpanProtection();
            }
            return false;
        }
        if (n4 == 4) {
            if (n == 2 && n2 == 2) {
                return this.validateCircuitEndsUnProt(this.sources) && this.validateCircuitEndsUnProt(this.drops) && this.validateTermSpanProtection() && this.validateOrigSpanProtection();
            }
            return false;
        }
        return false;
    }

    protected boolean validateUniDirectionalConn() {
        MemberPrefs memberPrefs;
        if (this.getState() == 2) {
            return true;
        }
        if (this.dbgOn()) {
            db.println("validateUniDirectionalConn() at " + this.getName());
        }
        int n = this.countNumInputs();
        int n2 = this.countNumOutputs();
        int n3 = this.countNumOmniSpans();
        if (this.dbgOn()) {
            db.println("validateUniDirConn: " + this.getName() + " numIn=" + n + " numOut=" + n2 + " numOmni=" + n3);
            db.println("                   sources=" + this.sources.size() + " drops=" + this.drops.size());
        }
        if ((memberPrefs = this.circuit.getMemberPrefs()) != null && memberPrefs.getDriNodePrefs().size() != 0 && memberPrefs.isBlsrDriNode(this.ne)) {
            int n4 = this.findUniDirectionalConnType();
            switch (n4) {
                case 0: 
                case 4: 
                case 6: 
                case 15: 
                case 16: {
                    return true;
                }
            }
        }
        if (this.getState() == 0) {
            if (n3 > 0 && n3 < 3) {
                if (this.sources.size() == 2 && !this.validateCircuitEndsUnProt(this.sources)) {
                    return false;
                }
                if (this.drops.size() == 2 && !this.validateCircuitEndsUnProt(this.drops)) {
                    return false;
                }
                if (n == 1) {
                    if (this.sources.size() == 0) {
                        if (this.drops.size() > 0 && n2 > this.drops.size()) {
                            return this.validateTermSpanProtection() && this.validateOmniSpanProtection() && this.validateOrigSpanProtection();
                        }
                        if (this.drops.size() == 0 && n2 > 0) {
                            return this.validateOrigSpanProtection() && this.validateTermSpanProtection() && this.validateOmniSpanProtection();
                        }
                        if (this.drops.size() > 0 && n2 == this.drops.size()) {
                            return this.validateTermSpanProtection() && this.validateOmniSpanProtection();
                        }
                    } else if (this.sources.size() == n && this.drops.size() == 0) {
                        return this.validateOmniSpanProtection() && this.validateOrigSpanProtection();
                    }
                } else if (n3 == 2 && n == 0) {
                    return this.validateOmniSpanProtection();
                }
                if (this.dbgOn()) {
                    db.println("Cannot find a valid combo for omni spans " + n3);
                }
                return false;
            }
            if (n3 >= 3) {
                return false;
            }
            if (this.sources.size() > 0) {
                if (this.circuit.getCktOperation() == 1 && (n2 < 1 || n2 > 2 || n > 2)) {
                    return false;
                }
                if (this.sources.size() == 2 && !this.validateCircuitEndsUnProt(this.sources)) {
                    return false;
                }
                if (this.drops.size() == 2 && !this.validateCircuitEndsUnProt(this.drops)) {
                    return false;
                }
                if (this.countNumOrigSpans() == 2) {
                    if (this.circuit.getCktOperation() == 1 && !this.validateOrigSpanProtection()) {
                        return false;
                    }
                    if (this.circuit.isMonitorCircuit()) {
                        return false;
                    }
                }
                return true;
            }
            if (this.drops.size() > 0) {
                if (this.countNumTermSpans() != 1 && this.countNumTermSpans() != 2) {
                    return false;
                }
                if (this.circuit.getCktOperation() == 1 && (this.countNumOrigSpans() != 0 || this.drops.size() > 2)) {
                    return false;
                }
                if (this.countNumTermSpans() == 2 && !this.validateTermSpanProtection()) {
                    return false;
                }
                if (this.isOpenEndedSelector()) {
                    return this.validateCircuitEndsUnProt(this.drops);
                }
                return true;
            }
            if (this.countNumTermSpans() != 1 && this.countNumTermSpans() != 2) {
                return false;
            }
            if (this.countNumOrigSpans() != 1 && this.countNumOrigSpans() != 2) {
                return false;
            }
            if (this.countNumTermSpans() == 2 && !this.validateTermSpanProtection()) {
                return false;
            }
            return this.countNumOrigSpans() != 2 || this.validateOrigSpanProtection();
        }
        if (this.getState() == 3) {
            if (!(this.countRoutedOrigSpans() == 0 && this.countRoutedDrops() == 1 || this.countRoutedOrigSpans() == 1 && this.countRoutedDrops() == 0 || this.countRoutedOrigSpans() == 2 && this.countRoutedDrops() == 0)) {
                return false;
            }
            return this.countRoutedOrigSpans() != 2 || this.validateRoutedOrigSpanProtection();
        }
        if (this.dbgOn()) {
            db.println("validateUniDirectionalConn() - Invalid node state");
        }
        return false;
    }

    protected boolean validateOmniSpanProtection() {
        boolean bl = true;
        Iterator iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (this.findRoutingDir(netCircuitSpan) != eSpanDirection.BIDIRECTIONAL || !netCircuitSpan.getNetLinkSpan().getOmni()) continue;
            bl = bl && netCircuitSpan.getLink().isFullyUnprotected();
        }
        return bl;
    }

    protected boolean validateOrigSpanProtection() {
        Iterator iterator = this.getOrigSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getBlsrDriInterConnect()) {
                if (netCircuitSpan.getLink().inBLSR()) continue;
                return false;
            }
            if (netCircuitSpan.getLink().getProtectionType() == 3) continue;
            if (this.isUpsrOver1Plus1Enabled()) {
                if (netCircuitSpan.getLink().getProtectionType() == 1) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected boolean validateTermSpanProtection() {
        Iterator iterator = this.getTermSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getBlsrDriInterConnect()) {
                if (netCircuitSpan.getLink().inBLSR()) continue;
                return false;
            }
            if (netCircuitSpan.getLink().getProtectionType() == 3) continue;
            if (this.isUpsrOver1Plus1Enabled()) {
                if (netCircuitSpan.getLink().getProtectionType() == 1) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean validateRoutedOrigSpanProtection() {
        Iterator iterator = this.getOrigSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (this.isUpsrOver1Plus1Enabled()) {
                if (netCircuitSpan.getSrcState() != 2 || netCircuitSpan.getLink().isFullyUnprotected() || netCircuitSpan.getLink().getProtectionType() == 1) continue;
                return false;
            }
            if (netCircuitSpan.getSrcState() != 2 || netCircuitSpan.getLink().isFullyUnprotected()) continue;
            if (this.dbgOn()) {
                db.println("validateRoutedOrigSpanProtection: false");
            }
            return false;
        }
        return true;
    }

    protected boolean validateCircuitEndsUnProt(LinkedList linkedList) {
        int n = linkedList.size();
        if (this.isUpsrOver1Plus1Enabled() && n > 0) {
            return this.validateUpsrOverOnePlusOne(linkedList);
        }
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return this.validateCircuitEndUnProt((NetCircuitEnd)linkedList.get(0));
        }
        if (n == 2) {
            return this.validateCircuitEndUnProt((NetCircuitEnd)linkedList.get(0)) && this.validateCircuitEndUnProt((NetCircuitEnd)linkedList.get(1));
        }
        return false;
    }

    public boolean isUpsrOverOnePluOne() {
        if (this.isUpsrOver1Plus1Enabled()) {
            if (this.sources.size() > 1) {
                return this.validateUpsrOverOnePlusOne(this.sources);
            }
            if (this.drops.size() > 1) {
                return this.validateUpsrOverOnePlusOne(this.drops);
            }
        }
        return false;
    }

    protected boolean validateUpsrOverOnePlusOne(LinkedList linkedList) {
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)linkedList.getFirst();
        NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)linkedList.getLast();
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        int n = netCircuitEnd.getCircuitEnd().getPortNum();
        int n2 = netCircuitEnd2.getCircuitEnd().getPortNum();
        INodeModel iNodeModel = this.getNodeModel();
        if (this.dbgOn()) {
            db.println("Validating UpsrOverOnePlusOne");
        }
        if (iNodeModel != null) {
            try {
                iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(n);
                iEntityModel2 = iNodeModel.getEntityTable().getEntityModelByIndex(n2);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        } else {
            return false;
        }
        if (iEntityModel instanceof IPortModel && iEntityModel2 instanceof IPortModel) {
            IPortModel iPortModel = (IPortModel)iEntityModel;
            IPortModel iPortModel2 = (IPortModel)iEntityModel2;
            if (iPortModel instanceof ITdmPortModel && iPortModel2 instanceof ITdmPortModel) {
                try {
                    ITdmPortModel iTdmPortModel = (ITdmPortModel)iPortModel;
                    ITdmPortModel iTdmPortModel2 = (ITdmPortModel)iPortModel2;
                    IElementModel iElementModel = iTdmPortModel.getElementModel();
                    IElementModel iElementModel2 = iTdmPortModel2.getElementModel();
                    if (iElementModel instanceof IOnePlusOneModel) {
                        if (iElementModel2 instanceof IOnePlusOneModel) {
                            if (iElementModel.equals(iElementModel2)) {
                                if (this.dbgOn()) {
                                    db.println(" AllowingUpsrOverOnePlusOne: Path1&2 on Same 1+1 ");
                                }
                                return true;
                            }
                            if (this.dbgOn()) {
                                db.println(" DisAllowingUpsrOverOnePlusOne: Path1&2 on different 1+1s");
                            }
                            return false;
                        }
                        if (this.dbgOn()) {
                            db.println(" DisAllowingUpsrOverOnePlusOne: Path1 on 1+1, Path2 is Not");
                        }
                        return false;
                    }
                    if (iElementModel2 instanceof IOnePlusOneModel) {
                        if (this.dbgOn()) {
                            db.println(" DisAllowingUpsrOverOnePlusOne: Path2 on 1+1, Path1 is Not");
                        }
                        return false;
                    }
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    if (this.dbgOn()) {
                        db.println("validateCktEnd: caught Exception => ");
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                    }
                    return false;
                }
            }
            if (iPortModel.isOptical() && iPortModel2.isOptical()) {
                if (this.dbgOn()) {
                    db.println("UpsrOverOnePlusOne: Both paths are optical ");
                }
                return !iPortModel.hasOpticalProtection() && !iPortModel2.hasOpticalProtection();
            }
            if (!iPortModel.isOptical() && !iPortModel2.isOptical()) {
                if (this.dbgOn()) {
                    db.println("UpsrOverOnePlusOne: Both paths are NON-optical (electrical) ");
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean validateCircuitEndUnProt(NetCircuitEnd netCircuitEnd) {
        IEntityModel iEntityModel = null;
        int n = netCircuitEnd.getCircuitEnd().getPortNum();
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel != null) {
            try {
                iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(n);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        } else {
            return false;
        }
        if (iEntityModel instanceof IPortModel) {
            IPortModel iPortModel = (IPortModel)iEntityModel;
            return iPortModel.isOptical() && !iPortModel.hasOpticalProtection();
        }
        return false;
    }

    protected boolean validateBLSRTimeSlots() throws SanityCheckFailed {
        String string;
        INetLink iNetLink;
        Object object;
        TreeMap treeMap = new TreeMap();
        Iterator<Object> iterator = this.sources.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                object = (NetCircuitEnd)iterator.next();
                iNetLink = this.circuit.getNetwork().findNetLinkFromSource(false, ((NetCircuitEnd)object).getNetElement(), ((NetCircuitEnd)object).getEntityIndex(), ((NetCircuitEnd)object).getHoNum());
                if (iNetLink == null || !(iNetLink instanceof NetLink) || !iNetLink.inBLSR()) continue;
                string = iNetLink.blsrRingName();
                if (!treeMap.containsKey(string)) {
                    treeMap.put(string, new ArrayList());
                }
                ((ArrayList)treeMap.get(string)).add(iNetLink);
            }
            iterator = this.drops.iterator();
        }
        iterator = this.getAllSpans().keySet().iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitSpan)iterator.next();
            iNetLink = ((NetCircuitSpan)object).getLink();
            if (!(iNetLink instanceof NetLink) || !iNetLink.inBLSR()) continue;
            string = iNetLink.blsrRingName();
            if (!treeMap.containsKey(string)) {
                treeMap.put(string, new ArrayList());
            }
            ((ArrayList)treeMap.get(string)).add(iNetLink);
        }
        iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            if (this.validateBLSRTimeSlots((List)iterator.next())) continue;
            return false;
        }
        return true;
    }

    protected boolean validateBLSRTimeSlots(List list) throws SanityCheckFailed {
        Object object;
        INetLink iNetLink;
        Object object2;
        TreeMap<INetLink, Object> treeMap = new TreeMap<INetLink, Object>(new NetLinkComparator());
        TreeMap<INetLink, Object> treeMap2 = new TreeMap<INetLink, Object>(new NetLinkComparator());
        if (this.dbgOn()) {
            db.println("validateBLSRTimeSlots at node " + this.getName());
        }
        Iterator<Object> iterator = this.sources.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                object2 = (NetCircuitEnd)iterator.next();
                iNetLink = this.circuit.getNetwork().findNetLinkFromSource(false, ((NetCircuitEnd)object2).getNetElement(), ((NetCircuitEnd)object2).getEntityIndex(), ((NetCircuitEnd)object2).getHoNum(), ((NetCircuitEnd)object2).getLoNum());
                if (iNetLink == null || !(iNetLink instanceof NetLink) || !list.contains(iNetLink)) continue;
                if (!treeMap.containsKey(iNetLink)) {
                    treeMap.put(iNetLink, object2);
                    continue;
                }
                if (((NetCircuitEnd)object2).equals((NetCircuitEnd)treeMap.get(iNetLink))) continue;
                return false;
            }
            if (this.circuit.getCircuitNodes().size() == 1 && i == 0 && treeMap.values().isEmpty()) break;
            iterator = this.drops.iterator();
        }
        object2 = this.getOrigSpans();
        LinkedList linkedList = this.getTermSpans();
        iterator = this.getAllSpans().keySet().iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitSpan)iterator.next();
            iNetLink = ((NetCircuitSpan)object).getLink();
            if (!(iNetLink instanceof NetLink) || !list.contains(iNetLink)) continue;
            treeMap2.put(iNetLink, object);
        }
        object = new LinkedList();
        ((LinkedList)object).addAll(treeMap.keySet());
        ((LinkedList)object).addAll(treeMap2.keySet());
        Object[] objectArray = ((LinkedList)object).toArray();
        boolean bl = this.circuit.getCircuitTypeObj().isLoCircuitType();
        boolean[] blArray = new boolean[]{false, false};
        IHoNum iHoNum = null;
        IHoNum iHoNum2 = null;
        ILoNum iLoNum = null;
        ILoNum iLoNum2 = null;
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        for (int i = 0; i < ((LinkedList)object).size(); ++i) {
            Object object3;
            NetLink netLink = (NetLink)objectArray[i];
            if (treeMap.containsKey(netLink)) {
                object3 = (NetCircuitEnd)treeMap.get(netLink);
                iHoNum = ((NetCircuitEnd)object3).getHoNum();
                blArray[0] = true;
                if (bl) {
                    iLoNum = ((NetCircuitEnd)object3).getLoNum();
                }
            } else {
                object3 = (NetCircuitSpan)treeMap2.get(netLink);
                iHoNum = ((NetCircuitSpan)object3).getHoNum(this.getNetElement());
                if (bl) {
                    iLoNum = ((NetCircuitSpan)object3).getLoNum();
                }
            }
            for (int j = i + 1; j < ((LinkedList)object).size(); ++j) {
                boolean bl2;
                Object object4;
                NetLink netLink2 = (NetLink)objectArray[j];
                if (treeMap.containsKey(netLink2)) {
                    object4 = (NetCircuitEnd)treeMap.get(netLink2);
                    iHoNum2 = ((NetCircuitEnd)object4).getHoNum();
                    blArray[1] = true;
                    if (bl) {
                        iLoNum2 = ((NetCircuitEnd)object4).getLoNum();
                    }
                } else {
                    object4 = (NetCircuitSpan)treeMap2.get(netLink2);
                    iHoNum2 = ((NetCircuitSpan)object4).getHoNum(this.getNetElement());
                    if (bl) {
                        iLoNum2 = ((NetCircuitSpan)object4).getLoNum();
                    }
                }
                boolean bl3 = object2.contains(treeMap2.get(netLink)) || this.sources.contains(treeMap.get(netLink)) || object2.contains(treeMap2.get(netLink2)) || this.sources.contains(treeMap.get(netLink2));
                boolean bl4 = bl2 = linkedList.contains(treeMap2.get(netLink)) || this.drops.contains(treeMap.get(netLink)) || linkedList.contains(treeMap2.get(netLink2)) || this.drops.contains(treeMap.get(netLink2));
                if (!bl3 || !bl2) continue;
                if (this.circuit.hasBlsrDri() && netLink.inBLSR() && netLink2.inBLSR()) {
                    IHoNum[] iHoNumArray = new IHoNum[]{iHoNum, iHoNum2};
                    NetLink[] netLinkArray = new NetLink[]{netLink, netLink2};
                    iHoNumArray = this.sanityCheckBlsrDriTimeSlots(netLinkArray, iHoNumArray, treeMap2, blArray);
                    iHoNum = iHoNumArray[0];
                    iHoNum2 = iHoNumArray[1];
                } else {
                    if (netLink.isPca() && !netLink2.isPca() || netLink.inWorkingBLSR() && !netLink2.inWorkingBLSR()) {
                        return false;
                    }
                    if (netLink.isPca(this.getNetElement()) || netLink2.isPca(this.getNetElement())) continue;
                }
                if (this.sources.size() != 0) continue;
                if (!hoLoComparator.isEqual(iHoNum, iHoNum2)) {
                    if (this.dbgOn()) {
                        db.println("validateBLSRTimeSlots: HoNum1: " + iHoNum.prettyString() + " HoNum2: " + iHoNum2.prettyString());
                    }
                    return false;
                }
                if (!bl || hoLoComparator.isEqual(iLoNum, iLoNum2)) continue;
                return false;
            }
        }
        return true;
    }

    protected IHoNum[] sanityCheckBlsrDriTimeSlots(NetLink[] netLinkArray, IHoNum[] iHoNumArray, TreeMap treeMap, boolean[] blArray) throws SanityCheckFailed {
        int n;
        boolean[] blArray2 = new boolean[]{false, false, false};
        boolean[] blArray3 = new boolean[]{false, false, false};
        NetLink netLink = netLinkArray[0];
        NetLink netLink2 = netLinkArray[1];
        if (this.dbgOn()) {
            db.println("sanityCheckBlsrDriTimeSlots: node " + this.getName());
            db.println("sanityCheckBlsrDriTimeSlots: link1 " + netLink.prettyString());
            db.println("sanityCheckBlsrDriTimeSlots: link2 " + netLink2.prettyString());
        }
        if (blArray[0] && netLink.isPca(this.getNetElement()) || blArray[1] && netLink2.isPca(this.getNetElement())) {
            throw new SanityCheckFailed("cannot have endPoint on PCA");
        }
        if ((this.driNodeType == 1 || this.driNodeType == 2 || this.driNodeType == 3) && (blArray[0] || blArray[1])) {
            throw new SanityCheckFailed("cannot have end point on BLSR link of DRI handoff node");
        }
        boolean bl = this.circuit.getCircuitTypeObj().isLoCircuitType();
        if (!blArray[0] && !blArray[1]) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)treeMap.get(netLink);
            if (netLink.isPca(this.getNetElement())) {
                blArray2[2] = true;
            }
            if (netCircuitSpan.getBlsrDriInterConnect()) {
                blArray2[1] = true;
            }
            if (netCircuitSpan.isSecondaryCircuit()) {
                blArray2[0] = true;
            }
            netCircuitSpan = (NetCircuitSpan)treeMap.get(netLink2);
            if (netLink2.isPca(this.getNetElement())) {
                blArray3[2] = true;
            }
            if (netCircuitSpan.getBlsrDriInterConnect()) {
                blArray3[1] = true;
            }
            if (netCircuitSpan.isSecondaryCircuit()) {
                blArray3[0] = true;
            }
            if (this.dbgOn()) {
                boolean[][] blArrayArray = new boolean[][]{blArray2, blArray3};
                for (int i = 0; i < blArrayArray.length; ++i) {
                    db.print("link" + (i + 1) + " flags ");
                    for (int j = 0; j < blArrayArray[i].length; ++j) {
                        db.print(blArrayArray[i][j] + " ");
                    }
                    db.println("");
                }
            }
            int n2 = n = blArray2[0] && blArray2[1] && !blArray2[2] && blArray3[0] && blArray3[1] && !blArray3[2] || blArray2[0] && blArray2[1] && blArray2[2] && blArray3[0] && blArray3[1] && blArray3[2] || !blArray2[0] && !blArray2[1] && !blArray2[2] && blArray3[0] && blArray3[1] || blArray2[0] && blArray2[1] && !blArray3[0] && !blArray3[1] && !blArray3[2] || !blArray2[0] && !blArray2[2] && !blArray3[0] && !blArray3[2] ? 1 : 0;
            if (n == 0) {
                throw new SanityCheckFailed("violation of BLSR DRI timeslot rules");
            }
        }
        if (blArray2[2] && !blArray3[2] || !blArray2[2] && blArray3[2]) {
            if (netLink.getProtectionType() == 4 || netLink.getProtectionType() == 6) {
                return iHoNumArray;
            }
            if (netLink.getProtectionType() == 0) {
                if (this.dbgOn()) {
                    db.print("changing hoNum1 from " + iHoNumArray[0]);
                }
                int n3 = netLink.getSrc().getNodeModel().getFramingType();
                n = netLink.getPhysicalSize() / 2 + 1;
                IHoNum iHoNum = HoLoFactory.idlSts2HoNum(n3, n);
                IHoNum iHoNum2 = HoLoFactory.addOffset(iHoNum, -1);
                iHoNumArray[0] = HoLoFactory.addHoNums(iHoNumArray[0], iHoNum2);
                if (this.dbgOn()) {
                    db.print(" to " + iHoNumArray[0]);
                    db.println("");
                }
                return iHoNumArray;
            }
            if (netLink.getProtectionType() == 5) {
                if (this.dbgOn()) {
                    db.print("changing hoNum2 from " + iHoNumArray[1]);
                }
                int n4 = netLink.getSrc().getNodeModel().getFramingType();
                n = netLink.getPhysicalSize() / 2 + 1;
                IHoNum iHoNum = HoLoFactory.idlSts2HoNum(n4, n);
                IHoNum iHoNum3 = HoLoFactory.addOffset(iHoNum, -1);
                iHoNumArray[1] = HoLoFactory.addHoNums(iHoNumArray[1], iHoNum3);
                if (this.dbgOn()) {
                    db.print(" to " + iHoNumArray[1]);
                    db.println("");
                }
                return iHoNumArray;
            }
        }
        return iHoNumArray;
    }

    protected void deleteConnectionObserver() {
        if (this.getConn() != null) {
            if (this.dbgOn()) {
                db.println("deleteConnectionObserver at " + this.getNameAndClass());
            }
            try {
                ModelIndirectObservable.instance().deleteObserver((IObservable)this.getConn(), this);
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                // empty catch block
            }
            this.updateEvent.init();
        }
    }

    protected void addConnectionObserver() {
        if (this.getConn() != null) {
            if (this.dbgOn()) {
                db.println("addConnectionObserver at " + this.getNameAndClass());
            }
            this.updateEvent.init();
            ModelIndirectObservable.instance().addObserver((IObservable)this.getConn(), this);
        }
    }

    protected void modifyConnectionType() throws CircuitProvError {
        int n = this.circuit.getCktOperation() == 5 ? this.calculateConnectionType(db) : this.findUpgradedConnType();
        if (n != this.getConnectionType()) {
            if (this.dbgOn()) {
                db.println("modifyConnectionType: Node " + this.getName() + ". New conn type = " + EnumStrings.getString((Class)IConnectionType.class, (int)n) + ". Old conn type = " + EnumStrings.getString((Class)IConnectionType.class, (int)this.getConnectionType()));
            }
            try {
                this.setConnTypeInConnModel(n);
            }
            catch (CTCUserException cTCUserException) {
                if (this.dbgOn()) {
                    db.println("modifyConnectionType: unable to change intended type");
                }
                throw new CircuitProvError("Unable to modify connection at " + this.getName());
            }
            if (n == 6 && this.getConnectionType() == 1) {
                this.cleanupUpsrEntities();
            }
            this.setConnectionType(n);
        }
    }

    protected void modifyConnectionDropsAndSpans() throws CircuitProvError {
        NetCircuitSpan netCircuitSpan;
        Iterator iterator = this.drops.iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.getStage() != 2) continue;
            if (this.dbgOn()) {
                db.println("Adding routed drop to connection");
            }
            try {
                this.addOutputToConnModel(netCircuitEnd);
                this.addConnectionPathEnd(netCircuitEnd);
            }
            catch (CTCUserException cTCUserException) {
                this.cleanupLoAdits();
                if (this.dbgOn()) {
                    db.println("failed to add output");
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
                String string = "Unable to add output to connection at " + this.getName();
                if (cTCUserException instanceof NoMoreLoCapableHo) {
                    string = string + "\n" + this.getNoLoCapableHoMessage() + " at " + this.getName();
                } else if (cTCUserException instanceof PathInUse) {
                    string = string + "\nPath already in use";
                } else if (cTCUserException instanceof DropsExceedMax) {
                    string = string + "\nMaximum number of multicast drops is reached.\nNo more new drops can be created.";
                }
                throw new CircuitProvError(string);
            }
            netCircuitEnd.setStage(3);
        }
        iterator = this.outSpans.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getSrcState() != 2) continue;
            if (this.dbgOn()) {
                db.println("Adding routed span to connection");
            }
            try {
                this.addOutputToConnModel(netCircuitSpan);
                this.addConnectionPathEnd(netCircuitSpan);
            }
            catch (CTCUserException cTCUserException) {
                this.cleanupLoAdits();
                if (this.dbgOn()) {
                    db.println("failed to add output");
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
                String string = "Unable to add output to connection at " + this.getName();
                if (cTCUserException instanceof NoMoreLoCapableHo) {
                    string = string + "\n" + this.getNoLoCapableHoMessage() + " at " + this.getName();
                } else if (cTCUserException instanceof PathInUse) {
                    string = string + "\nPath already in use";
                }
                throw new CircuitProvError(string);
            }
            netCircuitSpan.setSrcState(3);
        }
        if (this.getConnectionType() == 8) {
            iterator = this.biSpans.iterator();
            while (iterator.hasNext()) {
                netCircuitSpan = (NetCircuitSpan)iterator.next();
                if (this.findRoutingDir(netCircuitSpan) == eSpanDirection.TERMINATING && netCircuitSpan.getDstState() != 2 || this.findRoutingDir(netCircuitSpan) == eSpanDirection.ORIGINATING && netCircuitSpan.getSrcState() != 2) continue;
                try {
                    this.addOutputToConnModel(netCircuitSpan);
                    this.addConnectionPathEnd(netCircuitSpan);
                }
                catch (CTCUserException cTCUserException) {
                    if (this.dbgOn()) {
                        db.println("failed to add output");
                        SDebug.printStackTrace((Throwable)cTCUserException);
                    }
                    String string = "Unable to add output to connection at " + this.getName();
                    if (cTCUserException instanceof PathInUse) {
                        string = string + "\nPath already in use";
                    }
                    throw new CircuitProvError(string);
                }
            }
        }
    }

    protected abstract void modifyConnection() throws CircuitProvError;

    protected void destroyConnection() throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup, DeletionError {
        this.destroyCrossConnection();
    }

    protected abstract void destroyCrossConnection() throws Busy, ConnectionInTestAccess, ConnectionInRoll, ConnectionInTopologyUpgrade, VcatMemberNotOutOfGroup;

    protected void cleanupLoAdits() {
    }

    protected void cleanupLoAditsIfOldNe() {
    }

    protected int getTunnelEntityIndex() throws SanityCheckFailed {
        return -1;
    }

    protected boolean hasAggregation() {
        return false;
    }

    public IHoNum getLotHo() throws SanityCheckFailed {
        return null;
    }

    protected List getOrderedPathDefs(int n, boolean bl, SDebug sDebug) throws CTCUserException {
        Object object;
        block19: {
            ArrayList<Object> arrayList;
            ArrayList<Object> arrayList2;
            block21: {
                block23: {
                    block22: {
                        block20: {
                            block18: {
                                int n2 = this.countNumInputs();
                                int n3 = this.countNumOutputs();
                                int n4 = this.countNumOmniSpans();
                                arrayList2 = new ArrayList<Object>();
                                arrayList = new ArrayList<Object>();
                                Iterator iterator = this.sources.iterator();
                                while (iterator.hasNext()) {
                                    object = (NetCircuitEnd)iterator.next();
                                    arrayList2.add(((NetCircuitEnd)object).getPathDef(this.pathWidth));
                                }
                                iterator = this.drops.iterator();
                                while (iterator.hasNext()) {
                                    object = (NetCircuitEnd)iterator.next();
                                    arrayList.add(((NetCircuitEnd)object).getPathDef(this.pathWidth));
                                }
                                iterator = this.biSpans.iterator();
                                while (iterator.hasNext()) {
                                    object = (NetCircuitSpan)iterator.next();
                                    if (this.findRoutingDir((NetCircuitSpan)object) == eSpanDirection.ORIGINATING) {
                                        arrayList.add(((NetCircuitSpan)object).getPathDef(this.getNetElement(), this.pathWidth));
                                        continue;
                                    }
                                    if (this.findRoutingDir((NetCircuitSpan)object) != eSpanDirection.TERMINATING) continue;
                                    arrayList2.add(((NetCircuitSpan)object).getPathDef(this.getNetElement(), this.pathWidth));
                                }
                                iterator = this.inSpans.iterator();
                                while (iterator.hasNext()) {
                                    object = (NetCircuitSpan)iterator.next();
                                    arrayList2.add(((NetCircuitSpan)object).getPathDef(this.getNetElement(), this.pathWidth));
                                }
                                iterator = this.outSpans.iterator();
                                while (iterator.hasNext()) {
                                    object = (NetCircuitSpan)iterator.next();
                                    arrayList.add(((NetCircuitSpan)object).getPathDef(this.getNetElement(), this.pathWidth));
                                }
                                if (sDebug.on()) {
                                    sDebug.println("getOrderedPathDefs: in => " + arrayList2.size() + ", out => " + arrayList.size() + ", connType => " + EnumStrings.getString((Class)IConnectionType.class, (int)n) + ", goReturn => " + bl);
                                }
                                object = new LinkedList();
                                if (n != 0) break block18;
                                ((LinkedList)object).add(arrayList2.get(0));
                                for (int i = 0; i < arrayList.size(); ++i) {
                                    ((LinkedList)object).add(arrayList.get(i));
                                }
                                break block19;
                            }
                            if (n != 1) break block20;
                            ((LinkedList)object).add(arrayList2.get(0));
                            ((LinkedList)object).add(arrayList.get(0));
                            break block19;
                        }
                        if (n != 2) break block21;
                        if (arrayList2.size() != 2) break block22;
                        if (bl) {
                            ((LinkedList)object).add(arrayList2.get(0));
                            ((LinkedList)object).add(arrayList2.get(1));
                            ((LinkedList)object).add(arrayList.get(0));
                        } else {
                            ((LinkedList)object).add(arrayList2.get(1));
                            ((LinkedList)object).add(arrayList2.get(0));
                            ((LinkedList)object).add(arrayList.get(0));
                        }
                        break block19;
                    }
                    if (arrayList.size() != 2) break block23;
                    ((LinkedList)object).add(arrayList.get(0));
                    ((LinkedList)object).add(arrayList.get(1));
                    ((LinkedList)object).add(arrayList2.get(0));
                    break block19;
                }
                if (!sDebug.on()) break block19;
                sDebug.println("getOrderedPathDefs: WARNING - bad  UPSR case");
                break block19;
            }
            if (n == 3) {
                if (bl || this.equals(this.circuit.getSrcCircuitNode())) {
                    ((LinkedList)object).add(arrayList2.get(0));
                    ((LinkedList)object).add(arrayList2.get(1));
                    ((LinkedList)object).add(arrayList.get(0));
                    ((LinkedList)object).add(arrayList.get(1));
                } else {
                    ((LinkedList)object).add(arrayList2.get(1));
                    ((LinkedList)object).add(arrayList2.get(0));
                    ((LinkedList)object).add(arrayList.get(0));
                    ((LinkedList)object).add(arrayList.get(1));
                }
            } else if (n == 4) {
                ((LinkedList)object).add(arrayList.get(0));
                ((LinkedList)object).add(arrayList.get(1));
                ((LinkedList)object).add(arrayList2.get(0));
            } else if (n == 6) {
                ((LinkedList)object).add(arrayList2.get(0));
                ((LinkedList)object).add(arrayList2.get(1));
                for (int i = 0; i < arrayList.size(); ++i) {
                    ((LinkedList)object).add(arrayList.get(i));
                }
            }
        }
        return object;
    }

    protected abstract void createConnection() throws CircuitProvError;

    protected void createConnection(ICircuitId iCircuitId) throws CircuitProvError, InvalidPath, PathInUse, CTCUserException, InsufficientBandwidth, NoMoreLoCapableHo, ConnectionTypeError, ObjNotFound, InvalidState, AdminStateProvisioningError {
        int n = this.countNumInputs();
        int n2 = this.countNumOutputs();
        int n3 = this.countNumOmniSpans();
        PathDefsHolder pathDefsHolder = new PathDefsHolder();
        if (this.dbgOn()) {
            this.debug("createConnection(" + this.getName() + ") " + "inCount=" + n + " outCount=" + n2 + " omniCount " + n3 + " pathWidth " + this.pathWidth);
        }
        if (this.circuit.isBidirectional() && this.circuit.getCircuitNodes().size() == 1 && this.circuit.isDriMemberPref()) {
            NetCircuitEnd netCircuitEnd;
            if (this.dbgOn()) {
                db.println("Single node (I)DRI connection at " + this.getName());
            }
            if (this.sources.size() != 2) {
                if (this.dbgOn()) {
                    db.println("Need exactly two sources, got " + this.sources.size());
                }
                throw new CircuitProvError("Need exactly two sources, got " + this.sources.size());
            }
            NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)this.circuit.getPrimarySource();
            pathDefsHolder.inPathDefs.add(netCircuitEnd2.getPathDef(this.pathWidth));
            netCircuitEnd2 = (NetCircuitEnd)this.circuit.getSecondarySource();
            pathDefsHolder.omniPathDefs.add(netCircuitEnd2.getPathDef(this.pathWidth));
            pathDefsHolder.omniSpanPos.add(true);
            if (this.drops.size() > 2 || this.drops.size() < 1) {
                if (this.dbgOn()) {
                    db.println("Invalid number of drops, got " + this.drops.size());
                }
                throw new CircuitProvError("Invalid number of drops, got " + this.drops.size());
            }
            Iterator iterator = this.drops.iterator();
            if (iterator.hasNext()) {
                netCircuitEnd = (NetCircuitEnd)iterator.next();
                pathDefsHolder.outPathDefs.add(netCircuitEnd.getPathDef(this.pathWidth));
            }
            if (iterator.hasNext()) {
                netCircuitEnd = (NetCircuitEnd)iterator.next();
                pathDefsHolder.omniPathDefs.add(netCircuitEnd.getPathDef(this.pathWidth));
                pathDefsHolder.omniSpanPos.add(false);
                this.setConnectionType(11);
            } else {
                this.setConnectionType(10);
            }
        } else {
            Iterator iterator = this.sources.iterator();
            while (iterator.hasNext() && this.connType != 18) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                pathDefsHolder.inPathDefs.add(netCircuitEnd.getPathDef(this.pathWidth));
            }
            iterator = this.drops.iterator();
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                pathDefsHolder.outPathDefs.add(netCircuitEnd.getPathDef(this.pathWidth));
            }
        }
        this.fillInPathDefs(pathDefsHolder, this.circuit.getTrafficDir());
        int n4 = pathDefsHolder.inPathDefs.size();
        int n5 = pathDefsHolder.outPathDefs.size();
        int n6 = pathDefsHolder.omniPathDefs.size();
        if (n4 > 2 && this.dbgOn()) {
            db.println("Warning! createConnection: inputs > 2");
        }
        this.createConn(iCircuitId, pathDefsHolder.inPathDefs, pathDefsHolder.outPathDefs, pathDefsHolder.omniPathDefs, n4, n5, pathDefsHolder.inUpsrCost, pathDefsHolder.omniSpanPos);
    }

    private void fillInPathDefs(PathDefsHolder pathDefsHolder, boolean bl) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        Object object;
        Object object2;
        Iterator iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            object2 = (NetCircuitSpan)iterator.next();
            if (this.findRoutingDir((NetCircuitSpan)object2) == eSpanDirection.ORIGINATING) {
                if (this.isUpsrSelectorConn() && this.circuit.isBidirectional() && this.countOrigBiSpans() == 2 && !this.hasBlsrDriSelector() && !this.circuit.getCircuitTypeObj().isLAPCircuitType()) {
                    if (this.dbgOn()) {
                        db.println("start on selector node " + this.getName() + " which has 2 outgoing spans");
                    }
                    object = this.getUpsrPeerNode((NetCircuitSpan)object2);
                    NetCircuitSpan netCircuitSpan = this.getUpsrPeerSpan((NetCircuitSpan)object2);
                    if (object != null && netCircuitSpan != null) {
                        LinkedList<NetCircuitSpan> linkedList = new LinkedList<NetCircuitSpan>();
                        Iterator iterator2 = ((NetCircuitNode)object).getTermSpans().iterator();
                        while (iterator2.hasNext()) {
                            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator2.next();
                            linkedList.add(netCircuitSpan2);
                        }
                        if (this.dbgOn()) {
                            db.println("find the peer selector node " + ((NetCircuitNode)object).getName() + " which has " + linkedList.size() + " incoming in spans");
                        }
                        int n = linkedList.indexOf(netCircuitSpan);
                        pathDefsHolder.outPathDefs.ensureCapacity(2);
                        if (pathDefsHolder.outPathDefs.size() == 0) {
                            pathDefsHolder.outPathDefs.add(((NetCircuitSpan)object2).getPathDef(this.getNetElement(), this.pathWidth));
                            pathDefsHolder.outPathDefs.add(((NetCircuitSpan)object2).getPathDef(this.getNetElement(), this.pathWidth));
                        }
                        if (bl) {
                            if (n == 0) {
                                pathDefsHolder.outPathDefs.set(0, ((NetCircuitSpan)object2).getPathDef(this.getNetElement(), this.pathWidth));
                                continue;
                            }
                            if (n != 1) continue;
                            pathDefsHolder.outPathDefs.set(1, ((NetCircuitSpan)object2).getPathDef(this.getNetElement(), this.pathWidth));
                            continue;
                        }
                        if (n == 0) {
                            pathDefsHolder.outPathDefs.set(1, ((NetCircuitSpan)object2).getPathDef(this.getNetElement(), this.pathWidth));
                            continue;
                        }
                        if (n != 1) continue;
                        pathDefsHolder.outPathDefs.set(0, ((NetCircuitSpan)object2).getPathDef(this.getNetElement(), this.pathWidth));
                        continue;
                    }
                    pathDefsHolder.outPathDefs.add(((NetCircuitSpan)object2).getPathDef(this.getNetElement(), this.pathWidth));
                    pathDefsHolder.outUpsrCost.add(new Integer(this.biSpanUpsrCost((NetCircuitSpan)object2)));
                    continue;
                }
                pathDefsHolder.outPathDefs.add(((NetCircuitSpan)object2).getPathDef(this.getNetElement(), this.pathWidth));
                pathDefsHolder.outUpsrCost.add(new Integer(this.biSpanUpsrCost((NetCircuitSpan)object2)));
                continue;
            }
            if (this.findRoutingDir((NetCircuitSpan)object2) == eSpanDirection.TERMINATING) {
                pathDefsHolder.inPathDefs.add(((NetCircuitSpan)object2).getPathDef(this.getNetElement(), this.pathWidth));
                pathDefsHolder.inUpsrCost.add(new Integer(this.biSpanUpsrCost((NetCircuitSpan)object2)));
                continue;
            }
            if (this.findRoutingDir((NetCircuitSpan)object2) == eSpanDirection.BIDIRECTIONAL) {
                pathDefsHolder.omniPathDefs.add(((NetCircuitSpan)object2).getPathDef(this.getNetElement(), this.pathWidth));
                pathDefsHolder.omniSpanPos.add(((NetCircuitSpan)object2).getNetLinkSpan().getSourceRing());
                continue;
            }
            if (!this.dbgOn()) continue;
            db.println("Unknown routing dir on " + this.getName() + " for " + ((NetCircuitSpan)object2).prettyString());
        }
        iterator = this.inSpans.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            pathDefsHolder.inPathDefs.add(netCircuitSpan.getPathDef(this.getNetElement(), this.pathWidth));
        }
        iterator = this.outSpans.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (this.getCircuit().getCircuitTypeObj().isOchncType() && !this.drops.isEmpty()) {
                pathDefsHolder.outPathDefs.add(0, netCircuitSpan.getPathDef(this.getNetElement(), this.pathWidth));
                continue;
            }
            pathDefsHolder.outPathDefs.add(netCircuitSpan.getPathDef(this.getNetElement(), this.pathWidth));
        }
        object2 = this.circuit.getXmCircuitEnds();
        if (!object2.isEmpty() && this.getNodeModel().getNodeId() == ((INetCircuitEnd)object2.get(0)).getNodeId()) {
            if (this.dbgOn()) {
                db.println("createConnection looking at ds3xm");
            }
            if ((object2.get(0) == null || object2.get(1) == null) && this.dbgOn()) {
                db.println("ds3xmCktEnds are null");
            }
            if (this.isIngressOnXm()) {
                if (this.dbgOn()) {
                    db.println("adding to outPathDefs");
                }
                if ((object = ((NetCircuitEnd)object2.get(0)).getPathDef(this.pathWidth)) == null && this.dbgOn()) {
                    db.println("pathDef is null");
                }
                pathDefsHolder.outPathDefs.add(((NetCircuitEnd)object2.get(0)).getPathDef(this.pathWidth));
            } else {
                if (this.dbgOn()) {
                    db.println("adding to inPathDefs");
                }
                pathDefsHolder.inPathDefs.add(((NetCircuitEnd)object2.get(1)).getPathDef(this.pathWidth));
            }
        }
        if (this.isSrcCoLocatedCktNode()) {
            if (this.dbgOn()) {
                db.println("createConnection: looking at OchTrail co-located conns");
            }
            if ((object = this.getSrcCoLocatedCktEnds()).size() == 2) {
                if (object.get(0) != null && object.get(1) != null) {
                    if (this.dbgOn()) {
                        db.println("adding to outPathDefs/inPathDefs two paths (Ochnc Conn src)");
                    }
                    pathDefsHolder.inPathDefs.add(0, ((NetCircuitEnd)object.get(0)).getPathDef(this.pathWidth));
                    pathDefsHolder.outPathDefs.add(((NetCircuitEnd)object.get(1)).getPathDef(this.pathWidth));
                }
            } else if (this.dbgOn()) {
                db.println("WARNING: wrong number of internal cktends");
            }
        } else if (this.isDstCoLocatedCktNode()) {
            object = this.getDstCoLocatedCktEnds();
            if (object.size() == 2) {
                if (object.get(0) != null && object.get(1) != null) {
                    if (this.dbgOn()) {
                        db.println("adding to inPathDefs/outPathDefs two paths (Ochnc Conn dst)");
                    }
                    pathDefsHolder.inPathDefs.add(0, ((NetCircuitEnd)object.get(0)).getPathDef(this.pathWidth));
                    pathDefsHolder.outPathDefs.add(((NetCircuitEnd)object.get(1)).getPathDef(this.pathWidth));
                }
            } else if (this.dbgOn()) {
                db.println("WARNING: wrong number of internal cktends");
            }
        }
    }

    protected void arrangePathDefsForBlsrDri(IPathDefModel[] iPathDefModelArray) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        int n = this.getConnectionType();
        switch (n) {
            case 2: 
            case 6: {
                NetCircuitSpan netCircuitSpan;
                if (iPathDefModelArray.length != 2 || (netCircuitSpan = this.getSpanFromPathDef(iPathDefModelArray[0])) == null || !netCircuitSpan.isSecondaryCircuit()) break;
                IPathDefModel iPathDefModel = iPathDefModelArray[0];
                iPathDefModelArray[0] = iPathDefModelArray[1];
                iPathDefModelArray[1] = iPathDefModel;
                break;
            }
        }
    }

    protected void createConn(ICircuitId iCircuitId, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, int n2, ArrayList arrayList4, ArrayList arrayList5) throws CircuitProvError, ConnectionTypeError, ObjNotFound, InvalidState, InvalidPath, PathInUse, CTCUserException, NoMoreLoCapableHo, InsufficientBandwidth, AdminStateProvisioningError {
    }

    protected void prettyPrintConnectionList(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        if (!((Object)((Object)db)).equals((Object)sDebug) && !NetCircuitManager.pkgDbgSuppressed()) {
            sDebug.println("      node: " + this.getName());
            sDebug.println("connection: " + EnumStrings.getString((Class)IConnectionType.class, (int)this.connType));
        }
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof BridgeConnection) {
                sDebug.println(" primitive: BridgeConnection");
            } else if (e instanceof SelectorConnection) {
                sDebug.println(" primitive: SelectorConnection");
            } else if (e instanceof OnewayConnection) {
                sDebug.println(" primitive: OnewayConnection");
            }
            ((Connection)e).prettyString(sDebug);
        }
    }

    protected IConnectionConversionModel createConnConvModel(int n, InServiceUpgradeState inServiceUpgradeState, ICircuitId iCircuitId, List list, int n2, int n3, List list2, List list3, IConnCreateAttrs iConnCreateAttrs, boolean bl, boolean bl2) throws Busy, PathListIncomplete, ConnectionInRoll, ConnectionInTopologyUpgrade, ConnectionInTestAccess, ConnectionInLoopback, TopologyUpgradeNotAllowed, CTCUserException {
        if (this.dbgOn()) {
            db.println("createConnConvModel: old conn type => " + EnumStrings.getString((Class)IConnectionType.class, (int)n2) + ", new conn type => " + EnumStrings.getString((Class)IConnectionType.class, (int)n3) + " for node " + this.getName());
        }
        try {
            IConnectionConversionModel iConnectionConversionModel = this.getConn().createConnectionConversionModel(list3, n, iCircuitId, list, n3, iConnCreateAttrs, inServiceUpgradeState.value(), bl, bl2);
            this.setInConnectionConversion(true);
            this.currConversionStatus = true;
            return iConnectionConversionModel;
        }
        catch (Busy busy) {
            throw busy;
        }
        catch (PathListIncomplete pathListIncomplete) {
            throw pathListIncomplete;
        }
        catch (ConnectionInRoll connectionInRoll) {
            throw new CTCUserException("Circuits in Bridge and Roll cannot be upgraded to UPSR/SNCP");
        }
        catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
            throw new CTCUserException("Circuit already in Topology Upgrade cannot be upgraded to UPSR/SNCP");
        }
        catch (ConnectionInTestAccess connectionInTestAccess) {
            throw new CTCUserException("Circuit in Test Access cannot be upgraded to UPSR/SNCP");
        }
        catch (ConnectionInLoopback connectionInLoopback) {
            throw new CTCUserException("Circuit in Loopback cannot be upgraded to UPSR/SNCP");
        }
        catch (TopologyUpgradeNotAllowed topologyUpgradeNotAllowed) {
            throw topologyUpgradeNotAllowed;
        }
        catch (CTCUserException cTCUserException) {
            throw cTCUserException;
        }
    }

    protected IConnectionConversionModel getConnConvModel() {
        return this.getConnectionConversionModel();
    }

    protected void prettyPrint(SDebug sDebug) {
        NetCircuitSpan netCircuitSpan;
        NetCircuitEnd netCircuitEnd;
        if (!sDebug.on()) {
            return;
        }
        sDebug.println(" NODE " + this.getName() + " (" + this.getClass().getName() + ")");
        sDebug.print("   State=" + EnumStrings.getString((Class)INetCircuitProvState.class, (int)this.state));
        sDebug.print(" | CktId=" + NetCircuit.prettyString(this.cktId));
        sDebug.println(" | ConnType=" + (this.connType == 20 ? "Unknown" : EnumStrings.getString((Class)IConnectionType.class, (int)this.connType)));
        sDebug.print("    dri = " + (this.dri ? " true " : " false "));
        sDebug.print("    nodeType = " + EnumStrings.getString((Class)IDriNodeType.class, (int)this.driNodeType));
        sDebug.println("    inRoll = " + this.currRollStatus);
        sDebug.print("   ConnName=\"" + this.connName + "\"");
        sDebug.print(" | AdminState= " + this.translateAdminState(this.adminState));
        sDebug.print(" | ServiceState= " + this.translateServiceState(this.serviceState));
        sDebug.print(" | UpdateEventState: DELETE=" + this.updateEvent.deleted + "; CHANGED=" + this.updateEvent.changed);
        sDebug.println(this.inConnectionConversion() ? " | inConnectionConversion" : "");
        sDebug.print("   Src " + this.sources.size());
        sDebug.print(" | Drp " + this.drops.size());
        if (this.nodeDrop != null) {
            sDebug.print(" (Node Drop)");
        }
        sDebug.print(" | Term " + this.inSpans.size());
        sDebug.print(" | Orig " + this.outSpans.size());
        sDebug.print(" | Bi " + this.biSpans.size());
        sDebug.print(" | Path " + this.numberOfPaths);
        sDebug.print(" | Spl " + this.spliceListeners.size());
        sDebug.println(this.getUpsrOps() != null ? " | UPSR" : "");
        Iterator iterator = this.sources.iterator();
        sDebug.println(" Sources: ");
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            sDebug.println("  " + netCircuitEnd.prettyString());
        }
        iterator = this.drops.iterator();
        sDebug.println(" Drops: ");
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            sDebug.println("  " + netCircuitEnd.prettyString());
        }
        if (this.nodeDrop != null) {
            sDebug.println(" NodeDrop: ");
            sDebug.println("  " + this.nodeDrop.prettyString());
        }
        List list = this.getWorkingSpans();
        List list2 = this.getProtectSpans();
        if (list.size() != 0) {
            sDebug.println(" WorkingSpan(s):");
            iterator = list.iterator();
            while (iterator.hasNext()) {
                netCircuitSpan = (NetCircuitSpan)iterator.next();
                sDebug.println("  " + netCircuitSpan.availSpan.prettyString());
                sDebug.println("  " + netCircuitSpan.prettyStringSpanState());
            }
        }
        if (list2.size() != 0) {
            sDebug.println(" ProtectSpan(s):");
            iterator = list2.iterator();
            while (iterator.hasNext()) {
                netCircuitSpan = (NetCircuitSpan)iterator.next();
                sDebug.println("  " + netCircuitSpan.availSpan.prettyString());
                sDebug.println("  " + netCircuitSpan.prettyStringSpanState());
            }
        }
        if (this.hasUnprotectedSelector()) {
            sDebug.println(" Unprotected Selector");
        }
        if (this.hasUnprotectedDrop()) {
            sDebug.println(" Unprotected Drop");
        }
        if (this.nodeRoutingDir != null) {
            this.nodeRoutingDir.prettyPrint(sDebug);
        }
        this.prettyPrintConnectionList(sDebug);
    }

    protected String translateAdminState(int n) {
        return EnumStrings.getString((Class)IAdminState.class, (int)(n + 1));
    }

    protected String translateServiceState(int n) {
        return EnumStrings.getString((Class)IServiceState.class, (int)(n + 2));
    }

    protected String prettyString(IPathDefModel iPathDefModel) {
        return "";
    }

    protected void lotReuseLoAdit(boolean bl) {
    }

    public INetCircuit getCircuit() {
        return this.circuit;
    }

    public List getMonitorSourcePoints() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("getMonitorSourcePoints @ " + this.getName());
        }
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        Object[] objectArray = this.getPathsFromConnModel();
        int n = this.getConnTypeFromConnModel();
        if (objectArray.length == 0 || n == 20) {
            if (this.dbgOn()) {
                db.println("getMonitorSourcePoints: connection object is null");
            }
            throw new SanityCheckFailed("Connection not found at " + this.getName());
        }
        switch (n) {
            case 0: 
            case 9: {
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[0]));
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[0]));
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[1]));
                break;
            }
            case 2: 
            case 10: {
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[0]));
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[1]));
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[2]));
                break;
            }
            case 3: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[0]));
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[1]));
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[2]));
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[3]));
                break;
            }
            case 4: {
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[2]));
                break;
            }
            case 8: {
                int n2 = objectArray.length;
                if (n2 > 0) {
                    linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[0]));
                }
                if (n2 <= 1) break;
                linkedList.add(NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[1]));
            }
        }
        return linkedList;
    }

    protected void addDropInfo(NetCircuitDropInfo netCircuitDropInfo) {
        NetCircuitEnd netCircuitEnd = netCircuitDropInfo.getNetCktEnd();
        this.insertDrop(netCircuitEnd);
        netCircuitEnd.setStage(2);
        if (this.getState() != 0) {
            this.setState(3);
        }
    }

    protected void addSource(NetCircuitEnd netCircuitEnd) {
        if (this.hasConnection()) {
            if (this.dbgOn()) {
                db.println("Warning! attempt to add source to active node");
            }
            return;
        }
        netCircuitEnd.setStage(2);
        this.insertSource(netCircuitEnd);
    }

    protected void insertSource(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("sources.add(" + netCircuitEnd.prettyString() + ") at " + this.getName());
        }
        this.sources.add(netCircuitEnd);
    }

    protected void insertDrop(NetCircuitEnd netCircuitEnd) {
        if (netCircuitEnd.isNodeDrop()) {
            if (this.dbgOn()) {
                this.debug("Adding nodeDrop " + netCircuitEnd.prettyString() + " at " + this.getName());
            }
            this.nodeDrop = netCircuitEnd;
        } else {
            if (this.dbgOn()) {
                this.debug("drops.add(" + netCircuitEnd.prettyString() + ") at " + this.getName());
            }
            this.drops.add(netCircuitEnd);
        }
    }

    protected void removeSource(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("sources.remove(" + netCircuitEnd.prettyString() + ") at " + this.getName());
        }
        this.sources.remove(netCircuitEnd);
    }

    protected void removeDrop(NetCircuitEnd netCircuitEnd) {
        if (netCircuitEnd.isNodeDrop()) {
            if (this.dbgOn()) {
                this.debug("Removing nodeDrop " + netCircuitEnd.prettyString() + " at " + this.getName());
            }
            this.nodeDrop = null;
        } else {
            if (this.dbgOn()) {
                this.debug("drops.remove(" + netCircuitEnd.prettyString() + ") at " + this.getName());
            }
            this.drops.remove(netCircuitEnd);
        }
    }

    protected void changeSourceToDrop(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("changeSourceToDrop(" + netCircuitEnd.prettyString() + ") at " + this.getName());
        }
        this.removeSource(netCircuitEnd);
        this.insertDrop(netCircuitEnd);
    }

    protected void changeDropToSource(NetCircuitEnd netCircuitEnd) {
        if (this.dbgOn()) {
            this.debug("changeDropToSource(" + netCircuitEnd.prettyString() + ") at " + this.getName());
        }
        this.removeDrop(netCircuitEnd);
        this.insertSource(netCircuitEnd);
    }

    protected void destroySanityCheck() throws SanityCheckFailed {
    }

    public void destroy() {
        if (this.dbgOn()) {
            db.println("Destroy node " + this.getName() + " object on exit of CTC");
        }
        super.destroy();
        this.disposeSpans();
        this.dispose(true);
    }

    public void deactivate() throws DeletionError {
        if (this.dbgOn()) {
            db.println("Deactivating circuit node " + this.getName());
        }
        if (this.state != 0) {
            if (this.inConnectionConversion()) {
                IConnectionConversionModel iConnectionConversionModel;
                if (this.dbgOn()) {
                    db.println("deactivate: NCN in Conn Conv state");
                }
                if ((iConnectionConversionModel = this.getConnectionConversionModel()) != null) {
                    if (this.dbgOn()) {
                        db.println("deactivate: destroying Conn Conv object");
                    }
                    iConnectionConversionModel.destroy();
                }
            }
            try {
                this.destroyConnection();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    db.println("i/o exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
                throw new DeletionError("CTC IO error at " + this.getName() + ":\n        " + abstractCmsIOException.toString());
            }
            catch (Busy busy) {
                if (this.dbgOn()) {
                    db.println("Busy exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)busy);
                }
                throw new DeletionError("Connection supports a Monitor circuit. You cannot delete it at this time.");
            }
            catch (ConnectionInTestAccess connectionInTestAccess) {
                if (this.dbgOn()) {
                    db.println("ConnectionInTestAccess exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)connectionInTestAccess);
                }
                throw new DeletionError("Connection is in Test Access. You cannot delete it at this time.");
            }
            catch (ConnectionInRoll connectionInRoll) {
                if (this.dbgOn()) {
                    db.println("ConnectionInRoll exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)connectionInRoll);
                }
                throw new DeletionError("Connection is in Roll. You cannot delete it at this time.");
            }
            catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                if (this.dbgOn()) {
                    db.println("ConnectionInTopologyUpgrade exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                }
                throw new DeletionError("Connection is in Topology Upgrade. You cannot delete it at this time.");
            }
            catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                if (this.dbgOn()) {
                    db.println("VcatMemberNotOutOfGroup exception trying to destroy connection at " + this.getName());
                    SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                }
                throw new DeletionError("Connection is not Out of Group. You cannot delete it at this time.");
            }
        }
        this.circuit.disposeConnection(this, true);
    }

    protected void cleanupSpliceListeners() {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (this.dbgOn()) {
            db.println("cleanupSpliceListeners at " + this.getName());
        }
        Iterator iterator = this.spliceListeners.iterator();
        while (iterator.hasNext()) {
            SpliceListenerEntry spliceListenerEntry = (SpliceListenerEntry)iterator.next();
            if (this.dbgOn()) {
                this.debug("removeSpliceListener(" + spliceListenerEntry.prettyString() + ") at " + this.getName());
            }
            netCircuitSplicer.cancelCallback(spliceListenerEntry);
            iterator.remove();
        }
    }

    protected boolean aditListenerPresent(SpliceListenerEntry spliceListenerEntry) {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (netCircuitSplicer.findListener(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, spliceListenerEntry.spliceLinkIndex.direction, spliceListenerEntry.spliceListener.hoNum, spliceListenerEntry.spliceListener.loNum, true) != null) {
            if (this.dbgOn()) {
                this.debug("Pre-existing loAditSpliceListener(" + spliceListenerEntry.prettyString() + ") found at " + this.getName());
            }
            return true;
        }
        if (netCircuitSplicer.findListener(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, spliceListenerEntry.spliceLinkIndex.direction, spliceListenerEntry.spliceListener.hoNum, spliceListenerEntry.spliceListener.loNum, false) != null) {
            if (this.dbgOn()) {
                this.debug("Pre-existing HO spliceListener found for loAdit(" + spliceListenerEntry.prettyString() + ") found at " + this.getName());
            }
            return true;
        }
        return false;
    }

    protected void addSpliceListener(SpliceListenerEntry spliceListenerEntry) {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (this.dbgOn()) {
            this.debug("addSpliceListener(" + spliceListenerEntry.prettyString() + ") at " + this.getName());
        }
        this.spliceListeners.add(spliceListenerEntry);
        if (spliceListenerEntry.spliceListener.loNum != null) {
            SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, eSpanDirection.BIDIRECTIONAL);
            SpliceListener spliceListener = new SpliceListener(spliceListenerEntry.spliceListener.hoNum, null, this, true);
            SpliceListenerEntry spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex, spliceListener);
            this.addAditListener(spliceListenerEntry2);
        }
    }

    protected void addAditListener(SpliceListenerEntry spliceListenerEntry) {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (!this.aditListenerPresent(spliceListenerEntry)) {
            netCircuitSplicer.registerCallback(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, spliceListenerEntry.spliceLinkIndex.direction, spliceListenerEntry.spliceListener.hoNum, spliceListenerEntry.spliceListener.loNum, spliceListenerEntry.spliceListener.node, spliceListenerEntry.spliceListener.loAdit);
            this.spliceListeners.add(spliceListenerEntry);
            if (this.dbgOn()) {
                this.debug("Added loAditSpliceListener(" + spliceListenerEntry.prettyString() + ") at " + this.getName());
            }
        }
    }

    protected void removeSpliceListener(SpliceListenerEntry spliceListenerEntry) {
        SpliceListener spliceListener;
        SpliceListenerEntry spliceListenerEntry2;
        boolean bl;
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (this.dbgOn()) {
            this.debug("removeSpliceListener(" + spliceListenerEntry.prettyString() + ") at " + this.getName());
        }
        if (!(bl = this.spliceListeners.remove(spliceListenerEntry)) && this.dbgOn()) {
            this.debug("WARNING! spliceListener not found in list");
        }
        if (spliceListenerEntry.spliceListener.loNum != null && (bl = this.spliceListeners.remove(spliceListenerEntry2 = new SpliceListenerEntry(spliceListenerEntry.spliceLinkIndex, spliceListener = new SpliceListener(spliceListenerEntry.spliceListener.hoNum, null, this, true))))) {
            netCircuitSplicer.cancelCallback(spliceListenerEntry2);
            if (this.dbgOn()) {
                this.debug("Removed loAditSpliceListener(" + spliceListenerEntry2.prettyString() + ") at " + this.getName());
            }
        }
    }

    protected boolean connEndsPartOfCktEnd(LinkedList linkedList) {
        if (this.dbgOn()) {
            this.debug("Called connEndsPartOfCktEnd for " + this.getNetElement().getName());
        }
        Iterator iterator = this.connectionPathEnds.iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (!linkedList.contains(netCircuitEnd)) continue;
            if (this.dbgOn()) {
                this.debug("Connection EndPoint" + netCircuitEnd.prettyString() + " is part of CircuitInfo");
            }
            return true;
        }
        return false;
    }

    private void createSpliceListener(NetCircuitSplicer netCircuitSplicer, INetElement iNetElement, int n, eSpanDirection eSpanDirection2, IHoNum iHoNum, ILoNum iLoNum, NetCircuitNode netCircuitNode, boolean bl) {
        LinkedList linkedList;
        NetCircuitEnd netCircuitEnd = new NetCircuitEnd(iNetElement.getNodeId(), n, iHoNum, iLoNum, false);
        if (this.circuit.circuitInfoActive() && (linkedList = this.circuit.getCktInfoEndPoints()).contains(netCircuitEnd)) {
            if (this.dbgOn()) {
                this.debug("Not creating SpliceListener at " + this.getName() + "for cktInfo EndPoint" + netCircuitEnd.prettyString());
            }
            return;
        }
        if (this.isUpsrOver1Plus1Enabled() && this.checkListenerOnSamePort(netCircuitEnd)) {
            if (this.dbgOn()) {
                this.debug("Removed matching spliceListener for cktEnd " + netCircuitEnd.prettyString());
            }
            return;
        }
        SpliceListenerEntry spliceListenerEntry = netCircuitSplicer.registerCallback(iNetElement, n, eSpanDirection2, iHoNum, iLoNum, netCircuitNode, bl);
        this.addSpliceListener(spliceListenerEntry);
    }

    protected void createSpliceListener(INetElement iNetElement, int n, eSpanDirection eSpanDirection2, IHoNum iHoNum, ILoNum iLoNum, NetCircuitNode netCircuitNode, boolean bl) {
        this.createSpliceListener(NetCircuitSplicer.instance(), iNetElement, n, eSpanDirection2, iHoNum, iLoNum, netCircuitNode, bl);
    }

    protected void createSpliceListener(NetCircuitSplicer netCircuitSplicer, NetCircuitEnd netCircuitEnd, eSpanDirection eSpanDirection2) {
        this.createSpliceListener(netCircuitSplicer, this.getNetElement(), netCircuitEnd.getEntityIndex(), eSpanDirection2, netCircuitEnd.getHoNum(), netCircuitEnd.getLoNum(), this, false);
    }

    protected void createSpliceListener(NetCircuitEnd netCircuitEnd) {
        int n;
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (!this.hasConnectionPath(netCircuitEnd)) {
            if (this.dbgOn()) {
                this.debug("createSpliceListener: cktEnd has no connection path " + Integer.toHexString(netCircuitEnd.getEntityIndex()));
            }
            return;
        }
        try {
            n = this.getConnectionPathIndex(netCircuitEnd);
        }
        catch (ConnectionPathNotFound connectionPathNotFound) {
            if (this.dbgOn()) {
                this.debug("createSpliceListener: cktEnd has no connection path index" + Integer.toHexString(netCircuitEnd.getEntityIndex()));
            }
            return;
        }
        eSpanDirection eSpanDirection2 = this.nodeRoutingDir.getPathSpliceDir(n);
        if (this.dbgOn()) {
            this.debug("createSpliceListener: creating splice listener for " + Integer.toHexString(netCircuitEnd.getEntityIndex()) + " spliceDir: " + eSpanDirection2);
        }
        this.createSpliceListener(netCircuitSplicer, netCircuitEnd, eSpanDirection2);
    }

    protected void deleteSpliceListener(SpliceListenerEntry spliceListenerEntry) {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        netCircuitSplicer.cancelCallback(spliceListenerEntry);
        this.removeSpliceListener(spliceListenerEntry);
    }

    protected void disposeCircuitInfo() {
        this.createSpliceListenersForSourcesAndDrops();
    }

    protected void createSpliceListenersForSourcesAndDrops() {
        if (this.dbgOn()) {
            this.debug("Creating splice listeners for srcs/drops at " + this.getName());
        }
        Iterator iterator = this.sources.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                this.createSpliceListener(netCircuitEnd);
            }
            iterator = this.drops.iterator();
        }
    }

    public void dispose(boolean bl) {
        this.disposeConnection(bl);
        this.deleteConnectionObserver();
        this.finalDispose();
    }

    protected void disposeConnection(boolean bl) {
        if (this.dbgOn()) {
            db.println("disposeConnection called at " + this.getName());
        }
        if (this.getConn() != null) {
            this.deregisterNullCircuitConnection(this.getNetElement(), this.getConn());
        }
        if (bl) {
            this.cleanupSpliceListeners();
        }
    }

    protected void finalDispose() {
        if (this.dbgOn()) {
            db.println("finalDispose at " + this.getName());
        }
        this.isNodeRefValid = false;
        if ((this.inSpans.size() != 0 || this.outSpans.size() != 0 || this.biSpans.size() != 0) && this.dbgOn()) {
            db.println("Warning! finalDispose: all spans not disposed: " + this.inSpans.size() + "," + this.outSpans.size() + "," + this.biSpans.size());
        }
        this.inSpans.clear();
        this.outSpans.clear();
        this.biSpans.clear();
        if (this.spliceListeners.size() != 0 && this.dbgOn()) {
            db.println("Warning! finalDispose: all spliceListeners not disposed: " + this.spliceListeners.size());
        }
        this.spliceListeners.clear();
        this.setConn(null);
    }

    protected void disposeSpans() {
        if (this.dbgOn()) {
            db.println("disposeSpans at node " + this.getName());
        }
        LinkedList linkedList = (LinkedList)this.inSpans.clone();
        linkedList.addAll((Collection)this.outSpans.clone());
        linkedList.addAll((Collection)this.biSpans.clone());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ((NetCircuitSpan)iterator.next()).dispose(false);
        }
    }

    public int getState() {
        return this.state;
    }

    public boolean getDri() {
        return this.dri;
    }

    protected void setDri(boolean bl) {
        if (this.dbgOn() && bl) {
            db.println("setDri: " + bl + " on node " + this.getName());
        }
        this.dri = bl;
    }

    protected void initState(int n) {
        if (this.dbgOn()) {
            db.println("Node " + this.getName() + " init state: " + EnumStrings.getString((Class)INetCircuitProvState.class, (int)n));
        }
        this.state = n;
    }

    protected void setState(int n) {
        if (n == this.state) {
            return;
        }
        if (this.dbgOn()) {
            db.println("Node " + this.getName() + " state change: " + EnumStrings.getString((Class)INetCircuitProvState.class, (int)this.state) + "->" + EnumStrings.getString((Class)INetCircuitProvState.class, (int)n));
        }
        this.state = n;
    }

    protected boolean hasConnection() {
        return this.state == 2 || this.state == 3 || this.state == 4;
    }

    protected List inSpans() {
        return this.inSpans;
    }

    protected List outSpans() {
        return this.outSpans;
    }

    protected List biSpans() {
        return this.biSpans;
    }

    protected List drops() {
        return this.drops;
    }

    protected List sources() {
        return this.sources;
    }

    protected void activate() throws CircuitProvError {
        if (this.state == 2) {
            return;
        }
        if (this.dbgOn()) {
            db.println("Circuit Node Activate. Node " + this.getName());
        }
        if (this.state == 0) {
            this.createConnection();
            this.setServiceState(this.getServiceStateFromNE());
            if (this.circuit.tl1Compatible() && !this.circuit.isMemberOfVcat()) {
                this.createSpliceListenersForSourcesAndDrops();
            }
            return;
        }
        this.modifyConnection();
    }

    protected void deleteSpanFromConnection(NetCircuitSpan netCircuitSpan) throws DeleteInstead, InvalidPath, ConnectionTypeError, ObjNotFound, PathInUse, NoMoreLoCapableHo, ConnectionInTopologyUpgrade, ConnectionInLoopback, ConnectionInTestAccess, ConnectionInRoll {
        if (this.dbgOn()) {
            db.println("Deleting span from connection");
        }
        this.removeOutputFromConnModel(netCircuitSpan);
        --this.numberOfPaths;
        this.changeUpsrDcToTwoway();
        if (netCircuitSpan.getLink().getSrc() == this.ne) {
            netCircuitSpan.setSrcState(0);
        } else {
            netCircuitSpan.setDstState(0);
        }
    }

    protected void deleteDropFromConnection(NetCircuitEnd netCircuitEnd) throws DeleteInstead, InvalidPath, PathInUse, ObjNotFound, NoMoreLoCapableHo, ConnectionTypeError, ConnectionInTopologyUpgrade, ConnectionInLoopback, ConnectionInTestAccess, ConnectionInRoll {
        if (netCircuitEnd.getStage() == 2) {
            return;
        }
        if (this.dbgOn()) {
            db.println("Deleting drop from connection");
        }
        this.removeOutputFromConnModel(netCircuitEnd);
        --this.numberOfPaths;
        this.changeUpsrDcToTwoway();
    }

    protected void changeUpsrDcToTwoway() throws ConnectionTypeError, ConnectionInTopologyUpgrade, ConnectionInLoopback, ConnectionInTestAccess, ConnectionInRoll {
        if (this.numberOfPaths == 2 && this.getConnectionType() == 6) {
            if (this.getConn() != null) {
                this.setConnTypeInConnModel(1);
            }
            this.setupConnListOnCreation();
            this.cleanupUpsrEntities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupUpsrEntities() {
        Object object = this.entitiesLockObject;
        synchronized (object) {
            this.workingEntities = null;
            this.protectEntities = null;
            this.activeEntities = null;
        }
    }

    protected int getAdminStateFromNE() {
        if (!this.ne.getNodeModel().provides(Feature.ENHANCED_STATE_MODEL)) {
            return 0;
        }
        if (this.getConn() != null) {
            return this.getConn().getAdminState();
        }
        return -1;
    }

    public int getAdminState() {
        return this.adminState;
    }

    protected void setAdminState(int n) {
        if (this.dbgOn()) {
            this.debug("setAdminState(" + this.getName() + "): " + this.translateAdminState(this.adminState) + " --> " + this.translateAdminState(n));
        }
        this.adminState = n;
    }

    protected int getServiceStateFromNE() {
        if (Feature.provides((INodeModel)this.getNodeModel(), (Feature)Feature.EXTENDED_ESM)) {
            if (this.getConn() != null) {
                return this.getConn().getServiceState();
            }
            return -2;
        }
        return -2;
    }

    public int getServiceState() {
        return this.serviceState;
    }

    protected void setServiceState(int n) {
        if (this.dbgOn()) {
            this.debug("setServiceState(" + this.getName() + "): " + this.translateServiceState(this.serviceState) + " --> " + this.translateServiceState(n));
        }
        this.serviceState = n;
    }

    protected void tentative2Routed() throws DeletionError {
        if (this.dbgOn()) {
            db.println("tentative2Routed: state " + EnumStrings.getString((Class)INetCircuitProvState.class, (int)this.state) + " node " + this.getName());
        }
        if (this.state == 1) {
            block31: {
                if (this.dbgOn()) {
                    db.println("tentative2Routed: destroying the connection");
                }
                try {
                    this.destroyConnection();
                }
                catch (Busy busy) {
                    if (this.dbgOn()) {
                        db.println("Busy exception destroying a connection in tentative2Routed.");
                        SDebug.printStackTrace((Throwable)busy);
                    }
                }
                catch (ConnectionInTestAccess connectionInTestAccess) {
                    if (this.dbgOn()) {
                        db.println("ConectionInTestAccess destroying a connection in tentative2Routed.");
                        SDebug.printStackTrace((Throwable)connectionInTestAccess);
                    }
                }
                catch (ConnectionInRoll connectionInRoll) {
                    if (this.dbgOn()) {
                        db.println("ConnectionInRoll destroying a connection in tentative2Routed.");
                        SDebug.printStackTrace((Throwable)connectionInRoll);
                    }
                }
                catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                    if (this.dbgOn()) {
                        db.println("ConnectionInTopologyUpgrade destroying a connection in tentative2Routed.");
                        SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                    }
                }
                catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                    if (!this.dbgOn()) break block31;
                    db.println("VcatMemberNotOutOfGroup destroying a connection in tentative2Routed.");
                    SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                }
            }
            this.setState(0);
            this.setCreateStage(2);
        } else if (this.state == 3) {
            Iterator iterator = this.outSpans.iterator();
            while (iterator.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                if (netCircuitSpan.getSrcState() != 3) continue;
                if (this.dbgOn()) {
                    db.println("tentative2Routed: deleting tentative span " + netCircuitSpan.prettyString() + " from connection");
                }
                try {
                    this.deleteSpanFromConnection(netCircuitSpan);
                }
                catch (CTCUserException cTCUserException) {
                    if (this.dbgOn()) {
                        db.println("tentative2Routed: Warning! attempt to delete span from connection failed");
                    }
                    String string = "unable to delete span from connection at " + this.getName();
                    if (cTCUserException instanceof InvalidPath) {
                        string = string + "\nPath is invalid ";
                    } else if (cTCUserException instanceof ConnectionTypeError) {
                        string = string + "\nConnection type error ";
                    }
                    throw new DeletionError(string);
                }
                netCircuitSpan.setSrcState(2);
            }
            iterator = this.drops.iterator();
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                if (netCircuitEnd.getStage() != 3) continue;
                if (this.dbgOn()) {
                    db.println("deleting tentative drop " + netCircuitEnd.prettyString() + " from connection");
                }
                try {
                    this.deleteDropFromConnection(netCircuitEnd);
                }
                catch (CTCUserException cTCUserException) {
                    if (this.dbgOn()) {
                        db.println("tentative2Routed: Warning! attempt to delete drop from connection failed");
                    }
                    String string = "unable to delete drop from connection at " + this.getName();
                    if (cTCUserException instanceof InvalidPath) {
                        string = string + "\nPath is invalid ";
                    } else if (cTCUserException instanceof ConnectionTypeError) {
                        string = string + "\nConnection type error ";
                    }
                    throw new DeletionError(string);
                }
                netCircuitEnd.setStage(2);
            }
        }
    }

    protected int numRoutedPaths() {
        NetCircuitSpan netCircuitSpan;
        NetCircuitEnd netCircuitEnd;
        int n = 0;
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.getStage() != 2) continue;
            ++n;
        }
        iterator = this.drops.iterator();
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd.getStage() != 2) continue;
            ++n;
        }
        if (this.nodeDrop != null && this.nodeDrop.getStage() == 2) {
            ++n;
        }
        iterator = this.inSpans.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getDstState() != 2) continue;
            ++n;
        }
        iterator = this.outSpans.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getSrcState() != 2) continue;
            ++n;
        }
        iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getLink().getSrc() == this.ne) {
                if (netCircuitSpan.getSrcState() != 2) continue;
                ++n;
                continue;
            }
            if (netCircuitSpan.getDstState() != 2) continue;
            ++n;
        }
        return n;
    }

    protected void setCreateStage(int n) {
        NetCircuitSpan netCircuitSpan;
        NetCircuitEnd netCircuitEnd;
        Iterator iterator = this.sources.iterator();
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            netCircuitEnd.setStage(n);
        }
        iterator = this.drops.iterator();
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            netCircuitEnd.setStage(n);
        }
        if (this.nodeDrop != null) {
            this.nodeDrop.setStage(n);
        }
        iterator = this.inSpans.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            netCircuitSpan.setDstState(n);
        }
        iterator = this.outSpans.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            netCircuitSpan.setSrcState(n);
        }
        iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getLink().getSrc() == this.ne) {
                netCircuitSpan.setSrcState(n);
                continue;
            }
            netCircuitSpan.setDstState(n);
        }
    }

    protected void tentative2Active() {
        if (this.dbgOn()) {
            db.println("tentative2Active at node " + this.getName());
        }
        if (this.state == 0) {
            if (this.dbgOn()) {
                db.println("node is inactive");
            }
            return;
        }
        this.setCreateStage(4);
        this.setState(2);
    }

    private void destroyInputs() throws DeletionError {
        NetCircuitNode netCircuitNode;
        NetCircuitSpan netCircuitSpan;
        if (this.dbgOn()) {
            db.println("destroying inputs at " + this.getName());
        }
        Iterator iterator = this.inSpans.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            netCircuitSpan.setDstState(0);
            netCircuitNode = this.spanGetPeer(netCircuitSpan);
            netCircuitNode.deleteOutputSpan(netCircuitSpan);
            iterator.remove();
        }
        iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getLink().getSrc() == this.ne) {
                netCircuitSpan.setSrcState(0);
            } else {
                netCircuitSpan.setDstState(0);
            }
            netCircuitNode = this.spanGetPeer(netCircuitSpan);
            netCircuitNode.deleteBiSpan(netCircuitSpan);
            iterator.remove();
        }
    }

    protected void deleteNodeDrop() throws DeletionError {
    }

    protected boolean feedsNoDrops(Object object) {
        boolean bl = true;
        if (this.loopFlag) {
            if (this.dbgOn()) {
                db.println("feedsNoDrops: loop detected at " + this.getName());
            }
            this.loopFlag = false;
            return true;
        }
        this.loopFlag = true;
        if (!(this.drops.size() <= 0 || this.drops.size() == 1 && object != null && this.drops.contains(object))) {
            if (this.dbgOn()) {
                db.println("feedsNoDrops: drop found on " + this.getName());
            }
            this.loopFlag = false;
            return false;
        }
        Iterator iterator = this.getOrigSpans().iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan);
            if (netCircuitNode.feedsNoDrops(object)) continue;
            this.loopFlag = false;
            return false;
        }
        this.loopFlag = false;
        return true;
    }

    protected NetCircuitNode spanGetPeer(NetCircuitSpan netCircuitSpan) {
        if (netCircuitSpan == null) {
            if (this.dbgOn()) {
                this.debug("spanGetPeer: null span");
            }
            return null;
        }
        if (this.ne == netCircuitSpan.getLink().getDst()) {
            return (NetCircuitNode)this.circuit.getCircuitNodeFromNE(netCircuitSpan.getLink().getSrc());
        }
        return (NetCircuitNode)this.circuit.getCircuitNodeFromNE(netCircuitSpan.getLink().getDst());
    }

    protected NetCircuitSpan findAlternateBiSpan(NetCircuitSpan netCircuitSpan) {
        Iterator iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan2 == netCircuitSpan || netCircuitSpan2.getNetLinkSpan().getOmni()) continue;
            return netCircuitSpan2;
        }
        return null;
    }

    protected NetCircuitSpan findAlternateBiOrOmniSpan(NetCircuitSpan netCircuitSpan) {
        Iterator iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan2 == netCircuitSpan) continue;
            return netCircuitSpan2;
        }
        return null;
    }

    protected NetCircuitSpan findNextBiSpanOnRoute(IEntityModel[] iEntityModelArray, NetCircuitSpan netCircuitSpan) {
        int n = netCircuitSpan.getEntityIndex(this.ne);
        if (iEntityModelArray == null) {
            return null;
        }
        Iterator<Object> iterator = Arrays.asList(iEntityModelArray).iterator();
        boolean bl = false;
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3 = iterator.next().getEntityIndex();
            if (n3 == n) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl || n2 >= 4) {
            return null;
        }
        int n4 = -1;
        if (this.connType == 1 || this.connType == 8) {
            if (n2 == 0) {
                n4 = 1;
            } else if (n2 == 1) {
                n4 = 0;
            }
        }
        if (this.connType == 2) {
            if (n2 == 0 || n2 == 1) {
                n4 = 2;
            } else if (n2 == 2) {
                n4 = 0;
            }
        }
        if (this.connType == 3) {
            if (n2 == 0 || n2 == 1) {
                n4 = 2;
            } else if (n2 == 2 || n2 == 3) {
                n4 = 0;
            }
        }
        if (n4 == -1 || iEntityModelArray.length <= n4) {
            return null;
        }
        iterator = this.biSpans.iterator();
        int n5 = iEntityModelArray[n4].getEntityIndex();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan2.getEntityIndex(this.ne) != n5) continue;
            return netCircuitSpan2;
        }
        return null;
    }

    protected boolean upsrEmpty(Object object) {
        Connection connection = this.findConnectionWithOutput(object);
        if (connection == null) {
            if (this.dbgOn()) {
                db.println("upsrEmpty: no connection for output on node " + this.getName());
            }
            return true;
        }
        if (connection instanceof SelectorConnection) {
            SelectorConnection selectorConnection = (SelectorConnection)connection;
            if (this.dbgOn()) {
                db.println("upsrEmpty: examining selector on node " + this.getName());
            }
            Iterator iterator = selectorConnection.getInSpans().iterator();
            while (iterator.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                if (!selectorConnection.hasInputPathDrop(selectorConnection, netCircuitSpan, object)) continue;
                if (this.dbgOn()) {
                    db.println("upsrEmpty: found a drop depending on the connection on node " + this.getName());
                }
                return false;
            }
        } else {
            if (this.dbgOn()) {
                db.println("upsrEmpty: output not connected to a selector on node " + this.getName());
            }
            return true;
        }
        if (this.dbgOn()) {
            db.println("upsrEmpty: selector is empty on node " + this.getName());
        }
        return true;
    }

    private int upsrCountBridgePath(NetCircuitSpan netCircuitSpan) {
        int n = 0;
        if (this.dbgOn()) {
            db.println("upsrCountBridgePath: Node " + this.getName());
        }
        if (!this.biSpans.contains(netCircuitSpan)) {
            if (this.connType == 4 && this.isUndeletablePath(this.getPathDefIndexFromSpan(netCircuitSpan))) {
                ++n;
            }
            return n;
        }
        NetCircuitSpan netCircuitSpan2 = this.findAlternateBiSpan(netCircuitSpan);
        if (netCircuitSpan2 != null) {
            NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan2);
            n = netCircuitNode.upsrCountBridgePath(netCircuitSpan2);
        }
        if (netCircuitSpan2 == null && !this.sources.isEmpty() && this.getPathDefIndexFromSpan(netCircuitSpan) < 2) {
            ++n;
        }
        return n;
    }

    private boolean onUpsrBridgePath() {
        Iterator iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan);
            int n = netCircuitNode.upsrCountBridgePath(netCircuitSpan);
            if (n <= 0) continue;
            if (this.dbgOn()) {
                db.println("Non zero source count " + n);
            }
            return true;
        }
        if (this.dbgOn()) {
            db.println("onUpsrBridgePath is false");
        }
        return false;
    }

    private boolean isUndeletablePath(int n) {
        if (this.connType == 6 || this.connType == 4) {
            return n == 0 || n == 1;
        }
        return false;
    }

    public void removeRoutedDrop(NetCircuitEnd netCircuitEnd) throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("Removing ROUTED drop at " + this.getName());
        }
        this.removeDrop(netCircuitEnd);
        if (this.state == 3 && this.numRoutedPaths() == 0) {
            this.setState(2);
        }
        this.setupConnListOnCreation();
    }

    public void removeActiveDrop(NetCircuitEnd netCircuitEnd) throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("Removing ACTIVE drop at " + this.getName());
        }
        this.removeDrop(netCircuitEnd);
        this.setupConnListOnCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws DeletionError, SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("deleteDrop called at node " + this.getName());
        }
        boolean bl = this.upsrEmpty(iNetCircuitEnd);
        int n = this.drops.size() + this.outSpans.size();
        if (!this.circuit.getCircuitTypeObj().isEthernetCircuitType()) {
            if (!this.deleteDropCheck(iNetCircuitEnd, bl)) {
                throw new SanityCheckFailed("Can not delete this drop because deleting this drop will break UPSR ring.");
            }
            if (n == 1 && bl) {
                block32: {
                    try {
                        this.destroyConnection();
                    }
                    catch (Busy busy) {
                        if (this.dbgOn()) {
                            db.println("Busy exception destroying a connection in deleteDrop.");
                            SDebug.printStackTrace((Throwable)busy);
                        }
                    }
                    catch (ConnectionInTestAccess connectionInTestAccess) {
                        if (this.dbgOn()) {
                            db.println("ConectionInTestAccess destroying a connection in deleteDrop.");
                            SDebug.printStackTrace((Throwable)connectionInTestAccess);
                        }
                    }
                    catch (ConnectionInRoll connectionInRoll) {
                        if (this.dbgOn()) {
                            db.println("ConnectionInRoll destroying a connection in deleteDrop.");
                            SDebug.printStackTrace((Throwable)connectionInRoll);
                        }
                    }
                    catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                        if (this.dbgOn()) {
                            db.println("ConnectionInTopologyUpgrade destroying a connection in deleteDrop.");
                            SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                        }
                    }
                    catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                        if (!this.dbgOn()) break block32;
                        db.println("VcatMemberNotOutOfGroup destroying a connection in deleteDrop.");
                        SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                    }
                }
                this.removeActiveDrop((NetCircuitEnd)iNetCircuitEnd);
                this.destroyInputs();
            } else {
                try {
                    this.deleteDropFromConnection((NetCircuitEnd)iNetCircuitEnd);
                }
                catch (CTCUserException cTCUserException) {
                    if (this.dbgOn()) {
                        db.println("unable to remove drop from connection");
                    }
                    String string = "unable to delete drop from connection at " + this.getName();
                    if (cTCUserException instanceof InvalidPath) {
                        string = string + "\nPath is invalid ";
                    } else if (cTCUserException instanceof ConnectionTypeError) {
                        string = string + "\nConnection type error ";
                    }
                    throw new DeletionError(string);
                }
                this.removeActiveDrop((NetCircuitEnd)iNetCircuitEnd);
            }
        } else {
            try {
                this.deleteDropFromConnection((NetCircuitEnd)iNetCircuitEnd);
            }
            catch (CTCUserException cTCUserException) {
                if (this.dbgOn()) {
                    db.println("unable to remove drop from connection");
                }
                String string = "unable to delete drop from connection at " + this.getName();
                if (cTCUserException instanceof InvalidPath) {
                    string = string + "\nPath is invalid ";
                } else if (cTCUserException instanceof ConnectionTypeError) {
                    string = string + "\nConnection type error ";
                }
                throw new DeletionError(string);
            }
            this.removeActiveDrop((NetCircuitEnd)iNetCircuitEnd);
        }
        if (this.state == 3 && this.numRoutedPaths() == 0) {
            this.setState(2);
            Object object = this.entitiesLockObject;
            synchronized (object) {
                this.updateUpsrEntities(true);
            }
        }
    }

    protected boolean deleteDropCheck(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        int n = this.drops.size() + this.outSpans.size();
        if (this.connType == 1) {
            if (this.dbgOn()) {
                db.println("deleteDropCheck: drop has two-way connection");
            }
            return false;
        }
        if (this.connType == 6 || this.connType == 7 || this.connType == 5) {
            if (this.isUndeletablePath(this.getPathDefIndexFromCktEnd(iNetCircuitEnd))) {
                if (this.dbgOn()) {
                    db.println("deleteDropCheck: drop is on an undeletable path");
                }
                return false;
            }
            if (n == 1 && bl && this.onUpsrBridgePath()) {
                if (this.dbgOn()) {
                    db.println("deleteDropCheck: delete drop will break upsr ring");
                }
                return false;
            }
        } else if (this.connType == 4 && this.isUndeletablePath(this.getPathDefIndexFromCktEnd(iNetCircuitEnd))) {
            if (this.dbgOn()) {
                db.println("deleteDropCheck: drop is one of upsr bridge");
            }
            return false;
        }
        return true;
    }

    protected void deleteBiSpan(NetCircuitSpan netCircuitSpan) throws DeletionError {
        block25: {
            if (this.dbgOn()) {
                db.println("deleteBiSpan: Node " + this.getName() + " Span " + netCircuitSpan.prettyString());
            }
            if (this.nodeDrop != null) {
                try {
                    this.deleteSpanFromConnection(netCircuitSpan);
                }
                catch (CTCUserException cTCUserException) {
                    if (this.dbgOn()) {
                        db.println("unable to delete span from connection");
                    }
                    String string = "unable to delete span from connection at " + this.getName();
                    if (cTCUserException instanceof InvalidPath) {
                        string = string + "\nPath is invalid ";
                    } else if (cTCUserException instanceof ConnectionTypeError) {
                        string = string + "\nConnection type error ";
                    }
                    throw new DeletionError(string);
                }
                this.removeActiveBiSpan(netCircuitSpan);
                return;
            }
            if (!this.biSpans.contains(netCircuitSpan)) {
                this.deleteOutputSpan(netCircuitSpan);
                return;
            }
            if (netCircuitSpan.getLink().getSrc() == this.ne) {
                netCircuitSpan.setSrcState(0);
            } else {
                netCircuitSpan.setDstState(0);
            }
            this.removeActiveBiSpan(netCircuitSpan);
            try {
                this.destroyConnection();
            }
            catch (Busy busy) {
                if (this.dbgOn()) {
                    db.println("Busy exception destroying a connection in deleteBiSpan.");
                    SDebug.printStackTrace((Throwable)busy);
                }
            }
            catch (ConnectionInTestAccess connectionInTestAccess) {
                if (this.dbgOn()) {
                    db.println("ConectionInTestAccess destroying a connection in deleteBiSpan.");
                    SDebug.printStackTrace((Throwable)connectionInTestAccess);
                }
            }
            catch (ConnectionInRoll connectionInRoll) {
                if (this.dbgOn()) {
                    db.println("ConnectionInRoll destroying a connection in deleteBiSpan.");
                    SDebug.printStackTrace((Throwable)connectionInRoll);
                }
            }
            catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                if (this.dbgOn()) {
                    db.println("ConnectionInTopologyUpgrade destroying a connection in deleteBiSpan.");
                    SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                }
            }
            catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                if (!this.dbgOn()) break block25;
                db.println("VcatMemberNotOutOfGroup destroying a connection in deleteBiSpan.");
                SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
            }
        }
        if (this.isUpsrSelectorConnType(this.connType) && this.circuit.isBidirectional()) {
            return;
        }
        Iterator iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan2.getLink().getSrc() == this.ne) {
                netCircuitSpan2.setSrcState(0);
            } else {
                netCircuitSpan2.setDstState(0);
            }
            NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan2);
            netCircuitNode.deleteBiSpan(netCircuitSpan2);
            iterator.remove();
        }
    }

    protected void deleteOutputSpan(NetCircuitSpan netCircuitSpan) throws DeletionError {
        boolean bl;
        if (this.dbgOn()) {
            db.println("deleteOutputSpan: Node " + this.getName() + " Span " + netCircuitSpan.prettyString());
        }
        if (!this.outSpans.contains(netCircuitSpan)) {
            if (this.dbgOn()) {
                db.println("Warning! : span not found");
            }
            return;
        }
        netCircuitSpan.setSrcState(0);
        int n = this.outSpans.size() + this.drops.size();
        boolean bl2 = bl = this.biSpans.size() == 0 && this.outSpans.size() == 2;
        if (n == 1 && this.upsrEmpty(netCircuitSpan) || bl && this.feedsNoDrops(null)) {
            block23: {
                try {
                    this.destroyConnection();
                }
                catch (Busy busy) {
                    if (this.dbgOn()) {
                        db.println("Busy exception destroying a connection in deleteOutputSpan.");
                        SDebug.printStackTrace((Throwable)busy);
                    }
                }
                catch (ConnectionInTestAccess connectionInTestAccess) {
                    if (this.dbgOn()) {
                        db.println("ConectionInTestAccess destroying a connection in deleteOutputSpan.");
                        SDebug.printStackTrace((Throwable)connectionInTestAccess);
                    }
                }
                catch (ConnectionInRoll connectionInRoll) {
                    if (this.dbgOn()) {
                        db.println("ConnectionInRoll destroying a connection in deleteOutputSpan.");
                        SDebug.printStackTrace((Throwable)connectionInRoll);
                    }
                }
                catch (ConnectionInTopologyUpgrade connectionInTopologyUpgrade) {
                    if (this.dbgOn()) {
                        db.println("ConnectionInTopologyUpgrade destroying a connection in deleteOutputSpan.");
                        SDebug.printStackTrace((Throwable)connectionInTopologyUpgrade);
                    }
                }
                catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                    if (!this.dbgOn()) break block23;
                    db.println("VcatMemberNotOutOfGroup destroying a connection in deleteOutputSpan.");
                    SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                }
            }
            this.destroyInputs();
        } else {
            if (this.dbgOn()) {
                db.println("attempting to remove span (output) from connection");
            }
            try {
                this.deleteSpanFromConnection(netCircuitSpan);
            }
            catch (CTCUserException cTCUserException) {
                if (this.dbgOn()) {
                    db.println("unable to delete span from connection");
                }
                String string = "unable to delete span from connection at " + this.getName();
                if (cTCUserException instanceof InvalidPath) {
                    string = string + "\nPath is invalid ";
                } else if (cTCUserException instanceof ConnectionTypeError) {
                    string = string + "\nConnection type error ";
                }
                throw new DeletionError(string);
            }
            this.removeActiveOutSpan(netCircuitSpan);
        }
        if (this.state == 3 && this.numRoutedPaths() == 0) {
            this.setState(2);
        }
    }

    protected void addRoutedSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        this.addSpan(netCircuitSpan, eSpanDirection2);
        if (this.state != 0) {
            this.setState(3);
        }
    }

    protected int removeRoutedSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        this.removeSpan(netCircuitSpan, eSpanDirection2);
        if (this.state == 3 && this.numRoutedPaths() == 0) {
            this.setState(2);
        }
        this.setupConnListOnCreation();
        return this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans() + (this.nodeDrop != null ? 1 : 0);
    }

    private void removeActiveBiSpan(NetCircuitSpan netCircuitSpan) {
        if (this.dbgOn()) {
            this.debug("Removing ACTIVE biSpan at " + this.getName());
        }
        this.biSpans.remove(netCircuitSpan);
        this.setupConnListOnCreation();
    }

    private void removeActiveOutSpan(NetCircuitSpan netCircuitSpan) {
        if (this.dbgOn()) {
            this.debug("Removing ACTIVE outSpan at " + this.getName());
        }
        this.outSpans.remove(netCircuitSpan);
        this.setupConnListOnCreation();
    }

    protected void addActiveSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.circuit.getCircuitNodeFromNE(this.getNetElement());
        if (netCircuitNode != null && netCircuitNode.hasDualConnections()) {
            netCircuitNode.addActiveSpan(netCircuitSpan, eSpanDirection2);
            return;
        }
        if (this.dbgOn()) {
            db.println("Adding active span for circuit " + this.circuit.getCircuitName() + " " + NetCircuit.prettyString(this.circuit.getCircuitId()) + " at node " + this.getNameAndClass());
        }
        this.addSpan(netCircuitSpan, eSpanDirection2);
        this.circuit.addActiveSpan(netCircuitSpan);
        this.removeActiveEndpoint(netCircuitSpan);
        this.setupConnListOnDiscovery();
    }

    protected void removeActiveEndpoint(NetCircuitSpan netCircuitSpan) {
        int n = netCircuitSpan.getEntityIndex(this.ne);
        IHoNum iHoNum = netCircuitSpan.getHoNum(this.ne);
        ILoNum iLoNum = netCircuitSpan.getLoNum();
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        Iterator iterator = this.sources.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                if (netCircuitEnd.getEntityIndex() != n || iHoNum != null && !hoLoComparator.isEqual(iHoNum, netCircuitEnd.getHoNum()) || iLoNum != null && !hoLoComparator.isEqual(iLoNum, netCircuitEnd.getLoNum())) continue;
                if (netCircuitEnd.isTl1LapCktEnd()) {
                    if (!this.dbgOn()) continue;
                    db.println("Skipping LAP ckt end " + netCircuitEnd.prettyString());
                    continue;
                }
                if (this.dbgOn()) {
                    db.println("Removing active ckt end " + netCircuitEnd.prettyString());
                }
                iterator.remove();
                return;
            }
            iterator = this.drops.iterator();
        }
    }

    protected void disposeActiveSpan(NetCircuitSpan netCircuitSpan) {
        this.disposeActiveSpan(netCircuitSpan, false);
        this.circuit.disposeActiveSpan(netCircuitSpan);
    }

    protected void disposeActiveSpan(NetCircuitSpan netCircuitSpan, boolean bl) {
        eSpanDirection eSpanDirection2;
        if (this.dbgOn()) {
            db.println("disposeActiveSpan at " + this.getName());
        }
        if ((eSpanDirection2 = this.findDir(netCircuitSpan)) == null) {
            if (this.dbgOn()) {
                db.println("disposeActiveSpan: span not found at " + this.getName());
            }
            return;
        }
        this.removeSpan(netCircuitSpan, eSpanDirection2);
        if (this.circuit.getState() == 2 || bl) {
            return;
        }
        NetCircuitEnd netCircuitEnd = this.getSpanEndpoint(netCircuitSpan);
        if (this.dbgOn()) {
            db.println("disposeActiveSpan: spanEnd entityIdx = " + Integer.toHexString(netCircuitEnd.getEntityIndex()));
        }
        this.createSpliceListener(netCircuitEnd, eSpanDirection2);
    }

    protected void createSpliceListener(NetCircuitEnd netCircuitEnd, eSpanDirection eSpanDirection2) {
        this.createSpliceListener(netCircuitEnd);
    }

    public NetCircuitEnd getSpanEndpoint(NetCircuitSpan netCircuitSpan) {
        NetCircuitEnd netCircuitEnd = new NetCircuitEnd(this.ne.getNodeId(), netCircuitSpan.getEntityIndex(this.ne), netCircuitSpan.getHoNum(this.ne), netCircuitSpan.getLoNum(), false);
        NetCircuitEnd netCircuitEnd2 = this.getConnectionPathEnd(netCircuitEnd = NetCircuitEndFactory.convertCircuitEnd(this, netCircuitEnd));
        if (netCircuitEnd2 != null) {
            return netCircuitEnd2;
        }
        return netCircuitEnd;
    }

    protected NetCircuitEnd getSpliceListenerEndpoint(SpliceListenerEntry spliceListenerEntry) {
        NetCircuitEnd netCircuitEnd = new NetCircuitEnd(spliceListenerEntry.spliceLinkIndex.ne.getNodeId(), spliceListenerEntry.spliceLinkIndex.entityIndex, spliceListenerEntry.spliceListener.hoNum, spliceListenerEntry.spliceListener.loNum, false);
        NetCircuitEnd netCircuitEnd2 = this.getConnectionPathEnd(netCircuitEnd = NetCircuitEndFactory.convertCircuitEnd(this, netCircuitEnd));
        if (netCircuitEnd2 != null) {
            return netCircuitEnd2;
        }
        if (this.dbgOn()) {
            this.debug("WARNING: Could not find connection path end for spliceListener");
        }
        return netCircuitEnd;
    }

    protected NetCircuitEnd getConnectionPathEnd(NetCircuitEnd netCircuitEnd) {
        NetCircuitEnd netCircuitEnd2 = null;
        int n = netCircuitEnd.getPathIdentifier();
        List list = this.getConnectionPathEnds();
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            netCircuitEnd2 = (NetCircuitEnd)iterator.next();
            netCircuitEnd.setPathIdentifier(netCircuitEnd2.getPathIdentifier());
            if (!netCircuitEnd2.equals(netCircuitEnd)) continue;
            bl = true;
            break;
        }
        netCircuitEnd.setPathIdentifier(n);
        if (bl) {
            return netCircuitEnd2;
        }
        return null;
    }

    protected void addSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        if (this.dbgOn()) {
            db.print("addSpan: adding " + netCircuitSpan.prettyString() + " to " + this.getName());
        }
        if (eSpanDirection2 == eSpanDirection.TERMINATING) {
            this.inSpans.add(netCircuitSpan);
            if (this.dbgOn()) {
                db.println(", inSpanSize = " + this.inSpans.size());
            }
        } else if (eSpanDirection2 == eSpanDirection.ORIGINATING) {
            this.outSpans.add(netCircuitSpan);
            if (this.dbgOn()) {
                db.println(", outSpanSize = " + this.outSpans.size());
            }
        } else if (eSpanDirection2 == eSpanDirection.BIDIRECTIONAL) {
            this.biSpans.add(netCircuitSpan);
            if (this.dbgOn()) {
                db.println(", biSpanSize = " + this.biSpans.size());
            }
        } else if (this.dbgOn()) {
            db.println(", FAILURE!!: unknown span direction");
        }
    }

    protected void removeSpan(NetCircuitSpan netCircuitSpan, eSpanDirection eSpanDirection2) {
        if (this.dbgOn()) {
            db.print("removeSpan: removing " + netCircuitSpan.prettyString() + " from " + this.getName());
        }
        if (eSpanDirection2 == eSpanDirection.TERMINATING) {
            this.inSpans.remove(netCircuitSpan);
            if (this.dbgOn()) {
                db.println(", inSpanSize = " + this.inSpans.size());
            }
        } else if (eSpanDirection2 == eSpanDirection.ORIGINATING) {
            this.outSpans.remove(netCircuitSpan);
            if (this.dbgOn()) {
                db.println(", outSpanSize = " + this.outSpans.size());
            }
        } else if (eSpanDirection2 == eSpanDirection.BIDIRECTIONAL) {
            this.biSpans.remove(netCircuitSpan);
            if (this.dbgOn()) {
                db.println(", biSpanSize = " + this.biSpans.size());
            }
        } else if (this.dbgOn()) {
            db.println(", FAILURE!!: unknown span direction");
        }
    }

    protected void conformToCircuitInfo() {
        Object[] objectArray;
        if (this.dbgOn()) {
            db.println("conformToCircuitInfo @ Node " + this.getName());
        }
        if (this.getConn() == null) {
            return;
        }
        try {
            objectArray = this.getPathsFromConnModel();
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            return;
        }
        this.sources.clear();
        this.drops.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[i]);
            this.isCircuitInfoSourceOrDrop(netCircuitEnd);
        }
        this.setCircuitInfoNodeDrop();
        this.setupConnListOnDiscovery();
    }

    public abstract void setConnectionCircuitId(ICircuitId var1);

    public abstract ICircuitId getConnectionCircuitId();

    protected boolean completeCheck() {
        int n = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
        if (this.dbgOn()) {
            db.println("completeCheck for ckt " + NetCircuit.prettyString(this.circuit.getCircuitId()) + " at node " + this.getName() + " in = " + this.countNumInputs() + " out = " + this.countNumOutputs() + " omni = " + this.countNumOmniSpans() + ": In+Out+Omni=" + n + ", numberOfPaths=" + this.numberOfPaths);
        }
        if (n == this.numberOfPaths) {
            if (this.dbgOn()) {
                db.println("completeCheck passed");
            }
            return true;
        }
        return false;
    }

    protected boolean isDropLinkEndpoint() {
        Iterator iterator = this.sources.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                Iterator iterator2 = this.getAllSpans().keySet().iterator();
                while (iterator2.hasNext()) {
                    NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator2.next();
                    if (netCircuitEnd.getEntityIndex() != netCircuitSpan.getEntityIndex(this.ne)) continue;
                    return true;
                }
            }
            iterator = this.drops.iterator();
        }
        return false;
    }

    protected int sanityCheckGetConnType() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("sanityCheckGetConnType: finding connection type for node " + this.getName());
        }
        if (this.state == 2) {
            if (this.dbgOn()) {
                db.println("sanityCheck: " + EnumStrings.getString((Class)IConnectionType.class, (int)this.connType) + " node already active");
            }
            return this.connType;
        }
        int n = this.state == 1 || this.state == 3 ? (this.circuit.getCktOperation() == 5 ? this.calculateConnectionType(db) : this.findUpgradedConnType()) : this.findConnType();
        if (n == 20) {
            throw new SanityCheckFailed("Invalid connection type at Node " + this.getName());
        }
        if (this.state == 0 && this.isOpenEndedSelector()) {
            if (this.sources.size() == 2 && !this.validateCircuitEndsUnProt(this.sources)) {
                throw new SanityCheckFailed("Invalid connection at node " + this.getName());
            }
            if (this.drops.size() == 2 && !this.validateCircuitEndsUnProt(this.drops)) {
                throw new SanityCheckFailed("Invalid connection at node " + this.getName());
            }
        }
        if (!this.circuit.isMonitorCircuit()) {
            if (this.isDropLinkEndpoint()) {
                throw new SanityCheckFailed("Source/Drop is an endpoint of a network link");
            }
            if ((this.circuit.getCktNodeListSize() == 1 && this.circuit.getState() == 0 || this.countRoutedDrops() > 0 && this.circuit.getState() == 3) && !this.validateBLSRTimeSlots()) {
                throw new SanityCheckFailed("Invalid " + NetCircuitNode.getTDMTerminology(this.getNodeModel()).getRingTerms(1) + " same time slot requirement " + this.getName());
            }
        }
        this.sanityCheckVlan(n);
        if (!(n != 10 && n != 11 || this.node.provides(Feature.UPSR_DRI))) {
            throw new SanityCheckFailed(this.getName() + " is not capable of DRI " + "connections");
        }
        return n;
    }

    protected int sanityCheck() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("sanityCheck: checking node " + this.getName());
        }
        int n = this.sanityCheckGetConnType();
        boolean bl = false;
        MemberPrefs memberPrefs = this.circuit.getMemberPrefs();
        if (memberPrefs != null && memberPrefs.getDriNodePrefs().size() != 0 && memberPrefs.isBlsrDriNode(this.ne)) {
            switch (n) {
                case 0: 
                case 2: 
                case 4: 
                case 6: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    bl = true;
                    if (this.node.provides(Feature.BLSR_UPSR_DRI)) break;
                    throw new SanityCheckFailed(this.getName() + " is not capable of BLSR DRI " + "connections");
                }
            }
        }
        if (this.circuit.getState() == 0 && this.circuit.getDrops().size() == 2 && ((NetCircuitDropInfo)this.circuit.getDrops().get(0)).getNodeId() != ((NetCircuitDropInfo)this.circuit.getDrops().get(1)).getNodeId() && !this.circuit.hasOmniSpans() && !bl) {
            this.markRoutedUpsrRingFromBridge();
        } else if (this.circuit.getCircuitTypeObj().isLAPCircuitType()) {
            this.markRoutedUpsrRingFromBridge();
        } else if (this.isUpsrSelectorConnType(n)) {
            this.markRoutedUpsrRing();
        }
        return n;
    }

    protected void sanityCheckVlan(int n) throws SanityCheckFailed {
    }

    protected boolean isOpenEndedSelector() {
        return this.isUpsrSelectorConn() && (this.circuit.isBidirectional() && this.drops.size() == 2 || this.sources.size() == 2);
    }

    protected void setupConnListOnDiscovery() {
        NetCircuitEnd[] netCircuitEndArray;
        Object[] objectArray;
        NetCircuitEnd netCircuitEnd = null;
        int n = -1;
        if (this.dbgOn()) {
            db.println("setupConnListOnDiscovery: deconstructing a " + EnumStrings.getString((Class)IConnectionType.class, (int)this.connType) + " on node " + this.getName());
        }
        this.connections.clear();
        try {
            objectArray = this.hasDualConnections() ? ((DualConnectionCircuitNode)this).getPathsFromConnModelExcludeXms() : this.getPathsFromConnModel();
            netCircuitEndArray = new NetCircuitEnd[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                netCircuitEndArray[i] = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[i]);
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            return;
        }
        if (this.drops.size() + this.sources.size() + this.getAllSpansList().size() != objectArray.length) {
            if (this.dbgOn()) {
                db.println("setupConnListOnDiscovery: splicing incomplete");
            }
            return;
        }
        switch (this.connType) {
            case 0: 
            case 9: {
                if (this.isBridgedOneWay(this.connType)) {
                    this.setupConnListOnDiscoveryOfBridge(objectArray, netCircuitEndArray);
                    break;
                }
                OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                this.connections.add(onewayConnection);
                block19: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (i == 0) {
                        if (this.sources.contains(netCircuitEnd)) {
                            onewayConnection.addInput(netCircuitEnd);
                        }
                    } else if (i == 1 && this.drops.contains(netCircuitEnd)) {
                        onewayConnection.addOutput(netCircuitEnd);
                    }
                    if (this.getAllSpansList().isEmpty()) continue;
                    int n2 = this.getEntityIndexFromPathDef(objectArray[i]);
                    Iterator iterator = this.getAllSpansList().iterator();
                    while (iterator.hasNext()) {
                        NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (n2 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                        if (this.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            onewayConnection.addInput(netCircuitSpan);
                            continue block19;
                        }
                        if (i != 1) continue block19;
                        onewayConnection.addOutput(netCircuitSpan);
                        continue block19;
                    }
                }
                break;
            }
            case 1: 
            case 8: 
            case 18: {
                OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                this.connections.add(onewayConnection);
                OnewayConnection onewayConnection2 = new OnewayConnection("oneway2");
                this.connections.add(onewayConnection2);
                block21: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (this.sources.indexOf(netCircuitEnd) != -1) {
                        n = this.sources.indexOf(netCircuitEnd);
                        if (i == 0) {
                            onewayConnection.addInput(this.sources.get(n));
                            onewayConnection2.addOutput(this.sources.get(n));
                            continue;
                        }
                        onewayConnection.addOutput(this.sources.get(n));
                        onewayConnection2.addInput(this.sources.get(n));
                        continue;
                    }
                    if (this.drops.indexOf(netCircuitEnd) != -1) {
                        n = this.drops.indexOf(netCircuitEnd);
                        if (i == 0) {
                            onewayConnection.addInput(this.drops.get(n));
                            onewayConnection2.addOutput(this.drops.get(n));
                            continue;
                        }
                        onewayConnection.addOutput(this.drops.get(n));
                        onewayConnection2.addInput(this.drops.get(n));
                        continue;
                    }
                    int n3 = this.getEntityIndexFromPathDef(objectArray[i]);
                    Iterator iterator = this.getAllSpansList().iterator();
                    while (iterator.hasNext()) {
                        NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (n3 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                        if (this.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            onewayConnection.addInput(netCircuitSpan);
                            onewayConnection2.addOutput(netCircuitSpan);
                            continue block21;
                        }
                        if (i != 1) continue block21;
                        onewayConnection.addOutput(netCircuitSpan);
                        onewayConnection2.addInput(netCircuitSpan);
                        continue block21;
                    }
                }
                break;
            }
            case 6: {
                NetCircuitSpan netCircuitSpan;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                this.connections.add(bridgeConnection);
                BridgeConnection bridgeConnection2 = new BridgeConnection("bridge2");
                this.connections.add(bridgeConnection2);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                block23: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (this.sources.indexOf(netCircuitEnd) != -1) {
                        n = this.sources.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput(this.sources.get(n));
                            bridgeConnection2.addOutput(this.sources.get(n));
                            continue;
                        }
                        bridgeConnection.addOutput(this.sources.get(n));
                        bridgeConnection2.addInput(this.sources.get(n));
                        continue;
                    }
                    if (this.drops.indexOf(netCircuitEnd) != -1) {
                        n = this.drops.indexOf(netCircuitEnd);
                        selectorConnection.addOutput(this.drops.get(n));
                        continue;
                    }
                    int n4 = this.getEntityIndexFromPathDef(objectArray[i]);
                    Iterator iterator = this.getAllSpansList().iterator();
                    while (iterator.hasNext()) {
                        netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (n4 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                        if (this.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            bridgeConnection.addInput(netCircuitSpan);
                            bridgeConnection2.addOutput(netCircuitSpan);
                            continue block23;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan);
                            bridgeConnection2.addInput(netCircuitSpan);
                            continue block23;
                        }
                        selectorConnection.addOutput(netCircuitSpan);
                        continue block23;
                    }
                }
                netCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan);
                selectorConnection.addInput(netCircuitSpan);
                netCircuitSpan = new InternalCircuitSpan(bridgeConnection2, selectorConnection);
                bridgeConnection2.addOutput(netCircuitSpan);
                selectorConnection.addInput(netCircuitSpan);
                break;
            }
            case 7: {
                NetCircuitSpan netCircuitSpan;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                this.connections.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                block25: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (this.sources.indexOf(netCircuitEnd) != -1) {
                        n = this.sources.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput(this.sources.get(n));
                            continue;
                        }
                        selectorConnection.addInput(this.sources.get(n));
                        bridgeConnection.addOutput(this.sources.get(n));
                        continue;
                    }
                    if (this.drops.indexOf(netCircuitEnd) != -1) {
                        n = this.drops.indexOf(netCircuitEnd);
                        selectorConnection.addOutput(this.drops.get(n));
                        continue;
                    }
                    int n5 = this.getEntityIndexFromPathDef(objectArray[i]);
                    Iterator iterator = this.getAllSpansList().iterator();
                    while (iterator.hasNext()) {
                        netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (n5 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                        if (this.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            bridgeConnection.addInput(netCircuitSpan);
                            continue block25;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan);
                            selectorConnection.addInput(netCircuitSpan);
                            continue block25;
                        }
                        selectorConnection.addOutput(netCircuitSpan);
                        continue block25;
                    }
                }
                netCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan);
                selectorConnection.addInput(netCircuitSpan);
                break;
            }
            case 5: {
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                block27: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (this.sources.indexOf(netCircuitEnd) != -1) {
                        n = this.sources.indexOf(netCircuitEnd);
                        if (i == 0) {
                            selectorConnection.addInput(this.sources.get(n));
                            continue;
                        }
                        selectorConnection.addInput(this.sources.get(n));
                        continue;
                    }
                    if (this.drops.indexOf(netCircuitEnd) != -1) {
                        n = this.drops.indexOf(netCircuitEnd);
                        selectorConnection.addOutput(this.drops.get(n));
                        continue;
                    }
                    int n6 = this.getEntityIndexFromPathDef(objectArray[i]);
                    Iterator iterator = this.getAllSpansList().iterator();
                    while (iterator.hasNext()) {
                        NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (n6 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                        if (this.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            selectorConnection.addInput(netCircuitSpan);
                            continue block27;
                        }
                        if (i == 1) {
                            selectorConnection.addInput(netCircuitSpan);
                            continue block27;
                        }
                        selectorConnection.addOutput(netCircuitSpan);
                        continue block27;
                    }
                }
                break;
            }
            case 4: {
                this.setupConnListOnDiscoveryOfBridge(objectArray, netCircuitEndArray);
                break;
            }
            case 2: {
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                this.connections.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                block29: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (this.sources.indexOf(netCircuitEnd) != -1) {
                        n = this.sources.indexOf(netCircuitEnd);
                        if (i == 0 || i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            selectorConnection.addInput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i != 2) continue;
                        bridgeConnection.addInput((NetCircuitEnd)this.sources.get(n));
                        selectorConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                        continue;
                    }
                    if (this.drops.indexOf(netCircuitEnd) != -1) {
                        n = this.drops.indexOf(netCircuitEnd);
                        if (i == 0 || i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            selectorConnection.addInput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i != 2) continue;
                        bridgeConnection.addInput((NetCircuitEnd)this.drops.get(n));
                        selectorConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                        continue;
                    }
                    int n7 = this.getEntityIndexFromPathDef(objectArray[i]);
                    Iterator iterator = this.getAllSpansList().iterator();
                    while (iterator.hasNext()) {
                        NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (n7 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                        if (this.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0 || i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan);
                            selectorConnection.addInput(netCircuitSpan);
                            continue block29;
                        }
                        if (i != 2) continue block29;
                        bridgeConnection.addInput(netCircuitSpan);
                        selectorConnection.addOutput(netCircuitSpan);
                        continue block29;
                    }
                }
                break;
            }
            case 3: {
                SelectorConnection selectorConnection = new SelectorConnection("selector1");
                this.connections.add(selectorConnection);
                SelectorConnection selectorConnection2 = new SelectorConnection("selector2");
                this.connections.add(selectorConnection2);
                block31: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (this.sources.indexOf(netCircuitEnd) != -1) {
                        n = this.sources.indexOf(netCircuitEnd);
                        if (i == 0 || i == 1) {
                            selectorConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            selectorConnection2.addInput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i != 2 && i != 3) continue;
                        selectorConnection.addInput((NetCircuitEnd)this.sources.get(n));
                        selectorConnection2.addOutput((NetCircuitEnd)this.sources.get(n));
                        continue;
                    }
                    if (this.drops.indexOf(netCircuitEnd) != -1) {
                        n = this.drops.indexOf(netCircuitEnd);
                        if (i == 0 || i == 1) {
                            selectorConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            selectorConnection2.addInput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i != 2 && i != 3) continue;
                        selectorConnection.addInput((NetCircuitEnd)this.drops.get(n));
                        selectorConnection2.addOutput((NetCircuitEnd)this.drops.get(n));
                        continue;
                    }
                    int n8 = this.getEntityIndexFromPathDef(objectArray[i]);
                    Iterator iterator = this.getAllSpansList().iterator();
                    while (iterator.hasNext()) {
                        NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (n8 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                        if (this.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0 || i == 1) {
                            selectorConnection.addOutput(netCircuitSpan);
                            selectorConnection2.addInput(netCircuitSpan);
                            continue block31;
                        }
                        if (i != 2 && i != 3) continue block31;
                        selectorConnection.addInput(netCircuitSpan);
                        selectorConnection2.addOutput(netCircuitSpan);
                        continue block31;
                    }
                }
                break;
            }
            case 10: {
                NetCircuitSpan netCircuitSpan;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                this.connections.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                OnewayConnection onewayConnection = new OnewayConnection("oneway");
                this.connections.add(onewayConnection);
                for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (this.sources.indexOf(netCircuitEnd) != -1) {
                        n = this.sources.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput((NetCircuitEnd)this.sources.get(n));
                            onewayConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            selectorConnection.addInput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i != 2) continue;
                        selectorConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                        onewayConnection.addInput((NetCircuitEnd)this.sources.get(n));
                        continue;
                    }
                    if (this.drops.indexOf(netCircuitEnd) != -1) {
                        n = this.drops.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput((NetCircuitEnd)this.drops.get(n));
                            onewayConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            selectorConnection.addInput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i != 2) continue;
                        selectorConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                        onewayConnection.addInput((NetCircuitEnd)this.drops.get(n));
                        continue;
                    }
                    int n9 = this.getEntityIndexFromPathDef(objectArray[i]);
                    Iterator iterator = this.getAllSpansList().iterator();
                    while (iterator.hasNext()) {
                        netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (n9 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                        if (this.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            bridgeConnection.addInput(netCircuitSpan);
                            onewayConnection.addOutput(netCircuitSpan);
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan);
                            selectorConnection.addInput(netCircuitSpan);
                            continue;
                        }
                        if (i != 2) continue;
                        selectorConnection.addOutput(netCircuitSpan);
                        onewayConnection.addInput(netCircuitSpan);
                    }
                }
                netCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan);
                selectorConnection.addInput(netCircuitSpan);
                break;
            }
            case 11: {
                NetCircuitSpan netCircuitSpan;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                this.connections.add(bridgeConnection);
                BridgeConnection bridgeConnection3 = new BridgeConnection("bridge2");
                this.connections.add(bridgeConnection3);
                SelectorConnection selectorConnection = new SelectorConnection("selector1");
                this.connections.add(selectorConnection);
                SelectorConnection selectorConnection3 = new SelectorConnection("selector2");
                this.connections.add(selectorConnection3);
                for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (this.sources.indexOf(netCircuitEnd) != -1) {
                        n = this.sources.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput((NetCircuitEnd)this.sources.get(n));
                            selectorConnection3.addOutput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            selectorConnection.addInput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i == 2) {
                            bridgeConnection3.addInput((NetCircuitEnd)this.sources.get(n));
                            selectorConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i != 3) continue;
                        bridgeConnection3.addOutput((NetCircuitEnd)this.sources.get(n));
                        selectorConnection3.addInput((NetCircuitEnd)this.sources.get(n));
                        continue;
                    }
                    if (this.drops.indexOf(netCircuitEnd) != -1) {
                        n = this.drops.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput((NetCircuitEnd)this.drops.get(n));
                            selectorConnection3.addOutput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            selectorConnection.addInput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i == 2) {
                            bridgeConnection3.addInput((NetCircuitEnd)this.drops.get(n));
                            selectorConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i != 3) continue;
                        bridgeConnection3.addOutput((NetCircuitEnd)this.drops.get(n));
                        selectorConnection3.addInput((NetCircuitEnd)this.drops.get(n));
                        continue;
                    }
                    int n10 = this.getEntityIndexFromPathDef(objectArray[i]);
                    Iterator iterator = this.getAllSpansList().iterator();
                    while (iterator.hasNext()) {
                        netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (n10 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                        if (this.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            bridgeConnection.addInput(netCircuitSpan);
                            selectorConnection3.addOutput(netCircuitSpan);
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan);
                            selectorConnection.addInput(netCircuitSpan);
                            continue;
                        }
                        if (i == 2) {
                            selectorConnection.addOutput(netCircuitSpan);
                            bridgeConnection3.addInput(netCircuitSpan);
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection3.addInput(netCircuitSpan);
                        bridgeConnection3.addOutput(netCircuitSpan);
                    }
                }
                netCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan);
                selectorConnection.addInput(netCircuitSpan);
                netCircuitSpan = new InternalCircuitSpan(bridgeConnection3, selectorConnection3);
                bridgeConnection3.addOutput(netCircuitSpan);
                selectorConnection3.addInput(netCircuitSpan);
                break;
            }
            case 15: {
                NetCircuitSpan netCircuitSpan;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                this.connections.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                block37: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (this.sources.indexOf(netCircuitEnd) != -1) {
                        n = this.sources.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i == 2) {
                            selectorConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection.addInput((NetCircuitEnd)this.sources.get(n));
                        continue;
                    }
                    if (this.drops.indexOf(netCircuitEnd) != -1) {
                        n = this.drops.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection.addInput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i == 2) {
                            selectorConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i == 3) {
                            selectorConnection.addInput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i < 4) continue;
                        selectorConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                        continue;
                    }
                    int n11 = this.getEntityIndexFromPathDef(objectArray[i]);
                    Iterator iterator = this.getAllSpansList().iterator();
                    while (iterator.hasNext()) {
                        netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (n11 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                        if (this.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            bridgeConnection.addInput(netCircuitSpan);
                            continue block37;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan);
                            continue block37;
                        }
                        if (i == 2) {
                            selectorConnection.addOutput(netCircuitSpan);
                            continue block37;
                        }
                        if (i == 3) {
                            selectorConnection.addInput(netCircuitSpan);
                            continue block37;
                        }
                        if (i < 4) continue block37;
                        selectorConnection.addOutput(netCircuitSpan);
                        continue block37;
                    }
                }
                netCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan);
                selectorConnection.addInput(netCircuitSpan);
                break;
            }
            case 16: {
                NetCircuitSpan netCircuitSpan;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                this.connections.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                OnewayConnection onewayConnection = new OnewayConnection("oneway");
                this.connections.add(onewayConnection);
                block39: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (this.sources.indexOf(netCircuitEnd) != -1) {
                        n = this.sources.indexOf(netCircuitEnd);
                        if (i == 0) {
                            onewayConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            bridgeConnection.addInput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i == 1) {
                            onewayConnection.addInput((NetCircuitEnd)this.sources.get(n));
                            bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection.addInput((NetCircuitEnd)this.sources.get(n));
                        continue;
                    }
                    if (this.drops.indexOf(netCircuitEnd) != -1) {
                        n = this.drops.indexOf(netCircuitEnd);
                        if (i == 0) {
                            onewayConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            bridgeConnection.addInput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i == 1) {
                            onewayConnection.addInput((NetCircuitEnd)this.drops.get(n));
                            bridgeConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i == 2) {
                            selectorConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i < 4) continue;
                        selectorConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                        continue;
                    }
                    int n12 = this.getEntityIndexFromPathDef(objectArray[i]);
                    Iterator iterator = this.getAllSpansList().iterator();
                    while (iterator.hasNext()) {
                        netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (n12 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                        if (this.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            onewayConnection.addOutput(netCircuitSpan);
                            bridgeConnection.addInput(netCircuitSpan);
                            continue block39;
                        }
                        if (i == 1) {
                            onewayConnection.addInput(netCircuitSpan);
                            bridgeConnection.addOutput(netCircuitSpan);
                            continue block39;
                        }
                        if (i == 2) {
                            selectorConnection.addOutput(netCircuitSpan);
                            continue block39;
                        }
                        if (i == 3) {
                            selectorConnection.addInput(netCircuitSpan);
                            continue block39;
                        }
                        if (i < 4) continue block39;
                        selectorConnection.addOutput(netCircuitSpan);
                        continue block39;
                    }
                }
                netCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan);
                selectorConnection.addInput(netCircuitSpan);
                break;
            }
            case 13: {
                NetCircuitSpan netCircuitSpan;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                this.connections.add(bridgeConnection);
                BridgeConnection bridgeConnection4 = new BridgeConnection("bridge2");
                this.connections.add(bridgeConnection4);
                SelectorConnection selectorConnection = new SelectorConnection("selector1");
                this.connections.add(selectorConnection);
                SelectorConnection selectorConnection4 = new SelectorConnection("selector2");
                this.connections.add(selectorConnection4);
                block41: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (this.sources.indexOf(netCircuitEnd) != -1) {
                        n = this.sources.indexOf(netCircuitEnd);
                        if (i == 0) {
                            selectorConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            bridgeConnection.addInput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i == 1) {
                            selectorConnection.addInput((NetCircuitEnd)this.sources.get(n));
                            bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i == 2) {
                            bridgeConnection4.addInput((NetCircuitEnd)this.sources.get(n));
                            selectorConnection4.addOutput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection4.addInput((NetCircuitEnd)this.sources.get(n));
                        bridgeConnection4.addOutput((NetCircuitEnd)this.sources.get(n));
                        continue;
                    }
                    if (this.drops.indexOf(netCircuitEnd) != -1) {
                        n = this.drops.indexOf(netCircuitEnd);
                        if (i == 0) {
                            selectorConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            bridgeConnection.addInput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i == 1) {
                            selectorConnection.addInput((NetCircuitEnd)this.drops.get(n));
                            bridgeConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i == 2) {
                            bridgeConnection4.addInput((NetCircuitEnd)this.drops.get(n));
                            selectorConnection4.addOutput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection4.addInput((NetCircuitEnd)this.drops.get(n));
                        bridgeConnection4.addOutput((NetCircuitEnd)this.drops.get(n));
                        continue;
                    }
                    int n13 = this.getEntityIndexFromPathDef(objectArray[i]);
                    Iterator iterator = this.getAllSpansList().iterator();
                    while (iterator.hasNext()) {
                        netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (n13 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                        if (this.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            selectorConnection.addOutput(netCircuitSpan);
                            bridgeConnection.addInput(netCircuitSpan);
                            continue block41;
                        }
                        if (i == 1) {
                            selectorConnection.addInput(netCircuitSpan);
                            bridgeConnection.addOutput(netCircuitSpan);
                            continue block41;
                        }
                        if (i == 2) {
                            bridgeConnection4.addInput(netCircuitSpan);
                            selectorConnection4.addOutput(netCircuitSpan);
                            continue block41;
                        }
                        if (i != 3) continue block41;
                        selectorConnection4.addInput(netCircuitSpan);
                        bridgeConnection4.addOutput(netCircuitSpan);
                        continue block41;
                    }
                }
                netCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection4);
                bridgeConnection.addOutput(netCircuitSpan);
                selectorConnection4.addInput(netCircuitSpan);
                netCircuitSpan = new InternalCircuitSpan(bridgeConnection4, selectorConnection);
                bridgeConnection4.addOutput(netCircuitSpan);
                selectorConnection.addInput(netCircuitSpan);
                break;
            }
            case 14: {
                NetCircuitSpan netCircuitSpan;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                this.connections.add(bridgeConnection);
                BridgeConnection bridgeConnection5 = new BridgeConnection("bridge2");
                this.connections.add(bridgeConnection5);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                block43: for (int i = 0; i < objectArray.length; ++i) {
                    netCircuitEnd = netCircuitEndArray[i];
                    if (this.sources.indexOf(netCircuitEnd) != -1) {
                        n = this.sources.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection5.addOutput((NetCircuitEnd)this.sources.get(n));
                            bridgeConnection.addInput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i == 2) {
                            bridgeConnection5.addInput((NetCircuitEnd)this.sources.get(n));
                            selectorConnection.addOutput((NetCircuitEnd)this.sources.get(n));
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection.addInput((NetCircuitEnd)this.sources.get(n));
                        bridgeConnection5.addOutput((NetCircuitEnd)this.sources.get(n));
                        continue;
                    }
                    if (this.drops.indexOf(netCircuitEnd) != -1) {
                        n = this.drops.indexOf(netCircuitEnd);
                        if (i == 0) {
                            bridgeConnection5.addOutput((NetCircuitEnd)this.drops.get(n));
                            bridgeConnection.addInput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i == 2) {
                            bridgeConnection5.addInput((NetCircuitEnd)this.drops.get(n));
                            selectorConnection.addOutput((NetCircuitEnd)this.drops.get(n));
                            continue;
                        }
                        if (i != 3) continue;
                        selectorConnection.addInput((NetCircuitEnd)this.drops.get(n));
                        bridgeConnection5.addOutput((NetCircuitEnd)this.drops.get(n));
                        continue;
                    }
                    int n14 = this.getEntityIndexFromPathDef(objectArray[i]);
                    Iterator iterator = this.getAllSpansList().iterator();
                    while (iterator.hasNext()) {
                        netCircuitSpan = (NetCircuitSpan)iterator.next();
                        if (n14 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                        if (this.dbgOn()) {
                            db.println("Found span for path def " + netCircuitSpan.prettyString());
                        }
                        if (i == 0) {
                            bridgeConnection5.addOutput(netCircuitSpan);
                            bridgeConnection.addInput(netCircuitSpan);
                            continue block43;
                        }
                        if (i == 1) {
                            bridgeConnection.addOutput(netCircuitSpan);
                            continue block43;
                        }
                        if (i == 2) {
                            bridgeConnection5.addInput(netCircuitSpan);
                            selectorConnection.addOutput(netCircuitSpan);
                            continue block43;
                        }
                        if (i != 3) continue block43;
                        selectorConnection.addInput(netCircuitSpan);
                        bridgeConnection5.addOutput(netCircuitSpan);
                        continue block43;
                    }
                }
                netCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan);
                selectorConnection.addInput(netCircuitSpan);
                break;
            }
            default: {
                if (!this.dbgOn()) break;
                db.println("unknown connection type " + EnumStrings.getString((Class)IConnectionType.class, (int)this.connType));
            }
        }
        this.prettyPrintConnectionList(db);
    }

    protected void setupConnListOnDiscoveryOfBridge(Object[] objectArray, NetCircuitEnd[] netCircuitEndArray) {
        NetCircuitEnd netCircuitEnd = null;
        int n = -1;
        BridgeConnection bridgeConnection = new BridgeConnection("bridge");
        this.connections.add(bridgeConnection);
        for (int i = 0; i < objectArray.length; ++i) {
            netCircuitEnd = netCircuitEndArray[i];
            if (!(this.sources.indexOf(netCircuitEnd) == -1 || bridgeConnection.isInput(netCircuitEnd) && this.drops.contains(netCircuitEnd))) {
                n = this.sources.indexOf(netCircuitEnd);
                bridgeConnection.addInput(this.sources.get(n));
                continue;
            }
            if (this.drops.indexOf(netCircuitEnd) != -1) {
                n = this.drops.indexOf(netCircuitEnd);
                bridgeConnection.addOutput(this.drops.get(n));
                continue;
            }
            int n2 = this.getEntityIndexFromPathDef(objectArray[i]);
            Iterator iterator = this.getAllSpansList().iterator();
            while (iterator.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                if (n2 != netCircuitSpan.getEntityIndex(this.getNetElement()) || !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
                if (this.dbgOn()) {
                    db.println("Found span for path def " + netCircuitSpan.prettyString());
                }
                if (this.connType == 4 && i == 2 || (this.connType == 0 || this.connType == 9) && i == 0) {
                    bridgeConnection.addInput(netCircuitSpan);
                    continue;
                }
                bridgeConnection.addOutput(netCircuitSpan);
            }
        }
    }

    protected void setupConnList(int n) {
        if (this.state == 0) {
            this.setupConnListOnCreation(n);
        } else if (this.state == 3) {
            if (this.connType != n) {
                this.setupConnListOnCreation(n);
            } else {
                this.addRoutedOutputsToConnList(n);
            }
        }
    }

    protected void addRoutedOutputsToConnList(int n) {
        BridgeConnection[] bridgeConnectionArray = new BridgeConnection[3];
        SelectorConnection[] selectorConnectionArray = new SelectorConnection[3];
        OnewayConnection[] onewayConnectionArray = new OnewayConnection[3];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.dbgOn()) {
            this.debug("addRoutedOutputsToConnList: deconstructing a " + EnumStrings.getString((Class)IConnectionType.class, (int)n) + " on node " + this.getName());
        }
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (connection instanceof BridgeConnection) {
                bridgeConnectionArray[n2++] = (BridgeConnection)connection;
                continue;
            }
            if (connection instanceof SelectorConnection) {
                selectorConnectionArray[n3++] = (SelectorConnection)connection;
                continue;
            }
            if (!(connection instanceof OnewayConnection)) continue;
            onewayConnectionArray[n4++] = (OnewayConnection)connection;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getRoutedOrigSpans());
        arrayList.addAll(this.getRoutedDrops());
        switch (n) {
            case 0: 
            case 9: {
                if (n4 == 1) {
                    bridgeConnectionArray[0] = new BridgeConnection("bridge");
                    n2 = 1;
                    bridgeConnectionArray[0].addInput(onewayConnectionArray[0].getInputs().get(0));
                    bridgeConnectionArray[0].addOutput(onewayConnectionArray[0].getOutputs().get(0));
                    this.connections.remove(onewayConnectionArray[0]);
                    this.connections.add(bridgeConnectionArray[0]);
                }
                if (n2 != 1) break;
                for (int i = 0; i < arrayList.size(); ++i) {
                    bridgeConnectionArray[0].addOutput(arrayList.get(i));
                }
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 15: 
            case 16: {
                if (n3 != 1) break;
                for (int i = 0; i < arrayList.size(); ++i) {
                    selectorConnectionArray[0].addOutput(arrayList.get(i));
                }
                break;
            }
        }
        this.prettyPrintConnectionList(db);
    }

    protected void removeOutputFromConnList(Object object) {
        if (this.dbgOn()) {
            this.debug("removeOutputFromConnList: called for a " + EnumStrings.getString((Class)IConnectionType.class, (int)this.connType) + " on node " + this.getName());
        }
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            List list = connection.getOutputs();
            int n = list.size();
            if (!list.contains(object)) continue;
            connection.removeOutput(object);
            if (--n != 1 || !(connection instanceof BridgeConnection)) break;
            OnewayConnection onewayConnection = new OnewayConnection("oneway");
            onewayConnection.addInput(connection.getInputs().get(0));
            onewayConnection.addOutput(connection.getOutputs().get(0));
            iterator.remove();
            this.connections.add(onewayConnection);
            break;
        }
        this.prettyPrintConnectionList(db);
    }

    protected void setupConnListOnCreation() {
        if (this.state == 2) {
            this.setupConnListOnCreation(this.connType);
        } else {
            int n = this.findConnType();
            this.setConnectionType(n);
            this.setupConnListOnCreation(n);
        }
    }

    protected void setupConnListOnCreation(int n) {
        this.connections.clear();
        if (this.dbgOn()) {
            db.println("setupConnListOnCreation: deconstructing a " + EnumStrings.getString((Class)IConnectionType.class, (int)n) + " on node " + this.getName());
        }
        switch (n) {
            case 0: 
            case 4: 
            case 9: {
                if (this.isBridgedOneWay(n)) {
                    int n2;
                    BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                    this.connections.add(bridgeConnection);
                    if (this.sources.size() == 1) {
                        bridgeConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    } else if (this.getTermSpans().size() == 1) {
                        bridgeConnection.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                    }
                    LinkedList linkedList = this.getOrigSpans();
                    for (n2 = 0; n2 < linkedList.size(); ++n2) {
                        bridgeConnection.addOutput((NetCircuitSpan)linkedList.get(n2));
                    }
                    for (n2 = 0; n2 < this.drops.size(); ++n2) {
                        bridgeConnection.addOutput((NetCircuitEnd)this.drops.get(n2));
                    }
                    linkedList = this.getOmniSpans();
                    for (n2 = 0; n2 < linkedList.size(); ++n2) {
                        bridgeConnection.addOutput((NetCircuitSpan)linkedList.get(n2));
                    }
                    break;
                }
                OnewayConnection onewayConnection = new OnewayConnection("oneway");
                this.connections.add(onewayConnection);
                if (this.getTermSpans().size() == 1) {
                    onewayConnection.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                } else if (this.sources.size() == 1) {
                    onewayConnection.addInput((NetCircuitEnd)this.sources.get(0));
                }
                if (this.getOrigSpans().size() == 1) {
                    onewayConnection.addOutput((NetCircuitSpan)this.getOrigSpans().get(0));
                    break;
                }
                if (this.drops.size() != 1) break;
                onewayConnection.addOutput((NetCircuitEnd)this.drops.get(0));
                break;
            }
            case 1: 
            case 8: 
            case 18: {
                OnewayConnection onewayConnection = new OnewayConnection("oneway1");
                this.connections.add(onewayConnection);
                OnewayConnection onewayConnection2 = new OnewayConnection("oneway2");
                this.connections.add(onewayConnection2);
                if (this.biSpans.size() == 2) {
                    onewayConnection.addInput((NetCircuitSpan)this.biSpans.get(0));
                    onewayConnection.addOutput((NetCircuitSpan)this.biSpans.get(1));
                    onewayConnection2.addInput((NetCircuitSpan)this.biSpans.get(1));
                    onewayConnection2.addOutput((NetCircuitSpan)this.biSpans.get(0));
                    break;
                }
                if (this.sources.size() == 1 && this.drops.size() == 1) {
                    onewayConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    onewayConnection.addOutput((NetCircuitEnd)this.drops.get(0));
                    onewayConnection2.addInput((NetCircuitEnd)this.drops.get(0));
                    onewayConnection2.addOutput((NetCircuitEnd)this.sources.get(0));
                    break;
                }
                if (this.biSpans.size() != 1) break;
                onewayConnection.addInput((NetCircuitSpan)this.biSpans.get(0));
                onewayConnection2.addOutput((NetCircuitSpan)this.biSpans.get(0));
                if (this.sources.size() == 1) {
                    onewayConnection.addOutput((NetCircuitEnd)this.sources.get(0));
                    onewayConnection2.addInput((NetCircuitEnd)this.sources.get(0));
                }
                if (this.drops.size() != 1) break;
                onewayConnection.addOutput((NetCircuitEnd)this.drops.get(0));
                onewayConnection2.addInput((NetCircuitEnd)this.drops.get(0));
                break;
            }
            case 6: {
                int n3;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                this.connections.add(bridgeConnection);
                BridgeConnection bridgeConnection2 = new BridgeConnection("bridge2");
                this.connections.add(bridgeConnection2);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                if (this.biSpans.size() == 2) {
                    bridgeConnection.addInput((NetCircuitSpan)this.biSpans.get(0));
                    bridgeConnection2.addInput((NetCircuitSpan)this.biSpans.get(1));
                    bridgeConnection.addOutput((NetCircuitSpan)this.biSpans.get(1));
                    bridgeConnection2.addOutput((NetCircuitSpan)this.biSpans.get(0));
                } else if (this.inSpans.size() == 2) {
                    bridgeConnection.addInput((NetCircuitSpan)this.inSpans.get(0));
                    bridgeConnection2.addInput((NetCircuitSpan)this.inSpans.get(1));
                    bridgeConnection.addOutput((NetCircuitSpan)this.inSpans.get(1));
                    bridgeConnection2.addOutput((NetCircuitSpan)this.inSpans.get(0));
                } else if (this.inSpans.size() == 1 && this.sources.size() == 1) {
                    bridgeConnection.addInput((NetCircuitSpan)this.inSpans.get(0));
                    bridgeConnection2.addInput((NetCircuitEnd)this.sources.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(0));
                    bridgeConnection2.addOutput((NetCircuitSpan)this.inSpans.get(0));
                } else if (this.biSpans.size() == 1 && this.sources.size() == 1) {
                    bridgeConnection.addInput((NetCircuitSpan)this.biSpans.get(0));
                    bridgeConnection2.addInput((NetCircuitEnd)this.sources.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(0));
                    bridgeConnection2.addOutput((NetCircuitSpan)this.biSpans.get(0));
                } else if (this.biSpans.size() == 0 && this.sources.size() == 2) {
                    bridgeConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    bridgeConnection2.addInput((NetCircuitEnd)this.sources.get(1));
                    bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(1));
                    bridgeConnection2.addOutput((NetCircuitEnd)this.sources.get(0));
                } else if (this.inSpans.size() == 1 && this.getOmniSpans().size() == 1) {
                    bridgeConnection.addInput((NetCircuitSpan)this.inSpans.get(0));
                    bridgeConnection2.addInput((NetCircuitSpan)this.getOmniSpans().get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)this.getOmniSpans().get(0));
                    bridgeConnection2.addOutput((NetCircuitSpan)this.inSpans.get(0));
                } else if (this.dbgOn()) {
                    db.println("ERROR! UPSR_DC with invalid inputs");
                }
                for (n3 = 0; n3 < this.outSpans.size(); ++n3) {
                    selectorConnection.addOutput((NetCircuitSpan)this.outSpans.get(n3));
                }
                for (n3 = 0; n3 < this.drops.size(); ++n3) {
                    selectorConnection.addOutput((NetCircuitEnd)this.drops.get(n3));
                }
                InternalCircuitSpan internalCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                internalCircuitSpan = new InternalCircuitSpan(bridgeConnection2, selectorConnection);
                bridgeConnection2.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                break;
            }
            case 7: {
                int n4;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                this.connections.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                if (this.biSpans.size() == 1 && this.sources.size() == 1) {
                    bridgeConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection.addInput((NetCircuitSpan)this.biSpans.get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)this.biSpans.get(0));
                } else if (this.biSpans.size() == 1 && this.inSpans.size() == 1) {
                    bridgeConnection.addInput((NetCircuitSpan)this.inSpans.get(0));
                    selectorConnection.addInput((NetCircuitSpan)this.biSpans.get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)this.biSpans.get(0));
                } else if (this.biSpans.size() == 0 && this.sources.size() == 2) {
                    bridgeConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection.addInput((NetCircuitEnd)this.sources.get(1));
                    bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(1));
                } else if (this.dbgOn()) {
                    db.println("ERROR! UPSR_EN with invalid inputs");
                }
                for (n4 = 0; n4 < this.outSpans.size(); ++n4) {
                    selectorConnection.addOutput((NetCircuitSpan)this.outSpans.get(n4));
                }
                for (n4 = 0; n4 < this.drops.size(); ++n4) {
                    selectorConnection.addOutput((NetCircuitEnd)this.drops.get(n4));
                }
                InternalCircuitSpan internalCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                break;
            }
            case 5: {
                int n5;
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                if (this.sources.size() == 1 && this.inSpans.size() == 1) {
                    selectorConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection.addInput((NetCircuitSpan)this.inSpans.get(0));
                } else if (this.sources.size() == 0 && this.inSpans.size() == 2) {
                    selectorConnection.addInput((NetCircuitSpan)this.inSpans.get(0));
                    selectorConnection.addInput((NetCircuitSpan)this.inSpans.get(1));
                } else if (this.sources.size() == 2 && this.inSpans.size() == 0) {
                    selectorConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection.addInput((NetCircuitEnd)this.sources.get(1));
                } else if (this.dbgOn()) {
                    db.println("ERROR! UPSR_DROP with invalid inputs");
                }
                for (n5 = 0; n5 < this.outSpans.size(); ++n5) {
                    selectorConnection.addOutput((NetCircuitSpan)this.outSpans.get(n5));
                }
                for (n5 = 0; n5 < this.drops.size(); ++n5) {
                    selectorConnection.addOutput((NetCircuitEnd)this.drops.get(n5));
                }
                break;
            }
            case 2: {
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                this.connections.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                if (this.sources.size() == 2) {
                    bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(1));
                    selectorConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection.addInput((NetCircuitEnd)this.sources.get(1));
                } else if (this.sources.size() == 1 && this.getTermSpans().size() == 1) {
                    bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)this.getTermSpans().get(0));
                    selectorConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                } else if (this.getTermSpans().size() == 2) {
                    bridgeConnection.addOutput((NetCircuitSpan)this.getTermSpans().get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)this.getTermSpans().get(1));
                    selectorConnection.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                    selectorConnection.addInput((NetCircuitSpan)this.getTermSpans().get(1));
                } else if (this.sources.size() == 1 && this.getTermSpans().size() == 0) {
                    bridgeConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection.addOutput((NetCircuitEnd)this.sources.get(0));
                } else if (this.sources.size() == 0 && this.getTermSpans().size() == 1) {
                    bridgeConnection.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                    selectorConnection.addOutput((NetCircuitSpan)this.getTermSpans().get(0));
                }
                if (this.drops.size() == 2) {
                    bridgeConnection.addOutput((NetCircuitEnd)this.drops.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)this.drops.get(1));
                    selectorConnection.addInput((NetCircuitEnd)this.drops.get(0));
                    selectorConnection.addInput((NetCircuitEnd)this.drops.get(1));
                }
                if (this.drops.size() == 1 && this.getOrigSpans().size() == 1) {
                    bridgeConnection.addOutput((NetCircuitEnd)this.drops.get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)this.getOrigSpans().get(0));
                    selectorConnection.addInput((NetCircuitEnd)this.drops.get(0));
                    selectorConnection.addInput((NetCircuitSpan)this.getOrigSpans().get(0));
                    break;
                }
                if (this.getOrigSpans().size() == 2) {
                    bridgeConnection.addOutput((NetCircuitSpan)this.getOrigSpans().get(0));
                    bridgeConnection.addOutput((NetCircuitSpan)this.getOrigSpans().get(1));
                    selectorConnection.addInput((NetCircuitSpan)this.getOrigSpans().get(0));
                    selectorConnection.addInput((NetCircuitSpan)this.getOrigSpans().get(1));
                    break;
                }
                if (this.getOrigSpans().size() == 1 && this.drops.size() == 0) {
                    bridgeConnection.addInput((NetCircuitSpan)this.getOrigSpans().get(0));
                    selectorConnection.addOutput((NetCircuitSpan)this.getOrigSpans().get(0));
                    break;
                }
                if (this.getOrigSpans().size() != 0 || this.drops.size() != 1) break;
                bridgeConnection.addInput((NetCircuitEnd)this.drops.get(0));
                selectorConnection.addOutput((NetCircuitEnd)this.drops().get(0));
                break;
            }
            case 3: {
                SelectorConnection selectorConnection = new SelectorConnection("selector1");
                this.connections.add(selectorConnection);
                SelectorConnection selectorConnection2 = new SelectorConnection("selector2");
                this.connections.add(selectorConnection2);
                if (this.sources.size() == 2) {
                    selectorConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection.addInput((NetCircuitEnd)this.sources.get(1));
                    selectorConnection2.addOutput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection2.addOutput((NetCircuitEnd)this.sources.get(1));
                } else if (this.sources.size() == 1 && this.getTermSpans().size() == 1) {
                    selectorConnection.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                    selectorConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection2.addOutput((NetCircuitSpan)this.getTermSpans().get(0));
                    selectorConnection2.addOutput((NetCircuitEnd)this.sources.get(0));
                } else if (this.getTermSpans().size() == 2) {
                    selectorConnection.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                    selectorConnection.addInput((NetCircuitSpan)this.getTermSpans().get(1));
                    selectorConnection2.addOutput((NetCircuitSpan)this.getTermSpans().get(0));
                    selectorConnection2.addOutput((NetCircuitSpan)this.getTermSpans().get(1));
                }
                if (this.drops.size() == 2) {
                    selectorConnection2.addInput((NetCircuitEnd)this.drops.get(0));
                    selectorConnection2.addInput((NetCircuitEnd)this.drops.get(1));
                    selectorConnection.addOutput((NetCircuitEnd)this.drops.get(0));
                    selectorConnection.addOutput((NetCircuitEnd)this.drops.get(1));
                    break;
                }
                if (this.drops.size() == 1 && this.getOrigSpans().size() == 1) {
                    selectorConnection2.addInput((NetCircuitSpan)this.getOrigSpans().get(0));
                    selectorConnection2.addInput((NetCircuitEnd)this.drops.get(0));
                    selectorConnection.addOutput((NetCircuitSpan)this.getOrigSpans().get(0));
                    selectorConnection.addOutput((NetCircuitEnd)this.drops.get(0));
                    break;
                }
                if (this.getOrigSpans().size() != 2) break;
                selectorConnection2.addInput((NetCircuitSpan)this.getOrigSpans().get(0));
                selectorConnection2.addInput((NetCircuitSpan)this.getOrigSpans().get(1));
                selectorConnection.addOutput((NetCircuitSpan)this.getOrigSpans().get(0));
                selectorConnection.addOutput((NetCircuitSpan)this.getOrigSpans().get(1));
                break;
            }
            case 10: {
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                this.connections.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                OnewayConnection onewayConnection = new OnewayConnection("oneway");
                this.connections.add(onewayConnection);
                if (this.sources.size() == 2) {
                    bridgeConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    onewayConnection.addOutput((NetCircuitEnd)this.sources.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(1));
                    selectorConnection.addInput((NetCircuitEnd)this.sources.get(1));
                    if (this.drops.size() == 1) {
                        onewayConnection.addInput((NetCircuitEnd)this.drops.get(0));
                        selectorConnection.addOutput((NetCircuitEnd)this.drops.get(1));
                    }
                } else if (this.sources.size() == 1) {
                    onewayConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection.addOutput((NetCircuitEnd)this.sources.get(0));
                    if (this.getOmniSpans().size() == 1) {
                        bridgeConnection.addOutput((NetCircuitSpan)this.getOmniSpans().get(0));
                        selectorConnection.addInput((NetCircuitSpan)this.getOmniSpans().get(0));
                    }
                    if (this.getOrigSpans().size() == 1) {
                        bridgeConnection.addInput((NetCircuitSpan)this.getOrigSpans().get(0));
                        onewayConnection.addOutput((NetCircuitSpan)this.getOrigSpans().get(0));
                    }
                } else if (this.drops.size() == 1) {
                    onewayConnection.addInput((NetCircuitEnd)this.drops.get(0));
                    selectorConnection.addOutput((NetCircuitEnd)this.drops.get(0));
                    if (this.getOmniSpans().size() == 1) {
                        bridgeConnection.addOutput((NetCircuitSpan)this.getOmniSpans().get(0));
                        selectorConnection.addInput((NetCircuitSpan)this.getOmniSpans().get(0));
                    }
                    if (this.getTermSpans().size() == 1) {
                        bridgeConnection.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                        onewayConnection.addOutput((NetCircuitSpan)this.getTermSpans().get(0));
                    }
                } else {
                    LinkedList linkedList = this.getOrigSpans();
                    LinkedList linkedList2 = this.getTermSpans();
                    LinkedList linkedList3 = this.getOmniSpans();
                    if (linkedList.size() == 1 && linkedList2.size() == 1 && linkedList3.size() == 1) {
                        NetCircuitSpan netCircuitSpan;
                        NetCircuitSpan netCircuitSpan2;
                        NetCircuitSpan netCircuitSpan3 = (NetCircuitSpan)linkedList.get(0);
                        NetCircuitSpan netCircuitSpan4 = (NetCircuitSpan)linkedList2.get(0);
                        NetCircuitSpan netCircuitSpan5 = (NetCircuitSpan)linkedList3.get(0);
                        NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan3);
                        NetCircuitNode netCircuitNode2 = this.spanGetPeer(netCircuitSpan4);
                        if (netCircuitNode == null || netCircuitNode2 == null) break;
                        if (this.isBlsrDriHandoff()) {
                            if (netCircuitSpan3.isLineProtected() || netCircuitSpan3.isPca()) {
                                netCircuitSpan2 = netCircuitSpan4;
                                netCircuitSpan = netCircuitSpan3;
                            } else {
                                netCircuitSpan2 = netCircuitSpan3;
                                netCircuitSpan = netCircuitSpan4;
                            }
                        } else if (netCircuitNode.isBlsrDriHandoff()) {
                            netCircuitSpan2 = netCircuitSpan4;
                            netCircuitSpan = netCircuitSpan3;
                        } else if (netCircuitNode2.isBlsrDriHandoff()) {
                            netCircuitSpan2 = netCircuitSpan3;
                            netCircuitSpan = netCircuitSpan4;
                        } else if (netCircuitSpan5.getNetLinkSpan().getSourceRing()) {
                            netCircuitSpan2 = netCircuitSpan4;
                            netCircuitSpan = netCircuitSpan3;
                        } else {
                            netCircuitSpan2 = netCircuitSpan3;
                            netCircuitSpan = netCircuitSpan4;
                        }
                        selectorConnection.addOutput(netCircuitSpan);
                        onewayConnection.addInput(netCircuitSpan);
                        bridgeConnection.addInput(netCircuitSpan2);
                        onewayConnection.addOutput(netCircuitSpan2);
                        bridgeConnection.addOutput(netCircuitSpan5);
                        selectorConnection.addInput(netCircuitSpan5);
                    }
                }
                InternalCircuitSpan internalCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                break;
            }
            case 11: {
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                this.connections.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector1");
                this.connections.add(selectorConnection);
                BridgeConnection bridgeConnection3 = new BridgeConnection("bridge2");
                this.connections.add(bridgeConnection3);
                SelectorConnection selectorConnection3 = new SelectorConnection("selector2");
                this.connections.add(selectorConnection3);
                if (this.sources.size() == 2) {
                    bridgeConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection3.addOutput((NetCircuitEnd)this.sources.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(1));
                    selectorConnection.addInput((NetCircuitEnd)this.sources.get(1));
                    if (this.drops.size() == 2) {
                        bridgeConnection3.addInput((NetCircuitEnd)this.drops.get(0));
                        selectorConnection.addOutput((NetCircuitEnd)this.drops.get(0));
                        bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(1));
                        selectorConnection.addInput((NetCircuitEnd)this.sources.get(1));
                    }
                } else {
                    if (this.getTermSpans().size() == 1) {
                        bridgeConnection.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                        selectorConnection3.addOutput((NetCircuitSpan)this.getTermSpans().get(0));
                    }
                    if (this.getOmniSpans().size() == 2) {
                        if (((NetCircuitSpan)this.getOmniSpans().get(0)).getNetLinkSpan().getSourceRing()) {
                            bridgeConnection.addOutput((NetCircuitSpan)this.getOmniSpans().get(0));
                            selectorConnection.addInput((NetCircuitSpan)this.getOmniSpans().get(0));
                            bridgeConnection3.addOutput((NetCircuitSpan)this.getOmniSpans().get(1));
                            selectorConnection3.addInput((NetCircuitSpan)this.getOmniSpans().get(1));
                        } else {
                            bridgeConnection.addOutput((NetCircuitSpan)this.getOmniSpans().get(1));
                            selectorConnection.addInput((NetCircuitSpan)this.getOmniSpans().get(1));
                            bridgeConnection3.addOutput((NetCircuitSpan)this.getOmniSpans().get(0));
                            selectorConnection3.addInput((NetCircuitSpan)this.getOmniSpans().get(0));
                        }
                    }
                    if (this.getOrigSpans().size() == 1) {
                        selectorConnection.addOutput((NetCircuitSpan)this.getOrigSpans().get(0));
                        bridgeConnection3.addInput((NetCircuitSpan)this.getOrigSpans().get(0));
                    }
                }
                InternalCircuitSpan internalCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                internalCircuitSpan = new InternalCircuitSpan(bridgeConnection3, selectorConnection3);
                bridgeConnection3.addOutput(internalCircuitSpan);
                selectorConnection3.addInput(internalCircuitSpan);
                break;
            }
            case 15: {
                NetCircuitSpan netCircuitSpan;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                this.connections.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                if (this.sources.size() == 2) {
                    bridgeConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection.addInput((NetCircuitEnd)this.sources.get(1));
                } else if (this.sources.size() == 1) {
                    netCircuitSpan = (NetCircuitSpan)this.getTermSpans().get(0);
                    NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.sources.get(0);
                    if (netCircuitSpan.getBlsrDriInterConnect()) {
                        bridgeConnection.addInput(netCircuitEnd);
                        selectorConnection.addInput(netCircuitSpan);
                    } else {
                        bridgeConnection.addInput(netCircuitSpan);
                        selectorConnection.addInput(netCircuitEnd);
                    }
                } else {
                    NetCircuitSpan netCircuitSpan6 = (NetCircuitSpan)this.getTermSpans().get(0);
                    NetCircuitSpan netCircuitSpan7 = (NetCircuitSpan)this.getTermSpans().get(1);
                    if (netCircuitSpan6.getBlsrDriInterConnect()) {
                        bridgeConnection.addInput(netCircuitSpan7);
                        selectorConnection.addInput(netCircuitSpan6);
                    } else {
                        bridgeConnection.addInput(netCircuitSpan6);
                        selectorConnection.addInput(netCircuitSpan7);
                    }
                }
                List list = this.getDrops();
                LinkedList linkedList = this.getOrigSpans();
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    netCircuitSpan = (NetCircuitSpan)iterator.next();
                    if (!netCircuitSpan.getBlsrDriInterConnect()) continue;
                    linkedList.remove(netCircuitSpan);
                    bridgeConnection.addOutput(netCircuitSpan);
                    break;
                }
                iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    netCircuitSpan = (NetCircuitSpan)iterator.next();
                    selectorConnection.addOutput(netCircuitSpan);
                }
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                    selectorConnection.addOutput(netCircuitEnd);
                }
                netCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan);
                selectorConnection.addInput(netCircuitSpan);
                break;
            }
            case 16: {
                NetCircuitEnd netCircuitEnd;
                NetCircuitSpan netCircuitSpan;
                BridgeConnection bridgeConnection = new BridgeConnection("bridge");
                this.connections.add(bridgeConnection);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                OnewayConnection onewayConnection = new OnewayConnection("oneway");
                this.connections.add(onewayConnection);
                if (this.sources.size() == 2) {
                    NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)this.sources.get(0);
                    NetCircuitEnd netCircuitEnd3 = (NetCircuitEnd)this.sources.get(1);
                    bridgeConnection.addInput(netCircuitEnd2);
                    onewayConnection.addOutput(netCircuitEnd2);
                    selectorConnection.addInput(netCircuitEnd3);
                } else if (this.sources.size() == 1 && this.getTermSpans().size() == 1) {
                    netCircuitSpan = (NetCircuitSpan)this.getTermSpans().get(0);
                    NetCircuitEnd netCircuitEnd4 = (NetCircuitEnd)this.sources.get(0);
                    if (netCircuitSpan.getBlsrDriInterConnect()) {
                        bridgeConnection.addInput(netCircuitEnd4);
                        onewayConnection.addOutput(netCircuitEnd4);
                        selectorConnection.addInput(netCircuitSpan);
                    } else {
                        bridgeConnection.addInput(netCircuitSpan);
                        onewayConnection.addOutput(netCircuitSpan);
                        selectorConnection.addInput(netCircuitEnd4);
                    }
                } else if (this.getTermSpans().size() == 2) {
                    NetCircuitSpan netCircuitSpan8 = (NetCircuitSpan)this.getTermSpans().get(0);
                    NetCircuitSpan netCircuitSpan9 = (NetCircuitSpan)this.getTermSpans().get(1);
                    if (netCircuitSpan8.getBlsrDriInterConnect()) {
                        bridgeConnection.addInput(netCircuitSpan9);
                        onewayConnection.addOutput(netCircuitSpan9);
                        selectorConnection.addInput(netCircuitSpan8);
                    } else {
                        bridgeConnection.addInput(netCircuitSpan8);
                        onewayConnection.addOutput(netCircuitSpan8);
                        selectorConnection.addInput(netCircuitSpan9);
                    }
                }
                List list = this.getDrops();
                if (this.getOmniSpans().size() == 1) {
                    netCircuitSpan = (NetCircuitSpan)this.getOmniSpans().get(0);
                    onewayConnection.addInput(netCircuitSpan);
                    bridgeConnection.addOutput(netCircuitSpan);
                } else if (list.size() > 1) {
                    netCircuitEnd = (NetCircuitEnd)list.remove(1);
                    onewayConnection.addInput(netCircuitEnd);
                    bridgeConnection.addOutput(netCircuitEnd);
                }
                Iterator iterator = this.getOrigSpans().iterator();
                while (iterator.hasNext()) {
                    netCircuitSpan = (NetCircuitSpan)iterator.next();
                    selectorConnection.addOutput(netCircuitSpan);
                }
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    netCircuitEnd = (NetCircuitEnd)iterator.next();
                    selectorConnection.addOutput(netCircuitEnd);
                }
                netCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(netCircuitSpan);
                selectorConnection.addInput(netCircuitSpan);
                break;
            }
            case 13: {
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                this.connections.add(bridgeConnection);
                BridgeConnection bridgeConnection4 = new BridgeConnection("bridge2");
                this.connections.add(bridgeConnection4);
                SelectorConnection selectorConnection = new SelectorConnection("selector1");
                this.connections.add(selectorConnection);
                SelectorConnection selectorConnection4 = new SelectorConnection("selector2");
                this.connections.add(selectorConnection4);
                if (this.getTermSpans().size() == 2) {
                    if (((NetCircuitSpan)this.getTermSpans().get(0)).getBlsrDriInterConnect()) {
                        bridgeConnection.addInput((NetCircuitSpan)this.getTermSpans().get(1));
                        bridgeConnection4.addOutput((NetCircuitSpan)this.getTermSpans().get(0));
                        selectorConnection.addOutput((NetCircuitSpan)this.getTermSpans().get(1));
                        selectorConnection4.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                    } else {
                        bridgeConnection.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                        bridgeConnection4.addOutput((NetCircuitSpan)this.getTermSpans().get(1));
                        selectorConnection.addOutput((NetCircuitSpan)this.getTermSpans().get(0));
                        selectorConnection4.addInput((NetCircuitSpan)this.getTermSpans().get(1));
                    }
                } else if (this.getTermSpans().size() == 1 && this.sources.size() == 1) {
                    if (((NetCircuitSpan)this.getTermSpans().get(0)).getBlsrDriInterConnect()) {
                        bridgeConnection.addInput((NetCircuitEnd)this.sources.get(0));
                        bridgeConnection4.addOutput((NetCircuitSpan)this.getTermSpans().get(0));
                        selectorConnection.addOutput((NetCircuitEnd)this.sources.get(0));
                        selectorConnection4.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                    } else {
                        bridgeConnection.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                        bridgeConnection4.addOutput((NetCircuitEnd)this.sources.get(0));
                        selectorConnection.addOutput((NetCircuitSpan)this.getTermSpans().get(0));
                        selectorConnection4.addInput((NetCircuitEnd)this.sources.get(0));
                    }
                } else if (this.sources.size() >= 2) {
                    bridgeConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    bridgeConnection4.addOutput((NetCircuitEnd)this.sources.get(1));
                    selectorConnection.addOutput((NetCircuitEnd)this.sources.get(0));
                    selectorConnection4.addInput((NetCircuitEnd)this.sources.get(1));
                }
                LinkedList linkedList = this.getOrigSpans();
                if (linkedList.size() >= 2) {
                    if (((NetCircuitSpan)linkedList.get(0)).getBlsrDriInterConnect()) {
                        bridgeConnection.addOutput((NetCircuitSpan)linkedList.get(0));
                        bridgeConnection4.addInput((NetCircuitSpan)linkedList.get(1));
                        selectorConnection.addInput((NetCircuitSpan)linkedList.get(0));
                        selectorConnection4.addOutput((NetCircuitSpan)linkedList.get(1));
                    } else {
                        bridgeConnection.addOutput((NetCircuitSpan)linkedList.get(1));
                        bridgeConnection4.addInput((NetCircuitSpan)linkedList.get(0));
                        selectorConnection.addInput((NetCircuitSpan)linkedList.get(1));
                        selectorConnection4.addOutput((NetCircuitSpan)linkedList.get(0));
                    }
                }
                InternalCircuitSpan internalCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection4);
                bridgeConnection.addOutput(internalCircuitSpan);
                selectorConnection4.addInput(internalCircuitSpan);
                internalCircuitSpan = new InternalCircuitSpan(bridgeConnection4, selectorConnection);
                bridgeConnection4.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                break;
            }
            case 14: {
                BridgeConnection bridgeConnection = new BridgeConnection("bridge1");
                this.connections.add(bridgeConnection);
                BridgeConnection bridgeConnection5 = new BridgeConnection("bridge2");
                this.connections.add(bridgeConnection5);
                SelectorConnection selectorConnection = new SelectorConnection("selector");
                this.connections.add(selectorConnection);
                if (this.getTermSpans().size() == 2 && this.getOrigSpans().size() == 1 && this.getOmniSpans().size() == 1) {
                    if (((NetCircuitSpan)this.getTermSpans().get(0)).getBlsrDriInterConnect()) {
                        bridgeConnection.addInput((NetCircuitSpan)this.getTermSpans().get(1));
                        selectorConnection.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                    } else {
                        bridgeConnection.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                        selectorConnection.addInput((NetCircuitSpan)this.getTermSpans().get(1));
                    }
                    bridgeConnection5.addOutput((NetCircuitSpan)this.getTermSpans().get(0));
                    bridgeConnection5.addOutput((NetCircuitSpan)this.getTermSpans().get(1));
                    bridgeConnection.addOutput((NetCircuitSpan)this.getOmniSpans().get(0));
                    bridgeConnection5.addInput((NetCircuitSpan)this.getOrigSpans().get(0));
                    selectorConnection.addOutput((NetCircuitSpan)this.getOrigSpans().get(0));
                } else if (this.getTermSpans().size() == 1 && this.getOrigSpans().size() == 2 && this.getOmniSpans().size() == 1) {
                    if (((NetCircuitSpan)this.getOrigSpans().get(0)).getBlsrDriInterConnect()) {
                        bridgeConnection.addInput((NetCircuitSpan)this.getOrigSpans().get(1));
                        selectorConnection.addInput((NetCircuitSpan)this.getOrigSpans().get(0));
                    } else {
                        bridgeConnection.addInput((NetCircuitSpan)this.getOrigSpans().get(0));
                        selectorConnection.addInput((NetCircuitSpan)this.getOrigSpans().get(1));
                    }
                    bridgeConnection5.addOutput((NetCircuitSpan)this.getOrigSpans().get(0));
                    bridgeConnection5.addOutput((NetCircuitSpan)this.getOrigSpans().get(1));
                    bridgeConnection.addOutput((NetCircuitSpan)this.getOmniSpans().get(0));
                    bridgeConnection5.addInput((NetCircuitSpan)this.getTermSpans().get(0));
                    selectorConnection.addOutput((NetCircuitSpan)this.getTermSpans().get(0));
                } else if (this.sources.size() == 2 && this.drops.size() == 2) {
                    bridgeConnection.addInput((NetCircuitEnd)this.sources.get(0));
                    bridgeConnection5.addOutput((NetCircuitEnd)this.sources.get(0));
                    bridgeConnection.addOutput((NetCircuitEnd)this.sources.get(1));
                    bridgeConnection5.addInput((NetCircuitEnd)this.drops.get(0));
                    selectorConnection.addOutput((NetCircuitEnd)this.drops.get(0));
                    selectorConnection.addInput((NetCircuitEnd)this.drops.get(1));
                    bridgeConnection5.addOutput((NetCircuitEnd)this.drops.get(1));
                } else if (this.dbgOn()) {
                    db.println("WARNING!! unknown span combo for UPSR_BLSR_IDRI");
                }
                InternalCircuitSpan internalCircuitSpan = new InternalCircuitSpan(bridgeConnection, selectorConnection);
                bridgeConnection.addOutput(internalCircuitSpan);
                selectorConnection.addInput(internalCircuitSpan);
                break;
            }
            default: {
                if (!this.dbgOn()) break;
                db.println("setupConnListOnCreation: unknown connection type " + EnumStrings.getString((Class)IConnectionType.class, (int)this.connType));
            }
        }
        this.prettyPrintConnectionList(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getWorkingSpans() {
        List list = null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (!this.hasConnection()) {
            return linkedList;
        }
        if (!this.isUpsrSelector()) {
            return linkedList;
        }
        Object object = this.entitiesLockObject;
        synchronized (object) {
            if (this.workingEntities == null || this.circuit.getState() == 11) {
                this.updateUpsrEntities(false);
            }
            list = this.workingEntities;
        }
        Iterator iterator = this.getAllSpans().keySet().iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitSpan)iterator.next();
            if (!list.contains(new Integer(((NetCircuitSpan)object).getEntityIndex(this.ne)))) continue;
            linkedList.add(object);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getProtectSpans() {
        List list = null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (!this.hasConnection()) {
            return linkedList;
        }
        if (!this.isUpsrSelector()) {
            return linkedList;
        }
        Object object = this.entitiesLockObject;
        synchronized (object) {
            if (this.protectEntities == null || this.circuit.getState() == 11) {
                this.updateUpsrEntities(false);
            }
            list = this.protectEntities;
        }
        Iterator iterator = this.getAllSpans().keySet().iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitSpan)iterator.next();
            if (!list.contains(new Integer(((NetCircuitSpan)object).getEntityIndex(this.ne)))) continue;
            linkedList.add(object);
        }
        return linkedList;
    }

    public List getActiveSpans() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUpsrSpanActive(NetCircuitSpan netCircuitSpan) {
        Object object;
        List list = null;
        if (!this.hasConnection()) {
            return false;
        }
        if (!this.isNodeRefValid) {
            return false;
        }
        Object object2 = this.entitiesLockObject;
        synchronized (object2) {
            if (this.activeEntities == null) {
                this.updateUpsrActiveEntities();
            }
            list = this.activeEntities;
        }
        if (list != null && list.contains(new Integer(netCircuitSpan.getEntityIndex(this.ne)))) {
            return true;
        }
        if (this.isUpsrBridgeConnType(this.connType)) {
            return false;
        }
        if (this.connType == 6) {
            object2 = this.getWorkingSpans();
            object = this.getProtectSpans();
            if (!object2.contains(netCircuitSpan) && !object.contains(netCircuitSpan)) {
                return false;
            }
        }
        object2 = null;
        object = this.findAlternateBiSpan(netCircuitSpan);
        if (object != null) {
            object2 = this.spanGetPeer((NetCircuitSpan)object);
        }
        if (object2 == null) {
            if (this.dbgOn()) {
                db.println("Warning! isUpsrSpanActive: peer Node not found");
            }
            return true;
        }
        if (this.dbgOn()) {
            db.println("peernode " + ((NetCircuitNode)object2).getName());
        }
        return ((NetCircuitNode)object2).isUpsrSpanActive((NetCircuitSpan)object);
    }

    protected int biSpanUpsrCost(NetCircuitSpan netCircuitSpan) {
        if (!netCircuitSpan.isUpsr()) {
            return 0;
        }
        if (!this.isUpsrSelector()) {
            return 0;
        }
        NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan);
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                db.println("biSpanUpsrCost:  peer not found");
            }
            return 0;
        }
        return netCircuitNode.biSpanUpsrRecursiveCost(netCircuitSpan);
    }

    protected int biSpanUpsrRecursiveCost(NetCircuitSpan netCircuitSpan) {
        if (!netCircuitSpan.isUpsr()) {
            return 0;
        }
        int n = netCircuitSpan.getLink().getCost();
        int n2 = this.findConnType();
        if (n2 != 1) {
            return n;
        }
        NetCircuitNode netCircuitNode = null;
        NetCircuitSpan netCircuitSpan2 = this.findAlternateBiSpan(netCircuitSpan);
        if (netCircuitSpan2 != null) {
            netCircuitNode = this.spanGetPeer(netCircuitSpan2);
        }
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                db.println("Warning! biSpanUpsRecursiveCost: peer Node not found");
            }
            return n;
        }
        return n + netCircuitNode.biSpanUpsrRecursiveCost(netCircuitSpan2);
    }

    protected boolean isAnyChangeInUpsrSelector() {
        if (this.dbgOn()) {
            db.println("isAnyChangeInUpsrSelector: circuit = " + this.circuit.getCircuitName() + " at " + this.getName());
        }
        if (!this.hasConnection()) {
            return false;
        }
        if (!this.isUpsrSelector()) {
            return false;
        }
        int n = -1;
        Object[] objectArray = this.getActivePathsFromConnModel();
        int n2 = this.getProtectionOpFromConnModel();
        if (this.connType == 3 || this.connType == 11 || this.connType == 13) {
            n = this.getReverseProtectionOpFromConnModel();
        }
        return this.isAnyChangeInUpsrSelector(objectArray, n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAnyChangeInUpsrSelector(Object[] objectArray, int n, int n2) {
        boolean bl = false;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        if (this.dbgOn()) {
            db.println("newProtectionOp =" + n + " oldProtectionOp =" + this.protectionOp + " newReverseProtectionOp =" + n2 + " oldReverseProtectionOp =" + this.reverseProtectionOp);
        }
        if (this.dbgOn()) {
            db.println("Checking for active paths");
        }
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        while (iterator.hasNext()) {
            int n3 = this.getEntityIndexFromPathDef(iterator.next());
            linkedList.add(new Integer(n3));
            if (!this.dbgOn()) continue;
            db.println("  active path: " + Integer.toHexString(n3));
        }
        boolean bl2 = false;
        Object object = this.entitiesLockObject;
        synchronized (object) {
            if (this.activeEntities == null) {
                this.activeEntities = linkedList;
                bl2 = true;
            }
            if (this.protectionOp != n) {
                this.protectionOp = n;
                if (!bl2) {
                    bl2 = true;
                }
            }
            if (this.reverseProtectionOp != n2) {
                this.reverseProtectionOp = n2;
                if (!bl2) {
                    bl2 = true;
                }
            }
            LinkedList linkedList2 = new LinkedList();
            linkedList2.addAll(this.activeEntities);
            if (linkedList.size() != linkedList2.size()) {
                if (this.dbgOn()) {
                    db.println("active entities have changed: " + linkedList2.size() + " -> " + linkedList.size());
                }
                bl2 = true;
                bl = true;
            } else {
                for (int i = 0; i < linkedList.size(); ++i) {
                    if (((Integer)linkedList.get(i)).compareTo((Integer)linkedList2.get(i)) == 0) continue;
                    bl2 = true;
                    bl = true;
                    if (!this.dbgOn()) continue;
                    db.println("active entity changed: " + Integer.toHexString((Integer)linkedList2.get(i)) + " -> " + Integer.toHexString((Integer)linkedList.get(i)));
                }
            }
        }
        if (bl2) {
            if (this.dbgOn()) {
                db.println("isAnyChangeInUpsrSelector: Circuit Changed");
            }
            this.circuit.setChanged();
            if (bl) {
                object = this.entitiesLockObject;
                synchronized (object) {
                    this.activeEntities = (LinkedList)linkedList.clone();
                }
            }
            return bl;
        }
        if (this.dbgOn()) {
            db.println("isAnyChangeInUpsrSelector: Nothing changed, returning false");
        }
        return false;
    }

    protected boolean isAnyChangeInEtherStpState() {
        return false;
    }

    protected void updateUpsrActiveEntities() {
        if (!this.hasConnection()) {
            return;
        }
        if (!this.isUpsrSelector()) {
            return;
        }
        if (this.dbgOn()) {
            db.println("Updating the active entities at " + this.getName());
        }
        if (this.getConn() != null) {
            Object[] objectArray = this.getActivePathsFromConnModel();
            this.updateUpsrActiveEntities(objectArray);
        } else if (this.dbgOn()) {
            db.println("Connection object not found");
        }
    }

    private void updateUpsrActiveEntities(Object[] objectArray) {
        this.activeEntities = new LinkedList();
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        while (iterator.hasNext()) {
            int n = this.getEntityIndexFromPathDef(iterator.next());
            this.activeEntities.add(new Integer(n));
            if (!this.dbgOn()) continue;
            db.println("  active path: " + Integer.toHexString(n));
        }
    }

    protected void updateUpsrEntities(boolean bl) {
        if (!this.hasConnection()) {
            return;
        }
        if (!this.isUpsrSelector()) {
            return;
        }
        if (this.dbgOn()) {
            // empty if block
        }
        Object[] objectArray = this.getPathsFromConnModel();
        this.updateUpsrEntities(objectArray, bl);
    }

    private void updateUpsrEntities(Object[] objectArray, boolean bl) {
        this.workingEntities = new LinkedList();
        this.protectEntities = new LinkedList();
        if (objectArray.length == 0) {
            if (this.dbgOn()) {
                db.println("paths array is null");
            }
            return;
        }
        switch (this.connType) {
            case 2: 
            case 5: 
            case 6: {
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[0])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[1])));
                break;
            }
            case 3: {
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[0])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[1])));
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[2])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[3])));
                break;
            }
            case 10: {
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[0])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[1])));
                break;
            }
            case 11: {
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[0])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[1])));
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[2])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[3])));
                break;
            }
            case 13: {
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[1])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[3])));
                break;
            }
            case 16: {
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[0])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[3])));
                break;
            }
            case 15: {
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[3])));
                break;
            }
            case 14: {
                this.workingEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[0])));
                this.protectEntities.add(new Integer(this.getEntityIndexFromPathDef(objectArray[3])));
                break;
            }
        }
        if (bl) {
            this.updateUpsrActiveEntities();
        }
    }

    protected void markRoutedUpsrRing() throws SanityCheckFailed {
        boolean bl = true;
        boolean bl2 = this.countNumOmniSpans() != 0;
        boolean bl3 = false;
        boolean bl4 = true;
        if (this.dbgOn()) {
            this.debug("markRoutedUpsrRing(" + this.getName() + ")");
        }
        this.createUpsrOps();
        if (this.countNumInputs() < 2 && !bl2) {
            return;
        }
        LinkedList linkedList = null;
        MemberPrefs memberPrefs = this.circuit.getMemberPrefs();
        if (memberPrefs != null && memberPrefs.getDriNodePrefs().size() != 0 && memberPrefs.isBlsrDriNode(this.ne)) {
            linkedList = new LinkedList(this.getTermSpansForBlsrDriHandoffNodes());
        }
        if (linkedList == null || linkedList.size() == 0) {
            linkedList = new LinkedList(this.getTermSpans());
        }
        if (this.findConnType() == 15) {
            bl4 = false;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (this.dbgOn()) {
                this.debug("markRoutedUpsrRing: trying span " + netCircuitSpan.prettyString());
            }
            if (netCircuitSpan.getDstState() != 2 && this.circuit.getCktOperation() != 5) continue;
            NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan);
            if (netCircuitNode != null) {
                netCircuitNode.markRoutedUpsrSpan(netCircuitSpan, bl4);
                if (bl2 && !bl3) {
                    bl = netCircuitNode.isSourceRing(netCircuitSpan);
                    if (this.dbgOn()) {
                        this.debug(this.getName() + " determined to be on " + (bl ? "source " : "dest ") + "ring");
                    }
                }
            }
            if (!bl4 || !this.inSpans.contains(netCircuitSpan)) continue;
            this.inSpans.remove(netCircuitSpan);
            this.biSpans.add(netCircuitSpan);
        }
        if (bl2) {
            this.markRoutedOmniSpans(bl);
        }
    }

    protected boolean sanityCheckSelectorDropProtection() {
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (!(connection instanceof SelectorConnection)) continue;
            SelectorConnection selectorConnection = (SelectorConnection)connection;
            this.markSelectorInputPaths();
            if (selectorConnection.isProtected) continue;
            return false;
        }
        return true;
    }

    public List getTermSpansForBlsrDriHandoffNodes() {
        MemberPrefs memberPrefs = this.circuit.getMemberPrefs();
        LinkedList linkedList = new LinkedList();
        if (memberPrefs.getDriNodePrefs().size() != 0) {
            int n;
            if (memberPrefs.isBlsrDriNode(this.ne) && (n = memberPrefs.getDriType(this.getNetElement())) == 2) {
                int n2 = this.findConnType();
                switch (n2) {
                    case 13: 
                    case 15: {
                        NetCircuitNode netCircuitNode = (NetCircuitNode)this.circuit.getCircuitNodeFromNE(memberPrefs.findDriPeer(this.getNetElement()));
                        while (!netCircuitNode.getNetElement().equals(this.getNetElement())) {
                            linkedList.clear();
                            linkedList.addAll(netCircuitNode.getOrigSpans());
                            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)linkedList.get(0);
                            netCircuitNode = netCircuitNode.spanGetPeer(netCircuitSpan);
                        }
                        return linkedList;
                    }
                    case 14: {
                        if (this.getTermSpans().size() == 2) {
                            linkedList.addAll(this.getTermSpans());
                            break;
                        }
                        if (this.getOrigSpans().size() != 2) break;
                        linkedList.addAll(this.getOrigSpans());
                        break;
                    }
                    default: {
                        return linkedList;
                    }
                }
            }
            return linkedList;
        }
        return linkedList;
    }

    protected void markRoutedUpsrSpan(NetCircuitSpan netCircuitSpan, boolean bl) throws SanityCheckFailed {
        LinkedList linkedList;
        int n;
        if (this.dbgOn()) {
            db.println("markRoutedUpsrSpan: node " + this.getName() + " span " + netCircuitSpan.prettyString());
        }
        if (netCircuitSpan.isUpsr()) {
            return;
        }
        netCircuitSpan.setUpsrLink(true);
        if (netCircuitSpan.getBlsrDriInterConnect()) {
            if (!netCircuitSpan.getLink().inBLSR()) {
                throw new SanityCheckFailed("span is not on BLSR");
            }
        } else if (netCircuitSpan.getLink().getProtectionType() != 3) {
            if (this.isUpsrOver1Plus1Enabled()) {
                if (netCircuitSpan.getLink().getProtectionType() != 1) {
                    throw new SanityCheckFailed("UPSR span neither Unprot NOR 1+1 protected");
                }
            } else {
                netCircuitSpan.setUpsrLink(false);
                throw new SanityCheckFailed("UPSR span is line protected");
            }
        }
        if (!(this.circuit.getXmCircuitEnds().isEmpty() || ((NetCircuitEnd)this.circuit.getXmCircuitEnds().get(0)).getNodeId() != this.getNodeModel().getNodeId() || this.findConnType() != 1 && this.countNumOmniSpans() == 0)) {
            throw new SanityCheckFailed("The circuit has primary path via a pair of DS3XM-12 portless ports, but not on alternate path.");
        }
        if (this.isUpsrSelectorConn() && this.upsrOps == null) {
            this.createUpsrOps();
        }
        if ((n = this.countRoutedOutputs()) > 1) {
            return;
        }
        if (n == 1 && this.countRoutedSources() == 1) {
            return;
        }
        int n2 = this.findConnType();
        if (n2 == 10 || n2 == 11) {
            this.circuit.setDri(true);
        }
        if ((linkedList = new LinkedList(this.getTermSpans())).contains(netCircuitSpan)) {
            linkedList.remove(netCircuitSpan);
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan2.getDstState() != 2) continue;
            NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan2);
            netCircuitNode.markRoutedUpsrSpan(netCircuitSpan2, bl);
            if (n2 != 6 && bl && this.outSpans.contains(netCircuitSpan)) {
                this.outSpans.remove(netCircuitSpan);
                this.biSpans.add(netCircuitSpan);
            }
            if (!bl || !this.inSpans.contains(netCircuitSpan2)) continue;
            this.inSpans.remove(netCircuitSpan2);
            this.biSpans.add(netCircuitSpan2);
        }
    }

    protected void markRoutedUpsrRingFromBridge() throws SanityCheckFailed {
        if (this.dbgOn()) {
            this.debug("markRoutedUpsrRingFromBridge " + this.getName());
        }
        if (!this.isUpsrSelectorConn() && this.findConnType() != 4) {
            return;
        }
        if (this.circuit.isBidirectional()) {
            this.createUpsrOps();
        }
        LinkedList linkedList = new LinkedList(this.getOrigSpans());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode;
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getSrcState() != 2 || (netCircuitNode = this.spanGetPeer(netCircuitSpan)) == null) continue;
            netCircuitNode.markRoutedUpsrSpanOffBridge(netCircuitSpan);
        }
    }

    protected void markRoutedUpsrSpanOffBridge(NetCircuitSpan netCircuitSpan) throws SanityCheckFailed {
        int n;
        if (this.dbgOn()) {
            db.println("markRoutedUpsrSpanOffBridge: node= " + this.getName() + ". span= " + netCircuitSpan.prettyString());
        }
        if (netCircuitSpan.isUpsr()) {
            return;
        }
        netCircuitSpan.setUpsrLink(true);
        if (netCircuitSpan.getLink().getProtectionType() != 3) {
            if (this.isUpsrOver1Plus1Enabled()) {
                if (netCircuitSpan.getLink().getProtectionType() != 1) {
                    throw new SanityCheckFailed("UPSR span neither Unprot NOR line protected");
                }
            } else {
                throw new SanityCheckFailed("UPSR span is line protected");
            }
        }
        if (this.isUpsrSelectorConn() && this.upsrOps == null) {
            this.createUpsrOps();
        }
        if ((n = this.countRoutedInputs()) == 1 && this.countRoutedDrops() == 1) {
            if (this.inSpans.contains(netCircuitSpan)) {
                this.inSpans.remove(netCircuitSpan);
                this.biSpans.add(netCircuitSpan);
            }
            return;
        }
        LinkedList linkedList = new LinkedList(this.getOrigSpans());
        if (linkedList.contains(netCircuitSpan)) {
            linkedList.remove(netCircuitSpan);
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan2.getSrcState() != 2) continue;
            NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan2);
            netCircuitNode.markRoutedUpsrSpanOffBridge(netCircuitSpan2);
            if (this.inSpans.contains(netCircuitSpan)) {
                this.inSpans.remove(netCircuitSpan);
                this.biSpans.add(netCircuitSpan);
            }
            if (!this.outSpans.contains(netCircuitSpan2)) continue;
            this.outSpans.remove(netCircuitSpan2);
            this.biSpans.add(netCircuitSpan2);
        }
    }

    private void markRoutedOmniSpans(boolean bl) {
        LinkedList linkedList;
        boolean bl2 = bl;
        if (this.dbgOn()) {
            this.debug("markRoutedOmniSpans(" + this.getName() + ")" + (bl ? "(Src Ring)" : ""));
        }
        if ((linkedList = new LinkedList(this.getOmniSpans())).size() == 2 && this.countNumTermSpans() == 0) {
            if (this.dbgOn()) {
                this.debug("Not marking routed omni spans starting at interm. node");
            }
            return;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode;
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getDstState() != 2 || (netCircuitNode = this.spanGetPeer(netCircuitSpan)) == null) continue;
            netCircuitNode.markRoutedOmniSpans(netCircuitSpan, bl2);
            bl2 = !bl2;
        }
    }

    protected void markSpansDri() {
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            connection.markSpansDri();
        }
    }

    protected void validateBlsrDriPcaSpans(ArrayList arrayList) throws SanityCheckFailed {
        if (!this.isBlsrDriPrimary()) {
            return;
        }
        BlsrPrimaryInfo blsrPrimaryInfo = null;
        ArrayList<BlsrPrimaryInfo> arrayList2 = new ArrayList<BlsrPrimaryInfo>();
        Iterator iterator = this.getAllSpansList().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (!netCircuitSpan.getLink().inBLSR()) continue;
            blsrPrimaryInfo = new BlsrPrimaryInfo();
            blsrPrimaryInfo.blsrName = netCircuitSpan.getLink().blsrRingName(this.getNetElement());
            blsrPrimaryInfo.node = this;
            if (netCircuitSpan.getLink().isPca(this.getNetElement())) {
                blsrPrimaryInfo.usesPca = true;
            }
            arrayList2.add(blsrPrimaryInfo);
        }
        Iterator iterator2 = arrayList2.iterator();
        while (iterator2.hasNext()) {
            blsrPrimaryInfo = (BlsrPrimaryInfo)iterator2.next();
            Iterator iterator3 = arrayList.iterator();
            while (iterator3.hasNext()) {
                BlsrPrimaryInfo blsrPrimaryInfo2 = (BlsrPrimaryInfo)iterator3.next();
                if (!blsrPrimaryInfo2.blsrName.equals(blsrPrimaryInfo.blsrName) || blsrPrimaryInfo2.node.equals(blsrPrimaryInfo.node) || !blsrPrimaryInfo.usesPca && !blsrPrimaryInfo2.usesPca) continue;
                if (this.dbgOn()) {
                    db.println("hasInvalidBlsrDriPcaSpans: multiple primary nodes on the same BLSR using PCA " + blsrPrimaryInfo.blsrName + " node " + blsrPrimaryInfo.node.getName() + " uses PCA " + blsrPrimaryInfo.usesPca + " node " + blsrPrimaryInfo2.node.getName() + " uses PCA " + blsrPrimaryInfo2.usesPca);
                }
                throw new SanityCheckFailed("BLSR " + blsrPrimaryInfo.blsrName + " with multiple " + " primary handoffs can't use PCA and insure DRI protection");
            }
        }
        arrayList.addAll(arrayList2);
    }

    protected boolean isOpenEndedOnewayBlsrDriSecondaryDrop() {
        if (this.connections.size() != 1) {
            return false;
        }
        Connection connection = (Connection)this.connections.get(0);
        return connection.isOpenEndedOnewayBlsrDriSecondaryDrop();
    }

    protected boolean hasBlsrDriSelector() {
        Iterator iterator = this.getSelectors().iterator();
        while (iterator.hasNext()) {
            if (!((SelectorConnection)iterator.next()).isBlsrDriSelector()) continue;
            return true;
        }
        return false;
    }

    protected int markBlsrDriHandoffs() {
        int n = 0;
        if (this.getDri()) {
            return 0;
        }
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            List list;
            OnewayConnection onewayConnection;
            Connection connection;
            Connection connection2 = (Connection)iterator.next();
            if (connection2.isValidBlsrDriSelector()) {
                n += ((SelectorConnection)connection2).markBlsrDriHandoffs();
                continue;
            }
            if (!connection2.isValidOpenEndedOnewayBlsrDriSecondaryDrop() || (connection = this.circuit.findBlsrDriPrimary(onewayConnection = (OnewayConnection)connection2)) == null || (list = onewayConnection.getInSpans()).size() != 1) continue;
            n += onewayConnection.markBlsrDriHandoffs(null, connection, (NetCircuitSpan)list.get(0));
        }
        return n;
    }

    protected boolean hasInvalidBlsrDriSelector() {
        List list = this.getSelectors();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SelectorConnection selectorConnection = (SelectorConnection)iterator.next();
            if (!selectorConnection.isBlsrDriSelector() || selectorConnection.isValidBlsrDriSelector()) continue;
            return true;
        }
        return false;
    }

    protected boolean hasInvalidOpenEndedOnewayBlsrDri() {
        if (!this.isOpenEndedOnewayBlsrDriSecondaryDrop()) {
            return false;
        }
        if (this.connections.size() != 1) {
            return false;
        }
        Connection connection = (Connection)this.connections.get(0);
        return !connection.isValidOpenEndedOnewayBlsrDriSecondaryDrop();
    }

    protected void findUpsrHeads() {
        List list = this.getSelectors();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SelectorConnection selectorConnection = (SelectorConnection)iterator.next();
            selectorConnection.findUpsrHead();
        }
    }

    protected void updateBlsrDriNodeType() {
        if (this.connections.size() > 2 || this.driNodeType != 0) {
            return;
        }
        Connection connection = null;
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            connection = (Connection)iterator.next();
            if (connection.isOneway()) continue;
            return;
        }
        NetCircuitSpan netCircuitSpan = connection.inPuts.get(0) instanceof NetCircuitSpan ? (NetCircuitSpan)connection.inPuts.get(0) : null;
        NetCircuitSpan netCircuitSpan2 = connection.outPuts.get(0) instanceof NetCircuitSpan ? (NetCircuitSpan)connection.outPuts.get(0) : null;
        NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan2);
        NetCircuitNode netCircuitNode2 = this.spanGetPeer(netCircuitSpan);
        if (netCircuitNode2 == null || netCircuitNode == null) {
            return;
        }
        if (netCircuitNode2.isBlsrDriType() && netCircuitNode.isBlsrDriType() && netCircuitSpan.getLink().inBLSR() && netCircuitSpan2.getLink().inBLSR()) {
            this.driNodeType = 3;
            if (this.dbgOn()) {
                db.println("updateBlsrDriNodeType: updated " + this.getName() + " driNodeType to " + EnumStrings.getString((Class)IDriNodeType.class, (int)this.driNodeType));
            }
        }
    }

    protected boolean isBlsrDriHandoff() {
        return this.driNodeType == 1 || this.driNodeType == 2;
    }

    protected boolean isBlsrDriIntermediate() {
        return this.driNodeType == 3;
    }

    protected boolean isBlsrDriPrimary() {
        return this.driNodeType == 1;
    }

    protected boolean isBlsrDriSecondary() {
        return this.driNodeType == 2;
    }

    protected boolean isBlsrDriType() {
        return this.driNodeType == 1 || this.driNodeType == 2 || this.driNodeType == 3;
    }

    private boolean isOnSameBlsrRing(NetCircuitSpan netCircuitSpan, NetCircuitSpan netCircuitSpan2) {
        return netCircuitSpan2 != null && netCircuitSpan != null && netCircuitSpan.availSpan != null && netCircuitSpan2.availSpan != null && netCircuitSpan.getLink().inBLSR() && netCircuitSpan2.getLink().inBLSR() && netCircuitSpan.getLink().blsrRingName(this.getNetElement()).equals(netCircuitSpan2.getLink().blsrRingName(this.getNetElement()));
    }

    private void markRoutedOmniSpans(NetCircuitSpan netCircuitSpan, boolean bl) {
        if (this.dbgOn()) {
            db.println("markRoutedOmniSpans: node= " + this.getName() + ". span= " + netCircuitSpan.prettyString() + (bl ? "(Src Ring)" : ""));
        }
        if (this.getTotalInOuts() >= 3) {
            this.setDri(true);
            if (this.getTotalInOuts() == 3 && this.sources.size() == 1 && this.circuit.getCircuitDir() == 1) {
                bl = false;
            }
        }
        if (netCircuitSpan.isUpsr()) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("markRoutedOmniSpans: span is UPSR");
        }
        netCircuitSpan.setUpsrLink(true);
        netCircuitSpan.getNetLinkSpan().setSourceRing(bl);
        LinkedList linkedList = new LinkedList(this.getOmniSpans());
        if (linkedList.contains(netCircuitSpan)) {
            linkedList.remove(netCircuitSpan);
        }
        if (linkedList.isEmpty()) {
            return;
        }
        if (this.isUpsrSelectorConn()) {
            if (this.dbgOn()) {
                db.println("reached selector node- stopping");
            }
            return;
        }
        NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)linkedList.getFirst();
        if (netCircuitSpan2 != null) {
            NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan2);
            netCircuitNode.markRoutedOmniSpans(netCircuitSpan2, bl);
        } else {
            db.println("Warning! unable to find connected span in intermediate DRI node");
        }
    }

    protected void sanityCheckBlsrDriPrimaryNode() throws SanityCheckFailed {
        int n = this.getTotalInOuts();
        if (this.dbgOn()) {
            db.println("sanityCheckBlsrDriPrimaryNode: " + this.getName() + " endpoints " + n + " sources " + this.sources.size() + " drops " + this.drops.size());
        }
        if (n < 3 || n > 4) {
            throw new SanityCheckFailed(this.getName() + " invalid number of spans " + n);
        }
        if (n == 4 && (this.sources.size() != 0 || this.drops.size() != 0)) {
            throw new SanityCheckFailed(this.getName() + " sources or drops not allowed on IDRI nodes ");
        }
        if (this.countNumOmniSpans() > 1) {
            throw new SanityCheckFailed(this.getName() + " more than one omni span not allowed ");
        }
    }

    protected boolean isSourceRing(NetCircuitSpan netCircuitSpan) {
        MemberPrefs memberPrefs;
        boolean bl = true;
        if (this.dbgOn()) {
            db.println("isSourceRing: node= " + this.getName() + ". span= " + netCircuitSpan.prettyString());
        }
        if ((memberPrefs = this.circuit.getMemberPrefs()).isBlsrDriNode(this.ne)) {
            return false;
        }
        int n = this.countRoutedOutputs();
        if (n > 1) {
            return true;
        }
        LinkedList linkedList = new LinkedList(this.getTermSpans());
        if (linkedList.contains(netCircuitSpan)) {
            linkedList.remove(netCircuitSpan);
        }
        if (linkedList.isEmpty()) {
            db.println("Warning! No terminating Spans found on UPSR nodewhile trying to determine DRI source ring attibute.");
            db.println("This possible for circuits with 2 sources and interm. nodes");
            return true;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan2.getDstState() != 2) continue;
            NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan2);
            bl = netCircuitNode.isSourceRing(netCircuitSpan2);
            LinkedList linkedList2 = this.getOmniSpans();
            if (linkedList2.size() == 1) {
                return !bl;
            }
            return bl;
        }
        return bl;
    }

    protected void markSelectorInputPaths() {
        if (!this.hasSelector()) {
            return;
        }
        if (this.upsrOps == null) {
            this.createUpsrOps();
        }
        Iterator iterator = this.getSelectors().iterator();
        while (iterator.hasNext()) {
            if (this.dbgOn()) {
                db.println("markSelectorInputPaths: marking selectors on node " + this.getName());
            }
            SelectorConnection selectorConnection = (SelectorConnection)iterator.next();
            selectorConnection.findUpsrHead();
            selectorConnection.isProtected = true;
            Iterator iterator2 = selectorConnection.getInSpans().iterator();
            while (iterator2.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator2.next();
                boolean bl = selectorConnection.markSelectorInputSpans(selectorConnection, netCircuitSpan);
                boolean bl2 = selectorConnection.isProtected = selectorConnection.isProtected && bl;
                if (!this.dbgOn() || bl) continue;
                db.println("markSelectorInputPaths: ERROR - unprotected selector detected validating inSpan " + netCircuitSpan.prettyString());
            }
        }
    }

    protected Connection findConnectionWithOutput(Object object) {
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            Iterator iterator2 = connection.outPuts.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().equals(object)) continue;
                return connection;
            }
        }
        return null;
    }

    protected Connection findConnectionWithInput(Object object) {
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            Iterator iterator2 = connection.inPuts.iterator();
            while (iterator2.hasNext()) {
                if (!iterator2.next().equals(object)) continue;
                return connection;
            }
        }
        return null;
    }

    protected SelectorConnection findSelectorWithInput(Object object) {
        Iterator iterator = this.getSelectors().iterator();
        while (iterator.hasNext()) {
            SelectorConnection selectorConnection = (SelectorConnection)iterator.next();
            if (!selectorConnection.isInput(object) && !selectorConnection.isExternalInput(object)) continue;
            return selectorConnection;
        }
        return null;
    }

    protected boolean hasSelector() {
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (!(connection instanceof SelectorConnection)) continue;
            return true;
        }
        return false;
    }

    protected List getSelectors() {
        LinkedList<Connection> linkedList = new LinkedList<Connection>();
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (!connection.isSelector()) continue;
            linkedList.add(connection);
        }
        return linkedList;
    }

    protected boolean hasUnprotectedSelector() {
        Iterator iterator = this.getSelectors().iterator();
        while (iterator.hasNext()) {
            if (((SelectorConnection)iterator.next()).isProtected) continue;
            if (this.dbgOn()) {
                db.println("hasUnprotectedSelectors: unprotected selector found on node " + this.getName());
            }
            return true;
        }
        return false;
    }

    protected boolean hasUnprotectedDrop() {
        Iterator iterator = this.getDrops().iterator();
        if (this.circuit.getCircuitNodes().size() == 1) {
            return false;
        }
        while (iterator.hasNext()) {
            List list;
            NetCircuitSpan netCircuitSpan;
            Connection connection = this.findConnectionWithOutput(iterator.next());
            if (connection == null) {
                if (this.dbgOn()) {
                    db.println("hasUnprotectedDrop: no connection with output on node " + this.getName());
                }
                return true;
            }
            if (connection instanceof SelectorConnection || this.circuit.hasOpenEndedSelector() || connection.isInputLineProtected(netCircuitSpan = (list = connection.getInSpans()).size() == 0 ? null : (NetCircuitSpan)list.get(0))) continue;
            if (this.dbgOn()) {
                db.println("hasUnprotectedDrop: unprotected drop found on node " + this.getName());
            }
            return true;
        }
        return false;
    }

    protected void createUpsrOps() {
        this.upsrOps = new NetUpsrOps(this);
    }

    protected NetCircuitSpan findAltSpanForOneway(NetCircuitSpan netCircuitSpan) {
        OnewayConnection onewayConnection = null;
        LinkedList<Connection> linkedList = new LinkedList<Connection>();
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (!(connection instanceof OnewayConnection)) continue;
            linkedList.add(connection);
        }
        if (this.dbgOn()) {
            db.println("findAltSpanForOneway found " + linkedList.size() + " oneways on " + this.getName());
        }
        List list = new LinkedList();
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan2;
            onewayConnection = (OnewayConnection)iterator.next();
            list = onewayConnection.getInSpans();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                netCircuitSpan2 = (NetCircuitSpan)iterator2.next();
                if (!netCircuitSpan.equals(netCircuitSpan2)) continue;
                if (this.dbgOn()) {
                    db.println("found matching inspan " + netCircuitSpan2.availSpan.prettyString());
                }
                if (onewayConnection.getOutSpans().size() == 1) {
                    return (NetCircuitSpan)onewayConnection.getOutSpans().get(0);
                }
                if (this.dbgOn()) {
                    db.println("findAltSpanForOneway: returning null");
                }
                return null;
            }
            list = onewayConnection.getOutSpans();
            iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                netCircuitSpan2 = (NetCircuitSpan)iterator2.next();
                if (!netCircuitSpan.equals(netCircuitSpan2)) continue;
                if (onewayConnection.getInSpans().size() == 1) {
                    return (NetCircuitSpan)onewayConnection.getInSpans().get(0);
                }
                return null;
            }
        }
        return null;
    }

    protected boolean isInputOfSelector(NetCircuitSpan netCircuitSpan) {
        SelectorConnection selectorConnection = this.findSelectConnForInspan(netCircuitSpan);
        return selectorConnection != null;
    }

    protected SelectorConnection findSelectConnForInspan(NetCircuitSpan netCircuitSpan) {
        SelectorConnection selectorConnection = null;
        LinkedList<Connection> linkedList = new LinkedList<Connection>();
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (!(connection instanceof SelectorConnection)) continue;
            linkedList.add(connection);
        }
        List list = new LinkedList();
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            selectorConnection = (SelectorConnection)iterator.next();
            list = selectorConnection.getInSpans();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator2.next();
                if (!netCircuitSpan.equals(netCircuitSpan2)) continue;
                return selectorConnection;
            }
        }
        return null;
    }

    protected boolean isInputOfBridge(NetCircuitSpan netCircuitSpan) {
        BridgeConnection bridgeConnection = this.findBridgeConnForInspan(netCircuitSpan);
        return bridgeConnection != null;
    }

    protected BridgeConnection findBridgeConnForInspan(NetCircuitSpan netCircuitSpan) {
        BridgeConnection bridgeConnection = null;
        LinkedList<Connection> linkedList = new LinkedList<Connection>();
        Iterator iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            Connection connection = (Connection)iterator.next();
            if (!(connection instanceof BridgeConnection)) continue;
            linkedList.add(connection);
        }
        List list = new LinkedList();
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            bridgeConnection = (BridgeConnection)iterator.next();
            list = bridgeConnection.getInSpans();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator2.next();
                if (!netCircuitSpan.equals(netCircuitSpan2)) continue;
                return bridgeConnection;
            }
            bridgeConnection = null;
        }
        return bridgeConnection;
    }

    protected static ICircuitId getConnCircuitId(Object object) {
        if (object instanceof IConnectionModel) {
            return ((IConnectionModel)object).getCircuitId();
        }
        return null;
    }

    public int getConnObjIndex() {
        return this.getConn().getIndex();
    }

    public abstract IConnectionModel getConn();

    protected abstract void setConn(IConnectionModel var1);

    public boolean isUpsr() {
        return this.getUpsrOps() != null;
    }

    public boolean isUpsrSelector() {
        return this.hasConnection() && this.isUpsrSelectorConnType(this.connType);
    }

    public boolean isUpsrBridge() {
        return this.hasConnection() && this.isUpsrBridgeConnType(this.connType);
    }

    protected boolean isUpsrSelectorConn() {
        return this.isUpsrSelectorConnType(this.findConnType());
    }

    protected boolean isUpsrBridgeConn() {
        return this.isUpsrBridgeConnType(this.findConnType());
    }

    private boolean isUpsrSelectorConnType(int n) {
        return n == 2 || n == 3 || n == 7 || n == 5 || n == 6 || n == 10 || n == 11 || n == 14 || n == 13 || n == 15 || n == 16;
    }

    private boolean isUpsrBridgeConnType(int n) {
        return this.isBridgedOneWay(n) || n == 2 || n == 3 || n == 4 || n == 10 || n == 11 || n == 14 || n == 13 || n == 15 || n == 16;
    }

    public boolean upsrBridgeOrSelector() {
        if (this.isUpsrSelector()) {
            return true;
        }
        return this.isUpsrBridge();
    }

    public boolean isNodeRefValid() {
        return this.isNodeRefValid;
    }

    public boolean doesCircuitNodeUseConn(IConnectionModel iConnectionModel) {
        IConnectionModel iConnectionModel2 = this.getConn();
        return iConnectionModel == iConnectionModel2 || iConnectionModel2 != null && iConnectionModel2.equals(iConnectionModel);
    }

    protected boolean isForwardingSpan(NetCircuitSpan netCircuitSpan, NetCircuitNode netCircuitNode) {
        return false;
    }

    protected boolean okToDeleteNe() {
        Object object;
        Iterator iterator;
        if (this.sources.size() != 0 || this.drops.size() != 0) {
            return false;
        }
        if (this.dbgOn()) {
            db.println("inSpan size= " + this.inSpans.size() + " outSpan size= " + this.outSpans.size() + " biSpan size= " + this.biSpans.size());
        }
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        if (this.inSpans.size() != 0) {
            linkedList2 = this.inSpans;
        }
        if (this.outSpans.size() != 0) {
            linkedList = this.outSpans;
        }
        if (this.biSpans.size() != 0) {
            iterator = this.biSpans.iterator();
            while (iterator.hasNext()) {
                object = (NetCircuitSpan)iterator.next();
                if (this.findRoutingDir((NetCircuitSpan)object) == eSpanDirection.TERMINATING) {
                    linkedList2.add(object);
                    continue;
                }
                if (this.findRoutingDir((NetCircuitSpan)object) != eSpanDirection.ORIGINATING) continue;
                linkedList.add(object);
            }
        }
        if (this.dbgOn()) {
            db.println("TermSpan size= " + linkedList2.size() + " OrigSpan size= " + linkedList.size() + " " + this.getName());
        }
        if (linkedList2.size() != linkedList.size()) {
            return false;
        }
        iterator = linkedList2.iterator();
        object = linkedList.iterator();
        while (iterator.hasNext() && object.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)object.next();
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getHoNum(this.ne) == netCircuitSpan2.getHoNum(this.ne) && netCircuitSpan.getLoNum() == netCircuitSpan2.getLoNum()) continue;
            return false;
        }
        return true;
    }

    protected void handleTl1LoAditDeletion() {
    }

    public void update(IObservable iObservable, Object object) {
        String string = "Unknown";
        if (iObservable instanceof IHoConnectionModel || iObservable instanceof ILoConnectionModel || iObservable instanceof ILoAditModel || iObservable instanceof IOchncConnectionModel || iObservable instanceof IOchccConnectionModel || iObservable instanceof IOchTrailAditModel) {
            if (this.dbgOn()) {
                if (iObservable instanceof IHoConnectionModel) {
                    string = "IHoConnectionModel";
                } else if (iObservable instanceof ILoConnectionModel) {
                    string = "ILoConnectionModel";
                } else if (iObservable instanceof ILoAditModel) {
                    string = "ILoAditModel";
                } else if (iObservable instanceof IOchncConnectionModel) {
                    string = "IOchncConnectionModel";
                } else if (iObservable instanceof IOchccConnectionModel) {
                    string = "IOchccConnectionModel";
                } else if (iObservable instanceof IOchTrailAditModel) {
                    string = "IOchTrailAditModel";
                }
            }
            if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (this.dbgOn()) {
                    db.println("node.update: type = DELETED (" + string + ") at " + this.getNameAndClass());
                }
                this.updateEvent.deleted = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(this.circuit, this, "deleted");
                this.printObservers();
                this.notifyObservers(ModelUpdateType.DELETED);
            } else if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (this.dbgOn()) {
                    db.println("node.update: type = CHANGED (" + string + ") at " + this.getNameAndClass());
                }
                this.updateEvent.changed = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(this.circuit, this, "changed");
                this.printObservers();
                this.notifyObservers(ModelUpdateType.CHANGED);
            }
        }
    }

    protected void runUpdate() {
        if (!this.isNodeRefValid) {
            return;
        }
        if (this.updateEvent.deleted) {
            if (NetCircuitWatchDog.instance().dumpDb.isEventLogEnabled()) {
                UpdateEventCollector.instance().LogEvent(" NCN: " + this.getName() + " runUpdate  deleted");
            }
            if (this.dbgOn()) {
                db.println("node.runUpdate: type = DELETED at " + this.getNameAndClass() + " for " + this.circuit.getCircuitName());
            }
            this.updateDeleted();
            this.updateEvent.deleted = false;
        } else if (this.updateEvent.changed) {
            if (NetCircuitWatchDog.instance().dumpDb.isEventLogEnabled()) {
                UpdateEventCollector.instance().LogEvent(" NCN: " + this.getName() + " runUpdate changed");
            }
            if (this.dbgOn()) {
                db.println("node.runUpdate: type = CHANGED at " + this.getNameAndClass() + " for " + this.circuit.getCircuitName());
            }
            this.updateChanged();
            this.updateEvent.changed = false;
        }
    }

    protected void updateDeleted() {
        if (this.dbgOn()) {
            db.println("updateDeleted() at " + this.getNameAndClass());
        }
        if (!this.circuit.circuitInfoActive()) {
            if (this.circuit.getCircuitTypeObj().isLAPCircuitType() || this.circuit.getCircuitTypeObj().isTunnelCircuitType()) {
                if (this.dbgOn()) {
                    db.println("TCCU: CktNode " + this.getName() + "DELETED for cktType" + this.circuit.getCircuitType());
                }
                ((HoCcatCircuit)this.circuit).deleteLoTunnelNetLink();
                ((HoCcatCircuit)this.circuit).deleteLAPNetLink();
            } else if (this.circuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                if (this.dbgOn()) {
                    db.println("CktNode " + this.getName() + "DELETED for cktType" + this.circuit.getCircuitType());
                }
                ((OchncCircuit)this.circuit).deleteOchTrailTunnelNetLink();
            }
            this.handleTl1LoAditDeletion();
        }
        if (this.state == 2 || this.state == 3 || this.state == 4) {
            this.circuit.disposeConnection(this, true);
        } else if (this.state == 1) {
            this.deleteConnectionObserver();
            this.setConn(null);
            this.numberOfPaths = 0;
            this.setState(0);
        } else if (this.state == 0) {
            this.deleteConnectionObserver();
            this.setConn(null);
            this.numberOfPaths = 0;
        }
    }

    private void updateChanged() {
        int n;
        int n2;
        if (this.circuit.getState() == 2 || this.circuit.getState() == 0) {
            return;
        }
        if (this.dbgOn()) {
            db.println("Calling NetCircuitNode::updateChanged() to update the Cross Connection");
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.rollHasCompleted;
        try {
            bl = this.updateNumberOfPaths();
            bl2 = this.updateConnectionPathEnds();
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            return;
        }
        ICircuitId iCircuitId = this.getConnectionCircuitId();
        if (this.cktId != null && iCircuitId != null && (this.cktId.getNodeId() != iCircuitId.getNodeId() || this.cktId.getUniquePart().getUniqueId() != iCircuitId.getUniquePart().getUniqueId())) {
            this.cktId = iCircuitId;
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " cktId changed");
            }
            this.circuit.disposeConnection(this, true);
            NetCircuitWatchDog.instance().reloadConnections(this.ne);
            return;
        }
        this.isAnyChangeInUpsrSelector();
        int n3 = this.getAdminStateFromNE();
        if (this.getAdminState() != n3) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " adminState changed");
            }
            this.setAdminState(n3);
            this.circuit.setChanged();
        }
        if (this.serviceState != (n2 = this.getServiceStateFromNE())) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " serviceState changed");
            }
            this.setServiceState(n2);
            this.circuit.setChanged();
        }
        String string = this.getConnNameFromNE();
        boolean bl4 = false;
        if (this.connName == null && string != null) {
            bl4 = true;
        } else if (!this.connName.equals(string)) {
            bl4 = true;
        }
        if (bl4) {
            String string2;
            String string3 = this.circuit.getCircuitNameFromSrcNode();
            this.connName = string;
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " connName changed");
            }
            if (!(string2 = this.circuit.getCircuitNameFromSrcNode()).equals(string3)) {
                this.circuit.updateCircuitName(string2);
            }
            this.circuit.setChanged();
        }
        if (this.rollStatusChanged()) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " inRoll flag changed");
            }
            this.updateConnection();
            return;
        }
        if (this.inRoll() && bl3 != this.rollHasCompleted) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " roll has completed");
            }
            this.circuit.setChanged();
        }
        if (this.circuit.getState() == 5 || this.circuit.getState() == 6) {
            if (this.conversionStatusChanged()) {
                this.updateConnection();
                return;
            }
        } else if (this.conversionStatusChanged()) {
            this.setInConnectionConversion(this.inConnectionConversion());
        }
        if (this.connType != (n = this.getConnTypeFromConnModel())) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " connType changed");
            }
            this.updateConnection();
            return;
        }
        if (bl) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " numPaths changed");
            }
            this.updateConnection();
            return;
        }
        if (bl2) {
            if (this.dbgOn()) {
                this.debug("handleChanges(" + this.getName() + "):" + " pathsList changed");
            }
            this.updateConnection();
            return;
        }
        if (this.isAnyChangeInEtherStpState()) {
            this.circuit.setChanged();
        }
    }

    private boolean rollStatusChanged() {
        boolean bl = this.inRoll();
        if (this.currRollStatus != bl) {
            if (this.dbgOn()) {
                db.println("rollStatus changed from " + this.currRollStatus + " to " + bl);
            }
            this.currRollStatus = bl;
            if (!this.currRollStatus) {
                this.rollHasCompleted = false;
            }
            return true;
        }
        return false;
    }

    protected void setCurrRollStatus(boolean bl) {
        this.currRollStatus = bl;
    }

    protected boolean deletedEventPending() {
        return this.updateEvent.deleted;
    }

    protected boolean inRoll() {
        if (this.getConn() != null) {
            boolean bl = false;
            try {
                bl = this.getConn().inRoll();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                return false;
            }
            catch (AbstractMethodError abstractMethodError) {
                return false;
            }
            if (this.dbgOn()) {
                db.println("inRoll: NCN " + this.getName() + " state => " + bl);
            }
            return bl;
        }
        return false;
    }

    protected boolean inConnectionConversion() {
        if (this.node.provides(Feature.ISTU) && this.getConn() != null) {
            boolean bl = false;
            try {
                bl = this.getConn().inConnectionConversion();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                return false;
            }
            catch (AbstractMethodError abstractMethodError) {
                return false;
            }
            if (this.dbgOn()) {
                db.println("inConnectionConversion: NCN " + this.getName() + "state => " + bl);
            }
            return bl;
        }
        return false;
    }

    private boolean conversionStatusChanged() {
        boolean bl = this.inConnectionConversion();
        if (this.currConversionStatus != bl) {
            if (this.dbgOn()) {
                db.println("conversionStatusChanged: old connConv state => " + this.currConversionStatus + ", new connConv " + "state => " + bl);
            }
            this.currConversionStatus = bl;
            return true;
        }
        return false;
    }

    protected void setInConnectionConversion(boolean bl) {
        if (bl) {
            this.setState(4);
        } else {
            this.setState(2);
        }
        if (this.dbgOn()) {
            db.println("setInConnectionConversion: state => " + bl);
        }
        this.circuit.setInConnectionConversion(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateConnection() throws AbstractCmsObjectNotExistException {
        if (this.dbgOn()) {
            this.debug("updateConnection() at " + this.getName());
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)this.circuit.getCircuitNodeFromNE(this.ne);
        netCircuitNode.conformToConnection();
        this.setState(2);
        Object object = this.entitiesLockObject;
        synchronized (object) {
            this.updateUpsrEntities(true);
        }
        if (!this.circuit.circuitInfoActive()) {
            if (!this.circuit.tl1CircuitCompleteCheck()) {
                this.circuit.checkAndUpdateCircuit();
            }
        } else if (!this.circuit.completeCheck()) {
            this.circuit.checkAndUpdateCircuit();
        }
    }

    protected void conformToConnection() {
        this.conformToConnection(NetCircuitSplicer.instance());
    }

    protected void conformToConnection(NetCircuitSplicer netCircuitSplicer) {
        if (this.dbgOn()) {
            this.debug("conformToConnection() at " + this.getName());
        }
        this.disposeSpans();
        this.cleanupSpliceListeners();
        this.drops = new LinkedList();
        this.sources = new LinkedList();
        this.setCircuitInfoNodeDrop();
        this.setConnectionType(this.getConnTypeFromConnModel());
        this.conformToPaths(this.getPathsFromConnModel(), netCircuitSplicer);
        this.setupConnListOnDiscovery();
    }

    protected void setCircuitInfoNodeDrop() {
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.circuit.getCircuitType(), this.getNetElement());
        if (this.circuit.isDrop(netCircuitEnd) || this.circuit.isSource(netCircuitEnd)) {
            netCircuitEnd.setStage(4);
            this.insertDrop(netCircuitEnd);
        } else {
            this.nodeDrop = null;
        }
        if (this.getConnTypeFromConnModel() == 18) {
            this.circuit.isDiag(true);
        }
    }

    protected boolean dbgOn() {
        return (db.on() || NetCircuitManager.pkgDbgOn()) && !NetCircuitManager.pkgDbgSuppressed();
    }

    private void debug(String string) {
        db.println(string);
    }

    protected int getDirection(NetCircuitSpan netCircuitSpan) {
        if (this.inSpans.contains(netCircuitSpan) || this.outSpans.contains(netCircuitSpan)) {
            return 0;
        }
        return 1;
    }

    protected boolean myPeerHasDrops(NetCircuitSpan netCircuitSpan) {
        if (this.connType == 2 || this.connType == 4 || this.connType == 0 || this.connType == 3) {
            return false;
        }
        NetCircuitNode netCircuitNode = null;
        NetCircuitSpan netCircuitSpan2 = this.findAlternateBiSpan(netCircuitSpan);
        if (netCircuitSpan2 != null) {
            netCircuitNode = this.spanGetPeer(netCircuitSpan2);
        }
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                db.println("Warning! getUpsrSpanActive: peer Node not found");
            }
            return false;
        }
        if (netCircuitNode.getDrops().size() != 0) {
            return true;
        }
        return netCircuitNode.myPeerHasDrops(netCircuitSpan2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getUpsrSpanState(NetCircuitSpan netCircuitSpan, int n) {
        if (this.dbgOn()) {
            db.println("getUpsrSpanState called at node " + this.getName() + " with spanState = " + EnumStrings.getString((Class)IUpsrSpanState.class, (int)n));
        }
        int n2 = -1;
        List list = null;
        if (!this.hasConnection()) {
            return 1;
        }
        if (!this.isNodeRefValid) {
            return 1;
        }
        Object object = this.entitiesLockObject;
        synchronized (object) {
            if (this.activeEntities == null) {
                this.updateUpsrActiveEntities();
            }
            list = this.activeEntities;
        }
        object = this.getWorkingSpans();
        List list2 = this.getProtectSpans();
        if (list != null) {
            if (list.contains(new Integer(netCircuitSpan.getEntityIndex(this.ne)))) {
                n2 = 0;
            } else if (object.contains(netCircuitSpan) || list2.contains(netCircuitSpan)) {
                n2 = 1;
            }
        }
        if (n != -1 && n2 != -1 && n2 != n) {
            return 2;
        }
        if (this.connType == 6 && !object.contains(netCircuitSpan) && !list2.contains(netCircuitSpan)) {
            if (n != -1) {
                return n;
            }
            if (n2 != -1) {
                return n2;
            }
            return 3;
        }
        NetCircuitNode netCircuitNode = null;
        NetCircuitSpan netCircuitSpan2 = null;
        BridgeConnection bridgeConnection = this.findBridgeConnForInspan(netCircuitSpan);
        if (bridgeConnection != null) {
            Iterator iterator = bridgeConnection.getOutSpans().iterator();
            while (iterator.hasNext() && (netCircuitSpan2 = (NetCircuitSpan)iterator.next()).isInternalSpan()) {
                netCircuitSpan2 = null;
            }
        } else {
            netCircuitSpan2 = this.findAltSpanForOneway(netCircuitSpan);
        }
        if (netCircuitSpan2 != null) {
            if (this.dbgOn()) {
                db.println("altSpan = " + netCircuitSpan2.availSpan.prettyString());
            }
            netCircuitNode = this.spanGetPeer(netCircuitSpan2);
        } else if (this.dbgOn()) {
            db.println("Warning! getUpsrSpanState: altSpan is null");
        }
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                db.println("Warning! getUpsrSpanState: peer Node not found");
            }
            if (n != -1) {
                return n;
            }
            if (n2 != -1) {
                return n2;
            }
            if (this.upsrBridgeOrSelector()) {
                if (this.dbgOn()) {
                    db.println("returning UNUSED");
                }
                return 3;
            }
            if (!this.circuit.isBidirectional() && !this.sources.isEmpty()) {
                return 3;
            }
            return 0;
        }
        if (n2 != -1) {
            return netCircuitNode.getUpsrSpanState(netCircuitSpan2, n2);
        }
        return netCircuitNode.getUpsrSpanState(netCircuitSpan2, n);
    }

    protected NetCircuitSpan getSpanFromPathDef(IPathDefModel iPathDefModel) {
        int n = this.getEntityIndexFromPathDef(iPathDefModel);
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.biSpans);
        linkedList.addAll(this.inSpans);
        linkedList.addAll(this.outSpans);
        Iterator iterator = linkedList.iterator();
        NetCircuitSpan netCircuitSpan = null;
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (n != netCircuitSpan.getEntityIndex(this.getNetElement())) continue;
            if (this.dbgOn()) {
                db.println("found span corresponding to path : " + netCircuitSpan.prettyString());
            }
            return netCircuitSpan;
        }
        return null;
    }

    public NetCircuitSpan getSpanFromCktEnd(NetCircuitEnd netCircuitEnd) {
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.biSpans);
        linkedList.addAll(this.inSpans);
        linkedList.addAll(this.outSpans);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitEnd.getEntityIndex() != netCircuitSpan.getEntityIndex(this.getNetElement()) || !hoLoComparator.isEqual(netCircuitEnd.getHoNum(), netCircuitSpan.getHoNum(this.getNetElement())) || !hoLoComparator.isEqual(netCircuitEnd.getLoNum(), netCircuitSpan.getLoNum())) continue;
            return netCircuitSpan;
        }
        return null;
    }

    protected NetCircuitSpan findAltSpanForUpsrDri(NetCircuitSpan netCircuitSpan) {
        Object var2_2 = null;
        NetCircuitSpan netCircuitSpan2 = null;
        Object[] objectArray = this.getPathsFromConnModel();
        int n = this.getPathDefIndexFromSpan(netCircuitSpan);
        if (this.connType == 10) {
            switch (n) {
                case 0: {
                    netCircuitSpan2 = this.getSpanFromPathDef((IPathDefModel)objectArray[1]);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    netCircuitSpan2 = this.getSpanFromPathDef((IPathDefModel)objectArray[0]);
                    break;
                }
                default: {
                    if (this.dbgOn()) {
                        db.println("Unknown path index " + n);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (this.connType == 11) {
            switch (n) {
                case 0: {
                    netCircuitSpan2 = this.getSpanFromPathDef((IPathDefModel)objectArray[1]);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    netCircuitSpan2 = this.getSpanFromPathDef((IPathDefModel)objectArray[3]);
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    if (this.dbgOn()) {
                        db.println("Unknown path index " + n);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (this.connType == 6) {
            switch (n) {
                case 0: {
                    netCircuitSpan2 = this.getSpanFromPathDef((IPathDefModel)objectArray[1]);
                    break;
                }
                case 1: {
                    netCircuitSpan2 = this.getSpanFromPathDef((IPathDefModel)objectArray[0]);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    if (!this.dbgOn()) break;
                    db.println("Unknown path index " + n);
                }
            }
        }
        if (this.dbgOn()) {
            db.println("findAltSpanForUpsrDri - " + this.node.getName());
            if (netCircuitSpan2 != null) {
                db.println("span = " + netCircuitSpan2.prettyString());
            } else {
                db.println("span = null");
            }
        }
        return netCircuitSpan2;
    }

    protected int getPathDefIndexFromSpan(NetCircuitSpan netCircuitSpan) {
        Object[] objectArray = this.getPathsFromConnModel();
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            n2 = this.getEntityIndexFromPathDef(objectArray[i]);
            if (n2 == 0 || n2 != netCircuitSpan.getEntityIndex(this.getNetElement()) || netCircuitSpan.getLink().isLOTunnel() && !HoLoComparator.instance().isEqual(this.getHoNumFromPathDef(objectArray[i]), netCircuitSpan.getHoNum(this.getNetElement()))) continue;
            n = i;
            break;
        }
        return n;
    }

    private int getPathDefIndexFromCktEnd(INetCircuitEnd iNetCircuitEnd) {
        Object[] objectArray = this.getPathsFromConnModel();
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            n2 = this.getEntityIndexFromPathDef(objectArray[i]);
            IHoNum iHoNum = this.getHoNumFromPathDef(objectArray[i]);
            ILoNum iLoNum = this.getLoNumFromPathDef(objectArray[i]);
            if (n2 == 0 || n2 != iNetCircuitEnd.getEntityIndex() || !HoLoComparator.instance().isEqual(iHoNum, iNetCircuitEnd.getHoNum()) || !HoLoComparator.instance().isEqual(iLoNum, iNetCircuitEnd.getLoNum())) continue;
            n = i;
            break;
        }
        return n;
    }

    protected int getUpsrReversionMode() {
        return -1;
    }

    public List getActivePathList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.isUpsrSelector()) {
            Object[] objectArray = this.getActivePathsFromConnModel();
            arrayList.addAll(Arrays.asList(objectArray));
        }
        return arrayList;
    }

    public List getPathList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.hasConnection()) {
            Object[] objectArray = this.getPathsFromConnModel();
            arrayList.addAll(Arrays.asList(objectArray));
        }
        return arrayList;
    }

    public int getNumberOfPaths() {
        return this.numberOfPaths;
    }

    public boolean getCktNodeStpEnabled() {
        return true;
    }

    protected int countOrigBiSpans() {
        int n = 0;
        Iterator iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (this.findRoutingDir(netCircuitSpan) != eSpanDirection.ORIGINATING) continue;
            ++n;
        }
        return n;
    }

    protected boolean isUpsrDriConn() {
        int n = this.findConnType();
        return n == 10 || n == 11;
    }

    protected NetCircuitNode getUpsrPeerNode(NetCircuitSpan netCircuitSpan) {
        NetCircuitNode netCircuitNode;
        NetCircuitSpan netCircuitSpan2 = netCircuitSpan;
        if (!this.isUpsrSelectorConn()) {
            return null;
        }
        for (netCircuitNode = this.spanGetPeer(netCircuitSpan2); netCircuitNode != null && (!netCircuitNode.isUpsrSelectorConn() || netCircuitNode.isUpsrDriConn()); netCircuitNode = netCircuitNode.spanGetPeer(netCircuitSpan2)) {
            if ((netCircuitSpan2 = netCircuitNode.findAlternateBiSpan(netCircuitSpan2)) != null) {
                continue;
            }
            return null;
        }
        return netCircuitNode;
    }

    protected NetCircuitSpan getUpsrPeerSpan(NetCircuitSpan netCircuitSpan) {
        NetCircuitSpan netCircuitSpan2 = netCircuitSpan;
        if (!this.isUpsrSelectorConn()) {
            return null;
        }
        for (NetCircuitNode netCircuitNode = this.spanGetPeer(netCircuitSpan2); netCircuitNode != null && (!netCircuitNode.isUpsrSelectorConn() || netCircuitNode.isUpsrDriConn()); netCircuitNode = netCircuitNode.spanGetPeer(netCircuitSpan2)) {
            if ((netCircuitSpan2 = netCircuitNode.findAlternateBiSpan(netCircuitSpan2)) != null) {
                continue;
            }
            return null;
        }
        return netCircuitSpan2;
    }

    public boolean containsCktEnd(NetCircuitEnd netCircuitEnd) {
        List list = this.getPathList();
        Iterator iterator = list.iterator();
        NetCircuitEnd netCircuitEnd2 = null;
        while (iterator.hasNext()) {
            netCircuitEnd2 = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), iterator.next());
            if (!netCircuitEnd2.equals(netCircuitEnd)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEgressPoint(NetCircuitEnd netCircuitEnd) {
        List list = this.getEgressPoints();
        if (list.contains(netCircuitEnd)) {
            if (this.dbgOn()) {
                db.println("isEgressPoint returns true for " + netCircuitEnd.prettyString());
            }
            return true;
        }
        if (this.dbgOn()) {
            db.println("isEgressPoint returns false for " + netCircuitEnd.prettyString());
        }
        return false;
    }

    protected boolean isIngressPoint(NetCircuitEnd netCircuitEnd) {
        List list = this.getIngressPoints();
        if (list.contains(netCircuitEnd)) {
            if (this.dbgOn()) {
                db.println("isIngressPoint returns true for " + netCircuitEnd.prettyString());
            }
            return true;
        }
        if (this.dbgOn()) {
            db.println("isIngressPoint returns false for " + netCircuitEnd.prettyString());
        }
        return false;
    }

    public synchronized List getIngressPoints() {
        Object object;
        NetCircuitEnd netCircuitEnd;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList linkedList2 = new LinkedList();
        linkedList2.addAll(this.biSpans);
        linkedList2.addAll(this.inSpans);
        NetCircuitSpan netCircuitSpan = null;
        INetLink iNetLink = null;
        Iterator iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            iNetLink = netCircuitSpan.getLink();
            if (iNetLink.getDst() == this.getNetElement()) {
                try {
                    netCircuitEnd = iNetLink.getDst().getNodeModel();
                    object = new NetCircuitEnd((INodeModel)netCircuitEnd, netCircuitEnd.getEntityTable().getEntityModelByIndex(iNetLink.getDstEntityIndex()), netCircuitSpan.getDstHoNum(), netCircuitSpan.getLoNum(), false);
                    if (linkedList.contains(object)) continue;
                    linkedList.add(object);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                continue;
            }
            if (iNetLink.getSrc() != this.getNetElement() || !this.isDriSpan(netCircuitSpan)) continue;
            try {
                netCircuitEnd = iNetLink.getSrc().getNodeModel();
                object = new NetCircuitEnd((INodeModel)netCircuitEnd, netCircuitEnd.getEntityTable().getEntityModelByIndex(iNetLink.getSrcEntityIndex()), netCircuitSpan.getSrcHoNum(), netCircuitSpan.getLoNum(), false);
                if (linkedList.contains(object)) continue;
                linkedList.add(object);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        netCircuitEnd = null;
        object = this.sources.iterator();
        while (object.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)object.next();
            if (linkedList.contains(netCircuitEnd)) continue;
            linkedList.add(netCircuitEnd);
        }
        if (this.dbgOn()) {
            db.println("getIngressPoints @ " + this.getName() + " returns: " + linkedList);
        }
        return linkedList;
    }

    public synchronized List getEgressPoints() {
        Object object;
        NetCircuitEnd netCircuitEnd;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList linkedList2 = new LinkedList();
        linkedList2.addAll(this.biSpans);
        linkedList2.addAll(this.outSpans);
        NetCircuitSpan netCircuitSpan = null;
        INetLink iNetLink = null;
        Iterator iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            iNetLink = netCircuitSpan.getLink();
            if (iNetLink.getSrc() == this.getNetElement()) {
                try {
                    netCircuitEnd = iNetLink.getSrc().getNodeModel();
                    object = new NetCircuitEnd((INodeModel)netCircuitEnd, netCircuitEnd.getEntityTable().getEntityModelByIndex(iNetLink.getSrcEntityIndex()), netCircuitSpan.getSrcHoNum(), netCircuitSpan.getLoNum(), false);
                    if (linkedList.contains(object)) continue;
                    linkedList.add(object);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                }
                continue;
            }
            if (iNetLink.getDst() != this.getNetElement() || !this.isDriSpan(netCircuitSpan)) continue;
            try {
                netCircuitEnd = iNetLink.getDst().getNodeModel();
                object = new NetCircuitEnd((INodeModel)netCircuitEnd, netCircuitEnd.getEntityTable().getEntityModelByIndex(iNetLink.getDstEntityIndex()), netCircuitSpan.getDstHoNum(), netCircuitSpan.getLoNum(), false);
                if (linkedList.contains(object)) continue;
                linkedList.add(object);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        netCircuitEnd = null;
        object = this.drops.iterator();
        while (object.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)object.next();
            if (linkedList.contains(netCircuitEnd)) continue;
            linkedList.add(netCircuitEnd);
        }
        if (this.dbgOn()) {
            db.println("getEgressPoints @ " + this.getName() + " returns: " + linkedList);
        }
        return linkedList;
    }

    protected HashMap getAllSpans() {
        HashMap<NetCircuitSpan, eSpanDirection> hashMap = new HashMap<NetCircuitSpan, eSpanDirection>();
        Iterator iterator = this.inSpans.iterator();
        while (iterator.hasNext()) {
            hashMap.put((NetCircuitSpan)iterator.next(), eSpanDirection.TERMINATING);
        }
        iterator = this.outSpans.iterator();
        while (iterator.hasNext()) {
            hashMap.put((NetCircuitSpan)iterator.next(), eSpanDirection.ORIGINATING);
        }
        iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            hashMap.put((NetCircuitSpan)iterator.next(), eSpanDirection.BIDIRECTIONAL);
        }
        return hashMap;
    }

    public List getAllSpansList() {
        LinkedList<NetCircuitSpan> linkedList = new LinkedList<NetCircuitSpan>();
        Iterator iterator = this.inSpans.iterator();
        while (iterator.hasNext()) {
            linkedList.add((NetCircuitSpan)iterator.next());
        }
        iterator = this.outSpans.iterator();
        while (iterator.hasNext()) {
            linkedList.add((NetCircuitSpan)iterator.next());
        }
        iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            linkedList.add((NetCircuitSpan)iterator.next());
        }
        return linkedList;
    }

    protected HashMap getSpansRoutingDirMap() {
        NetCircuitSpan netCircuitSpan;
        HashMap<NetCircuitSpan, eSpanDirection> hashMap = new HashMap<NetCircuitSpan, eSpanDirection>();
        Iterator iterator = this.inSpans.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            hashMap.put(netCircuitSpan, eSpanDirection.TERMINATING);
        }
        iterator = this.outSpans.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            hashMap.put(netCircuitSpan, eSpanDirection.ORIGINATING);
        }
        iterator = this.biSpans.iterator();
        while (iterator.hasNext()) {
            netCircuitSpan = (NetCircuitSpan)iterator.next();
            hashMap.put(netCircuitSpan, this.findRoutingDir(netCircuitSpan));
        }
        return hashMap;
    }

    public boolean involvedInUpsr(INetCircuitEnd iNetCircuitEnd) {
        NetCircuitSpan netCircuitSpan = this.getSpanFromCktEnd((NetCircuitEnd)iNetCircuitEnd);
        return netCircuitSpan != null && netCircuitSpan.isUpsr();
    }

    protected short getPathWidth() {
        return this.pathWidth;
    }

    public boolean hasLoopback() {
        boolean bl = false;
        if (this.getConn() != null && this.getNodeModel().provides(Feature.HASLPBK_IFACE)) {
            bl = this.getConn().hasLoopback();
        }
        return bl;
    }

    public boolean hasXcLoopback() {
        return false;
    }

    protected void registerNullCircuitConnection(INetElement iNetElement, Object object) {
        if (!this.registeredNullCircuitConnection) {
            TL1ObjectManager.instance().registerTL1Object(iNetElement, object, this);
            this.registeredNullCircuitConnection = true;
        }
    }

    protected void deregisterNullCircuitConnection(INetElement iNetElement, Object object) {
        if (this.registeredNullCircuitConnection) {
            TL1ObjectManager.instance().deregisterTL1Object(iNetElement, object);
            this.registeredNullCircuitConnection = false;
        }
    }

    public boolean areNodesEqual(INetCircuitNode iNetCircuitNode) {
        if (!this.getCircuit().equals(iNetCircuitNode.getCircuit())) {
            return false;
        }
        return this.getNetElement().equals(iNetCircuitNode.getNetElement());
    }

    protected NetCircuitEnd getLinkEndpoint(INetLink iNetLink) {
        NetCircuitEnd netCircuitEnd = null;
        Iterator iterator = this.spliceListeners.iterator();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel;
            SpliceListenerEntry spliceListenerEntry = (SpliceListenerEntry)iterator.next();
            SpliceLinkIndex spliceLinkIndex = spliceListenerEntry.spliceLinkIndex;
            SpliceListener spliceListener = spliceListenerEntry.spliceListener;
            if ((spliceLinkIndex.ne.getNodeId() != iNetLink.getSrc().getNodeId() || spliceLinkIndex.entityIndex != iNetLink.getSrcEntityIndex() || (iNetLink.isLOTunnel() || iNetLink.isLAP()) && !HoLoComparator.instance().isEqual(spliceListener.hoNum, iNetLink.getSrcHo())) && (spliceLinkIndex.ne.getNodeId() != iNetLink.getDst().getNodeId() || spliceLinkIndex.entityIndex != iNetLink.getDstEntityIndex() || (iNetLink.isLOTunnel() || iNetLink.isLAP()) && !HoLoComparator.instance().isEqual(spliceListener.hoNum, iNetLink.getDstHo()))) continue;
            INodeModel iNodeModel = this.getNodeModel();
            if (iNodeModel == null) {
                if (!this.dbgOn()) continue;
                db.println("getSpliceListener: the reference to node model of " + this.getName() + " is null!?");
                continue;
            }
            try {
                iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(spliceLinkIndex.entityIndex);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                iEntityModel = null;
            }
            if (iEntityModel == null) continue;
            netCircuitEnd = spliceListener.loNum == null ? new HoCircuitEnd(iNodeModel, iEntityModel, spliceListener.hoNum, null, false) : new LoCircuitEnd(iNodeModel, iEntityModel, spliceListener.hoNum, spliceListener.loNum, false);
            return netCircuitEnd;
        }
        return netCircuitEnd;
    }

    protected SpliceListenerEntry getSpliceListener(INetCircuitEnd iNetCircuitEnd, boolean bl) {
        Iterator iterator = this.spliceListeners.iterator();
        while (iterator.hasNext()) {
            SpliceListenerEntry spliceListenerEntry = (SpliceListenerEntry)iterator.next();
            NetCircuitEnd netCircuitEnd = this.getSpliceListenerEndpoint(spliceListenerEntry);
            if (!netCircuitEnd.equals(iNetCircuitEnd) || spliceListenerEntry.spliceListener.loAdit != bl || !this.getConnectionPathEnds().contains(iNetCircuitEnd)) continue;
            return spliceListenerEntry;
        }
        return null;
    }

    static TDMTerminology getTDMTerminology(INodeModel iNodeModel) {
        TDMTerminology tDMTerminology = null;
        tDMTerminology = iNodeModel != null ? iNodeModel.getTDMTerminology() : NetworkModel.instance().getCmsHostModel().getNodeModel().getTDMTerminology();
        return tDMTerminology;
    }

    protected boolean isIngressOnXm() {
        return false;
    }

    protected boolean hasDualConnections() {
        return false;
    }

    public List getUpsrConns() {
        LinkedList<IConnectionModel> linkedList = new LinkedList<IConnectionModel>();
        if (this.isUpsrSelector()) {
            linkedList.add(this.getConn());
        }
        return linkedList;
    }

    protected boolean onXm() {
        return false;
    }

    protected boolean onXm(int n) {
        if (Feature.provides((INodeModel)this.getNodeModel(), (Feature)Feature.DS3XM12)) {
            try {
                if (this.getEntityModel(n).onPortlessPort()) {
                    return true;
                }
            }
            catch (ObjNotFound objNotFound) {
                // empty catch block
            }
        }
        return false;
    }

    protected int getPairedPortlessPort(int n) {
        if (n % 2 == 0) {
            return n + 1;
        }
        return n - 1;
    }

    protected IEntityModel getEntityModel(int n) throws ObjNotFound {
        IEntityModel iEntityModel = null;
        IEntityTableModel iEntityTableModel = null;
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel != null && (iEntityTableModel = this.node.getEntityTable()) != null && n != 0) {
            try {
                iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                // empty catch block
            }
        }
        if (iEntityModel == null) {
            throw new ObjNotFound("Unable to get entity model for index: " + Integer.toHexString(n));
        }
        return iEntityModel;
    }

    protected boolean isSrcCoLocatedCktNode() {
        return false;
    }

    protected boolean isDstCoLocatedCktNode() {
        return false;
    }

    protected List getSrcCoLocatedCktEnds() {
        return new LinkedList();
    }

    protected List getDstCoLocatedCktEnds() {
        return new LinkedList();
    }

    public void setInternalSpliceLinkEnds() {
    }

    public void disposeActiveInternalSpliceLink(DualConnectionCircuitNode dualConnectionCircuitNode) {
        if (!this.hasConnection()) {
            return;
        }
        if (this.dbgOn()) {
            this.debug("disposeActiveInternalSpliceLink() at " + this.getNameAndClass());
        }
        Iterator iterator = this.getConnectionPathEnds().iterator();
        while (iterator.hasNext()) {
            int n;
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (!netCircuitEnd.onXm() && !dualConnectionCircuitNode.onInternalSpliceLink(netCircuitEnd)) continue;
            this.createSpliceListener(netCircuitEnd);
            if (this.circuit.circuitInfoActive()) continue;
            try {
                n = this.getConnectionPathIndex(netCircuitEnd);
            }
            catch (ConnectionPathNotFound connectionPathNotFound) {
                return;
            }
            eSpanDirection eSpanDirection2 = this.nodeRoutingDir.getPathRoutingDir(n);
            this.assumeSourceOrDrop(eSpanDirection2, netCircuitEnd);
        }
    }

    protected NetCircuitEnd getNodeDrop() {
        return this.nodeDrop;
    }

    protected boolean isBridgedOneWay(int n) {
        return (n == 0 || n == 4 || n == 9) && this.countNumOutputs() > 1;
    }

    String getNoLoCapableHoMessage() {
        TDMTerminology tDMTerminology = NetworkDefaults.getCmsHostTDMTerms();
        String string = tDMTerminology.getGeneralTerms(1);
        String string2 = tDMTerminology.getGeneralTerms(0);
        return "No " + string + " capable " + string2 + "s are available";
    }

    protected NetCircuitEnd convertSpliceListenerToSourceOrDrop(eSpanDirection eSpanDirection2) {
        NetCircuitEnd netCircuitEnd = null;
        Iterator iterator = this.spliceListeners.iterator();
        while (iterator.hasNext()) {
            block5: {
                eSpanDirection eSpanDirection3;
                SpliceListenerEntry spliceListenerEntry = (SpliceListenerEntry)iterator.next();
                if (spliceListenerEntry.spliceListener.loAdit || (eSpanDirection3 = spliceListenerEntry.spliceLinkIndex.direction) != eSpanDirection2 && eSpanDirection3 != eSpanDirection.BIDIRECTIONAL) continue;
                netCircuitEnd = this.getSpliceListenerEndpoint(spliceListenerEntry);
                if (eSpanDirection3 == eSpanDirection.BIDIRECTIONAL) {
                    try {
                        int n = this.getConnectionPathIndex(netCircuitEnd);
                        eSpanDirection eSpanDirection4 = this.nodeRoutingDir.getPathRoutingDir(n);
                        if (eSpanDirection4 != eSpanDirection2 && eSpanDirection4 != eSpanDirection.BIDIRECTIONAL) {
                        }
                        break block5;
                    }
                    catch (ConnectionPathNotFound connectionPathNotFound) {
                        if (!this.dbgOn()) continue;
                        this.debug("convertSpliceListenerToSourceOrDrop(" + this.getName() + "): Path not found");
                    }
                    continue;
                }
            }
            netCircuitEnd.setStage(4);
            this.assumeSourceOrDrop(eSpanDirection2, netCircuitEnd);
            this.setupConnListOnDiscovery();
            return netCircuitEnd;
        }
        return null;
    }

    protected void prettyPrint(List list) {
        if (this.dbgOn()) {
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.debug("Path " + n++ + "=" + this.prettyString((IPathDefModel)iterator.next()));
            }
        }
    }

    public boolean connectionless() {
        return this.getConn() == null;
    }

    private boolean isDriPathIndex(int n) {
        return this.connType == 10 ? n == 1 : (this.connType == 11 ? n == 1 || n == 3 : (this.connType == 14 ? n == 1 : (this.connType == 6 ? n == 1 : this.connType == 16 && n == 1)));
    }

    protected boolean isDriSpan(NetCircuitSpan netCircuitSpan) {
        return this.getDri() && this.isDriPathIndex(this.getPathDefIndexFromSpan(netCircuitSpan));
    }

    public boolean isDriCktEnd(INetCircuitEnd iNetCircuitEnd) {
        return this.getDri() && this.isDriPathIndex(this.getPathDefIndexFromCktEnd(iNetCircuitEnd));
    }

    protected boolean isRollToCktEnd(NetCircuitEnd netCircuitEnd) {
        return netCircuitEnd.equals(this.getRollToCktEnd());
    }

    protected NetCircuitEnd getRollFromCktEnd() {
        NetCircuitEnd netCircuitEnd = null;
        IRollModel iRollModel = this.getRoll();
        if (iRollModel != null) {
            netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), this.getRollFromPath(iRollModel));
        }
        return netCircuitEnd;
    }

    protected NetCircuitEnd getRollToCktEnd() {
        NetCircuitEnd netCircuitEnd = null;
        IRollModel iRollModel = this.getRoll();
        if (iRollModel != null) {
            netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), this.getRollToPath(iRollModel));
        }
        return netCircuitEnd;
    }

    protected boolean isCompletedRollToPath(Object object, IRollModel iRollModel) {
        return false;
    }

    private class BlsrPrimaryInfo {
        String blsrName;
        NetCircuitNode node;
        boolean usesPca;

        private BlsrPrimaryInfo() {
        }
    }

    private class UpdateEvent {
        public boolean changed;
        public boolean deleted;

        public UpdateEvent() {
            this.init();
        }

        public void init() {
            this.changed = false;
            this.deleted = false;
        }
    }

    public static class NetCircuitNodeByNodeNameComparator
    implements Comparator {
        private static NetCircuitNodeByNodeNameComparator inst = new NetCircuitNodeByNodeNameComparator();

        public static NetCircuitNodeByNodeNameComparator instance() {
            return inst;
        }

        public int compare(Object object, Object object2) {
            int n;
            if (object == null ^ object2 == null) {
                n = object == null ? -1 : 1;
            } else if (object == null && object2 == null) {
                n = 0;
            } else {
                if (!(object instanceof NetCircuitNode)) {
                    n = 1;
                }
                if (!(object2 instanceof NetCircuitNode)) {
                    n = -1;
                }
                String string = ((NetCircuitNode)object).getName();
                String string2 = ((NetCircuitNode)object2).getName();
                n = string == null ? (string2 == null ? 0 : 1) : string.compareTo(string2);
            }
            return n;
        }

        public boolean equals(Object object) {
            return this == object;
        }
    }
}

