/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.CallbackLinkComparator;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.HoCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.InternalSpliceLink;
import cerent.cms.ncp.InternalSpliceLinkComparator;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoCircuitNode;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.MissingLinks;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchccCircuitNode;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SpliceLinkIndex;
import cerent.cms.ncp.SpliceLinkIndexComparator;
import cerent.cms.ncp.SpliceListener;
import cerent.cms.ncp.SpliceListenerComparator;
import cerent.cms.ncp.SpliceListenerEntry;
import cerent.cms.ncp.SpliceListenerEntryComparator;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkFactory;
import cerent.cms.topo.Network;
import cerent.cms.topo.NonRoutableNetLink;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.ServerTrailLink;
import cerent.util.AnnotatedException;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class NetCircuitSplicer
implements Observer {
    private static NetCircuitSplicer splicer;
    private static SDebug db;
    public DumpDebug spliceTreeDump = new DumpDebug("SpliceTree");
    private Map linkEntries;
    private SpliceListenerComparator listenerComparator = new SpliceListenerComparator();
    private SpliceLinkIndexComparator linkIndexComparator = new SpliceLinkIndexComparator();
    private CallbackLinkComparator netLinkComparator = new CallbackLinkComparator();
    private InternalSpliceLinkComparator internalSpliceLinkComparator = new InternalSpliceLinkComparator();
    private TreeSet spliceListenersAddHolder;
    private TreeSet spliceListenersRemoveHolder;
    private List callbackLinksHolder;
    private List callbackIntLinksHolder;
    private TreeSet callbackLinks;
    private TreeSet callbackIntLinks;
    private Object holderLockObject;
    private Network net;
    private NetCircuitManager ncMgr;

    protected NetCircuitSplicer() {
        this.linkEntries = new TreeMap(this.linkIndexComparator);
        this.callbackLinks = new TreeSet(this.netLinkComparator);
        this.callbackIntLinks = new TreeSet(this.internalSpliceLinkComparator);
        this.callbackLinksHolder = new LinkedList();
        this.callbackIntLinksHolder = new LinkedList();
        SpliceListenerEntryComparator spliceListenerEntryComparator = new SpliceListenerEntryComparator();
        this.spliceListenersAddHolder = new TreeSet(spliceListenerEntryComparator);
        this.spliceListenersRemoveHolder = new TreeSet(spliceListenerEntryComparator);
        this.holderLockObject = new Object();
        this.net = null;
        this.ncMgr = null;
    }

    public static synchronized NetCircuitSplicer instance() {
        if (splicer == null) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Creating a Circuit Splicer");
            }
            splicer = new NetCircuitSplicer();
        }
        return splicer;
    }

    protected void initialize() {
        this.net = Network.instance();
        this.ncMgr = NetCircuitManager.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCallback(SpliceListenerEntry spliceListenerEntry) {
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("Queuing callback cancel for " + spliceListenerEntry.prettyString());
        }
        Object object = this.holderLockObject;
        synchronized (object) {
            this.spliceListenersAddHolder.remove(spliceListenerEntry);
            this.spliceListenersRemoveHolder.add(spliceListenerEntry);
        }
    }

    protected synchronized SpliceListener findListener(INetElement iNetElement, int n, eSpanDirection eSpanDirection2, IHoNum iHoNum, ILoNum iLoNum, boolean bl) {
        SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(iNetElement, n, eSpanDirection2);
        Map map = (Map)this.linkEntries.get(spliceLinkIndex);
        if (map == null) {
            return null;
        }
        SpliceListener spliceListener = new SpliceListener(iHoNum, iLoNum, null, bl);
        spliceListener = (SpliceListener)map.get(spliceListener);
        return spliceListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpliceListenerEntry registerCallback(INetElement iNetElement, int n, eSpanDirection eSpanDirection2, IHoNum iHoNum, ILoNum iLoNum, NetCircuitNode netCircuitNode, boolean bl) {
        Object object;
        INetLink iNetLink = null;
        INetLink iNetLink2 = null;
        INetLink iNetLink3 = null;
        INetLink iNetLink4 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        InternalSpliceLink internalSpliceLink = null;
        LinkedList<InternalSpliceLink> linkedList2 = new LinkedList<InternalSpliceLink>();
        SpliceListenerEntry spliceListenerEntry = new SpliceListenerEntry(iNetElement, n, eSpanDirection2, iHoNum, iLoNum, netCircuitNode, bl);
        if (this.net == null) {
            this.net = Network.instance();
        }
        if (eSpanDirection2 == eSpanDirection.ORIGINATING || eSpanDirection2 == eSpanDirection.BIDIRECTIONAL) {
            iNetLink = this.net.findNetLinkFromSource(false, iNetElement, n, iHoNum, iLoNum);
            if (iNetLink != null && (iNetLink2 = this.net.findReverseLink(iNetLink)) != null && !iNetLink2.isValidDstHoNumber(iHoNum)) {
                iNetLink2 = null;
            }
            if (iLoNum != null && (iNetLink3 = this.net.findNetLinkFromSource(true, iNetElement, n, iHoNum, iLoNum)) != null && (iNetLink4 = this.net.findReverseLink(iNetLink3)) != null && !iNetLink4.isValidDstHoNumber(iHoNum)) {
                iNetLink4 = null;
            }
        } else {
            iNetLink = this.net.findNetLinkFromDestination(false, iNetElement, n, iHoNum, iLoNum);
            if (iNetLink != null && (iNetLink2 = this.net.findReverseLink(iNetLink)) != null && !iNetLink2.isValidSrcHoNumber(iHoNum)) {
                iNetLink2 = null;
            }
            if (iLoNum != null && (iNetLink3 = this.net.findNetLinkFromDestination(true, iNetElement, n, iHoNum, iLoNum)) != null && (iNetLink4 = this.net.findReverseLink(iNetLink3)) != null && !iNetLink4.isValidSrcHoNumber(iHoNum)) {
                iNetLink4 = null;
            }
        }
        if (NetCircuitSplicer.dbgOn()) {
            if (iNetLink != null && this.hasNullTdmReverseLink(iNetLink, iNetLink2)) {
                NetCircuitSplicer.debug("registerCallback: WARNING-No reverse link for " + iNetLink.prettyString());
            }
            if (iNetLink3 != null && this.hasNullTdmReverseLink(iNetLink3, iNetLink4)) {
                NetCircuitSplicer.debug("registerCallback: WARNING-No reverse link for " + iNetLink3.prettyString());
            }
        }
        bl2 = iNetLink != null && !this.hasNullTdmReverseLink(iNetLink, iNetLink2);
        boolean bl4 = bl3 = iNetLink3 != null && !this.hasNullTdmReverseLink(iNetLink3, iNetLink4);
        if (bl3) {
            if (!linkedList.contains(iNetLink3)) {
                linkedList.add(iNetLink3);
            }
            if (eSpanDirection2 == eSpanDirection.BIDIRECTIONAL && iNetLink4 != null && !linkedList.contains(iNetLink4)) {
                linkedList.add(iNetLink4);
            }
        }
        if (bl2) {
            if (!linkedList.contains(iNetLink)) {
                linkedList.add(iNetLink);
            }
            if (eSpanDirection2 == eSpanDirection.BIDIRECTIONAL && iNetLink2 != null && !linkedList.contains(iNetLink2)) {
                linkedList.add(iNetLink2);
            }
        }
        if (iNetLink == null && iNetLink3 == null) {
            if (netCircuitNode instanceof OchccCircuitNode && bl) {
                if (OchTrailHelper.isTrunkPort(iNetElement.getNodeModel(), n)) {
                    int n2 = n;
                    try {
                        object = OchTrailHelper.getColocatedOchPorts(iNetElement, n2);
                        if (object != null) {
                            internalSpliceLink = eSpanDirection2 == eSpanDirection.ORIGINATING ? new InternalSpliceLink(iNetElement, n2, (int)object[0]) : new InternalSpliceLink(iNetElement, (int)object[1], n2);
                            linkedList2.add(internalSpliceLink);
                        }
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Exception getting co-located ports: " + (Object)((Object)abstractCmsNoSuchEntityException));
                        }
                    }
                    catch (FeatureUnsupported featureUnsupported) {
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Exception getting co-located ports: " + (Object)((Object)featureUnsupported));
                        }
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Exception getting co-located ports: " + (Object)((Object)noSuchInterface));
                        }
                    }
                }
            } else if (netCircuitNode instanceof OchncCircuitNode) {
                if (OchPortsHelper.isOchPort(iNetElement.getNodeModel(), n)) {
                    int n3 = n;
                    int n4 = OchTrailHelper.getColocatedTrunkPort(iNetElement.getNodeModel(), n3);
                    if (n4 != 0) {
                        internalSpliceLink = eSpanDirection2 == eSpanDirection.TERMINATING ? new InternalSpliceLink(iNetElement, n4, n3) : new InternalSpliceLink(iNetElement, n3, n4);
                        linkedList2.add(internalSpliceLink);
                    }
                }
            } else if ((netCircuitNode instanceof LoCircuitNode && bl || netCircuitNode instanceof HoCircuitNode) && netCircuitNode.onXm(n)) {
                int n5 = n;
                int n6 = netCircuitNode.getPairedPortlessPort(n5);
                internalSpliceLink = eSpanDirection2 == eSpanDirection.TERMINATING ? new InternalSpliceLink(iNetElement, n6, n5) : new InternalSpliceLink(iNetElement, n5, n6);
                linkedList2.add(internalSpliceLink);
            }
        }
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("Queuing callback register for " + spliceListenerEntry.prettyString());
        }
        object = this.holderLockObject;
        synchronized (object) {
            this.spliceListenersRemoveHolder.remove(spliceListenerEntry);
            this.spliceListenersAddHolder.add(spliceListenerEntry);
            this.callbackLinksHolder.addAll(linkedList);
            this.callbackIntLinksHolder.addAll(linkedList2);
        }
        return spliceListenerEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeSpliceListeners() {
        Object object = this.holderLockObject;
        synchronized (object) {
            Map map;
            SpliceListenerEntry spliceListenerEntry;
            Iterator iterator = this.spliceListenersAddHolder.iterator();
            while (iterator.hasNext()) {
                spliceListenerEntry = (SpliceListenerEntry)iterator.next();
                map = (TreeMap<SpliceListener, SpliceListener>)this.linkEntries.get(spliceListenerEntry.spliceLinkIndex);
                if (map == null) {
                    map = new TreeMap<SpliceListener, SpliceListener>(this.listenerComparator);
                    this.linkEntries.put(spliceListenerEntry.spliceLinkIndex, map);
                }
                map.put(spliceListenerEntry.spliceListener, spliceListenerEntry.spliceListener);
                if (!NetCircuitSplicer.dbgOn()) continue;
                NetCircuitSplicer.debug("Added " + spliceListenerEntry.prettyString() + " to listenerTree");
            }
            this.spliceListenersAddHolder.clear();
            iterator = this.spliceListenersRemoveHolder.iterator();
            while (iterator.hasNext()) {
                spliceListenerEntry = (SpliceListenerEntry)iterator.next();
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Deleting " + spliceListenerEntry.prettyString() + " from listenerTree");
                }
                if ((map = (Map)this.linkEntries.get(spliceListenerEntry.spliceLinkIndex)) == null) {
                    if (!NetCircuitSplicer.dbgOn()) continue;
                    NetCircuitSplicer.debug("Splice link index tree not found");
                    continue;
                }
                SpliceListener spliceListener = (SpliceListener)map.get(spliceListenerEntry.spliceListener);
                if (spliceListener == null) {
                    if (!NetCircuitSplicer.dbgOn()) continue;
                    NetCircuitSplicer.debug("Splice listener not found in listener tree");
                    continue;
                }
                map.remove(spliceListener);
            }
            this.spliceListenersRemoveHolder.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeCallbackLinks() {
        Object object = this.holderLockObject;
        synchronized (object) {
            Object object2;
            Iterator iterator = this.callbackLinksHolder.iterator();
            while (iterator.hasNext()) {
                object2 = (INetLink)iterator.next();
                if (this.callbackLinks.contains(object2)) continue;
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Adding " + object2.prettyString() + " to callback links");
                }
                if (object2.state() == 2) continue;
                this.callbackLinks.add(object2);
            }
            this.callbackLinksHolder.clear();
            iterator = this.callbackIntLinksHolder.iterator();
            while (iterator.hasNext()) {
                object2 = (InternalSpliceLink)iterator.next();
                if (this.callbackIntLinks.contains(object2)) continue;
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Adding " + ((InternalSpliceLink)object2).prettyString() + " to callback internal splice links");
                }
                this.callbackIntLinks.add(object2);
            }
            this.callbackIntLinksHolder.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newNetLink(INetLink iNetLink) {
        if (iNetLink instanceof NonRoutableNetLink) {
            return;
        }
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("newNetLink(" + iNetLink.prettyString() + ")");
        }
        INetLink iNetLink2 = Network.instance().findReverseLink(iNetLink);
        Object object = this.holderLockObject;
        synchronized (object) {
            this.callbackLinksHolder.add(iNetLink);
            iNetLink.addObserver(this);
            if (iNetLink2 != null) {
                this.callbackLinksHolder.add(iNetLink2);
                iNetLink2.addObserver(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeNetLink(INetLink iNetLink) {
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("changeNetLink(" + iNetLink.prettyString() + ")");
        }
        INetLink iNetLink2 = Network.instance().findReverseLink(iNetLink);
        Object object = this.holderLockObject;
        synchronized (object) {
            this.callbackLinksHolder.add(iNetLink);
            if (iNetLink2 != null) {
                this.callbackLinksHolder.add(iNetLink2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteNetLink(INetLink iNetLink) {
        if (iNetLink instanceof NonRoutableNetLink) {
            return;
        }
        Object object = this.holderLockObject;
        synchronized (object) {
            iNetLink.deleteObserver(this);
            this.callbackLinksHolder.remove(iNetLink);
        }
    }

    public synchronized int addNeToRing(INetElement iNetElement, Observer observer) throws MissingLinks, AnnotatedException {
        Object object;
        if (this.net == null) {
            this.net = Network.instance();
            if (this.net == null) {
                NetCircuitSplicer.debug("addNeToRing failed: Couldn't get network object");
                return 0;
            }
        }
        this.synchronizeSpliceListeners();
        this.synchronizeCallbackLinks();
        LinkedList linkedList = (LinkedList)this.net.findAllNetLinksWithSource(iNetElement);
        if (linkedList == null) {
            throw new MissingLinks("Netlink list null");
        }
        Iterator iterator = linkedList.iterator();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        while (iterator.hasNext()) {
            object = this.net.findReverseLink((INetLink)iterator.next());
            if (object == null) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("processAddNe: No reverse link for " + iNetElement.getName());
                }
                throw new MissingLinks("No reverse link!");
            }
            linkedList2.add(object);
        }
        object = linkedList2.listIterator(0);
        float f = linkedList2.size();
        int n = 0;
        int n2 = 0;
        while (object.hasNext()) {
            ListIterator listIterator;
            try {
                listIterator = linkedList2.listIterator(n2 + 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                if (!NetCircuitSplicer.dbgOn()) break;
                NetCircuitSplicer.debug("addNodeToNetwork: Done processing");
                break;
            }
            INetLink iNetLink = (INetLink)object.next();
            while (listIterator.hasNext()) {
                INetLink iNetLink2 = (INetLink)listIterator.next();
                n += this.spliceConnForMatchedListeners(iNetElement, iNetLink, iNetLink2);
            }
            if (observer != null) {
                float f2 = (float)n2 / f * 100.0f;
                observer.update(null, new Integer((int)Math.floor(f2)));
            }
            ++n2;
        }
        if (observer != null) {
            observer.update(null, new Integer(100));
        }
        return n;
    }

    public synchronized int addNeToOnePlusOne(INetElement iNetElement, IEntityModel iEntityModel, IEntityModel iEntityModel2, INetElement iNetElement2, IEntityModel iEntityModel3, INetElement iNetElement3, IEntityModel iEntityModel4, Observer observer) throws MissingLinks, AnnotatedException {
        return this.addNeToOnePlusOne(iNetElement, iEntityModel.getEntityIndex(), iEntityModel2.getEntityIndex(), iNetElement2, iEntityModel3.getEntityIndex(), iNetElement3, iEntityModel4.getEntityIndex(), observer);
    }

    private synchronized int addNeToOnePlusOne(INetElement iNetElement, int n, int n2, INetElement iNetElement2, int n3, INetElement iNetElement3, int n4, Observer observer) throws MissingLinks, AnnotatedException {
        CmsObservable cmsObservable;
        Object object;
        CmsObservable cmsObservable2;
        INetLink iNetLink;
        INetLink iNetLink2;
        int n5 = 0;
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("addNeToOnePlusOne(C=" + iNetElement.getName() + " CtoA=" + Integer.toHexString(n) + " CtoB=" + Integer.toHexString(n2) + " A=" + iNetElement2.getName() + " AtoC=" + Integer.toHexString(n3) + " B=" + iNetElement3.getName() + " BtoC=" + Integer.toHexString(n4));
        }
        if ((iNetLink2 = this.net.findNetLink(iNetElement2, n3, null, iNetElement3, n4, null, true)) == null) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("addNeToOnePlusOne: No A-->B link found");
            }
            throw new MissingLinks("Missing link from " + iNetElement2.getName() + " to " + iNetElement3.getName());
        }
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("addNeToOnePlusOne: link A-->B = " + iNetLink2.prettyString());
        }
        if ((iNetLink = this.net.findReverseLink(iNetLink2)) == null) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("addNeToOnePlusOne: No A<--B link found");
            }
            throw new MissingLinks("No reverse link");
        }
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("addNeToOnePlusOne: link A<--B = " + iNetLink.prettyString());
        }
        Iterator iterator = this.ncMgr.getCircuits().iterator();
        while (iterator.hasNext()) {
            NetCircuit netCircuit = (NetCircuit)iterator.next();
            if (netCircuit instanceof NetVcatCircuit) {
                cmsObservable2 = (NetVcatCircuit)netCircuit;
                object = ((NetVcatCircuit)cmsObservable2).getAllMemberCircuits().iterator();
                while (object.hasNext()) {
                    cmsObservable = (NetCircuit)object.next();
                    this.updateDeleted((NetCircuit)cmsObservable, iNetLink2, iNetLink);
                }
                continue;
            }
            this.updateDeleted(netCircuit, iNetLink2, iNetLink);
        }
        this.synchronizeSpliceListeners();
        this.synchronizeCallbackLinks();
        cmsObservable2 = this.createLocalNetLink(iNetLink2, iNetElement2, n3, iNetElement, n);
        object = this.createLocalNetLink(iNetLink2, iNetElement, n, iNetElement2, n3);
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("addNeToOnePlusOne: Created temp link A-->C");
            NetCircuitSplicer.debug("  " + ((NetLink)cmsObservable2).prettyString());
        }
        cmsObservable = this.createLocalNetLink(iNetLink2, iNetElement3, n4, iNetElement, n2);
        NetLink netLink = this.createLocalNetLink(iNetLink2, iNetElement, n2, iNetElement3, n4);
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("addNeToOnePlusOne: Created temp link B-->C");
            NetCircuitSplicer.debug("  " + ((NetLink)cmsObservable).prettyString());
        }
        n5 = this.spliceConnForMatchedListeners(iNetElement, (INetLink)((Object)cmsObservable2), (INetLink)object, (INetLink)((Object)cmsObservable), netLink);
        ((NetLink)cmsObservable2).dispose();
        ((NetLink)object).dispose();
        ((NetLink)cmsObservable).dispose();
        netLink.dispose();
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("addNeToOnePlusOne: updated " + n5 + " circuits");
        }
        return n5;
    }

    private void updateDeleted(NetCircuit netCircuit, INetLink iNetLink, INetLink iNetLink2) {
        INetCircuitSpan iNetCircuitSpan = netCircuit.getCircuitSpanFromNetLink(iNetLink);
        if (iNetCircuitSpan == null) {
            iNetCircuitSpan = netCircuit.getCircuitSpanFromNetLink(iNetLink2);
        }
        if (iNetCircuitSpan != null) {
            ((NetCircuitSpan)iNetCircuitSpan).updateDeleted();
        }
    }

    private NetLink createLocalNetLink(INetLink iNetLink, INetElement iNetElement, int n, INetElement iNetElement2, int n2) {
        ILinkModel iLinkModel = iNetLink.getLinkModel();
        INodeModel iNodeModel = iNetElement.getNodeModel();
        INodeModel iNodeModel2 = iNetElement2.getNodeModel();
        LinkModel linkModel = new LinkModel(iNodeModel, n, null, iNodeModel2, n2, null, iLinkModel.linkType(), iLinkModel.physicalType(), iLinkModel.physicalLinkType(), true, true, -1, -1, iLinkModel.protectionType(), "", 0, iLinkModel.protectionGroup(), iLinkModel.protectionRole(), iLinkModel.cost(), 0, 0);
        NetLink netLink = (NetLink)NetLinkFactory.createNetLink(this.net, (ILinkModel)linkModel, iNetElement, iNetElement2, iNetElement.getTopology(), false, false);
        return netLink;
    }

    protected boolean spliceAllowed(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        if (netCircuitNode.isUpsrOverOnePluOne() || netCircuitNode2.isUpsrOverOnePluOne()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Splicing denied on 1s/2d or 2s/1d UPSRover1+1 connections");
            }
            return false;
        }
        return this.spliceAllowed(netCircuitNode.getCircuit(), netCircuitNode2.getCircuit());
    }

    protected boolean spliceAllowed(INetCircuit iNetCircuit, INetCircuit iNetCircuit2) {
        ICircuitId iCircuitId = iNetCircuit.getCircuitId();
        ICircuitId iCircuitId2 = iNetCircuit2.getCircuitId();
        if (iCircuitId == null || iCircuitId2 == null) {
            return false;
        }
        if (iCircuitId.getNodeId() != 0 && iCircuitId2.getNodeId() != 0 && !iCircuitId.equals(iCircuitId2)) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceAllowed: Encountered circuit ID conflict");
            }
            return false;
        }
        return true;
    }

    private boolean spliceCheck(SpliceListener spliceListener, SpliceListener spliceListener2, boolean bl) {
        if (!spliceListener.node.isNodeRefValid() || !spliceListener2.node.isNodeRefValid()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceCheck: Invalid node reference");
            }
            return false;
        }
        INetCircuit iNetCircuit = spliceListener.node.getCircuit();
        INetCircuit iNetCircuit2 = spliceListener2.node.getCircuit();
        if (!iNetCircuit.isCircuitRefValid() || !iNetCircuit2.isCircuitRefValid()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceCheck: Invalid circuit reference");
            }
            return false;
        }
        if (!this.spliceAllowed(spliceListener.node, spliceListener2.node)) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceCheck: Failed spliceAllowed()");
            }
            return false;
        }
        if (!bl && iNetCircuit.getCircuitSize() != iNetCircuit2.getCircuitSize()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceCheck: Circuit size conflict");
            }
            return false;
        }
        if (iNetCircuit.getCircuitTypeObj().isOchncType() || iNetCircuit2.getCircuitTypeObj().isOchncType()) {
            if (spliceListener.optChannel != spliceListener2.optChannel || iNetCircuit.getCircuitDir() != iNetCircuit2.getCircuitDir()) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("spliceCheck: OCHNC Circuit optChannel or direction conflict (" + iNetCircuit.getCircuitName() + "/" + iNetCircuit.getCircuitTypeObj() + " has " + spliceListener.optChannel + ", " + iNetCircuit.getCircuitDir() + " - " + iNetCircuit2.getCircuitName() + "/" + iNetCircuit2.getCircuitTypeObj() + " has " + spliceListener2.optChannel + ", " + iNetCircuit2.getCircuitDir() + ")");
                }
                return false;
            }
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceCheck: OCHNC check on optChannel/direction succeeded (" + iNetCircuit.getCircuitName() + "/" + iNetCircuit.getCircuitTypeObj() + " has " + spliceListener.optChannel + ", " + iNetCircuit.getCircuitDir() + " - " + iNetCircuit2.getCircuitName() + "/" + iNetCircuit2.getCircuitTypeObj() + " has " + spliceListener2.optChannel + ", " + iNetCircuit2.getCircuitDir() + ")");
            }
        }
        return true;
    }

    private void addTl1TunnelEnd(SpliceListenerEntry spliceListenerEntry, SpliceListenerEntry spliceListenerEntry2, Object object, INetLink iNetLink) {
        NetCircuitNode netCircuitNode;
        SpliceListener spliceListener = spliceListenerEntry.spliceListener;
        SpliceLinkIndex spliceLinkIndex = spliceListenerEntry.spliceLinkIndex;
        SpliceListener spliceListener2 = spliceListenerEntry2.spliceListener;
        SpliceLinkIndex spliceLinkIndex2 = spliceListenerEntry2.spliceLinkIndex;
        NetCircuitNode netCircuitNode2 = spliceListener.node;
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)netCircuitNode2.getCircuit();
        INetLink iNetLink2 = null;
        boolean bl = true;
        if (object instanceof INetLink) {
            bl = true;
            iNetLink2 = (INetLink)object;
        } else if (object instanceof InternalSpliceLink) {
            bl = false;
        } else {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("addTl1TunnelEnd: ERROR-Invalid link object");
            }
            return;
        }
        INetCircuitNode iNetCircuitNode = netCcatCircuit.getCircuitNodeFromNE(spliceListener2.node.getNetElement());
        if (iNetCircuitNode != null && (iNetCircuitNode instanceof LoTunnelNode || iNetCircuitNode instanceof OchTrailTunnelNode || iNetCircuitNode instanceof DualConnectionCircuitNode)) {
            netCircuitNode = (NetCircuitNode)iNetCircuitNode;
        } else {
            IConnectionModel iConnectionModel = spliceListener2.node.getConn();
            int n = spliceLinkIndex2.entityIndex;
            ILoAditModel iLoAditModel = null;
            ILoDefModel[] iLoDefModelArray = null;
            if (iConnectionModel instanceof ILoConnectionModel) {
                iLoDefModelArray = ((ILoConnectionModel)iConnectionModel).getPaths();
            } else if (iConnectionModel instanceof IOchccConnectionModel) {
                iLoDefModelArray = ((IOchccConnectionModel)iConnectionModel).getPaths();
            }
            for (int i = 0; i < iLoDefModelArray.length; ++i) {
                IOchncPathDefModel[] iOchncPathDefModelArray;
                ILoDefModel iLoDefModel = iLoDefModelArray[i];
                ILoAditModel iLoAditModel2 = null;
                if (iLoDefModel instanceof ILoDefModel) {
                    iLoAditModel2 = iLoDefModel.getLoAdit();
                } else if (iLoDefModel instanceof IOchccPathDefModel) {
                    iLoAditModel2 = ((IOchccPathDefModel)iLoDefModel).getOchTrailAdit();
                }
                int n2 = 0;
                if (iLoAditModel2 instanceof ILoAditModel) {
                    iOchncPathDefModelArray = iLoAditModel2.getHo();
                    n2 = iOchncPathDefModelArray.getPool().getEntityIndex();
                } else if (iLoAditModel2 instanceof IOchTrailAditModel) {
                    iOchncPathDefModelArray = ((IOchTrailAditModel)iLoAditModel2).getPaths();
                    n2 = iOchncPathDefModelArray[0].getPortEntityIdx();
                }
                if (n2 != n) continue;
                iLoAditModel = iLoAditModel2;
                break;
            }
            if (iLoAditModel == null) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("addTl1TunnelEnd: ERROR: Could not find tunnel adit model");
                }
                return;
            }
            netCircuitNode = NetCircuitNodeFactory.createCircuitNode(spliceListener2.node.getNetElement(), netCcatCircuit, iLoAditModel);
            netCircuitNode.setState(2);
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(netCcatCircuit.getCircuitType(), spliceListener2.node.getNetElement());
            netCircuitEnd.setStage(4);
            netCircuitNode.insertDrop(netCircuitEnd);
            if (bl) {
                netCcatCircuit.insertCktNode(netCircuitNode);
            } else {
                NetCircuitNodeFactory.createDualConnectionCircuitNode(netCircuitNode2, netCircuitNode);
            }
            netCircuitNode.cleanupSpliceListeners();
        }
        if (bl) {
            NetLinkSpan netLinkSpan = spliceLinkIndex2.direction != eSpanDirection.BIDIRECTIONAL || spliceLinkIndex.direction != eSpanDirection.BIDIRECTIONAL ? new NetLinkSpan(iNetLink2, iNetLink, (ILabel)spliceListener2.hoNum, (ILabel)spliceListener2.hoNum) : (iNetLink2.getSrc().equals(netCircuitNode2.getNetElement()) ? new NetLinkSpan(iNetLink2, iNetLink, (ILabel)spliceListener2.hoNum, (ILabel)spliceListener2.hoNum) : new NetLinkSpan(iNetLink, iNetLink2, (ILabel)spliceListener2.hoNum, (ILabel)spliceListener2.hoNum));
            NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(netCcatCircuit, netLinkSpan);
            netCircuitSpan.setSrcState(4);
            netCircuitSpan.setDstState(4);
            netCircuitNode.addActiveSpan(netCircuitSpan, spliceLinkIndex2.direction);
            netCircuitNode2.addActiveSpan(netCircuitSpan, spliceLinkIndex.direction);
        }
    }

    private boolean spliceTl1TunnelEnd(SpliceListenerEntry spliceListenerEntry, SpliceListenerEntry spliceListenerEntry2, Object object, INetLink iNetLink, boolean bl, boolean bl2) {
        int n;
        boolean bl3;
        NetCcatCircuit netCcatCircuit;
        SpliceListenerEntry spliceListenerEntry3;
        Object object2;
        SpliceListenerEntry spliceListenerEntry4;
        Object object3;
        INetLink iNetLink2 = null;
        InternalSpliceLink internalSpliceLink = null;
        boolean bl4 = true;
        if (object instanceof INetLink) {
            bl4 = true;
            iNetLink2 = (INetLink)object;
        } else if (object instanceof InternalSpliceLink) {
            bl4 = false;
            internalSpliceLink = (InternalSpliceLink)object;
        } else {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: ERROR-Invalid link object");
            }
            return false;
        }
        if (NetCircuitSplicer.dbgOn()) {
            object3 = bl4 ? iNetLink2.prettyString() : internalSpliceLink.prettyString();
            NetCircuitSplicer.debug("spliceTl1TunnelEnd for " + (String)object3);
        }
        object3 = spliceListenerEntry.spliceListener;
        SpliceListener spliceListener = spliceListenerEntry2.spliceListener;
        NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)((SpliceListener)object3).node.getCircuit();
        NetCcatCircuit netCcatCircuit3 = (NetCcatCircuit)spliceListener.node.getCircuit();
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("Splicing TL1 tunnel end listeners: " + ((SpliceListener)object3).prettyString() + " and " + spliceListener.prettyString());
        }
        if (((SpliceListener)object3).loAdit && spliceListener.loAdit) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: Both listeners cannot be Adits");
            }
            return false;
        }
        if (((SpliceListener)object3).loAdit) {
            Object object4 = object3;
            spliceListenerEntry4 = spliceListenerEntry;
            NetCcatCircuit netCcatCircuit4 = netCcatCircuit2;
            object2 = spliceListener;
            spliceListenerEntry3 = spliceListenerEntry2;
            netCcatCircuit = netCcatCircuit3;
            bl3 = bl2;
        } else if (spliceListener.loAdit) {
            SpliceListener spliceListener2 = spliceListener;
            spliceListenerEntry4 = spliceListenerEntry2;
            NetCcatCircuit netCcatCircuit5 = netCcatCircuit3;
            object2 = object3;
            spliceListenerEntry3 = spliceListenerEntry;
            netCcatCircuit = netCcatCircuit2;
            bl3 = bl;
        } else {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: No loAdit found");
            }
            return false;
        }
        if (!(((SpliceListener)object2).node instanceof OchncCircuitNode) && !bl3) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Unidirectional TL1 tunnels are not recognized as links");
            }
            return false;
        }
        int n2 = ((SpliceListener)object2).node.getNetElement().getNodeModel().getFramingType();
        IFramingType iFramingType = FramingType.getFramingType((int)n2);
        if (netCcatCircuit.getCircuitTypeObj().isLAPCircuitType() || netCcatCircuit.getCircuitTypeObj().isHoCircuitType()) {
            n = CircuitSize.getLoTunnelSize((int)n2).getEnum();
            if (netCcatCircuit.getCircuitSize() != n) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("spliceTl1Lot:: hoCkt size does not match LAP/LOT");
                }
                return false;
            }
        }
        if (netCcatCircuit.getCircuitTypeObj().isLAPCircuitType()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: Converting LAP to LOT ");
            }
            netCcatCircuit.checkAndUpdateCircuit();
            this.ncMgr.removeCircuitIfLAP(netCcatCircuit);
            n = iFramingType.getTunnelCircuitType();
            netCcatCircuit.setCircuitType(n);
            this.addTl1TunnelEnd(spliceListenerEntry3, spliceListenerEntry4, object, iNetLink);
            netCcatCircuit.tl1CircuitCompleteCheck();
        } else if (netCcatCircuit.getCircuitTypeObj().isHoCircuitType()) {
            NetCircuitEnd netCircuitEnd = ((SpliceListener)object2).node.getSpliceListenerEndpoint(spliceListenerEntry3);
            if (netCcatCircuit.isSource(netCircuitEnd)) {
                try {
                    netCcatCircuit.reverseRoutingDir();
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("spliceTl1TunnelEnd: Error during ckt. reversal");
                    }
                    return false;
                }
            }
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: Converting circuit to LAP");
            }
            int n3 = iFramingType.getAggCircuitType();
            netCcatCircuit.setCircuitType(n3);
            this.addTl1TunnelEnd(spliceListenerEntry3, spliceListenerEntry4, object, iNetLink);
            netCcatCircuit.tl1CircuitCompleteCheck();
            this.ncMgr.insertCircuitIfLAP(netCcatCircuit);
        } else if (netCcatCircuit.getCircuitTypeObj().isOchncType() || netCcatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            if (netCcatCircuit.getCircuitTypeObj().isOchncType()) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("spliceTl1TunnelEnd: Converting OCHNC circuit to OTT");
                }
                netCcatCircuit.setCircuitType(15);
                netCcatCircuit.checkAndUpdateCircuit();
            } else if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: Completing OTT circuit");
            }
            this.addTl1TunnelEnd(spliceListenerEntry3, spliceListenerEntry4, object, iNetLink);
            netCcatCircuit.tl1CircuitCompleteCheck();
        } else {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: Invalid Circuit Type ");
            }
            return false;
        }
        netCcatCircuit.notifyChanged();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spliceListenersInTrees(Map map, Map map2, SpliceLinkIndex spliceLinkIndex, SpliceLinkIndex spliceLinkIndex2, Object object, INetLink iNetLink, boolean bl, boolean bl2) {
        Object object2;
        TreeMap<SpliceListener, SpliceListener> treeMap = new TreeMap<SpliceListener, SpliceListener>(this.listenerComparator);
        INetLink iNetLink2 = null;
        InternalSpliceLink internalSpliceLink = null;
        boolean bl3 = true;
        if (object instanceof INetLink) {
            bl3 = true;
            iNetLink2 = (INetLink)object;
        } else if (object instanceof InternalSpliceLink) {
            bl3 = false;
            internalSpliceLink = (InternalSpliceLink)object;
        } else {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceListenersinTrees: ERROR-Invalid link object");
            }
            return;
        }
        if (map == null || map2 == null) {
            return;
        }
        if (NetCircuitSplicer.dbgOn()) {
            object2 = bl3 ? iNetLink2.prettyString() : internalSpliceLink.prettyString();
            NetCircuitSplicer.debug("spliceListenersinTrees for " + (String)object2);
        }
        object2 = map.values().iterator();
        while (object2.hasNext()) {
            SpliceListener spliceListener;
            SpliceListener spliceListener2;
            IHoLoNum iHoLoNum;
            Object object3;
            IHoNum iHoNum;
            SpliceListener spliceListener3 = (SpliceListener)object2.next();
            Object object4 = (NetCcatCircuit)spliceListener3.node.getCircuit();
            ICircuitType iCircuitType = ((NetCircuit)object4).getCircuitTypeObj();
            treeMap.clear();
            if (bl3) {
                if (!iNetLink2.isValidSrcHoNumber(spliceListener3.hoNum)) {
                    if (!NetCircuitSplicer.dbgOn()) continue;
                    NetCircuitSplicer.debug("spliceListenersinTrees: Link does not support HO num" + spliceListener3.hoNum.getHoNum());
                    continue;
                }
                iHoNum = iNetLink2.getLinkType() == 2 ? iNetLink2.getDstHo() : spliceListener3.hoNum;
            } else {
                iHoNum = spliceListener3.hoNum;
            }
            if (spliceListener3.loAdit && this.aditListenerSuperceded(map, spliceListener3)) continue;
            if (bl3 && iNetLink2.isServerTrail()) {
                object3 = null;
                if (spliceListener3.loNum != null) {
                    iHoLoNum = ((ServerTrailLink)iNetLink2).getDstHoLo(spliceListener3.hoNum, spliceListener3.loNum);
                    iHoNum = iHoLoNum.getHoNum();
                    object3 = iHoLoNum.getLoNum();
                } else {
                    iHoNum = ((ServerTrailLink)iNetLink2).getDstHo(spliceListener3.hoNum);
                }
                spliceListener2 = new SpliceListener(iHoNum, (ILoNum)object3, null, false);
            } else {
                spliceListener2 = new SpliceListener(iHoNum, spliceListener3.loNum, null, false);
            }
            while (true) {
                if ((spliceListener = (SpliceListener)this.findNextMatch(map2, treeMap, spliceListener2)) == null && spliceListener3.loNum == null && !spliceListener3.loAdit) {
                    spliceListener2.loNum = null;
                    spliceListener2.loAdit = true;
                    spliceListener = (SpliceListener)this.findNextMatch(map2, treeMap, spliceListener2);
                    if (spliceListener != null && spliceListener.loAdit && this.aditListenerSuperceded(map2, spliceListener)) continue;
                }
                if (spliceListener == null || this.spliceCheck(spliceListener3, spliceListener, spliceListener3.loAdit || spliceListener.loAdit)) break;
                treeMap.put(spliceListener, spliceListener);
            }
            if (spliceListener == null) continue;
            SpliceListenerEntry spliceListenerEntry = new SpliceListenerEntry(spliceLinkIndex, spliceListener3);
            SpliceListenerEntry spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex2, spliceListener);
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Splicing listeners: " + spliceListenerEntry.prettyString() + " and " + spliceListenerEntry2.prettyString());
            }
            object3 = (NetCcatCircuit)spliceListener.node.getCircuit();
            iHoLoNum = ((NetCircuit)object3).getCircuitTypeObj();
            NetCcatCircuit netCcatCircuit = object4;
            synchronized (netCcatCircuit) {
                block58: {
                    block60: {
                        block59: {
                            if (!spliceListener3.node.isNodeRefValid() || !spliceListener.node.isNodeRefValid()) {
                                if (NetCircuitSplicer.dbgOn()) {
                                    NetCircuitSplicer.debug("Node on ckt got deleted - skipping");
                                }
                                continue;
                            }
                            if (object4 == object3) break block59;
                            if (!this.spliceAllowed(spliceListener3.node, spliceListener.node)) {
                                if (NetCircuitSplicer.dbgOn()) {
                                    NetCircuitSplicer.debug("Splice match for two non-null circuits. Skipping");
                                }
                                continue;
                            }
                            if (!(spliceListener3.loAdit || spliceListener.loAdit || this.passedTwoConnsSameNECheck((INetCircuit)object4, (INetCircuit)object3))) {
                                continue;
                            }
                            if (!bl3 || iNetLink2.isLAP()) break block60;
                            if (iCircuitType.isLAPCircuitType()) {
                                if (NetCircuitSplicer.dbgOn()) {
                                    NetCircuitSplicer.debug("Splicer: Extending existing TL1-LAP circuit");
                                }
                                ((NetCcatCircuit)object4).checkAndUpdateCircuit();
                            }
                            if (!iHoLoNum.isLAPCircuitType()) break block60;
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Splicer: Extending existing TL1-LAP circuit");
                            }
                            ((NetCcatCircuit)object3).checkAndUpdateCircuit();
                            break block60;
                        }
                        if (!bl3) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Internal splice cancelled: Both xconns from same circuit.");
                            }
                            object2.remove();
                            spliceListener3.node.removeSpliceListener(spliceListenerEntry);
                            map2.remove(spliceListener);
                            spliceListener.node.removeSpliceListener(spliceListenerEntry2);
                            continue;
                        }
                        if (iCircuitType.isTunnelCircuitType() && iNetLink2.isLOTunnel()) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Attempt to splice LOT ckt with LOT link. Skipping...");
                            }
                            continue;
                        }
                        if (iCircuitType.isLAPCircuitType() && iNetLink2.isLAP()) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Attempt to splice LAP ckt with LAP net link. Skipping...");
                            }
                            continue;
                        }
                        if (iCircuitType.isOchTrailTunnelCircuitType() && iNetLink2 instanceof OchTrailTunnelNetLink) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Attempt to splice OTT ckt with OTT net link. Skipping...");
                            }
                            continue;
                        }
                        if (this.alreadyConnected(spliceListener3.node, spliceListener.node)) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Two nodes have already connected.");
                            }
                            continue;
                        }
                    }
                    if (!((NetCircuit)object4).isCircuitRefValid()) {
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Splicer: Circuit got destroyed. Skipping");
                        }
                        continue;
                    }
                    if (spliceListener3.loAdit || spliceListener.loAdit) {
                        if (bl3 && (iNetLink2.isLAP() || iNetLink2.isLOTunnel() || iNetLink2.isOchTrailTunnel())) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Skipping LoAdit listener on tunnel links");
                            }
                            continue;
                        }
                        if (this.spliceTl1TunnelEnd(spliceListenerEntry, spliceListenerEntry2, object, iNetLink, bl, bl2)) {
                            object2.remove();
                            spliceListener3.node.removeSpliceListener(spliceListenerEntry);
                            map2.remove(spliceListener);
                            spliceListener.node.removeSpliceListener(spliceListenerEntry2);
                        }
                        continue;
                    }
                    object2.remove();
                    spliceListener3.node.removeSpliceListener(spliceListenerEntry);
                    map2.remove(spliceListener);
                    spliceListener.node.removeSpliceListener(spliceListenerEntry2);
                    if (bl3) {
                        NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink2, iNetLink, spliceListener3.hoNum, iHoNum, spliceListener3.loNum);
                        NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan((INetCircuit)object4, netLinkSpan);
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Created the splicing span");
                        }
                        netCircuitSpan.setSrcState(4);
                        netCircuitSpan.setDstState(4);
                        if (bl && bl2 && ((NetCcatCircuit)object4).isBiDirSpanKnown(netCircuitSpan)) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Span already present in circuit. Skipping");
                            }
                            continue;
                        }
                        spliceListener3.node.addActiveSpan(netCircuitSpan, bl ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.ORIGINATING);
                        spliceListener.node.addActiveSpan(netCircuitSpan, bl2 ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.TERMINATING);
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Successfully added active splicing span");
                        }
                        try {
                            this.completeSplice(spliceListener3.node, spliceListener.node);
                            break block58;
                        }
                        catch (AbstractCmsIOException abstractCmsIOException) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Exception on complete check! Undoing " + (Object)((Object)abstractCmsIOException));
                            }
                            spliceListener3.node.disposeActiveSpan(netCircuitSpan);
                            spliceListener.node.disposeActiveSpan(netCircuitSpan);
                            netCircuitSpan.dispose();
                            continue;
                        }
                        catch (IllegalStateException illegalStateException) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Exception on unify! Undoing " + illegalStateException);
                            }
                            spliceListener3.node.disposeActiveSpan(netCircuitSpan);
                            spliceListener.node.disposeActiveSpan(netCircuitSpan);
                            netCircuitSpan.dispose();
                            continue;
                        }
                    }
                    ((NetCcatCircuit)object4).unify((NetCcatCircuit)object3);
                }
            }
            if (!((NetCircuit)object3).isCircuitRefValid()) {
                ((NetCcatCircuit)object3).notifyDeleted();
            } else if (!((NetCircuit)object4).isCircuitRefValid()) {
                ((NetCcatCircuit)object4).notifyDeleted();
                object4 = object3;
            }
            ((NetCcatCircuit)object4).notifyChanged();
            if (((NetCircuit)object4).getState() != 1 || !iCircuitType.isTunnelCircuitType()) continue;
            this.spliceListenersInTrees(map, map2, spliceLinkIndex, spliceLinkIndex2, ((NetCcatCircuit)object4).getLotLink(), ((NetCcatCircuit)object4).getReverseLotLink(), bl, bl2);
            this.spliceListenersInTrees(map, map2, spliceLinkIndex, spliceLinkIndex2, iNetLink2, iNetLink, bl, bl2);
            break;
        }
    }

    private boolean aditListenerSuperceded(Map map, SpliceListener spliceListener) {
        SpliceListener spliceListener2 = new SpliceListener(spliceListener.hoNum, null, null, false);
        if (this.findNextMatch(map, null, spliceListener2) != null) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Matching HO listener for adit found;  (Skipping the Adit Listener) ");
            }
            return true;
        }
        return false;
    }

    protected boolean passedTwoConnsSameNECheck(INetCircuit iNetCircuit, INetCircuit iNetCircuit2) {
        NetCircuitNode netCircuitNode;
        INetElement iNetElement = null;
        Iterator iterator = iNetCircuit.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            if (iNetCircuit2.getCircuitNodeFromNE(netCircuitNode.getNetElement()) == null) continue;
            iNetElement = netCircuitNode.getNetElement();
            break;
        }
        if (iNetElement != null) {
            netCircuitNode = iNetCircuit.getCircuitTypeObj();
            if (!(netCircuitNode.isHoCircuitType() || netCircuitNode.isLAPCircuitType() || netCircuitNode.isOchncType() || netCircuitNode.isOchTrailTunnelCircuitType())) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Splice skipped: Circuit type does not support 2 conns on same NE");
                }
                return false;
            }
            if (((NetCircuitNode)iNetCircuit2.getCircuitNodeFromNE(iNetElement)).hasDualConnections() || ((NetCircuitNode)iNetCircuit.getCircuitNodeFromNE(iNetElement)).hasDualConnections()) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("splice skipped: already has 2 conns on same NE");
                }
                return false;
            }
        }
        return true;
    }

    private void spliceLapListenerInSrcTree(Map map, SpliceLinkIndex spliceLinkIndex, INetLink iNetLink, INetLink iNetLink2, boolean bl) {
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("spliceLapListenerInSrcTree for " + iNetLink.prettyString());
        }
        if (!iNetLink.isLAP()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("called for non- lap link");
            }
            return;
        }
        if (map == null) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Source tree is null!");
            }
            return;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            SpliceListener spliceListener = (SpliceListener)iterator.next();
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("considering splice listener " + spliceListener.prettyString());
            }
            if (!iNetLink.isValidSrcHoNumber(spliceListener.hoNum)) continue;
            if (spliceListener.loNum == null) {
                if (!NetCircuitSplicer.dbgOn()) continue;
                NetCircuitSplicer.debug("skipping over this listener");
                continue;
            }
            IHoNum iHoNum = iNetLink.getDstHo();
            NetCircuitNode netCircuitNode = spliceListener.node;
            LoCcatCircuit loCcatCircuit = (LoCcatCircuit)netCircuitNode.getCircuit();
            NetCircuitNode netCircuitNode2 = (NetCircuitNode)loCcatCircuit.getCircuitNodeFromNE(iNetLink.getDst());
            boolean bl2 = false;
            if (netCircuitNode2 == null) {
                if (loCcatCircuit.circuitInfoActive()) {
                    int n = 0;
                    Iterator iterator2 = loCcatCircuit.getDropCktEnds().iterator();
                    for (int i = 0; i < 2; ++i) {
                        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator2.next();
                        if (netCircuitEnd.getNetElement() != iNetLink.getDst()) {
                            ++n;
                        }
                        iterator2 = loCcatCircuit.getSources().iterator();
                    }
                    if (n == loCcatCircuit.getDrops().size() + loCcatCircuit.getSources().size()) continue;
                }
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("circuit node on LAP HO grooming end not found, creating one");
                }
                HoCcatCircuit hoCcatCircuit = (HoCcatCircuit)((NetLink)iNetLink).getLotCircuit();
                netCircuitNode2 = loCcatCircuit.createLapHoCircuitNode(hoCcatCircuit, iNetLink.getDst(), iNetLink.getDstEntityIndex(), iNetLink.getDstHo(), spliceListener.loNum, false);
                bl2 = true;
            }
            NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink, iNetLink2, spliceListener.hoNum, iHoNum, spliceListener.loNum);
            NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(loCcatCircuit, netLinkSpan);
            netCircuitSpan.setSrcState(4);
            netCircuitSpan.setDstState(4);
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Adding active spans to the circuit");
            }
            netCircuitNode.addActiveSpan(netCircuitSpan, bl ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.ORIGINATING);
            netCircuitNode2.addActiveSpan(netCircuitSpan, bl ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.TERMINATING);
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("removing splice listener");
            }
            netCircuitNode.removeSpliceListener(new SpliceListenerEntry(spliceLinkIndex, spliceListener));
            if (bl2) {
                loCcatCircuit.lapNodeCreated(netCircuitNode2);
            }
            iterator.remove();
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceLapListenerInSrcTree: check circuit's completeness");
            }
            if (loCcatCircuit.circuitInfoActive()) {
                loCcatCircuit.completeCheck();
            } else {
                loCcatCircuit.tl1CircuitCompleteCheck();
            }
            loCcatCircuit.notifyChanged();
        }
    }

    private void spliceLapListenerInDstTree(Map map, SpliceLinkIndex spliceLinkIndex, INetLink iNetLink, INetLink iNetLink2, boolean bl) {
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("spliceLapListenerInDstTree for " + iNetLink.prettyString());
        }
        if (!iNetLink.isLAP()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("called for non- lap link");
            }
            return;
        }
        if (map == null) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Destination tree is null!");
            }
            return;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            SpliceListener spliceListener = (SpliceListener)iterator.next();
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("considering splice listener " + spliceListener.prettyString());
            }
            if (!iNetLink.isValidDstHoNumber(spliceListener.hoNum)) continue;
            if (spliceListener.loNum == null) {
                if (!NetCircuitSplicer.dbgOn()) continue;
                NetCircuitSplicer.debug("skipping over this listener");
                continue;
            }
            IHoNum iHoNum = iNetLink.getSrcHo();
            NetCircuitNode netCircuitNode = spliceListener.node;
            LoCcatCircuit loCcatCircuit = (LoCcatCircuit)netCircuitNode.getCircuit();
            NetCircuitNode netCircuitNode2 = (NetCircuitNode)loCcatCircuit.getCircuitNodeFromNE(iNetLink.getSrc());
            boolean bl2 = false;
            if (netCircuitNode2 == null) {
                if (loCcatCircuit.circuitInfoActive() && ((NetCircuitEnd)loCcatCircuit.getSources().get(0)).getNetElement() != iNetLink.getSrc() && ((NetCircuitDropInfo)loCcatCircuit.getDrops().get(0)).getNetElement() != iNetLink.getSrc()) continue;
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("circuit node on LAP HO grooming end not found, creating one");
                }
                HoCcatCircuit hoCcatCircuit = (HoCcatCircuit)((NetLink)iNetLink).getLotCircuit();
                netCircuitNode2 = loCcatCircuit.createLapHoCircuitNode(hoCcatCircuit, iNetLink.getSrc(), iNetLink.getSrcEntityIndex(), iNetLink.getSrcHo(), spliceListener.loNum, true);
                bl2 = true;
            }
            NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink, iNetLink2, iHoNum, spliceListener.hoNum, spliceListener.loNum);
            NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(loCcatCircuit, netLinkSpan);
            netCircuitSpan.setSrcState(4);
            netCircuitSpan.setDstState(4);
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Adding active spans to the circuit");
            }
            netCircuitNode.addActiveSpan(netCircuitSpan, bl ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.TERMINATING);
            netCircuitNode2.addActiveSpan(netCircuitSpan, bl ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.ORIGINATING);
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("removing splice listener");
            }
            netCircuitNode.removeSpliceListener(new SpliceListenerEntry(spliceLinkIndex, spliceListener));
            if (bl2) {
                loCcatCircuit.lapNodeCreated(netCircuitNode2);
            }
            iterator.remove();
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceLapListenerInDstTree: check circuit's completeness");
            }
            if (loCcatCircuit.circuitInfoActive()) {
                loCcatCircuit.completeCheck();
            } else {
                loCcatCircuit.tl1CircuitCompleteCheck();
            }
            loCcatCircuit.notifyChanged();
        }
    }

    protected void completeSplice(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)netCircuitNode.getCircuit();
        NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)netCircuitNode2.getCircuit();
        NetCcatCircuit netCcatCircuit3 = (NetCcatCircuit)netCircuitNode.getCircuit();
        if (!netCcatCircuit.circuitInfoActive() && netCcatCircuit2.circuitInfoActive()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Unify: swapping source ckt " + NetCcatCircuit.prettyString(netCcatCircuit.getCircuitId()) + " with matchCkt " + NetCcatCircuit.prettyString(netCcatCircuit2.getCircuitId()));
            }
            netCcatCircuit = netCcatCircuit2;
            netCcatCircuit2 = netCcatCircuit3;
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("After the SWAP: source ckt " + NetCcatCircuit.prettyString(netCcatCircuit.getCircuitId()) + " with matchCkt " + NetCcatCircuit.prettyString(netCcatCircuit2.getCircuitId()));
            }
        }
        if (netCcatCircuit != netCcatCircuit2) {
            if (!netCcatCircuit.unify(netCcatCircuit2)) {
                throw new IllegalStateException("Fail to unify the circuits");
            }
        } else {
            this.checkCircuitComplete(netCcatCircuit);
            netCcatCircuit.notifyChanged();
        }
    }

    protected boolean alreadyConnected(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        return false;
    }

    protected void checkCircuitComplete(NetCcatCircuit netCcatCircuit) {
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("Check circuit's completeness");
        }
        if (!netCcatCircuit.circuitInfoActive()) {
            if (!netCcatCircuit.tl1CircuitCompleteCheck()) {
                netCcatCircuit.checkAndUpdateCircuit();
            }
        } else {
            netCcatCircuit.completeCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void generateCallbacks() {
        NetCircuitSplicer netCircuitSplicer = this;
        synchronized (netCircuitSplicer) {
            Map map;
            SpliceLinkIndex spliceLinkIndex;
            Map map2;
            SpliceLinkIndex spliceLinkIndex2;
            Map map3;
            SpliceLinkIndex spliceLinkIndex3;
            Map map4;
            SpliceLinkIndex spliceLinkIndex4;
            this.synchronizeSpliceListeners();
            this.synchronizeCallbackLinks();
            while (this.callbackLinks.size() != 0) {
                INetLink iNetLink;
                INetLink iNetLink2;
                block36: {
                    try {
                        iNetLink2 = (INetLink)this.callbackLinks.first();
                        if (!this.callbackLinks.remove(iNetLink2)) {
                            if (!NetCircuitSplicer.dbgOn()) break;
                            NetCircuitSplicer.debug("Splicer: WARNING! - Unable to remove Link from callbackLinks");
                            NetCircuitSplicer.debug(iNetLink2.prettyString());
                        }
                        break block36;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        if (!NetCircuitSplicer.dbgOn()) break;
                        NetCircuitSplicer.debug("Splicer: Link disappeared from callbackLinks unexpectedly");
                    }
                    break;
                }
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Splicer: Considering network link: ");
                    NetCircuitSplicer.debug(iNetLink2.prettyString());
                }
                if (this.hasNullTdmReverseLink(iNetLink2, iNetLink = Network.instance().findReverseLink(iNetLink2))) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: WARNING-Reverse link not found; aborting...");
                    }
                    return;
                }
                spliceLinkIndex4 = new SpliceLinkIndex(iNetLink2.getSrc(), iNetLink2.getSrcEntityIndex(), eSpanDirection.ORIGINATING);
                map4 = (Map)this.linkEntries.get(spliceLinkIndex4);
                spliceLinkIndex3 = new SpliceLinkIndex(iNetLink2.getDst(), iNetLink2.getDstEntityIndex(), eSpanDirection.TERMINATING);
                map3 = (Map)this.linkEntries.get(spliceLinkIndex3);
                spliceLinkIndex2 = new SpliceLinkIndex(iNetLink2.getSrc(), iNetLink2.getSrcEntityIndex(), eSpanDirection.BIDIRECTIONAL);
                map2 = (Map)this.linkEntries.get(spliceLinkIndex2);
                spliceLinkIndex = new SpliceLinkIndex(iNetLink2.getDst(), iNetLink2.getDstEntityIndex(), eSpanDirection.BIDIRECTIONAL);
                map = (Map)this.linkEntries.get(spliceLinkIndex);
                if (map4 != null && map3 != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: origTree-->termTree");
                    }
                    this.spliceListenersInTrees(map4, map3, spliceLinkIndex4, spliceLinkIndex3, iNetLink2, iNetLink, false, false);
                }
                if (map2 != null && map != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: srcBiTree-->dstBiTree");
                    }
                    this.spliceListenersInTrees(map2, map, spliceLinkIndex2, spliceLinkIndex, iNetLink2, iNetLink, true, true);
                }
                if (map4 != null && map != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: origTree-->dstBiTree");
                    }
                    this.spliceListenersInTrees(map4, map, spliceLinkIndex4, spliceLinkIndex, iNetLink2, iNetLink, false, true);
                }
                if (map2 != null && map3 != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: srcBiTree-->termTree");
                    }
                    this.spliceListenersInTrees(map2, map3, spliceLinkIndex2, spliceLinkIndex3, iNetLink2, iNetLink, true, false);
                }
                if (!iNetLink2.isLAP()) continue;
                if (map2 != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: srcBiTree-->");
                    }
                    this.spliceLapListenerInSrcTree(map2, spliceLinkIndex2, iNetLink2, iNetLink, true);
                }
                if (map != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: -->dstBiTree");
                    }
                    this.spliceLapListenerInDstTree(map, spliceLinkIndex, iNetLink2, iNetLink, true);
                }
                if (map4 != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: origTree-->");
                    }
                    this.spliceLapListenerInSrcTree(map4, spliceLinkIndex4, iNetLink2, iNetLink, false);
                }
                if (map3 == null) continue;
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Splicer: -->termTree");
                }
                this.spliceLapListenerInDstTree(map3, spliceLinkIndex3, iNetLink2, iNetLink, false);
            }
            while (this.callbackIntLinks.size() != 0) {
                InternalSpliceLink internalSpliceLink;
                try {
                    internalSpliceLink = (InternalSpliceLink)this.callbackIntLinks.first();
                    this.callbackIntLinks.remove(internalSpliceLink);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (!NetCircuitSplicer.dbgOn()) break;
                    NetCircuitSplicer.debug("Splicer: intLink disappeared from callbackIntLinks unexpectedly");
                    break;
                }
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Splicer: Considering internal splice link: ");
                    NetCircuitSplicer.debug(internalSpliceLink.prettyString());
                }
                spliceLinkIndex4 = new SpliceLinkIndex(internalSpliceLink.ne, internalSpliceLink.srcEntityIndex, eSpanDirection.ORIGINATING);
                map4 = (Map)this.linkEntries.get(spliceLinkIndex4);
                spliceLinkIndex3 = new SpliceLinkIndex(internalSpliceLink.ne, internalSpliceLink.dstEntityIndex, eSpanDirection.TERMINATING);
                map3 = (Map)this.linkEntries.get(spliceLinkIndex3);
                spliceLinkIndex2 = new SpliceLinkIndex(internalSpliceLink.ne, internalSpliceLink.srcEntityIndex, eSpanDirection.BIDIRECTIONAL);
                map2 = (Map)this.linkEntries.get(spliceLinkIndex2);
                spliceLinkIndex = new SpliceLinkIndex(internalSpliceLink.ne, internalSpliceLink.dstEntityIndex, eSpanDirection.BIDIRECTIONAL);
                map = (Map)this.linkEntries.get(spliceLinkIndex);
                if (map4 != null && map3 != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: origTree-->termTree");
                    }
                    this.spliceListenersInTrees(map4, map3, spliceLinkIndex4, spliceLinkIndex3, internalSpliceLink, null, false, false);
                }
                if (map2 != null && map != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: srcBiTree-->dstBiTree");
                    }
                    this.spliceListenersInTrees(map2, map, spliceLinkIndex2, spliceLinkIndex, internalSpliceLink, null, true, true);
                }
                if (map4 != null && map != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: origTree-->dstBiTree");
                    }
                    this.spliceListenersInTrees(map4, map, spliceLinkIndex4, spliceLinkIndex, internalSpliceLink, null, false, true);
                }
                if (map2 == null || map3 == null) continue;
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Splicer: srcBiTree-->termTree");
                }
                this.spliceListenersInTrees(map2, map3, spliceLinkIndex2, spliceLinkIndex3, internalSpliceLink, null, true, false);
            }
        }
    }

    private int spliceConnForMatchedListeners(INetElement iNetElement, INetLink iNetLink, INetLink iNetLink2) throws AnnotatedException {
        INetLink iNetLink3 = this.net.findReverseLink(iNetLink);
        INetLink iNetLink4 = this.net.findReverseLink(iNetLink2);
        return this.spliceConnForMatchedListeners(iNetElement, iNetLink, iNetLink3, iNetLink2, iNetLink4);
    }

    private int spliceConnForMatchedListeners(INetElement iNetElement, INetLink iNetLink, INetLink iNetLink2, INetLink iNetLink3, INetLink iNetLink4) throws AnnotatedException {
        int n = 0;
        LinkedList linkedList = new LinkedList();
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("spliceConnForMatchedListeners: considering links: ");
            NetCircuitSplicer.debug("  " + iNetLink.prettyString());
            NetCircuitSplicer.debug("  " + iNetLink3.prettyString());
        }
        if (iNetLink.getSrc().equals(iNetLink3.getSrc())) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceConnForMatchedListeners: skipping link pair (same src)");
            }
            return 0;
        }
        SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(iNetLink.getSrc(), iNetLink.getSrcEntityIndex(), eSpanDirection.ORIGINATING);
        Map map = (Map)this.linkEntries.get(spliceLinkIndex);
        SpliceLinkIndex spliceLinkIndex2 = new SpliceLinkIndex(iNetLink3.getSrc(), iNetLink3.getSrcEntityIndex(), eSpanDirection.TERMINATING);
        Map map2 = (Map)this.linkEntries.get(spliceLinkIndex2);
        SpliceLinkIndex spliceLinkIndex3 = new SpliceLinkIndex(iNetLink.getSrc(), iNetLink.getSrcEntityIndex(), eSpanDirection.BIDIRECTIONAL);
        Map map3 = (Map)this.linkEntries.get(spliceLinkIndex3);
        SpliceLinkIndex spliceLinkIndex4 = new SpliceLinkIndex(iNetLink3.getSrc(), iNetLink3.getSrcEntityIndex(), eSpanDirection.BIDIRECTIONAL);
        Map map4 = (Map)this.linkEntries.get(spliceLinkIndex4);
        if (map != null && map2 != null) {
            linkedList.addAll(this.findCktIdMatchedListeners(map, map2));
            n += this.spliceNode(iNetElement, iNetLink, iNetLink2, iNetLink3, iNetLink4, eSpanDirection.ORIGINATING, eSpanDirection.TERMINATING, map, map2, spliceLinkIndex, spliceLinkIndex2, linkedList);
        }
        linkedList.clear();
        if (map3 != null && map4 != null) {
            linkedList.addAll(this.findCktIdMatchedListeners(map3, map4));
            n += this.spliceNode(iNetElement, iNetLink, iNetLink2, iNetLink3, iNetLink4, eSpanDirection.BIDIRECTIONAL, eSpanDirection.BIDIRECTIONAL, map3, map4, spliceLinkIndex3, spliceLinkIndex4, linkedList);
        }
        linkedList.clear();
        if (map != null && map4 != null) {
            linkedList.addAll(this.findCktIdMatchedListeners(map, map4));
            n += this.spliceNode(iNetElement, iNetLink, iNetLink2, iNetLink3, iNetLink4, eSpanDirection.ORIGINATING, eSpanDirection.BIDIRECTIONAL, map, map4, spliceLinkIndex, spliceLinkIndex4, linkedList);
        }
        spliceLinkIndex = new SpliceLinkIndex(iNetLink3.getSrc(), iNetLink3.getSrcEntityIndex(), eSpanDirection.ORIGINATING);
        map = (Map)this.linkEntries.get(spliceLinkIndex);
        spliceLinkIndex2 = new SpliceLinkIndex(iNetLink.getSrc(), iNetLink.getSrcEntityIndex(), eSpanDirection.TERMINATING);
        map2 = (Map)this.linkEntries.get(spliceLinkIndex2);
        spliceLinkIndex3 = new SpliceLinkIndex(iNetLink3.getSrc(), iNetLink3.getSrcEntityIndex(), eSpanDirection.BIDIRECTIONAL);
        map3 = (Map)this.linkEntries.get(spliceLinkIndex3);
        spliceLinkIndex4 = new SpliceLinkIndex(iNetLink.getSrc(), iNetLink.getSrcEntityIndex(), eSpanDirection.BIDIRECTIONAL);
        map4 = (Map)this.linkEntries.get(spliceLinkIndex4);
        linkedList.clear();
        if (map != null && map2 != null) {
            linkedList.addAll(this.findCktIdMatchedListeners(map, map2));
            n += this.spliceNode(iNetElement, iNetLink3, iNetLink4, iNetLink, iNetLink2, eSpanDirection.ORIGINATING, eSpanDirection.TERMINATING, map, map2, spliceLinkIndex, spliceLinkIndex2, linkedList);
        }
        linkedList.clear();
        if (map != null && map4 != null) {
            linkedList.addAll(this.findCktIdMatchedListeners(map, map4));
            n += this.spliceNode(iNetElement, iNetLink3, iNetLink4, iNetLink, iNetLink2, eSpanDirection.ORIGINATING, eSpanDirection.BIDIRECTIONAL, map, map4, spliceLinkIndex, spliceLinkIndex4, linkedList);
        }
        return n;
    }

    private LinkedList findCktIdMatchedListeners(Map map, Map map2) {
        if (map == null || map2 == null) {
            return null;
        }
        Iterator iterator = map.values().iterator();
        LinkedList<SpliceListener> linkedList = new LinkedList<SpliceListener>();
        TreeMap<SpliceListener, SpliceListener> treeMap = new TreeMap<SpliceListener, SpliceListener>(this.listenerComparator);
        while (iterator.hasNext()) {
            SpliceListener spliceListener;
            treeMap.clear();
            SpliceListener spliceListener2 = (SpliceListener)iterator.next();
            SpliceListener spliceListener3 = new SpliceListener(spliceListener2.hoNum, spliceListener2.loNum, null, false);
            while ((spliceListener = (SpliceListener)this.findNextMatch(map2, treeMap, spliceListener3)) != null && !this.spliceCheck(spliceListener2, spliceListener, false)) {
                treeMap.put(spliceListener, spliceListener);
            }
            if (spliceListener == null) continue;
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("findCktIdMatchedListeners: matched " + spliceListener2.prettyString());
            }
            linkedList.add(spliceListener2);
            linkedList.add(spliceListener);
        }
        return linkedList;
    }

    private int spliceNode(INetElement iNetElement, INetLink iNetLink, INetLink iNetLink2, INetLink iNetLink3, INetLink iNetLink4, eSpanDirection eSpanDirection2, eSpanDirection eSpanDirection3, Map map, Map map2, SpliceLinkIndex spliceLinkIndex, SpliceLinkIndex spliceLinkIndex2, LinkedList linkedList) throws AnnotatedException {
        SpliceListener spliceListener;
        SpliceListener spliceListener2;
        int n = 0;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            spliceListener2 = (SpliceListener)iterator.next();
            spliceListener = (SpliceListener)iterator.next();
            if (spliceListener2.loNum != null || !this.spliceNodeListeners(iNetElement, spliceListener2, spliceListener, iNetLink, iNetLink2, iNetLink3, iNetLink4, eSpanDirection2, eSpanDirection3, map, map2, spliceLinkIndex, spliceLinkIndex2)) continue;
            ++n;
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            spliceListener2 = (SpliceListener)iterator.next();
            spliceListener = (SpliceListener)iterator.next();
            if (spliceListener2.loNum == null || !this.spliceNodeListeners(iNetElement, spliceListener2, spliceListener, iNetLink, iNetLink2, iNetLink3, iNetLink4, eSpanDirection2, eSpanDirection3, map, map2, spliceLinkIndex, spliceLinkIndex2)) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean spliceNodeListeners(INetElement iNetElement, SpliceListener spliceListener, SpliceListener spliceListener2, INetLink iNetLink, INetLink iNetLink2, INetLink iNetLink3, INetLink iNetLink4, eSpanDirection eSpanDirection2, eSpanDirection eSpanDirection3, Map map, Map map2, SpliceLinkIndex spliceLinkIndex, SpliceLinkIndex spliceLinkIndex2) throws AnnotatedException {
        IObservable iObservable;
        IObservable iObservable2;
        boolean bl;
        ICircuitId iCircuitId = spliceListener.node.getCircuit().getCircuitId();
        if (!iCircuitId.equals(spliceListener2.node.getCircuit().getCircuitId())) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceNode: Circuit Id mismatch unexpected");
            }
            return false;
        }
        if (!iNetLink.isValidSrcHoNumber(spliceListener.hoNum) || !iNetLink3.isValidSrcHoNumber(spliceListener2.hoNum)) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceNode: link does not support listener HO");
            }
            return false;
        }
        if (spliceListener.loNum != null) {
            bl = false;
            boolean bl2 = false;
            iObservable2 = this.net.findNetLink(iNetLink.getSrc(), spliceLinkIndex.entityIndex, spliceListener.hoNum, iNetLink3.getSrc(), spliceLinkIndex2.entityIndex, spliceListener2.hoNum, false);
            if (iObservable2 != null) {
                bl = iObservable2.getLinkType() == 2;
            }
            iObservable = this.net.findNetLink(iNetLink3.getSrc(), spliceLinkIndex2.entityIndex, spliceListener2.hoNum, iNetLink.getSrc(), spliceLinkIndex.entityIndex, spliceListener.hoNum, false);
            if (iObservable2 != null) {
                boolean bl3 = bl2 = iObservable.getLinkType() == 2;
            }
            if (bl && bl2) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("spliceNode: Found existing LOT");
                }
                return true;
            }
            if (!iNetElement.loXCon()) {
                return this.createLoTunnelForSpliceNode(iNetElement, spliceListener, spliceListener2, iNetLink, iNetLink3, iNetLink2, iNetLink4);
            }
        }
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)spliceListener.node.getCircuit();
        NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)spliceListener2.node.getCircuit();
        iObservable2 = netCcatCircuit;
        synchronized (iObservable2) {
            iObservable = netCcatCircuit2;
            synchronized (iObservable) {
                NetCircuitSpan netCircuitSpan;
                NetCircuitSpan netCircuitSpan2;
                if (!netCcatCircuit.isCircuitRefValid() || !netCcatCircuit2.isCircuitRefValid()) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("spliceNode: circuit got destroyed unexpectedly");
                    }
                    return false;
                }
                try {
                    netCcatCircuit.addNeForAddNode(iNetElement);
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("spliceNode: Cannot add NodeImpl. unexpected");
                    }
                    return false;
                }
                NetCircuitNode netCircuitNode = (NetCircuitNode)netCcatCircuit.getCircuitNodeFromNE(iNetElement);
                if (netCircuitNode == null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("spliceNode: added node disappeared!");
                    }
                    return false;
                }
                if (eSpanDirection2 != eSpanDirection.TERMINATING) {
                    NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink, iNetLink2, spliceListener.hoNum, spliceListener.hoNum, spliceListener.loNum);
                    netCircuitSpan2 = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)spliceListener.node.getCircuit(), netLinkSpan);
                    netCircuitSpan2.setSrcState(4);
                    netCircuitSpan2.setDstState(2);
                } else {
                    NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink2, iNetLink, spliceListener.hoNum, spliceListener.hoNum, spliceListener.loNum);
                    netCircuitSpan2 = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)spliceListener.node.getCircuit(), netLinkSpan);
                    netCircuitSpan2.setSrcState(2);
                    netCircuitSpan2.setDstState(4);
                }
                if (eSpanDirection3 == eSpanDirection.ORIGINATING) {
                    NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink3, iNetLink4, spliceListener2.hoNum, spliceListener2.hoNum, spliceListener2.loNum);
                    netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)spliceListener2.node.getCircuit(), netLinkSpan);
                    netCircuitSpan.setSrcState(4);
                    netCircuitSpan.setDstState(2);
                } else {
                    NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink4, iNetLink3, spliceListener2.hoNum, spliceListener2.hoNum, spliceListener2.loNum);
                    netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan((NetCcatCircuit)spliceListener2.node.getCircuit(), netLinkSpan);
                    netCircuitSpan.setSrcState(2);
                    netCircuitSpan.setDstState(4);
                }
                eSpanDirection eSpanDirection4 = eSpanDirection2 == eSpanDirection.BIDIRECTIONAL ? eSpanDirection.BIDIRECTIONAL : eSpanDirection3;
                netCircuitNode.addRoutedSpan(netCircuitSpan2, eSpanDirection4);
                eSpanDirection4 = eSpanDirection3 == eSpanDirection.BIDIRECTIONAL ? eSpanDirection.BIDIRECTIONAL : eSpanDirection2;
                netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection4);
                netCircuitNode.setupConnListOnCreation(netCircuitNode.findConnType());
                netCircuitNode.updateBlsrDriNodeType();
                try {
                    netCircuitNode.activate();
                }
                catch (CircuitProvError circuitProvError) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("spliceNode:Unable to activate cktnode");
                    }
                    netCcatCircuit.removeCktNode(netCircuitNode);
                    return false;
                }
                netCircuitNode.tentative2Active();
                spliceListener.node.addActiveSpan(netCircuitSpan2, eSpanDirection2);
                spliceListener2.node.addActiveSpan(netCircuitSpan, eSpanDirection3);
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("spliceNodeListeners: check circuit's completeness");
                }
                bl = netCcatCircuit == netCcatCircuit2 ? (!netCcatCircuit.circuitInfoActive() ? netCcatCircuit.tl1CircuitCompleteCheck() : netCcatCircuit.completeCheck()) : netCcatCircuit.unify(netCcatCircuit2);
                if (!bl) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("spliceNode: Circuit failure!");
                    }
                    return false;
                }
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("spliceNode: Added circuit" + NetCcatCircuit.prettyString(iCircuitId));
                }
                map.remove(spliceListener);
                spliceListener.node.removeSpliceListener(new SpliceListenerEntry(spliceLinkIndex, spliceListener));
                map2.remove(spliceListener2);
                spliceListener2.node.removeSpliceListener(new SpliceListenerEntry(spliceLinkIndex2, spliceListener2));
            }
        }
        netCcatCircuit.notifyChanged();
        if (netCcatCircuit != netCcatCircuit2) {
            netCcatCircuit2.notifyDeleted();
        }
        return true;
    }

    private Object findNextMatch(Map map, Map map2, Object object) {
        TreeSet treeSet = new TreeSet(this.listenerComparator);
        TreeSet<Object> treeSet2 = new TreeSet<Object>(this.listenerComparator);
        treeSet.addAll(map.values());
        if (map2 != null) {
            treeSet.removeAll(map2.values());
        }
        treeSet2.add(object);
        treeSet.retainAll(treeSet2);
        try {
            Object e = treeSet.first();
            return e;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    private boolean createLoTunnelForSpliceNode(INetElement iNetElement, SpliceListener spliceListener, SpliceListener spliceListener2, INetLink iNetLink, INetLink iNetLink2, INetLink iNetLink3, INetLink iNetLink4) throws AnnotatedException {
        int n;
        boolean bl = false;
        NetCcatCircuit netCcatCircuit = null;
        try {
            n = iNetElement.getNodeModel().getFramingType();
            IFramingType iFramingType = FramingType.getFramingType((int)n);
            int n2 = iFramingType.getTunnelCircuitType();
            int n3 = iFramingType.getLoTunnelSize();
            CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(n2, n3, 1);
            netCcatCircuit = (NetCcatCircuit)NetCircuitFactory.newCircuit(circuitCreatInfo, spliceListener.node.getNetElement());
            if (netCcatCircuit == null) {
                bl = true;
            } else {
                netCcatCircuit.addNetElement(spliceListener2.node.getNetElement(), new RoutePrefs());
                netCcatCircuit.addCircuitSpan(new NetLinkSpan(iNetLink, iNetLink3, (ILabel)spliceListener.hoNum, (ILabel)spliceListener.hoNum));
                netCcatCircuit.addCircuitSpan(new NetLinkSpan(iNetLink4, iNetLink2, (ILabel)spliceListener2.hoNum, (ILabel)spliceListener2.hoNum));
                netCcatCircuit.sanityCheck();
            }
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            bl = true;
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            bl = true;
        }
        if (bl) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("createLoTunnelForSpliceNode: LOT creation failed!");
            }
            if (netCcatCircuit != null) {
                this.destroyCktCatchExceptions(netCcatCircuit);
            }
            return false;
        }
        netCcatCircuit.lotReuseLoAdits(true);
        n = 0;
        try {
            netCcatCircuit.provision();
        }
        catch (NoRoute noRoute) {
            n = 1;
        }
        catch (ConnTypeUnsupported connTypeUnsupported) {
            n = 1;
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            n = 1;
        }
        catch (CircuitProvError circuitProvError) {
            n = 1;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            n = 1;
        }
        if (n != 0) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("createLoTunnelForSpliceNode: LOT creation failed!");
            }
            this.destroyCktCatchExceptions(netCcatCircuit);
            return false;
        }
        netCcatCircuit.lotReuseLoAdits(false);
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("createLoTunnelForSpliceNode: LOT created successfully");
        }
        return true;
    }

    private boolean destroyCktCatchExceptions(NetCcatCircuit netCcatCircuit) {
        boolean bl = false;
        try {
            netCcatCircuit.destroyCircuit();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            bl = true;
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            bl = true;
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            bl = true;
        }
        catch (DeletionError deletionError) {
            bl = true;
        }
        if (bl && NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("Circuit destroy failure due to exception");
        }
        return bl;
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof Network.NetLinkCreationNotifier) {
            if (object instanceof INetLink) {
                INetLink iNetLink = (INetLink)object;
                if (db.on()) {
                    NetCircuitSplicer.debug("update: received notification about new NL " + iNetLink.prettyString());
                }
                this.newNetLink(iNetLink);
            }
        } else if (observable instanceof INetLink) {
            if (object == ModelUpdateType.DELETED) {
                INetLink iNetLink = (INetLink)((Object)observable);
                if (db.on()) {
                    NetCircuitSplicer.debug("NetLink deleted " + iNetLink.prettyString());
                }
                this.deleteNetLink(iNetLink);
            } else if (object == ModelUpdateType.CHANGED) {
                INetLink iNetLink = (INetLink)((Object)observable);
                if (db.on()) {
                    NetCircuitSplicer.debug("NetLink changed " + iNetLink.prettyString());
                }
                this.changeNetLink(iNetLink);
            }
        }
    }

    public void dispose() {
        INetLink iNetLink;
        this.spliceTreeDump.dispose();
        Iterator iterator = this.callbackLinks.iterator();
        while (iterator.hasNext()) {
            iNetLink = (INetLink)iterator.next();
            iNetLink.deleteObserver(this);
        }
        iterator = this.callbackLinksHolder.iterator();
        while (iterator.hasNext()) {
            iNetLink = (INetLink)iterator.next();
            iNetLink.deleteObserver(this);
        }
    }

    private boolean hasNullTdmReverseLink(INetLink iNetLink, INetLink iNetLink2) {
        return !(iNetLink instanceof DwdmNetLink) && iNetLink2 == null;
    }

    protected static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected static void debug(String string) {
        db.println(string);
    }

    static {
        db = new SDebug("NetCircuitSplicer");
    }

    public class DumpDebug
    extends SDebug {
        public DumpDebug(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            if (!this.on()) {
                this.set();
            }
            NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.this;
            synchronized (netCircuitSplicer) {
                Set set = NetCircuitSplicer.this.linkEntries.keySet();
                Iterator iterator = set.iterator();
                this.println(set.size() + " link indices found");
                while (iterator.hasNext()) {
                    SpliceLinkIndex spliceLinkIndex = (SpliceLinkIndex)iterator.next();
                    this.println("Index: " + spliceLinkIndex.prettyString());
                    Map map = (Map)NetCircuitSplicer.this.linkEntries.get(spliceLinkIndex);
                    if (map == null) continue;
                    Iterator iterator2 = map.values().iterator();
                    this.println("---> " + map.size() + " listeners found");
                    while (iterator2.hasNext()) {
                        SpliceListener spliceListener = (SpliceListener)iterator2.next();
                        if (spliceListener == null) continue;
                        this.println("     " + spliceListener.prettyString());
                    }
                }
            }
        }
    }
}

