/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.ICircuitFactoryModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoVcatTermModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoVcatTermModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.IVcatTermModel;
import cerent.cms.model.IVcatTermModels;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.NetVcatTermination;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.ncp.UpdateEventCollector;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.util.EventBus;
import cerent.util.IMetrics;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.LogLevel;
import cerent.util.PerformanceMetrics;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

public class NetCircuitWatchDog
implements IObserver {
    private static final SDebug db = new SDebug("NetCircuitWatchDog");
    public DumpDebug dumpDb;
    private static NetCircuitWatchDog watchDog;
    private NetCircuitSplicer splicer = NetCircuitSplicer.instance();
    private NetElemComparator netElemComparator = new NetElemComparator();
    private TL1ObjectManager tl1Mgr;
    private SortedSet cktInfoNodes = Collections.synchronizedSortedSet(new TreeSet(this.netElemComparator));
    private SortedSet connNodes = Collections.synchronizedSortedSet(new TreeSet(this.netElemComparator));
    private SortedSet vcatTermNodes = Collections.synchronizedSortedSet(new TreeSet(this.netElemComparator));
    private List updatedCircuits;
    private boolean updateCircuitNameMaps = false;
    private SortedSet cktNameMapNodes;
    private IMetrics metrics;
    static /* synthetic */ Class class$cerent$cms$ncp$NetCircuitManager;

    private NetCircuitWatchDog() {
        this.tl1Mgr = TL1ObjectManager.instance();
        this.updatedCircuits = new LinkedList();
        this.cktNameMapNodes = Collections.synchronizedSortedSet(new TreeSet(this.netElemComparator));
        this.dumpDb = new DumpDebug("NetCircuitWatchDog");
        Thread thread = new Thread("NetCircuitWatchDog"){

            public void run() {
                boolean bl = false;
                NetCircuitWatchDog.this.splicer.initialize();
                while (true) {
                    try {
                        while (true) {
                            1.sleep(5000L);
                            if (!bl) {
                                bl = Network.instance().getEnableCircuitDiscovery();
                                if (!db.on() || !bl) continue;
                                db.println("Starting circuit discovery");
                                continue;
                            }
                            EventBus.instance().notifyEvent((Object)(class$cerent$cms$ncp$NetCircuitManager == null ? NetCircuitWatchDog.class$("cerent.cms.ncp.NetCircuitManager") : class$cerent$cms$ncp$NetCircuitManager).toString(), (Object)new Integer(1));
                            PerformanceMetrics performanceMetrics = PerformanceMetrics.getInstance();
                            NetCircuitWatchDog.this.metrics = performanceMetrics.getMetrics("generateCallbacks", IMetrics.circuitDb, LogLevel.FINE);
                            NetCircuitWatchDog.this.generateCallbacks();
                            NetCircuitWatchDog.this.metrics.stop();
                            NetCircuitWatchDog.this.splicer.generateCallbacks();
                            Network.instance().discoverServerTrails();
                            EventBus.instance().notifyEvent((Object)(class$cerent$cms$ncp$NetCircuitManager == null ? NetCircuitWatchDog.class$("cerent.cms.ncp.NetCircuitManager") : class$cerent$cms$ncp$NetCircuitManager).toString(), (Object)new Integer(2));
                        }
                    }
                    catch (Exception exception) {
                        db.println("Circuit Watch dog thread hit exception");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                        continue;
                    }
                    catch (Error error) {
                        db.println("Circuit Watch dog thread hit error");
                        db;
                        SDebug.printStackTrace((Throwable)error);
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setName("CMS CircuitWatchdog");
        thread.start();
    }

    public static synchronized NetCircuitWatchDog instance() {
        if (watchDog == null) {
            if (NetCircuitWatchDog.dbgOn()) {
                NetCircuitWatchDog.debug("Creating a Circuit WatchDog");
            }
            watchDog = new NetCircuitWatchDog();
        }
        return watchDog;
    }

    private void newNetElement(INetElement iNetElement) {
        if (iNetElement != null) {
            this.cktInfoNodes.add(iNetElement);
        }
    }

    public void reloadConnections(INetElement iNetElement) {
        if (iNetElement != null) {
            this.connNodes.add(iNetElement);
        }
    }

    public void reloadCircuitInfos(INetElement iNetElement) {
        if (iNetElement != null) {
            this.cktInfoNodes.add(iNetElement);
        }
    }

    public void reloadVcatTerms(INetElement iNetElement) {
        if (iNetElement != null) {
            this.vcatTermNodes.add(iNetElement);
        }
    }

    protected void queueCircuitNameMapUpdate() {
        this.updateCircuitNameMaps = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueCircuitUpdate(NetCircuit netCircuit, Object object, String string) {
        String string2;
        Object object2;
        if (object instanceof NetCircuitNode) {
            object2 = (NetCircuitNode)object;
            string2 = "NCN " + ((NetCircuitNode)object2).getName() + " ";
        } else if (object instanceof NetVcatTermination) {
            string2 = "NVcatT ";
        } else if (object instanceof NetCcatCircuit) {
            object2 = (NetCcatCircuit)object;
            string2 = "NCcatCkt " + netCircuit.getCircuitName() + " ";
        } else if (object instanceof NetCircuitSpan) {
            string2 = " NCS ";
        } else if (object instanceof NetCircuit) {
            object2 = (NetCircuit)object;
            string2 = "NC " + netCircuit.getCircuitName() + " ";
        } else {
            string2 = "Misc ";
        }
        string2 = string2 + string;
        object2 = this.updatedCircuits;
        synchronized (object2) {
            if (netCircuit != null && !netCircuit.getUpdateEventQueued()) {
                this.updatedCircuits.add(netCircuit);
                netCircuit.setUpdateEventQueued(true);
                if (this.dumpDb.isEventLogEnabled()) {
                    UpdateEventCollector.instance().LogEvent(string2 + " event queued");
                }
            } else if (this.dumpDb.isEventLogEnabled()) {
                UpdateEventCollector.instance().LogEvent(string2 + " event not queued");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCallbacks() {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator;
        Object object4;
        Object object5;
        ICircuitId iCircuitId;
        INodeModel iNodeModel;
        NetCircuit netCircuit;
        ICircuitModel[] iCircuitModelArray;
        INetElement iNetElement = null;
        NetCircuitManager netCircuitManager = NetCircuitManager.instance();
        LinkedList<INetElement> linkedList = new LinkedList<INetElement>();
        if (netCircuitManager == null) {
            if (NetCircuitWatchDog.dbgOn()) {
                NetCircuitWatchDog.debug("circuit manager is not yet instantiated- returning");
            }
            return;
        }
        while (true) {
            iCircuitModelArray = this.updatedCircuits;
            synchronized (iCircuitModelArray) {
                if (this.updatedCircuits.size() == 0) {
                    break;
                }
                netCircuit = (NetCircuit)this.updatedCircuits.remove(0);
                netCircuit.setUpdateEventQueued(false);
                if (this.dumpDb.isEventLogEnabled()) {
                    UpdateEventCollector.instance().LogEvent(" NCW: " + netCircuit.getCircuitName() + " event dequeued");
                }
            }
            netCircuit.runUpdate();
        }
        while (this.cktInfoNodes.size() != 0) {
            try {
                try {
                    iCircuitModelArray = this.cktInfoNodes;
                    synchronized (iCircuitModelArray) {
                        iNetElement = (INetElement)this.cktInfoNodes.first();
                        this.cktInfoNodes.remove(iNetElement);
                        if (this.dumpDb.isEventLogEnabled()) {
                            UpdateEventCollector.instance().LogEvent("NCW::genCallBack : cktInfoNodes dequeued");
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!NetCircuitWatchDog.dbgOn()) break;
                    NetCircuitWatchDog.debug("Somehow the cktInfoNodes list became empty!");
                    break;
                }
                if (iNetElement == null) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug("NetElement is null!");
                    continue;
                }
                iNodeModel = iNetElement.getNodeModel();
                if (iNodeModel == null) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug(iNetElement.getName() + "NodeModel is null!");
                    continue;
                }
                if (!iNodeModel.isInited()) {
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug(iNetElement.getName() + ": node not initialized");
                        NetCircuitWatchDog.debug("putting back in queue");
                    }
                    linkedList.add(iNetElement);
                    continue;
                }
                ICircuitFactoryModel iCircuitFactoryModel = iNodeModel.getCircuitFactoryModel();
                iCircuitModelArray = iCircuitFactoryModel.getCircuits();
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("=================================================");
                    NetCircuitWatchDog.debug("Received " + iCircuitModelArray.length + " circuit(s) from " + iNetElement.getName());
                    NetCircuitWatchDog.debug("=================================================");
                }
                for (int i = 0; i < iCircuitModelArray.length; ++i) {
                    try {
                        iCircuitId = iCircuitModelArray[i].getId();
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        continue;
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                        continue;
                    }
                    netCircuit = (NetCircuit)netCircuitManager.getCircuitFromId(iCircuitId);
                    try {
                        if (netCircuit != null) {
                            netCircuit.addDiscoveredCircuitInfo(iNodeModel, iCircuitModelArray[i]);
                            netCircuitManager.insertCircuitIfLAP(netCircuit);
                            continue;
                        }
                        NetCircuitFactory.newCircuitFromCircuitInfo(iNodeModel, iCircuitModelArray[i]);
                        continue;
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        if (!NetCircuitWatchDog.dbgOn()) continue;
                        NetCircuitWatchDog.debug("Discovered circuitInfo does not exist.");
                    }
                }
                if (iCircuitModelArray.length != 0 && NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("=================================================");
                    NetCircuitWatchDog.debug("Done processing circuits from " + iNetElement.getName());
                    NetCircuitWatchDog.debug("=================================================");
                }
                this.connNodes.add(iNetElement);
                this.vcatTermNodes.add(iNetElement);
                ModelIndirectObservable.instance().addObserver((IObservable)iCircuitFactoryModel, this);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug(abstractCmsIOException.toString() + " exception at node " + (iNetElement != null ? iNetElement.getName() : "UNKNOWN") + ", will try after 6 seconds");
                }
                if (iNetElement == null) continue;
                linkedList.add(iNetElement);
            }
        }
        this.metrics.lap("CircuitModel processing completed");
        if (linkedList.size() != 0) {
            this.cktInfoNodes.addAll(linkedList);
        }
        iCircuitModelArray = new LinkedList();
        LinkedList<INetElement> linkedList2 = new LinkedList<INetElement>();
        while (this.connNodes.size() != 0) {
            try {
                try {
                    object5 = this.connNodes;
                    synchronized (object5) {
                        iNetElement = (INetElement)this.connNodes.first();
                        this.connNodes.remove(iNetElement);
                        if (this.dumpDb.isEventLogEnabled()) {
                            UpdateEventCollector.instance().LogEvent("NCW::genCallBack: connNodes dequeued");
                        }
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!NetCircuitWatchDog.dbgOn()) break;
                    NetCircuitWatchDog.debug("Somehow the connNodes list became empty!");
                    break;
                }
                if (iNetElement == null) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug("NetElement is null!");
                    continue;
                }
                iNodeModel = iNetElement.getNodeModel();
                if (iNodeModel == null) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug(iNetElement.getName() + "NodeModel is null!");
                    continue;
                }
                if (!iNodeModel.isInited()) {
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug(iNetElement.getName() + ": node not initialized");
                        NetCircuitWatchDog.debug("putting back in queue");
                    }
                    linkedList2.add(iNetElement);
                    continue;
                }
                IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
                List<IHoConnectionModel> list = Arrays.asList(iConnectionModels.getHoConnectionModels());
                List<ILoConnectionModel> list2 = Arrays.asList(iConnectionModels.getLoConnectionModels());
                List<ILoAditModel> list3 = Arrays.asList(iConnectionModels.getLoAditModels());
                List<IOchncConnectionModel> list4 = Arrays.asList(iConnectionModels.getOchncConnectionModels());
                List<IOchccConnectionModel> list5 = Arrays.asList(iConnectionModels.getOchccConnectionModels());
                List<IOchTrailAditModel> list6 = Arrays.asList(iConnectionModels.getOchTrailAditModels());
                iCircuitModelArray.add(list);
                iCircuitModelArray.add(list2);
                iCircuitModelArray.add(list3);
                iCircuitModelArray.add(list4);
                iCircuitModelArray.add(list5);
                iCircuitModelArray.add(list6);
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("=================================================");
                    NetCircuitWatchDog.debug("Got " + list.size() + " HO-Conn, " + list2.size() + " LO-Conn, " + list3.size() + " LoAdit(s),");
                    NetCircuitWatchDog.debug("    " + list4.size() + " Ochnc-Conn, " + list5.size() + " OchTrail-Conn, " + list6.size() + " OchTrailAdit(s) from " + iNetElement.getName());
                    NetCircuitWatchDog.debug("=================================================");
                }
                object5 = iCircuitModelArray.iterator();
                while (object5.hasNext()) {
                    List list7 = (List)object5.next();
                    object4 = list7.iterator();
                    while (object4.hasNext()) {
                        Object e = object4.next();
                        try {
                            iCircuitId = NetCircuitNode.getConnCircuitId(e);
                        }
                        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                            continue;
                        }
                        if (iCircuitId.getUniquePart().getUniqueId() == 0) {
                            if (e instanceof ILoAditModel || e instanceof IOchTrailAditModel) continue;
                            if (NetCircuitWatchDog.dbgOn()) {
                                NetCircuitWatchDog.debug("Connection with null connection Id");
                            }
                            if (this.tl1Mgr.hasTL1Object(iNetElement, e)) {
                                if (!NetCircuitWatchDog.dbgOn()) continue;
                                NetCircuitWatchDog.debug("Already seen-skipping");
                                continue;
                            }
                        }
                        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)netCircuitManager.getCircuitFromId(iCircuitId);
                        try {
                            if (netCcatCircuit != null) {
                                netCcatCircuit.addDiscoveredConnection(iNetElement, e);
                                continue;
                            }
                            NetCircuitFactory.newCircuitFromConn(iNetElement, e);
                        }
                        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                            if (!NetCircuitWatchDog.dbgOn()) continue;
                            NetCircuitWatchDog.debug("Discovered connection does not exist.");
                        }
                    }
                }
                if (iCircuitModelArray.size() != 0 && NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("=================================================");
                    NetCircuitWatchDog.debug("Done processing connections from " + iNetElement.getName());
                    NetCircuitWatchDog.debug("=================================================");
                }
                ModelIndirectObservable.instance().addObserver((IObservable)iConnectionModels, this);
                iCircuitModelArray.clear();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug(abstractCmsIOException.toString() + " exception at node " + (iNetElement != null ? iNetElement.getName() : "UNKNOWN") + ", will try connections after 6 seconds");
                }
                if (iNetElement == null) continue;
                linkedList2.add(iNetElement);
            }
        }
        this.metrics.lap("ConnectionModel processing completed");
        if (linkedList2.size() != 0) {
            this.connNodes.addAll(linkedList2);
        }
        object5 = new LinkedList();
        iCircuitModelArray.clear();
        while (this.vcatTermNodes.size() != 0) {
            try {
                try {
                    iterator = this.vcatTermNodes;
                    synchronized (iterator) {
                        iNetElement = (INetElement)this.vcatTermNodes.first();
                        this.vcatTermNodes.remove(iNetElement);
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!NetCircuitWatchDog.dbgOn()) break;
                    NetCircuitWatchDog.debug("Somehow the vcatTermNodes list became empty!");
                    break;
                }
                if (iNetElement == null) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug("NetElement is null!");
                    continue;
                }
                iNodeModel = iNetElement.getNodeModel();
                if (iNodeModel == null) {
                    if (!NetCircuitWatchDog.dbgOn()) continue;
                    NetCircuitWatchDog.debug(iNetElement.getName() + "NodeModel is null!");
                    continue;
                }
                if (!iNodeModel.isInited()) {
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug(iNetElement.getName() + ": node not initialized");
                        NetCircuitWatchDog.debug("putting back in queue");
                    }
                    object5.add((INetElement)iNetElement);
                    continue;
                }
                object4 = iNodeModel.getVcatTermModels();
                List<IHoVcatTermModel> list = Arrays.asList(object4.getHoVcatTermModels());
                List<ILoVcatTermModel> list8 = Arrays.asList(object4.getLoVcatTermModels());
                iCircuitModelArray.add(list);
                iCircuitModelArray.add(list8);
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("=================================================");
                    NetCircuitWatchDog.debug("Got " + list.size() + " HO-VcatTerm, " + list8.size() + " LO-VcatTerm from " + iNetElement.getName());
                    NetCircuitWatchDog.debug("=================================================");
                }
                iterator = iCircuitModelArray.iterator();
                while (iterator.hasNext()) {
                    List list9 = (List)iterator.next();
                    object3 = list9.iterator();
                    while (object3.hasNext()) {
                        IVcatTermModel iVcatTermModel = (IVcatTermModel)object3.next();
                        try {
                            iCircuitId = iVcatTermModel.getCircuitId();
                        }
                        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                            continue;
                        }
                        if (iCircuitId.getUniquePart().getUniqueId() == 0) {
                            if (NetCircuitWatchDog.dbgOn()) {
                                NetCircuitWatchDog.debug("vcat term with null circuit Id");
                            }
                            if (this.tl1Mgr.hasTL1Object(iNetElement, iVcatTermModel)) {
                                if (!NetCircuitWatchDog.dbgOn()) continue;
                                NetCircuitWatchDog.debug("Already seen-skipping");
                                continue;
                            }
                        }
                        NetVcatCircuit netVcatCircuit = (NetVcatCircuit)netCircuitManager.getCircuitFromId(iCircuitId);
                        try {
                            if (netVcatCircuit != null) {
                                netVcatCircuit.addDiscoveredVcatTerm(iNetElement, iVcatTermModel);
                                continue;
                            }
                            NetCircuitFactory.newCircuitFromVcatTerm(iNetElement, iVcatTermModel);
                        }
                        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                            if (!NetCircuitWatchDog.dbgOn()) continue;
                            NetCircuitWatchDog.debug("Discovered vcat term does not exist.");
                        }
                    }
                }
                if (iCircuitModelArray.size() != 0 && NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("=================================================");
                    NetCircuitWatchDog.debug("Done processing vcat term from " + iNetElement.getName());
                    NetCircuitWatchDog.debug("=================================================");
                }
                ModelIndirectObservable.instance().addObserver((IObservable)object4, this);
                iCircuitModelArray.clear();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug(abstractCmsIOException.toString() + " exception at node " + (iNetElement != null ? iNetElement.getName() : "UNKNOWN") + ", will try after 6 seconds");
                }
                if (iNetElement == null) continue;
                object5.add((INetElement)iNetElement);
            }
        }
        this.metrics.lap("VcatTermModel processing completed");
        if (object5.size() != 0) {
            this.vcatTermNodes.addAll(object5);
        }
        iterator = Network.instance();
        object3 = ((Network)((Object)iterator)).getElements();
        if (this.updateCircuitNameMaps) {
            this.updateCircuitNameMaps = false;
            if (NetCircuitWatchDog.dbgOn() && object3.size() > 0) {
                NetCircuitWatchDog.debug("Queuing circuit name map update for " + object3.size() + " nodes ");
            }
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (INetElement)object2.next();
                this.cktNameMapNodes.add(object);
            }
        }
        object2 = this.cktNameMapNodes;
        synchronized (object2) {
            object = this.cktNameMapNodes.iterator();
            while (object.hasNext()) {
                INetElement iNetElement2 = (INetElement)object.next();
                if (!object3.contains(iNetElement2)) {
                    object.remove();
                    continue;
                }
                iNodeModel = iNetElement2.getNodeModel();
                if (iNodeModel.isInited() && netCircuitManager.setNodeCircuitNameMap(iNodeModel)) {
                    object.remove();
                    continue;
                }
                if (!NetCircuitWatchDog.dbgOn()) continue;
                NetCircuitWatchDog.debug("Re-queuing circuit name map update at " + iNetElement2.getName());
                NetCircuitWatchDog.debug("Node not initialized or caught I/O exception");
            }
        }
    }

    public void update(IObservable iObservable, Object object) {
        Network network = Network.instance();
        if (iObservable instanceof IConnectionModels) {
            INetElement iNetElement;
            INodeModel iNodeModel = ((IConnectionModels)iObservable).getNodeModel();
            try {
                iNetElement = network.findNetElem(iNodeModel);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                iNetElement = null;
            }
            if (iNetElement == null && NetCircuitWatchDog.dbgOn()) {
                NetCircuitWatchDog.debug("Watchdog unable to find NetElem in update method");
                NetCircuitWatchDog.debug(" Was searching for node with NodeId " + Integer.toHexString(iNodeModel.getNodeId()));
            }
            if (((Integer)object).equals(ModelUpdateType.ADDED)) {
                if (iNetElement != null) {
                    this.connNodes.add(iNetElement);
                    if (this.dumpDb.isEventLogEnabled()) {
                        UpdateEventCollector.instance().LogEvent("NCW::update : " + Integer.toHexString(iNodeModel.getNodeId()) + " added to connNodes");
                    }
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("ConnectionModels changed at " + iNetElement.getName());
                    }
                }
            } else if (((Integer)object).equals(ModelUpdateType.DELETED) && iObservable instanceof IConnectionModels) {
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("Got a deleted message for ConnectionModels");
                }
                if (iNetElement != null) {
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("Queuing circuitNameMap update at " + iNetElement.getName());
                    }
                    this.cktNameMapNodes.add(iNetElement);
                }
            }
        } else if (iObservable instanceof ICircuitFactoryModel) {
            if (((Integer)object).equals(ModelUpdateType.ADDED)) {
                INetElement iNetElement;
                INodeModel iNodeModel = ((ICircuitFactoryModel)iObservable).getNodeModel();
                try {
                    iNetElement = network.findNetElem(iNodeModel);
                    if (iNetElement == null && NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("Watchdog unable to find NetElem in update method");
                        NetCircuitWatchDog.debug(" Was searching for node with NodeId " + Integer.toHexString(iNodeModel.getNodeId()));
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    iNetElement = null;
                }
                if (iNetElement != null) {
                    this.cktInfoNodes.add(iNetElement);
                    if (this.dumpDb.isEventLogEnabled()) {
                        UpdateEventCollector.instance().LogEvent("NCW::update : " + Integer.toHexString(iNodeModel.getNodeId()) + " added to cktInfoNodes");
                    }
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("CktFactory changed at " + iNetElement.getName());
                    }
                }
            } else if (((Integer)object).equals(ModelUpdateType.DELETED) && NetCircuitWatchDog.dbgOn()) {
                NetCircuitWatchDog.debug("Got a deleted message for CircuitFactoryModel");
            }
        } else if (iObservable instanceof IVcatTermModels) {
            if (((Integer)object).equals(ModelUpdateType.ADDED)) {
                INetElement iNetElement;
                INodeModel iNodeModel = ((IVcatTermModels)iObservable).getNodeModel();
                try {
                    iNetElement = network.findNetElem(iNodeModel);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    iNetElement = null;
                }
                if (iNetElement == null) {
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("Watchdog unable to find NetElem in update method");
                        NetCircuitWatchDog.debug(" Was searching for node with NodeId " + Integer.toHexString(iNodeModel.getNodeId()));
                    }
                } else {
                    this.vcatTermNodes.add(iNetElement);
                    if (NetCircuitWatchDog.dbgOn()) {
                        NetCircuitWatchDog.debug("VcatTermModels changed at " + iNetElement.getName());
                    }
                }
            } else if (((Integer)object).equals(ModelUpdateType.DELETED) && NetCircuitWatchDog.dbgOn()) {
                NetCircuitWatchDog.debug("Got a deleted message for VcatTermModels");
            }
        } else if (iObservable instanceof Network.NetElementCreationNotifier) {
            if (object instanceof NetElement) {
                NetElement netElement = (NetElement)object;
                if (db.on()) {
                    db.println("update: received notification about new NE " + netElement.getHostName());
                }
                if (netElement.getNodeId() == 0 || netElement.getNodeId() == -1) {
                    netElement.addObserver(this);
                } else {
                    this.newNetElement(netElement);
                }
                if (NetCircuitWatchDog.dbgOn()) {
                    NetCircuitWatchDog.debug("Queuing circuitNameMap update at " + netElement.getName());
                }
                this.cktNameMapNodes.add(netElement);
            }
        } else if (iObservable instanceof NetElement && object == ModelUpdateType.CHANGED) {
            NetElement netElement = (NetElement)iObservable;
            if (db.on()) {
                db.println("update: received CHANGED event from NE " + netElement.getHostName());
            }
            if (netElement.getNodeId() != 0 && netElement.getNodeId() != -1) {
                if (db.on()) {
                    db.println("update: NE has valid node ID, adding new NE");
                }
                netElement.deleteObserver(this);
                this.newNetElement(netElement);
            }
        }
    }

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    private static void debug(String string) {
        db.println(string);
    }

    public class DumpDebug
    extends SDebug {
        private boolean updateEventLogEnabled;
        public static final String HenableEventLog = "enables update event logging, arg is number of lines in event buffer";
        public static final String HdisableEventLog = "disables update event logging";
        public static final String HdumpEventLog = "dump the update event log";

        public DumpDebug(String string) {
            super(string);
            this.updateEventLogEnabled = false;
        }

        public final void enableEventLog(int n) {
            UpdateEventCollector.EnableUpdateEventCollector(n);
            this.updateEventLogEnabled = true;
        }

        public final boolean isEventLogEnabled() {
            return this.updateEventLogEnabled;
        }

        public final void disableEventLog() {
            if (this.updateEventLogEnabled) {
                UpdateEventCollector.instance().DisableUpdateEventCollector();
            }
            this.updateEventLogEnabled = false;
        }

        public final void dumpEventLog() {
            if (this.updateEventLogEnabled) {
                UpdateEventCollector.instance().DumpEventLog(db);
            }
        }
    }
}

