/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetVcatGroup;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.NetVcatTermination;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetLink;
import cerent.util.SDebug;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NetVcatGroup
implements INetVcatGroup {
    private static final SDebug db = new SDebug("NetVcatGroup");
    private NetVcatCircuit circuit;
    private Map memberCircuits;
    private Map vcatTerms;

    protected NetVcatGroup(NetVcatCircuit netVcatCircuit) {
        this.circuit = netVcatCircuit;
        this.memberCircuits = Collections.synchronizedMap(new HashMap());
        this.vcatTerms = Collections.synchronizedMap(new HashMap());
    }

    protected boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected void addCreatedVcatTerm(CircuitCreatInfo circuitCreatInfo, int n, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, NetVcatTermination netVcatTermination) {
        this.createMemberCircuit(circuitCreatInfo, n, iNetCircuitEnd, iNetCircuitEnd2);
        this.insertVcatTermination(netVcatTermination);
    }

    protected void addDiscoveredVcatTerm(NetVcatTermination netVcatTermination) {
        if (this.dbgOn()) {
            db.println("addDiscoveredVcatTerm() for node " + netVcatTermination.getNodeName());
        }
        netVcatTermination.addAllMembers();
        this.insertVcatTermination(netVcatTermination);
    }

    protected INetCircuit[] createMemberCircuit(CircuitCreatInfo circuitCreatInfo, int n, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        INetCircuit[] iNetCircuitArray = new INetCircuit[n];
        int n2 = this.circuit.getMemberCktType();
        String string = "";
        CircuitCreatInfo circuitCreatInfo2 = new CircuitCreatInfo(n2, circuitCreatInfo.size(), circuitCreatInfo.dir(), circuitCreatInfo.monitor(), string, circuitCreatInfo.adminState(), circuitCreatInfo.tl1Compatible(), circuitCreatInfo.getTrafficDir());
        for (int i = 0; i < n; ++i) {
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)NetCircuitFactory.newCircuit(circuitCreatInfo2, iNetCircuitEnd, iNetCircuitEnd2);
            netCcatCircuit.initVcatGroup(this);
            this.insertMemberCircuit(netCcatCircuit);
            iNetCircuitArray[i] = netCcatCircuit;
        }
        return iNetCircuitArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertMemberCircuit(NetCcatCircuit netCcatCircuit) {
        Map map = this.memberCircuits;
        synchronized (map) {
            this.memberCircuits.put(netCcatCircuit, netCcatCircuit.getMemberStatusMap());
        }
        this.circuit.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMemberCircuit(NetCcatCircuit netCcatCircuit) {
        Map map = this.memberCircuits;
        synchronized (map) {
            this.memberCircuits.remove(netCcatCircuit);
        }
        this.circuit.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllMemberCircuits() {
        LinkedList linkedList;
        Map map = this.memberCircuits;
        synchronized (map) {
            linkedList = new LinkedList(this.memberCircuits.keySet());
        }
        return linkedList;
    }

    public int getMemberCircuitsSize() {
        return this.memberCircuits.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertVcatTermination(NetVcatTermination netVcatTermination) {
        Map map = this.vcatTerms;
        synchronized (map) {
            this.vcatTerms.put(netVcatTermination.getNetCktEnd(), netVcatTermination);
        }
        this.circuit.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeVcatTermination(NetVcatTermination netVcatTermination) {
        Map map = this.vcatTerms;
        synchronized (map) {
            this.vcatTerms.remove(netVcatTermination.getNetCktEnd());
        }
        this.circuit.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllVcatTerms() {
        LinkedList linkedList;
        Map map = this.vcatTerms;
        synchronized (map) {
            linkedList = new LinkedList(this.vcatTerms.values());
        }
        return linkedList;
    }

    public int getVcatTermsSize() {
        return this.vcatTerms.size();
    }

    protected NetVcatTermination getVcatTermFromCktEnd(INetCircuitEnd iNetCircuitEnd) {
        return (NetVcatTermination)this.vcatTerms.get(iNetCircuitEnd);
    }

    protected String getCircuitName() {
        return this.circuit.getCircuitName();
    }

    protected void addDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            ((NetCcatCircuit)iterator.next()).addDrop(iNetCircuitEnd, routePrefs);
        }
    }

    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            ((NetCcatCircuit)iterator.next()).deleteDrop(iNetCircuitEnd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        Iterator<Object> iterator;
        Map map = this.memberCircuits;
        synchronized (map) {
            iterator = this.memberCircuits.keySet().iterator();
            while (iterator.hasNext()) {
                ((NetCcatCircuit)iterator.next()).dispose();
                iterator.remove();
            }
        }
        map = this.vcatTerms;
        synchronized (map) {
            iterator = this.vcatTerms.values().iterator();
            while (iterator.hasNext()) {
                ((NetVcatTermination)iterator.next()).dispose();
                iterator.remove();
            }
        }
    }

    protected void finalDispose() {
        this.memberCircuits.clear();
        this.vcatTerms.clear();
        this.circuit.setChanged();
    }

    protected int getConfiguredNumOfMembers(NetVcatTermination netVcatTermination) {
        if (netVcatTermination.getDirection() == 1) {
            return netVcatTermination.getConfiguredNumOfMembers(2);
        }
        if (this.circuit.getCktSources().contains((NetCircuitEnd)netVcatTermination.getNetCktEnd())) {
            if (this == this.circuit.getForwardVcatGroup()) {
                return netVcatTermination.getConfiguredNumOfMembers(0);
            }
            if (this == this.circuit.getReverseVcatGroup()) {
                return netVcatTermination.getConfiguredNumOfMembers(1);
            }
        } else if (this.circuit.isDrop((NetCircuitEnd)netVcatTermination.getNetCktEnd())) {
            if (this == this.circuit.getForwardVcatGroup()) {
                return netVcatTermination.getConfiguredNumOfMembers(1);
            }
            if (this == this.circuit.getReverseVcatGroup()) {
                return netVcatTermination.getConfiguredNumOfMembers(0);
            }
        }
        return 0;
    }

    protected int getActualNumOfMembers(NetVcatTermination netVcatTermination) {
        if (netVcatTermination.getDirection() == 1) {
            return netVcatTermination.getAllMemberNodes(2).size();
        }
        if (this.circuit.getCktSources().contains((NetCircuitEnd)netVcatTermination.getNetCktEnd())) {
            if (this == this.circuit.getForwardVcatGroup()) {
                return netVcatTermination.getAllMemberNodes(0).size();
            }
            if (this == this.circuit.getReverseVcatGroup()) {
                return netVcatTermination.getAllMemberNodes(1).size();
            }
        } else if (this.circuit.isDrop((NetCircuitEnd)netVcatTermination.getNetCktEnd())) {
            if (this == this.circuit.getForwardVcatGroup()) {
                return netVcatTermination.getAllMemberNodes(1).size();
            }
            if (this == this.circuit.getReverseVcatGroup()) {
                return netVcatTermination.getAllMemberNodes(0).size();
            }
        }
        return 0;
    }

    protected boolean completeCheck() {
        int n;
        int n2;
        CmsObservable cmsObservable;
        int n3 = this.getVcatTermsSize();
        int n4 = this.getMemberCircuitsSize();
        if (n3 == 0 || n4 == 0) {
            if (this.dbgOn()) {
                db.println("completeCheck: number of vcat term is " + n3 + ", number of member circuits is " + n4);
            }
            return false;
        }
        int n5 = this.circuit.getSourcesSize() + this.circuit.getDropsSize();
        if (n5 != n3) {
            return false;
        }
        Iterator iterator = this.getAllVcatTerms().iterator();
        if (n3 == 1) {
            cmsObservable = (NetVcatTermination)iterator.next();
            n2 = this.getConfiguredNumOfMembers((NetVcatTermination)cmsObservable);
            n = this.getActualNumOfMembers((NetVcatTermination)cmsObservable);
            if (n2 != n4 || n2 != n) {
                if (this.dbgOn()) {
                    db.println("completeCheck: vcat term at " + ((NetVcatTermination)cmsObservable).getNodeName() + " is configured with " + n2 + " members, " + "but vcat term only has " + n + " members, " + "and there are " + n4 + " circuits in vcat group");
                }
                return false;
            }
        } else {
            while (iterator.hasNext()) {
                cmsObservable = (NetVcatTermination)iterator.next();
                n2 = this.getConfiguredNumOfMembers((NetVcatTermination)cmsObservable);
                n = this.getActualNumOfMembers((NetVcatTermination)cmsObservable);
                if (n2 == n4 && n2 == n) continue;
                if (this.dbgOn()) {
                    db.println("completeCheck: vcat term at " + ((NetVcatTermination)cmsObservable).getNodeName() + " is configured with " + n2 + " members, " + "but vcat term only has " + n + " members, " + "and there are " + n4 + " circuits in vcat group");
                }
                return false;
            }
        }
        iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            cmsObservable = (NetCcatCircuit)iterator.next();
            if (!((NetCcatCircuit)cmsObservable).circuitInfoActive()) {
                if (((NetCcatCircuit)cmsObservable).tl1CircuitCompleteCheck()) continue;
                if (this.dbgOn()) {
                    db.println("completeCheck: Tl1 circuit completeness failed");
                }
                return false;
            }
            if (((NetCcatCircuit)cmsObservable).completeCheck()) continue;
            if (this.dbgOn()) {
                db.println("completeCheck: CTC circuit completeness failed");
            }
            return false;
        }
        return true;
    }

    protected boolean unify(NetVcatGroup netVcatGroup, boolean bl) {
        NetVcatCircuit netVcatCircuit = this.circuit;
        NetVcatCircuit netVcatCircuit2 = netVcatGroup.circuit;
        NetVcatCircuit netVcatCircuit3 = this.circuit;
        if (!netVcatCircuit.circuitInfoActive() && netVcatCircuit2.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.println("Unify: swapping source ckt " + NetVcatCircuit.prettyString(netVcatCircuit.getCircuitId()) + " with matchCkt " + NetVcatCircuit.prettyString(netVcatCircuit2.getCircuitId()));
            }
            netVcatCircuit = netVcatCircuit2;
            netVcatCircuit2 = netVcatCircuit3;
            if (this.dbgOn()) {
                db.println("After the SWAP: source ckt " + NetVcatCircuit.prettyString(netVcatCircuit.getCircuitId()) + " with matchCkt " + NetVcatCircuit.prettyString(netVcatCircuit2.getCircuitId()));
            }
        }
        if (!netVcatCircuit.unify(netVcatCircuit2)) {
            return false;
        }
        if (bl) {
            if (!netVcatCircuit.circuitInfoActive()) {
                if (!netVcatCircuit.tl1CircuitCompleteCheck()) {
                    if (netVcatCircuit.inRoll()) {
                        netVcatCircuit.setState(8);
                    } else {
                        netVcatCircuit.setState(6);
                    }
                }
            } else if (!netVcatCircuit.completeCheck()) {
                if (netVcatCircuit.inRoll()) {
                    netVcatCircuit.setState(8);
                } else {
                    netVcatCircuit.setState(4);
                }
            }
            netVcatCircuit.setChanged();
        }
        if (netVcatCircuit2 != netVcatCircuit3) {
            netVcatCircuit2.notifyDeleted();
        }
        return true;
    }

    protected void setMemberStatus(NetCircuitEnd netCircuitEnd, int n) throws CTCUserException {
        NetVcatTermination netVcatTermination = this.getVcatTermFromCktEnd(netCircuitEnd);
        if (netVcatTermination != null) {
            netVcatTermination.setMemberStatus(netCircuitEnd, n);
            this.circuit.setChanged();
        }
    }

    protected void convertMemberCircuits() {
        if (this.dbgOn()) {
            db.println("convertMemberCircuits: convert member circuit back to CCAT circuit");
        }
        Iterator iterator = this.getAllMemberCircuits().iterator();
        while (iterator.hasNext()) {
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iterator.next();
            this.removeMemberCircuit(netCcatCircuit);
            netCcatCircuit.deleteVcatGroup();
            this.circuit.ncMgr.convertMemberToCcat(netCcatCircuit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memberChanged() {
        NetVcatCircuit netVcatCircuit = this.circuit;
        synchronized (netVcatCircuit) {
            if (this.dbgOn()) {
                db.println("memberChanged: check circuit's completeness");
            }
            if (!this.circuit.circuitInfoActive()) {
                if (!this.circuit.tl1CircuitCompleteCheck()) {
                    this.circuit.checkAndUpdateCircuit();
                }
            } else if (!this.circuit.completeCheck()) {
                this.circuit.checkAndUpdateCircuit();
            }
            this.circuit.setChanged();
        }
        if (!this.circuit.isCircuitRefValid()) {
            this.circuit.notifyDeleted();
        } else {
            this.circuit.notifyChanged();
        }
    }

    protected void sanityCheckVcatRoutingPref(NetCcatCircuit netCcatCircuit, List list) throws SanityCheckFailed {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((NetCircuitSpan)iterator.next()).getLink());
        }
        if (this.circuit.getVcatRoutingPref() == 1) {
            if (!this.circuit.isCommonFiberRouted(netCcatCircuit, linkedList)) {
                throw new SanityCheckFailed("Common fiber routing requires all member circuits to traverse through same sets of fibers.");
            }
        } else if (!this.circuit.isCommonFiberRouted(netCcatCircuit, linkedList) && !this.circuit.isSplitRoutingEnabled()) {
            throw new SanityCheckFailed("Split fiber routing is not enabled");
        }
    }
}

