/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnectionPathNotFound;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitEnd;
import cerent.cms.ncp.OchncCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.INetElement;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class OchTrailTunnelNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("OchTrailTunnelNode");
    private IOchTrailAditModel ochtrailAdit;

    public OchTrailTunnelNode(INetElement iNetElement, OchncCircuit ochncCircuit) {
        super(iNetElement, ochncCircuit);
        this.cktId = new CircuitId(0, 0);
        this.serviceState = -2;
        this.pathWidth = (short)ochncCircuit.getCircuitSize();
    }

    public OchTrailTunnelNode(INetElement iNetElement, OchncCircuit ochncCircuit, Object object) throws AbstractCmsObjectNotExistException {
        super(iNetElement, ochncCircuit, object);
        this.ne = iNetElement;
        ochncCircuit.setChanged();
        this.pathWidth = (short)ochncCircuit.getCircuitSize();
    }

    protected void sanityCheckConnModel() {
        this.inUse();
    }

    protected int getConnTypeFromConnModel() {
        IOchTrailAditModel iOchTrailAditModel = this.ochtrailAdit;
        if (iOchTrailAditModel != null) {
            return 0;
        }
        return 20;
    }

    protected Object[] getPathsFromConnModel() {
        IOchTrailAditModel iOchTrailAditModel = this.ochtrailAdit;
        if (iOchTrailAditModel != null) {
            return iOchTrailAditModel.getPaths();
        }
        if (this.dbgOn()) {
            db.println("getPathsFromAditModel @ Node " + this.getName() + " with connection object deleted");
        }
        return new LinkedList().toArray();
    }

    protected int getConnDir() {
        return 1;
    }

    protected void conformToPaths(Object[] objectArray, NetCircuitSplicer netCircuitSplicer) {
        if (objectArray == null) {
            return;
        }
        this.numberOfPaths = objectArray.length;
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        if (this.dbgOn()) {
            db.println("OchTrailTunnelNode conformToPaths: " + this.getName() + " connType: " + EnumStrings.getString((Class)IConnectionType.class, (int)this.connType) + " no. of paths:" + this.numberOfPaths);
        }
        if (this.numberOfPaths == 2) {
            Object object = iterator.next();
            this.integratePath(object, eSpanDirection.TERMINATING, eSpanDirection.TERMINATING, netCircuitSplicer);
            object = iterator.next();
            this.integratePath(object, eSpanDirection.ORIGINATING, eSpanDirection.ORIGINATING, netCircuitSplicer);
        } else if (this.dbgOn()) {
            db.println("OchTrailTunnelNode conformToPath: invalid OTT ONEWAY");
        }
    }

    protected void createSpliceListener(NetCircuitEnd netCircuitEnd, eSpanDirection eSpanDirection2) {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (!this.hasConnectionPath(netCircuitEnd)) {
            if (this.dbgOn()) {
                this.debug("createSpliceListener: cktEnd has no connection path " + Integer.toHexString(netCircuitEnd.getEntityIndex()));
            }
            return;
        }
        try {
            int n = this.getConnectionPathIndex(netCircuitEnd);
        }
        catch (ConnectionPathNotFound connectionPathNotFound) {
            if (this.dbgOn()) {
                this.debug("createSpliceListener: cktEnd has no connection path index" + Integer.toHexString(netCircuitEnd.getEntityIndex()));
            }
            return;
        }
        if (this.dbgOn()) {
            this.debug("createSpliceListener: creating splice listener for " + Integer.toHexString(netCircuitEnd.getEntityIndex()) + " spliceDir: " + eSpanDirection2);
        }
        this.createSpliceListener(netCircuitSplicer, netCircuitEnd, eSpanDirection2);
    }

    public NetCircuitEnd getSpanEndpoint(NetCircuitSpan netCircuitSpan) {
        CircuitEnd circuitEnd = new CircuitEnd();
        circuitEnd.setNodeId(this.ne.getNodeId());
        circuitEnd.setPortNum(netCircuitSpan.getEntityIndex(this.ne));
        circuitEnd.setDropProt(false);
        return new OchncCircuitEnd(this.ne.getNodeModel(), circuitEnd, ((OchncCircuitSpan)netCircuitSpan).getOptChannel());
    }

    protected void cleanupOchTrailAdits() {
        if (this.dbgOn()) {
            db.println("Cleanup LO Adits at " + this.getName());
        }
        int n = 0;
        LinkedList linkedList = this.inSpans;
        while (n < 3) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                netCircuitSpan.cleanupLoAdit(this.getNetElement());
            }
            linkedList = ++n == 1 ? this.outSpans : this.biSpans;
        }
    }

    public int getEntityIndex() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("getTunnelEntityIndex for OchTrail Adit");
        }
        if (this.ochtrailAdit == null) {
            throw new SanityCheckFailed("Invalid OchTrail Adit at " + this.getName());
        }
        IOchncPathDefModel[] iOchncPathDefModelArray = this.ochtrailAdit.getPaths();
        return iOchncPathDefModelArray[0].getPortEntityIdx();
    }

    protected int getTunnelEntityIndex() throws SanityCheckFailed {
        return this.getEntityIndex();
    }

    public int getOptChannel() throws SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("getTunnel Channel for OchTrail Adit");
        }
        if (this.ochtrailAdit != null) {
            throw new SanityCheckFailed("Invalid OchTrail Adit at " + this.getName());
        }
        IOchncPathDefModel[] iOchncPathDefModelArray = this.ochtrailAdit.getPaths();
        return iOchncPathDefModelArray[0].getOptChannel();
    }

    protected int findConnType() {
        return 0;
    }

    protected void createConnection() throws CircuitProvError {
        this.setConnectionType(this.findConnType());
        if (this.getConnectionType() == 20) {
            if (this.dbgOn()) {
                db.println("Warning! createConnection at " + this.getName() + " connection type is unknown");
            }
            throw new CircuitProvError("Invalid connection type at " + this.getName());
        }
        this.cktId = this.circuit.getCircuitId();
        if (this.dbgOn()) {
            db.println("createConnection: connection type " + EnumStrings.getString((Class)IConnectionType.class, (int)this.getConnectionType()) + " ckt Id: " + Integer.toHexString(this.cktId.getNodeId()) + ":" + this.cktId.getUniquePart().getUniqueId() + " at Node " + this.getName());
        }
        try {
            this.createConnection(this.cktId);
        }
        catch (CTCUserException cTCUserException) {
            if (this.dbgOn()) {
                db.println("Exception while creating OchTrail adit at " + this.getName());
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            String string = "Unable to create OchTrail Adit connection at " + this.getName();
            if (cTCUserException instanceof PathInUse) {
                string = string + "\nPath already in use";
            }
            throw new CircuitProvError(string);
        }
        if (this.ochtrailAdit == null) {
            if (this.dbgOn()) {
                db.println("Connection Models returned NULL OchTrail adit reference");
            }
            throw new CircuitProvError("Error while creating connection object at " + this.getName());
        }
        this.addConnectionObserver();
        this.setState(1);
        this.setCreateStage(3);
        this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
        this.updateConnectionPathEnds(this.getPathEndsFromPathDefs(this.getConnectionPathDefs()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createConnection(ICircuitId iCircuitId) throws CircuitProvError, ConnectionTypeError, ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo, InvalidState {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.dbgOn()) {
            this.debug("Creating new OchTrail Adit at (" + this.getName() + ") " + "inCount=" + this.inSpans.size() + " outCount=" + this.outSpans.size() + " pathWidth " + this.pathWidth);
        }
        if (this.inSpans.size() == 0 && this.outSpans.size() == 0) {
            if (this.isSrcCoLocatedCktNode()) {
                if (this.dbgOn()) {
                    db.println("OchTrail co-located Adit on src node");
                }
                if (this.getSrcCoLocatedCktEnds().get(0) == null) throw new CircuitProvError("Invalid Adit path definition");
                if (this.dbgOn()) {
                    db.println("adding pathDefs");
                }
                arrayList.add(((NetCircuitEnd)this.getSrcCoLocatedCktEnds().get(0)).getPathDef(this.pathWidth));
                arrayList.add(((NetCircuitEnd)this.getSrcCoLocatedCktEnds().get(0)).getPathDef(this.pathWidth));
            } else {
                if (!this.isDstCoLocatedCktNode()) throw new CircuitProvError("Wrong Circuit Topology");
                if (this.dbgOn()) {
                    db.println("OchTrail co-located Adit on dst node");
                }
                if (this.getDstCoLocatedCktEnds().get(0) == null) throw new CircuitProvError("Invalid Adit path definition");
                if (this.dbgOn()) {
                    db.println("adding pathDefs");
                }
                arrayList.add(((NetCircuitEnd)this.getDstCoLocatedCktEnds().get(0)).getPathDef(this.pathWidth));
                arrayList.add(((NetCircuitEnd)this.getDstCoLocatedCktEnds().get(0)).getPathDef(this.pathWidth));
            }
        } else {
            if (this.inSpans.size() != 1) {
                throw new CircuitProvError("Invalid number of inSpan, got " + this.inSpans.size());
            }
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)this.inSpans.getFirst();
            arrayList.add(netCircuitSpan.getPathDef(this.getNetElement(), this.pathWidth));
            if (this.outSpans.size() != 1) throw new CircuitProvError("Invalid number of outSpan, got " + this.outSpans.size());
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)this.outSpans.getFirst();
            arrayList.add(netCircuitSpan2.getPathDef(this.getNetElement(), this.pathWidth));
        }
        this.createOchTrailAditOnNE(iCircuitId, arrayList);
    }

    protected IOchTrailAditModel createOchTrailAditOnNE(ICircuitId iCircuitId, ArrayList arrayList) throws PathInUse, InvalidPath, InvalidState {
        this.prettyPrint((IOchncPathDefModel)arrayList.get(0), "input");
        this.prettyPrint((IOchncPathDefModel)arrayList.get(1), "output");
        IOchncPathDefModel[] iOchncPathDefModelArray = new IOchncPathDefModel[2];
        iOchncPathDefModelArray = arrayList.toArray(new IOchncPathDefModel[0]);
        IConnectionModels iConnectionModels = this.getNodeModel().getConnectionModels();
        this.ochtrailAdit = iConnectionModels.createOchTrailAdit(iCircuitId, iOchncPathDefModelArray, this.adminState);
        return this.ochtrailAdit;
    }

    public boolean inUse() {
        return this.ochtrailAdit != null && this.ochtrailAdit.inUse();
    }

    protected void destroySanityCheck() throws SanityCheckFailed {
        if (this.ochtrailAdit == null) {
            return;
        }
        if (!this.hasConnection()) {
            return;
        }
        if (this.inUse()) {
            throw new SanityCheckFailed("Och Trail Tunnel circuit is in use");
        }
    }

    protected void destroyCrossConnection() {
        block6: {
            if (this.ochtrailAdit != null) {
                if (this.dbgOn()) {
                    db.println("destroyOchTrailAdit(" + this.getName() + ")");
                }
                try {
                    this.ochtrailAdit.localDestroy();
                }
                catch (Busy busy) {
                    if (this.dbgOn()) {
                        db.println("Unable to delete OchTrail Adit - xBusy");
                    }
                    return;
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    if (!this.dbgOn()) break block6;
                    db.println("OchTrail Adit already deleted");
                }
            }
        }
        this.updateConnectionPathEnds(new LinkedList());
    }

    protected void deleteNodeDrop() {
        if (this.dbgOn()) {
            db.println("Warning! cannot delete node drop for Tunnel");
        }
    }

    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws DeletionError, SanityCheckFailed {
        super.deleteDrop(iNetCircuitEnd);
    }

    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the connection circuit Id at " + this.getName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        if (this.ochtrailAdit != null) {
            this.ochtrailAdit.setCircuitId(iCircuitId);
            this.cktId = iCircuitId;
        }
    }

    public ICircuitId getConnectionCircuitId() {
        if (this.ochtrailAdit != null) {
            return this.ochtrailAdit.getCircuitId();
        }
        if (this.dbgOn()) {
            db.println("getConnectionCircuitId @ Node " + this.getName() + " with connection object deleted");
        }
        return null;
    }

    protected boolean isSrcCoLocatedCktNode() {
        return !this.circuit.getSrcInternalSpliceLinkEnds().isEmpty() && ((NetCircuitEnd)this.circuit.getSrcInternalSpliceLinkEnds().get(0)).getNodeId() == this.getNodeModel().getNodeId();
    }

    protected boolean isDstCoLocatedCktNode() {
        return !this.circuit.getDstInternalSpliceLinkEnds().isEmpty() && ((NetCircuitEnd)this.circuit.getDstInternalSpliceLinkEnds().get(0)).getNodeId() == this.getNodeModel().getNodeId();
    }

    protected void handleTl1LoAditDeletion() {
        int n = this.circuit.getCircuitType();
        if (this.dbgOn()) {
            db.println("handleTl1LoAditDeletion :  DELETED for cktType" + n + " at node" + this.getName());
        }
        if (!this.circuit.circuitInfoActive() && this.circuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() && !((OchncCircuit)this.circuit).hasOTTAdits()) {
            this.circuit.setCircuitType(9);
        }
    }

    protected List getSrcCoLocatedCktEnds() {
        LinkedList linkedList = new LinkedList();
        if (!this.circuit.getSrcInternalSpliceLinkEnds().isEmpty()) {
            linkedList.add(this.circuit.getSrcInternalSpliceLinkEnds().get(0));
        }
        return linkedList;
    }

    protected List getDstCoLocatedCktEnds() {
        LinkedList linkedList = new LinkedList();
        if (!this.circuit.getDstInternalSpliceLinkEnds().isEmpty()) {
            linkedList.add(this.circuit.getDstInternalSpliceLinkEnds().get(0));
        }
        return linkedList;
    }

    public IConnectionModel getConn() {
        return this.ochtrailAdit;
    }

    protected void setConn(IConnectionModel iConnectionModel) {
        this.ochtrailAdit = (IOchTrailAditModel)iConnectionModel;
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }

    protected void prettyPrint(IOchncPathDefModel iOchncPathDefModel, String string) {
        if (this.dbgOn()) {
            this.debug(string + " OchncPathDef in Adit  " + this.prettyString(iOchncPathDefModel));
        }
    }

    protected String prettyString(IOchncPathDefModel iOchncPathDefModel) {
        return this.getName() + "::" + Integer.toHexString(iOchncPathDefModel.getPortEntityIdx()) + "::" + iOchncPathDefModel.getOptChannel();
    }

    protected Object[] getActivePathsFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchncCircuitNode -> getActivePathsFromConnModel @ Node " + this.getName());
        }
        return null;
    }

    protected int getProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchncCircuitNode -> getProtectionOpFromConnModel @ Node " + this.getName());
        }
        return -1;
    }

    protected int getReverseProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchncCircuitNode -> getReverseProtectionOpFromConnModel @ Node " + this.getName());
        }
        return -1;
    }

    protected void modifyConnection() throws CircuitProvError {
    }

    protected void updateConnection() throws AbstractCmsObjectNotExistException {
        if (this.dbgOn()) {
            this.debug("updateConnection() at " + this.getName());
        }
        super.updateConnection();
    }

    protected int getAdminStateFromNE() {
        block4: {
            IPortModel iPortModel = this.getPortModel();
            if (iPortModel != null) {
                try {
                    int n = iPortModel.getAdminState();
                    if (db.on()) {
                        db.println("getAdminStateFromNE. Returning admin state from port: " + this.translateAdminState(n));
                    }
                    return n;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (!db.on()) break block4;
                    db.warning("getAdminStateFromNE. Cannot get admin state for port " + iPortModel + ": " + noSuchInterface.getMessage());
                }
            }
        }
        return super.getAdminStateFromNE();
    }

    protected void setConnAdminState(int n) throws AdminStateProvisioningError {
        block5: {
            IPortModel iPortModel = this.getPortModel();
            if (iPortModel != null) {
                try {
                    int n2 = n;
                    if (n2 == 3) {
                        n2 = 0;
                    }
                    iPortModel.setAdminState(n2);
                    if (db.on()) {
                        db.println("setConnAdminState. Set " + this.translateAdminState(n2) + " applied on port: " + iPortModel);
                    }
                }
                catch (Exception exception) {
                    if (!db.on()) break block5;
                    db.warning("setConnAdminState. Cannot get admin state for port " + iPortModel + ": " + exception.getMessage());
                }
            }
        }
        super.setConnAdminState(n);
    }

    protected int getServiceStateFromNE() {
        block4: {
            IPortModel iPortModel = this.getPortModel();
            if (iPortModel != null) {
                try {
                    int n = iPortModel.getServiceStateType();
                    if (db.on()) {
                        db.println("getServiceStateFromNE. Returning service state from port: " + this.translateServiceState(n));
                    }
                    return n;
                }
                catch (NoSuchInterface noSuchInterface) {
                    if (!db.on()) break block4;
                    db.warning("getServiceStateFromNE. Cannot get service state for port " + iPortModel + ": " + noSuchInterface.getMessage());
                }
            }
        }
        return super.getServiceStateFromNE();
    }

    private IPortModel getPortModel() {
        if (this.getConn() != null) {
            return this.ochtrailAdit.getPortModel();
        }
        return null;
    }
}

