/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AdminStateOpt;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ConnCreateAttrs;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.PathInUse;
import cerent.cms.model.WrongNumberOfPaths;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchccCircuitEnd;
import cerent.cms.ncp.OchccCircuitSpan;
import cerent.cms.ncp.SpliceLinkIndex;
import cerent.cms.ncp.SpliceListener;
import cerent.cms.ncp.SpliceListenerEntry;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.util.EID;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class OchccCircuitNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("OchccCircuitNode");
    private IOchccConnectionModel ochccConn;

    public OchccCircuitNode(INetElement iNetElement, OchccCircuit ochccCircuit) {
        super(iNetElement, ochccCircuit);
        if (this.dbgOn()) {
            db.println("instantiate OchccNode");
        }
        this.cktId = new CircuitId(0, 0);
        this.serviceState = -2;
        this.pathWidth = (short)ochccCircuit.getSpecificSize();
    }

    public OchccCircuitNode(INetElement iNetElement, OchccCircuit ochccCircuit, Object object) throws AbstractCmsObjectNotExistException {
        super(iNetElement, ochccCircuit, object);
        this.ne = iNetElement;
        this.connName = this.getConnNameFromNE();
        ochccCircuit.setChanged();
        this.pathWidth = (short)this.ochccConn.getPaths()[0].getService();
    }

    public void updateSpecificSize(int n) {
        this.pathWidth = (short)n;
    }

    protected void sanityCheckConnModel() {
        this.getConnTypeFromConnModel();
    }

    protected void conformToPaths(Object[] objectArray, NetCircuitSplicer netCircuitSplicer) {
        if (objectArray == null) {
            return;
        }
        this.numberOfPaths = objectArray.length;
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        if (this.dbgOn()) {
            db.println("OchccCircuitNode conformToPaths: " + this.getName() + " connType: " + EnumStrings.getString((Class)IConnectionType.class, (int)this.connType) + " no. of paths:" + this.numberOfPaths);
        }
        if (this.connType == 1) {
            if (this.numberOfPaths == 2) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
            } else if (this.numberOfPaths == 1) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
            } else if (this.dbgOn()) {
                db.println("OchccCircuitNode conformToPath: invalid TWOWAY");
            }
        } else if (this.connType == 19) {
            if (this.numberOfPaths == 3) {
                Object object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.ORIGINATING, netCircuitSplicer);
                object = iterator.next();
                this.integratePath(object, eSpanDirection.BIDIRECTIONAL, eSpanDirection.TERMINATING, netCircuitSplicer);
            } else if (this.dbgOn()) {
                db.println("OchccCircuitNode conformToPath: invalid OCHTRAIL_SPLITTER");
            }
        } else if (this.dbgOn()) {
            db.println("OchccCircuitNode conformToPath: unsupported connection type");
        }
    }

    protected void addSpliceListener(SpliceListenerEntry spliceListenerEntry) {
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (this.dbgOn()) {
            this.debug("addSpliceListener(" + spliceListenerEntry.prettyString() + ") at " + this.getName());
        }
        this.spliceListeners.add(spliceListenerEntry);
        SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, eSpanDirection.ORIGINATING);
        SpliceListener spliceListener = new SpliceListener(spliceListenerEntry.spliceListener.hoNum, null, this, true);
        SpliceListenerEntry spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex, spliceListener);
        this.addAditListener(spliceListenerEntry2);
        spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, eSpanDirection.TERMINATING);
        spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex, spliceListener);
        this.addAditListener(spliceListenerEntry2);
    }

    protected void removeSpliceListener(SpliceListenerEntry spliceListenerEntry) {
        boolean bl;
        NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
        if (this.dbgOn()) {
            this.debug("removeSpliceListener(" + spliceListenerEntry.prettyString() + ") at " + this.getName());
        }
        if (!(bl = this.spliceListeners.remove(spliceListenerEntry)) && this.dbgOn()) {
            this.debug("WARNING! spliceListener not found in list");
        }
        if (spliceListenerEntry.spliceListener.loAdit) {
            return;
        }
        SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, eSpanDirection.ORIGINATING);
        SpliceListener spliceListener = new SpliceListener(spliceListenerEntry.spliceListener.hoNum, null, this, true);
        SpliceListenerEntry spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex, spliceListener);
        bl = this.spliceListeners.remove(spliceListenerEntry2);
        if (bl) {
            netCircuitSplicer.cancelCallback(spliceListenerEntry2);
            if (this.dbgOn()) {
                this.debug("Removed loAditSpliceListener(" + spliceListenerEntry2.prettyString() + ") at " + this.getName());
            }
        }
        if (bl = this.spliceListeners.remove(spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, spliceListenerEntry.spliceLinkIndex.entityIndex, eSpanDirection.TERMINATING), spliceListener))) {
            netCircuitSplicer.cancelCallback(spliceListenerEntry2);
            if (this.dbgOn()) {
                this.debug("Removed loAditSpliceListener(" + spliceListenerEntry2.prettyString() + ") at " + this.getName());
            }
        }
    }

    protected int findConnType() {
        int n;
        int n2;
        int n3 = this.countNumInputs();
        int n4 = n3 + (n2 = this.countNumOutputs()) + (n = this.countNumOmniSpans());
        if (n4 == 1) {
            if (n3 == 1 || n2 == 1) {
                return 1;
            }
        } else if (n4 == 2) {
            if (n3 == 1 && n2 == 1) {
                return 1;
            }
        } else if (n4 == 3 && (n3 == 2 && n2 == 1 || n3 == 1 && n2 == 2)) {
            return 19;
        }
        if (this.dbgOn()) {
            db.println("Warning! findConnType: Unknown Conn. Type, node: " + this.getName() + " total=" + n4 + " in: " + n3 + " out: " + n2 + " omni: " + n);
        }
        return 20;
    }

    protected int getConnTypeFromConnModel() {
        IOchccConnectionModel iOchccConnectionModel = this.ochccConn;
        if (iOchccConnectionModel != null) {
            return iOchccConnectionModel.getConnectionType();
        }
        return 20;
    }

    protected int getConnDir() {
        return 1;
    }

    protected Object[] getPathsFromConnModel() {
        IOchccConnectionModel iOchccConnectionModel = this.ochccConn;
        if (iOchccConnectionModel != null) {
            return iOchccConnectionModel.getPaths();
        }
        if (this.dbgOn()) {
            db.println("getPathsFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return new LinkedList().toArray();
    }

    protected void createConnection() throws CircuitProvError {
        this.setConnectionType(this.findConnType());
        if (this.getConnectionType() == 20) {
            if (this.dbgOn()) {
                db.println("Warning! createConnection at " + this.getName() + " connection type is unknown");
            }
            throw new CircuitProvError("Invalid connection type at " + this.getName());
        }
        this.cktId = this.circuit.getCircuitId();
        this.connName = this.circuit.getCircuitName();
        if (this.dbgOn()) {
            db.println("createConnection(" + this.getName() + ")" + "; connType=" + EnumStrings.getString((Class)IConnectionType.class, (int)this.getConnectionType()) + "; cktId=" + NetCcatCircuit.prettyString(this.cktId));
        }
        ICircuitType iCircuitType = this.circuit.getCircuitTypeObj();
        try {
            this.createConnection(this.cktId);
        }
        catch (CTCUserException cTCUserException) {
            if (this.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)cTCUserException);
            }
            String string = "Unable to create connection at " + this.getName();
            if (cTCUserException instanceof PathInUse) {
                string = string + "\nPath already in use";
            }
            this.cleanupOchTrailAdits();
            throw new CircuitProvError(string);
        }
        catch (AdminStateProvisioningError adminStateProvisioningError) {
            if (this.dbgOn()) {
                db.println("Exception while creating connection at " + this.getName());
                SDebug.printStackTrace((Throwable)adminStateProvisioningError);
            }
            String string = "Unable to create connection at " + this.getName();
            string = string + "\n" + adminStateProvisioningError.getMessage();
            this.cleanupOchTrailAdits();
            throw new CircuitProvError(string);
        }
        if (this.ochccConn == null) {
            if (this.dbgOn()) {
                db.println("Connection Models returned NULL connection ");
            }
            throw new CircuitProvError(ErrorMsg.getString((EID)NEMC.EID_ERROR_CONNECTION_OBJECT_PARAM_1, (Object)this.getName()) + this.getName());
        }
        this.addConnectionObserver();
        this.setState(1);
        this.setCreateStage(3);
        this.numberOfPaths = this.countNumInputs() + this.countNumOutputs() + this.countNumOmniSpans();
        this.updateConnectionPathEnds(this.getPathEndsFromPathDefs(this.getConnectionPathDefs()));
    }

    protected void createConn(ICircuitId iCircuitId, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, int n, int n2, ArrayList arrayList4, ArrayList arrayList5) throws PathInUse, InvalidPath, InvalidState, InvalidCircuitName, ConnectionTypeError, WrongNumberOfPaths {
        this.prettyPrint(arrayList.toArray(new IOchccPathDefModel[0]), "input");
        this.prettyPrint(arrayList2.toArray(new IOchccPathDefModel[0]), "output");
        IOchccPathDefModel[][] iOchccPathDefModelArrayArray = new IOchccPathDefModel[][]{arrayList.toArray(new IOchccPathDefModel[0]), arrayList2.toArray(new IOchccPathDefModel[0])};
        this.ochccConn = this.createOchccConnOnNE(iCircuitId, iOchccPathDefModelArrayArray, n, n2);
        if (this.ochccConn == null) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IOchccConnectionModel createOchccConnOnNE(ICircuitId iCircuitId, IOchccPathDefModel[][] iOchccPathDefModelArray, int n, int n2) throws PathInUse, InvalidPath, InvalidState, InvalidCircuitName, ConnectionTypeError, WrongNumberOfPaths {
        IOchccPathDefModel[] iOchccPathDefModelArray2 = iOchccPathDefModelArray[0];
        IOchccPathDefModel[] iOchccPathDefModelArray3 = iOchccPathDefModelArray[1];
        IOchccPathDefModel[] iOchccPathDefModelArray4 = null;
        AdminStateOpt adminStateOpt = new AdminStateOpt();
        adminStateOpt.setAdminState(this.getAdminState());
        ConnCreateAttrs connCreateAttrs = new ConnCreateAttrs();
        connCreateAttrs.setCktName(this.connName);
        connCreateAttrs.setAdminStateOpt(adminStateOpt);
        IConnectionModels iConnectionModels = this.getNodeModel().getConnectionModels();
        if (this.dbgOn()) {
            db.println("createOchccConnOnNE:connType=" + EnumStrings.getString((Class)IConnectionType.class, (int)this.getConnectionType()));
        }
        Map map = TL1ObjectManager.instance().getTL1Conns();
        synchronized (map) {
            if (this.getConnectionType() == 1) {
                iOchccPathDefModelArray4 = iOchccPathDefModelArray2.length == 0 ? new IOchccPathDefModel[]{iOchccPathDefModelArray3[0]} : (iOchccPathDefModelArray3.length == 0 ? new IOchccPathDefModel[]{iOchccPathDefModelArray2[0]} : new IOchccPathDefModel[]{iOchccPathDefModelArray2[0], iOchccPathDefModelArray3[0]});
                this.ochccConn = iConnectionModels.createOchccConnection(iCircuitId, this.getConnectionType(), iOchccPathDefModelArray4, (IConnCreateAttrs)connCreateAttrs);
            } else if (this.getConnectionType() == 19) {
                iOchccPathDefModelArray4 = new IOchccPathDefModel[3];
                if (n == 2) {
                    iOchccPathDefModelArray4[0] = iOchccPathDefModelArray2[0];
                    iOchccPathDefModelArray4[1] = iOchccPathDefModelArray2[1];
                    iOchccPathDefModelArray4[2] = iOchccPathDefModelArray3[0];
                } else if (n2 == 2) {
                    iOchccPathDefModelArray4[0] = iOchccPathDefModelArray3[0];
                    iOchccPathDefModelArray4[1] = iOchccPathDefModelArray3[1];
                    iOchccPathDefModelArray4[2] = iOchccPathDefModelArray2[0];
                } else {
                    if (this.dbgOn()) {
                        db.println("Warning! createOchTrailConn: bad SPLITTER case");
                    }
                    return null;
                }
                this.ochccConn = iConnectionModels.createOchccConnection(iCircuitId, this.getConnectionType(), iOchccPathDefModelArray4, (IConnCreateAttrs)connCreateAttrs);
            } else {
                if (this.dbgOn()) {
                    db.println("Circuit Node: createOchccConnOnNE Unknown connection type " + this.getConnectionType());
                }
                return null;
            }
            if (NetCcatCircuit.isNullCircuitId(iCircuitId) && this.ochccConn != null) {
                this.registerNullCircuitConnection(this.getNetElement(), this.ochccConn);
            }
        }
        return this.ochccConn;
    }

    protected void cleanupOchTrailAdits() {
        Object object;
        Iterator iterator;
        int n;
        if (this.dbgOn()) {
            db.println("Cleanup OchTrail Adits auto-created at " + this.getName());
        }
        LinkedList linkedList = this.sources;
        for (n = 0; n < 2; ++n) {
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = (OchccCircuitEnd)iterator.next();
                ((OchccCircuitEnd)object).cleanupOchTrailAdit();
            }
            linkedList = this.drops;
        }
        n = 0;
        linkedList = this.inSpans;
        while (n < 3) {
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                object = (OchccCircuitSpan)iterator.next();
                ((OchccCircuitSpan)object).cleanupOchTrailAdit(this.getNetElement());
            }
            linkedList = ++n == 1 ? this.outSpans : this.biSpans;
        }
    }

    protected void destroyCrossConnection() {
        if (this.ochccConn != null) {
            if (this.dbgOn()) {
                db.println("destroyOchTrailConnection(" + this.getName() + ")");
            }
            try {
                this.ochccConn.localDestroy();
            }
            catch (Busy busy) {
                if (this.dbgOn()) {
                    db.println("Unable to delete OchTrail connection - xBusy");
                }
                return;
            }
        }
        this.updateConnectionPathEnds(new LinkedList());
    }

    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the connection circuit Id at " + this.getName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        ICircuitId iCircuitId2 = this.getConnectionCircuitId();
        if (this.ochccConn != null) {
            this.ochccConn.setCircuitId(iCircuitId);
            this.cktId = iCircuitId;
            if (iCircuitId2 == null || iCircuitId2.getNodeId() == 0 && iCircuitId2.getUniquePart().getUniqueId() == 0) {
                this.deregisterNullCircuitConnection(this.getNetElement(), this.ochccConn);
            }
        }
    }

    protected void disposeSpans() {
        if (this.dbgOn()) {
            db.println("disposeSpans at node " + this.getName());
        }
        for (int i = 0; i < this.biSpans.size(); ++i) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)this.biSpans.get(i);
            if (!(netCircuitSpan.getLink() instanceof OchTrailTunnelNetLink)) continue;
            OchTrailTunnelNetLink ochTrailTunnelNetLink = (OchTrailTunnelNetLink)netCircuitSpan.getLink();
            INetCircuit iNetCircuit = ochTrailTunnelNetLink.getLotCircuit();
            ((OchccCircuit)this.getCircuit()).addTunnelCircuit(iNetCircuit);
            if (!this.dbgOn()) continue;
            db.println("disposeSpans: saved the reference to the underneath ckt tunnel");
        }
        super.disposeSpans();
    }

    public ICircuitId getConnectionCircuitId() {
        if (this.ochccConn != null) {
            return this.ochccConn.getCircuitId();
        }
        if (this.dbgOn()) {
            db.println("getConnectionCircuitId @ Node " + this.getName() + " with connection object deleted");
        }
        return null;
    }

    public IConnectionModel getConn() {
        return this.ochccConn;
    }

    protected void setConn(IConnectionModel iConnectionModel) {
        this.ochccConn = (IOchccConnectionModel)iConnectionModel;
    }

    protected String prettyString(IOchccPathDefModel iOchccPathDefModel) {
        return this.getName() + "::" + Integer.toHexString(iOchccPathDefModel.getPortEntityIdx());
    }

    protected void prettyPrint(IOchccPathDefModel[] iOchccPathDefModelArray, String string) {
        for (int i = 0; i < iOchccPathDefModelArray.length; ++i) {
            if (!this.dbgOn()) continue;
            db.println(string + " OchTrailPath #" + i + " " + this.prettyString(iOchccPathDefModelArray[i]));
        }
    }

    protected Object[] getActivePathsFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchccCircuitNode -> getActivePathsFromConnModel @ Node " + this.getName());
        }
        return null;
    }

    protected int getProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchccCircuitNode -> getProtectionOpFromConnModel @ Node " + this.getName());
        }
        return 0;
    }

    protected int getReverseProtectionOpFromConnModel() {
        if (this.dbgOn()) {
            db.println("OchccCircuitNode -> getReverseProtectionOpFromConnModel @ Node " + this.getName());
        }
        return -1;
    }

    protected void modifyConnection() {
        if (this.dbgOn()) {
            db.println("OchccCircuitNode -> modifyConnection @ Node " + this.getName());
        }
    }

    protected boolean hasUnprotectedDrop() {
        if (this.connType == 19) {
            return false;
        }
        return super.hasUnprotectedDrop();
    }

    private void debug(String string) {
        db.println(string);
    }
}

