/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CktInfo;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.ICircuitDropInfo;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchncCircuitEnd;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkFactory;
import cerent.cms.topo.Network;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class OchncCircuit
extends NetCcatCircuit {
    private static final SDebug db = new SDebug("OchncCircuit");
    private NetLink OTTLink;
    private NetLink revOTTLink;
    private INetCircuitEnd[] srcInternalSpliceLinkEnds = null;
    private INetCircuitEnd[] dstInternalSpliceLinkEnds = null;
    private CircuitCreatInfo cktCreatInfo = null;

    protected OchncCircuit(CircuitCreatInfo circuitCreatInfo) {
        super(circuitCreatInfo);
    }

    protected OchncCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        super(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
    }

    protected OchncCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement, Object object) {
        super(circuitCreatInfo, iNetElement, object);
        this.clearChanged();
    }

    protected OchncCircuit(CircuitCreatInfo circuitCreatInfo, INodeModel iNodeModel, ICircuitModel iCircuitModel) throws AbstractCmsObjectNotExistException {
        this(circuitCreatInfo);
        this.initState(4);
        this.addDiscoveredCircuitInfo(iNodeModel, iCircuitModel);
        this.clearChanged();
    }

    protected OchncCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement) {
        this(circuitCreatInfo);
        this.cktCreatInfo = circuitCreatInfo;
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(circuitCreatInfo.type(), iNetElement);
        this.circuitInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
        this.insertSource(netCircuitEnd);
        NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, 2);
        if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            int n = circuitCreatInfo.getTrunkInfo().getSrcTrkPort();
            this.srcInternalSpliceLinkEnds = this.fillInternalSpliceLinks(iNetElement, n, circuitCreatInfo.cktOptChannel());
        }
        this.srcCircuitNode = this.srcInternalSpliceLinkEnds != null ? NetCircuitNodeFactory.createDualConnectionCircuitNode(iNetElement, this.getCircuitTypeObj(), this) : NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
        this.setSrcNodeModel(iNetElement.getNodeModel());
        this.insertCktNode(this.srcCircuitNode);
        this.srcCircuitNode.addDropInfo(netCircuitDropInfo);
    }

    private INetCircuitEnd[] fillInternalSpliceLinks(INetElement iNetElement, int n, int n2) {
        INetCircuitEnd[] iNetCircuitEndArray;
        block9: {
            iNetCircuitEndArray = null;
            try {
                int[] nArray = OchTrailHelper.getColocatedOchPorts(iNetElement, n);
                if (nArray != null && nArray.length == 2) {
                    iNetCircuitEndArray = new INetCircuitEnd[]{new OchncCircuitEnd(iNetElement.getNodeModel(), new CircuitEnd(iNetElement.getNodeId(), n, null, false, 0), n2), new OchncCircuitEnd(iNetElement.getNodeModel(), new CircuitEnd(iNetElement.getNodeId(), nArray[0], null, false, 0), n2), new OchncCircuitEnd(iNetElement.getNodeModel(), new CircuitEnd(iNetElement.getNodeId(), nArray[1], null, false, 0), n2)};
                    if (this.dbgOn()) {
                        this.debug("Co-located ports on node: " + iNetElement.getName());
                        for (int i = 0; i < iNetCircuitEndArray.length; ++i) {
                            this.debug("Port idx: " + Integer.toHexString(iNetCircuitEndArray[i].getEntityIndex()));
                        }
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.dbgOn()) {
                    this.debug("Exception getting co-located ports: " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
            catch (FeatureUnsupported featureUnsupported) {
                if (this.dbgOn()) {
                    this.debug("Exception getting co-located ports: " + (Object)((Object)featureUnsupported));
                }
            }
            catch (NoSuchInterface noSuchInterface) {
                if (!this.dbgOn()) break block9;
                this.debug("Exception getting co-located ports: " + (Object)((Object)noSuchInterface));
            }
        }
        return iNetCircuitEndArray;
    }

    protected void checkAndUpdateCircuit() {
        this.deleteOchTrailTunnelNetLink();
        super.checkAndUpdateCircuit();
    }

    public void clearInternalSrcSpliceLinkEnds() {
        this.srcInternalSpliceLinkEnds = null;
    }

    public void clearInternalDstSpliceLinkEnds() {
        this.dstInternalSpliceLinkEnds = null;
    }

    public List getSrcInternalSpliceLinkEnds() {
        if (this.srcInternalSpliceLinkEnds != null) {
            return Arrays.asList(this.srcInternalSpliceLinkEnds);
        }
        return new LinkedList();
    }

    public List getDstInternalSpliceLinkEnds() {
        if (this.dstInternalSpliceLinkEnds != null) {
            return Arrays.asList(this.dstInternalSpliceLinkEnds);
        }
        return new LinkedList();
    }

    public void setSrcInternalSpliceLinkEnds(List list) {
        if (list == null || list.size() != 3) {
            return;
        }
        if (this.dbgOn()) {
            db.println("setSrcInternalSpliceLinkEnds:");
        }
        this.srcInternalSpliceLinkEnds = new INetCircuitEnd[3];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd == null) {
                if (!this.dbgOn()) continue;
                db.println("setSrcInternalSpliceLinkEnds: null link end");
                continue;
            }
            if (this.dbgOn()) {
                db.println("  " + netCircuitEnd.prettyString());
            }
            this.srcInternalSpliceLinkEnds[n++] = netCircuitEnd;
        }
    }

    public void setDstInternalSpliceLinkEnds(List list) {
        if (list == null || list.size() != 3) {
            return;
        }
        if (this.dbgOn()) {
            db.println("setDstInternalSpliceLinkEnds:");
        }
        this.dstInternalSpliceLinkEnds = new INetCircuitEnd[3];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd == null) {
                if (!this.dbgOn()) continue;
                db.println("setDstInternalSpliceLinkEnds: null link end");
                continue;
            }
            if (this.dbgOn()) {
                db.println("  " + netCircuitEnd.prettyString());
            }
            this.dstInternalSpliceLinkEnds[n++] = netCircuitEnd;
        }
    }

    protected void deleteOchTrailTunnelNetLink() {
        if (this.OTTLink != null) {
            if (this.dbgOn()) {
                this.debug("Deleting OTT link");
            }
            this.getNetwork().deleteNetLink(this.OTTLink);
            this.OTTLink = null;
        }
        if (this.revOTTLink != null) {
            if (this.dbgOn()) {
                this.debug("Deleting reverse OTT link");
            }
            this.getNetwork().deleteNetLink(this.revOTTLink);
            this.revOTTLink = null;
        }
    }

    public INetLink getLotLink() {
        return this.OTTLink;
    }

    public INetLink getReverseLotLink() {
        return this.revOTTLink;
    }

    protected boolean validateCircuitTopology() {
        if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            if (this.getCktNodeListSize() < 2 || this.getSourcesSize() != 1 || this.getDropsSize() != 1) {
                if (this.dbgOn()) {
                    db.println("Circuit has invalid nodes/drops/sources");
                }
                return false;
            }
            return true;
        }
        return super.validateCircuitTopology();
    }

    protected boolean completeCheck() {
        if (super.completeCheck()) {
            if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                this.addOchTrailTunnelNetLink();
            } else if (this.isBidirectional()) {
                INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)this.getSources().get(0);
                NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)this.getDrops().get(0);
                if (iNetCircuitEnd.getNodeId() == netCircuitDropInfo.getNodeId()) {
                    this.swapDropsOrder();
                }
            }
            return true;
        }
        return false;
    }

    protected boolean tl1CircuitCompleteCheck() {
        if (super.tl1CircuitCompleteCheck()) {
            if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                this.addOchTrailTunnelNetLink();
            } else if (this.isBidirectional() && this.getCircuitNodes().size() > 1) {
                this.swapDropsOrder();
            }
            return true;
        }
        return false;
    }

    private void swapDropsOrder() {
        if (this.getDrops().size() == 2) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)this.getDrops().get(0);
            if (this.dbgOn()) {
                db.println("swapDropsOrder: Old 1st Drop cktEnd " + Integer.toHexString(netCircuitDropInfo.getEntityIndex()));
            }
            NetCircuitDropInfo netCircuitDropInfo2 = (NetCircuitDropInfo)this.getDrops().get(1);
            if (this.dbgOn()) {
                db.println("swapDropsOrder: Old 2nd Drop cktEnd " + Integer.toHexString(netCircuitDropInfo2.getEntityIndex()));
            }
            LinkedList<NetCircuitDropInfo> linkedList = new LinkedList<NetCircuitDropInfo>();
            linkedList.add(netCircuitDropInfo2);
            linkedList.add(netCircuitDropInfo);
            this.setDrops(linkedList);
            if (this.dbgOn()) {
                db.println("swapDropsOrder: New 1st Drop cktEnd " + Integer.toHexString(((NetCircuitDropInfo)this.getDrops().get(0)).getEntityIndex()));
                db.println("swapDropsOrder: New 2nd Drop cktEnd " + Integer.toHexString(((NetCircuitDropInfo)this.getDrops().get(1)).getEntityIndex()));
            }
        }
    }

    public boolean hasOTTAdits() {
        int n = 0;
        if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            List list = this.getCircuitNodes();
            Iterator iterator = list.iterator();
            NetCircuitNode netCircuitNode = null;
            OchTrailTunnelNode ochTrailTunnelNode = null;
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                if (netCircuitNode instanceof OchTrailTunnelNode) {
                    ochTrailTunnelNode = (OchTrailTunnelNode)netCircuitNode;
                } else {
                    if (!(netCircuitNode instanceof DualConnectionCircuitNode)) continue;
                    ochTrailTunnelNode = (OchTrailTunnelNode)((DualConnectionCircuitNode)netCircuitNode).getFstCircuitNode();
                }
                try {
                    if (ochTrailTunnelNode == null) continue;
                    ochTrailTunnelNode.inUse();
                    if (this.dbgOn()) {
                        this.debug("hasOTTAdits: verify ochtrail exist on OM for " + ochTrailTunnelNode.getName());
                    }
                    ++n;
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!this.dbgOn()) continue;
                    this.debug("hasOTTAdits: the OchTrailAdit is no longer accessible.");
                }
            }
        }
        return n != 0;
    }

    protected void addOchTrailTunnelNetLink() {
        block27: {
            LinkModel linkModel;
            Object object;
            LinkedList<INetElement> linkedList;
            int n;
            int n2;
            int n3;
            INetElement iNetElement;
            INodeModel iNodeModel;
            INetElement iNetElement2;
            INodeModel iNodeModel2;
            block26: {
                if (this.OTTLink != null && this.revOTTLink != null) {
                    return;
                }
                if (this.dbgOn()) {
                    db.println("adding OchTrail tunnel link to network topology");
                }
                if (this.getDropsSize() != 1 || this.getSourcesSize() != 1) {
                    if (this.dbgOn()) {
                        db.println("Warning! number of Tunnel ends != 2");
                    }
                    return;
                }
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.getPrimarySource();
                iNodeModel2 = netCircuitEnd.getNodeModel();
                if (iNodeModel2 == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to get node model of source ckt. end");
                    }
                    return;
                }
                iNetElement2 = this.getNetwork().findNetElem(iNodeModel2);
                if (iNetElement2 == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find srcNE");
                    }
                    return;
                }
                NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement2);
                if (netCircuitNode == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find source ckt. node");
                    }
                    return;
                }
                NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)this.getCktDrops().get(0);
                netCircuitEnd = netCircuitDropInfo.getNetCktEnd();
                iNodeModel = netCircuitEnd.getNodeModel();
                if (iNodeModel == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to get node model of destn. ckt. end");
                    }
                    return;
                }
                iNetElement = this.getNetwork().findNetElem(iNodeModel);
                if (iNetElement == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find dstNE");
                    }
                    return;
                }
                NetCircuitNode netCircuitNode2 = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
                if (netCircuitNode2 == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find destination ckt. node");
                    }
                    return;
                }
                try {
                    n3 = netCircuitNode.getTunnelEntityIndex();
                    n2 = netCircuitNode2.getTunnelEntityIndex();
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    if (this.dbgOn()) {
                        db.println("Sanity check failed while getting endpoint information");
                    }
                    return;
                }
                n = 3;
                if (OchTrailHelper.isProtected(iNodeModel2, n3)) {
                    n = 8;
                }
                linkedList = new LinkedList<INetElement>();
                Iterator iterator = this.getCircuitNodes().iterator();
                while (iterator.hasNext()) {
                    object = (NetCircuitNode)iterator.next();
                    linkedList.add(((NetCircuitNode)object).getNetElement());
                    if (!this.dbgOn()) continue;
                    this.debug("Adding a Node to OTTNEs ");
                }
                object = new LinkedList();
                Iterator iterator2 = this.getCircuitSpans().iterator();
                while (iterator2.hasNext()) {
                    NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator2.next();
                    ((LinkedList)object).add(netCircuitSpan.getLink());
                    if (!this.dbgOn()) continue;
                    this.debug("Adding a span to OTTLinks ");
                }
                linkModel = new LinkModel(iNodeModel2, n3, null, iNodeModel, n2, null, 8, -1, -1, true, true, -1, -1, n, "", 0, 0, 1, 0, 0, 0);
                this.OTTLink = (NetLink)NetLinkFactory.createNetLink(this.getNetwork(), linkModel, iNetElement2, iNetElement, iNetElement2.getTopology(), linkedList, (LinkedList)object, this);
                try {
                    this.getNetwork().addNetLink(this.OTTLink);
                    NetCircuitSplicer.instance().newNetLink(this.OTTLink);
                }
                catch (ObjDuplicate objDuplicate) {
                    if (!this.dbgOn()) break block26;
                    db.println("duplicate OchTrail tunnel");
                }
            }
            linkModel = new LinkModel(iNodeModel, n2, null, iNodeModel2, n3, null, 8, -1, -1, true, true, -1, -1, n, "", 0, 0, 1, 0, 0, 0);
            this.revOTTLink = (NetLink)NetLinkFactory.createNetLink(this.getNetwork(), linkModel, iNetElement, iNetElement2, iNetElement.getTopology(), linkedList, (LinkedList)object, this);
            try {
                this.getNetwork().addNetLink(this.revOTTLink);
                NetCircuitSplicer.instance().newNetLink(this.revOTTLink);
            }
            catch (ObjDuplicate objDuplicate) {
                if (!this.dbgOn()) break block27;
                db.println("duplicate OchTrail tunnel (reverse link)");
            }
        }
    }

    public synchronized void addNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws IncorrectCircuitState {
        NetCircuitNode netCircuitNode;
        if (this.dbgOn()) {
            db.println("Adding a Network Element to circuit. NE = " + iNetElement.getName());
        }
        if (!this.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Circuit already destroyed");
        }
        if (this.getState() != 1 && this.getState() != 0) {
            throw new IncorrectCircuitState("Circuit should have DISCOVERED or CREATING status when adding a Network Element");
        }
        if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType() && this.getState() == 1) {
            throw new IncorrectCircuitState("Cannot add a Node to a DISCOVERED OchTrail Tunnel");
        }
        if (routePrefs != null) {
            this.setMemberPrefs(routePrefs.getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberPrefs());
        }
        if ((netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement)) == null) {
            boolean bl = false;
            if (this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                int n = this.cktCreatInfo.getTrunkInfo().getDstTrkPort();
                this.dstInternalSpliceLinkEnds = this.fillInternalSpliceLinks(iNetElement, n, this.cktCreatInfo.cktOptChannel());
            }
            netCircuitNode = this.dstInternalSpliceLinkEnds != null ? NetCircuitNodeFactory.createDualConnectionCircuitNode(iNetElement, this.getCircuitTypeObj(), this) : NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
            this.insertCktNode(netCircuitNode);
        }
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), iNetElement);
        NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, 2);
        netCircuitNode.addDropInfo(netCircuitDropInfo);
        this.insertDrop(netCircuitDropInfo);
        if (this.getState() != 0) {
            this.setState(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNetElement(INetElement iNetElement) throws ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, DeletionError, SanityCheckFailed {
        if (this.dbgOn()) {
            db.println("Deleting Net Element from circuit. Node = " + iNetElement.getName());
        }
        OchncCircuit ochncCircuit = this;
        synchronized (ochncCircuit) {
            block10: {
                NetCircuitNode netCircuitNode = (NetCircuitNode)this.getCircuitNodeFromNE(iNetElement);
                if (netCircuitNode == null) {
                    if (this.dbgOn()) {
                        db.println("Warning! unable to find circuit node");
                    }
                    throw new ObjNotFound("Unable to find the Network Element");
                }
                if (netCircuitNode == this.srcCircuitNode) {
                    if (this.dbgOn()) {
                        db.println("Cannot delete source circuit node");
                    }
                    throw new SanityCheckFailed("Cannot delete Source circuit node");
                }
                NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), iNetElement);
                try {
                    this.deleteDropCktEnd(netCircuitEnd);
                }
                catch (CircuitDropOutstanding circuitDropOutstanding) {
                    if (!this.dbgOn()) break block10;
                    db.println("deleteNetElement- circuit drop outstanding " + circuitDropOutstanding);
                }
            }
        }
        this.notifyChanged();
    }

    protected void getNodeLevelSourcesAndDrops(List list, List list2) {
        super.getNodeLevelSourcesAndDrops(list, list2);
        if (this.circuitInfoActive()) {
            return;
        }
        if (!this.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            return;
        }
        Iterator iterator = this.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (!(netCircuitNode instanceof OchTrailTunnelNode) && !(netCircuitNode instanceof DualConnectionCircuitNode)) continue;
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), netCircuitNode.getNetElement());
            if (list.size() == 0) {
                list.add(netCircuitEnd);
                continue;
            }
            list2.add(netCircuitEnd);
        }
    }

    protected synchronized boolean unify(NetCcatCircuit netCcatCircuit) {
        this.srcInternalSpliceLinkEnds = null;
        this.dstInternalSpliceLinkEnds = null;
        return super.unify(netCcatCircuit);
    }

    public void toOchTrailTunnelCircuit(OchTrailHelper.UpgradeOchncInfo upgradeOchncInfo, OchTrailHelper.UpgradeOchncInfo upgradeOchncInfo2) throws CircuitProvError {
        if (this.getCircuitType() == 9) {
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit() called for " + this);
            }
            INetElement iNetElement = this.getSourceNE();
            OchncCircuitNode ochncCircuitNode = (OchncCircuitNode)this.getCircuitNodeFromNE(iNetElement);
            INetElement iNetElement2 = this.getDropNE();
            OchncCircuitNode ochncCircuitNode2 = (OchncCircuitNode)this.getCircuitNodeFromNE(iNetElement2);
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit: Change circuit type to OCH_TRAIL_TUNNEL_CIRCUIT");
            }
            this.setCircuitType(15);
            this.setSources(null);
            this.setDrops(null);
            INodeModel iNodeModel = upgradeOchncInfo.getTrunkPort().getNodeModel();
            INetElement iNetElement3 = Network.instance().findNetElem(iNodeModel);
            OchTrailTunnelNode ochTrailTunnelNode = (OchTrailTunnelNode)NetCircuitNodeFactory.createCircuitNode(iNetElement3, this);
            ochTrailTunnelNode.setState(2);
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit: Insert circuit source");
            }
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), iNetElement3);
            netCircuitEnd.setStage(4);
            ochTrailTunnelNode.insertDrop(netCircuitEnd);
            this.insertSource(netCircuitEnd);
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit: Change circuit src node from " + iNetElement.getName() + " to " + iNodeModel.getName());
            }
            this.setSrcNodeModel(iNodeModel);
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit: Add src circuit node at " + iNodeModel.getName());
            }
            this.insertCktNode(ochTrailTunnelNode);
            if (upgradeOchncInfo.isColocated()) {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: Co-located case on src node " + iNodeModel.getName() + " fill the internal splice link info");
                }
                this.srcInternalSpliceLinkEnds = this.fillInternalSpliceLinks(iNetElement3, upgradeOchncInfo.getTrunkPort().getEntityIndex(), this.getCircuitOptChannel());
                if (this.srcInternalSpliceLinkEnds == null && db.on()) {
                    db.println("WARNING: toOchTrailTunnelCircuit: failed to add internalSrcSpliceLinks for " + iNodeModel.getName());
                }
            } else {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: Not Co-located case on src node " + iNodeModel.getName() + " add active spans.");
                }
                this.addActiveSpan(ochTrailTunnelNode, ochncCircuitNode, upgradeOchncInfo.getVirtualLink1(), upgradeOchncInfo.getVirtualLink2());
                this.addActiveSpan(ochTrailTunnelNode, ochncCircuitNode, upgradeOchncInfo.getVirtualLink2().getReverseLink(), upgradeOchncInfo.getVirtualLink1().getReverseLink());
            }
            try {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: create OchTraiTunnel conn on src node " + iNodeModel.getName());
                }
                ochTrailTunnelNode.createConnection();
            }
            catch (CircuitProvError circuitProvError) {
                if (db.on()) {
                    SDebug.printStackTrace((Throwable)circuitProvError);
                }
                throw circuitProvError;
            }
            ochTrailTunnelNode.setCreateStage(4);
            if (upgradeOchncInfo.isColocated()) {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: Create the DualConnectionNode on node " + iNodeModel.getName());
                }
                NetCircuitNodeFactory.createDualConnectionCircuitNode((NetCircuitNode)ochTrailTunnelNode, ochncCircuitNode);
            }
            INodeModel iNodeModel2 = upgradeOchncInfo2.getTrunkPort().getNodeModel();
            INetElement iNetElement4 = Network.instance().findNetElem(iNodeModel2);
            OchTrailTunnelNode ochTrailTunnelNode2 = (OchTrailTunnelNode)NetCircuitNodeFactory.createCircuitNode(iNetElement4, this);
            ochTrailTunnelNode2.setState(2);
            NetCircuitEnd netCircuitEnd2 = NetCircuitEndFactory.createNodeDrop(this.getCircuitType(), iNetElement4);
            netCircuitEnd2.setStage(4);
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit: Insert circuit drop");
            }
            NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd2, 2);
            this.insertDrop(netCircuitDropInfo);
            ochTrailTunnelNode2.insertDrop(netCircuitEnd2);
            if (db.on()) {
                db.println("toOchTrailTunnelCircuit: Add dst circuit node at " + iNodeModel2.getName());
            }
            this.insertCktNode(ochTrailTunnelNode2);
            if (upgradeOchncInfo2.isColocated()) {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: Co-located case on dst node " + iNodeModel2.getName() + " fill the internal splice link info");
                }
                this.dstInternalSpliceLinkEnds = this.fillInternalSpliceLinks(iNetElement4, upgradeOchncInfo2.getTrunkPort().getEntityIndex(), this.getCircuitOptChannel());
                if (this.dstInternalSpliceLinkEnds == null && db.on()) {
                    db.println("WARNING: toOchTrailTunnelCircuit: failed to add dst internalSpliceLinks for " + iNodeModel2);
                }
            } else {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: Not Co-located case on dst node " + iNodeModel2.getName() + " add active spans.");
                }
                this.addActiveSpan(ochTrailTunnelNode2, ochncCircuitNode2, upgradeOchncInfo2.getVirtualLink1(), upgradeOchncInfo2.getVirtualLink2());
                this.addActiveSpan(ochTrailTunnelNode2, ochncCircuitNode2, upgradeOchncInfo2.getVirtualLink2().getReverseLink(), upgradeOchncInfo2.getVirtualLink1().getReverseLink());
            }
            try {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: create OchTraiTunnel conn on dst node " + iNodeModel2.getName());
                }
                ochTrailTunnelNode2.createConnection();
            }
            catch (CircuitProvError circuitProvError) {
                block39: {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)circuitProvError);
                    }
                    try {
                        ochTrailTunnelNode.deactivate();
                    }
                    catch (DeletionError deletionError) {
                        if (!db.on()) break block39;
                        SDebug.printStackTrace((Throwable)deletionError);
                    }
                }
                throw circuitProvError;
            }
            ochTrailTunnelNode2.setCreateStage(4);
            if (upgradeOchncInfo2.isColocated()) {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: Create the DualConnectionNode on node " + iNodeModel2.getName());
                }
                NetCircuitNodeFactory.createDualConnectionCircuitNode((NetCircuitNode)ochTrailTunnelNode2, ochncCircuitNode2);
            }
            String string = this.getCircuitName();
            try {
                if (db.on()) {
                    db.println("toOchTrailTunnelCircuit: ChangeCircuitId on node " + iNodeModel.getName());
                }
                this.changeCircuitId(iNetElement.getNodeId(), iNetElement3.getNodeId());
                this.renameCircuit(string);
            }
            catch (CircuitProvError circuitProvError) {
                block40: {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)circuitProvError);
                    }
                    try {
                        ochTrailTunnelNode.deactivate();
                        ochTrailTunnelNode2.deactivate();
                    }
                    catch (DeletionError deletionError) {
                        if (!db.on()) break block40;
                        SDebug.printStackTrace((Throwable)deletionError);
                    }
                }
                this.setCircuitName(string);
                throw circuitProvError;
            }
        }
        if (db.on()) {
            db.println("toOchTrailTunnelCircuit() done");
        }
    }

    private synchronized boolean changeCircuitId(int n, int n2) throws CircuitProvError {
        ICircuitId iCircuitId;
        INodeModel iNodeModel;
        INetElement iNetElement = this.getNetwork().findNetElem(n2);
        INodeModel iNodeModel2 = iNodeModel = iNetElement == null ? null : iNetElement.getNodeModel();
        if (iNodeModel == null) {
            return false;
        }
        if (this.dbgOn()) {
            this.debug("changeCircuitId(" + this.getCircuitName() + ", " + OchncCircuit.prettyString(this.circuitId) + ")");
        }
        CktInfo cktInfo = new CktInfo();
        Iterator iterator = this.getCktSources().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (n3 == 0) {
                cktInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
                ++n3;
                continue;
            }
            if (n3 != true) continue;
            cktInfo.setSecSrcPoint(netCircuitEnd.getCircuitEnd());
            break;
        }
        if (cktInfo.getSecSrcPoint() == null) {
            cktInfo.setSecSrcPoint(OchncCircuit.createNullCircuitEnd());
        }
        ICircuitDropInfo[] iCircuitDropInfoArray = new ICircuitDropInfo[this.getDropsSize()];
        iterator = this.getCktDrops().iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            iCircuitDropInfoArray[n4++] = netCircuitDropInfo.getCircuitDropInfo();
        }
        VlanSetManager.instance();
        cktInfo.setVlans(VlanSetManager.vlanModelToVlanInfo(this.getVlans()));
        cktInfo.setDropInfo(iCircuitDropInfoArray);
        cktInfo.setMonitor(this.isMonitorCircuit());
        cktInfo.setCircuitSize(this.getCircuitSize());
        cktInfo.setCircuitType(this.getCircuitType());
        cktInfo.setCktOptChannel(this.getCircuitOptChannel());
        cktInfo.setDir(this.getCircuitDir());
        cktInfo.setCircuitName("");
        cktInfo.setSla(this.getSla());
        try {
            this.destroyCircuitInfo();
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
        }
        catch (DeletionError deletionError) {
            throw new CircuitProvError("Unable to dispose the old OCHNC Circuit.");
        }
        this.createCircuitInfo(iNodeModel, cktInfo);
        try {
            iCircuitId = this.circuitModel.getId();
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (this.dbgOn()) {
                db.println("New CircuitModel disappeared");
            }
            throw new CircuitProvError("New Circuit model disappeared");
        }
        this.srcInternalSpliceLinkEnds = null;
        this.dstInternalSpliceLinkEnds = null;
        this.changeCircuitId(iCircuitId);
        return true;
    }

    public void addActiveSpan(OchTrailTunnelNode ochTrailTunnelNode, OchncCircuitNode ochncCircuitNode, INetLink iNetLink, INetLink iNetLink2) {
        eSpanDirection eSpanDirection2;
        eSpanDirection eSpanDirection3;
        if (db.on()) {
            db.println("addActiveSpan() adding span: " + iNetLink.prettyString() + ", " + iNetLink2.prettyString());
        }
        NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink, iNetLink2);
        INetLink iNetLink3 = netLinkSpan.getLink();
        if (this.dbgOn()) {
            db.println("addCircuitSpan " + netLinkSpan.prettyString() + " to circuit " + OchncCircuit.prettyString(this.circuitId));
        }
        if (this.getCircuitSpanFromNetLink(iNetLink3) != null) {
            if (this.dbgOn()) {
                db.println("addCircuitSpan: span already in list; ignored");
            }
            return;
        }
        NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this, netLinkSpan);
        if (iNetLink.getSrc().equals(ochTrailTunnelNode.getNetElement())) {
            eSpanDirection3 = eSpanDirection.ORIGINATING;
            eSpanDirection2 = eSpanDirection.TERMINATING;
        } else {
            eSpanDirection3 = eSpanDirection.TERMINATING;
            eSpanDirection2 = eSpanDirection.ORIGINATING;
        }
        ochTrailTunnelNode.addActiveSpan(netCircuitSpan, eSpanDirection3);
        this.clearSourcesAndDrops(ochncCircuitNode);
        ochncCircuitNode.addActiveSpan(netCircuitSpan, eSpanDirection2);
        if (this.dbgOn()) {
            db.println("Set circuit span state to ACTIVE");
        }
        netCircuitSpan.setSrcState(4);
        netCircuitSpan.setDstState(4);
    }

    private void clearSourcesAndDrops(OchncCircuitNode ochncCircuitNode) {
        Object object;
        List list = ochncCircuitNode.getSources();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitEnd)iterator.next();
            ochncCircuitNode.removeSource((NetCircuitEnd)object);
        }
        object = ochncCircuitNode.getDrops();
        iterator = object.iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
            ochncCircuitNode.removeDrop(netCircuitEnd);
        }
    }

    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    protected void debug(String string) {
        db.println(string);
    }
}

