/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NetProtectionType;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.LoTunnelCircuitEnd;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetVcatTermination;
import cerent.cms.ncp.RollManager;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.IEntityCellRenderer;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RollValidator {
    private static TDMTerminology tdmTerm;
    private static String UPSR_TERM;
    private static String BLSR_TERM;
    public static int SINGLE_ROLL;
    public static int DUAL_ROLL_1;
    public static int DUAL_ROLL_2;
    private static RollValidator instance;
    private static SDebug db;

    protected boolean dbgOn() {
        return db.on() || RollManager.pkgDbgOn();
    }

    public static synchronized RollValidator getInstance() {
        if (instance == null) {
            instance = new RollValidator();
        }
        return instance;
    }

    public INetCircuitEnd validateSingleRollBNR(int n, INetCircuit iNetCircuit, INetCircuit iNetCircuit2, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, StringBuffer stringBuffer) {
        INetCircuitEnd iNetCircuitEnd3 = null;
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iNetCircuit;
        NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)iNetCircuit2;
        if (iNetCircuitEnd2 == null) {
            stringBuffer.append("Invalid selection of Pivot/Fixed Point.");
            db.println("rollFrom passed to validateSingleRollBNR() is null");
            return null;
        }
        this.doCommonCheck(netCcatCircuit, iNetCircuitEnd2, stringBuffer);
        if (stringBuffer.toString().length() > 0) {
            return null;
        }
        INetElement iNetElement = iNetCircuitEnd.getNetElement();
        INetCircuitNode iNetCircuitNode = netCcatCircuit.getCircuitNodeFromNE(iNetElement);
        tdmTerm = iNetCircuitNode.getNodeModel().getTDMTerminology();
        UPSR_TERM = tdmTerm.getRingTerms(0);
        BLSR_TERM = tdmTerm.getRingTerms(1);
        if (this.isConnectedToLAPNode(iNetCircuitEnd2, netCcatCircuit)) {
            stringBuffer.append("Cannot break a VT aggregation circuit.");
            return null;
        }
        List list = iNetCircuitNode.getIngressPoints();
        List list2 = iNetCircuitNode.getEgressPoints();
        if (list.contains(iNetCircuitEnd)) {
            Object object;
            INetCircuitEnd iNetCircuitEnd4;
            NetCircuitNode netCircuitNode;
            if (netCcatCircuit.isMemberOfVcat() && netCcatCircuit.isOpenEndedVcatCircuit() && (netCircuitNode = netCcatCircuit.getCircuitNodeFromCktEnd(iNetCircuitEnd4 = ((NetVcatTermination)(object = (NetVcatTermination)netCcatCircuit.getVcatGroup().getAllVcatTerms().get(0))).getNetCktEnd())).isEgressPoint(netCcatCircuit.getCktEndFromTermEnd(iNetCircuitEnd4))) {
                stringBuffer.append("Cannot perform single roll on the non-open end of a VCAT circuit.");
                return null;
            }
            if (((NetCircuitNode)iNetCircuitNode).involvedInUpsr(iNetCircuitEnd2) && !netCcatCircuit.isDrop((NetCircuitEnd)iNetCircuitEnd2)) {
                stringBuffer.append("Based on circuit roll type and selection of Pivot/Fixed Point 1, only circuit source or drop can be rolled away.");
                return null;
            }
            if (!netCcatCircuit.isBidirectional() && n == 0) {
                stringBuffer.append("Based on circuit direction and selection of Pivot/Fixed Point 1, circuit roll mode must be MANUAL.");
                return null;
            }
            if (netCcatCircuit2 != null) {
                if (netCcatCircuit.getCircuitDir() != netCcatCircuit2.getCircuitDir()) {
                    stringBuffer.append("Roll From and Roll To circuits must have the same direction.");
                    return null;
                }
                object = (NetCircuitEnd)netCcatCircuit2.getSources().get(0);
                iNetCircuitEnd3 = this.getDccCktEnd(iNetCircuitEnd2.getNodeModel(), (INetCircuitEnd)object);
                if (iNetCircuitEnd3 == null) {
                    stringBuffer.append("Can not find the DCC link. \nDCC link needs to be established between selected port \nand source port of Roll To circuit before rolling.");
                    return null;
                }
                if (netCcatCircuit2.getSources().size() != 1) {
                    stringBuffer.append("Roll To circuit can only have one source.");
                    return null;
                }
            }
        } else if (list2.contains(iNetCircuitEnd)) {
            Object object;
            INetCircuitEnd iNetCircuitEnd5;
            NetCircuitNode netCircuitNode;
            if (netCcatCircuit.isMemberOfVcat() && netCcatCircuit.isOpenEndedVcatCircuit() && (netCircuitNode = netCcatCircuit.getCircuitNodeFromCktEnd(iNetCircuitEnd5 = ((NetVcatTermination)(object = (NetVcatTermination)netCcatCircuit.getVcatGroup().getAllVcatTerms().get(0))).getNetCktEnd())).isIngressPoint(netCcatCircuit.getCktEndFromTermEnd(iNetCircuitEnd5))) {
                stringBuffer.append("Cannot perform single roll on the non-open end of a VCAT circuit.");
                return null;
            }
            if (((NetCircuitNode)iNetCircuitNode).involvedInUpsr(iNetCircuitEnd2) && !netCcatCircuit.isSource((NetCircuitEnd)iNetCircuitEnd2)) {
                stringBuffer.append("Based on circuit roll type and selection of Pivot/Fixed Point 1, only circuit source or drop can be rolled away.");
                return null;
            }
            if (!(netCcatCircuit.isBidirectional() || iNetCircuitNode.getSources().size() == 2 && iNetCircuitNode.getConnectionType() == 6 || n != 1)) {
                stringBuffer.append("Based on circuit direction and selection of Pivot/Fixed Point 1, circuit roll mode must be AUTO.");
                return null;
            }
            if (netCcatCircuit2 != null) {
                object = (NetCircuitDropInfo)netCcatCircuit2.getDrops().get(0);
                iNetCircuitEnd5 = ((NetCircuitDropInfo)object).getNetCktEnd();
                iNetCircuitEnd3 = this.getDccCktEnd(iNetCircuitEnd2.getNodeModel(), iNetCircuitEnd5);
                if (iNetCircuitEnd3 == null) {
                    stringBuffer.append("Can not find the DCC link. \nDCC link needs to be established between selected port \nand destination port of Roll To circuit before rolling.");
                    return null;
                }
                if (netCcatCircuit2.getDrops().size() != 1) {
                    stringBuffer.append("Roll To circuit can only have one drop.");
                    return null;
                }
            }
        }
        if (this.isBLSRmiddleNode((NetCircuitNode)iNetCircuitNode) && this.isRollFromOnBLSR((NetCircuitNode)iNetCircuitNode, (NetCircuitEnd)iNetCircuitEnd2)) {
            stringBuffer.append("Roll From path is part of a " + BLSR_TERM + ", no SINGLE rolls allowed.");
            return null;
        }
        return iNetCircuitEnd3;
    }

    public INetCircuitEnd validateDualRollBNR1(INetCircuit iNetCircuit, INetCircuit iNetCircuit2, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, StringBuffer stringBuffer) {
        INetCircuitEnd iNetCircuitEnd3 = null;
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iNetCircuit;
        NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)iNetCircuit2;
        if (iNetCircuitEnd2 == null) {
            stringBuffer.append("Invalid selection of Pivot/Fixed point 1.");
            db.println("rollFrom passed to validateDualRollBNR1() is null");
            return null;
        }
        this.doCommonCheck(netCcatCircuit, iNetCircuitEnd2, stringBuffer);
        if (stringBuffer.toString().length() > 0) {
            return null;
        }
        INetElement iNetElement = Network.instance().findNetElem(iNetCircuitEnd.getNodeId());
        INetCircuitNode iNetCircuitNode = netCcatCircuit.getCircuitNodeFromNE(iNetElement);
        tdmTerm = iNetCircuitNode.getNodeModel().getTDMTerminology();
        UPSR_TERM = tdmTerm.getRingTerms(0);
        BLSR_TERM = tdmTerm.getRingTerms(1);
        if (netCcatCircuit2 != null) {
            INetCircuitEnd iNetCircuitEnd4 = (INetCircuitEnd)netCcatCircuit2.getSources().get(0);
            iNetCircuitEnd3 = this.getDccCktEnd(iNetCircuitEnd2.getNodeModel(), iNetCircuitEnd4);
            if (iNetCircuitEnd3 == null) {
                stringBuffer.append("Can not find the DCC link. DCC link needs to be established before rolling.");
                return null;
            }
        }
        if (this.isBLSRmiddleNode((NetCircuitNode)iNetCircuitNode) && this.isRollFromOnBLSR((NetCircuitNode)iNetCircuitNode, (NetCircuitEnd)iNetCircuitEnd2)) {
            stringBuffer.append("Cannot roll intermediate node of a " + BLSR_TERM + ".");
            return null;
        }
        return iNetCircuitEnd3;
    }

    public INetCircuitEnd validateDualRollBNR2(INetCircuit iNetCircuit, INetCircuit iNetCircuit2, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, INetCircuitEnd iNetCircuitEnd3, List list, List list2, INetCircuitEnd iNetCircuitEnd4, INetCircuitEnd iNetCircuitEnd5, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        INetCircuitNode iNetCircuitNode;
        INetCircuitEnd iNetCircuitEnd6 = null;
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iNetCircuit;
        NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)iNetCircuit2;
        if (iNetCircuitEnd5 == null) {
            stringBuffer.append("Invalid selection of Pivot/Fixed point 2.");
            db.println("rollFrom passed to validateDualRollBNR2() is null");
            return null;
        }
        this.doCommonCheck(netCcatCircuit, iNetCircuitEnd5, stringBuffer);
        if (stringBuffer.toString().length() > 0) {
            return null;
        }
        INetElement iNetElement = Network.instance().findNetElem(iNetCircuitEnd4.getNodeId());
        INetCircuitNode iNetCircuitNode2 = netCcatCircuit.getCircuitNodeFromNE(iNetElement);
        tdmTerm = iNetCircuitNode2.getNodeModel().getTDMTerminology();
        UPSR_TERM = tdmTerm.getRingTerms(0);
        BLSR_TERM = tdmTerm.getRingTerms(1);
        if (iNetCircuitEnd2.getNodeModel() == iNetCircuitEnd5.getNodeModel()) {
            stringBuffer.append("Pivot/Fixed Point 1 and Pivot/Fixed Point 2 can not be on the same node.");
            return null;
        }
        INetElement iNetElement2 = iNetCircuitEnd2.getNetElement();
        INetElement iNetElement3 = iNetCircuitEnd5.getNetElement();
        int n = netCcatCircuit.getProtType(list2, new LinkedList());
        INetCircuitNode iNetCircuitNode3 = netCcatCircuit.getCircuitNodeFromNE(iNetElement2);
        INetCircuitNode iNetCircuitNode4 = netCcatCircuit.getCircuitNodeFromNE(iNetElement3);
        if (((NetCircuitNode)iNetCircuitNode3).involvedInUpsr(iNetCircuitEnd2) && ((NetCircuitNode)iNetCircuitNode4).involvedInUpsr(iNetCircuitEnd5)) {
            iNetCircuitNode = netCcatCircuit.getUpsrDstNode(list, iNetElement2);
            if (iNetCircuitNode != null && list.indexOf(iNetCircuitNode4) > list.indexOf(iNetCircuitNode)) {
                if (!iNetCircuitNode.getDrops().isEmpty()) {
                    stringBuffer.append("Drops are found between two Pivot/Fixed points in a " + UPSR_TERM + " ring.\nPlease delete drops before rolling.");
                } else {
                    stringBuffer.append("Two Pivot/Fixed points have to be within the same " + UPSR_TERM + " ring.");
                }
                return null;
            }
        } else {
            if (((NetCircuitNode)iNetCircuitNode3).involvedInUpsr(iNetCircuitEnd2) || ((NetCircuitNode)iNetCircuitNode4).involvedInUpsr(iNetCircuitEnd5)) {
                stringBuffer.append("Two Pivot/Fixed points must be both on the same " + UPSR_TERM + " ring\nsegment or on non-" + UPSR_TERM + " ring segment.");
                return null;
            }
            iNetCircuitNode = netCcatCircuit.getDropNode(list, iNetElement2);
            if (iNetCircuitNode != null && list.indexOf(iNetCircuitNode4) > list.indexOf(iNetCircuitNode)) {
                stringBuffer.append("Drops are found between two Pivot/Fixed points. \nPlease delete drops before rolling.");
                return null;
            }
        }
        if (this.isBLSRmiddleNode((NetCircuitNode)iNetCircuitNode2) && this.isRollFromOnBLSR((NetCircuitNode)iNetCircuitNode2, (NetCircuitEnd)iNetCircuitEnd5)) {
            stringBuffer.append("Cannot roll intermediate node of a " + BLSR_TERM + ".");
            return null;
        }
        if (n == 17) {
            boolean bl = true;
            object4 = null;
            object3 = list2.iterator();
            while (object3.hasNext()) {
                object2 = (NetCircuitSpan)object3.next();
                object = ((NetCircuitSpan)object2).getLink();
                if (!object.inBLSR()) continue;
                if (object4 == null) {
                    object4 = object.blsrRingName();
                    continue;
                }
                if (object.blsrRingName().equals(object4)) continue;
                bl = false;
            }
            if (object4 != null && bl) {
                stringBuffer.append("Cannot only roll one " + BLSR_TERM + " ring in a DRI circuit.");
                return null;
            }
        }
        if (netCcatCircuit2 != null) {
            if (!netCcatCircuit.isBidirectional() && n == 12) {
                if (!netCcatCircuit2.isBidirectional()) {
                    stringBuffer.append("The segment between two Pivot/Fixed Points is 1-way " + UPSR_TERM + ", therefore, Roll To circuit must be bidirectional.");
                    return null;
                }
            } else if (netCcatCircuit.getCircuitDir() != netCcatCircuit2.getCircuitDir()) {
                stringBuffer.append("Roll From and Roll To circuits must have the same direction.");
                return null;
            }
            INetCircuitEnd iNetCircuitEnd7 = (INetCircuitEnd)netCcatCircuit2.getSources().get(0);
            object4 = (INetCircuitEnd)netCcatCircuit2.getDrops().get(0);
            iNetCircuitEnd6 = this.getDccCktEnd(iNetCircuitEnd5.getNodeModel(), (INetCircuitEnd)object4);
            if (iNetCircuitEnd6 == null) {
                stringBuffer.append("Can not find the DCC link. DCC link needs to be established before rolling.");
                return null;
            }
            if (!netCcatCircuit.isBidirectional() && n == 12 && !netCcatCircuit2.isBidirectional()) {
                stringBuffer.append("1-way " + UPSR_TERM + " circuit requires bidirectional " + "cross connection on Roll To circuit.");
                return null;
            }
            if (netCcatCircuit.getCircuitDir() != netCcatCircuit2.getCircuitDir()) {
                stringBuffer.append("Circuit roll failure.  Two circuits must have the same direction.");
                return null;
            }
            object3 = this.getNetLinkWithCktEnd(iNetCircuitEnd3);
            object2 = this.getNetLinkWithCktEnd(iNetCircuitEnd6);
            if (NetProtectionType.isUnprotectedType(n)) {
                if (n == 3 && (netCcatCircuit2.getCircuitNodes().size() != 1 && NetProtectionType.isPcaType(netCcatCircuit2.getProtType()) || NetProtectionType.isPcaType(object3.getProtectionType()) || NetProtectionType.isPcaType(object2.getProtectionType()))) {
                    stringBuffer2.append("Are you sure you want to downgrade unprotected path?");
                }
            } else if (NetProtectionType.isProtectedType(n)) {
                if (n == 12) {
                    if (netCcatCircuit2.getCircuitNodes().size() != 1 && netCcatCircuit2.getProtType() != 3 || object3.getProtectionType() != 3 || object2.getProtectionType() != 3) {
                        stringBuffer.append("When rolling on a " + UPSR_TERM + " ring, all spans in the new route have to be unprotected.");
                        return null;
                    }
                    object = ((NetCircuitNode)iNetCircuitNode3).getEgressPoints();
                    List list3 = ((NetCircuitNode)iNetCircuitNode4).getIngressPoints();
                    object.remove(iNetCircuitEnd2);
                    list3.remove(iNetCircuitEnd5);
                    INetLink iNetLink = null;
                    INetLink iNetLink2 = null;
                    if (!object.isEmpty()) {
                        iNetLink = this.getNetLinkWithCktEnd((NetCircuitEnd)object.get(0));
                    }
                    if (!list3.isEmpty()) {
                        iNetLink2 = this.getNetLinkWithCktEnd((NetCircuitEnd)list3.get(0));
                    }
                    if (iNetLink != null && iNetLink.getSrcEntityIndex() == object3.getSrcEntityIndex() || iNetLink2 != null && iNetLink2.getSrcEntityIndex() == object2.getSrcEntityIndex()) {
                        stringBuffer.append("Roll is not allowed because you are trying to make a roll causing working and protect paths onto the same port.");
                        return null;
                    }
                } else if (netCcatCircuit2.getCircuitNodes().size() != 1 && NetProtectionType.isUnprotectedType(netCcatCircuit2.getProtType()) || NetProtectionType.isUnprotectedType(object3.getProtectionType()) || NetProtectionType.isUnprotectedType(object2.getProtectionType())) {
                    stringBuffer2.append("Are you sure you want to downgrade fully-protected path?");
                }
            }
        }
        return iNetCircuitEnd6;
    }

    public List getRollFromPathList(int n, INetCircuitEnd iNetCircuitEnd, INetCircuit iNetCircuit, StringBuffer stringBuffer) {
        LinkedList linkedList = new LinkedList();
        if (iNetCircuitEnd == null) {
            stringBuffer.append("Selected point is not valid, please select a valid roll point.");
            return linkedList;
        }
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iNetCircuit;
        INetElement iNetElement = iNetCircuitEnd.getNetElement();
        INetCircuitNode iNetCircuitNode = netCcatCircuit.getCircuitNodeFromNE(iNetElement);
        if (iNetCircuitNode instanceof LoTunnelNode) {
            if (netCcatCircuit.getCircuitTypeObj().isTunnelCircuitType()) {
                stringBuffer.append("Cannot roll source or drop of a VT tunnel circuit.");
                return linkedList;
            }
            if (netCcatCircuit.getCircuitTypeObj().isLAPCircuitType()) {
                stringBuffer.append("Cannot roll drop of a VT aggregation circuit.");
                return linkedList;
            }
        }
        if (netCcatCircuit instanceof LoCcatCircuit && !this.isVAPCompatibleRoll(iNetCircuitEnd, netCcatCircuit, stringBuffer)) {
            return linkedList;
        }
        List list = iNetCircuitNode.getIngressPoints();
        List list2 = iNetCircuitNode.getEgressPoints();
        if (this.dbgOn()) {
            NetCircuitEnd netCircuitEnd;
            int n2;
            db.println("<<< ingress list contains following cktEnds : >>>");
            for (n2 = 0; n2 < list.size(); ++n2) {
                netCircuitEnd = (NetCircuitEnd)list.get(n2);
                db.println("cktEnd " + n2 + " is : " + netCircuitEnd.prettyString());
            }
            db.println("<<< egress list contains following cktEnds : >>>");
            for (n2 = 0; n2 < list2.size(); ++n2) {
                netCircuitEnd = (NetCircuitEnd)list2.get(n2);
                db.println("cktEnd " + n2 + " is : " + netCircuitEnd.prettyString());
            }
        }
        if (n == SINGLE_ROLL) {
            if (list.contains(iNetCircuitEnd)) {
                if (((NetCircuitNode)iNetCircuitNode).isDriCktEnd(iNetCircuitEnd)) {
                    list2.remove(iNetCircuitEnd);
                }
                return list2;
            }
            if (list2.contains(iNetCircuitEnd)) {
                if (((NetCircuitNode)iNetCircuitNode).isDriCktEnd(iNetCircuitEnd)) {
                    list.remove(iNetCircuitEnd);
                }
                return list;
            }
        } else {
            if (n == DUAL_ROLL_1) {
                if (list.contains(iNetCircuitEnd)) {
                    if (((NetCircuitNode)iNetCircuitNode).isDriCktEnd(iNetCircuitEnd)) {
                        list2.remove(iNetCircuitEnd);
                    }
                    return list2;
                }
                stringBuffer.append("For dual roll, only ingress port of a node can be selected as Pivot/Fixed point 1.");
                return linkedList;
            }
            if (n == DUAL_ROLL_2) {
                if (list2.contains(iNetCircuitEnd)) {
                    if (((NetCircuitNode)iNetCircuitNode).isDriCktEnd(iNetCircuitEnd)) {
                        list.remove(iNetCircuitEnd);
                    }
                    return list;
                }
                stringBuffer.append("For dual roll, only egress port of a node can be selected as Pivot/Fixed point 2.");
                return linkedList;
            }
        }
        stringBuffer.append("Could not find valid Roll From path.");
        return linkedList;
    }

    public List getValidRollSlots(INodeModel iNodeModel) {
        try {
            Class[] classArray = new Class[]{Integer.class};
            Method method = RollValidator.class.getMethod("isValidBNRCard", classArray);
            return iNodeModel.getValidRollSlots(method);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            SDebug.printStackTrace((Throwable)noSuchMethodException);
            return new LinkedList();
        }
    }

    public String getEntityString(IEntityModel iEntityModel) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        IModuleModel iModuleModel = (IModuleModel)iEntityModel.getChildren().get(0);
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iModuleModel);
        return iEntityCellRenderer.getString((Object)iModuleModel, null);
    }

    public List getValidRollPorts(IEntityModel iEntityModel) {
        List list = new LinkedList();
        List list2 = iEntityModel.getChildren();
        IModuleModel iModuleModel = (IModuleModel)list2.get(0);
        if (!iModuleModel.getEqTypeName().startsWith("ETH100") && !iModuleModel.getEqTypeName().startsWith("G1000") && iModuleModel.getEqType() != 102 && iModuleModel.getEqType() != 103 && iModuleModel.getEqType() != 238 && iModuleModel.getEqType() != 221) {
            list = iModuleModel.getDescendantsOfClassType(7);
        }
        return list;
    }

    public String getPortString(IModuleModel iModuleModel) {
        INodeModel iNodeModel = iModuleModel.getNodeModel();
        IEntityCellRenderer iEntityCellRenderer = ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iModuleModel);
        return iEntityCellRenderer.getString((Object)iModuleModel, null);
    }

    private INetCircuitEnd getDccCktEnd(INodeModel iNodeModel, INetCircuitEnd iNetCircuitEnd) {
        try {
            INetLink iNetLink = this.getNetLinkWithCktEnd(iNetCircuitEnd);
            if (iNetLink != null) {
                INetElement iNetElement = Network.instance().findNetElem(iNodeModel.getNodeId());
                if (iNetLink.getDst() == iNetElement) {
                    return new NetCircuitEnd(iNodeModel, iNodeModel.getEntityTable().getEntityModelByIndex(iNetLink.getDstEntityIndex()), iNetCircuitEnd.getHoNum(), iNetCircuitEnd.getLoNum(), false);
                }
            }
            return null;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            return null;
        }
    }

    private INetLink getNetLinkWithCktEnd(INetCircuitEnd iNetCircuitEnd) {
        Network network = Network.instance();
        INetLink iNetLink = network.findNetLinkFromSourceCktEnd(iNetCircuitEnd instanceof LoCircuitEnd, iNetCircuitEnd.getNetElement(), iNetCircuitEnd.getEntityIndex(), iNetCircuitEnd.getHoNum());
        return iNetLink;
    }

    private boolean isConnectedToLAPNode(INetCircuitEnd iNetCircuitEnd, INetCircuit iNetCircuit) {
        if (iNetCircuit.getCircuitTypeObj().isLAPCircuitType()) {
            Iterator iterator = iNetCircuit.getDrops().iterator();
            while (iterator.hasNext()) {
                NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
                NetCircuitEnd netCircuitEnd = netCircuitDropInfo.getNetCktEnd();
                if (!(netCircuitEnd instanceof LoTunnelCircuitEnd)) continue;
                if (this.getDccCktEnd(netCircuitEnd.getNodeModel(), iNetCircuitEnd) == null) break;
                return true;
            }
        }
        return false;
    }

    private boolean isVAPCompatibleRoll(INetCircuitEnd iNetCircuitEnd, INetCircuit iNetCircuit, StringBuffer stringBuffer) {
        INetCircuitNode iNetCircuitNode;
        INetElement iNetElement = iNetCircuitEnd.getNetElement();
        INetCircuitNode iNetCircuitNode2 = iNetCircuit.getCircuitNodeFromNE(iNetElement);
        NetCcatCircuit netCcatCircuit = null;
        NetCcatCircuit netCcatCircuit2 = null;
        NetCcatCircuit netCcatCircuit3 = ((LoCcatCircuit)iNetCircuit).useLAPOnSource();
        if (netCcatCircuit3 != null) {
            netCcatCircuit = netCcatCircuit3;
        } else {
            netCcatCircuit2 = ((LoCcatCircuit)iNetCircuit).useLAPOnDrop();
            if (netCcatCircuit2 != null) {
                netCcatCircuit = netCcatCircuit2;
            }
        }
        if (netCcatCircuit != null && (iNetCircuitNode = netCcatCircuit.getCircuitNodeFromNE(iNetElement)) != null && !(iNetCircuitNode instanceof LoTunnelNode)) {
            stringBuffer.append("Cannot roll VAP portion of this circuit.");
            return false;
        }
        return true;
    }

    private boolean isBLSRmiddleNode(NetCircuitNode netCircuitNode) {
        int n = 0;
        INetElement iNetElement = netCircuitNode.getNetElement();
        if (!netCircuitNode.getSources().isEmpty()) {
            return false;
        }
        List list = netCircuitNode.getAllSpansList();
        Iterator iterator = list.iterator();
        String string = "";
        boolean bl = false;
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            INetLink iNetLink = netCircuitSpan.getLink();
            if (!netCircuitSpan.getLink().inBLSR()) continue;
            if (bl) {
                if (iNetLink.isLOTunnel() || iNetLink.isLAP() ? !string.equals(iNetLink.blsrRingName(iNetElement)) && !netCircuitNode.isBlsrDriHandoff() : !string.equals(iNetLink.blsrRingName()) && !netCircuitNode.isBlsrDriHandoff()) {
                    return false;
                }
            } else {
                bl = true;
                string = iNetLink.isLOTunnel() || iNetLink.isLAP() ? iNetLink.blsrRingName(iNetElement) : iNetLink.blsrRingName();
            }
            ++n;
        }
        return n > 1;
    }

    public boolean allMidNodesInSameBlsr(INetCircuit iNetCircuit) {
        int n = 0;
        Iterator iterator = iNetCircuit.getCircuitNodes().iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (!netCircuitNode.getSources().isEmpty() || !netCircuitNode.getDrops().isEmpty() && !netCircuitNode.getOrigSpans().isEmpty() || this.isBLSRmiddleNode(netCircuitNode)) continue;
            ++n;
        }
        return n <= true;
    }

    private boolean isRollFromOnBLSR(NetCircuitNode netCircuitNode, NetCircuitEnd netCircuitEnd) {
        NetCircuitSpan netCircuitSpan = netCircuitNode.getSpanFromCktEnd(netCircuitEnd);
        if (netCircuitSpan != null) {
            return netCircuitSpan.getLink().inWorkingBLSR();
        }
        return false;
    }

    private void doCommonCheck(INetCircuit iNetCircuit, INetCircuitEnd iNetCircuitEnd, StringBuffer stringBuffer) {
        INetElement iNetElement = iNetCircuitEnd.getNetElement();
        INetCircuitNode iNetCircuitNode = iNetCircuit.getCircuitNodeFromNE(iNetElement);
        if (!RollManager.instance().isBridgeAndRollSupported(iNetElement.getNodeModel())) {
            stringBuffer.append(iNetElement.getName() + " doesn't support Bridge and Roll Feature. " + "Please select a different port.");
            return;
        }
        IEntityModel iEntityModel = null;
        try {
            iEntityModel = iNetCircuitEnd.getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            // empty catch block
        }
        if (iEntityModel != null) {
            if (iEntityModel instanceof IPortModel && !((IPortModel)iEntityModel).isOptical()) {
                stringBuffer.append("Bridge and roll on electrical or data card is not supported. Please select a different port.");
                return;
            }
            IModuleModel iModuleModel = iEntityModel.getModuleModel();
            int n = iModuleModel.getEqType();
            if (!RollValidator.isValidBNRCard(n)) {
                stringBuffer.append("Bridge and roll on electrical or data card is not supported. Please select a different port.");
                return;
            }
        }
        if (iNetCircuitNode.getSources().contains(iNetCircuitEnd) && iNetCircuitNode.getDrops().contains(iNetCircuitEnd)) {
            stringBuffer.append("Bridge and roll on hairpin path is not supported. Please select a different path");
        }
    }

    public static boolean isValidBNRCard(int n) {
        return n == 9 || n == 124 || n == 106 || n == 10 || n == 85 || n == 11 || n == 126 || n == 87 || n == 60 || n == 86 || n == 146 || n == 219 || n == 220 || n == 157 || n == 232;
    }

    static {
        SINGLE_ROLL = 0;
        DUAL_ROLL_1 = 1;
        DUAL_ROLL_2 = 2;
        db = new SDebug("RollValidator");
    }
}

