/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SrgViolation;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.PortSrg;
import cerent.cms.route.SlotSrg;
import cerent.cms.route.Spt;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RouteValidator {
    protected static RouteValidator validator;

    public static synchronized RouteValidator instance() {
        if (validator == null) {
            validator = new RouteValidator();
        }
        return validator;
    }

    public void validateRoute(NetCcatCircuit netCcatCircuit) throws SanityCheckFailed {
        Object object;
        boolean bl = false;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator iterator = netCcatCircuit.getCircuitSpans().iterator();
        while (iterator.hasNext()) {
            object = (NetCircuitSpan)iterator.next();
            linkedList.add(object);
            if (!((NetCircuitSpan)object).getOmni()) continue;
            bl = true;
        }
        object = netCcatCircuit.getMemberPrefs();
        if (object != null) {
            if (((MemberPrefs)object).getDriNodePrefs().size() != 0) {
                bl = true;
            }
            if (((MemberPrefs)object).getPathProtection() == 5 && !bl) {
                throw new SanityCheckFailed("The DRI checkbox is selected but the path is not DRI protected.\n\nIf you are creating a BLSR-DRI, please also ensure:\n- Primary and secondary nodes are specified.\n- A secondary path is specified.");
            }
        }
        List list = new LinkedList();
        if (netCcatCircuit.getCktOperation() != 5) {
            list = netCcatCircuit.getCircuitNodes();
        }
        this.validateRoute(netCcatCircuit, linkedList, list, (MemberPrefs)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateRoute(NetCcatCircuit netCcatCircuit, List list, List list2, MemberPrefs memberPrefs) throws SanityCheckFailed {
        INetLink iNetLink;
        Object object;
        Object object2;
        LinkedList<INetElement> linkedList = new LinkedList<INetElement>();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object2 = (NetCircuitNode)iterator.next();
            if (!((NetCircuitNode)object2).validateConn()) {
                throw new SanityCheckFailed("Invalid span combination at Node " + ((NetCircuitNode)object2).getName());
            }
            linkedList.add(((NetCircuitNode)object2).getNetElement());
        }
        object2 = new LinkedList();
        LinkedList<INetLink> linkedList2 = new LinkedList<INetLink>();
        LinkedList linkedList3 = new LinkedList();
        LinkedList<INetLink> linkedList4 = new LinkedList<INetLink>();
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            object = (INetCircuitSpan)iterator2.next();
            iNetLink = object.getLink();
            if (!iNetLink.canSupportCircuitDirection(netCcatCircuit.getCircuitDir())) {
                throw new SanityCheckFailed("Circuit Path does not support given directionality (uni/bi)");
            }
            if (object.getSrcState() == 2) {
                linkedList2.add(iNetLink);
                linkedList3.add(object);
            } else {
                linkedList4.add(iNetLink);
            }
            if (object.getNetLinkSpan().getOmni() || object.getBlsrDriInterConnect()) continue;
            ((LinkedList)object2).add(iNetLink);
        }
        if (Spt.anyLoops(netCcatCircuit.srcCircuitNode.getNetElement(), (LinkedList)object2)) {
            if (!netCcatCircuit.getCircuitTypeObj().isEthernetCircuitType()) {
                if (netCcatCircuit.getPrimarySource().getNetElement() != netCcatCircuit.getPrimaryDrop().getNetElement()) throw new SanityCheckFailed("Loop detected in selected route");
                if (Spt.anyInvalidRings(netCcatCircuit.srcCircuitNode.getNetElement(), linkedList, (LinkedList)object2)) {
                    throw new SanityCheckFailed("Loop detected in selected route");
                }
            } else {
                if (Spt.anyInvalidRings(netCcatCircuit.srcCircuitNode.getNetElement(), linkedList, (LinkedList)object2)) {
                    throw new SanityCheckFailed("Loop detected in selected route");
                }
                this.checkLinkDiversity((LinkedList)object2);
            }
        }
        if (netCcatCircuit.getCktOperation() != 5 && linkedList2.size() != 0 && linkedList4.size() != 0) {
            object = linkedList2.iterator();
            while (object.hasNext()) {
                iNetLink = (INetLink)object.next();
                Iterator iterator3 = linkedList4.iterator();
                while (iterator3.hasNext()) {
                    INetLink iNetLink2 = (INetLink)iterator3.next();
                    if (iNetLink.getDst() == iNetLink2.getDst()) {
                        throw new SanityCheckFailed("An existing link and a newly chosen link terminate on node " + iNetLink.getDst().getName());
                    }
                    if ((iNetLink2.isLOTunnel() && !iNetLink.isLOTunnel() || iNetLink2.isLAP() && !iNetLink.isLAP()) && iNetLink2.getLinksList().contains(iNetLink)) {
                        throw new SanityCheckFailed("An existing link and a newly chosen link terminate on node " + iNetLink.getDst().getName());
                    }
                    if ((!iNetLink.isLOTunnel() || iNetLink2.isLOTunnel()) && (!iNetLink.isLAP() || iNetLink2.isLAP()) || !iNetLink.getLinksList().contains(iNetLink2)) continue;
                    throw new SanityCheckFailed("An existing link and a newly chosen link terminate on node " + iNetLink2.getDst().getName());
                }
            }
        }
        if (memberPrefs != null && (memberPrefs.getPathProtection() == 0 || memberPrefs.getPathProtection() == 5)) {
            if (memberPrefs.getDiversityOption() == 1) {
                this.checkNodalDiversity(list2);
            }
            if (netCcatCircuit.getCktOperation() == 5) {
                object = new LinkedList<INetLink>(linkedList4);
                ((LinkedList)object).addAll(linkedList2);
                this.checkLinkDiversity((LinkedList)object);
            } else {
                this.checkLinkDiversity(linkedList2);
            }
        }
        if (netCcatCircuit.getCktOperation() == 5 || netCcatCircuit.isMonitorCircuit()) return;
        this.sanityCheckBLSRTimeSlots(list2);
    }

    private void sanityCheckBLSRTimeSlots(List list) throws SanityCheckFailed {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (netCircuitNode.validateBLSRTimeSlots()) continue;
            throw new SanityCheckFailed("Invalid " + NetCircuitNode.getTDMTerminology(netCircuitNode.getNodeModel()).getRingTerms(1) + " same time slot requirement on node " + netCircuitNode.getName());
        }
    }

    private void checkNodalDiversity(List list) throws SanityCheckFailed {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
            if (!netCircuitNode.getSources().isEmpty() || netCircuitNode.countNumInputs() < 2 || netCircuitNode.countRoutedOrigSpans() < 2 || netCircuitNode.driNodeType == 1) continue;
            throw new SanityCheckFailed("Nodal Diverse Path Requirement is not met. The node in question is : " + netCircuitNode.getNetElement().getName());
        }
    }

    private void checkLinkDiversity(LinkedList linkedList) throws SanityCheckFailed {
        HashSet<PortSrg> hashSet = new HashSet<PortSrg>();
        while (linkedList.size() != 0) {
            Object object;
            INetLink iNetLink = (INetLink)linkedList.removeFirst();
            Iterator iterator = iNetLink.getLinksList().iterator();
            while (iterator.hasNext()) {
                object = (INetLink)iterator.next();
                hashSet.add(new PortSrg(object.getSrc(), object.getSrcSlotNumber(), object.getSrcPortNumber()));
                hashSet.add(new PortSrg(object.getDst(), object.getDstSlotNumber(), object.getDstPortNumber()));
            }
            object = linkedList.iterator();
            while (object.hasNext()) {
                INetLink iNetLink2 = (INetLink)object.next();
                try {
                    iNetLink2.containsSrg(hashSet);
                }
                catch (xLinkNotUsable xLinkNotUsable2) {
                    throw new SanityCheckFailed("Slot Diverse Path Requirement is not met.\nThe Link is: " + iNetLink2.prettyString());
                }
            }
        }
    }

    public LinkedList getSrgFailureList(List list) {
        INetLink iNetLink;
        Object object;
        LinkedList<SrgViolation> linkedList = new LinkedList<SrgViolation>();
        LinkedList<INetLink> linkedList2 = new LinkedList<INetLink>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (INetCircuitSpan)iterator.next();
            iNetLink = object.getLink();
            if (object.getSrcState() != 2 && (object.getSrcState() != 4 || object.getCircuit().getState() == 3)) continue;
            linkedList2.add(iNetLink);
            if (!object.getOmni() || object.getSrcState() != 2 || object.getDstState() != 2) continue;
            linkedList2.add(iNetLink.getReverseLink());
        }
        object = new HashSet();
        while (linkedList2.size() != 0) {
            Object object2;
            iNetLink = (INetLink)linkedList2.removeFirst();
            Iterator iterator2 = iNetLink.getLinksList().iterator();
            while (iterator2.hasNext()) {
                object2 = (INetLink)iterator2.next();
                object.add(new SlotSrg(object2.getSrc(), object2.getSrcSlotNumber(), true));
                object.add(new SlotSrg(object2.getDst(), object2.getDstSlotNumber(), false));
            }
            object2 = linkedList2.iterator();
            while (object2.hasNext()) {
                INetLink iNetLink2 = (INetLink)object2.next();
                try {
                    iNetLink2.containsSrg((Collection)object);
                }
                catch (xLinkNotUsable xLinkNotUsable2) {
                    SrgViolation srgViolation = new SrgViolation("Slot Diverse Path Requirement is not met.", iNetLink2);
                    linkedList.add(srgViolation);
                }
            }
        }
        return linkedList;
    }
}

