/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ocm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.model.IOhCircuitInfo;
import cerent.cms.model.IOhCircuitModel;
import cerent.cms.model.IOhConnectionModel;
import cerent.cms.model.IOhConnectionModels;
import cerent.cms.model.IOhXconModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ITdmLineModel;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhCircuitType;
import cerent.cms.model.SdccCircuitInfo;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.topo.INetLink;
import cerent.util.AnnotatedException;
import cerent.util.SDebug;
import java.util.Set;

public class DccTunnel
extends OhCircuit {
    private static final SDebug db = new SDebug("DccTunnel");
    private SdccCircuitInfo sdccCreationInfo;

    public DccTunnel(IOhCircuitInfo iOhCircuitInfo) throws AnnotatedException {
        super(iOhCircuitInfo);
    }

    public DccTunnel(IOhConnectionModel iOhConnectionModel) {
        super(iOhConnectionModel);
    }

    public DccTunnel(IOhCircuitModel iOhCircuitModel) {
        super(iOhCircuitModel);
    }

    protected void createOhCircuitInfoIfce(IOhCircuitInfo iOhCircuitInfo) throws CircuitProvError {
        if (iOhCircuitInfo.getCircuitType() == 4) {
            this.sdccCreationInfo = (SdccCircuitInfo)iOhCircuitInfo;
        }
        if (db.on()) {
            db.println("creating circuit info ifce");
        }
        super.createOhCircuitInfoIfce(iOhCircuitInfo);
    }

    protected static boolean linkValidForSdccTunnel(INetLink iNetLink) {
        if (db.on()) {
            db.println("checking if sdcc channel is available");
        }
        if (!iNetLink.getSrc().getConnectionState() || !iNetLink.getDst().getConnectionState()) {
            return false;
        }
        INodeModel iNodeModel = net.getNodeModel(iNetLink.getSrc().getNodeId());
        int n = iNetLink.getSrcEntityIndex();
        INodeModel iNodeModel2 = net.getNodeModel(iNetLink.getDst().getNodeId());
        int n2 = iNetLink.getDstEntityIndex();
        return DccTunnel.sdccChannelAvailable(iNodeModel, n) && DccTunnel.sdccChannelAvailable(iNodeModel2, n2);
    }

    private static boolean sdccChannelAvailable(INodeModel iNodeModel, int n) {
        IOhConnectionModels iOhConnectionModels = iNodeModel.getOhConnectionModels();
        if (iOhConnectionModels == null) {
            return false;
        }
        for (int i = 0; i < OhChannelType.DCC_CHANNEL_TYPES.length; ++i) {
            OhChannelType ohChannelType = OhChannelType.DCC_CHANNEL_TYPES[i];
            if (!iOhConnectionModels.isChannelAvailable(n, ohChannelType)) continue;
            return true;
        }
        return false;
    }

    protected OhChannelType getChannelType(boolean bl, IOhCircuitEnd iOhCircuitEnd, OhCircuitType ohCircuitType) {
        if (ohCircuitType.equals((Object)OhCircuitType.SDCC_TUNNEL_CIRCUIT_OBJ)) {
            IOhCircuitEnd iOhCircuitEnd2 = this.sdccCreationInfo.getSrcPoint();
            IOhCircuitEnd iOhCircuitEnd3 = this.sdccCreationInfo.getDestPoints()[0];
            if (iOhCircuitEnd.equals(iOhCircuitEnd2) && bl) {
                return this.sdccCreationInfo.getSrcChannelType();
            }
            if (iOhCircuitEnd.equals(iOhCircuitEnd3) && !bl) {
                return this.sdccCreationInfo.getDstChannelType();
            }
            return this.findAvailDccChannel(iOhCircuitEnd);
        }
        return super.getChannelType(bl, iOhCircuitEnd, ohCircuitType);
    }

    protected OhChannelType findAvailDccChannel(IOhCircuitEnd iOhCircuitEnd) {
        OhChannelType[] ohChannelTypeArray;
        INodeModel iNodeModel = net.getNodeModel(iOhCircuitEnd.getNodeId());
        if (iNodeModel == null) {
            if (this.dbgOn()) {
                db.severe("Can't find the node model for node - " + iOhCircuitEnd.getNodeId());
            }
            return null;
        }
        IOhConnectionModels iOhConnectionModels = iNodeModel.getOhConnectionModels();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        if (iOhConnectionModels == null || iEntityTableModel == null) {
            if (this.dbgOn()) {
                db.severe("Can't find the entity table model or ohconnection model for node - " + iOhCircuitEnd.getNodeId());
            }
            return null;
        }
        try {
            IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(iOhCircuitEnd.getPort());
            ITdmLineModel iTdmLineModel = (ITdmLineModel)((IPortModel)iEntityModel).getInterfaceModel();
            ohChannelTypeArray = iTdmLineModel.supportsOhChannel(4) ? OhChannelType.DCC_CHANNEL_TYPES : new OhChannelType[]{OhChannelType.SDCC_OBJ};
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.dbgOn()) {
                db.warning("Can't find entity for " + iOhCircuitEnd.getPort());
            }
            return null;
        }
        for (int i = 0; i < ohChannelTypeArray.length; ++i) {
            if (iOhConnectionModels.isChannelInUse(iOhCircuitEnd.getPort(), ohChannelTypeArray[i])) continue;
            return ohChannelTypeArray[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannelType(int n, boolean bl) {
        IOhXconModel iOhXconModel;
        Set set = (Set)this.connModelMap.get(new Integer(n));
        if (set == null || set.isEmpty()) {
            return -1;
        }
        Set set2 = set;
        synchronized (set2) {
            iOhXconModel = (IOhXconModel)set.iterator().next();
        }
        return bl ? iOhXconModel.getInputChannelType() : iOhXconModel.getOutputChannelType();
    }

    public int getSourceChannelType() {
        return this.getChannelType(this.getSource().getNodeId(), true);
    }

    public int getDestinationChannelType() {
        return this.getChannelType(this.getFirstDestination().getNodeId(), false);
    }
}

