/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ocm;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OhCircuitEnd;
import cerent.cms.ocm.OhCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.util.SDebug;

public class OhNetCircuitEnd
extends OhCircuitEnd {
    INetElement elem;
    INodeModel nodeModel;
    IPortModel portModel;
    INetLink associatedLink = null;
    IOhCircuitEnd cktEnd = null;
    private static final SDebug db = new SDebug("OhNetCircuitEnd");

    public OhNetCircuitEnd() {
        this.cktEnd = new OhCircuitEnd();
    }

    public OhNetCircuitEnd(IOhCircuitEnd iOhCircuitEnd) {
        super(iOhCircuitEnd);
        this.setModels();
        if (this.nodeModel != null && Feature.provides((INodeModel)this.nodeModel, (Feature)Feature.MULTISHELF)) {
            this.setShelf(iOhCircuitEnd.getShelf());
        }
    }

    private void setModels() {
        block5: {
            this.elem = Network.instance().getNetElem(this.getNodeId());
            if (this.elem != null) {
                this.nodeModel = this.elem.getNodeModel();
            }
            if (this.nodeModel != null) {
                try {
                    IEntityTableModel iEntityTableModel = this.nodeModel.getEntityTable();
                    if (iEntityTableModel != null) {
                        this.portModel = (IPortModel)iEntityTableModel.getEntityModelByIndex(this.getPort());
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.dbgOn()) break block5;
                    db.warning("Can't find the entity for index = " + this.getPort());
                }
            }
        }
    }

    public INetElement getNetElement() {
        if (this.elem == null) {
            this.setModels();
        }
        return this.elem;
    }

    public INodeModel getNodeModel() {
        if (this.nodeModel == null) {
            this.setModels();
        }
        return this.nodeModel;
    }

    public void setNodeModel(INodeModel iNodeModel) {
        this.nodeModel = iNodeModel;
    }

    public boolean isPortOptical() {
        if (this.portModel == null) {
            this.setModels();
        }
        return this.portModel != null && this.portModel.isOptical();
    }

    public INetLink getAssociatedLink() {
        if (this.associatedLink == null && this.isPortOptical()) {
            this.associatedLink = Network.instance().findNetLinkFromEnt(this.elem, this.getPort(), true);
        }
        return this.associatedLink;
    }

    public boolean associateWithLink(INetLink iNetLink) {
        if (iNetLink == null || this.getAssociatedLink() == null) {
            return false;
        }
        if (((Object)this.getAssociatedLink()).equals(iNetLink)) {
            return true;
        }
        INetLink iNetLink2 = Network.instance().findReverseLink(iNetLink);
        return iNetLink2 != null && ((Object)this.getAssociatedLink()).equals(iNetLink2);
    }

    public IEntityModel getEntityModel() throws ObjNotFound {
        IEntityModel iEntityModel;
        block4: {
            int n;
            iEntityModel = null;
            IEntityTableModel iEntityTableModel = null;
            INodeModel iNodeModel = this.getNodeModel();
            if (iNodeModel != null && (iEntityTableModel = iNodeModel.getEntityTable()) != null && (n = this.getPort()) != 0) {
                try {
                    iEntityModel = iEntityTableModel.getEntityModelByIndex(this.getPort());
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!this.dbgOn()) break block4;
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
            }
        }
        if (iEntityModel != null) {
            return iEntityModel;
        }
        throw new ObjNotFound("Unable to get entity model");
    }

    protected boolean dbgOn() {
        return db.on() || OhCircuitManager.pkgDbgOn();
    }
}

