/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.CongestionMetric;
import cerent.cms.route.IMetric;
import cerent.cms.route.PathMetric;
import cerent.cms.route.ProtectionMetric;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.SptNode;

public class AggregateMetric
implements IMetric {
    private RoutePrefs prefs;
    private SptNode sptNode;
    private IMetric primary;
    private IMetric secondary;
    private IMetric tertiary;

    public AggregateMetric(RoutePrefs routePrefs, SptNode sptNode) {
        this.prefs = routePrefs;
        this.sptNode = sptNode;
        if (routePrefs.getPrimaryOptimizationCriterion() == 1) {
            this.primary = new PathMetric(routePrefs);
            this.secondary = new ProtectionMetric(routePrefs);
            this.tertiary = new CongestionMetric(routePrefs);
        } else if (routePrefs.getPrimaryOptimizationCriterion() == 2) {
            this.primary = new ProtectionMetric(routePrefs);
            this.secondary = new PathMetric(routePrefs);
            this.tertiary = new CongestionMetric(routePrefs);
        } else if (routePrefs.getPrimaryOptimizationCriterion() == 3) {
            this.primary = new CongestionMetric(routePrefs);
            this.secondary = new PathMetric(routePrefs);
            this.tertiary = new ProtectionMetric(routePrefs);
        }
    }

    private IMetric getPrimaryMetric() {
        return this.primary;
    }

    private IMetric getSecondaryMetric() {
        return this.secondary;
    }

    private IMetric getTertiaryMetric() {
        return this.tertiary;
    }

    public void accumulate(IMetric iMetric, SptLink sptLink, RoutePrefs routePrefs) {
        AggregateMetric aggregateMetric = (AggregateMetric)iMetric;
        this.primary.accumulate(aggregateMetric.getPrimaryMetric(), sptLink, routePrefs);
        this.secondary.accumulate(aggregateMetric.getSecondaryMetric(), sptLink, routePrefs);
        this.tertiary.accumulate(aggregateMetric.getTertiaryMetric(), sptLink, routePrefs);
    }

    public boolean betterThan(Object object) {
        AggregateMetric aggregateMetric = (AggregateMetric)object;
        int n = 0;
        n = this.primary.compareTo(aggregateMetric.getPrimaryMetric());
        if (n == 0) {
            this.secondary.compareTo(aggregateMetric.getSecondaryMetric());
            if (n == 0) {
                this.tertiary.compareTo(aggregateMetric.getTertiaryMetric());
            }
        }
        if (n < 0) {
            return true;
        }
        if (n > 0) {
            return false;
        }
        int n2 = this.sptNode.tieBreaker(aggregateMetric.sptNode);
        if (n2 >= 0) {
            return true;
        }
        if (n2 < 0) {
            return false;
        }
        return false;
    }

    public int compareTo(Object object) {
        if (this.betterThan(object)) {
            return -1;
        }
        return 1;
    }

    public String prettyString() {
        String string = "Metric: ";
        string = string + this.getPrimaryMetric().prettyString();
        string = string + this.getSecondaryMetric().prettyString();
        return string;
    }
}

