/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.AdjacencyExtractor;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class AutoAdjacencyExtractor
extends AdjacencyExtractor {
    public AutoAdjacencyExtractor(RoutePrefs routePrefs) {
        this.prefs = routePrefs;
    }

    protected Collection getAdjacencyList(INetElement iNetElement) {
        Collection collection = super.getAdjacencyList(iNetElement);
        INetLink iNetLink = this.prefs.getRequiredLink(iNetElement);
        if (iNetLink != null) {
            if (!collection.contains(iNetLink)) {
                return new LinkedList();
            }
            LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
            linkedList.add(iNetLink);
            Iterator iterator = collection.iterator();
            block0: while (iterator.hasNext()) {
                INetLink iNetLink2 = (INetLink)iterator.next();
                if (iNetLink2.getLinksList().size() <= 1) continue;
                Iterator iterator2 = iNetLink2.getLinksList().iterator();
                while (iterator2.hasNext()) {
                    INetLink iNetLink3 = (INetLink)iterator2.next();
                    if (iNetLink3.getSrc() != iNetElement && iNetLink3.getDst() != iNetElement) continue;
                    INetLink iNetLink4 = iNetLink3.getReverseLink();
                    if (!((Object)iNetLink3).equals(iNetLink) && (iNetLink4 == null || !((Object)iNetLink4).equals(iNetLink))) continue;
                    linkedList.add(iNetLink2);
                    continue block0;
                }
            }
            return linkedList;
        }
        if (collection.size() == 0) {
            this.prefs.getLog().warning("AutoAdjacencyExtractor: Adjacency List is empty for NE: " + iNetElement.prettyString());
        }
        return collection;
    }
}

