/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.AutoAdjacencyExtractor;
import cerent.cms.route.CircuitPath;
import cerent.cms.route.DebugLog;
import cerent.cms.route.IRouteRequestor;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.PathSegment;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.VcatFilter;
import cerent.cms.topo.INetElement;
import java.util.Iterator;
import java.util.LinkedList;

public class AutoRouteRequestor
implements IRouteRequestor {
    private RoutePrefs prefs;

    public AutoRouteRequestor(RoutePrefs routePrefs) {
        this.prefs = routePrefs;
        if (DebugLog.instance().driPrefs != null) {
            routePrefs.getActiveMember().setDriNodePrefs(DebugLog.instance().driPrefs);
        }
    }

    public AutoRouteRequestor(RoutePrefs routePrefs, boolean bl) {
        this.prefs = routePrefs;
    }

    public CircuitPath getCircuitPath() throws NoRoute {
        CircuitPath circuitPath;
        RoutePrefs routePrefs = new RoutePrefs(this.prefs);
        routePrefs.getLog().getDebugLog().info("AutoRR: " + routePrefs.prettyString());
        AutoAdjacencyExtractor autoAdjacencyExtractor = new AutoAdjacencyExtractor(routePrefs);
        routePrefs.setAdjacencyExtractor(autoAdjacencyExtractor);
        VcatFilter vcatFilter = new VcatFilter(routePrefs, this);
        try {
            circuitPath = vcatFilter.getCircuitPath();
        }
        catch (NoRoute noRoute) {
            throw new NoRoute("No Route Found with Given Requirements", noRoute.getDetailedLog());
        }
        routePrefs.getLog().getDebugLog().info("Auto RR: Complete Circuit Path: " + circuitPath.prettyString());
        return circuitPath;
    }

    public INetElement[] computeReachableNodes() {
        AutoAdjacencyExtractor autoAdjacencyExtractor = new AutoAdjacencyExtractor(this.prefs);
        this.prefs.setAdjacencyExtractor(autoAdjacencyExtractor);
        this.prefs.setPathProt(8);
        this.prefs.setTsi(true);
        this.prefs.setOptimalPath(false);
        this.prefs.setAllTypesLabels(true);
        this.prefs.getActiveDropPrefs().setCommonFiber(false);
        this.prefs.getActiveDropPrefs().getFirstMemberGroupPrefs().setMemberCount(1);
        this.prefs.getLog().getDebugLog().info(this.prefs.prettyString());
        VcatFilter vcatFilter = new VcatFilter(this.prefs, this);
        return vcatFilter.getReachableNodes();
    }

    public static LinkedList computeCircuitPathSegments(LinkedList linkedList) {
        LinkedList<PathSegment> linkedList2 = new LinkedList<PathSegment>();
        PathSegment pathSegment = null;
        LinkedList<NetLinkSpan> linkedList3 = new LinkedList<NetLinkSpan>();
        NetLinkSpan netLinkSpan = null;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            NetLinkSpan netLinkSpan2 = (NetLinkSpan)iterator.next();
            if (netLinkSpan == null || netLinkSpan.getLink().getProtectionType() != netLinkSpan2.getLink().getProtectionType()) {
                if (pathSegment != null) {
                    pathSegment.setPrimary(linkedList3);
                    linkedList2.add(pathSegment);
                }
                pathSegment = new PathSegment();
                linkedList3 = new LinkedList();
            }
            linkedList3.add(netLinkSpan2);
            netLinkSpan = netLinkSpan2;
        }
        if (pathSegment != null) {
            pathSegment.setPrimary(linkedList3);
            linkedList2.add(pathSegment);
        }
        return linkedList2;
    }
}

