/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.DropPath;
import cerent.cms.route.InvalidCircuitPath;
import cerent.cms.route.PathSegment;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import java.util.Iterator;
import java.util.LinkedList;

public class CircuitPath {
    private RoutePrefs routePrefs;
    private DropPath dropPath;
    private DropPath reverseDropPath;

    public CircuitPath(RoutePrefs routePrefs) {
        this.routePrefs = routePrefs;
        this.dropPath = null;
    }

    public void setRoutePrefs(RoutePrefs routePrefs) {
        this.routePrefs = routePrefs;
    }

    public RoutePrefs getRoutePrefs() {
        return this.routePrefs;
    }

    public void setDropPath(DropPath dropPath) throws InvalidCircuitPath {
        if (this.dropPath != null) {
            throw new InvalidCircuitPath();
        }
        this.dropPath = dropPath;
    }

    public DropPath getDropPath() {
        return this.dropPath;
    }

    public void setReverseDropPath(DropPath dropPath) throws InvalidCircuitPath {
        if (this.reverseDropPath != null) {
            throw new InvalidCircuitPath();
        }
        this.reverseDropPath = dropPath;
    }

    public DropPath getReverseDropPath() {
        return this.reverseDropPath;
    }

    public LinkedList getAvailSpans() {
        LinkedList linkedList = new LinkedList();
        linkedList = this.getDropPath().getSpans();
        if (this.reverseDropPath != null) {
            linkedList.addAll(this.getReverseDropPath().getSpans());
        }
        return linkedList;
    }

    public LinkedList getPathSegments() {
        return this.getDropPath().getPathSegments();
    }

    protected LinkedList getMemberSegments() {
        return this.getDropPath().getMemberSegments();
    }

    public LinkedList getPathLinks() {
        LinkedList linkedList = this.getPathSegments();
        LinkedList linkedList2 = new LinkedList();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            PathSegment pathSegment = (PathSegment)iterator.next();
            linkedList2.addAll(pathSegment.getPrimaryLinks());
        }
        return linkedList2;
    }

    public LinkedList getBlsrDriSecPathLinks() {
        LinkedList linkedList = this.getPathSegments();
        LinkedList linkedList2 = new LinkedList();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            PathSegment pathSegment = (PathSegment)iterator.next();
            linkedList2.addAll(pathSegment.getDriLinkSpans());
        }
        return linkedList2;
    }

    public void updatePathSegments(CircuitPath circuitPath) {
        this.getDropPath().updatePathSegments(circuitPath.getDropPath());
    }

    protected LinkedList getAllPathLinks() {
        LinkedList linkedList = this.getPathSegments();
        LinkedList linkedList2 = new LinkedList();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            PathSegment pathSegment = (PathSegment)iterator.next();
            linkedList2.addAll(pathSegment.getPrimaryLinks());
            linkedList2.addAll(pathSegment.getAlternateLinks());
            linkedList2.addAll(pathSegment.getDriLinks());
        }
        return linkedList2;
    }

    private INetLink findLink(INetElement iNetElement, boolean bl, boolean bl2) {
        LinkedList linkedList = this.getPathSegments();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            PathSegment pathSegment = (PathSegment)iterator.next();
            LinkedList linkedList2 = bl ? pathSegment.getPrimaryLinks() : pathSegment.getAlternateLinks();
            Iterator iterator2 = linkedList2.iterator();
            while (iterator2.hasNext()) {
                INetLink iNetLink = (INetLink)iterator2.next();
                if (!(bl2 ? iNetElement.equals(iNetLink.getSrc()) : iNetElement.equals(iNetLink.getDst()))) continue;
                return iNetLink;
            }
        }
        return null;
    }

    private boolean isNodeOnPath(INetElement iNetElement, boolean bl) {
        Iterator iterator = this.getPathSegments().iterator();
        PathSegment pathSegment = null;
        Iterator iterator2 = null;
        LinkedList linkedList = null;
        INetLink iNetLink = null;
        while (iterator.hasNext()) {
            pathSegment = (PathSegment)iterator.next();
            linkedList = bl ? pathSegment.getPrimaryLinks() : pathSegment.getAlternateLinks();
            iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                iNetLink = (INetLink)iterator2.next();
                if (!iNetElement.equals(iNetLink.getSrc()) && !iNetElement.equals(iNetLink.getDst())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isNodeOnPrimaryPath(INetElement iNetElement) {
        return this.isNodeOnPath(iNetElement, true);
    }

    protected boolean isNodeOnAlternatePath(INetElement iNetElement) {
        return this.isNodeOnPath(iNetElement, false);
    }

    protected INetLink findOriginatingPrimaryLink(INetElement iNetElement) {
        return this.findLink(iNetElement, true, true);
    }

    protected INetLink findTerminatingPrimaryLink(INetElement iNetElement) {
        return this.findLink(iNetElement, true, false);
    }

    protected INetLink findOriginatingAlternateLink(INetElement iNetElement) {
        return this.findLink(iNetElement, false, true);
    }

    protected INetLink findTerminatingAlternateLink(INetElement iNetElement) {
        return this.findLink(iNetElement, false, false);
    }

    public void addDriSegment(CircuitPath circuitPath) {
        this.getDropPath().addDriSegment(circuitPath.getDropPath());
    }

    public void addBlsrDriSecondary(CircuitPath circuitPath) {
        this.getDropPath().addBlsrDriSecondary(circuitPath.getDropPath());
    }

    public String prettyString() {
        String string = "Circuit Path: ";
        string = string + this.getDropPath().prettyString();
        if (this.getReverseDropPath() != null) {
            string = string + this.getReverseDropPath().prettyString();
        }
        return string;
    }
}

