/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.model.Feature;
import cerent.cms.route.AutoRouteRequestor;
import cerent.cms.route.CircuitPath;
import cerent.cms.route.DriNodes;
import cerent.cms.route.DropPath;
import cerent.cms.route.DropPrefs;
import cerent.cms.route.IGranularityFilter;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.IPathFilter;
import cerent.cms.route.ISrg;
import cerent.cms.route.LabelSetFactory;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.NodeSrg;
import cerent.cms.route.PathSegment;
import cerent.cms.route.PortSrg;
import cerent.cms.route.ProtectedPathFilter;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.TsiRingConstraint;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.route.xNoAlternatePath;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class DriPathFilter
extends ProtectedPathFilter {
    static final int NOT_BLSR_DRI_SEGMENT = 1;
    static final int P1_S1_SEGMENT = 2;
    static final int P1_P2_SEGMENT = 3;
    static final int S1_P2_SEGMENT = 4;
    static final int P_S_SEGMENT = 5;
    private int segment;
    static String[] segmentName = new String[]{"INVALID", "NOT_BLSR_DRI", "P1->S1", "P1->P2", "S1->P2", "P->S"};
    private INetElement prevStop;
    DriNodes activeDriNodes;

    public DriPathFilter(RoutePrefs routePrefs, IGranularityFilter iGranularityFilter) {
        super(routePrefs, iGranularityFilter);
        this.setDriRings(routePrefs);
        this.activeDriNodes = null;
        this.info("Dri Path Filter created");
    }

    private void setDriRings(RoutePrefs routePrefs) {
        LinkedList linkedList = new LinkedList();
        Iterator iterator = routePrefs.getDriNodePrefs().iterator();
        while (iterator.hasNext()) {
            DriNodes driNodes = (DriNodes)iterator.next();
            linkedList.addAll(driNodes.findBlsrDriRings());
        }
        routePrefs.getActiveMember().setPreferredDriRings(linkedList);
        this.info("Preferred DRI rings are :");
        iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.info("Ring#" + n + " is " + string);
            ++n;
        }
    }

    private int findDriSegment(SptLink sptLink) {
        SptLink sptLink2 = sptLink;
        String string = "";
        this.info("findDriSegment");
        while (sptLink2 != null) {
            this.info("link = " + sptLink2.prettyString());
            INetElement iNetElement = sptLink2.getLink().getSrc();
            if (sptLink2.getLink().inBLSR()) {
                string = sptLink2.getLink().originatingRingName();
            }
            SptLink sptLink3 = sptLink2.getSrcNode().getBestLink();
            String string2 = "";
            boolean bl = false;
            if (sptLink3 != null) {
                bl = sptLink3.getLink().terminatingInRing();
                string2 = sptLink3.getLink().terminatingRingName();
            }
            int n = this.prefs.getActiveMember().findDriNodeType(iNetElement);
            int n2 = this.prefs.getActiveMember().findDriNodeType(sptLink2.getLink().getDst());
            this.prevStop = iNetElement;
            this.info("Node type is " + n);
            switch (n) {
                case 2: {
                    if (n2 == 3) {
                        return 3;
                    }
                    return 2;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    if (bl) {
                        if (!string.equals("") && string2.equals(string)) {
                            return 5;
                        }
                        return 1;
                    }
                    if (this.prefs.getActiveMember().getDriRing(iNetElement).equals("") && !this.prefs.getActiveMember().getOtherDriRing(iNetElement).equals("")) {
                        return 5;
                    }
                    return 1;
                }
                case 7: {
                    return 1;
                }
            }
            sptLink2 = sptLink3;
        }
        return 1;
    }

    public boolean isUsableByParent(SptLink sptLink) throws xLinkNotUsable {
        this.info("PARENT filter called for link " + sptLink.getLink().prettyString());
        return true;
    }

    public boolean isUsable(SptLink sptLink) throws xLinkNotUsable {
        this.info("DriPathFilter: isUsable for link " + sptLink.getLink().prettyString());
        if (sptLink.getLink().getLinkType() == 5) {
            throw new xLinkNotUsable("DriPathFilter: UPSR Loop links are not considered");
        }
        this.segment = this.findDriSegment(sptLink);
        boolean bl = false;
        INetElement iNetElement = sptLink.getLink().getSrc();
        INetElement iNetElement2 = sptLink.getLink().getDst();
        int n = this.prefs.getActiveMember().findDriNodeType(iNetElement);
        int n2 = this.prefs.getActiveMember().findDriNodeType(iNetElement2);
        String string = this.prefs.getActiveMember().getDriRing(iNetElement);
        String string2 = this.prefs.getActiveMember().getOtherDriRing(iNetElement);
        String string3 = this.prefs.getActiveMember().getDriRing(iNetElement2);
        String string4 = "";
        INetLink iNetLink = sptLink.getLink();
        INetLink iNetLink2 = sptLink.getParentLink();
        boolean bl2 = false;
        if (iNetLink2 != null && iNetLink2.inBLSR()) {
            string4 = iNetLink2.terminatingRingName();
            bl2 = iNetLink2.terminatingInRing();
        }
        String string5 = iNetLink.originatingRingName();
        this.info("Dri Segment determined to be " + segmentName[this.segment]);
        this.info("Destination node type is " + n2);
        switch (this.segment) {
            case 1: {
                if (n2 == 4 || n2 == 5 || n2 == 7) {
                    throw new xLinkNotUsable("Secondary nodes are blocked");
                }
                if (n2 == 3) {
                    throw new xLinkNotUsable("P2 nodes are blocked");
                }
                if (!(n2 != 2 || string3 != null && !string3.equals("") && sptLink.getLink().terminatingInRing() && sptLink.getLink().blsrRingName().equals(string3))) {
                    throw new xLinkNotUsable("Terminating link on Primary has to be on BLSR ring " + string3);
                }
                if (!(n != 3 || string != null && !string.equals("") && sptLink.getLink().terminatingInRing() && sptLink.getLink().blsrRingName().equals(string))) {
                    throw new xLinkNotUsable("Originating link on Primary has to be on BLSR ring " + string);
                }
                if (!(n != 7 || string2 == null || string2.equals("") || sptLink.getLink().terminatingInRing() && sptLink.getLink().blsrRingName().equals(string2))) {
                    throw new xLinkNotUsable("Originating link on Secondary has to be on BLSR ring " + string2);
                }
                if (n2 == 6) {
                    if (string3.equals("") && !sptLink.getLink().isFullyUnprotected()) {
                        throw new xLinkNotUsable("Terminating link on Primary needs to be unprotected");
                    }
                    if (!string3.equals("") && !sptLink.getLink().blsrRingName().equals(string3)) {
                        throw new xLinkNotUsable("Terminating link on Primary has to be on BLSR ring " + string3);
                    }
                }
                if (n != 6) break;
                if (string2.equals("") && !sptLink.getLink().isFullyUnprotected()) {
                    throw new xLinkNotUsable("Originating link on Primary needs to be unprotected");
                }
                if (string2.equals("") || sptLink.getLink().blsrRingName().equals(string2)) break;
                throw new xLinkNotUsable("Originating link on Primary has to be BLSR ring " + string2);
            }
            case 3: {
                if (!iNetElement2.equals(this.prefs.getActiveMember().findDriP2(this.prevStop))) {
                    throw new xLinkNotUsable("Not P1->P2 link");
                }
                if (!sptLink.getLink().isFullyUnprotected()) {
                    throw new xLinkNotUsable("P1->P2 link should be unprotected");
                }
                this.info("skipping protected path filter check");
                bl = true;
                break;
            }
            case 2: {
                if (!iNetLink.terminatingInRing()) {
                    throw new xLinkNotUsable("only BLSR links allowed in P1->S1 segment");
                }
                if (!string5.equals(string4) && bl2) {
                    throw new xLinkNotUsable("cannot switch rings on P1->S1 segment");
                }
                if (!iNetElement2.equals(this.prefs.getActiveMember().findDriS1(this.prevStop))) break;
                break;
            }
            case 4: {
                if (!iNetElement2.equals(this.prefs.getActiveMember().findDriP2(this.prevStop))) {
                    throw new xLinkNotUsable("S1->P2 link has to terminate on P2");
                }
                if (sptLink.getLink().isFullyUnprotected()) break;
                throw new xLinkNotUsable("S1->P2 link should be unprot");
            }
            case 5: {
                if (!iNetLink.terminatingInRing()) {
                    throw new xLinkNotUsable("only BLSR links allowed in P->S segment");
                }
                if (!string4.equals("") && !string5.equals(string4)) {
                    throw new xLinkNotUsable("Cannot switch ring in P->S segment");
                }
                if (!this.prefs.getActiveMember().getDriRing(this.prevStop).equals("") || this.prefs.getActiveMember().getOtherDriRing(this.prevStop).equals("") || this.prefs.getActiveMember().getOtherDriRing(this.prevStop).equals(string5)) break;
                throw new xLinkNotUsable("link on incorrect BLSR ring ");
            }
        }
        if (bl) {
            return this.gFilter.isUsable(sptLink);
        }
        return super.isUsable(sptLink);
    }

    public CircuitPath getCircuitPath() throws NoRoute {
        this.validateDriPrefs();
        CircuitPath circuitPath = super.getCircuitPath();
        this.computeDriPaths(circuitPath);
        this.prefs.getLog().getDebugLog().info("Complete Circuit Path: ");
        this.prefs.getLog().getDebugLog().info(circuitPath.prettyString());
        this.cleanUpRoutePrefs();
        return circuitPath;
    }

    private void validateDriPrefs() throws NoRoute {
        DriNodes driNodes;
        Iterator iterator;
        if (this.prefs.getSecSrc() == null) {
            iterator = this.prefs.getDriNodePrefs().iterator();
            while (iterator.hasNext()) {
                driNodes = (DriNodes)iterator.next();
                if (driNodes.findDriNodeType(this.prefs.getSrc()) != 7 && driNodes.findDriNodeType(this.prefs.getSrc()) != 6) continue;
                this.info("Circuit source and P,S nodes can only overlap in case of Openended DRI");
                this.info("Single source cannot lie on S or P node");
                throw new NoRoute("Single source cannot be a S' or P node -");
            }
        }
        if (this.prefs.getSecDst() == null) {
            iterator = this.prefs.getDriNodePrefs().iterator();
            while (iterator.hasNext()) {
                driNodes = (DriNodes)iterator.next();
                if (driNodes.findDriNodeType(this.prefs.getDst()) != 7 && driNodes.findDriNodeType(this.prefs.getDst()) != 6) continue;
                this.info("Circuit destination and P,S nodes can only overlap in case of Openended DRI");
                this.info("Single destination cannot lie on S or P node");
                throw new NoRoute("Single destination cannot be a S or P node -");
            }
        }
    }

    private void cleanUpRoutePrefs() {
        Iterator iterator = this.prefs.getDriNodePrefs().iterator();
        while (iterator.hasNext()) {
            DriNodes driNodes = (DriNodes)iterator.next();
            driNodes.clearTsiRingConstraints();
        }
    }

    private void computeDriPaths(CircuitPath circuitPath) throws NoRoute {
        DropPath dropPath = circuitPath.getDropPath();
        boolean bl = false;
        this.computeOmniForUpsrBlsr(circuitPath);
        Set set = this.buildSrgListForCircuitPath(circuitPath);
        if (circuitPath.getPathSegments().size() == 0) {
            return;
        }
        Iterator iterator = circuitPath.getPathSegments().iterator();
        while (iterator.hasNext()) {
            PathSegment pathSegment = (PathSegment)iterator.next();
            this.info("computing DRI paths for segment " + pathSegment.prettyString());
            if (pathSegment.getAlternate().size() != 0) {
                if (pathSegment.getDri().isEmpty()) {
                    this.computeDriPathForSegment(circuitPath, pathSegment, set);
                } else {
                    this.info("Segment is already DRI protected");
                }
            } else {
                this.info("Skipping line-protected segment");
            }
            if (pathSegment.getDri().isEmpty()) continue;
            bl = true;
        }
        if (!bl) {
            this.info("Throwing No Route since DRI-protection was not possible");
            throw new NoRoute("Unable to provide DRI Protection for the Circuit");
        }
    }

    private Set buildSrgListForCircuitPath(CircuitPath circuitPath) {
        HashSet<ISrg> hashSet = new HashSet<ISrg>();
        LinkedList linkedList = circuitPath.getAllPathLinks();
        Iterator iterator = linkedList.iterator();
        INetLink iNetLink = null;
        while (iterator.hasNext()) {
            iNetLink = (INetLink)iterator.next();
            Iterator iterator2 = iNetLink.getLinksList().iterator();
            while (iterator2.hasNext()) {
                INetLink iNetLink2 = (INetLink)iterator2.next();
                hashSet.add(new PortSrg(iNetLink2.getSrc(), iNetLink2.getSrcSlotNumber(), iNetLink2.getSrcPortNumber()));
                hashSet.add(new PortSrg(iNetLink2.getDst(), iNetLink2.getDstSlotNumber(), iNetLink2.getDstPortNumber()));
                hashSet.add(new NodeSrg(iNetLink2.getSrc(), 3));
                hashSet.add(new NodeSrg(iNetLink2.getDst(), 3));
            }
        }
        return hashSet;
    }

    private boolean computeDriPathForSegment(CircuitPath circuitPath, PathSegment pathSegment, Set set) throws NoRoute {
        CircuitPath circuitPath2;
        Iterator iterator;
        CircuitPath circuitPath3;
        int n = 0;
        boolean bl = false;
        this.prefs.getLog().info("Computing DRI Path for segment");
        INetElement iNetElement = pathSegment.getSrc();
        INetElement iNetElement2 = pathSegment.getAlternateSrc();
        int n2 = this.prefs.getActiveMember().findDriNodeType(iNetElement);
        if (iNetElement2 != null && iNetElement2 != iNetElement && n2 == 1) {
            circuitPath3 = this.computeDriSegment(iNetElement, iNetElement2, set);
            circuitPath.addDriSegment(circuitPath3);
            bl = true;
        }
        if (!(iterator = pathSegment.getPrimaryLinks().iterator()).hasNext()) {
            return false;
        }
        INetLink iNetLink = (INetLink)iterator.next();
        block6: while (iterator.hasNext()) {
            INetLink iNetLink2 = iNetLink;
            iNetLink = (INetLink)iterator.next();
            LinkedList linkedList = pathSegment.getAlternateLinks();
            for (int i = n; i < linkedList.size() - 1; ++i) {
                INetLink iNetLink3 = (INetLink)linkedList.get(i);
                INetLink iNetLink4 = (INetLink)linkedList.get(i + 1);
                iNetElement = iNetLink2.getDst();
                iNetElement2 = iNetLink3.getDst();
                this.prefs.getLog().info("Primary, Alternate candidates " + iNetElement.prettyString() + " and " + iNetElement2.prettyString());
                try {
                    circuitPath2 = this.computeDriSegment(iNetElement, iNetElement2, set);
                }
                catch (NoRoute noRoute) {
                    continue;
                }
                Set set2 = this.buildSrgListForCircuitPath(circuitPath2);
                set2.addAll(set);
                if (this.prefs.isUniDirectional()) {
                    circuitPath.addDriSegment(circuitPath2);
                    n = i + 1;
                    this.prefs.getLog().info("Not computing lower spans for uni-dir circuit");
                    bl = true;
                    continue block6;
                }
                try {
                    circuitPath3 = this.computeDriSegment(iNetElement, iNetElement2, set2);
                    n = i + 1;
                }
                catch (NoRoute noRoute) {
                    this.prefs.getLog().info("Integrated DRI case failed");
                    iNetElement = iNetLink.getDst();
                    iNetElement2 = iNetLink4.getDst();
                    if (iNetElement.equals(pathSegment.getDst())) {
                        this.prefs.getLog().info("Ran out of primary candidates");
                        continue block6;
                    }
                    if (iNetElement2.equals(pathSegment.getAlternateDst())) {
                        this.prefs.getLog().info("Ran out of alternate candidates");
                        continue block6;
                    }
                    if (iterator.hasNext()) {
                        iNetLink = (INetLink)iterator.next();
                    }
                    if (iNetElement.equals(iNetElement2)) continue;
                    this.prefs.getLog().info("Attempting non-integrated path from " + iNetElement.prettyString() + " " + iNetElement2.prettyString());
                    try {
                        circuitPath3 = this.computeDriSegment(iNetElement, iNetElement2, set2);
                        n = i + 2;
                    }
                    catch (NoRoute noRoute2) {
                        continue;
                    }
                }
                this.prefs.getLog().info("Successfully computed lower ring ");
                circuitPath.addDriSegment(circuitPath2);
                circuitPath.addDriSegment(circuitPath3);
                bl = true;
                continue block6;
            }
        }
        iNetElement = pathSegment.getDst();
        iNetElement2 = pathSegment.getAlternateDst();
        n2 = this.prefs.getActiveMember().findDriNodeType(iNetElement);
        if (iNetElement2 != null && iNetElement2 != iNetElement && n2 == 1) {
            circuitPath2 = this.computeDriSegment(iNetElement, iNetElement2, set);
            circuitPath.addDriSegment(circuitPath2);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CircuitPath computeDriSegment(INetElement iNetElement, INetElement iNetElement2, Set set) throws NoRoute {
        if (this.prefs.isUniDirectional()) {
            if (!iNetElement.getNodeModel().provides(Feature.UPSR_DRI)) {
                throw new NoRoute(iNetElement.getName() + " does not support DRI");
            }
            if (!iNetElement2.getNodeModel().provides(Feature.UPSR_DRI)) {
                throw new NoRoute(iNetElement.getName() + " does not support DRI");
            }
        }
        RoutePrefs routePrefs = new RoutePrefs();
        DropPrefs dropPrefs = routePrefs.getActiveDropPrefs();
        MemberGroupPrefs memberGroupPrefs = dropPrefs.getActiveMemberGroupPrefs();
        MemberPrefs memberPrefs = memberGroupPrefs.getMemberPrefs();
        routePrefs.setSrc(iNetElement);
        routePrefs.setCircuitType(this.prefs.getCircuitType());
        routePrefs.setTsi(this.prefs.Tsi());
        routePrefs.setAdjacencyExtractor(this.prefs.getAdjacencyExtractor());
        dropPrefs.setDrop(iNetElement2);
        memberGroupPrefs.setMemberCount(this.prefs.getMemberCount());
        memberGroupPrefs.setMemberBandwidth(this.prefs.getBandwidth());
        memberPrefs.setPrimaryOptimizationCriterion(this.prefs.getPrimaryOptimizationCriterion());
        memberPrefs.setPathProtection(3);
        memberPrefs.setDir(this.prefs.getDirectionality());
        memberPrefs.setDiversityOption(this.prefs.getDiversityOption());
        memberPrefs.addExcludeSpans(this.prefs.getExcludeSpans());
        memberPrefs.setExcludeSrgs(new HashSet(this.prefs.getExcludeSrgs()));
        memberPrefs.setSla(this.prefs.getSla());
        memberPrefs.addSrgs(set);
        memberPrefs.getExcludeSrgs().remove(new NodeSrg(iNetElement, 3));
        memberPrefs.getExcludeSrgs().remove(new NodeSrg(iNetElement2, 3));
        CircuitPath circuitPath = null;
        routePrefs.getLog().getDebugLog().beginIndent();
        try {
            AutoRouteRequestor autoRouteRequestor = new AutoRouteRequestor(routePrefs, true);
            circuitPath = autoRouteRequestor.getCircuitPath();
            LinkedList linkedList = circuitPath.getAvailSpans();
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                INetLinkSpan iNetLinkSpan = (INetLinkSpan)iterator.next();
                iNetLinkSpan.setOmni(true);
            }
        }
        finally {
            routePrefs.getLog().getDebugLog().endIndent();
        }
        return circuitPath;
    }

    protected DriNodes getActiveDriNodes() {
        return this.activeDriNodes;
    }

    private void computeOmniForUpsrBlsr(CircuitPath circuitPath) throws NoRoute {
        this.info("computOmniForUpsrBlsr");
        Iterator iterator = this.prefs.getDriNodePrefs().iterator();
        Set set = this.buildSrgListForCircuitPath(circuitPath);
        CircuitPath circuitPath2 = null;
        while (iterator.hasNext()) {
            block12: {
                circuitPath2 = null;
                DriNodes driNodes = (DriNodes)iterator.next();
                INetElement iNetElement = driNodes.getPrimary();
                if (iNetElement == null) continue;
                INetElement iNetElement2 = this.prefs.getActiveMember().findDriPeer(iNetElement);
                int n = this.prefs.getActiveMember().findDriNodeType(iNetElement);
                if (n != 6 || iNetElement.equals(this.prefs.getSrc()) || iNetElement.equals(this.prefs.getDst())) continue;
                INetLink iNetLink = circuitPath.findOriginatingPrimaryLink(iNetElement);
                INetLink iNetLink2 = circuitPath.findTerminatingPrimaryLink(iNetElement);
                if (iNetLink == null || iNetLink2 == null) {
                    this.info("Throwing No Route since prmLink = null");
                    throw new NoRoute("Primary link not found.");
                }
                if (!driNodes.getFirstDriRing().equals("") && !driNodes.getSecondDriRing().equals("")) continue;
                this.info("Computing UPSR omni for DRI Nodes " + driNodes.prettyString());
                try {
                    this.info("Attempt Integrated OMNI span");
                    circuitPath2 = this.computeDriSegment(iNetElement, iNetElement2, set);
                }
                catch (NoRoute noRoute) {
                    INetLink iNetLink3;
                    this.info("Integrated OMNI could not be found");
                    if (driNodes.getFirstDriRing().equals("") && !driNodes.getSecondDriRing().equals("")) {
                        this.info("Trying UPSR-BLSR Trad");
                        INetLink iNetLink4 = circuitPath.findTerminatingAlternateLink(iNetElement2);
                        if (iNetLink2 != null && !iNetLink2.getSrc().equals(this.prefs.getSrc()) && iNetLink4 != null && !iNetLink4.getSrc().equals(this.prefs.getSrc())) {
                            try {
                                circuitPath2 = this.computeDriSegment(iNetLink2.getSrc(), iNetLink4.getSrc(), set);
                            }
                            catch (NoRoute noRoute2) {
                                this.info("Trad UPSR-BLSR OMNI Not Found");
                                this.info("UPSR is open ended");
                            }
                        }
                    }
                    this.info("Trying BLSR-UPSR Trad");
                    INetElement iNetElement3 = null;
                    INetElement iNetElement4 = null;
                    if (!circuitPath.isNodeOnPrimaryPath(iNetElement2)) {
                        this.info("Same side");
                        iNetLink3 = circuitPath.findOriginatingAlternateLink(iNetElement2);
                        iNetElement3 = iNetLink != null ? iNetLink.getDst() : null;
                        iNetElement4 = iNetLink3 != null ? iNetLink3.getDst() : null;
                    } else {
                        this.info("Opposite side");
                        iNetLink3 = circuitPath.findOriginatingPrimaryLink(iNetElement2);
                        iNetLink = circuitPath.findOriginatingAlternateLink(iNetElement);
                        iNetElement3 = iNetLink3 != null ? iNetLink3.getDst() : null;
                        INetElement iNetElement5 = iNetElement4 = iNetLink != null ? iNetLink.getDst() : null;
                    }
                    if (iNetElement3 == null || iNetElement3.equals(this.prefs.getDst()) || iNetElement4 == null || iNetElement4.equals(this.prefs.getDst())) break block12;
                    try {
                        circuitPath2 = this.computeDriSegment(iNetElement3, iNetElement4, set);
                    }
                    catch (NoRoute noRoute3) {
                        this.info("Trad BLSR-UPSR OMNI Not Found");
                        this.info("UPSR is open ended");
                    }
                }
            }
            if (circuitPath2 == null) continue;
            circuitPath.addDriSegment(circuitPath2);
        }
    }

    private int findSecondaryFilterMode(CircuitPath circuitPath, INetElement iNetElement, int n) {
        this.info("Finding DRI secondary filter mode for primary " + iNetElement.prettyString() + " and node type " + n);
        switch (n) {
            case 2: {
                INetLink iNetLink = circuitPath.findOriginatingPrimaryLink(iNetElement);
                if (iNetLink != null && iNetLink.getDst().equals(this.prefs.getActiveMember().findDriP2(iNetElement))) {
                    return 100;
                }
                return 101;
            }
            case 6: {
                INetLink iNetLink = circuitPath.findOriginatingPrimaryLink(iNetElement);
                INetLink iNetLink2 = circuitPath.findTerminatingPrimaryLink(iNetElement);
                if (iNetLink != null && iNetLink2 != null && iNetLink.originatingRingName().equals(iNetLink2.terminatingRingName()) && !iNetLink.originatingRingName().equals("")) {
                    return 103;
                }
                return 102;
            }
        }
        return 9;
    }

    private LinkedList findPrimarySegment(CircuitPath circuitPath, INetElement iNetElement, INetElement iNetElement2, int n) {
        INetLink iNetLink;
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        INetElement iNetElement3 = iNetElement;
        if (n == 102) {
            return linkedList;
        }
        while (!iNetElement3.equals(iNetElement2)) {
            iNetLink = circuitPath.findOriginatingPrimaryLink(iNetElement3);
            if (iNetLink == null) {
                this.info("Warning! error while computing primary DRIsegment ");
                return linkedList;
            }
            linkedList.add(iNetLink);
            iNetElement3 = iNetLink.getDst();
        }
        if (n == 103) {
            iNetLink = circuitPath.findOriginatingPrimaryLink(iNetElement2);
        }
        return linkedList;
    }

    private INetElement findSecondaryDestination(CircuitPath circuitPath, INetElement iNetElement, int n) {
        if (n == 100 || n == 101) {
            return this.prefs.getActiveMember().findDriP2(iNetElement);
        }
        if (n == 103) {
            return this.prefs.getActiveMember().findDriS(iNetElement);
        }
        if (n == 102) {
            return this.prefs.getActiveMember().findDriS(iNetElement);
        }
        return null;
    }

    private boolean handleDualSourceBlsr(CircuitPath circuitPath, INetElement iNetElement, int n, DriNodes driNodes) throws xNoAlternatePath {
        if (iNetElement.equals(this.prefs.getSecSrc())) {
            throw new xNoAlternatePath("Primary DRI node cannot be secondary source");
        }
        if (!iNetElement.equals(this.prefs.getSrc()) || this.prefs.getSecSrc() == null) {
            return false;
        }
        this.info("handling Dual source BLSR-DRI case");
        if (!this.prefs.getActiveMember().findDriPeer(driNodes, iNetElement).equals(this.prefs.getSecSrc())) {
            throw new xNoAlternatePath("If Circuit source is DRI primary then Alt. source has to be corresponding secondary");
        }
        if (driNodes.getDriType() != 2) {
            throw new xNoAlternatePath("Circuit source cannot be part of traditional DRI");
        }
        INetLink iNetLink = circuitPath.findOriginatingPrimaryLink(iNetElement);
        CircuitPath circuitPath2 = this.computeAlternatePath(circuitPath, new LinkedList(), this.prefs.getSecSrc(), iNetElement, 104, this);
        circuitPath.addBlsrDriSecondary(circuitPath2);
        return true;
    }

    private boolean handleDualDestinationBlsr(CircuitPath circuitPath, INetElement iNetElement, int n, DriNodes driNodes) throws xNoAlternatePath {
        if (iNetElement.equals(this.prefs.getSecDst())) {
            throw new xNoAlternatePath("Primary DRI node cannot be secondary destination");
        }
        if (!iNetElement.equals(this.prefs.getDst()) || this.prefs.getSecDst() == null) {
            return false;
        }
        this.info("handling Dual destination BLSR-DRI case");
        if (!this.prefs.getActiveMember().findDriPeer(driNodes, iNetElement).equals(this.prefs.getSecDst())) {
            throw new xNoAlternatePath("If Circuit destination is DRI primary then Alt. destination has to be corresponding secondary");
        }
        if (driNodes.getDriType() != 2) {
            throw new xNoAlternatePath("Circuit source cannot be part of traditional DRI");
        }
        INetLink iNetLink = circuitPath.findTerminatingPrimaryLink(iNetElement);
        CircuitPath circuitPath2 = this.computeAlternatePath(circuitPath, new LinkedList(), iNetElement, this.prefs.getSecDst(), 104, this);
        circuitPath.addBlsrDriSecondary(circuitPath2);
        return true;
    }

    private boolean handleUpsrBlsr(CircuitPath circuitPath, INetElement iNetElement, int n, DriNodes driNodes) throws xNoAlternatePath {
        INetLink iNetLink = circuitPath.findTerminatingPrimaryLink(iNetElement);
        INetLink iNetLink2 = circuitPath.findOriginatingPrimaryLink(iNetElement);
        Set set = this.buildSrgListForCircuitPath(circuitPath);
        boolean bl = false;
        INetElement iNetElement2 = this.prefs.getActiveMember().findDriPeer(iNetElement);
        if (driNodes.getDriType() == 1) {
            return false;
        }
        if (!driNodes.getFirstDriRing().equals("") && !driNodes.getSecondDriRing().equals("")) {
            return false;
        }
        if (circuitPath.isNodeOnPrimaryPath(this.prefs.getActiveMember().findDriPeer(iNetElement))) {
            return true;
        }
        if (driNodes.getFirstDriRing().equals("") && !driNodes.getSecondDriRing().equals("")) {
            this.info("Handling UPSR-BLSR DRI");
            CircuitPath circuitPath2 = this.computeAlternatePath(circuitPath, new LinkedList(), iNetElement2, iNetElement, 104, this);
            circuitPath.addBlsrDriSecondary(circuitPath2);
        } else {
            this.info("Handling BLSR-UPSR DRI");
            CircuitPath circuitPath3 = this.computeAlternatePath(circuitPath, new LinkedList(), iNetElement, iNetElement2, 104, this);
            circuitPath.addBlsrDriSecondary(circuitPath3);
        }
        this.info("done handling UPSR-BLSR/BLSR-UPSR");
        return true;
    }

    private void setTsiRingConstraints(CircuitPath circuitPath) {
        DropPath dropPath = circuitPath.getDropPath();
        LinkedList linkedList = dropPath.getSpans();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ILabel iLabel;
            ILabelSet iLabelSet = null;
            NetLinkSpan netLinkSpan = (NetLinkSpan)iterator.next();
            this.info(" Setting RingCons. for Span = " + netLinkSpan.prettyString());
            INetLink iNetLink = netLinkSpan.getLink();
            if (!iNetLink.inBLSR()) continue;
            String string = iNetLink.originatingRingName();
            ILabel iLabel2 = iLabel = netLinkSpan.getSrcLabel();
            if (this.activeDriNodes.isSecPca() && (iNetLink.getProtectionType() == 5 || iNetLink.getProtectionType() == 0)) {
                IHoNum iHoNum;
                int n = iNetLink.getSrc().getNodeModel().getFramingType();
                if (!(iNetLink instanceof NetLink)) {
                    return;
                }
                int n2 = ((NetLink)iNetLink).getPhysicalSize() / 2 + 1;
                IHoNum iHoNum2 = HoLoFactory.idlSts2HoNum(n, n2);
                IHoNum iHoNum3 = HoLoFactory.addOffset(iHoNum2, -1);
                if (iLabel instanceof IHoLoNum) {
                    iHoNum = ((IHoLoNum)iLabel).getHoNum();
                    IHoNum iHoNum4 = HoLoFactory.addHoNums(iHoNum, iHoNum3);
                    iLabel2 = HoLoFactory.createHoLoNum(iHoNum4, ((IHoLoNum)iLabel).getLoNum());
                } else if (iLabel instanceof IHoNum) {
                    iHoNum = HoLoFactory.addHoNums((IHoNum)iLabel, iHoNum3);
                    this.info(" DRI secondary: Adding pcaOffset = " + iHoNum3.prettyString() + " with hoNum " + iLabel.prettyString() + " gives : " + iHoNum.prettyString());
                    iLabel2 = iHoNum;
                }
            }
            if (iLabelSet == null) {
                iLabelSet = LabelSetFactory.create(iLabel2);
            }
            iLabelSet.addLabel(iLabel2);
            TsiRingConstraint tsiRingConstraint = new TsiRingConstraint(string, iLabelSet);
            this.activeDriNodes.addTsiRingConstraint(tsiRingConstraint);
        }
    }

    protected boolean computeAlternatePaths(CircuitPath circuitPath) throws xNoAlternatePath {
        Iterator iterator = this.prefs.getDriNodePrefs().iterator();
        this.info("DriPathFilter: computeAlternatePaths");
        this.info("Walking the DRI nodes");
        while (iterator.hasNext()) {
            int n;
            DriNodes driNodes;
            this.activeDriNodes = driNodes = (DriNodes)iterator.next();
            this.info("Computing secondary for DRI Nodes " + this.activeDriNodes.prettyString());
            INetElement iNetElement = driNodes.getPrimary();
            if (iNetElement == null || this.handleDualSourceBlsr(circuitPath, iNetElement, n = this.prefs.getActiveMember().findDriNodeType(iNetElement), driNodes) || this.handleDualDestinationBlsr(circuitPath, iNetElement, n, driNodes) || this.handleUpsrBlsr(circuitPath, iNetElement, n, driNodes)) continue;
            int n2 = this.findSecondaryFilterMode(circuitPath, iNetElement, n);
            this.info("Identified secondary filter mode as " + n2);
            INetElement iNetElement2 = this.findSecondaryDestination(circuitPath, iNetElement, n2);
            LinkedList linkedList = this.findPrimarySegment(circuitPath, iNetElement, iNetElement2, n2);
            if (iNetElement2 == null) continue;
            CircuitPath circuitPath2 = this.computeAlternatePath(circuitPath, linkedList, iNetElement, iNetElement2, n2, this);
            circuitPath.addBlsrDriSecondary(circuitPath2);
            if (n2 != 102) continue;
            this.info("Secondary mode is Integ Same side- routing in reverse direction ");
            LinkedList linkedList2 = new LinkedList(circuitPath.getPathLinks());
            linkedList2.addAll(circuitPath2.getPathLinks());
            linkedList.addAll(circuitPath2.getPathLinks());
            INetLink iNetLink = circuitPath.findOriginatingPrimaryLink(iNetElement);
            circuitPath2 = super.computeAlternatePath(linkedList2, linkedList, iNetElement2, iNetElement, n2, this, null);
            circuitPath.addBlsrDriSecondary(circuitPath2);
        }
        return super.computeAlternatePaths(circuitPath);
    }

    protected CircuitPath computeAlternatePath(CircuitPath circuitPath, LinkedList linkedList, INetElement iNetElement, INetElement iNetElement2, int n, IPathFilter iPathFilter) throws xNoAlternatePath {
        this.setTsiRingConstraints(circuitPath);
        return super.computeAlternatePath(circuitPath.getPathLinks(), linkedList, iNetElement, iNetElement2, n, iPathFilter, null);
    }

    private void info(String string) {
        this.prefs.getLog().getDebugLog().info(string);
    }
}

