/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.CircuitPath;
import cerent.cms.route.DebugLog;
import cerent.cms.route.IEndProtectPathFilter;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NodeSrg;
import cerent.cms.route.PathSegment;
import cerent.cms.route.ProtectedPathFilter;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.xNoAlternatePath;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.UPSRLoopLink;
import cerent.util.ILabel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class DualEndProtectPathFilter
implements IEndProtectPathFilter {
    RoutePrefs prefs;
    ProtectedPathFilter filter;
    private boolean twoSoneD;
    DebugLog dLog;
    UPSRLoopLink srcToSecSrc;
    UPSRLoopLink SecSrcToSrc;
    UPSRLoopLink dstToSecDst;
    UPSRLoopLink SecDstToDst;

    public DualEndProtectPathFilter(RoutePrefs routePrefs, ProtectedPathFilter protectedPathFilter) {
        this.prefs = routePrefs;
        this.filter = protectedPathFilter;
        this.dLog = routePrefs.getLog().getDebugLog();
        this.createUPSRLoopLinks();
        this.twoSoneD = false;
        if (routePrefs.getSecSrc() != null && routePrefs.getSecSrc() != routePrefs.getSrc()) {
            this.dLog.info("DualEndProtectedPathFilter: 2 Sources, 1 Destination");
            this.twoSoneD = true;
        } else {
            this.dLog.info("DualEndProtectedPathFilter: 1 Source, 2 Destinations");
        }
    }

    private boolean upsrLoopLinkRequired(INetElement iNetElement, INetElement iNetElement2) {
        Network network = Network.instance();
        if (network == null) {
            this.dLog.info("Couldn't get network object");
            return true;
        }
        this.dLog.info("Looking for Unprotected links between " + iNetElement.prettyString() + "and " + iNetElement2.prettyString());
        LinkedList linkedList = (LinkedList)network.findAllNetLinksWithNetElem(iNetElement);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!iNetLink.getDst().equals(iNetElement2) && !iNetLink.getSrc().equals(iNetElement2) || !iNetLink.isFullyUnprotected()) continue;
            this.dLog.info("Unprotected link found " + iNetLink.prettyString());
            return false;
        }
        return true;
    }

    private void createUPSRLoopLinks() {
        if (this.prefs.getSecSrc() != null && this.prefs.getSecSrc() != this.prefs.getSrc() && this.upsrLoopLinkRequired(this.prefs.getSrc(), this.prefs.getSecSrc())) {
            this.srcToSecSrc = new UPSRLoopLink(this.prefs.getSrc(), this.prefs.getSecSrc());
            this.prefs.getSrc().addAdjacentLink(this.srcToSecSrc);
            this.SecSrcToSrc = new UPSRLoopLink(this.prefs.getSecSrc(), this.prefs.getSrc());
            this.prefs.getSecSrc().addAdjacentLink(this.SecSrcToSrc);
        }
        if (this.prefs.getSecDst() != null && this.prefs.getSecDst() != this.prefs.getDst() && this.upsrLoopLinkRequired(this.prefs.getDst(), this.prefs.getSecDst())) {
            this.dstToSecDst = new UPSRLoopLink(this.prefs.getDst(), this.prefs.getSecDst());
            this.prefs.getDst().addAdjacentLink(this.dstToSecDst);
            this.SecDstToDst = new UPSRLoopLink(this.prefs.getSecDst(), this.prefs.getDst());
            this.prefs.getSecDst().addAdjacentLink(this.SecDstToDst);
        }
    }

    public void cleanup() {
        if (this.srcToSecSrc != null) {
            this.prefs.getSrc().removeAdjacentLink(this.srcToSecSrc);
            this.prefs.getSecSrc().removeAdjacentLink(this.SecSrcToSrc);
        }
        if (this.dstToSecDst != null) {
            this.prefs.getDst().removeAdjacentLink(this.dstToSecDst);
            this.prefs.getSecDst().removeAdjacentLink(this.SecDstToDst);
        }
    }

    public boolean alternatePaths(CircuitPath circuitPath, LinkedList linkedList) throws xNoAlternatePath {
        Set set = null;
        LinkedList linkedList2 = circuitPath != null ? circuitPath.getMemberSegments() : this.computeSegments(linkedList);
        INetElement iNetElement = null;
        INetElement iNetElement2 = null;
        INetElement iNetElement3 = null;
        INetElement iNetElement4 = null;
        for (int i = 0; i < linkedList2.size(); ++i) {
            LinkedList linkedList3 = (LinkedList)linkedList2.get(i);
            boolean bl = this.isLineProtected(linkedList3);
            if (bl) continue;
            if (linkedList3.size() > 0) {
                iNetElement3 = ((INetLink)linkedList3.getFirst()).getSrc();
                iNetElement4 = ((INetLink)linkedList3.getLast()).getDst();
                iNetElement = iNetElement3;
                iNetElement2 = iNetElement4;
            }
            if (this.twoSoneD) {
                if (linkedList3.size() == 0) {
                    iNetElement = this.prefs.getSecSrc();
                    iNetElement2 = this.prefs.getSrc();
                } else if (iNetElement3 == this.prefs.getSrc()) {
                    iNetElement = this.prefs.getSecSrc();
                    set = this.build2s1DSrgList(linkedList3);
                }
            } else if (linkedList3.size() == 0) {
                iNetElement = this.prefs.getDst();
                iNetElement2 = this.prefs.getSecDst();
            } else if (iNetElement4 == this.prefs.getDst()) {
                iNetElement2 = this.prefs.getSecDst();
                set = this.build1s2DSrgList(linkedList3);
            }
            this.computeAlternatePath(linkedList, linkedList3, iNetElement, iNetElement2, circuitPath, set);
        }
        return true;
    }

    private void computeAlternatePath(LinkedList linkedList, LinkedList linkedList2, INetElement iNetElement, INetElement iNetElement2, CircuitPath circuitPath, Set set) throws xNoAlternatePath {
        Object object;
        if (linkedList2.size() > 0) {
            object = ((INetLink)linkedList2.getFirst()).getSrc();
            INetElement iNetElement3 = ((INetLink)linkedList2.getLast()).getDst();
            this.dLog.info("computeAlternatePath: Segment Source: " + object.prettyString() + "Segment Drop: " + iNetElement3.prettyString() + "Alt Segment Source: " + iNetElement.prettyString() + "Alt Segment Drop: " + iNetElement2.prettyString());
        } else {
            this.dLog.info("computeAlternatePath: Null SegmentAlt Segment Source: " + iNetElement.prettyString() + "Alt Segment Drop: " + iNetElement2.prettyString());
        }
        if (iNetElement == iNetElement2) {
            return;
        }
        object = this.filter.computeAlternatePath(linkedList, linkedList2, iNetElement, iNetElement2, 3, null, set);
        this.dLog.info("DualEnd: altCp " + ((CircuitPath)object).prettyString());
        if (circuitPath != null) {
            this.dLog.info("Adding altCp to cp " + circuitPath.prettyString());
            circuitPath.updatePathSegments((CircuitPath)object);
        }
    }

    private LinkedList computeSegments(LinkedList linkedList) throws xNoAlternatePath {
        Object object;
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        LinkedList linkedList3 = new LinkedList();
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink;
            object = (INetLink)iterator.next();
            if (object.isFullyProtected()) {
                bl = true;
            }
            if (this.twoSoneD) {
                if (object.getDst() == this.prefs.getSecSrc() && bl) {
                    throw new xNoAlternatePath("Path from primary Source to Drop passes through Secondary Source. There is protected link before that. ");
                }
                if (object.getSrc() == this.prefs.getSrc() && object.isFullyProtected() && this.prefs.getDiversityOption() == 1) {
                    throw new xNoAlternatePath("A protected link is not allowed from primary Source when two sources exist and nodal diverse is required.");
                }
                if (object.getSrc() == this.prefs.getSrc() && object.isFullyProtected()) {
                    linkedList3.add(new LinkedList());
                }
            } else {
                if (object.getDst() == this.prefs.getSecDst()) {
                    bl2 = true;
                    bl = false;
                }
                if (object.getDst() == this.prefs.getDst() && bl && bl2) {
                    throw new xNoAlternatePath("Path from Primary Source to Primary Drop passes through Secondary Drop. There is protected link after that. ");
                }
                if (object.getDst() == this.prefs.getDst() && object.isFullyProtected() && this.prefs.getDiversityOption() == 1) {
                    throw new xNoAlternatePath("A protected link is not allowed to Primary Drop when two drops exist and nodal diverse is required.");
                }
                if (object.getDst() == this.prefs.getDst() && object.isFullyProtected()) {
                    linkedList3.add(new LinkedList());
                }
            }
            if (linkedList2.size() > 0 && !this.filter.areProtectionTypesSimilar(iNetLink = (INetLink)linkedList2.getFirst(), (INetLink)object)) {
                linkedList3.add(linkedList2);
                linkedList2 = new LinkedList<Object>();
            }
            linkedList2.add(object);
        }
        if (linkedList2.size() > 0) {
            linkedList3.add(linkedList2);
        } else if (linkedList.size() == 0) {
            linkedList3.add(new LinkedList());
        }
        iterator = linkedList3.iterator();
        this.dLog.info("Computed the following segments: ");
        while (iterator.hasNext()) {
            object = new String();
            linkedList2 = (LinkedList<Object>)iterator.next();
            object = linkedList2.size() == 0 ? (String)object + "\t: Null Segment: " : (String)object + "\t Segment Src: " + ((INetLink)linkedList2.getFirst()).getSrc().prettyString() + " Segment Dst: " + ((INetLink)linkedList2.getLast()).getDst().prettyString();
            object = (String)object + " Line Protected: " + this.isLineProtected(linkedList2);
            this.dLog.info((String)object);
        }
        return linkedList3;
    }

    private boolean isLineProtected(LinkedList linkedList) {
        if (linkedList.size() == 0) {
            return false;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (iNetLink.isFullyProtected()) continue;
            return false;
        }
        return true;
    }

    public LinkedList computeCircuitPathSegments(LinkedList linkedList, int n) {
        LinkedList linkedList2;
        PathSegment pathSegment = null;
        LinkedList<PathSegment> linkedList3 = new LinkedList<PathSegment>();
        LinkedList<NetLinkSpan> linkedList4 = new LinkedList<NetLinkSpan>();
        LinkedList<INetLink> linkedList5 = new LinkedList<INetLink>();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            linkedList5.add(((SptLink)iterator.next()).getLink());
        }
        try {
            linkedList2 = this.computeSegments(linkedList5);
        }
        catch (xNoAlternatePath xNoAlternatePath2) {
            this.dLog.info(xNoAlternatePath2.getString());
            return new LinkedList();
        }
        for (int i = 0; i < linkedList2.size(); ++i) {
            LinkedList linkedList6 = (LinkedList)linkedList2.get(i);
            pathSegment = new PathSegment(this.prefs.getSrc(), this.prefs.getDst());
            linkedList4 = new LinkedList();
            iterator = linkedList6.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                SptLink sptLink = this.getSptLink(linkedList, iNetLink);
                ILabelSet iLabelSet = sptLink.getSrcLabelSet();
                ILabelSet iLabelSet2 = sptLink.getDstLabelSet();
                ILabel[] iLabelArray = iLabelSet.getLabels(this.prefs.getMemberCount());
                ILabel[] iLabelArray2 = iLabelSet2.getLabels(this.prefs.getMemberCount());
                NetLinkSpan netLinkSpan = new NetLinkSpan(sptLink.getLink(), sptLink.getLink().getReverseLink(), iLabelArray[n], iLabelArray2[n]);
                linkedList4.add(netLinkSpan);
            }
            pathSegment.setPrimary(linkedList4);
            linkedList3.add(pathSegment);
        }
        return linkedList3;
    }

    private SptLink getSptLink(LinkedList linkedList, INetLink iNetLink) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            SptLink sptLink = (SptLink)iterator.next();
            if (sptLink.getLink() != iNetLink) continue;
            return sptLink;
        }
        return null;
    }

    private Set build2s1DSrgList(LinkedList linkedList) {
        INetLink iNetLink;
        HashSet<NodeSrg> hashSet = new HashSet<NodeSrg>();
        boolean bl = false;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            iNetLink = (INetLink)iterator.next();
            if (iNetLink.getSrc() != this.prefs.getSecSrc() && iNetLink.getDst() != this.prefs.getSecSrc()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            iNetLink = (INetLink)iterator.next();
            if (iNetLink.getSrc() == this.prefs.getSecSrc()) continue;
            hashSet.add(new NodeSrg(iNetLink.getSrc(), 3));
        }
        return hashSet;
    }

    private Set build1s2DSrgList(LinkedList linkedList) {
        INetLink iNetLink;
        HashSet<NodeSrg> hashSet = new HashSet<NodeSrg>();
        boolean bl = false;
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            iNetLink = (INetLink)iterator.next();
            if (iNetLink.getSrc() != this.prefs.getSecDst() && iNetLink.getDst() != this.prefs.getSecDst()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        this.dLog.info("DualEndProtectedPathFilter: BuidlingSrgList for 1s2d: Segment traverses through d2");
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            iNetLink = (INetLink)iterator.next();
            if (iNetLink.getSrc() != this.prefs.getSecDst()) continue;
            this.dLog.info("DualEndProtectedPathFilter: BuidlingSrgList for 1s2d: Found d2");
            hashSet.add(new NodeSrg(iNetLink.getDst(), 3));
        }
        return hashSet;
    }
}

