/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.model.ObjDuplicate;
import cerent.cms.route.DriNodePair;
import cerent.cms.route.DriNodes;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.ISrg;
import cerent.cms.route.LabelSrg;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.NodeSrg;
import cerent.cms.route.PortSrg;
import cerent.cms.route.RouteLog;
import cerent.cms.route.TsiConstraint;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.util.ILabel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class MemberPrefs {
    private int protectionPref;
    private int directionality;
    private int diversity;
    private LinkedList requiredLinks;
    private LinkedList requiredNodes;
    private Set preferredLinks;
    private Set requiredSpans;
    private Set tsiConstraints;
    private Set excludeSrgs;
    private int sla;
    private int primaryCriterion;
    private LinkedList excludeSpans;
    private MemberGroupPrefs mg;
    private int id;
    private List driNodePrefs;
    private LinkedList preferredDriRings;
    private boolean useDiverseSrlg;
    private boolean sameStsRouting;
    private LinkedList allStsToUse;

    public MemberPrefs(MemberGroupPrefs memberGroupPrefs) {
        this.mg = memberGroupPrefs;
        this.primaryCriterion = 1;
        this.protectionPref = 2;
        this.directionality = 2;
        this.diversity = 1;
        this.requiredLinks = new LinkedList();
        this.requiredNodes = new LinkedList();
        this.preferredLinks = new HashSet();
        this.requiredSpans = new HashSet();
        this.tsiConstraints = new HashSet();
        this.excludeSrgs = new HashSet();
        this.excludeSpans = new LinkedList();
        this.sla = 0;
        this.id = 1;
        this.driNodePrefs = new LinkedList();
        this.preferredDriRings = new LinkedList();
        this.useDiverseSrlg = false;
        this.sameStsRouting = false;
        this.allStsToUse = new LinkedList();
    }

    public MemberPrefs(MemberPrefs memberPrefs, MemberGroupPrefs memberGroupPrefs) {
        this.mg = memberGroupPrefs;
        this.primaryCriterion = memberPrefs.primaryCriterion;
        this.protectionPref = memberPrefs.protectionPref;
        this.directionality = memberPrefs.directionality;
        this.diversity = memberPrefs.diversity;
        this.useDiverseSrlg = memberPrefs.useDiverseSrlg;
        this.sameStsRouting = memberPrefs.sameStsRouting;
        this.allStsToUse = new LinkedList(memberPrefs.allStsToUse);
        this.requiredLinks = new LinkedList(memberPrefs.requiredLinks);
        this.requiredNodes = new LinkedList(memberPrefs.requiredNodes);
        this.preferredLinks = new HashSet(memberPrefs.preferredLinks);
        this.requiredSpans = new HashSet(memberPrefs.requiredSpans);
        this.tsiConstraints = new HashSet(memberPrefs.tsiConstraints);
        this.excludeSrgs = new HashSet(memberPrefs.excludeSrgs);
        this.excludeSpans = new LinkedList(memberPrefs.excludeSpans);
        this.sla = memberPrefs.sla;
        this.id = memberPrefs.id;
        this.driNodePrefs = new LinkedList(memberPrefs.driNodePrefs);
        this.preferredDriRings = new LinkedList(memberPrefs.preferredDriRings);
    }

    public void setPrimaryOptimizationCriterion(int n) {
        this.primaryCriterion = n;
    }

    public int getPrimaryOptimizationCriterion() {
        return this.primaryCriterion;
    }

    public void setPathProtection(int n) {
        this.protectionPref = n;
    }

    public int getPathProtection() {
        return this.protectionPref;
    }

    public void setDiversityOption(int n) {
        this.diversity = n;
    }

    public int getDiversityOption() {
        return this.diversity;
    }

    public void addRequiredLink(INetLink iNetLink) {
        String string = "MemberPrefs: Adding the required link: ";
        string = string + iNetLink.prettyString();
        if (!this.requiredLinks.contains(iNetLink)) {
            this.requiredLinks.add(iNetLink);
            string = string + " Done";
        }
        this.getLog().getDebugLog().finest(string);
    }

    public void addRequiredLinks(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (this.requiredLinks.contains(iNetLink)) continue;
            this.requiredLinks.add(iNetLink);
        }
    }

    public LinkedList getRequiredLinks() {
        return this.requiredLinks;
    }

    public Map getTsiConstraints(INetElement iNetElement, String string) {
        Iterator iterator = this.tsiConstraints.iterator();
        TreeMap<ILabel, TsiConstraint> treeMap = new TreeMap<ILabel, TsiConstraint>();
        while (iterator.hasNext()) {
            TsiConstraint tsiConstraint = (TsiConstraint)iterator.next();
            INetElement iNetElement2 = tsiConstraint.getNetElement();
            if (!iNetElement2.equals(iNetElement) || !tsiConstraint.getRingName().equals(string)) continue;
            treeMap.put(tsiConstraint.getLabel(), tsiConstraint);
        }
        return treeMap;
    }

    public void addTsiConstraints(Collection collection) {
        this.tsiConstraints.addAll(collection);
    }

    public Set getTsiConstraints() {
        return this.tsiConstraints;
    }

    public Set getRequiredSpans() {
        return this.requiredSpans;
    }

    public void addExcludeSpans(LinkedList linkedList) {
        this.excludeSpans.addAll(linkedList);
    }

    public LinkedList getExcludeSpans() {
        return this.excludeSpans;
    }

    public void addExcludeLink(INetLink iNetLink) {
        ISrg iSrg;
        ISrg iSrg2;
        if (iNetLink.getLinkType() == 2) {
            iSrg2 = new LabelSrg(iNetLink.getSrc(), iNetLink.getSrcSlotNumber(), iNetLink.getSrcPortNumber(), (ILabel)iNetLink.getSrcHo());
            iSrg = new LabelSrg(iNetLink.getDst(), iNetLink.getDstSlotNumber(), iNetLink.getDstPortNumber(), (ILabel)iNetLink.getDstHo());
        } else {
            iSrg2 = new PortSrg(iNetLink.getSrc(), iNetLink.getSrcSlotNumber(), iNetLink.getSrcPortNumber());
            iSrg = new PortSrg(iNetLink.getDst(), iNetLink.getDstSlotNumber(), iNetLink.getDstPortNumber());
        }
        this.excludeSrgs.add(iSrg2);
        this.excludeSrgs.add(iSrg);
    }

    public void addRequiredNode(INetElement iNetElement) {
        String string = "MemberPrefs: Adding the required Node: ";
        string = string + iNetElement.prettyString();
        if (!this.requiredNodes.contains(iNetElement)) {
            if (this.getSrc() == null) {
                string = string + "Source is NULL";
            }
            if (!iNetElement.equals(this.getSrc())) {
                this.requiredNodes.add(iNetElement);
                string = string + " Done";
            }
        }
        this.getLog().getDebugLog().finest(string);
    }

    public LinkedList getRequiredNodes() {
        return this.requiredNodes;
    }

    public void addExcludeNode(INetElement iNetElement) {
        NodeSrg nodeSrg = new NodeSrg(iNetElement, 3);
        this.excludeSrgs.add(nodeSrg);
    }

    public Set getExcludeSrgs() {
        return this.excludeSrgs;
    }

    public void setExcludeSrgs(Set set) {
        this.excludeSrgs = set;
    }

    public void addSrgs(Collection collection) {
        this.excludeSrgs.addAll(collection);
    }

    public boolean getDiverseSrlg() {
        return this.useDiverseSrlg;
    }

    public void setDiverseSrlg(boolean bl) {
        this.useDiverseSrlg = bl;
    }

    public void setSameStsRouting(boolean bl) {
        this.sameStsRouting = bl;
    }

    public boolean sameStsRouting() {
        return this.sameStsRouting;
    }

    public void setStsToUse(int n) {
        Integer n2 = new Integer(n);
        this.allStsToUse.add(n2);
    }

    public LinkedList allStsToUse() {
        if (this.sameStsRouting) {
            return this.allStsToUse;
        }
        return null;
    }

    public void addStsToUse(LinkedList linkedList) {
        if (linkedList == null) {
            return;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            this.allStsToUse.add(n);
        }
    }

    public void clearStsToUse() {
        if (this.allStsToUse != null) {
            this.allStsToUse.clear();
        }
    }

    public void addPreferredLink(INetLink iNetLink) {
        if (iNetLink == null) {
            return;
        }
        this.preferredLinks.add(iNetLink);
    }

    public void addPreferredLinks(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            this.preferredLinks.add(iNetLink);
        }
    }

    public Set getPreferredLinks() {
        return this.preferredLinks;
    }

    private RouteLog getLog() {
        return this.mg.getLog();
    }

    protected INetElement getSrc() {
        return this.mg.getSrc();
    }

    public void addRequiredSpan(INetLinkSpan iNetLinkSpan) {
        this.requiredSpans.add(iNetLinkSpan);
        this.addPreferredLink(iNetLinkSpan.getLink());
    }

    public void addRequiredSpans(Collection collection) {
        this.requiredSpans.addAll(collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            NetLinkSpan netLinkSpan = (NetLinkSpan)iterator.next();
            this.addPreferredLink(netLinkSpan.getLink());
        }
    }

    private void validateReqEntityList(Collection collection) throws ObjDuplicate {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            INetElement iNetElement;
            Object e = iterator.next();
            if (e instanceof INetLink) {
                INetLink iNetLink = (INetLink)e;
                try {
                    iNetLink.containsSrg(this.excludeSrgs);
                    continue;
                }
                catch (xLinkNotUsable xLinkNotUsable2) {
                    throw new ObjDuplicate("Link " + iNetLink.prettyString() + " exists in Required Links and Exclude Links");
                }
            }
            if (!(e instanceof INetElement) || !this.excludeSrgs.contains(new NodeSrg(iNetElement = (INetElement)e, 3))) continue;
            throw new ObjDuplicate("Node " + iNetElement.prettyString() + " exists in Required Nodes and Exclude Nodes");
        }
    }

    public void setReqEntityList(Collection collection) throws ObjDuplicate {
        this.validateReqEntityList(collection);
        this.requiredNodes.clear();
        this.requiredLinks.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            if (e instanceof INetLink) {
                object = (INetLink)e;
                this.addRequiredLink((INetLink)object);
                this.addRequiredNode(object.getSrc());
                this.addRequiredNode(object.getDst());
                continue;
            }
            if (!(e instanceof INetElement)) continue;
            object = (INetElement)e;
            this.addRequiredNode((INetElement)object);
        }
    }

    public void addExcludeLinks(LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            this.addExcludeLink(iNetLink);
        }
    }

    public void addExcludeNodes(LinkedList linkedList) {
        this.getLog().getDebugLog().finest("MemberPrefs: Adding Exclude Nodes SRG list");
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            this.addExcludeNode(iNetElement);
        }
    }

    public void setExcEntityList(LinkedList linkedList) throws ObjDuplicate {
        this.excludeSrgs.clear();
        this.addExcEntityList(linkedList);
    }

    public void addExcEntityList(LinkedList linkedList) throws ObjDuplicate {
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object e = iterator.next();
            if (e instanceof INetLink) {
                object = (INetLink)e;
                this.addExcludeLink((INetLink)object);
                continue;
            }
            if (!(e instanceof INetElement)) continue;
            object = (INetElement)e;
            this.addExcludeNode((INetElement)object);
        }
        this.validateReqEntityList(this.requiredLinks);
        this.validateReqEntityList(this.requiredNodes);
    }

    public void setSla(int n) {
        this.sla = n;
    }

    public int getSla() {
        return this.sla;
    }

    public void setMemberId(int n) {
        this.id = n;
    }

    public int getMemberId() {
        return this.id;
    }

    public void setDirectionality(int n) {
        this.directionality = n;
    }

    public void setDir(int n) {
        if (n == 0) {
            this.setDirectionality(2);
        } else {
            this.setDirectionality(3);
        }
    }

    public int getDirectionality() {
        return this.directionality;
    }

    public MemberGroupPrefs getMemberGroupPrefs() {
        return this.mg;
    }

    public List getDriNodePrefs() {
        return this.driNodePrefs;
    }

    public void setDriNodePrefs(List list) {
        this.driNodePrefs = list;
    }

    public LinkedList getPreferredDriRings() {
        return this.preferredDriRings;
    }

    public void setPreferredDriRings(LinkedList linkedList) {
        this.preferredDriRings = linkedList;
    }

    public void addDriNodes(DriNodes driNodes) {
        this.driNodePrefs.add(driNodes);
    }

    public void clearDriNodePrefs() {
        this.driNodePrefs.clear();
    }

    public int getDriType(INetElement iNetElement) {
        if (this.driNodePrefs.size() == 0) {
            return -1;
        }
        Iterator iterator = this.driNodePrefs.iterator();
        while (iterator.hasNext()) {
            DriNodes driNodes = (DriNodes)iterator.next();
            if (!driNodes.isNodeInDriNodes(iNetElement)) continue;
            return driNodes.getDriType();
        }
        return -1;
    }

    public String getDriRing(INetElement iNetElement) {
        if (this.driNodePrefs.size() == 0) {
            return null;
        }
        Iterator iterator = this.driNodePrefs.iterator();
        while (iterator.hasNext()) {
            DriNodes driNodes = (DriNodes)iterator.next();
            if (!driNodes.isNodeInDriNodes(iNetElement)) continue;
            return driNodes.getDriRing(iNetElement);
        }
        return null;
    }

    public String getOtherDriRing(INetElement iNetElement) {
        if (this.driNodePrefs.size() == 0) {
            return null;
        }
        Iterator iterator = this.driNodePrefs.iterator();
        while (iterator.hasNext()) {
            DriNodes driNodes = (DriNodes)iterator.next();
            if (!driNodes.isNodeInDriNodes(iNetElement)) continue;
            return driNodes.getOtherDriRing(iNetElement);
        }
        return null;
    }

    public void sanityCheck() throws NoRoute {
        Iterator iterator = this.driNodePrefs.iterator();
        while (iterator.hasNext()) {
            DriNodes driNodes = (DriNodes)iterator.next();
            driNodes.sanityCheck();
        }
    }

    public boolean isBlsrDriNode(INetElement iNetElement) {
        return this.findDriNodeType(iNetElement) != 1;
    }

    protected int findDriNodeType(INetElement iNetElement) {
        if (this.driNodePrefs == null) {
            return 1;
        }
        Iterator iterator = this.driNodePrefs.iterator();
        while (iterator.hasNext()) {
            DriNodes driNodes = (DriNodes)iterator.next();
            int n = driNodes.findDriNodeType(iNetElement);
            if (n == 1) continue;
            return n;
        }
        return 1;
    }

    public INetElement findDriPeer(INetElement iNetElement) {
        DriNodes driNodes = this.findDriNodes(iNetElement);
        if (driNodes == null) {
            return null;
        }
        return this.findDriPeer(driNodes, iNetElement);
    }

    protected INetElement findDriPeer(DriNodes driNodes, INetElement iNetElement) {
        Iterator iterator = driNodes.getNodePairs().iterator();
        while (iterator.hasNext()) {
            DriNodePair driNodePair = (DriNodePair)iterator.next();
            if (iNetElement.equals(driNodePair.getPrimary())) {
                return driNodePair.getSecondary();
            }
            if (!iNetElement.equals(driNodePair.getSecondary())) continue;
            return driNodePair.getPrimary();
        }
        return null;
    }

    private DriNodes findDriNodes(INetElement iNetElement) {
        Iterator iterator = this.driNodePrefs.iterator();
        while (iterator.hasNext()) {
            DriNodes driNodes = (DriNodes)iterator.next();
            Iterator iterator2 = driNodes.getNodePairs().iterator();
            while (iterator2.hasNext()) {
                DriNodePair driNodePair = (DriNodePair)iterator2.next();
                if (!driNodePair.getPrimary().equals(iNetElement) && !driNodePair.getSecondary().equals(iNetElement)) continue;
                return driNodes;
            }
        }
        return null;
    }

    private DriNodePair findDriOtherPair(DriNodes driNodes, INetElement iNetElement) {
        if (driNodes.getDriType() != 1) {
            return null;
        }
        List list = driNodes.getNodePairs();
        DriNodePair driNodePair = (DriNodePair)list.get(0);
        DriNodePair driNodePair2 = (DriNodePair)list.get(1);
        if (driNodePair.getPrimary().equals(iNetElement) || driNodePair.getSecondary().equals(iNetElement)) {
            return driNodePair2;
        }
        if (driNodePair2.getPrimary().equals(iNetElement) || driNodePair2.getSecondary().equals(iNetElement)) {
            return driNodePair;
        }
        return null;
    }

    protected INetElement findDriP2(INetElement iNetElement) {
        DriNodes driNodes = this.findDriNodes(iNetElement);
        if (driNodes.getDriType() != 1) {
            return null;
        }
        DriNodePair driNodePair = this.findDriOtherPair(driNodes, iNetElement);
        return driNodePair.getPrimary();
    }

    protected INetElement findDriS1(INetElement iNetElement) {
        DriNodes driNodes = this.findDriNodes(iNetElement);
        return this.findDriPeer(driNodes, iNetElement);
    }

    protected INetElement findDriS2(INetElement iNetElement) {
        DriNodes driNodes = this.findDriNodes(iNetElement);
        if (driNodes.getDriType() != 1) {
            return null;
        }
        DriNodePair driNodePair = this.findDriOtherPair(driNodes, iNetElement);
        return driNodePair.getSecondary();
    }

    protected INetElement findDriS2givenS1(INetElement iNetElement) {
        DriNodes driNodes = this.findDriNodes(iNetElement);
        if (driNodes.getDriType() != 1) {
            return null;
        }
        DriNodePair driNodePair = this.findDriOtherPair(driNodes, iNetElement);
        return driNodePair.getSecondary();
    }

    protected INetElement findDriS2givenP2(INetElement iNetElement) {
        DriNodes driNodes = this.findDriNodes(iNetElement);
        if (driNodes.getDriType() != 1) {
            return null;
        }
        return this.findDriPeer(driNodes, iNetElement);
    }

    protected INetElement findDriS(INetElement iNetElement) {
        DriNodes driNodes = this.findDriNodes(iNetElement);
        return this.findDriPeer(driNodes, iNetElement);
    }

    protected INetElement findDriPgivenS(INetElement iNetElement) {
        DriNodes driNodes = this.findDriNodes(iNetElement);
        return this.findDriPeer(driNodes, iNetElement);
    }

    protected INetElement convertPathSegmentEndPoint(INetElement iNetElement) {
        INetElement iNetElement2 = this.findDriPeer(iNetElement);
        if (iNetElement2 != null) {
            return iNetElement2;
        }
        return iNetElement;
    }

    public String prettyString() {
        Object object;
        Iterator iterator;
        String string = "\n\t\tMember Preferences: ";
        string = string + "\n\t\t\tDirection: ";
        switch (this.getDirectionality()) {
            case 2: {
                string = string + "Unidirectional";
                break;
            }
            case 3: {
                string = string + "Bidirectional";
                break;
            }
            default: {
                string = string + "Unknown";
            }
        }
        string = string + "\n\t\t\tProtection Preference: ";
        block4 : switch (this.getPathProtection()) {
            case 3: {
                string = string + "Fully Unprotected";
                break;
            }
            case 4: {
                string = string + "PCA";
                break;
            }
            case 2: {
                string = string + "Unprotected";
                break;
            }
            case 6: {
                string = string + "Line Protected";
                break;
            }
            case 7: {
                string = string + "Endpoints Line Protcted";
                break;
            }
            case 5: {
                string = string + "DRI - Protected";
                break;
            }
            case 8: {
                string = string + "No specific Protection";
                break;
            }
            case 0: 
            case 1: {
                string = string + "Protected";
                string = string + "\n\t\t\tDiversity: ";
                switch (this.getDiversityOption()) {
                    case 1: {
                        string = string + "Node Diversity Required";
                        break block4;
                    }
                    case 3: {
                        string = string + "Only Link Diversity Required";
                        break block4;
                    }
                    case 2: {
                        string = string + "Node Diversity Desired";
                        break block4;
                    }
                }
                string = string + "Unknown";
                break;
            }
            default: {
                string = string + "Unknown";
            }
        }
        string = string + "\n\t\t\tOptimization Criteria: ";
        switch (this.getPrimaryOptimizationCriterion()) {
            case 1: {
                string = string + "Cost (Or Distance) ";
                break;
            }
            case 2: {
                string = string + "Protection Quality ";
                break;
            }
            case 3: {
                string = string + "Load Balance ";
                break;
            }
            default: {
                string = string + "Unknown ";
            }
        }
        string = string + "\n\t\t\tDiverse SRLG check: ";
        string = this.getDiverseSrlg() ? string + "REQUIRED " : string + "NOT_REQUIRED";
        if (this.sameStsRouting()) {
            string = string + "\n\tSameStsRouting: ";
            string = string + "Yes";
            if (this.allStsToUse().size() > 0) {
                string = string + "\n\t\t\tSTS to use: ";
                iterator = this.allStsToUse().iterator();
                while (iterator.hasNext()) {
                    object = (Integer)iterator.next();
                    string = string + "\n\t\t\t" + (Integer)object;
                }
            }
        }
        if (this.getRequiredLinks().size() > 0) {
            string = string + "\n\t\t\tRequired Links: ";
            iterator = this.getRequiredLinks().iterator();
            while (iterator.hasNext()) {
                object = (INetLink)iterator.next();
                string = string + "\n\t\t\t" + object.prettyString();
            }
        }
        if (this.getRequiredNodes().size() > 0) {
            string = string + "\n\t\t\tRequired Nodes: ";
            iterator = this.getRequiredNodes().iterator();
            while (iterator.hasNext()) {
                object = (INetElement)iterator.next();
                string = string + " " + object.prettyString();
            }
        }
        if (this.getExcludeSrgs().size() > 0) {
            string = string + "\n\t\t\tExclude SRGs: ";
            iterator = this.getExcludeSrgs().iterator();
            while (iterator.hasNext()) {
                object = (ISrg)iterator.next();
                string = string + "\n\t\t\t" + object.prettyString();
            }
        }
        if (this.getTsiConstraints().size() > 0) {
            string = string + "\n\t\t\tTSI Constraints: ";
            iterator = this.getTsiConstraints().iterator();
            while (iterator.hasNext()) {
                object = (TsiConstraint)iterator.next();
                string = string + "\n\t\t\t" + ((TsiConstraint)object).prettyString();
            }
        }
        if (this.getPreferredLinks().size() > 0) {
            string = string + "\n\t\t\tPreferred Links: ";
            iterator = this.getPreferredLinks().iterator();
            while (iterator.hasNext()) {
                object = (INetLink)iterator.next();
                string = string + "\n\t\t\t" + object.prettyString();
            }
        }
        if (this.getRequiredSpans().size() > 0) {
            string = string + "\n\t\t\tRequired Spans: ";
            iterator = this.getRequiredSpans().iterator();
            while (iterator.hasNext()) {
                object = (INetLinkSpan)iterator.next();
                string = string + "\n\t\t\t" + object.prettyString();
            }
        }
        if (this.getExcludeSpans().size() > 0) {
            string = string + "\n\t\t\tExclude Spans: ";
            iterator = this.getExcludeSpans().iterator();
            while (iterator.hasNext()) {
                object = (INetLinkSpan)iterator.next();
                string = string + "\n\t\t\t" + object.prettyString();
            }
        }
        if (this.getDriNodePrefs().size() > 0) {
            string = string + "\n\t\t\tDriNode prefs: ";
            iterator = this.getDriNodePrefs().iterator();
            while (iterator.hasNext()) {
                object = (DriNodes)iterator.next();
                string = string + "\n\t\t\t" + ((DriNodes)object).prettyString();
            }
        }
        return string;
    }
}

