/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.DebugLog;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.util.HoLoComparator;
import cerent.util.HoLoNum;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import cerent.util.ILoNum;

public class NetLinkSpan
implements INetLinkSpan {
    private static final HoLoComparator holoComp = HoLoComparator.instance();
    private INetLink link;
    private INetLink reverseLink;
    private boolean omni = false;
    private boolean secondaryCircuit = false;
    private IHoNum srcHoNum;
    private IHoNum dstHoNum;
    private ILoNum iLoNum;
    private boolean sourceRing = true;

    public NetLinkSpan(INetLink iNetLink, INetLink iNetLink2) {
        this.link = iNetLink;
        this.reverseLink = iNetLink2;
        this.omni = false;
        this.sourceRing = true;
    }

    public NetLinkSpan(INetLink iNetLink, INetLink iNetLink2, IHoNum iHoNum, IHoNum iHoNum2, ILoNum iLoNum) {
        this.link = iNetLink;
        this.reverseLink = iNetLink2;
        this.srcHoNum = iHoNum;
        this.dstHoNum = iHoNum2;
        this.iLoNum = iLoNum;
    }

    public NetLinkSpan(INetLink iNetLink, INetLink iNetLink2, ILabel iLabel, ILabel iLabel2) {
        this.link = iNetLink;
        this.reverseLink = iNetLink2;
        if (iLabel instanceof IHoNum) {
            IHoNum iHoNum = (IHoNum)iLabel;
            IHoNum iHoNum2 = (IHoNum)iLabel2;
            this.srcHoNum = iHoNum;
            this.dstHoNum = iHoNum2;
            this.iLoNum = null;
        } else if (iLabel instanceof IHoLoNum) {
            IHoLoNum iHoLoNum = (IHoLoNum)iLabel;
            IHoLoNum iHoLoNum2 = (IHoLoNum)iLabel2;
            this.srcHoNum = iHoLoNum.getHoNum();
            this.dstHoNum = iHoLoNum2.getHoNum();
            this.iLoNum = iHoLoNum.getLoNum();
        } else {
            this.debug("Warning: create NetLinkspan from label: unknown label type");
        }
    }

    public NetLinkSpan(INetLink iNetLink, ILabel iLabel, ILabel iLabel2) {
        this(iNetLink, null, iLabel, iLabel2);
    }

    public String prettyString() {
        return this.link.prettyString() + (this.iLoNum != null ? " srcHo " + this.srcHoNum + " : dsHo " + this.dstHoNum + " : Lo " + this.iLoNum : " Ho " + this.srcHoNum + (this.getOmni() ? " (OMNI) " : ""));
    }

    public INetLink getLink() {
        return this.link;
    }

    public INetElement getSrc() {
        return this.getLink().getSrc();
    }

    public INetElement getDst() {
        return this.getLink().getDst();
    }

    public INetLink getReverseLink() {
        return this.reverseLink;
    }

    public ILabel getSrcLabel() {
        if (this.iLoNum != null) {
            HoLoNum hoLoNum = new HoLoNum(this.getSrcHoNum(), this.getLoNum());
            return hoLoNum;
        }
        return this.getSrcHoNum();
    }

    public ILabel getDstLabel() {
        if (this.iLoNum != null) {
            HoLoNum hoLoNum = new HoLoNum(this.getDstHoNum(), this.getLoNum());
            return hoLoNum;
        }
        return this.getDstHoNum();
    }

    public ILoNum getLoNum() {
        return this.iLoNum;
    }

    public IHoNum getSrcHoNum() {
        return this.srcHoNum;
    }

    public IHoNum getDstHoNum() {
        return this.dstHoNum;
    }

    public boolean getOmni() {
        return this.omni;
    }

    public void setOmni(boolean bl) {
        this.omni = bl;
    }

    public boolean isSecondaryCircuit() {
        return this.secondaryCircuit;
    }

    public void setSecondaryCircuit(boolean bl) {
        this.secondaryCircuit = bl;
    }

    public boolean getSourceRing() {
        return this.sourceRing;
    }

    public void setSourceRing(boolean bl) {
        this.sourceRing = bl;
    }

    public boolean isRelevantLink(INetLink iNetLink) {
        return ((Object)this.link).equals(iNetLink);
    }

    public eSpanDirection biSpanDir(INetElement iNetElement) {
        if (this.omni) {
            return eSpanDirection.BIDIRECTIONAL;
        }
        if (iNetElement == this.link.getSrc()) {
            return eSpanDirection.ORIGINATING;
        }
        if (iNetElement == this.link.getDst()) {
            return eSpanDirection.TERMINATING;
        }
        return eSpanDirection.BIDIRECTIONAL;
    }

    private void debug(String string) {
        DebugLog.instance().info(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof INetLinkSpan)) {
            return false;
        }
        INetLinkSpan iNetLinkSpan = (INetLinkSpan)object;
        if (!((Object)iNetLinkSpan.getLink()).equals(this.link)) {
            return false;
        }
        if (iNetLinkSpan.getReverseLink() != null ? !((Object)iNetLinkSpan.getReverseLink()).equals(this.reverseLink) : this.reverseLink != null) {
            return false;
        }
        if (!holoComp.isEqual(iNetLinkSpan.getSrcHoNum(), this.getSrcHoNum())) {
            return false;
        }
        if (!holoComp.isEqual(iNetLinkSpan.getDstHoNum(), this.getDstHoNum())) {
            return false;
        }
        return holoComp.isEqual(iNetLinkSpan.getLoNum(), this.getLoNum());
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.link.hashCode();
        n = 37 * n + (this.reverseLink == null ? 0 : this.reverseLink.hashCode());
        n = 37 * n + (this.srcHoNum == null ? 0 : this.srcHoNum.hashCode());
        n = 37 * n + (this.dstHoNum == null ? 0 : this.dstHoNum.hashCode());
        n = 37 * n + (this.iLoNum == null ? 0 : this.iLoNum.hashCode());
        return n;
    }
}

