/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.IMetric;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;

public class PathMetric
implements IMetric {
    private RoutePrefs prefs;
    private int cost;

    public PathMetric(RoutePrefs routePrefs) {
        this.prefs = routePrefs;
        this.cost = 0;
    }

    public int getCost() {
        return this.cost;
    }

    public void accumulate(IMetric iMetric, SptLink sptLink, RoutePrefs routePrefs) {
        int n = 1;
        if (!routePrefs.getPreferredLinks().contains(sptLink.getLink())) {
            n = sptLink.getLink().getCost();
        }
        PathMetric pathMetric = (PathMetric)iMetric;
        this.cost = pathMetric.getCost() + n;
    }

    public int compareTo(Object object) {
        PathMetric pathMetric = (PathMetric)object;
        return this.getCost() - pathMetric.getCost();
    }

    public boolean betterThan(Object object) {
        return this.compareTo(object) <= 0;
    }

    public String prettyString() {
        String string = " Path : " + this.getCost();
        return string;
    }
}

