/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.model.Feature;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.AutoRouteRequestor;
import cerent.cms.route.CircuitPath;
import cerent.cms.route.DropPrefs;
import cerent.cms.route.DualEndProtectPathFilter;
import cerent.cms.route.IEndProtectPathFilter;
import cerent.cms.route.IGranularityFilter;
import cerent.cms.route.IPathFilter;
import cerent.cms.route.ISrg;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NoRoute;
import cerent.cms.route.NodeSrg;
import cerent.cms.route.PathFilter;
import cerent.cms.route.PortSrg;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SingleEndProtectPathFilter;
import cerent.cms.route.SlotSrg;
import cerent.cms.route.SptLink;
import cerent.cms.route.SptNode;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.route.xNoAlternatePath;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.util.DetailedLog;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class ProtectedPathFilter
extends PathFilter {
    IEndProtectPathFilter endFilter;
    boolean isOchTrail = false;

    public ProtectedPathFilter(RoutePrefs routePrefs, IGranularityFilter iGranularityFilter) {
        super(routePrefs, iGranularityFilter);
        if (routePrefs.getSecSrc() != null && routePrefs.getSecSrc() != routePrefs.getSrc() && routePrefs.getActiveMember().findDriNodeType(routePrefs.getSrc()) == 1 || routePrefs.getSecDst() != null && routePrefs.getSecDst() != routePrefs.getDst() && routePrefs.getActiveMember().findDriNodeType(routePrefs.getDst()) == 1) {
            this.endFilter = new DualEndProtectPathFilter(routePrefs, this);
            routePrefs.getLog().getDebugLog().info("ProtectedPathFilter: DualEndProtectPathFilter Created");
        } else {
            this.endFilter = new SingleEndProtectPathFilter(routePrefs, this);
            routePrefs.getLog().getDebugLog().info("ProtectedPathFilter: SingleEndProtectPathFilter Created");
        }
    }

    public CircuitPath getCircuitPath() throws NoRoute {
        CircuitPath circuitPath;
        try {
            this.prefs.getLog().getDebugLog().info(" =========Compute Primary Path Started============ ");
            circuitPath = super.getCircuitPath();
            this.prefs.getLog().getDebugLog().info(" =========Compute Primary Path Finished============ ");
        }
        catch (NoRoute noRoute) {
            this.endFilter.cleanup();
            if (noRoute.getDetailedLog() != null) {
                noRoute.getDetailedLog().setDesc("Primary path not found");
                throw new NoRoute("Primary path not found", noRoute.getDetailedLog());
            }
            throw noRoute;
        }
        this.endFilter.cleanup();
        try {
            this.prefs.getLog().getDebugLog().info(" =========Compute Alternate Path Started============ ");
            this.computeAlternatePaths(circuitPath);
            this.prefs.getLog().getDebugLog().info(" =========Compute Alternate Path Finished============ ");
        }
        catch (xNoAlternatePath xNoAlternatePath2) {
            this.prefs.getLog().getDebugLog().info("No Alternate Path exists for one of the segments");
            if (xNoAlternatePath2.getDetailedLog() != null) {
                xNoAlternatePath2.getDetailedLog().setDesc("Alternate path not found: " + xNoAlternatePath2.getMessage());
            }
            throw new NoRoute(xNoAlternatePath2.getMessage(), xNoAlternatePath2.getDetailedLog());
        }
        this.prefs.getLog().getDebugLog().info("Complete Circuit Path: ");
        this.prefs.getLog().getDebugLog().info(circuitPath.prettyString());
        return circuitPath;
    }

    public boolean isUsable(SptLink sptLink) throws xLinkNotUsable {
        if (sptLink.getLink().isPca()) {
            throw new xLinkNotUsable("ProtectedPathFilter: PCA links are not considered");
        }
        if (sptLink.getLink().getLinkType() == 5) {
            throw new xLinkNotUsable("ProtectedPathFilter: UPSR Loop links are not considered");
        }
        if (!sptLink.getLink().isFullyUnprotected() && !sptLink.getLink().isFullyProtected()) {
            throw new xLinkNotUsable("ProtectedPathFilter: Link is neither fully protected nor fully unprotected");
        }
        this.isPathProtectable(sptLink);
        return super.isUsable(sptLink);
    }

    private boolean isPathProtectable(SptLink sptLink) throws xLinkNotUsable {
        if (this.isOchTrail) {
            return true;
        }
        SptNode sptNode = sptLink.getDstNode();
        if (sptNode == null) {
            throw new xLinkNotUsable("SptLink's destination node is not set");
        }
        LinkedList linkedList = sptNode.getNetLinks();
        this.prefs.getLog().getDebugLog().info("isPathProtectable: Checking for Alternate Path exists for one of the segments: " + linkedList.size());
        try {
            this.endFilter.alternatePaths(null, linkedList);
        }
        catch (xNoAlternatePath xNoAlternatePath2) {
            throw new xLinkNotUsable(xNoAlternatePath2.getString());
        }
        return true;
    }

    public boolean areProtectionTypesSimilar(INetLink iNetLink, INetLink iNetLink2) {
        if (iNetLink.isProtected() && iNetLink2.isProtected()) {
            return true;
        }
        if (iNetLink.isFullyUnprotected() && iNetLink2.isFullyUnprotected()) {
            return true;
        }
        return iNetLink.isPca() && iNetLink2.isPca();
    }

    protected boolean computeAlternatePaths(CircuitPath circuitPath) throws xNoAlternatePath {
        LinkedList linkedList = circuitPath.getPathLinks();
        return this.endFilter.alternatePaths(circuitPath, linkedList);
    }

    protected LinkedList getPrimaryPathSrlgs(LinkedList linkedList) {
        LinkedList linkedList2 = new LinkedList();
        try {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                LinkedList linkedList3 = iNetLink.getSrlgList();
                if (linkedList3.size() == 0) continue;
                linkedList2.addAll(iNetLink.getSrlgList());
            }
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            this.prefs.getLog().getDebugLog().info("getPrimaryPathSrlgs:exception = " + sanityCheckFailed.getMessage());
        }
        return linkedList2;
    }

    protected CircuitPath computeAlternatePath(LinkedList linkedList, LinkedList linkedList2, INetElement iNetElement, INetElement iNetElement2, int n, IPathFilter iPathFilter, Set set) throws xNoAlternatePath {
        Object object;
        Object object2;
        CircuitPath circuitPath = null;
        RoutePrefs routePrefs = new RoutePrefs();
        DropPrefs dropPrefs = routePrefs.getActiveDropPrefs();
        MemberGroupPrefs memberGroupPrefs = dropPrefs.getActiveMemberGroupPrefs();
        MemberPrefs memberPrefs = memberGroupPrefs.getMemberPrefs();
        routePrefs.setSrc(iNetElement);
        routePrefs.setCircuitType(this.prefs.getCircuitType());
        routePrefs.setTsi(this.prefs.Tsi());
        routePrefs.setAdjacencyExtractor(this.prefs.getAdjacencyExtractor());
        routePrefs.setParentFilter(iPathFilter);
        this.isOchTrail = this.prefs.isOchTrailCircuit();
        routePrefs.setcktSrcEntityIndex(this.prefs.getcktSrcEntityIndex());
        routePrefs.setcktDstEntityIndex(this.prefs.getcktDstEntityIndex());
        dropPrefs.setDrop(iNetElement2);
        dropPrefs.setCommonFiber(this.prefs.getActiveDropPrefs().isCommonFiber());
        memberGroupPrefs.setMemberCount(this.prefs.getMemberCount());
        memberGroupPrefs.setMemberBandwidth(this.prefs.getBandwidth());
        memberPrefs.setPrimaryOptimizationCriterion(this.prefs.getPrimaryOptimizationCriterion());
        memberPrefs.setPathProtection(n);
        memberPrefs.setDirectionality(this.prefs.getDirectionality());
        memberPrefs.setDiversityOption(this.prefs.getDiversityOption());
        memberPrefs.addExcludeSpans(this.prefs.getExcludeSpans());
        memberPrefs.setDriNodePrefs(this.prefs.getDriNodePrefs());
        memberPrefs.setPreferredDriRings(this.prefs.getActiveMember().getPreferredDriRings());
        memberPrefs.setDiverseSrlg(this.prefs.getDiverseSrlg());
        HashSet hashSet = new HashSet(this.prefs.getExcludeSrgs());
        if (this.prefs.getDiverseSrlg()) {
            this.prefs.getLog().getDebugLog().info("computeAlternatePath: SRLG check required");
            if (linkedList2 != null) {
                hashSet.addAll(this.getPrimaryPathSrlgs(linkedList2));
            }
        }
        if (set != null) {
            this.prefs.getLog().getDebugLog().info("computeAlternatePath: Adding passed SRGs");
            hashSet.addAll(set);
        }
        HashSet<ISrg> hashSet2 = new HashSet<ISrg>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object2 = (ISrg)iterator.next();
            if (object2 instanceof NodeSrg && iNetElement2.equals(((NodeSrg)(object = (NodeSrg)object2)).getNe())) continue;
            hashSet2.add((ISrg)object2);
        }
        memberPrefs.setExcludeSrgs(new HashSet(hashSet2));
        memberPrefs.setSla(this.prefs.getSla());
        memberPrefs.setSameStsRouting(this.prefs.sameStsRouting());
        memberPrefs.addStsToUse(this.prefs.allStsToUse());
        object = this.prefs.getPreferredLinks().iterator();
        while (object.hasNext()) {
            object2 = (INetLink)object.next();
            if (linkedList.contains(object2)) continue;
            memberPrefs.addPreferredLink((INetLink)object2);
        }
        Set set2 = this.prefs.getDiversityOption() == 1 || this.prefs.getDiversityOption() == 2 ? (this.isOchTrail ? this.buildOchTrailSrgList(linkedList, linkedList2, iNetElement, iNetElement2) : this.buildSrgList(linkedList, linkedList2, iNetElement, iNetElement2, true)) : (this.isOchTrail ? this.buildOchTrailSrgList(linkedList, linkedList2, iNetElement, iNetElement2) : this.buildSrgList(linkedList, linkedList2, iNetElement, iNetElement2, false));
        memberPrefs.addSrgs(set2);
        routePrefs.getLog().getDebugLog().beginIndent();
        try {
            AutoRouteRequestor autoRouteRequestor = new AutoRouteRequestor(routePrefs, true);
            circuitPath = autoRouteRequestor.getCircuitPath();
        }
        catch (NoRoute noRoute) {
            DetailedLog detailedLog = noRoute.getDetailedLog();
            if (this.prefs.getDiversityOption() == 2) {
                this.prefs.getLog().getDebugLog().info("computeAlternatePath: with Link Diverse only option");
                memberPrefs.setExcludeSrgs(new HashSet(hashSet2));
                set2 = this.isOchTrail ? this.buildOchTrailSrgList(linkedList, linkedList2, iNetElement, iNetElement2) : this.buildSrgList(linkedList, linkedList2, iNetElement, iNetElement2, false);
                memberPrefs.addSrgs(set2);
                try {
                    AutoRouteRequestor autoRouteRequestor = new AutoRouteRequestor(routePrefs, true);
                    circuitPath = autoRouteRequestor.getCircuitPath();
                    routePrefs.getLog().getDebugLog().endIndent();
                    return circuitPath;
                }
                catch (NoRoute noRoute2) {
                    detailedLog = noRoute2.getDetailedLog();
                }
            }
            routePrefs.getLog().getDebugLog().endIndent();
            throw new xNoAlternatePath("Alternate path  for segment originating at " + iNetElement.prettyString() + " terminating at " + iNetElement2.prettyString() + " is not available", detailedLog);
        }
        routePrefs.getLog().getDebugLog().endIndent();
        return circuitPath;
    }

    protected LinkedList computeCircuitPathSegments(LinkedList linkedList, int n) {
        return this.endFilter.computeCircuitPathSegments(linkedList, n);
    }

    private Set buildSrgList(LinkedList linkedList, LinkedList linkedList2, INetElement iNetElement, INetElement iNetElement2, boolean bl) {
        HashSet<ISrg> hashSet = new HashSet<ISrg>();
        INetLink iNetLink = null;
        if (linkedList != null && linkedList.size() != 0) {
            iNetLink = (INetLink)linkedList.getLast();
        }
        INetLink iNetLink2 = null;
        if (linkedList2 != null && linkedList2.size() != 0) {
            iNetLink2 = (INetLink)linkedList2.getLast();
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink3 = (INetLink)iterator.next();
            Iterator iterator2 = iNetLink3.getLinksList().iterator();
            while (iterator2.hasNext()) {
                INetLink iNetLink4 = (INetLink)iterator2.next();
                if (linkedList2 != null && linkedList2.contains(iNetLink3)) {
                    hashSet.add(new PortSrg(iNetLink4.getSrc(), iNetLink4.getSrcSlotNumber(), iNetLink4.getSrcPortNumber()));
                    hashSet.add(new PortSrg(iNetLink4.getDst(), iNetLink4.getDstSlotNumber(), iNetLink4.getDstPortNumber()));
                    if (!iNetLink4.getSrc().getNodeModel().provides(Feature.UPSR_SLOTDIV_NR)) {
                        hashSet.add(new SlotSrg(iNetLink4.getSrc(), iNetLink4.getSrcSlotNumber(), true));
                    }
                    if (!iNetLink4.getDst().getNodeModel().provides(Feature.UPSR_SLOTDIV_NR) && (!((Object)iNetLink2).equals(iNetLink) && ((Object)iNetLink4).equals(iNetLink2) || iNetLink4.getDst().equals(this.prefs.getDst()))) {
                        hashSet.add(new SlotSrg(iNetLink4.getDst(), iNetLink4.getDstSlotNumber(), false));
                    }
                }
                if (!bl && (linkedList2 == null || linkedList2.contains(iNetLink3))) continue;
                if (iNetLink4.getSrc() != iNetElement2 && iNetLink4.getSrc() != iNetElement) {
                    hashSet.add(new NodeSrg(iNetLink4.getSrc(), 3));
                }
                if (iNetLink4.getDst() == iNetElement || iNetLink4.getDst() == iNetElement2) continue;
                hashSet.add(new NodeSrg(iNetLink4.getDst(), 3));
            }
        }
        return hashSet;
    }

    private Set buildOchTrailSrgList(LinkedList linkedList, LinkedList linkedList2, INetElement iNetElement, INetElement iNetElement2) {
        HashSet<PortSrg> hashSet = new HashSet<PortSrg>();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (iNetLink instanceof OchTrailTunnelNetLink) {
                if (linkedList2 == null || !linkedList2.contains(iNetLink)) continue;
                hashSet.add(new PortSrg(iNetLink.getSrc(), iNetLink.getSrcSlotNumber(), iNetLink.getSrcPortNumber()));
                hashSet.add(new PortSrg(iNetLink.getDst(), iNetLink.getDstSlotNumber(), iNetLink.getDstPortNumber()));
                continue;
            }
            Iterator iterator2 = iNetLink.getLinksList().iterator();
            while (iterator2.hasNext()) {
                INetLink iNetLink2 = (INetLink)iterator2.next();
                if (linkedList2 == null || !linkedList2.contains(iNetLink)) continue;
                hashSet.add(new PortSrg(iNetLink2.getSrc(), iNetLink2.getSrcSlotNumber(), iNetLink2.getSrcPortNumber()));
                hashSet.add(new PortSrg(iNetLink2.getDst(), iNetLink2.getDstSlotNumber(), iNetLink2.getDstPortNumber()));
            }
        }
        return hashSet;
    }
}

