/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.route.AdjacencyExtractor;
import cerent.cms.route.DebugLog;
import cerent.cms.route.DriNodes;
import cerent.cms.route.DropPrefs;
import cerent.cms.route.IPathFilter;
import cerent.cms.route.InvalidPreferences;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.RouteException;
import cerent.cms.route.RouteLog;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.topo.NetLinkComparator;
import cerent.cms.topo.Network;
import cerent.cms.ui.CircuitOptDir;
import cerent.util.DetailedLog;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RoutePrefs {
    private INetElement source;
    private INetElement secondarySource;
    private int circuitType;
    private boolean optimalPath;
    private boolean isTunnel;
    private int cktOptDirection = -1;
    private int cktOptChannel;
    private int cktSrcEntityIndex;
    private int cktSecSrcEntityIndex;
    private int cktDstEntityIndex;
    private int cktSecDstEntityIndex;
    private Set adjNodes;
    private Set adjLinks;
    private boolean isLap;
    private INetElement groomingEnd;
    private DropPrefs fwdDropPrefs;
    private DropPrefs revDropPrefs;
    private boolean tsi;
    private boolean lineProtInPath;
    private DropPrefs activeDrop;
    private RouteLog routeLog;
    private Set ignoredExceptions;
    private AdjacencyExtractor adj;
    private boolean tunnelsAllowed;
    private boolean allTypesLabels;
    private boolean checkSwitchingGranularity;
    private boolean forOhCircuit;
    IPathFilter parentFilter;

    public RoutePrefs() {
        this(true);
    }

    public RoutePrefs(boolean bl) {
        this.optimalPath = true;
        if (bl) {
            this.fwdDropPrefs = new DropPrefs(this, false);
        }
        this.revDropPrefs = null;
        this.isTunnel = false;
        this.isLap = false;
        this.groomingEnd = null;
        this.adjNodes = new TreeSet(new NetElemComparator());
        this.adjLinks = new TreeSet(new NetLinkComparator());
        this.tsi = false;
        this.lineProtInPath = false;
        this.checkSwitchingGranularity = true;
        this.tunnelsAllowed = true;
        this.allTypesLabels = false;
        this.parentFilter = null;
        this.forOhCircuit = false;
        this.activeDrop = this.fwdDropPrefs;
        this.routeLog = new RouteLog(new DetailedLog(1, "Path Computation Failure Reasons:"), DebugLog.instance());
        this.adj = null;
    }

    public RoutePrefs(RoutePrefs routePrefs) {
        this.source = routePrefs.source;
        this.secondarySource = routePrefs.secondarySource;
        this.circuitType = routePrefs.circuitType;
        this.optimalPath = routePrefs.optimalPath;
        this.fwdDropPrefs = new DropPrefs(routePrefs.fwdDropPrefs, this);
        this.revDropPrefs = null;
        this.isTunnel = routePrefs.isTunnel;
        this.isLap = routePrefs.isLap;
        this.groomingEnd = routePrefs.groomingEnd;
        this.tsi = routePrefs.tsi;
        this.forOhCircuit = routePrefs.forOhCircuit;
        this.adjNodes = new TreeSet(new NetElemComparator());
        this.adjLinks = new TreeSet(new NetLinkComparator());
        this.adjNodes.addAll(routePrefs.getAdjacencyNodes());
        this.adjLinks.addAll(routePrefs.getAdjacencyLinks());
        this.lineProtInPath = routePrefs.lineProtInPath;
        this.allTypesLabels = routePrefs.allTypesLabels;
        this.checkSwitchingGranularity = routePrefs.checkSwitchingGranularity;
        this.tunnelsAllowed = routePrefs.tunnelsAllowed;
        this.parentFilter = routePrefs.getParentFilter();
        this.activeDrop = this.fwdDropPrefs;
        this.routeLog = new RouteLog(new DetailedLog(1, "Path Computation Failure Reasons:"), DebugLog.instance());
        this.adj = routePrefs.adj;
        this.cktOptDirection = routePrefs.cktOptDirection;
        this.cktOptChannel = routePrefs.cktOptChannel;
        this.cktSrcEntityIndex = routePrefs.cktSrcEntityIndex;
        this.cktSecSrcEntityIndex = routePrefs.cktSecSrcEntityIndex;
        this.cktDstEntityIndex = routePrefs.cktDstEntityIndex;
        this.cktSecDstEntityIndex = routePrefs.cktSecDstEntityIndex;
    }

    public static RoutePrefs getOchncRoutePrefs(int n, INetElement iNetElement, int n2, int n3, int n4, int n5) {
        RoutePrefs routePrefs = RoutePrefs.getOchncRoutePrefs(n, iNetElement, n2, n3);
        routePrefs.setDirectionality(3);
        routePrefs.setcktSecSrcEntityIndex(n4);
        routePrefs.setcktSecDstEntityIndex(n5);
        return routePrefs;
    }

    public static RoutePrefs getOchncRoutePrefs(int n, INetElement iNetElement, int n2, int n3) {
        RoutePrefs routePrefs = new RoutePrefs();
        routePrefs.setSrc(iNetElement);
        routePrefs.setPathProt(2);
        routePrefs.setDiversityOption(1);
        routePrefs.setDirectionality(2);
        routePrefs.setPcaPref(false);
        routePrefs.setDri(false);
        routePrefs.setcktOptChannel(n);
        routePrefs.setcktSrcEntityIndex(n2);
        routePrefs.setcktDstEntityIndex(n3);
        return routePrefs;
    }

    public static RoutePrefs getOchncRoutePrefs(int n, int n2) {
        RoutePrefs routePrefs = new RoutePrefs();
        routePrefs.setPathProt(2);
        routePrefs.setDiversityOption(1);
        routePrefs.setPcaPref(false);
        routePrefs.setDri(false);
        routePrefs.setcktOptDir(n2);
        routePrefs.setcktOptChannel(n);
        return routePrefs;
    }

    public RoutePrefs getReversePrefs() {
        RoutePrefs routePrefs = new RoutePrefs(this);
        if (this.getOptDirRoute()) {
            routePrefs.setcktOptDir(CircuitOptDir.getOppositeCktOptDir(this.getcktOptDir()));
        }
        if (this.getTunnel()) {
            routePrefs.setSrc(this.getDst());
            routePrefs.setDst(this.getSrc());
            routePrefs.setcktSrcEntityIndex(this.getcktDstEntityIndex());
            routePrefs.setcktDstEntityIndex(this.getcktSrcEntityIndex());
        } else {
            routePrefs.setSrc(this.getSecSrc());
            routePrefs.setDst(this.getSecDst());
            routePrefs.setcktSrcEntityIndex(this.getcktSecSrcEntityIndex());
            routePrefs.setcktDstEntityIndex(this.getcktSecDstEntityIndex());
        }
        routePrefs.setDirectionality(2);
        routePrefs.setcktSecSrcEntityIndex(-1);
        routePrefs.setcktSecDstEntityIndex(-1);
        routePrefs.setSecSrc(null);
        routePrefs.setSecDst(null);
        return routePrefs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addFirstDwdmLink() {
        IEntityModel iEntityModel;
        DebugLog debugLog = this.getLog().getDebugLog();
        INodeModel iNodeModel = this.getSrc().getNodeModel();
        IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
        if (this.getTunnel()) {
            INetLink iNetLink = Network.instance().findNetLinkFromSource(false, this.getSrc(), this.getcktSrcEntityIndex(), null);
            if (iNetLink != null) {
                this.addOchLinkToReqList(iNetLink);
                return;
            }
            try {
                IEntityModel iEntityModel2;
                IEntityModel[] iEntityModelArray;
                if (debugLog.on()) {
                    debugLog.println("Cannot find first link for source " + this.getSrc().getName() + ", port " + Integer.toHexString(this.getcktSrcEntityIndex()) + " Try to navigate up till the OTS line port");
                }
                if ((iEntityModelArray = OchTrailHelper.getColocatedOchPorts(iEntityModel2 = iEntityTableModel.getEntityModelByIndex(this.getcktSrcEntityIndex()))).length != 0) {
                    IEntityModel iEntityModel3 = OchPortsHelper.getOutLinePort(this.getcktOptChannel(), iEntityModelArray[0]);
                    iNetLink = Network.instance().findNetLinkFromSource(false, this.getSrc(), iEntityModel3.getEntityIndex(), null);
                    if (iNetLink != null) {
                        this.addOchLinkToReqList(iNetLink);
                        return;
                    } else {
                        if (!debugLog.on()) return;
                        debugLog.println("Cannot find first link for source " + this.getSrc().getName() + ", port " + Integer.toHexString(this.getcktSrcEntityIndex()));
                    }
                    return;
                }
                if (!debugLog.on()) return;
                debugLog.println("Cannot find first link for source " + this.getSrc().getName() + ", port " + Integer.toHexString(this.getcktSrcEntityIndex()));
                return;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                if (!debugLog.on()) return;
                debugLog.println("Cannot add first OTS link: " + (Object)((Object)abstractCmsNoSuchEntityException));
            }
            return;
        }
        try {
            iEntityModel = iEntityTableModel.getEntityModelByIndex(this.getcktSrcEntityIndex());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            if (!debugLog.on()) return;
            debugLog.println("Cannot add first OTS link: " + (Object)((Object)abstractCmsNoSuchEntityException));
            return;
        }
        IEntityModel iEntityModel4 = OchPortsHelper.getOutLinePort(this.getcktOptChannel(), iEntityModel);
        INetLink iNetLink = Network.instance().findNetLinkFromSource(false, this.getSrc(), iEntityModel4.getEntityIndex(), null);
        if (iNetLink != null) {
            this.addOchLinkToReqList(iNetLink);
            return;
        } else {
            if (!debugLog.on()) return;
            debugLog.println("Cannot find first link for source " + this.getSrc().getName() + ", port " + Integer.toHexString(this.getcktSrcEntityIndex()));
        }
    }

    private void addOchLinkToReqList(INetLink iNetLink) {
        block3: {
            DebugLog debugLog = this.getLog().getDebugLog();
            if (debugLog.on()) {
                debugLog.println("Adding first required OTS link: " + iNetLink.prettyString());
            }
            LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
            linkedList.add(iNetLink);
            try {
                this.setReqEntityList(linkedList);
            }
            catch (ObjDuplicate objDuplicate) {
                if (!debugLog.on()) break block3;
                debugLog.println("First link is already in required links .... Should never happen!");
            }
        }
    }

    public void setSrc(INetElement iNetElement) {
        this.source = iNetElement;
    }

    public INetElement getSrc() {
        return this.source;
    }

    public void setDiverseSrlg(boolean bl) {
        this.getActiveMember().setDiverseSrlg(bl);
    }

    public boolean getDiverseSrlg() {
        return this.getActiveMember().getDiverseSrlg();
    }

    public List getDriNodePrefs() {
        return this.getActiveMember().getDriNodePrefs();
    }

    public void addDriNodes(DriNodes driNodes) {
        this.getActiveMember().addDriNodes(driNodes);
    }

    public void clearDriNodePrefs() {
        this.getActiveMember().clearDriNodePrefs();
    }

    public void setSecSrc(INetElement iNetElement) {
        this.secondarySource = iNetElement;
    }

    public INetElement getSecSrc() {
        return this.secondarySource;
    }

    public void setDirectionality(int n) {
        this.getActiveMember().setDirectionality(n);
    }

    public void setDir(int n) {
        this.getActiveMember().setDir(n);
    }

    public int getDirectionality() {
        return this.getActiveMember().getDirectionality();
    }

    public void setAllTypesLabels(boolean bl) {
        this.allTypesLabels = bl;
    }

    public boolean getAllTypesLabels() {
        return this.allTypesLabels;
    }

    public boolean isUniDirectional() {
        int n = this.getDirectionality();
        return n == 2 || n == 1;
    }

    public void setFwdDropPrefs(DropPrefs dropPrefs) throws InvalidPreferences {
        if (this.fwdDropPrefs != null) {
            throw new InvalidPreferences();
        }
        this.fwdDropPrefs = dropPrefs;
    }

    public DropPrefs getFwdDropPrefs() {
        return this.fwdDropPrefs;
    }

    public DropPrefs getActiveDropPrefs() {
        return this.fwdDropPrefs;
    }

    protected void setActiveDropPrefs(DropPrefs dropPrefs) {
        this.activeDrop = dropPrefs;
    }

    public void setTunnel(boolean bl) {
        this.isTunnel = bl;
    }

    public boolean getTunnel() {
        return this.isTunnel;
    }

    public void setLap(boolean bl) {
        this.isLap = bl;
    }

    public boolean getLap() {
        return this.isLap;
    }

    public void setCheckSwitchingGranularity(boolean bl) {
        this.checkSwitchingGranularity = bl;
    }

    public boolean getCheckSwitchingGranularity() {
        return this.checkSwitchingGranularity;
    }

    public void setParentFilter(IPathFilter iPathFilter) {
        this.parentFilter = iPathFilter;
    }

    public IPathFilter getParentFilter() {
        return this.parentFilter;
    }

    public void setCircuitType(int n) {
        this.circuitType = n;
    }

    public int getCircuitType() {
        return this.circuitType;
    }

    public boolean isOchncCircuit() {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.circuitType);
        return iCircuitType.isOchncType();
    }

    public boolean isOchTrailCircuit() {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.circuitType);
        return iCircuitType.isOchccCircuitType();
    }

    public boolean isOchTrailTunnelCircuit() {
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)this.circuitType);
        return iCircuitType.isOchTrailTunnelCircuitType();
    }

    public boolean getOptDirRoute() {
        return this.cktOptDirection != -1;
    }

    public void setcktOptDir(int n) {
        this.cktOptDirection = n;
    }

    public int getcktOptDir() {
        return this.cktOptDirection;
    }

    public void setcktOptChannel(int n) {
        this.cktOptChannel = n;
    }

    public int getcktOptChannel() {
        return this.cktOptChannel;
    }

    public void setcktSrcEntityIndex(int n) {
        this.cktSrcEntityIndex = n;
    }

    public int getcktSrcEntityIndex() {
        return this.cktSrcEntityIndex;
    }

    public void setcktSecSrcEntityIndex(int n) {
        this.cktSecSrcEntityIndex = n;
    }

    public int getcktSecSrcEntityIndex() {
        return this.cktSecSrcEntityIndex;
    }

    public void setcktDstEntityIndex(int n) {
        this.cktDstEntityIndex = n;
    }

    public int getcktDstEntityIndex() {
        return this.cktDstEntityIndex;
    }

    public void setcktSecDstEntityIndex(int n) {
        this.cktSecDstEntityIndex = n;
    }

    public int getcktSecDstEntityIndex() {
        return this.cktSecDstEntityIndex;
    }

    protected void setTunnelsAllowed(boolean bl) {
        this.tunnelsAllowed = bl;
    }

    protected boolean getTunnelsAllowed() {
        return this.tunnelsAllowed;
    }

    public void setGroomingEnd(INetElement iNetElement) {
        this.groomingEnd = iNetElement;
    }

    public INetElement getGroomingEnd() {
        return this.groomingEnd;
    }

    public void setTsi(boolean bl) {
        this.tsi = bl;
    }

    public boolean Tsi() {
        return this.tsi;
    }

    public void setSameStsRouting(boolean bl) {
        this.getActiveMember().setSameStsRouting(bl);
    }

    public boolean sameStsRouting() {
        return this.getActiveMember().sameStsRouting();
    }

    public void setStsToUse(int n) {
        this.getActiveMember().setStsToUse(n);
    }

    public LinkedList allStsToUse() {
        return this.getActiveMember().allStsToUse();
    }

    public Set getAdjacencyNodes() {
        return this.adjNodes;
    }

    public void addAdjacencyNode(INetElement iNetElement) {
        this.adjNodes.add(iNetElement);
    }

    public void addAdjacencyNodes(Collection collection) {
        this.adjNodes.addAll(collection);
    }

    public void addAdjacencyLink(INetLink iNetLink) {
        this.adjLinks.add(iNetLink);
        INetLink iNetLink2 = Network.instance().findReverseLink(iNetLink);
        if (iNetLink2 != null) {
            this.adjLinks.add(iNetLink2);
        }
        this.adjNodes.add(iNetLink.getSrc());
        this.adjNodes.add(iNetLink.getDst());
    }

    public void addAdjacencyLinks(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addAdjacencyLink((INetLink)iterator.next());
        }
    }

    public Set getAdjacencyLinks() {
        return this.adjLinks;
    }

    public void setLineProtInPath(boolean bl) {
        this.lineProtInPath = bl;
    }

    public boolean getLineProtInPath() {
        return this.lineProtInPath;
    }

    public RouteLog getLog() {
        return this.routeLog;
    }

    public void setOptimalPath(boolean bl) {
        this.optimalPath = bl;
    }

    public boolean needOptimalPath() {
        return this.optimalPath;
    }

    public int getMemberCount() {
        return this.getActiveDropPrefs().getActiveMemberGroupPrefs().getMemberCount();
    }

    public int getCircuitSize() {
        return this.getBandwidth();
    }

    public int getBandwidth() {
        return this.getActiveDropPrefs().getActiveMemberGroupPrefs().getMemberBandwidth();
    }

    public void setCircuitSize(int n) {
        this.getActiveDropPrefs().getActiveMemberGroupPrefs().setMemberBandwidth(n);
    }

    public void setCircuitSizeToAllMembers(int n) {
        Iterator iterator = this.getActiveDropPrefs().getMemberGroupPrefs().iterator();
        while (iterator.hasNext()) {
            MemberGroupPrefs memberGroupPrefs = (MemberGroupPrefs)iterator.next();
            memberGroupPrefs.setMemberBandwidth(n);
        }
    }

    public void setPathOnly(boolean bl) {
        if (bl) {
            this.setCircuitSize(29);
        }
    }

    public boolean getPathOnly() {
        return this.getCircuitSize() == 29;
    }

    public INetElement getDst() {
        return this.getActiveDropPrefs().getDrop();
    }

    public void setDst(INetElement iNetElement) {
        this.getActiveDropPrefs().setDrop(iNetElement);
    }

    public INetElement getSecDst() {
        return this.getActiveDropPrefs().getSecondaryDrop();
    }

    public void setSecDst(INetElement iNetElement) {
        this.getActiveDropPrefs().setSecondaryDrop(iNetElement);
    }

    protected MemberPrefs getActiveMember() {
        return this.getActiveDropPrefs().getActiveMemberGroupPrefs().getActiveMember();
    }

    protected int getPrimaryOptimizationCriterion() {
        return this.getActiveMember().getPrimaryOptimizationCriterion();
    }

    protected int getPathProtection() {
        return this.getActiveMember().getPathProtection();
    }

    public int getDiversityOption() {
        return this.getActiveMember().getDiversityOption();
    }

    public void setDiversityOption(int n) {
        this.getActiveMember().setDiversityOption(n);
    }

    public void setDri(boolean bl) {
        if (bl) {
            this.setPathProt(5);
        }
    }

    public boolean getDri() {
        return this.getPathProt() == 5;
    }

    public LinkedList getRequiredLinks() {
        return this.getActiveMember().getRequiredLinks();
    }

    public LinkedList getRequiredNodes() {
        return this.getActiveMember().getRequiredNodes();
    }

    public Set getExcludeSrgs() {
        return this.getActiveMember().getExcludeSrgs();
    }

    public void setExcludeSrgs(Set set) {
        this.getActiveMember().setExcludeSrgs(set);
    }

    public Set getPreferredLinks() {
        return this.getActiveMember().getPreferredLinks();
    }

    public Set getRequiredSpans() {
        return this.getActiveMember().getRequiredSpans();
    }

    public void setRequiredSpans(Collection collection) {
        this.getActiveMember().addRequiredSpans(collection);
    }

    public LinkedList getExcludeSpans() {
        return this.getActiveMember().getExcludeSpans();
    }

    protected int getSla() {
        return this.getActiveMember().getSla();
    }

    public void setSla(int n) {
        this.getActiveMember().setSla(n);
    }

    public void setPcaPref(boolean bl) {
        if (bl) {
            this.setPathProt(4);
        }
    }

    public boolean getPcaPref() {
        return this.getPathProt() == 4;
    }

    public void setPathProt(int n) {
        this.getActiveMember().setPathProtection(n);
    }

    public int getPathProt() {
        return this.getActiveMember().getPathProtection();
    }

    public boolean isUnprotected() {
        return this.getPathProt() == 2;
    }

    public boolean isLoCircuit() {
        return CircuitType.getCircuitType((int)this.getCircuitType()).isLoCircuitType() || CircuitType.getCircuitType((int)this.getCircuitType()).isLoVcatCircuitType();
    }

    public boolean isFullyUnprotected() {
        return this.getPathProt() == 3;
    }

    public void setForOhCircuit() {
        this.forOhCircuit = true;
    }

    public boolean forOhCircuit() {
        return this.forOhCircuit;
    }

    public void setReqEntityList(Collection collection) throws ObjDuplicate {
        this.getActiveMember().setReqEntityList(collection);
    }

    public void addExcEntityList(Collection collection) throws ObjDuplicate {
        this.getActiveMember().addExcEntityList((LinkedList)collection);
    }

    public void setExcEntityList(Collection collection) throws ObjDuplicate {
        this.getActiveMember().setExcEntityList((LinkedList)collection);
    }

    public void addExcludeLinks(LinkedList linkedList) {
        this.getActiveMember().addExcludeLinks(linkedList);
    }

    public void addExcludeNodes(LinkedList linkedList) {
        this.getActiveMember().addExcludeNodes(linkedList);
    }

    public void addExcludeSrgs(Collection collection) {
        this.getActiveMember().addSrgs(collection);
    }

    public void addExcludeLink(INetLink iNetLink) {
        this.getActiveMember().addExcludeLink(iNetLink);
    }

    public void addExcludeNode(INetElement iNetElement) {
        this.getActiveMember().addExcludeNode(iNetElement);
    }

    protected void validateException(RouteException routeException) throws RouteException {
        if (this.ignoredExceptions.contains(new Integer(routeException.getExceptionNumber()))) {
            return;
        }
        throw routeException;
    }

    public INetLink getRequiredLink(INetElement iNetElement) {
        LinkedList linkedList = this.getActiveMember().getRequiredLinks();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (iNetLink.getSrc() != iNetElement) continue;
            return iNetLink;
        }
        return null;
    }

    public LinkedList getPreferredLinks(INetElement iNetElement) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Iterator iterator = this.getActiveMember().getPreferredLinks().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (iNetLink.getSrc() != iNetElement) continue;
            linkedList.add(iNetLink);
        }
        return linkedList;
    }

    public LinkedList getRequiredSpans(INetLink iNetLink) {
        LinkedList<NetLinkSpan> linkedList = new LinkedList<NetLinkSpan>();
        Iterator iterator = this.getActiveMember().getRequiredSpans().iterator();
        while (iterator.hasNext()) {
            NetLinkSpan netLinkSpan = (NetLinkSpan)iterator.next();
            if (netLinkSpan.getLink() != iNetLink) continue;
            linkedList.add(netLinkSpan);
        }
        return linkedList;
    }

    public Map getTsiConstraints(INetElement iNetElement, String string) {
        return this.getActiveMember().getTsiConstraints(iNetElement, string);
    }

    public void setAdjacencyExtractor(AdjacencyExtractor adjacencyExtractor) {
        this.adj = adjacencyExtractor;
    }

    public AdjacencyExtractor getAdjacencyExtractor() {
        return this.adj;
    }

    public boolean explorePathCharacterstics() {
        return this.getPathProt() == 1 || this.getPathProt() == 0;
    }

    public void isUsable(INetLink iNetLink) throws xLinkNotUsable {
        this.getActiveDropPrefs().isUsable(iNetLink);
    }

    public String prettyString() {
        String string = "\n\tRoute Preferences: ";
        string = string + "Source Node: ";
        if (this.getSrc() != null) {
            string = string + this.getSrc().prettyString();
        }
        if (this.getSecSrc() != null) {
            string = string + "\n\tSecondary Source Node: ";
            string = string + this.getSecSrc().prettyString();
        }
        string = string + "\n\tOptimal Path Required: ";
        string = this.optimalPath ? string + "Yes" : string + "No";
        if (this.isTunnel) {
            string = string + "\n\tIs this for Tunnel: ";
            string = string + "Yes";
        }
        if (this.isLap) {
            string = string + "\n\tIs this for LAP: ";
            string = string + "Yes";
        }
        if (this.tsi) {
            string = string + "\n\tTSI: ";
            string = string + "Yes";
        }
        if (this.forOhCircuit) {
            string = string + "\n\tIs this for Overhead Circuit: ";
            string = string + "Yes";
        }
        string = string + this.getActiveDropPrefs().prettyString();
        return string;
    }
}

