/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.model.CircuitSize;
import cerent.cms.route.CandidateList;
import cerent.cms.route.DebugLog;
import cerent.cms.route.IPathFilter;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RouteLog;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.SptList;
import cerent.cms.route.SptNode;
import cerent.cms.route.xAlreadyInCandidateList;
import cerent.cms.route.xCausesRouteLoop;
import cerent.cms.route.xLinkDoesNotMeetRequiredNLConstraint;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.util.DetailedLog;
import cerent.util.IHoNum;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Spt {
    private INetElement srcNe;
    private INetElement dstNe;
    private SptNode srcSptNode;
    private SptNode dstSptNode;
    private RoutePrefs prefs;
    private IPathFilter filter;
    private DetailedLog fLog;
    private DebugLog dLog;
    private RouteLog rLog;

    public Spt(RoutePrefs routePrefs, IPathFilter iPathFilter) {
        this(routePrefs);
        this.dstNe = routePrefs.getDst();
        this.filter = iPathFilter;
    }

    public Spt(RoutePrefs routePrefs) {
        this.prefs = routePrefs;
        this.srcNe = routePrefs.getSrc();
        this.dstNe = null;
        this.filter = null;
        this.dstSptNode = null;
        this.srcSptNode = null;
        this.rLog = routePrefs.getLog();
        this.fLog = this.rLog.getDetailedLog();
        this.dLog = this.rLog.getDebugLog();
    }

    protected void computeRoute() throws NoRoute {
        if (this.filter == null) {
            throw new NoRoute("No Filter specified");
        }
        try {
            this.srcSptNode = new SptNode(this.srcNe, null, this.prefs);
        }
        catch (xCausesRouteLoop xCausesRouteLoop2) {
            // empty catch block
        }
        LinkedList linkedList = this.prefs.getRequiredNodes();
        linkedList.remove(this.prefs.getSrc());
        if (linkedList.size() != 0 && !linkedList.contains(this.prefs.getDst())) {
            this.dLog.finest("Spt: Adding Destination: " + this.prefs.getDst().prettyString() + " to the required nodes");
            linkedList.add(this.prefs.getDst());
        }
        this.srcSptNode.setReqNodes(linkedList);
        this.computeRoute(this.srcSptNode);
    }

    protected LinkedList getPathLinks() {
        int n = this.prefs.getMemberCount();
        boolean bl = this.prefs.Tsi();
        this.dLog.finest(" getPathLinks in SPT: Number of members: " + n + " TSI : " + bl);
        LinkedList linkedList = new LinkedList();
        if (this.dstSptNode != null && this.dstSptNode.getBestLink() == null) {
            this.dLog.info(" getPathLinks: best link is null");
        }
        if (this.dstSptNode == null || this.dstSptNode.getBestLink() == null) {
            this.dLog.info(" getPathLinks: Destination is not computed or the best link does not exist");
            return linkedList;
        }
        this.dLog.info("getPathLinks in SPT: ComputeLabels");
        this.dstSptNode.getBestLink().computeLabels(this.prefs);
        linkedList.addAll(this.dstSptNode.getAllLinks());
        this.dLog.info("getPathLinks in SPT: Number of Path Links " + linkedList.size());
        return linkedList;
    }

    private void computeRoute(SptNode sptNode) throws NoRoute {
        Object object;
        this.dLog.info("computeRoute: Computing a path from " + sptNode.getNetElement().prettyString() + " to " + this.dstNe.prettyString());
        this.dLog.beginIndent();
        SptList sptList = new SptList(this.prefs);
        CandidateList candidateList = new CandidateList(this.prefs);
        LinkedList linkedList = new LinkedList();
        try {
            candidateList.add(sptNode);
        }
        catch (xAlreadyInCandidateList xAlreadyInCandidateList2) {
            // empty catch block
        }
        while (!candidateList.isEmpty()) {
            SptNode sptNode2 = candidateList.getBestCandidate();
            this.dLog.info("cr: Considering " + sptNode2.getNetElement().prettyString() + " for SPT");
            sptList.add(sptNode2);
            if (sptNode2.getNetElement() == this.dstNe) {
                this.dstSptNode = sptNode2;
                this.dLog.endIndent();
                this.dLog.info("computeRoute: Found the Shortest Path to final destination");
                return;
            }
            object = this.prefs.getAdjacencyExtractor().getAdjacencyList(sptNode2.getNetElement());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                this.dLog.info("computeRoute: Considering " + iNetLink.prettyString());
                SptNode sptNode3 = null;
                if (!this.isUsableForSameSts(iNetLink) || !this.isUsable(iNetLink, sptNode2, sptList, candidateList, sptNode3, linkedList)) continue;
                this.dLog.info("cr: Link is usable");
                if (this.prefs.needOptimalPath() || sptNode3.getNetElement() != this.dstNe) continue;
                this.dstSptNode = sptNode2;
                this.dLog.endIndent();
                this.dLog.info("computeRoute: Found a Path to final destination");
                return;
            }
        }
        this.dLog.info("computeRoute: Exhausted all nodes");
        this.dLog.endIndent();
        object = this.getSptFailureLog(sptNode, sptList, linkedList);
        throw new NoRoute("No Route found with given requirements", (DetailedLog)object);
    }

    private boolean isUsable(INetLink iNetLink, SptNode sptNode, SptList sptList, CandidateList candidateList, SptNode sptNode2, LinkedList linkedList) {
        SptNode sptNode3;
        SptLink sptLink = new SptLink(sptNode, iNetLink, this.dLog);
        String string = "Link is not usable: ";
        try {
            sptNode3 = new SptNode(iNetLink.getDst(), sptLink, this.prefs);
        }
        catch (xCausesRouteLoop xCausesRouteLoop2) {
            this.rLog.warning(string + sptLink.getLink().prettyString() + xCausesRouteLoop2.getString());
            sptLink.setUnusableException(new xLinkNotUsable(xCausesRouteLoop2.getString()));
            linkedList.add(sptLink);
            return false;
        }
        sptLink.setDstNode(sptNode3);
        try {
            this.filter.isUsable(sptLink);
        }
        catch (xLinkNotUsable xLinkNotUsable2) {
            this.rLog.warning(string + sptLink.getLink().prettyString() + xLinkNotUsable2.getString());
            sptLink.setUnusableException(xLinkNotUsable2);
            linkedList.add(sptLink);
            return false;
        }
        try {
            this.validateRequiredNodesLinksConstraint(sptNode3);
        }
        catch (xLinkDoesNotMeetRequiredNLConstraint xLinkDoesNotMeetRequiredNLConstraint2) {
            this.rLog.warning(string + sptLink.getLink().prettyString() + xLinkDoesNotMeetRequiredNLConstraint2.getString());
            sptLink.setUnusableException(new xLinkNotUsable(xLinkDoesNotMeetRequiredNLConstraint2.getString()));
            linkedList.add(sptLink);
            return false;
        }
        if (sptList.contains(sptNode3)) {
            this.rLog.warning(string + sptLink.getLink().prettyString() + "Already characteristically similar " + " path exists in SPT");
            return false;
        }
        try {
            candidateList.add(sptNode3);
        }
        catch (xAlreadyInCandidateList xAlreadyInCandidateList2) {
            this.rLog.warning(string + xAlreadyInCandidateList2.getString());
            return false;
        }
        sptNode2 = sptNode3;
        return true;
    }

    private boolean isUsableForSameSts(INetLink iNetLink) {
        if (this.prefs.sameStsRouting()) {
            IHoNum iHoNum;
            int n = this.getMaxStsNumber(this.prefs);
            if (iNetLink.getPhysicalSize() < n) {
                this.rLog.info("isUsableForSameSts maxStsNum: " + n);
                return false;
            }
            int n2 = this.prefs.getPathProtection();
            return iNetLink.getProtectionType() != 0 || n2 == 13 || n < (iHoNum = iNetLink.get2fBlsrStartingPcaHo(true)).getHoNum();
        }
        return true;
    }

    private int getMaxStsNumber(RoutePrefs routePrefs) {
        int n = 0;
        LinkedList linkedList = routePrefs.allStsToUse();
        Iterator iterator = linkedList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            if (n2 <= n) continue;
            n = n2;
        }
        this.rLog.info("getMaxStsNumber : " + n);
        return n;
    }

    private void validateRequiredNodesLinksConstraint(SptNode sptNode) throws xLinkDoesNotMeetRequiredNLConstraint {
        int n;
        SptNode sptNode2 = sptNode.getParentNode();
        if (sptNode2 == null) {
            this.dLog.finest("vrnlc: No Parent Node");
            return;
        }
        LinkedList linkedList = sptNode2.getReqNodes();
        if (linkedList == null || linkedList.size() == 0) {
            return;
        }
        ArrayList arrayList = sptNode.getBestLink().getLink().getNodesList();
        arrayList.remove(sptNode.getBestLink().getLink().getSrc());
        LinkedList<INetElement> linkedList2 = new LinkedList<INetElement>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            if (!linkedList.contains(iNetElement)) continue;
            linkedList2.add(iNetElement);
        }
        if (linkedList2.size() == 0) {
            this.dLog.finest("vrnlc: Link does not use any Required nodes");
            sptNode.setReqNodes(linkedList);
            return;
        }
        this.dLog.finest("vrnlc: Link uses: " + linkedList2.size() + " required nodes");
        this.validateRequiredLinksConstraint(sptNode);
        for (n = 0; n < linkedList2.size(); ++n) {
            if (linkedList.subList(0, linkedList2.size()).contains(linkedList2.get(n))) continue;
            throw new xLinkDoesNotMeetRequiredNLConstraint(" The nodes in the link are not in the order as required nodes \n");
        }
        for (n = 0; n < linkedList2.size(); ++n) {
            linkedList.removeFirst();
        }
        if (linkedList.size() == 1) {
            linkedList.removeFirst();
        }
        sptNode.setReqNodes(linkedList);
        sptNode.setReqNodesInBestLink(linkedList2);
        try {
            this.dLog.finest("vrnlc: Does route exists from the current node: " + sptNode.prettyString() + " to the destination");
            this.computeRoute(sptNode);
            this.dLog.finest("vrnlc: Route exists from current node: " + sptNode.prettyString() + " to the destination.");
        }
        catch (NoRoute noRoute) {
            this.dLog.finest("vrnlc: No Route exists from current node: " + sptNode.prettyString() + " to the destination.");
            throw new xLinkDoesNotMeetRequiredNLConstraint("Link does not meet required nodes/links constraint");
        }
    }

    private void validateRequiredLinksConstraint(SptNode sptNode) throws xLinkDoesNotMeetRequiredNLConstraint {
        INetLink iNetLink = sptNode.getBestLink().getLink();
        INetLink iNetLink2 = this.prefs.getRequiredLink(iNetLink.getSrc());
        if (iNetLink2 == null || ((Object)iNetLink2).equals(iNetLink)) {
            sptNode.addReqLinkInBestLink(iNetLink);
            return;
        }
        ArrayList arrayList = iNetLink.getNodesList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            INetElement iNetElement = (INetElement)iterator.next();
            iNetLink2 = this.prefs.getRequiredLink(iNetElement);
            if (iNetLink2 == null) continue;
            ArrayList arrayList2 = iNetLink.getLinksList();
            boolean bl = false;
            Iterator iterator2 = arrayList2.iterator();
            while (iterator2.hasNext()) {
                INetLink iNetLink3 = (INetLink)iterator2.next();
                if (iNetLink3.getSrc() != iNetElement && iNetLink3.getDst() != iNetElement) continue;
                INetLink iNetLink4 = iNetLink3.getReverseLink();
                if (!((Object)iNetLink3).equals(iNetLink2) && (iNetLink4 == null || !((Object)iNetLink4).equals(iNetLink2))) continue;
                sptNode.addReqLinkInBestLink(iNetLink2);
                bl = true;
                this.dLog.finest("vrlc: The required link " + iNetLink2.prettyString() + " is used by the current link " + iNetLink.prettyString());
            }
            if (bl) continue;
            throw new xLinkDoesNotMeetRequiredNLConstraint("Required Link " + iNetLink2.prettyString() + " is not used by the link ");
        }
    }

    protected INetElement[] computeReachableNodes() {
        Object object;
        Iterator iterator;
        Collection collection;
        this.prefs.setCheckSwitchingGranularity(false);
        try {
            this.srcSptNode = new SptNode(this.srcNe, null, this.prefs);
        }
        catch (xCausesRouteLoop xCausesRouteLoop2) {
            // empty catch block
        }
        this.dLog.info("crn: From: " + this.srcSptNode.getNetElement().prettyString());
        SptList sptList = new SptList(this.prefs);
        CandidateList candidateList = new CandidateList(this.prefs);
        try {
            candidateList.add(this.srcSptNode);
        }
        catch (xAlreadyInCandidateList xAlreadyInCandidateList2) {
            // empty catch block
        }
        while (!candidateList.isEmpty()) {
            SptNode sptNode = candidateList.getNextCandidate();
            this.dLog.info("crn: Considering " + sptNode.getNetElement().prettyString() + " for SPT");
            sptList.add(sptNode);
            collection = this.prefs.getAdjacencyExtractor().getAdjacencyList(sptNode.getNetElement());
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                object = (INetLink)iterator.next();
                this.dLog.info("crn: Considering " + object.prettyString());
                SptNode sptNode2 = null;
                if (this.isUsable((INetLink)object, sptNode, sptList, candidateList, sptNode2, new LinkedList())) {
                    this.dLog.info("crn: Link is Usable");
                    continue;
                }
                this.dLog.info("crn: Link is NOT Usable");
            }
        }
        collection = sptList.getNeList();
        iterator = ((AbstractSequentialList)collection).iterator();
        while (iterator.hasNext()) {
            object = (INetElement)iterator.next();
            if (object.canSupportCircuitSize(this.prefs.getBandwidth())) continue;
            this.dLog.info("crn: NE " + object.getName() + " does not support circuit size" + CircuitSize.getCircuitSize((int)this.prefs.getBandwidth()).toString());
            iterator.remove();
        }
        this.dLog.info("crn: Done Computation; SptList size is : " + ((LinkedList)collection).size());
        return ((LinkedList)collection).toArray(new INetElement[((LinkedList)collection).size()]);
    }

    public static boolean anyLoops(INetElement iNetElement, LinkedList linkedList) {
        SptNode sptNode = null;
        try {
            sptNode = new SptNode(iNetElement, null);
        }
        catch (xCausesRouteLoop xCausesRouteLoop2) {
            // empty catch block
        }
        SptNode sptNode2 = null;
        LinkedList<SptNode> linkedList2 = new LinkedList<SptNode>();
        linkedList2.add(sptNode);
        while (!linkedList2.isEmpty()) {
            sptNode = (SptNode)linkedList2.remove(0);
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (iNetLink.getSrc() != sptNode.getNetElement()) continue;
                SptLink sptLink = new SptLink(iNetLink, sptNode);
                try {
                    sptNode2 = new SptNode(iNetLink.getDst(), sptLink);
                }
                catch (xCausesRouteLoop xCausesRouteLoop3) {
                    return true;
                }
                sptLink.setDstNode(sptNode2);
                linkedList2.add(sptNode2);
            }
        }
        return false;
    }

    public static boolean anyInvalidRings(INetElement iNetElement, LinkedList linkedList, LinkedList linkedList2) {
        SptNode sptNode = null;
        try {
            sptNode = new SptNode(iNetElement, null);
        }
        catch (xCausesRouteLoop xCausesRouteLoop2) {
            // empty catch block
        }
        LinkedList<SptNode> linkedList3 = new LinkedList<SptNode>();
        linkedList3.add(sptNode);
        while (!linkedList3.isEmpty()) {
            sptNode = (SptNode)linkedList3.remove(0);
            Iterator iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (iNetLink.getSrc() != sptNode.getNetElement()) continue;
                INetElement iNetElement2 = iNetLink.getDst();
                SptLink sptLink = new SptLink(iNetLink, sptNode);
                SptNode sptNode2 = null;
                try {
                    sptNode2 = new SptNode(iNetElement2, sptLink);
                }
                catch (xCausesRouteLoop xCausesRouteLoop3) {
                    if (iNetElement2.equals(iNetElement)) continue;
                    return true;
                }
                sptLink.setDstNode(sptNode2);
                linkedList3.add(sptNode2);
            }
        }
        return false;
    }

    private static List getChildren(INetElement iNetElement, LinkedList linkedList) {
        LinkedList<SptNode> linkedList2 = new LinkedList<SptNode>();
        SptNode sptNode = null;
        SptNode sptNode2 = null;
        try {
            sptNode2 = new SptNode(iNetElement, null);
        }
        catch (xCausesRouteLoop xCausesRouteLoop2) {
            // empty catch block
        }
        LinkedList<SptNode> linkedList3 = new LinkedList<SptNode>();
        linkedList3.add(sptNode2);
        while (!linkedList3.isEmpty()) {
            sptNode2 = (SptNode)linkedList3.remove(0);
            int n = 0;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (iNetLink.getSrc() != sptNode2.getNetElement()) {
                    if (++n != linkedList.size()) continue;
                    linkedList2.add(sptNode2);
                    continue;
                }
                INetElement iNetElement2 = iNetLink.getDst();
                SptLink sptLink = new SptLink(iNetLink, sptNode2);
                sptNode = new SptNode(iNetElement2);
                sptNode.setBestLink(sptLink);
                sptLink.setDstNode(sptNode);
                if (sptNode.isAlsoAncestor()) {
                    linkedList2.add(sptNode);
                    continue;
                }
                linkedList3.add(sptNode);
            }
        }
        return linkedList2;
    }

    private static List findLinksBwtTwoLinks(List list, INetLink iNetLink, INetLink iNetLink2) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink3 = (INetLink)iterator.next();
            if (iNetLink3 == iNetLink) {
                bl = true;
            }
            if (iNetLink3 == iNetLink2) {
                linkedList.add(iNetLink3);
                bl = false;
            }
            if (!bl) continue;
            linkedList.add(iNetLink3);
        }
        return linkedList;
    }

    public static List getLinksBtwTwoLinks(INetElement iNetElement, INetElement iNetElement2, LinkedList linkedList, INetLink iNetLink, INetLink iNetLink2) {
        LinkedList linkedList2 = new LinkedList();
        List list = Spt.getChildren(iNetElement, linkedList);
        if (iNetElement2 != null) {
            list.addAll(Spt.getChildren(iNetElement2, linkedList));
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SptNode sptNode = (SptNode)iterator.next();
            LinkedList linkedList3 = sptNode.getAllLinks();
            LinkedList<INetLink> linkedList4 = new LinkedList<INetLink>();
            Iterator iterator2 = linkedList3.iterator();
            while (iterator2.hasNext()) {
                INetLink iNetLink3 = ((SptLink)iterator2.next()).getLink();
                linkedList4.add(iNetLink3);
            }
            if (iNetLink == null && iNetLink2 == null) {
                linkedList2.addAll(linkedList4);
                continue;
            }
            if (iNetLink2 == null) {
                if (!linkedList4.contains(iNetLink)) continue;
                linkedList2.addAll(linkedList4);
                continue;
            }
            if (!linkedList4.contains(iNetLink) || !linkedList4.contains(iNetLink2)) continue;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            Object object = linkedList4.iterator();
            while (object.hasNext()) {
                INetLink iNetLink4 = (INetLink)object.next();
                if (iNetLink4 == iNetLink) {
                    n = n3;
                }
                if (iNetLink4 == iNetLink2) {
                    n2 = n3;
                }
                ++n3;
            }
            if (n > n2) continue;
            object = Spt.findLinksBwtTwoLinks(linkedList4, iNetLink, iNetLink2);
            Spt.insertLinks(linkedList2, (List)object);
        }
        return linkedList2;
    }

    private static void insertLinks(List list, List list2) {
        if (list.isEmpty()) {
            list.addAll(list2);
            return;
        }
        int n = 0;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!list.contains(iNetLink)) {
                list.add(n, iNetLink);
                ++n;
                continue;
            }
            n = list.indexOf(iNetLink) + 1;
        }
    }

    private DetailedLog getReachableNodesLog(SptList sptList) {
        DetailedLog detailedLog = new DetailedLog(1, "Reachable Nodes");
        LinkedList linkedList = sptList.getSptNodesList();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            SptNode sptNode = (SptNode)iterator.next();
            detailedLog.addChild(new DetailedLog(1, sptNode.dumpPathToNode()));
        }
        return detailedLog;
    }

    private DetailedLog getUnusableLinksLog(SptList sptList, LinkedList linkedList) {
        Iterator iterator = linkedList.iterator();
        LinkedList linkedList2 = sptList.getNeList();
        DetailedLog detailedLog = new DetailedLog(1, "Unusable Links");
        while (iterator.hasNext()) {
            SptLink sptLink = (SptLink)iterator.next();
            if (!linkedList2.contains(sptLink.getLink().getSrc()) || linkedList2.contains(sptLink.getLink().getDst())) continue;
            String string = "";
            if (sptLink.getUnusableException() != null) {
                string = sptLink.getUnusableException().getString();
            }
            this.dLog.info("Unusable Links:" + sptLink.prettyString() + " " + string);
            DetailedLog detailedLog2 = new DetailedLog(2, sptLink.prettyString() + ":" + string);
            detailedLog.addChild(detailedLog2);
        }
        return detailedLog;
    }

    private DetailedLog getSptFailureLog(SptNode sptNode, SptList sptList, LinkedList linkedList) {
        DetailedLog detailedLog = this.getReachableNodesLog(sptList);
        DetailedLog detailedLog2 = this.getUnusableLinksLog(sptList, linkedList);
        DetailedLog detailedLog3 = new DetailedLog(3, "No Route to Destination from Node " + sptNode.prettyString());
        detailedLog3.addChild(detailedLog);
        detailedLog3.addChild(detailedLog2);
        return detailedLog3;
    }
}

