/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.AggregateMetric;
import cerent.cms.route.DebugLog;
import cerent.cms.route.IMetric;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.xCausesRouteLoop;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class SptNode {
    private INetElement ne;
    private SptLink bestLink;
    private IMetric cost;
    private LinkedList reqNodes;
    private PathCharacteristics pc;
    private RoutePrefs prefs;

    public SptNode(INetElement iNetElement, SptLink sptLink, RoutePrefs routePrefs) throws xCausesRouteLoop {
        this.ne = iNetElement;
        this.bestLink = sptLink;
        this.prefs = routePrefs;
        this.reqNodes = new LinkedList();
        if (this.isAlsoAncestor()) {
            throw new xCausesRouteLoop("This link leads to a loop");
        }
        this.pc = routePrefs.explorePathCharacterstics() ? new PathCharacteristics(this, true) : new PathCharacteristics(this, false);
        this.cost = new AggregateMetric(routePrefs, this);
        if (routePrefs.needOptimalPath() && sptLink != null) {
            this.cost.accumulate(sptLink.getSrcNode().getCost(), sptLink, routePrefs);
        }
    }

    public SptNode(INetElement iNetElement, SptLink sptLink) throws xCausesRouteLoop {
        this.ne = iNetElement;
        this.bestLink = sptLink;
        if (this.isAlsoAncestor()) {
            throw new xCausesRouteLoop("This link leads to a loop");
        }
    }

    public SptNode(INetElement iNetElement) {
        this.ne = iNetElement;
        this.bestLink = null;
    }

    public INetElement getNetElement() {
        return this.ne;
    }

    protected IMetric getCost() {
        return this.cost;
    }

    private PathCharacteristics getPc() {
        return this.pc;
    }

    protected SptLink getBestLink() {
        return this.bestLink;
    }

    protected void setBestLink(SptLink sptLink) {
        this.bestLink = sptLink;
    }

    protected LinkedList getReqNodes() {
        return new LinkedList(this.reqNodes);
    }

    protected SptNode getParentNode() {
        if (this.getBestLink() == null) {
            return null;
        }
        return this.getBestLink().getSrcNode();
    }

    protected void setReqNodes(LinkedList linkedList) {
        this.reqNodes = new LinkedList(linkedList);
    }

    protected void setReqNodesInBestLink(LinkedList linkedList) {
        if (this.pc != null) {
            this.pc.addReqNodes(linkedList);
        }
    }

    protected void addReqLinkInBestLink(INetLink iNetLink) {
    }

    protected LinkedList getAllLinks() {
        LinkedList<SptLink> linkedList = new LinkedList<SptLink>();
        SptLink sptLink = this.getBestLink();
        while (sptLink != null) {
            linkedList.addFirst(sptLink);
            SptNode sptNode = sptLink.getSrcNode();
            sptLink = sptNode.getBestLink();
        }
        return linkedList;
    }

    protected LinkedList getNetLinks() {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        SptLink sptLink = this.getBestLink();
        while (sptLink != null) {
            linkedList.addFirst(sptLink.getLink());
            SptNode sptNode = sptLink.getSrcNode();
            sptLink = sptNode.getBestLink();
        }
        return linkedList;
    }

    protected boolean isAlsoAncestor() {
        SptLink sptLink = this.getBestLink();
        if (sptLink == null) {
            return false;
        }
        ArrayList arrayList = sptLink.getLink().getNodesList();
        arrayList.remove(sptLink.getSrcNode().getNetElement());
        while (sptLink != null) {
            if (sptLink != this.getBestLink()) {
                ArrayList arrayList2 = sptLink.getLink().getNodesList();
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    INetElement iNetElement = (INetElement)iterator.next();
                    if (!arrayList.contains(iNetElement)) continue;
                    return true;
                }
            }
            sptLink = sptLink.getSrcNode().getBestLink();
        }
        return false;
    }

    public boolean areYouBetterPath(SptNode sptNode) {
        return this.getCost().betterThan(sptNode.getCost());
    }

    public int tieBreaker(SptNode sptNode) {
        int n = 0;
        int n2 = 0;
        if (this.prefs.isLoCircuit()) {
            n = this.getNumLotLinks();
            n2 = sptNode.getNumLotLinks();
        }
        if (n - n2 != 0) {
            return n - n2;
        }
        switch (this.prefs.getPathProt()) {
            case 4: {
                n = this.getNumPcaLinks();
                n2 = sptNode.getNumPcaLinks();
                break;
            }
            case 2: {
                n = this.getNumUnprotectedLinks();
                n2 = sptNode.getNumUnprotectedLinks();
                break;
            }
            case 5: {
                if (this.prefs.getDriNodePrefs().size() == 0) {
                    n = this.getNumUnprotectedLinks();
                    n2 = sptNode.getNumUnprotectedLinks();
                    break;
                }
                n = this.getNumBlsrDriLinks();
                if (n != (n2 = sptNode.getNumBlsrDriLinks())) break;
                n = this.getNumUnprotectedLinks();
                n2 = sptNode.getNumUnprotectedLinks();
                break;
            }
            case 0: 
            case 1: 
            case 6: {
                n = this.getNumProtectedLinks();
                n2 = sptNode.getNumProtectedLinks();
                if (n != n2) break;
                this.prefs.getLog().info("equal prot links, breaking tie using # blsr links ");
                n = this.getNumBlsrLinks();
                n2 = sptNode.getNumBlsrLinks();
                if (n != n2 || n == 0) break;
                n = -1 * this.getNumDistinctBlsrRings();
                n2 = -1 * sptNode.getNumDistinctBlsrRings();
                this.prefs.getLog().info("equal blsr links, breaking ties using #distinct blsr rings my=" + n + " other = " + n2);
            }
        }
        return n - n2;
    }

    public int getNumLotLinks() {
        int n = 0;
        Iterator iterator = this.getNetLinks().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!iNetLink.isLOTunnel()) continue;
            ++n;
        }
        return n;
    }

    public int getNumPcaLinks() {
        int n = 0;
        Iterator iterator = this.getNetLinks().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!iNetLink.isPca()) continue;
            ++n;
        }
        return n;
    }

    public int getNumUnprotectedLinks() {
        int n = 0;
        Iterator iterator = this.getNetLinks().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!iNetLink.isFullyUnprotected()) continue;
            ++n;
        }
        return n;
    }

    public int getNumProtectedLinks() {
        int n = 0;
        Iterator iterator = this.getNetLinks().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!iNetLink.isProtected()) continue;
            ++n;
        }
        return n;
    }

    public int getNumBlsrLinks() {
        int n = 0;
        Iterator iterator = this.getNetLinks().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!iNetLink.inBLSR()) continue;
            ++n;
        }
        return n;
    }

    public int getNumDistinctBlsrRings() {
        String string = "";
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.getNetLinks().iterator();
        this.prefs.getLog().info("get distinct blsr rings");
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            ArrayList arrayList = iNetLink.getLinksList();
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                INetLink iNetLink2 = (INetLink)iterator2.next();
                string = iNetLink2.blsrRingName();
                if (string == "" || string == null || linkedList.contains(string)) continue;
                linkedList.add(string);
            }
        }
        return linkedList.size();
    }

    public int getNumBlsrDriLinks() {
        int n = 0;
        LinkedList linkedList = this.prefs.getActiveMember().getPreferredDriRings();
        if (linkedList == null || linkedList.size() == 0) {
            return 0;
        }
        Iterator iterator = this.getNetLinks().iterator();
        while (iterator.hasNext()) {
            String string;
            INetLink iNetLink = (INetLink)iterator.next();
            if (!iNetLink.inBLSR() || (string = iNetLink.blsrRingName()) == "" || string == null || !linkedList.contains(string)) continue;
            ++n;
        }
        return n;
    }

    public String prettyString() {
        return this.getNetElement().prettyString();
    }

    protected String dumpPathToNode() {
        LinkedList linkedList = this.getNetLinks();
        String string = this.prettyString() + ":" + "Path=";
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            string = string + iNetLink.getSrc().prettyString() + "-";
        }
        string = string + this.prettyString();
        return string;
    }

    public String getCostString() {
        return this.getCost().prettyString();
    }

    public boolean isCharacteristicallySimilar(SptNode sptNode) {
        DebugLog debugLog = this.prefs.getLog().getDebugLog();
        if (this.getPc() != null) {
            return this.getPc().equal(sptNode.getPc());
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SptNode)) {
            return false;
        }
        SptNode sptNode = (SptNode)object;
        return sptNode.getNetElement().getNodeId() == this.getNetElement().getNodeId() && sptNode.isCharacteristicallySimilar(this);
    }

    public int hashCode() {
        return this.getNetElement().getNodeId();
    }

    private class PathCharacteristics {
        private LinkedList scList;
        LinkedList reqNodesList = new LinkedList();

        public PathCharacteristics(SptNode sptNode2, boolean bl) {
            Object object;
            this.scList = new LinkedList();
            if (sptNode2.getBestLink() != null && (object = sptNode2.getBestLink().getSrcNode().getPc()) != null) {
                this.scList.addAll(super.getScList());
                this.reqNodesList.addAll(super.getReqNodesList());
            }
            if (bl) {
                object = new SegmentCharacteristics(sptNode2);
                if (this.scList.size() == 0 || !((SegmentCharacteristics)object).equal((SegmentCharacteristics)this.scList.getLast())) {
                    this.scList.add(object);
                }
            }
        }

        private void addReqNodes(LinkedList linkedList) {
            this.reqNodesList.addAll(linkedList);
        }

        private LinkedList getScList() {
            return this.scList;
        }

        private LinkedList getReqNodesList() {
            return this.reqNodesList;
        }

        protected boolean equal(PathCharacteristics pathCharacteristics) {
            LinkedList linkedList = pathCharacteristics.getScList();
            LinkedList linkedList2 = this.getScList();
            if (linkedList.size() != linkedList2.size()) {
                return false;
            }
            for (int i = 0; i < linkedList2.size(); ++i) {
                if (((SegmentCharacteristics)linkedList2.get(i)).equal((SegmentCharacteristics)linkedList.get(i))) continue;
                return false;
            }
            linkedList = pathCharacteristics.getReqNodesList();
            linkedList2 = this.getReqNodesList();
            return linkedList.size() == linkedList2.size();
        }

        protected String prettyString() {
            Object object;
            int n;
            String string = "Path Characteristics: ";
            LinkedList linkedList = this.getScList();
            string = string + "Segment List: ";
            for (n = 0; n < linkedList.size(); ++n) {
                object = (SegmentCharacteristics)linkedList.get(n);
                string = ((SegmentCharacteristics)object).lineProtected ? string + " P " : string + " U ";
            }
            string = string + " Required Nodes: ";
            linkedList = this.getReqNodesList();
            for (n = 0; n < linkedList.size(); ++n) {
                object = (INetElement)linkedList.get(n);
                string = string + object.prettyString() + " ";
            }
            return string;
        }

        private class SegmentCharacteristics {
            protected boolean lineProtected = false;

            public SegmentCharacteristics(SptNode sptNode) {
                if (sptNode.getBestLink() == null) {
                    return;
                }
                if (sptNode.getBestLink().getLink().isProtected()) {
                    this.lineProtected = true;
                }
            }

            private boolean equal(SegmentCharacteristics segmentCharacteristics) {
                return segmentCharacteristics.lineProtected == this.lineProtected;
            }
        }
    }
}

