/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.CircuitPath;
import cerent.cms.route.DebugLog;
import cerent.cms.route.DropPath;
import cerent.cms.route.DropPrefs;
import cerent.cms.route.HoGranularityFilter;
import cerent.cms.route.IGranularityFilter;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.IRouteRequestor;
import cerent.cms.route.InvalidCircuitPath;
import cerent.cms.route.LambdaGranularityFilter;
import cerent.cms.route.LoGranularityFilter;
import cerent.cms.route.ManualAdjacencyExtractor;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NoRoute;
import cerent.cms.route.NullGranularityFilter;
import cerent.cms.route.OhGranularityFilter;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import java.util.Iterator;
import java.util.LinkedList;

public class VcatFilter {
    RoutePrefs prefs;
    IRouteRequestor rr;
    IGranularityFilter gFilter;

    public VcatFilter(RoutePrefs routePrefs, IRouteRequestor iRouteRequestor) {
        this.prefs = routePrefs;
        this.rr = iRouteRequestor;
    }

    private void intializeGFilter() {
        if (this.prefs.forOhCircuit()) {
            this.gFilter = new OhGranularityFilter(this.prefs, this);
            return;
        }
        if (this.prefs.getPathOnly() || this.prefs.isOchTrailCircuit()) {
            this.gFilter = new NullGranularityFilter(this.prefs, this);
            return;
        }
        this.gFilter = this.prefs.isLoCircuit() ? new LoGranularityFilter(this.prefs, this) : (this.prefs.isOchncCircuit() || this.prefs.isOchTrailTunnelCircuit() ? new LambdaGranularityFilter(this.prefs, this) : new HoGranularityFilter(this.prefs, this));
    }

    protected boolean isUsable(SptLink sptLink) throws xLinkNotUsable {
        if (!this.prefs.needOptimalPath()) {
            return true;
        }
        ILabelSet iLabelSet = sptLink.getSrcLabelSet();
        ILabelSet iLabelSet2 = sptLink.getDstLabelSet();
        if (iLabelSet.size() < this.prefs.getMemberCount() || iLabelSet2.size() < this.prefs.getMemberCount()) {
            String string = "VcatFilter: Not enough bandwidth available on link  Required # Labels: " + this.prefs.getMemberCount() + "Available " + "# Source Labels: " + iLabelSet.size() + "# Dest labels: " + iLabelSet2.size();
            this.prefs.getLog().warning(string);
            throw new xLinkNotUsable(string);
        }
        return true;
    }

    private LinkedList computePrefLinks(LinkedList linkedList, MemberPrefs memberPrefs) {
        LinkedList<INetLink> linkedList2 = new LinkedList<INetLink>();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (memberPrefs.getPathProtection() != 4 && memberPrefs.getPathProtection() != 6) {
                linkedList2.add(iNetLink);
                continue;
            }
            if (iNetLink.getProtectionType() != 0 && iNetLink.getProtectionType() != 5) {
                linkedList2.add(iNetLink);
                continue;
            }
            if (memberPrefs.getPathProtection() == 4 && iNetLink.getProtectionType() == 5) {
                linkedList2.add(iNetLink);
                continue;
            }
            if (memberPrefs.getPathProtection() == 6 && iNetLink.getProtectionType() == 0) {
                linkedList2.add(iNetLink);
                continue;
            }
            INetLink iNetLink2 = iNetLink.getCounterpartLink();
            if (iNetLink2 == null) continue;
            linkedList2.add(iNetLink2);
        }
        return linkedList2;
    }

    protected CircuitPath getCircuitPath() throws NoRoute {
        CircuitPath circuitPath = new CircuitPath(this.prefs);
        DropPath dropPath = new DropPath(circuitPath);
        try {
            circuitPath.setDropPath(dropPath);
        }
        catch (InvalidCircuitPath invalidCircuitPath) {
            if (this.prefs.getLog().getDebugLog().on()) {
                this.prefs.getLog().getDebugLog();
                DebugLog.printStackTrace((Throwable)invalidCircuitPath);
            }
            throw new NoRoute("No path found.");
        }
        DropPrefs dropPrefs = this.prefs.getFwdDropPrefs();
        this.prefs.setActiveDropPrefs(dropPrefs);
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        int n = 1;
        Iterator iterator = dropPrefs.getMemberGroupPrefs().iterator();
        while (iterator.hasNext()) {
            MemberGroupPrefs memberGroupPrefs = (MemberGroupPrefs)iterator.next();
            MemberPrefs memberPrefs = memberGroupPrefs.getMemberPrefs();
            memberPrefs.sanityCheck();
            dropPrefs.setActiveMemberGroupPrefs(memberGroupPrefs);
            LinkedList linkedList3 = this.computePrefLinks(linkedList, memberPrefs);
            memberPrefs.addExcludeSpans(linkedList2);
            memberPrefs.addPreferredLinks(linkedList3);
            if (dropPrefs.getMemberGroupPrefs().size() > 1) {
                this.prefs.getLog().getDebugLog().info("<<< VCatFilter: Routing for Member Group #: " + n++ + " >>>" + "\nMember Prefs: " + memberPrefs.prettyString());
            }
            this.intializeGFilter();
            CircuitPath circuitPath2 = this.gFilter.getCircuitPath();
            if (dropPrefs.getMemberGroupPrefs().size() <= 1) {
                return circuitPath2;
            }
            DropPath dropPath2 = circuitPath2.getDropPath();
            dropPath.addMemberPaths(dropPath2.getMemberPaths());
            linkedList2.addAll(circuitPath2.getAvailSpans());
            linkedList = circuitPath2.getPathLinks();
            if (!dropPrefs.isCommonFiber()) continue;
            ManualAdjacencyExtractor manualAdjacencyExtractor = new ManualAdjacencyExtractor(this.prefs);
            this.prefs.setAdjacencyExtractor(manualAdjacencyExtractor);
        }
        return circuitPath;
    }

    protected INetElement[] getReachableNodes() {
        this.intializeGFilter();
        return this.gFilter.getReachableNodes();
    }
}

