/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.FramingType;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOspfTopologyModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.Topology;
import cerent.launcher.CtcHttpRetriever;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.NO_IMPLEMENT;

public class NetElement
extends CmsObservable
implements INetElement,
IObserver {
    private static final SDebug dbg = new SDebug("NetElement");
    private NodeModel node;
    private int nodeId;
    private int oldNodeId;
    private boolean connected;
    private boolean loXCon;
    private Topology topology;
    private Integer topoId;
    private String name;
    private String defaultName;
    private boolean inited;
    private boolean isTopoHost;
    private boolean isABR;
    private List ospfAreas;
    private boolean deleted;
    private String hostName;
    private List adjacencyList;
    private IOspfTopologyModel topoModel;
    private String swVersion;
    private boolean hasSecureIPAddress;
    private String secureIPAddress;
    private NetElemDebug db;

    public String prettyString() {
        return this.getName() + (this.loXCon() ? "v" : " ");
    }

    protected NetElement(NodeModel nodeModel, Topology topology, int n) throws AbstractCmsIOException {
        this.db = new NetElemDebug("NetElement_" + NetElement.getDebugName(nodeModel.getHostName()));
        if (dbg.on()) {
            this.db.set(true);
        }
        if (this.db.on()) {
            this.db.println("NetElement: creating new NE instance");
        }
        this.topoId = new Integer(0);
        this.deleted = false;
        this.topoModel = null;
        this.node = nodeModel;
        this.name = this.defaultName = nodeModel.getDefaultName();
        this.hostName = "unknown";
        this.swVersion = "";
        this.isTopoHost = false;
        this.isABR = false;
        this.hasSecureIPAddress = false;
        this.secureIPAddress = "unknown";
        this.setTopology(topology, n);
        this.ospfAreas = Collections.synchronizedList(new LinkedList());
        this.node.addObserver(this);
        this.node.getConnectionNotifier().addObserver((IObserver)this);
        this.adjacencyList = Collections.synchronizedList(new LinkedList());
        this.updateInitedState();
        this.updateConnectionState();
        this.initializeNodeId();
        this.updateName();
        this.updateLoXCon();
        this.updateHostName();
        this.updateSwVersion();
        this.updateSecureIPAddress();
        this.clearChanged();
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof NodeModel) {
            if (object == ModelUpdateType.DELETED) {
                if (this.db.on()) {
                    this.db.println("update: received DELETED event from NM");
                }
                this.dispose();
            } else if (object == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED update from NM");
                }
                this.updateName();
                this.updateLoXCon();
                this.updateHostName();
                this.updateSecureIPAddress();
                this.notifyObservers(ModelUpdateType.CHANGED);
                if (this.hasNodeIdChanged()) {
                    this.oldNodeId = this.nodeId;
                }
            }
        } else if (iObservable instanceof NodeModel.ConnectionNotifier) {
            if (this.db.on()) {
                this.db.println("update: received " + object + " event from " + "ConnectionNotifier");
            }
            this.updateInitedState();
            this.updateConnectionState();
            this.updateNodeId();
            this.updateName();
            this.updateLoXCon();
            this.updateHostName();
            this.updateSwVersion();
            this.updateSecureIPAddress();
            Network.instance().updateServerTrails(this);
            this.notifyObservers(ModelUpdateType.CHANGED);
            if (this.hasNodeIdChanged()) {
                this.oldNodeId = this.nodeId;
            }
        } else if (iObservable instanceof IOspfTopologyModel) {
            if (object == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED event from TopoModel");
                }
                this.discoverAreas();
                this.notifyObservers(ModelUpdateType.CHANGED);
            } else if (object == ModelUpdateType.DELETED) {
                if (this.db.on()) {
                    this.db.println("update: received DELETED event from TopoModel");
                }
                this.releaseTopoModel();
            }
        }
    }

    public boolean getConnectionState() {
        return this.connected;
    }

    public boolean isInited() {
        return this.inited;
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public int getFramingType() {
        return this.node.getFramingType();
    }

    public IFramingType getFramingTypeObj() {
        return FramingType.getFramingType((int)this.getFramingType());
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public int getOldNodeId() {
        return this.oldNodeId;
    }

    public boolean hasNodeIdChanged() {
        return this.oldNodeId == this.nodeId;
    }

    public IOspfTopologyModel getOspfTopologyModel() {
        return this.topoModel;
    }

    private void updateInitedState() {
        boolean bl = this.inited;
        this.inited = this.node.isInited();
        if (bl != this.inited) {
            this.setChanged();
            if (this.db.on()) {
                this.db.println("updateInitedState: state change, old = " + bl + ", new = " + this.inited);
            }
        }
    }

    private void updateConnectionState() {
        boolean bl = this.node.getConnectionState();
        if (this.connected == bl) {
            return;
        }
        if (bl) {
            if (this.inited) {
                if (this.db.on()) {
                    this.db.println("updateConnectionState: state change, old = " + this.connected + ", new = " + bl);
                }
                this.connected = bl;
                this.setChanged();
            }
            this.acquireTopoModel();
        } else {
            if (this.db.on()) {
                this.db.println("updateConnectionState: state change, old = " + this.connected + ", new = " + bl);
            }
            this.connected = bl;
            this.releaseTopoModel();
            this.setChanged();
        }
    }

    private void updateNodeId() {
        int n;
        if (this.db.on) {
            this.db.println("Entering updateNodeId");
        }
        if (this.isInited() && this.nodeId != (n = this.node.getNodeId())) {
            if (this.topology != null) {
                this.oldNodeId = this.nodeId;
                this.nodeId = n;
                if (this.db.on) {
                    this.db.println("Calling Topology.updateNodeId for " + this.topology);
                }
                this.topology.updateNodeId(this);
            }
            this.setChanged();
            if (this.db.on()) {
                this.db.println("updateNodeId: nodeId changed, old = " + Integer.toHexString(this.oldNodeId) + ", new = " + Integer.toHexString(this.nodeId));
            }
        }
        if (this.db.on) {
            this.db.println("Exitting updateNodeId");
        }
    }

    private void initializeNodeId() {
        this.nodeId = this.oldNodeId = this.node.getNodeId();
        if (this.db.on()) {
            this.db.println("initializeNodeId: nodeId = " + Integer.toHexString(this.nodeId));
        }
    }

    private void updateLoXCon() {
        boolean bl = this.loXCon;
        if (this.node.isInited()) {
            boolean bl2 = this.loXCon = this.node.provides(Feature.XCVT) || this.node.provides(Feature.XCVXC);
            if (bl != this.loXCon) {
                this.setChanged();
                if (this.db.on()) {
                    this.db.println("updateLoXCon: loXCon changed, old = " + bl + ", new = " + this.loXCon);
                }
            }
        }
    }

    private void updateName() {
        if (this.node.isInited()) {
            String string = this.name;
            this.name = this.node.getName();
            if (this.db.on()) {
                this.db.println("updateName = " + this.name);
            }
            if (!string.equals(this.name)) {
                this.setChanged();
                if (this.db.on()) {
                    this.db.println("updateName: name changed, old = " + string + ", new = " + this.name);
                }
            }
        }
    }

    private void updateHostName() {
        String string = this.hostName;
        this.hostName = this.node.getHostName();
        if (!string.equals(this.hostName)) {
            if (this.topology != null) {
                this.topology.updateIPAddress(this, string);
            }
            this.setChanged();
            if (this.db.on()) {
                this.db.println("updateHostName: hostname changed, old = " + string + ", new = " + this.hostName);
            }
        }
    }

    private void updateSecureIPAddress() {
        if (this.node.isInited()) {
            if (this.node.provides(Feature.TCC2P_SECURITY_MODE)) {
                this.hasSecureIPAddress = true;
                String string = this.secureIPAddress;
                IIpAddr iIpAddr = this.node.getSecureIpConfig().getIpAddress();
                this.secureIPAddress = InetUtil.makeDottedString(iIpAddr);
                if (!string.equals(this.secureIPAddress)) {
                    if (this.topology != null) {
                        this.topology.updateSecureIPAddress(this, string);
                    }
                    this.setChanged();
                    if (this.db.on()) {
                        this.db.println("updateSecureIPAddress: secure IP address changed, old = " + string + ", new = " + this.secureIPAddress);
                    }
                }
            } else {
                this.hasSecureIPAddress = false;
                this.secureIPAddress = "unknown";
            }
        }
    }

    private void updateSwVersion() {
        String string = this.swVersion;
        try {
            this.swVersion = CtcHttpRetriever.getSwVersion((String)this.hostName);
            if (this.swVersion.length() >= 5) {
                this.swVersion = this.swVersion.substring(0, 5);
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (this.db.on()) {
                this.db.println("updateSwVersion: caught IO exception");
            }
            NetElemDebug.printStackTrace((Throwable)malformedURLException);
            this.swVersion = "";
        }
        catch (IOException iOException) {
            if (this.db.on()) {
                this.db.println("updateSwVersion: caught IO exception");
            }
            NetElemDebug.printStackTrace((Throwable)iOException);
            this.swVersion = "";
        }
        if (!string.equals(this.swVersion)) {
            this.setChanged();
            if (this.db.on()) {
                this.db.println("updateSwVersion: SW version changed, old = " + string + ", new = " + this.swVersion);
            }
        }
    }

    public void setNodeId(int n) {
        if (this.db.on()) {
            this.db.println("setNodeId: nodeId = " + Integer.toHexString(n));
        }
        this.nodeId = n;
    }

    public boolean canSupportCircuitSize(int n) {
        boolean bl;
        block4: {
            if (PortGrouping.getInstance().isInCreation()) {
                return true;
            }
            bl = false;
            try {
                if (this.node != null) {
                    bl = this.node.canSupportCircuitSize(n);
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block4;
                this.db.println("canSupportCircuitSize( " + n + " ) encountered exception");
                NetElemDebug.printStackTrace((Throwable)exception);
            }
        }
        return bl;
    }

    public boolean loXCon() {
        return this.loXCon;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public String getName() {
        return this.name;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getSecureIPAddress() {
        return this.secureIPAddress;
    }

    public boolean hasSecureIPAddress() {
        return this.hasSecureIPAddress && !this.secureIPAddress.equals("unknown");
    }

    protected void setHostName(String string) throws UnknownHostException {
        boolean bl;
        this.node.setHostName(string);
        boolean bl2 = bl = !this.hostName.equals(string);
        if (this.db.on()) {
            this.db.println("setHostName: changed from " + this.hostName + " to " + string);
        }
        this.hostName = string;
        if (bl) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    public String getSwVersion() {
        return this.swVersion;
    }

    public void addAdjacentLink(INetLink iNetLink) {
        int n = iNetLink.getSrcEntityIndex();
        if (iNetLink.isValidSrcHoNumber(iNetLink.getSrcHo()) && iNetLink.getSrcHo() != null) {
            n += iNetLink.getSrcHo().getHoNum();
        }
        Iterator iterator = this.adjacencyList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            INetLink iNetLink2 = (INetLink)iterator.next();
            int n3 = iNetLink2.getSrcEntityIndex();
            if (iNetLink2.isValidSrcHoNumber(iNetLink2.getSrcHo()) && iNetLink2.getSrcHo() != null) {
                n3 += iNetLink2.getSrcHo().getHoNum();
            }
            if (n == n3 && ((Object)iNetLink).equals(iNetLink2)) {
                return;
            }
            if (n3 < n) {
                this.adjacencyList.add(n2, iNetLink);
                return;
            }
            ++n2;
        }
        this.adjacencyList.add(iNetLink);
    }

    public void removeAdjacentLink(INetLink iNetLink) {
        this.adjacencyList.remove(iNetLink);
    }

    public Collection getAdjacencyList() {
        return this.adjacencyList;
    }

    public LinkedList getBlsrLinks(INetLink iNetLink) {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        Iterator iterator = this.getAdjacencyList().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink2 = (INetLink)iterator.next();
            if (!iNetLink2.originatingRingName().equals(iNetLink.originatingRingName())) continue;
            linkedList.add(iNetLink2);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTopology(Topology topology, int n) {
        if (this.db.on()) {
            this.db.println("setTopology: topo = " + topology + ", topo id = " + n);
        }
        Integer n2 = this.topoId;
        synchronized (n2) {
            this.topology = topology;
            this.topoId = new Integer(n);
        }
    }

    public int getTopoId() {
        return this.topoId;
    }

    public Topology getTopology() {
        return this.topology;
    }

    protected void setTopoHost(boolean bl) {
        if (this.isTopoHost != bl) {
            this.isTopoHost = bl;
            if (this.db.on()) {
                this.db.println("setTopoHost: NE is topo host = " + bl);
            }
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    public boolean isTopoHost() {
        return this.isTopoHost;
    }

    private void setIsABR(boolean bl) {
        if (this.isABR != bl) {
            this.setChanged();
            this.isABR = bl;
            if (this.db.on()) {
                this.db.println("setIsABR: NE is ABR => " + this.isABR);
            }
        }
        if (this.isABR && this.topology != null) {
            this.topology.discoveredABR(this);
        }
    }

    public boolean isABR() {
        return this.isABR;
    }

    private synchronized void discoverAreas() {
        if (this.topoModel == null) {
            if (this.db.on()) {
                this.db.println("discoverAreas: topoModel is null");
            }
            return;
        }
        if (this.db.on()) {
            this.db.println("discoverAreas: retrieving OSPF areas from topoModel");
        }
        if (this.node.provides(Feature.MULTI_OSPF_AREAS)) {
            int[] nArray;
            try {
                nArray = this.topoModel.getOspfAreas().getOspfAreaList();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.db.on()) {
                    this.db.println("discoverAreas: caught exception => " + abstractCmsIOException.getMessage());
                    NetElemDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
                nArray = new int[]{};
            }
            if (this.db.on()) {
                this.db.println("discoverAreas: NE belongs to " + nArray.length + " areas");
            }
            this.ospfAreas.clear();
            for (int i = 0; i < nArray.length; ++i) {
                Long l;
                if (this.db.on()) {
                    this.db.println("discoverAreas: adding area " + nArray[i]);
                }
                if (this.ospfAreas.contains(l = new Long(nArray[i]))) continue;
                this.ospfAreas.add(l);
            }
        } else {
            long l;
            try {
                l = Topology.ipAddrToLong(this.node.getOspfLanConfigModel().getDccOspfAreaId());
            }
            catch (NO_IMPLEMENT nO_IMPLEMENT) {
                l = 0L;
            }
            catch (AbstractMethodError abstractMethodError) {
                l = 0L;
            }
            this.ospfAreas.clear();
            this.ospfAreas.add(new Long(l));
        }
        if (this.ospfAreas.size() > 1) {
            this.setIsABR(true);
        } else {
            this.setIsABR(false);
        }
    }

    public boolean containsOspfArea(long l) {
        return this.ospfAreas.contains(new Long(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getOspfAreas() {
        LinkedList linkedList;
        List list = this.ospfAreas;
        synchronized (list) {
            linkedList = new LinkedList(this.ospfAreas);
        }
        return linkedList;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy: destroying NM");
        }
        if (this.isDeleted()) {
            if (this.db.on()) {
                this.db.println("destroy: NE already deleted");
            }
            return;
        }
        this.node.getConnectionNotifier().deleteObserver((IObserver)this);
        this.node.destroy();
    }

    private void dispose() {
        if (this.db != null && this.db.on()) {
            this.db.println("dispose: disposing NE");
        }
        this.deleted = true;
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
        if (this.topology != null) {
            this.topology.delete(this);
        }
        this.releaseTopoModel();
        super.destroy();
        if (this.node != null) {
            this.node.deleteObserver(this);
        }
        if (this.db != null) {
            this.db.dispose();
        }
    }

    public static String getDebugName(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
            if (inetAddress != null) {
                byte[] byArray = inetAddress.getAddress();
                return "" + (byArray[3] & 0xFF) + "-" + (byArray[2] & 0xFF) + "-" + (byArray[1] & 0xFF) + "-" + (byArray[0] & 0xFF);
            }
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    private synchronized void releaseTopoModel() {
        if (this.topoModel != null) {
            this.topoModel.deleteObserver((IObserver)this);
            if (!this.node.provides(Feature.TOPO_LIFECYCLE_MGMT)) {
                if (this.db.on()) {
                    this.db.println("releaseTopoModel: topoModel support not provided, destroying topoModel");
                }
                this.topoModel.destroy();
            }
            this.topoModel = null;
            if (this.db.on()) {
                this.db.println("releaseTopoModel: released TopoModel");
            }
        }
    }

    private void acquireTopoModel() {
        if (this.node.isInited() && this.topoModel == null) {
            this.topoModel = this.node.getOspfTopologyModel();
            if (this.topoModel != null) {
                if (this.db.on()) {
                    this.db.println("acquireTopoModel: acquired TopoModel");
                }
                if (!this.node.provides(Feature.TOPO_LIFECYCLE_MGMT)) {
                    if (this.db.on()) {
                        this.db.println("acquireTopoModel: topoModel support not provided, initing topoModel");
                    }
                    this.topoModel.init();
                }
                this.topoModel.addObserver((IObserver)this);
                this.discoverAreas();
                this.setChanged();
            }
        }
    }

    public class NetElemDebug
    extends SDebug {
        public NetElemDebug(String string) {
            super(string);
        }

        public final void dumpNMObservers() {
            NetElement.this.db.println("NM observers:");
            NetElement.this.node.printObservers();
        }

        public final void dumpObservers() {
            NetElement.this.db.println("NE observers");
            NetElement.this.printObservers();
        }

        public final void dump() {
            NetElement.this.db.println("=================================");
            NetElement.this.db.println("NetElement state:");
            NetElement.this.db.println("name = " + NetElement.this.name);
            NetElement.this.db.println("defaultName = " + NetElement.this.defaultName);
            NetElement.this.db.println("IP address = " + NetElement.this.hostName);
            NetElement.this.db.println("Secure IP address = " + NetElement.this.secureIPAddress);
            NetElement.this.db.println("Node ID = " + NetElement.this.nodeId);
            NetElement.this.db.println("Connected = " + NetElement.this.connected);
            NetElement.this.db.println("Inited = " + NetElement.this.inited);
            NetElement.this.db.println("Topology Host = " + NetElement.this.isTopoHost);
            NetElement.this.db.println("TopoModel = " + NetElement.this.topoModel);
            NetElement.this.db.println("SW Version = " + NetElement.this.swVersion);
            this.dumpAreas();
            NetElement.this.db.println("loXCon = " + NetElement.this.loXCon);
            NetElement.this.db.println("Topology ID = " + NetElement.this.topoId);
        }

        public final void dumpAreas() {
            NetElement.this.db.println("----------------");
            NetElement.this.db.println("ABR = " + NetElement.this.isABR);
            NetElement.this.db.println("OSPF area(s): ");
            Iterator iterator = NetElement.this.getOspfAreas().iterator();
            while (iterator.hasNext()) {
                NetElement.this.db.println("    " + (Long)iterator.next());
            }
        }

        public final void testChangedUpdate() {
            NetElement.this.setChanged();
            NetElement.this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }
}

