/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILinkPhysicalType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IReversionMode;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.GenericSrg;
import cerent.cms.route.ISrg;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.DccLinkStateMachine;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.LinkStateMachine;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.topo.PhantomLinkStateMachine;
import cerent.cms.topo.ProtectionSwitchStateHelper;
import cerent.cms.topo.RoutableNetLink;
import cerent.cms.topo.Topology;
import cerent.util.EnumStrings;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class NetLink
extends RoutableNetLink {
    private boolean checking;
    private long ospfAreaId;
    private LinkStateMachine linkStateMc;
    private ProtectionSwitchStateHelper srcProtectionSwitchState;
    private ProtectionSwitchStateHelper dstProtectionSwitchState;
    private PhantomLinkStateMachine srcPhantomLinkStateMc;
    private INetCircuit lotCircuit = null;
    private LinkedList userSrlgs;
    public static final int MAX_SRLG_TYPE = 5;
    static /* synthetic */ Class class$cerent$cms$model$ILinkType;

    protected NetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, Topology topology, int n, boolean bl2) {
        super(network, iLinkModel, iNetElement, iNetElement2, bl, topology, n);
        this.ospfAreaId = 0L;
        this.linkStateMc = new DccLinkStateMachine(network, this, this.db);
        this.deleted = false;
        this.checking = false;
        this.userSrlgs = new LinkedList();
        if (this.isPhantom()) {
            this.srcPhantomLinkStateMc = new PhantomLinkStateMachine(this, (NetElement)this.getSrc(), this.getSrcEntityIndex(), this.db);
            this.srcPhantomLinkStateMc.addObserver(this);
        }
        if (bl2 && bl) {
            this.linkStateMc.driveSm(5);
        }
        if (this.isBlsr() || this.isOnePlusOne()) {
            this.srcProtectionSwitchState = new ProtectionSwitchStateHelper(this, this.getSrc(), this.getSrcEntityIndex(), this.db);
            this.dstProtectionSwitchState = new ProtectionSwitchStateHelper(this, this.getDst(), this.getDstEntityIndex(), this.db);
            this.srcProtectionSwitchState.addObserver(this);
            this.dstProtectionSwitchState.addObserver(this);
            INetLink iNetLink = network.findReverseLink(this);
            if (iNetLink != null && iNetLink instanceof NetLink) {
                ((NetLink)iNetLink).updateProtectionSwitchState();
            }
        }
    }

    protected NetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, int n, boolean bl, LinkedList linkedList, LinkedList linkedList2, INetCircuit iNetCircuit) {
        super(network, iLinkModel, iNetElement, iNetElement2, topology, n, false, linkedList, linkedList2);
        Object object;
        this.checking = false;
        this.userSrlgs = new LinkedList();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            object = (INetElement)iterator.next();
            if (!this.nodesList.contains(object)) {
                this.nodesList.add(object);
            }
            object.addObserver((IObserver)this);
        }
        object = linkedList2.iterator();
        while (object.hasNext()) {
            INetLink iNetLink = (INetLink)object.next();
            if (!this.linksList.contains(iNetLink)) {
                this.linksList.add(iNetLink);
            }
            iNetLink.addObserver(this);
        }
        this.lotCircuit = iNetCircuit;
    }

    protected NetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, int n, boolean bl, LinkedList linkedList, LinkedList linkedList2, boolean bl2, boolean bl3, INetCircuit iNetCircuit) {
        super(network, iLinkModel, iNetElement, iNetElement2, topology, n, false, linkedList, linkedList2);
        if (this.db.on()) {
            this.db.println("creating new network link for LAP");
        }
        this.srcExtendable = bl2;
        this.dstExtendable = bl3;
        this.userSrlgs = new LinkedList();
        this.lotCircuit = iNetCircuit;
    }

    protected void initializeDebug() {
        if (this.isLOTunnel() || this.isLAP()) {
            this.db = new NetLinkDebug("NLv" + NetLink.getDebugName(this.src.getHostName()) + "(" + Integer.toHexString(this.getSrcEntityIndex()) + ")-" + NetLink.getDebugName(this.dst.getHostName()) + "(" + Integer.toHexString(this.getDstEntityIndex()) + ")");
            if (this.db.on()) {
                this.db.println("NetLink: creating new LOT/LAP NetLink");
            }
        } else {
            this.db = new NetLinkDebug((this.sdccLink ? "NL_" : "NLp") + NetLink.getDebugName(this.src.getHostName()) + "(" + Integer.toHexString(this.getSrcEntityIndex()) + ")-" + NetLink.getDebugName(this.dst.getHostName()) + "(" + Integer.toHexString(this.getDstEntityIndex()) + ")");
            if (this.db.on()) {
                if (this.isPca()) {
                    this.db.println("NetLink: creating new PCA NetLink");
                } else {
                    this.db.println("NetLink: creating new NetLink");
                }
            }
        }
    }

    public void setProtectionType(int n) {
        INetLink iNetLink;
        boolean bl = false;
        if (this.linkModel.protectionType() != n) {
            bl = true;
        } else {
            this.updateProtectionSwitchState();
        }
        super.setProtectionType(n);
        if (bl && (this.isBlsr() || this.isOnePlusOne())) {
            if (this.srcProtectionSwitchState != null) {
                this.srcProtectionSwitchState.dispose();
            }
            if (this.dstProtectionSwitchState != null) {
                this.dstProtectionSwitchState.dispose();
            }
            this.srcProtectionSwitchState = new ProtectionSwitchStateHelper(this, this.getSrc(), this.getSrcEntityIndex(), this.db);
            this.dstProtectionSwitchState = new ProtectionSwitchStateHelper(this, this.getDst(), this.getDstEntityIndex(), this.db);
            this.srcProtectionSwitchState.addObserver(this);
            this.dstProtectionSwitchState.addObserver(this);
        } else if (!(!bl || this.isBlsr() && this.isOnePlusOne())) {
            if (this.srcProtectionSwitchState != null) {
                if (this.db.on()) {
                    this.db.println("setProtectionType: link no longer protected, deleting SRC prot switch state");
                }
                this.srcProtectionSwitchState.dispose();
            }
            if (this.dstProtectionSwitchState != null) {
                if (this.db.on()) {
                    this.db.println("setProtectionType: link no longer protected, deleting DST prot switch state");
                }
                this.dstProtectionSwitchState.dispose();
            }
        }
        if (bl && (iNetLink = this.net.findReverseLink(this)) != null && iNetLink instanceof NetLink) {
            ((NetLink)iNetLink).updateProtectionSwitchState();
        }
    }

    public String prettyString() {
        return super.prettyString() + " " + (this.isPhysical() || this.isPhantom() ? this.getPhysicalTypeAsString() : "") + (this.isBlsr() ? " (ring " + this.blsrRingName() + ")" : "");
    }

    public String prettyStringDetail() {
        String string = super.prettyString() + " " + (this.isPhysical() ? this.getPhysicalTypeAsString() : "") + (this.isBlsr() ? " (ring " + this.blsrRingName() + (this.isNonRevertivePca() ? " nr " : "") + ")" : "") + (!this.isSdccLink() ? "" : " lsmState=" + this.linkStateMc.getCurrentSrcStateAsString() + "," + this.linkStateMc.getCurrentDstStateAsString()) + ", TopoId = " + this.getTopoId();
        if (this.userSrlgs.size() > 0) {
            String string2 = "";
            int n = 0;
            Iterator iterator = this.userSrlgs.iterator();
            while (iterator.hasNext()) {
                GenericSrg genericSrg = (GenericSrg)iterator.next();
                string2 = string2 + "\nSRLG " + ++n + genericSrg.prettyString();
            }
            string = string + string2;
        }
        return string;
    }

    private String getPhysicalTypeAsString() {
        boolean bl = this.isSonetCapable();
        ILinkPhysicalType iLinkPhysicalType = this.getPhysicalTypeObj();
        String string = "";
        if (iLinkPhysicalType == null) {
            if (this.db.on()) {
                this.db.println("getPhysicalTypeAsString: unknown " + (bl ? "SONET" : "SDH") + " physical type => " + this.getPhysicalSize());
            }
            string = "unknown";
        } else {
            string = iLinkPhysicalType.getDisplayString(bl);
        }
        return string;
    }

    private String getProtectionRoleAsString() {
        if (this.getProtectionRole() == 0) {
            return "Protect";
        }
        if (this.getProtectionRole() == 1) {
            return "Working";
        }
        if (this.db.on()) {
            this.db.println("getProtectionRoleAsString: unknown protection role => " + this.getProtectionRole());
        }
        return "unknown";
    }

    public boolean isBlsrCapable() {
        return true;
    }

    public INodeModel topoHost() {
        return this.linkModel.topoHost();
    }

    public void setTopoHost(INodeModel iNodeModel) {
        this.linkModel.setTopoHost(iNodeModel);
    }

    public int oldState() {
        return ((LinkModel)this.linkModel).oldState();
    }

    public int newState() {
        return ((LinkModel)this.linkModel).newState();
    }

    protected void oldState(int n) {
        ((LinkModel)this.linkModel).oldState(n);
    }

    public void newState(int n) {
        ((LinkModel)this.linkModel).oldState(this.newState());
        if (this.db.on()) {
            this.db.println("newState: state = " + (n == 1 ? "Up" : "Down."));
        }
        if (n != this.oldState()) {
            if (this.db.on()) {
                this.db.println("newState: state changed from " + (this.oldState() == 1 ? "Up" : "Down") + " to " + (n == 1 ? "Up" : "Down"));
            }
            ((LinkModel)this.linkModel).newState(n);
            if (n == 2) {
                this.linkStateMc.driveSm(8);
            } else if (n == 1) {
                this.linkStateMc.driveSm(9);
            }
            if (!this.deleted) {
                this.setChanged();
            } else {
                this.clearChanged();
            }
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    private void updateState(INetLink iNetLink) {
        int n = iNetLink.state();
        if (this.state() == n) {
            if (this.db.on()) {
                this.db.println("updateState: NL event, state unchanged");
            }
            return;
        }
        if (n == 2) {
            if (this.db.on()) {
                this.db.println("updateState: NL event, state changed, new => DOWN");
            }
            ((LinkModel)this.linkModel).newState(n);
            this.setChanged();
        } else {
            this.updateState();
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    private void updateState(INetElement iNetElement) {
        boolean bl = iNetElement.getConnectionState();
        if (this.state() == 2 && !bl || this.state() == 1 && bl) {
            if (this.db.on()) {
                this.db.println("updateState: NE event, state unchanged");
            }
            return;
        }
        if (this.state() == 1 && !bl) {
            if (this.db.on()) {
                this.db.println("updateState: NE event, state changed, new => DOWN");
            }
            ((LinkModel)this.linkModel).newState(2);
            this.setChanged();
        } else if (this.state() == 2 && bl) {
            this.updateState();
        } else {
            this.db.println("updateState: NE event, unsupported event");
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    private void updateState() {
        Object object;
        int n = 1;
        Iterator iterator = this.linksList.iterator();
        while (iterator.hasNext()) {
            object = (INetLink)iterator.next();
            if (object.state() != 2) continue;
            if (this.db.on()) {
                this.db.println("updateState: NL " + object.prettyString() + "still DOWN");
            }
            n = 2;
            break;
        }
        if (n == 2) {
            return;
        }
        iterator = this.nodesList.iterator();
        while (iterator.hasNext()) {
            object = (INetElement)iterator.next();
            if (object.getConnectionState()) continue;
            if (this.db.on()) {
                this.db.println("updateState: NE " + object.prettyString() + "still disconnected");
            }
            n = 2;
            break;
        }
        if (n == 1) {
            if (this.db.on()) {
                this.db.println("updateState: state changed, new => UP");
            }
            ((LinkModel)this.linkModel).newState(1);
            this.setChanged();
        }
    }

    protected void refresh(int n, String string, byte by, int n2, int n3, int n4, int n5) {
        if (this.db.on()) {
            this.db.println("refresh: processing refresh request");
        }
        this.setProtectionType(n);
        if (this.isBlsr()) {
            this.setBlsrRingName(string);
            this.setBlsrNodeId(by);
        } else {
            this.setBlsrRingName("");
            this.setBlsrNodeId((byte)32);
        }
        this.setCost(n2);
        this.setPhysicalType(n3);
        this.setPcaRevertMode(n5);
        this.newState(1);
    }

    protected void setChecking(boolean bl) {
        if (this.db.on()) {
            this.db.println("setChecking: checking = " + bl);
        }
        this.checking = bl;
    }

    public boolean inChecking() {
        return this.checking;
    }

    public boolean isWorkingBlsr() {
        return this.getProtectionType() == 0 || this.getProtectionType() == 4;
    }

    public boolean isBlsr() {
        return this.getProtectionType() == 0 || this.getProtectionType() == 4 || this.getProtectionType() == 5 || this.getProtectionType() == 6;
    }

    public boolean isOnePlusOne() {
        return this.getProtectionType() == 1;
    }

    public int getSrcProtectionSwitchState() {
        if (this.srcProtectionSwitchState != null) {
            return this.srcProtectionSwitchState.getState();
        }
        return -1;
    }

    private String getSrcProtectionSwitchStateAsString() {
        if (this.srcProtectionSwitchState != null) {
            return this.srcProtectionSwitchState.getStateAsString();
        }
        return "UNKNOWN";
    }

    public int getDstProtectionSwitchState() {
        if (this.dstProtectionSwitchState != null) {
            return this.dstProtectionSwitchState.getState();
        }
        return -1;
    }

    private String getDstProtectionSwitchStateAsString() {
        if (this.dstProtectionSwitchState != null) {
            return this.dstProtectionSwitchState.getStateAsString();
        }
        return "UNKNOWN";
    }

    public int getEndProtectionSwitchState(boolean bl) {
        if (bl) {
            return this.getSrcProtectionSwitchState();
        }
        return this.getDstProtectionSwitchState();
    }

    public int getPcaRevertMode() {
        return ((LinkModel)this.linkModel).pcaRevertMode();
    }

    public boolean isNonRevertivePca() {
        return this.isPca() && this.getPcaRevertMode() == 1;
    }

    public String blsrRingName() {
        return ((LinkModel)this.linkModel).blsrRingName();
    }

    public String blsrRingName(INetElement iNetElement) {
        if (iNetElement.equals(this.getSrc())) {
            return this.originatingRingName();
        }
        return this.terminatingRingName();
    }

    public byte blsrNodeId() {
        return ((LinkModel)this.linkModel).blsrNodeId();
    }

    public void setPcaRevertMode(boolean bl) {
        if (bl) {
            this.setPcaRevertMode(1);
        } else {
            this.setPcaRevertMode(2);
        }
    }

    public void setPcaRevertMode(int n) {
        if (n != ((LinkModel)this.linkModel).pcaRevertMode()) {
            if (this.db.on()) {
                this.db.println(this.prettyString() + ": new PcaReversionMode = " + EnumStrings.getString((Class)IReversionMode.class, (int)n));
            }
            ((LinkModel)this.linkModel).pcaRevertMode = n;
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    private void setBlsrRingName(String string) {
        if (!((LinkModel)this.linkModel).blsrRingName().equals(string)) {
            if (this.db.on()) {
                this.db.println("setBlsrRingName: " + ((LinkModel)this.linkModel).blsrRingName() + " --> " + string);
            }
            ((LinkModel)this.linkModel).setBlsrRingName(string);
            this.setChanged();
        }
    }

    private void setBlsrNodeId(byte by) {
        if (((LinkModel)this.linkModel).blsrNodeId() != by) {
            if (this.db.on()) {
                this.db.println("setBlsrNodeId: " + ((LinkModel)this.linkModel).blsrNodeId() + " --> " + by);
            }
            ((LinkModel)this.linkModel).setBlsrNodeId(by);
            this.setChanged();
        }
    }

    public Topology getTopology() {
        return this.topology;
    }

    public int getTopoId() {
        return this.topoId;
    }

    protected void setOspfAreaId(long l) {
        if (this.ospfAreaId != l) {
            this.ospfAreaId = l;
            this.topology.ospfAreaChanged(this);
        }
    }

    protected void clearOspfAreaId() {
        this.ospfAreaId = 0L;
    }

    public long getOspfAreaId() {
        return this.ospfAreaId;
    }

    public boolean inBLSR(String string) {
        if (this.isLOTunnel() || this.isLAP()) {
            Iterator iterator = this.linksList.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (!(iNetLink instanceof NetLink) || !((NetLink)iNetLink).blsrRingName().equals(string)) continue;
                return true;
            }
            return false;
        }
        return this.blsrRingName().equals(string);
    }

    public boolean inBLSR() {
        if (this.isLOTunnel() || this.isLAP()) {
            Iterator iterator = this.linksList.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (!(iNetLink instanceof NetLink) || !((NetLink)iNetLink).inBLSR()) continue;
                return true;
            }
            return false;
        }
        return this.isBlsr();
    }

    public boolean inWorkingBLSR() {
        if (this.db.on()) {
            this.db.println("In Working Blsr: " + this.prettyString());
        }
        if (this.isLOTunnel() || this.isLAP()) {
            Iterator iterator = this.linksList.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                if (!(iNetLink instanceof NetLink) || !((NetLink)iNetLink).inWorkingBLSR()) continue;
                if (this.db.on()) {
                    this.db.println("In Working Blsr: Return true");
                }
                return true;
            }
            if (this.db.on()) {
                this.db.println("In Working Blsr: Return false");
            }
            return false;
        }
        return this.isWorkingBlsr();
    }

    public String originatingRingName() {
        if (this.linksList.size() == 0) {
            return "";
        }
        Iterator iterator = this.linksList.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!(iNetLink instanceof NetLink) || !iNetLink.getSrc().equals(this.getSrc()) && !iNetLink.getDst().equals(this.getSrc())) continue;
            return ((NetLink)iNetLink).blsrRingName();
        }
        return "";
    }

    public String terminatingRingName() {
        if (this.linksList.size() == 0) {
            return "";
        }
        Iterator iterator = this.linksList.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (!(iNetLink instanceof NetLink) || !iNetLink.getSrc().equals(this.getDst()) && !iNetLink.getDst().equals(this.getDst())) continue;
            return ((NetLink)iNetLink).blsrRingName();
        }
        return "";
    }

    public boolean originatingInRing() {
        if (this.linksList.size() == 0) {
            return false;
        }
        INetLink iNetLink = (INetLink)this.linksList.get(0);
        return iNetLink instanceof NetLink && ((NetLink)iNetLink).inBLSR();
    }

    public boolean terminatingInRing() {
        if (this.linksList.size() == 0) {
            return false;
        }
        INetLink iNetLink = (INetLink)this.linksList.get(this.linksList.size() - 1);
        return iNetLink instanceof NetLink && ((NetLink)iNetLink).inBLSR();
    }

    public INetLink get4FProtectLink() {
        IElementModel iElementModel;
        IEntityModel iEntityModel;
        if (this.getProtectionType() != 4) {
            return null;
        }
        IEntityTableModel iEntityTableModel = this.src.getNodeModel().getEntityTable();
        if (iEntityTableModel == null) {
            return null;
        }
        try {
            iEntityModel = iEntityTableModel.getEntityModelByIndex(this.linkModel.srcEntityIndex());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            return null;
        }
        if (!(iEntityModel instanceof ITdmPortModel)) {
            return null;
        }
        ITdmPortModel iTdmPortModel = (ITdmPortModel)iEntityModel;
        try {
            iElementModel = iTdmPortModel.getElementModel();
        }
        catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
            }
            return null;
        }
        if (!(iElementModel instanceof IBlsrModel)) {
            return null;
        }
        IBlsrModel iBlsrModel = (IBlsrModel)iElementModel;
        int n = iBlsrModel.getProtectEntityIndex(this.getSrcEntityIndex());
        if (this.db.on()) {
            this.db.println("Active Entity Index: " + Integer.toString(this.getSrcEntityIndex(), 16) + ", Protect Entity Index: " + Integer.toString(n, 16));
            this.db.println("Source Node: " + this.src.prettyString());
        }
        return this.net.findPcaNetLinkFromEnt(this.src, n);
    }

    public INetLink getBLSRPcaLink() {
        if (this.getProtectionType() == 4) {
            INetLink iNetLink = this.get4FProtectLink();
            if (dbg.on()) {
                dbg.println("getBLSRPcaLink returning (4F): " + iNetLink);
            }
            return iNetLink;
        }
        if (this.getProtectionType() == 0) {
            INetLink iNetLink = this.net.findPcaNetLinkFromEnt(this.src, this.getSrcEntityIndex());
            if (dbg.on()) {
                dbg.println("getBLSRPcaLink returning (2F): " + iNetLink);
            }
            return iNetLink;
        }
        if (this.getProtectionType() == 5 || this.getProtectionType() == 6) {
            if (dbg.on()) {
                dbg.println("getBLSRPcaLink returning (PCA): " + this);
            }
            return this;
        }
        return null;
    }

    public INetCircuit getLotCircuit() {
        return this.lotCircuit;
    }

    protected void _update(Object object, Object object2) {
        if (this.db.on()) {
            this.db.println("Update from " + object + ", ModelUpdateType = " + object2);
        }
        super._update(object, object2);
        if (object instanceof ProtectionSwitchStateHelper) {
            ProtectionSwitchStateHelper protectionSwitchStateHelper = (ProtectionSwitchStateHelper)((Object)object);
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED event from ProtectionSwitchStateHelper");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.CHANGED);
            } else if (object2 == ModelUpdateType.DELETED) {
                if (this.db.on()) {
                    this.db.println("update: received DELETED event from ProtectionSwitchStateHelper");
                }
                if (protectionSwitchStateHelper == this.srcProtectionSwitchState) {
                    if (this.db.on()) {
                        this.db.println("update: received DELETED event from SRC ProtectionSwitchStateHelper");
                    }
                    this.srcProtectionSwitchState.deleteObserver(this);
                    this.srcProtectionSwitchState = null;
                } else if (protectionSwitchStateHelper == this.dstProtectionSwitchState) {
                    if (this.db.on()) {
                        this.db.println("update: received DELETED event from DST ProtectionSwitchStateHelper");
                    }
                    this.dstProtectionSwitchState.deleteObserver(this);
                    this.dstProtectionSwitchState = null;
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.CHANGED);
            }
        } else if (object instanceof PhantomLinkStateMachine) {
            PhantomLinkStateMachine phantomLinkStateMachine = (PhantomLinkStateMachine)((Object)object);
            if (object2 == ModelUpdateType.DELETED) {
                INetLink iNetLink;
                if (this.db.on()) {
                    this.db.println("update: received DELETED event from PhantomLinkStateMachine");
                }
                if ((iNetLink = this.net.findReverseLink(this)) != null) {
                    iNetLink.dispose();
                }
                this.dispose();
            }
        } else if (object instanceof INetLink) {
            INetLink iNetLink = (INetLink)object;
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED event from NL " + iNetLink.prettyString());
                }
                this.updateState(iNetLink);
            } else if (object2 == ModelUpdateType.DELETED) {
                this.db.println("update: received DELETED event from NL " + iNetLink.prettyString());
                this.db.println("update: DELETED event not implemented.");
            }
        } else if (object instanceof INetElement) {
            INetElement iNetElement = (INetElement)object;
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED event from NE " + iNetElement.prettyString());
                }
                this.updateState(iNetElement);
            } else if (object2 == ModelUpdateType.DELETED) {
                this.db.println("update: received DELETED event from NE " + iNetElement.prettyString());
                this.db.println("update: DELETED event not implemented.");
            }
        }
    }

    protected void updateProtectionSwitchState() {
        if (this.srcProtectionSwitchState != null) {
            this.srcProtectionSwitchState.registerWithEM();
        }
        if (this.dstProtectionSwitchState != null) {
            this.dstProtectionSwitchState.registerWithEM();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disposeStep1() {
        NetLink netLink = this;
        synchronized (netLink) {
            if (this.deleted) {
                return false;
            }
            this.deleted = true;
        }
        if (!this.isLOTunnel() && !this.isLAP() && !this.isOchTrailTunnel() && this.db != null && this.db.on()) {
            this.db.println("dispose: disposing link, srcState => " + this.linkStateMc.getCurrentSrcStateAsString() + ", dstState => " + this.linkStateMc.getCurrentDstStateAsString());
        }
        if (this.net != null) {
            this.net.delete(this);
        }
        return true;
    }

    private void disposeStep2() {
        Object object;
        if (this.srcProtectionSwitchState != null) {
            this.srcProtectionSwitchState.dispose();
        }
        if (this.dstProtectionSwitchState != null) {
            this.dstProtectionSwitchState.dispose();
        }
        if (this.isPhantom() && this.srcPhantomLinkStateMc != null) {
            this.srcPhantomLinkStateMc.dispose();
            this.srcPhantomLinkStateMc.deleteObserver(this);
        }
        this.getSrc().deleteObserver(this);
        this.getDst().deleteObserver(this);
        Iterator iterator = this.linksList.iterator();
        while (iterator.hasNext()) {
            object = (INetLink)iterator.next();
            object.deleteObserver(this);
        }
        iterator = this.nodesList.iterator();
        while (iterator.hasNext()) {
            object = (INetElement)iterator.next();
            object.deleteObserver(this);
        }
        super.dispose();
        this.topology = null;
    }

    public void dispose() {
        if (!this.disposeStep1()) {
            return;
        }
        if (this.isSdccLink()) {
            this.linkStateMc.driveSm(4);
        }
        this.disposeStep2();
    }

    public void disposed() {
        if (this.disposeStep1()) {
            this.disposeStep2();
        }
    }

    public void addSrlg(ISrg iSrg) throws SanityCheckFailed {
        if (this.userSrlgs.contains(iSrg)) {
            return;
        }
        if (this.userSrlgs.size() >= 5) {
            throw new SanityCheckFailed("Only 5 SRLGs allowed per link");
        }
        this.userSrlgs.add(iSrg);
    }

    public void removeSrlg(ISrg iSrg) throws SanityCheckFailed {
        if (!this.userSrlgs.contains(iSrg)) {
            throw new SanityCheckFailed("Link is not part of SRLG");
        }
        this.userSrlgs.remove(iSrg);
    }

    public void clearSrlg() throws SanityCheckFailed {
        this.userSrlgs.clear();
    }

    public LinkedList getSrlgList() throws SanityCheckFailed {
        if (this.isLOTunnel() || this.isLAP()) {
            LinkedList linkedList = new LinkedList();
            Iterator iterator = this.linksList.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                linkedList.addAll(iNetLink.getSrlgList());
            }
            return linkedList;
        }
        return this.userSrlgs;
    }

    public int getCost() {
        int n = 0;
        if (this.isLOTunnel() || this.isLAP()) {
            Iterator iterator = this.linksList.iterator();
            while (iterator.hasNext()) {
                INetLink iNetLink = (INetLink)iterator.next();
                n += iNetLink.getCost();
            }
        } else {
            n = super.getCost();
        }
        return n;
    }

    public void containsSrg(Collection collection) throws xLinkNotUsable {
        super.containsSrg(collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ISrg iSrg = (ISrg)iterator.next();
            if (!this.userSrlgs.contains(iSrg)) continue;
            throw new xLinkNotUsable("Link contains SRLG: " + iSrg.prettyString());
        }
    }

    public static int getLinkPhysicalType(int n) {
        switch (n) {
            case 28: {
                return 0;
            }
            case 29: {
                return 1;
            }
            case 30: {
                return 2;
            }
            case 61: {
                return 3;
            }
        }
        return 5;
    }

    public static String getDebugName(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
            if (inetAddress != null) {
                byte[] byArray = inetAddress.getAddress();
                return "" + (byArray[3] & 0xFF) + "-" + (byArray[2] & 0xFF) + "-" + (byArray[1] & 0xFF) + "-" + (byArray[0] & 0xFF);
            }
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    public int state() {
        return this.newState();
    }

    public class NetLinkDebug
    extends SDebug {
        public NetLinkDebug(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            Object object;
            Iterator iterator;
            AbstractNetLink.dbg.println("==============================================");
            NetLink.this.db.println("Src = " + NetLink.this.src.getHostName());
            NetLink.this.db.println("Dst = " + NetLink.this.dst.getHostName());
            NetLink.this.db.println("State = " + (NetLink.this.newState() == 1 ? "Up" : "Down"));
            NetLink.this.db.println("Deleted = " + NetLink.this.deleted);
            NetLink.this.db.println("Checking = " + NetLink.this.checking);
            NetLink.this.db.println("Topology ID = " + NetLink.this.topoId);
            if (!(NetLink.this.isLOTunnel() || NetLink.this.isLAP() || NetLink.this.isOchTrailTunnel())) {
                NetLink.this.db.println("src state = " + NetLink.this.linkStateMc.getCurrentSrcStateAsString());
                NetLink.this.db.println("dst state = " + NetLink.this.linkStateMc.getCurrentDstStateAsString());
            }
            NetLink.this.db.println("NetLink Type = " + NetLink.this.getLinkTypeObj());
            NetLink.this.db.println("Originating Ring Name = " + NetLink.this.originatingRingName());
            NetLink.this.db.println("Terminating Ring Name = " + NetLink.this.terminatingRingName());
            NetLink.this.db.println("OSPF area ID = " + NetLink.this.ospfAreaId);
            NetLink.this.db.println("Protection Type = " + NetLink.this.getProtectionType() + " = " + NetLink.this.getProtectionTypeObj());
            if (!(NetLink.this.isLOTunnel() || NetLink.this.isLAP() || NetLink.this.isOchTrailTunnel())) {
                NetLink.this.db.println("Physical Type = " + NetLink.this.getPhysicalTypeObj().getDisplayString(NetLink.this.isSonetCapable()));
            }
            NetLink.this.db.println("Physical Link Type = " + EnumStrings.getString((Class)(class$cerent$cms$model$ILinkType == null ? (class$cerent$cms$model$ILinkType = NetLink.class$("cerent.cms.model.ILinkType")) : class$cerent$cms$model$ILinkType), (int)NetLink.this.getPhysicalLinkType()));
            NetLink.this.db.println("Src XC Capable = " + NetLink.this.linkModel.isXcCapable());
            NetLink.this.db.println("Dst XC Capable = " + NetLink.this.linkModel.isNbrXcCapable());
            NetLink.this.db.println("Protection role = " + NetLink.this.getProtectionRoleAsString());
            NetLink.this.db.println("Src Protection Switch State = " + NetLink.this.getSrcProtectionSwitchStateAsString());
            NetLink.this.db.println("Dst Protection Switch State = " + NetLink.this.getDstProtectionSwitchStateAsString());
            NetLink.this.db.println("Src Slot = " + NetLink.this.srcSlot);
            NetLink.this.db.println("Src Port = " + NetLink.this.srcPort);
            NetLink.this.db.println("Dst Slot = " + NetLink.this.dstSlot);
            NetLink.this.db.println("Dst Port = " + NetLink.this.dstPort);
            NetLink.this.db.println("Cost = " + NetLink.this.linkModel.cost());
            NetLink.this.db.println("  Nodes List: ");
            ArrayList arrayList = NetLink.this.nodesList;
            synchronized (arrayList) {
                iterator = NetLink.this.nodesList.iterator();
                while (iterator.hasNext()) {
                    object = (INetElement)iterator.next();
                    NetLink.this.db.println("    " + object.getHostName());
                }
            }
            NetLink.this.db.println("  Links List:");
            arrayList = NetLink.this.linksList;
            synchronized (arrayList) {
                iterator = NetLink.this.linksList.iterator();
                while (iterator.hasNext()) {
                    object = (INetLink)iterator.next();
                    NetLink.this.db.println("    " + object.prettyString());
                }
            }
        }

        public final void setLinkCost(int n) {
            NetLink.this.setCost(n);
        }

        public final void dumpLSMState() {
            if (!(NetLink.this.isLOTunnel() || NetLink.this.isLAP() || NetLink.this.isOchTrailTunnel())) {
                NetLink.this.db.println("=============================");
                NetLink.this.db.println("src state = " + NetLink.this.linkStateMc.getCurrentSrcStateAsString());
                NetLink.this.db.println("dst state = " + NetLink.this.linkStateMc.getCurrentDstStateAsString());
            }
        }

        public final void dumpObservers() {
            NetLink.this.db.println("NL observers:");
            NetLink.this.printObservers();
        }
    }
}

