/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.ILinkModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.NetLinkManager;
import cerent.cms.topo.Network;
import cerent.cms.topo.NonTerminationNetLink;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.OscNetLink;
import cerent.cms.topo.ServerTrailLink;
import cerent.cms.topo.ServerTrailPrefs;
import cerent.cms.topo.TerminationNetLink;
import cerent.cms.topo.Topology;
import cerent.cms.topo.UnknownNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.util.SDebug;
import java.util.LinkedList;

public class NetLinkFactory {
    private static final SDebug db = new SDebug("NetLinkFactory");

    public static INetLink createNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, boolean bl, boolean bl2) {
        AbstractNetLink abstractNetLink = null;
        if (network.db.on()) {
            db.set(true);
        }
        block0 : switch (iLinkModel.linkType()) {
            case 1: {
                switch (iLinkModel.physicalLinkType()) {
                    case 0: {
                        if (db.on()) {
                            db.println("createNetLink: creating new UnknownNetLink");
                        }
                        abstractNetLink = new UnknownNetLink(network, iLinkModel, iNetElement, iNetElement2, bl, topology, topology.getTopoId());
                        NetLinkManager.instance().newNetLink(abstractNetLink);
                        break block0;
                    }
                    case 1: 
                    case 2: {
                        if (iLinkModel.isXcCapable() && iLinkModel.isNbrXcCapable()) {
                            if (db.on()) {
                                db.println("createNetLink: creating new NetLink");
                            }
                            abstractNetLink = new NetLink(network, iLinkModel, iNetElement, iNetElement2, bl, topology, topology.getTopoId(), bl2);
                            break block0;
                        }
                        if (!iLinkModel.isXcCapable() && !iLinkModel.isNbrXcCapable()) {
                            if (db.on()) {
                                db.println("createNetLink: creating new SDCC NonTerminationNetLink");
                            }
                            abstractNetLink = new NonTerminationNetLink(network, iLinkModel, iNetElement, iNetElement2, topology, topology.getTopoId());
                            NetLinkManager.instance().newNetLink(abstractNetLink);
                            break block0;
                        }
                        if (db.on()) {
                            db.println("createNetLink: creating new TerminationNetLink");
                        }
                        abstractNetLink = new TerminationNetLink(network, iLinkModel, iNetElement, iNetElement2, topology, topology.getTopoId());
                        NetLinkManager.instance().newNetLink(abstractNetLink);
                        break block0;
                    }
                    case 3: {
                        if (db.on()) {
                            db.println("createNetLink: creating new GCC NonTerminationNetLink");
                        }
                        abstractNetLink = new NonTerminationNetLink(network, iLinkModel, iNetElement, iNetElement2, topology, topology.getTopoId());
                        NetLinkManager.instance().newNetLink(abstractNetLink);
                        break block0;
                    }
                    case 4: {
                        if (db.on()) {
                            db.println("createNetLink: creating new OscNetLink");
                        }
                        abstractNetLink = new OscNetLink(network, iLinkModel, iNetElement, iNetElement2, true, topology, topology.getTopoId(), true);
                        NetLinkManager.instance().newNetLink(abstractNetLink);
                        break block0;
                    }
                    case 5: {
                        if (db.on()) {
                            db.println("createNetLink: creating new DwdmNetLink");
                        }
                        abstractNetLink = new DwdmNetLink(network, iLinkModel, iNetElement, iNetElement2, false, topology, topology.getTopoId(), false);
                        break block0;
                    }
                }
                db.println("createNetLink: physical link type " + iLinkModel.physicalLinkType() + " NOT IMPLEMENTED");
                break;
            }
            case 2: 
            case 3: {
                abstractNetLink = new NetLink(network, iLinkModel, iNetElement, iNetElement2, false, topology, topology.getTopoId(), bl2);
                break;
            }
            case 6: {
                abstractNetLink = new VirtualNetLink(network, iLinkModel, iNetElement, iNetElement2, topology, topology.getTopoId());
                NetLinkManager.instance().newNetLink(abstractNetLink);
                break;
            }
            default: {
                db.println("createNetLink: link type " + iLinkModel.linkType() + " NOT IMPLEMENTED");
            }
        }
        return abstractNetLink;
    }

    public static INetLink createNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, LinkedList linkedList, LinkedList linkedList2, INetCircuit iNetCircuit) {
        NetLink netLink = null;
        switch (iLinkModel.linkType()) {
            case 2: {
                netLink = new NetLink(network, iLinkModel, iNetElement, iNetElement2, topology, topology.getTopoId(), false, linkedList, linkedList2, iNetCircuit);
                break;
            }
            case 8: {
                netLink = new OchTrailTunnelNetLink(network, iLinkModel, iNetElement, iNetElement2, topology, topology.getTopoId(), false, linkedList, linkedList2, iNetCircuit);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 9: {
                db.println("createNetLink: NOT SUPPORTED link type " + iLinkModel.linkType());
                break;
            }
            default: {
                db.println("createNetLink: link type " + iLinkModel.linkType() + " NOT IMPLEMENTED");
            }
        }
        return netLink;
    }

    public static INetLink createNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, LinkedList linkedList, LinkedList linkedList2, boolean bl, boolean bl2, INetCircuit iNetCircuit) {
        NetLink netLink = null;
        switch (iLinkModel.linkType()) {
            case 7: {
                netLink = new NetLink(network, iLinkModel, iNetElement, iNetElement2, topology, topology.getTopoId(), false, linkedList, linkedList2, bl, bl2, iNetCircuit);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                db.println("createNetLink: NOT SUPPORTED link type " + iLinkModel.linkType());
                break;
            }
            default: {
                db.println("createNetLink: link type " + iLinkModel.linkType() + " NOT IMPLEMENTED");
            }
        }
        return netLink;
    }

    public static INetLink createNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, boolean bl, ServerTrailPrefs serverTrailPrefs) {
        ServerTrailLink serverTrailLink = null;
        switch (iLinkModel.linkType()) {
            case 9: {
                serverTrailLink = new ServerTrailLink(network, iLinkModel, iNetElement, iNetElement2, topology, topology.getTopoId(), serverTrailPrefs);
                break;
            }
            default: {
                db.println("createServerTrailLink: link type " + iLinkModel.linkType() + " NOT IMPLEMENTED");
            }
        }
        return serverTrailLink;
    }
}

