/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.NetLink;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;

public class PhantomLinkStateMachine
extends CmsObservable
implements IObserver {
    private NetLink nl;
    private NetElement ne;
    private int entIdx;
    private SDebug db;
    private ITdmPortModel pm;
    private IInterfaceModel im;
    private int eqType;

    public PhantomLinkStateMachine(NetLink netLink, NetElement netElement, int n, SDebug sDebug) {
        this.nl = netLink;
        this.ne = netElement;
        this.entIdx = n;
        this.db = sDebug;
        this.pm = null;
        this.im = null;
        this.eqType = -1;
        this.registerWithPM();
        this.registerWithIM();
    }

    private ITdmPortModel acquirePortModel() {
        if (this.ne.getConnectionState()) {
            try {
                IEntityModel iEntityModel;
                INodeModel iNodeModel = this.ne.getNodeModel();
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null && (iEntityModel = iEntityTableModel.getEntityModelByIndex(this.entIdx)) != null && iEntityModel instanceof ITdmPortModel) {
                    this.pm = (ITdmPortModel)iEntityModel;
                    return this.pm;
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
                return null;
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    this.db.println("registerWithPM: No such entity for ent idx => " + this.entIdx);
                }
                return null;
            }
        }
        return null;
    }

    private void registerWithIM() {
        boolean bl = false;
        if (this.pm == null) {
            this.pm = this.acquirePortModel();
        }
        if (this.pm != null) {
            this.im = this.pm.getInterfaceModel();
            if (this.im != null) {
                ModelIndirectObservable.instance().addObserver((IObservable)this.im, this);
                if (this.db.on()) {
                    this.db.println("registerWithIM: observing InterfaceModel on " + this.ne.getHostName());
                }
                this.ne.deleteObserver(this);
                this.updateProtType();
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            if (this.db.on()) {
                this.db.println("registerWithIM: observing NE " + this.ne.getHostName());
            }
            this.ne.addObserver(this);
        }
    }

    private void deregisterWithIM() {
        if (this.im != null) {
            ModelIndirectObservable.instance().deleteObserver((IObservable)this.im, this);
            if (this.db.on()) {
                this.db.println("deregisterWithIM: deleted IntefaceModel observation on NE " + this.ne.getHostName());
            }
            this.im = null;
        }
    }

    private void registerWithPM() {
        if (this.pm == null) {
            this.pm = this.acquirePortModel();
        }
        if (this.pm != null) {
            ModelIndirectObservable.instance().addObserver((IObservable)this.pm, this);
            this.eqType = this.pm.getEqType();
            if (this.db.on()) {
                this.db.println("registerWithPM: observing PortModel on " + this.ne.getHostName());
            }
        } else {
            if (this.db.on()) {
                this.db.println("registerWithPM: observing NE " + this.ne.getHostName());
            }
            this.ne.addObserver(this);
        }
    }

    private void deregisterWithPM() {
        if (this.pm != null) {
            ModelIndirectObservable.instance().deleteObserver((IObservable)this.pm, this);
            if (this.db.on()) {
                this.db.println("deregisterWithPM: deleted PortModel observation on NE " + this.ne.getHostName());
            }
            this.pm = null;
        }
    }

    protected int getEqType() {
        return this.eqType;
    }

    private void updateEqType() {
        block4: {
            try {
                if (this.pm != null && this.pm.getEqType() != this.eqType) {
                    if (this.db.on()) {
                        this.db.println("updateEqType: eqType changed, old => " + this.eqType + ", new => " + this.pm.getEqType());
                    }
                    this.eqType = this.pm.getEqType();
                    this.nl.setPhysicalType(NetLink.getLinkPhysicalType(this.eqType));
                }
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (!this.db.on()) break block4;
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
        }
    }

    private void updateProtType() {
        if (this.pm != null) {
            if (this.pm.hasOpticalProtection()) {
                if (!this.nl.isProtected()) {
                    try {
                        if (this.pm.isOnePlusOnePortActive()) {
                            if (this.db.on()) {
                                this.db.println("updateProtType: protType changed old => Unprot, new => 1+1");
                            }
                            this.nl.setProtectionType(1);
                        } else if (this.db.on()) {
                            this.db.println("updateProtType: ERROR: Port incorrectly provisioned as protect port for 1+1 Protection Group");
                        }
                    }
                    catch (NoSuchInterface noSuchInterface) {
                        if (this.db.on()) {
                            this.db.println("updateProtType: caught Exception => ");
                            SDebug.printStackTrace((Throwable)noSuchInterface);
                        }
                    }
                    catch (WrongInterfaceType wrongInterfaceType) {
                        if (this.db.on()) {
                            this.db.println("updateProtType: caught Exception => ");
                            SDebug.printStackTrace((Throwable)wrongInterfaceType);
                        }
                    }
                }
            } else if (this.nl.isProtected()) {
                if (this.db.on()) {
                    this.db.println("updateProtType: protType changed old => 1+1, new => Unprot");
                }
                this.nl.setProtectionType(3);
            }
        } else if (this.db.on()) {
            this.db.println("updateProtType: PortModel is null");
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose: disposing PhantomLinkStateMachine");
        }
        this.deregisterWithPM();
        this.deregisterWithIM();
        this.ne.deleteObserver(this);
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof ITdmPortModel) {
            ITdmPortModel iTdmPortModel = (ITdmPortModel)iObservable;
            if (object == ModelUpdateType.DELETED) {
                if (this.db.on()) {
                    this.db.println("PhantomLinkStateMachine.update: received DELETED event from PortModel on NE " + this.ne.getHostName());
                }
                this.dispose();
            } else if (object == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("PhantomLinkStateMachine.update: received CHANGED event from PortModel on NE " + this.ne.getHostName());
                }
                this.updateEqType();
            }
        } else if (iObservable instanceof IInterfaceModel) {
            if (object == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("PhantomLinkStateMaching.update: received CHANGED event from InterfaceModel " + iObservable);
                }
                this.updateProtType();
            } else if (object == ModelUpdateType.DELETED) {
                if (this.db.on()) {
                    this.db.println("PhantomLinkStateMachine.update: received DELETED event from InterfaceModel " + iObservable);
                }
                this.deregisterWithIM();
            }
        } else if (iObservable instanceof NetElement) {
            NetElement netElement = (NetElement)iObservable;
            if (object == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("PhantomLinkStateMachine.update: received CHANGED event from NE " + netElement.getHostName());
                }
                this.registerWithPM();
                this.registerWithIM();
            } else if (object == ModelUpdateType.DELETED) {
                if (this.db.on()) {
                    this.db.println("PhantomLinkStateMachine.update: received DELETED event from NE " + netElement.getHostName());
                }
                this.dispose();
            }
        }
    }
}

