/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoPathInfo;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathInfo;
import cerent.cms.model.IPoolModel;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.route.AbstractLabelSet;
import cerent.cms.route.DropPrefs;
import cerent.cms.route.HoLabelSet;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.LoLabelSet;
import cerent.cms.route.LotLabelSet;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.Topology;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import cerent.util.ILoNum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class RoutableNetLink
extends AbstractNetLink {
    protected int lotProtectionType;

    protected RoutableNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, Topology topology, int n) {
        super(network, iLinkModel, iNetElement, iNetElement2, bl, topology, n);
        if (this.db.on()) {
            this.db.println("Creating new RoutableNetLink");
        }
    }

    protected RoutableNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, Topology topology, int n, boolean bl, LinkedList linkedList, LinkedList linkedList2) {
        super(network, iLinkModel, iNetElement, iNetElement2, topology, n, false, linkedList, linkedList2);
    }

    public RoutableNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl) {
        super(network, iLinkModel, iNetElement, iNetElement2, bl);
    }

    public RoutableNetLink(INetElement iNetElement, INetElement iNetElement2) {
        super(iNetElement, iNetElement2);
    }

    public boolean isLotInMixedProtection() {
        return this.lotProtectionType == 3;
    }

    public boolean inBLSR() {
        return false;
    }

    public boolean isUsable(RoutePrefs routePrefs) throws xLinkNotUsable {
        if (this.db.on()) {
            this.db.println("isUsable: Link : " + this.prettyString());
        }
        Iterator iterator = this.getLinksList().iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink = (INetLink)iterator.next();
            if (iNetLink.state() != 1) {
                throw new xLinkNotUsable("Link is Not UP");
            }
            DropPrefs dropPrefs = routePrefs.getFwdDropPrefs();
            if (!dropPrefs.isCommonFiber()) {
                iNetLink.containsSrg(routePrefs.getExcludeSrgs());
            } else if (!routePrefs.getPreferredLinks().contains(this) && !routePrefs.getPreferredLinks().contains(iNetLink)) {
                iNetLink.containsSrg(routePrefs.getExcludeSrgs());
            }
            if (!iNetLink.getDst().getConnectionState()) {
                throw new xLinkNotUsable("DstLink is not in UP state");
            }
            if (!iNetLink.getSrc().getConnectionState()) {
                throw new xLinkNotUsable("SrcLink is not in UP state");
            }
            routePrefs.isUsable(this);
        }
        return true;
    }

    public boolean isRoutable() {
        return true;
    }

    public abstract boolean isBlsrCapable();

    public boolean availBW(RoutePrefs routePrefs) {
        DropPrefs dropPrefs = routePrefs.getFwdDropPrefs();
        if (dropPrefs.getMemberGroupPrefs().size() > 1 && dropPrefs.isCommonFiber()) {
            try {
                routePrefs.isUsable(this);
            }
            catch (xLinkNotUsable xLinkNotUsable2) {
                if (this.db.on()) {
                    this.db.println("availBW: " + xLinkNotUsable2.getString());
                }
                return false;
            }
        } else {
            MemberGroupPrefs memberGroupPrefs = dropPrefs.getFirstMemberGroupPrefs();
            INetLinkSpan[] iNetLinkSpanArray = this.getNAvailSpans(memberGroupPrefs.getMemberBandwidth(), routePrefs.getCircuitType(), memberGroupPrefs.getMemberCount());
            if (iNetLinkSpanArray == null || iNetLinkSpanArray.length < memberGroupPrefs.getMemberCount()) {
                if (this.db.on()) {
                    this.db.println("availBW: Returned false");
                }
                return false;
            }
        }
        return true;
    }

    private ILabelSet recalcLabelSetForLAP(ILabelSet iLabelSet) {
        LotLabelSet lotLabelSet = new LotLabelSet();
        if (iLabelSet == null) {
            return lotLabelSet;
        }
        Iterator iterator = iLabelSet.getLabelSet().iterator();
        if (!this.isLAP()) {
            return iLabelSet;
        }
        IHoNum iHoNum = !this.isSrcExtendable() ? this.getSrcHo() : this.getDstHo();
        while (iterator.hasNext()) {
            IHoLoNum iHoLoNum = (IHoLoNum)iterator.next();
            iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iHoLoNum.getLoNum());
            lotLabelSet.addLabel((ILabel)iHoLoNum);
        }
        if (this.db.on()) {
            this.db.println("recalcLabelSetForLAP: Returning " + lotLabelSet.size() + " Labels");
        }
        return lotLabelSet;
    }

    public ILabelSet getSrcLabelSet(int n, int n2) {
        if (this.db.on()) {
            this.db.println("getSrcLabelSet");
        }
        if (this.isLAP() && !this.isSrcExtendable()) {
            ILabelSet iLabelSet = this.getDstLabelSet(n, n2);
            return this.recalcLabelSetForLAP(iLabelSet);
        }
        if (!this.getSrc().getConnectionState()) {
            return null;
        }
        IPoolModel iPoolModel = this.getSrcPool();
        return this.getLabelSet(this.getSrc(), iPoolModel, n, n2, true);
    }

    public ILabelSet getDstLabelSet(int n, int n2) {
        if (this.db.on()) {
            this.db.println("getDstLabelSet");
        }
        if (this.isLAP() && !this.isDstExtendable()) {
            ILabelSet iLabelSet = this.getSrcLabelSet(n, n2);
            return this.recalcLabelSetForLAP(iLabelSet);
        }
        if (!this.getDst().getConnectionState()) {
            return null;
        }
        IPoolModel iPoolModel = this.getDstPool();
        return this.getLabelSet(this.getDst(), iPoolModel, n, n2, false);
    }

    protected ILabelSet getLabelSet(INetElement iNetElement, IPoolModel iPoolModel, int n, int n2, boolean bl) {
        Object object;
        Object object2;
        ILoPathInfo[] iLoPathInfoArray;
        Object object3;
        IHoNum iHoNum;
        Object object4;
        IConnectionModels iConnectionModels;
        AbstractLabelSet abstractLabelSet;
        short s;
        ICircuitType iCircuitType;
        boolean bl2;
        if (iPoolModel == null || iNetElement == null) {
            return null;
        }
        if (!iNetElement.canSupportCircuitSize(n)) {
            if (this.db.on()) {
                this.db.println("NE does not support circuit size");
            }
            return null;
        }
        if (this.db.on()) {
            this.db.println("getLabelSet: Link : " + this.prettyString());
        }
        if (this.db.on()) {
            this.db.println("getLabelSet: Pool entIdx => " + iPoolModel.getEntityIndex());
        }
        boolean bl3 = bl2 = (iCircuitType = CircuitType.getCircuitType((int)n2)).isLoCircuitType() || iCircuitType.isLoVcatCircuitType();
        if (bl2) {
            int n3 = RoutableNetLink.getLoTunnelSize(this.src.getNodeModel().getFramingType());
            s = CircuitSize.getCircuitSize((int)n3).size2widthOfHoCircuit();
            abstractLabelSet = this.isLOTunnel() || this.isLAP() ? new LotLabelSet() : new LoLabelSet();
        } else {
            s = CircuitSize.getCircuitSize((int)n).size2widthOfHoCircuit();
            abstractLabelSet = new HoLabelSet();
        }
        if (bl2) {
            INodeModel iNodeModel = iNetElement.getNodeModel();
            iConnectionModels = iNodeModel.getConnectionModels();
            object4 = RoutableNetLink.aditsWithCapacity(iConnectionModels.getLoAditsInPool(iPoolModel), CircuitSize.getCircuitSize((int)n));
            for (int i = 0; i < ((ILoAditModel[])object4).length; ++i) {
                iHoNum = RoutableNetLink.physicalHo((ILoAditModel)object4[i]);
                if (this.isLOTunnel() || this.isLAP()) {
                    if (!bl ? !iHoNum.equals(this.getDstHo()) : !iHoNum.equals(this.getSrcHo())) continue;
                    if (this.db.on()) {
                        this.db.println("getLabelSet: Lot Ho " + iHoNum);
                    }
                } else {
                    object3 = this.net.findLoTunnelNetLink(iNetElement, bl ? this.getDst() : this.getSrc(), bl ? this.getSrcEntityIndex() : this.getDstEntityIndex(), iHoNum);
                    if (object3 != null) continue;
                }
                short s2 = CircuitSize.getCircuitSize((int)n).size2widthOfLoCircuit();
                iLoPathInfoArray = object4[i].getAvailableLos((int)s2);
                object2 = RoutableNetLink.getAllLoNums(iLoPathInfoArray);
                if (this.db.on()) {
                    this.db.println("getLabelSet: Num Los " + object2.size());
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    ILoNum iLoNum = (ILoNum)object.next();
                    IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
                    abstractLabelSet.addLabel((ILabel)iHoLoNum);
                }
            }
        }
        if (this.getLinkType() == 1 || this.getLinkType() == 4 || this.getLinkType() == 3 || this.getLinkType() == 9) {
            IPathInfo[] iPathInfoArray = iPoolModel.getAvailablePaths(s);
            if (this.db.on()) {
                this.db.println("getLabelSet: obtained available paths for pathSize " + s);
                this.db.println("getLabelSet: paths.length = " + iPathInfoArray.length);
            }
            iConnectionModels = RoutableNetLink.getBaseHo(iPoolModel);
            object4 = RoutableNetLink.getAllHoNums(iPathInfoArray, (IHoNum)iConnectionModels);
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                iHoNum = (IHoNum)iterator.next();
                if (bl2) {
                    object3 = HoLoFactory.getAllLoNums(iHoNum.getFramingType(), n);
                    iLoPathInfoArray = object3.iterator();
                    while (iLoPathInfoArray.hasNext()) {
                        object2 = (ILoNum)iLoPathInfoArray.next();
                        object = HoLoFactory.createHoLoNum(iHoNum, (ILoNum)object2);
                        abstractLabelSet.addLabel((ILabel)object);
                    }
                    continue;
                }
                abstractLabelSet.addLabel((ILabel)iHoNum);
            }
        }
        if (this.db.on()) {
            this.db.println("getLabelSet: Returning " + abstractLabelSet.size() + " Labels");
        }
        return abstractLabelSet;
    }

    public List getAvailableHoNumbers(int n, int n2) {
        ArrayList arrayList = new ArrayList();
        this.getAvailableHoNumbers(arrayList, n, n2);
        return arrayList;
    }

    public void getAvailableHoNumbers(Collection collection, int n, int n2) {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        ILabelSet iLabelSet = this.getSrcLabelSet(n, n2);
        ILabelSet iLabelSet2 = this.getDstLabelSet(n, n2);
        iLabelSet.intersectSelf(iLabelSet2);
        Iterator iterator = iLabelSet.getLabelSet().iterator();
        while (iterator.hasNext()) {
            ILabel iLabel = (ILabel)iterator.next();
            if (iLabel instanceof IHoNum) {
                treeSet.add(iLabel);
                continue;
            }
            treeSet.add(((IHoLoNum)iLabel).getHoNum());
        }
        collection.addAll(treeSet);
    }

    private List getAvailLoAdits(ICircuitSize iCircuitSize) {
        ArrayList<IHoNum> arrayList = new ArrayList<IHoNum>();
        ILoAditModel[] iLoAditModelArray = this.getSrcLoAdits(iCircuitSize);
        ILoAditModel[] iLoAditModelArray2 = this.getDstLoAdits(iCircuitSize);
        Set<IHoNum> set = null;
        if (this.isLOTunnel()) {
            set = new TreeSet();
            if (RoutableNetLink.getAllHoNums(iLoAditModelArray).contains(this.getSrcHo()) && RoutableNetLink.getAllHoNums(iLoAditModelArray2).contains(this.getDstHo())) {
                set.add(this.getSrcHo());
            }
        } else if (this.isLAP()) {
            set = new TreeSet();
            if (this.isSrcExtendable()) {
                set.add(this.getSrcHo());
            } else if (this.isDstExtendable()) {
                set.add(this.getDstHo());
            }
        } else {
            set = RoutableNetLink.getCommonHoNums(iLoAditModelArray, iLoAditModelArray2);
        }
        if (!set.isEmpty()) {
            arrayList.addAll(set);
        }
        return arrayList;
    }

    protected ILoAditModel[] getSrcLoAdits(ICircuitSize iCircuitSize) {
        return this.getLoAdits(this.getSrc(), this.getSrcEntityIndex(), iCircuitSize);
    }

    protected ILoAditModel[] getSrcLoAdits() {
        return this.getSrcLoAdits(null);
    }

    protected ILoAditModel[] getDstLoAdits(ICircuitSize iCircuitSize) {
        return this.getLoAdits(this.getDst(), this.getDstEntityIndex(), iCircuitSize);
    }

    protected ILoAditModel[] getDstLoAdits() {
        return this.getDstLoAdits(null);
    }

    protected ILoAditModel[] getLoAdits(INetElement iNetElement, int n, ICircuitSize iCircuitSize) {
        INodeModel iNodeModel = iNetElement.getNodeModel();
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        IPoolModel iPoolModel = this.getPool(iNetElement, n);
        ILoAditModel[] iLoAditModelArray = RoutableNetLink.aditsWithCapacity(iConnectionModels.getLoAditsInPool(iPoolModel), iCircuitSize);
        if (iNodeModel.getFramingType() == 1) {
            ArrayList<ILoAditModel> arrayList = new ArrayList<ILoAditModel>();
            for (int i = 0; i < iLoAditModelArray.length; ++i) {
                ILoAditModel iLoAditModel = iLoAditModelArray[i];
                if (!(PortGrouping.getInstance().isInCreation() ^ !iLoAditModel.isReservedForPortGroup())) continue;
                arrayList.add(iLoAditModel);
            }
            if (arrayList.size() != iLoAditModelArray.length) {
                iLoAditModelArray = arrayList.toArray(new ILoAditModel[0]);
            }
        }
        return iLoAditModelArray;
    }

    public void getAvailableLoNumbers(Collection collection, IHoNum iHoNum, int n) {
        collection.addAll(this.getAvailableLoNumbers(iHoNum, n));
    }

    public List getAvailableLoNumbers(IHoNum iHoNum, int n) {
        return this.getAvailLoNums(iHoNum, false, n);
    }

    public List getAvailLoNums(IHoNum iHoNum, boolean bl, int n) {
        Set set;
        IPoolModel iPoolModel;
        ILoPathInfo[] iLoPathInfoArray;
        short s;
        IHoNum iHoNum2;
        ArrayList arrayList = new ArrayList();
        boolean bl2 = false;
        IHoNum iHoNum3 = iHoNum2 = iHoNum;
        if (this.db.on()) {
            this.db.println("getAvailLoNums: looking at link " + this.prettyString() + "srcExtensible = " + this.isSrcExtendable() + " dstExtensible " + this.isDstExtendable());
        }
        if (this.isLOTunnel() || this.isLAP()) {
            if (bl) {
                if (this.db.on()) {
                    this.db.println("getAvailLoNums: Tunnel is not a valid link");
                }
                return arrayList;
            }
            iHoNum3 = this.getSrcHo();
            iHoNum2 = this.getDstHo();
        }
        ILoAditModel[] iLoAditModelArray = this.getSrcLoAdits();
        ILoAditModel[] iLoAditModelArray2 = this.getDstLoAdits();
        ILoAditModel iLoAditModel = (ILoAditModel)RoutableNetLink.linearSearch(iLoAditModelArray, iHoNum3, AditComparator.instance());
        ILoAditModel iLoAditModel2 = (ILoAditModel)RoutableNetLink.linearSearch(iLoAditModelArray2, iHoNum2, AditComparator.instance());
        if (this.isLAP()) {
            s = CircuitSize.getCircuitSize((int)n).size2widthOfLoCircuit();
            if (this.isSrcExtendable()) {
                iLoPathInfoArray = iLoAditModel.getAvailableLos((int)s);
                arrayList.addAll(RoutableNetLink.getAllLoNums(iLoPathInfoArray));
            } else if (this.isDstExtendable()) {
                iPoolModel = iLoAditModel2.getAvailableLos((int)s);
                arrayList.addAll(RoutableNetLink.getAllLoNums((ILoPathInfo[])iPoolModel));
            }
            if (!arrayList.isEmpty()) {
                if (this.db.on()) {
                    this.db.println("getAvailLoNums: " + arrayList.size() + " Lo Numbers are available");
                }
                bl2 = true;
            }
        }
        if (iLoAditModel != null && iLoAditModel2 != null && (set = RoutableNetLink.getCommonLoNums(iLoPathInfoArray = iLoAditModel.getAvailableLos((int)(s = CircuitSize.getCircuitSize((int)n).size2widthOfLoCircuit())), (ILoPathInfo[])(iPoolModel = iLoAditModel2.getAvailableLos((int)s)))) != null) {
            arrayList.addAll(set);
            if (this.db.on()) {
                this.db.println("getAvailLoNums: " + set.size() + " Lo Numbers are available");
            }
            bl2 = true;
        }
        if (!bl2) {
            int n2 = CircuitSize.getLoTunnelSize((int)this.src.getNodeModel().getFramingType()).getEnum();
            s = CircuitSize.getCircuitSize((int)n2).size2widthOfHoCircuit();
            iPoolModel = this.getSrcPool();
            set = this.getDstPool();
            IPathInfo[] iPathInfoArray = iPoolModel.getAvailablePaths(s);
            IPathInfo[] iPathInfoArray2 = set.getAvailablePaths(s);
            if (this.getLinkType() == 1 || this.getLinkType() == 3 || this.getLinkType() == 9) {
                ILoPathInfo[] iLoPathInfoArray2;
                Set set2;
                IPathInfo iPathInfo = (IPathInfo)RoutableNetLink.linearSearch(iPathInfoArray, iHoNum, new PathInfoComparator(iPoolModel));
                IPathInfo iPathInfo2 = (IPathInfo)RoutableNetLink.linearSearch(iPathInfoArray2, iHoNum, new PathInfoComparator((IPoolModel)set));
                if (iPathInfo != null && iPathInfo2 != null) {
                    arrayList.addAll(HoLoFactory.getAllLoNums(iHoNum.getFramingType(), n));
                }
                if (iLoAditModel != null && iPathInfo2 != null && (set2 = RoutableNetLink.getAllLoNums(iLoPathInfoArray2 = iLoAditModel.getAvailableLos((int)(s = CircuitSize.getCircuitSize((int)n).size2widthOfLoCircuit())))) != null) {
                    arrayList.addAll(set2);
                }
                if (iPathInfo != null && iLoAditModel2 != null && (set2 = RoutableNetLink.getAllLoNums(iLoPathInfoArray2 = iLoAditModel2.getAvailableLos((int)(s = CircuitSize.getCircuitSize((int)n).size2widthOfLoCircuit())))) != null) {
                    arrayList.addAll(set2);
                }
            }
        }
        if (this.db.on()) {
            this.db.println("getAvailLoNums: returning " + arrayList.size() + " Lo Numbers");
        }
        return arrayList;
    }

    private static class PathInfoComparator
    implements Comparator {
        IHoNum baseHo;

        public PathInfoComparator(IHoNum iHoNum) {
            this.baseHo = iHoNum;
        }

        public PathInfoComparator(IPoolModel iPoolModel) {
            this(AbstractNetLink.getBaseHo(iPoolModel));
        }

        public int compare(Object object, Object object2) {
            IHoNum iHoNum = object instanceof IPathInfo ? AbstractNetLink.physicalHo(this.baseHo, (IPathInfo)object) : (IHoNum)object;
            IHoNum iHoNum2 = object2 instanceof IPathInfo ? AbstractNetLink.physicalHo(this.baseHo, (IPathInfo)object2) : (IHoNum)object2;
            return AbstractNetLink.holoComp.compare(iHoNum, iHoNum2);
        }

        public boolean equals(Object object) {
            return object instanceof PathInfoComparator;
        }
    }

    private static class AditComparator
    implements Comparator {
        static AditComparator instance_ = new AditComparator();

        private AditComparator() {
        }

        static AditComparator instance() {
            return instance_;
        }

        public int compare(Object object, Object object2) {
            IHoNum iHoNum = object instanceof ILoAditModel ? AbstractNetLink.physicalHo((ILoAditModel)object) : (IHoNum)object;
            IHoNum iHoNum2 = object2 instanceof ILoAditModel ? AbstractNetLink.physicalHo((ILoAditModel)object2) : (IHoNum)object2;
            return AbstractNetLink.holoComp.compare(iHoNum, iHoNum2);
        }

        public boolean equals(Object object) {
            return object instanceof AditComparator;
        }
    }

    protected static interface ILotProtectionType {
        public static final int LOT_PROTECTION_UNDEFINED = 0;
        public static final int LOT_UNPROTECTED = 1;
        public static final int LOT_PROTECTED = 2;
        public static final int LOT_MIXED_PROTECTION = 3;
    }
}

