/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.CircuitId;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.FramingType;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFramingType;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoServerTrailEnd;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoServerTrailEnd;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IServerTrailEnd;
import cerent.cms.model.IServerTrailLinkId;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ServerTrailPrefs {
    private INetElement source;
    private INetElement dest;
    private int srcEntityIndex;
    private ILabel srcPoolStart;
    private ILabel srcPoolEnd;
    private int destEntityIndex;
    private ILabel destPoolStart;
    private ILabel destPoolEnd;
    private int physicalLinkType;
    private ICircuitSize trailCktSize;
    private ICircuitType trailCktType;
    private int idlProtType;
    private int protType;
    private String srlg;
    private int cost;
    private boolean isLoTrail;
    private int Nx;
    private IServerTrailLinkId svId;
    private boolean discovered;
    private static final SDebug db = new SDebug("ServerTrail");
    private static final HoLoComparator hoLoComp = HoLoComparator.instance();

    public ServerTrailPrefs() {
        if (db.on()) {
            db.println("Creating a new ServerTrailPrefs");
        }
        this.initPrefs();
    }

    public ServerTrailPrefs(ServerTrailPrefs serverTrailPrefs) {
        this.source = serverTrailPrefs.getSrc();
        this.dest = serverTrailPrefs.getDest();
        this.srcEntityIndex = serverTrailPrefs.getSrcEntity();
        this.srcPoolStart = serverTrailPrefs.getSrcPoolStart();
        this.srcPoolEnd = serverTrailPrefs.getSrcPoolEnd();
        this.destEntityIndex = serverTrailPrefs.getDestEntity();
        this.destPoolStart = serverTrailPrefs.getDestPoolStart();
        this.destPoolEnd = serverTrailPrefs.getDestPoolEnd();
        this.physicalLinkType = serverTrailPrefs.getPhyLinkType();
        this.trailCktSize = serverTrailPrefs.getCircuitSize();
        this.trailCktType = serverTrailPrefs.getCircuitType();
        this.idlProtType = serverTrailPrefs.getIdlProtectionType();
        this.protType = serverTrailPrefs.getProtectionType();
        this.srlg = serverTrailPrefs.getSrlg();
        this.cost = serverTrailPrefs.getCost();
        this.isLoTrail = serverTrailPrefs.isLoTrail();
        this.Nx = serverTrailPrefs.getNx();
        this.svId = serverTrailPrefs.getTrailId();
        this.discovered = serverTrailPrefs.isDiscovered();
    }

    public ServerTrailPrefs(ServerTrailPrefs serverTrailPrefs, boolean bl) {
        if (bl) {
            this.source = serverTrailPrefs.getDest();
            this.dest = serverTrailPrefs.getSrc();
            this.srcEntityIndex = serverTrailPrefs.getDestEntity();
            this.srcPoolStart = serverTrailPrefs.getDestPoolStart();
            this.srcPoolEnd = serverTrailPrefs.getDestPoolEnd();
            this.destEntityIndex = serverTrailPrefs.getSrcEntity();
            this.destPoolStart = serverTrailPrefs.getSrcPoolStart();
            this.destPoolEnd = serverTrailPrefs.getSrcPoolEnd();
            this.physicalLinkType = serverTrailPrefs.getPhyLinkType();
            this.trailCktSize = serverTrailPrefs.getCircuitSize();
            this.trailCktType = serverTrailPrefs.getCircuitType();
            this.idlProtType = serverTrailPrefs.getIdlProtectionType();
            this.protType = serverTrailPrefs.getProtectionType();
            this.srlg = serverTrailPrefs.getSrlg();
            this.cost = serverTrailPrefs.getCost();
            this.isLoTrail = serverTrailPrefs.isLoTrail();
            this.Nx = serverTrailPrefs.getNx();
            this.svId = serverTrailPrefs.getTrailId();
            this.discovered = serverTrailPrefs.isDiscovered();
        } else {
            this.source = serverTrailPrefs.getSrc();
            this.dest = serverTrailPrefs.getDest();
            this.srcEntityIndex = serverTrailPrefs.getSrcEntity();
            this.srcPoolStart = serverTrailPrefs.getSrcPoolStart();
            this.srcPoolEnd = serverTrailPrefs.getSrcPoolEnd();
            this.destEntityIndex = serverTrailPrefs.getDestEntity();
            this.destPoolStart = serverTrailPrefs.getDestPoolStart();
            this.destPoolEnd = serverTrailPrefs.getDestPoolEnd();
            this.physicalLinkType = serverTrailPrefs.getPhyLinkType();
            this.trailCktSize = serverTrailPrefs.getCircuitSize();
            this.trailCktType = serverTrailPrefs.getCircuitType();
            this.idlProtType = serverTrailPrefs.getIdlProtectionType();
            this.protType = serverTrailPrefs.getProtectionType();
            this.srlg = serverTrailPrefs.getSrlg();
            this.cost = serverTrailPrefs.getCost();
            this.isLoTrail = serverTrailPrefs.isLoTrail();
            this.Nx = serverTrailPrefs.getNx();
            this.svId = serverTrailPrefs.getTrailId();
            this.discovered = serverTrailPrefs.isDiscovered();
        }
    }

    public void initPrefs() {
        this.source = null;
        this.dest = null;
        this.srcPoolStart = null;
        this.srcPoolEnd = null;
        this.destPoolStart = null;
        this.destPoolEnd = null;
        this.trailCktSize = null;
        this.trailCktType = null;
        this.Nx = 0;
        this.srlg = "";
        this.isLoTrail = false;
        this.svId = null;
        this.discovered = false;
    }

    public boolean equals(ServerTrailPrefs serverTrailPrefs) {
        if (this.source.equals(serverTrailPrefs.getSrc()) && this.srcEntityIndex == serverTrailPrefs.getSrcEntity() && (this.getSrcPoolStart() instanceof IHoNum && serverTrailPrefs.getSrcPoolStart() instanceof IHoNum && ((IHoNum)this.getSrcPoolStart()).equals((IHoNum)serverTrailPrefs.getSrcPoolStart()) || this.getSrcPoolStart() instanceof IHoLoNum && serverTrailPrefs.getSrcPoolStart() instanceof IHoLoNum && ((IHoLoNum)this.getSrcPoolStart()).equals((IHoLoNum)serverTrailPrefs.getSrcPoolStart()))) {
            return true;
        }
        return this.source.equals(serverTrailPrefs.getDest()) && this.srcEntityIndex == serverTrailPrefs.getDestEntity() && (this.getDestPoolStart() instanceof IHoNum && serverTrailPrefs.getDestPoolStart() instanceof IHoNum && ((IHoNum)this.getDestPoolStart()).equals((IHoNum)serverTrailPrefs.getDestPoolStart()) || this.getDestPoolStart() instanceof IHoLoNum && serverTrailPrefs.getDestPoolStart() instanceof IHoLoNum && ((IHoLoNum)this.getDestPoolStart()).equals((IHoLoNum)serverTrailPrefs.getDestPoolStart()));
    }

    public void setSrc(INetElement iNetElement) {
        this.source = iNetElement;
    }

    public INetElement getSrc() {
        return this.source;
    }

    public void setSrcEntity(int n) {
        this.srcEntityIndex = n;
    }

    public int getSrcEntity() {
        return this.srcEntityIndex;
    }

    public void setSrcPoolStart(ILabel iLabel) {
        if (iLabel instanceof IHoLoNum && ((IHoLoNum)iLabel).getLoNum() == null) {
            this.srcPoolStart = ((IHoLoNum)iLabel).getHoNum();
            return;
        }
        this.srcPoolStart = iLabel;
    }

    public ILabel getSrcPoolStart() {
        return this.srcPoolStart;
    }

    public void setSrcPoolEnd(ILabel iLabel) {
        if (iLabel instanceof IHoLoNum && ((IHoLoNum)iLabel).getLoNum() == null) {
            this.srcPoolEnd = ((IHoLoNum)iLabel).getHoNum();
            return;
        }
        this.srcPoolEnd = iLabel;
    }

    public ILabel getSrcPoolEnd() {
        return this.srcPoolEnd;
    }

    public void setDest(INetElement iNetElement) {
        this.dest = iNetElement;
    }

    public INetElement getDest() {
        return this.dest;
    }

    public void setDestEntity(int n) {
        this.destEntityIndex = n;
    }

    public int getDestEntity() {
        return this.destEntityIndex;
    }

    public void setDestPoolStart(ILabel iLabel) {
        if (iLabel instanceof IHoLoNum && ((IHoLoNum)iLabel).getLoNum() == null) {
            this.destPoolStart = ((IHoLoNum)iLabel).getHoNum();
            return;
        }
        this.destPoolStart = iLabel;
    }

    public ILabel getDestPoolStart() {
        return this.destPoolStart;
    }

    public void setDestPoolEnd(ILabel iLabel) {
        if (iLabel instanceof IHoLoNum && ((IHoLoNum)iLabel).getLoNum() == null) {
            this.destPoolEnd = ((IHoLoNum)iLabel).getHoNum();
            return;
        }
        this.destPoolEnd = iLabel;
    }

    public ILabel getDestPoolEnd() {
        return this.destPoolEnd;
    }

    public void setPhyLinkType(int n) {
        this.physicalLinkType = n;
    }

    public int getPhyLinkType() {
        return this.physicalLinkType;
    }

    public void setCircuitSize(ICircuitSize iCircuitSize) {
        this.trailCktSize = iCircuitSize;
    }

    public ICircuitSize getCircuitSize() {
        return this.trailCktSize;
    }

    public void setCircuitType(ICircuitType iCircuitType) {
        this.trailCktType = iCircuitType;
    }

    public void discoverCircuitType() {
        if (this.trailCktSize == null || this.source == null) {
            return;
        }
        int n = this.source.getNodeModel().getFramingType();
        boolean bl = this.trailCktSize.isLo(n);
        this.trailCktType = this.trailCktSize.isSonetTerminationSize() ? (bl ? CircuitType.getCircuitType((int)2) : CircuitType.getCircuitType((int)1)) : (bl ? CircuitType.getCircuitType((int)5) : CircuitType.getCircuitType((int)4));
    }

    public ICircuitType getCircuitType() {
        return this.trailCktType;
    }

    public void setProtectionType(int n) {
        this.protType = n == 0 ? 13 : (n == 1 ? 3 : (n == 2 ? 10 : 16));
        this.idlProtType = n;
    }

    public int getProtectionType() {
        return this.protType;
    }

    public int getIdlProtectionType() {
        return this.idlProtType;
    }

    public void setSrlg(String string) {
        this.srlg = string;
    }

    public String getSrlg() {
        return this.srlg;
    }

    public void setCost(int n) {
        this.cost = n;
    }

    public int getCost() {
        return this.cost;
    }

    public void setLoTrail() {
        if (this.getSrc() != null) {
            this.isLoTrail = false;
            INodeModel iNodeModel = this.getSrc().getNodeModel();
            int n = iNodeModel.getFramingType();
            this.isLoTrail = this.getCircuitSize().isLo(n);
        } else {
            this.isLoTrail = true;
        }
    }

    public void resetLoTrail() {
        this.isLoTrail = false;
    }

    public boolean isLoTrail() {
        return this.isLoTrail;
    }

    public void setNx(int n) {
        this.Nx = n;
    }

    public int getNx() {
        return this.Nx;
    }

    public void calculateNx(ILabel iLabel, ILabel iLabel2) {
        ICircuitSize iCircuitSize = this.getCircuitSize();
        if (iLabel instanceof IHoNum && iLabel2 instanceof IHoNum) {
            IHoNum iHoNum = (IHoNum)iLabel;
            IHoNum iHoNum2 = (IHoNum)iLabel2;
            IHoNum iHoNum3 = iHoNum;
            int n = 0;
            while (iHoNum3.getHoNum() <= iHoNum2.getHoNum()) {
                ++n;
                if (iHoNum3.equals(iHoNum2)) {
                    if (db.on()) {
                        db.println("For Ho Trail startHo = " + iHoNum.prettyString() + " endHo = " + iHoNum2.prettyString() + " cktSize = " + iCircuitSize.getCircuitSizeString() + " Nx = " + n);
                    }
                    this.setNx(n);
                    return;
                }
                iHoNum3 = HoLoFactory.addOffset(iHoNum3, iCircuitSize);
            }
            if (db.on()) {
                db.println("ERROR getting Nx for HoTrail startHo = " + iHoNum.prettyString() + " endHo = " + iHoNum2.prettyString() + " cktSize = " + iCircuitSize.getCircuitSizeString() + " Nx = " + n);
            }
        } else if (iLabel instanceof IHoLoNum && iLabel2 instanceof IHoLoNum) {
            IHoLoNum iHoLoNum = (IHoLoNum)iLabel;
            IHoLoNum iHoLoNum2 = (IHoLoNum)iLabel2;
            IHoLoNum iHoLoNum3 = iHoLoNum;
            int n = 0;
            while (iHoLoNum3.getHoNum().getHoNum() <= iHoLoNum2.getHoNum().getHoNum()) {
                ++n;
                if (iHoLoNum3.equals(iHoLoNum2)) {
                    if (db.on()) {
                        db.println("For Lo Trail startHoLo = " + iHoLoNum.prettyString(":") + " endHoLo = " + iHoLoNum2.prettyString(":") + " cktSize " + iCircuitSize.getCircuitSizeString() + " Nx = " + n);
                    }
                    this.setNx(n);
                    return;
                }
                iHoLoNum3 = HoLoFactory.addNeBasedOffset(iHoLoNum3, 1);
            }
            if (db.on()) {
                db.println("ERROR getting Nx for LoTrail startHoLo = " + iHoLoNum.prettyString(":") + " endHoLo = " + iHoLoNum2.prettyString(":") + " cktSize = " + iCircuitSize.getCircuitSizeString() + " Nx = " + n);
            }
        }
    }

    protected void setPoolEnds() {
        this.setLoTrail();
        ILabel iLabel = this.getSrcPoolStart();
        ILabel iLabel2 = this.getDestPoolStart();
        int n = this.getNx();
        ICircuitSize iCircuitSize = this.getCircuitSize();
        if (this.isLoTrail()) {
            IHoLoNum iHoLoNum = (IHoLoNum)iLabel;
            IHoLoNum iHoLoNum2 = (IHoLoNum)iLabel2;
            IHoLoNum iHoLoNum3 = (IHoLoNum)iLabel;
            IHoLoNum iHoLoNum4 = (IHoLoNum)iLabel2;
            if (n > 1) {
                iHoLoNum3 = HoLoFactory.addNeBasedOffset(iHoLoNum, n - 1);
                iHoLoNum4 = HoLoFactory.addNeBasedOffset(iHoLoNum2, n - 1);
            }
            this.setSrcPoolEnd((ILabel)iHoLoNum3);
            this.setDestPoolEnd((ILabel)iHoLoNum4);
        } else {
            short s = iCircuitSize.size2widthOfHoCircuit();
            IHoNum iHoNum = (IHoNum)this.getSrcPoolStart();
            IHoNum iHoNum2 = (IHoNum)this.getDestPoolStart();
            INodeModel iNodeModel = this.getSrc().getNodeModel();
            int n2 = iNodeModel.getFramingType();
            IFramingType iFramingType = FramingType.getFramingType((int)n2);
            int n3 = iFramingType.getFramingTypeHoPathWidth((int)s);
            int n4 = n * n3 - 1;
            IHoNum iHoNum3 = HoLoFactory.addOffset(iHoNum, n4);
            IHoNum iHoNum4 = HoLoFactory.addOffset(iHoNum2, n4);
            this.setSrcPoolEnd((ILabel)iHoNum3);
            this.setDestPoolEnd((ILabel)iHoNum4);
        }
    }

    public List getCktEnds(INetElement iNetElement) {
        IEntityModel iEntityModel;
        boolean bl;
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNetElement.equals(this.source)) {
            bl = true;
        } else if (iNetElement.equals(this.dest)) {
            bl = false;
        } else {
            return linkedList;
        }
        try {
            iEntityModel = bl ? iNodeModel.getEntityTable().getEntityModelByIndex(this.srcEntityIndex) : iNodeModel.getEntityTable().getEntityModelByIndex(this.destEntityIndex);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (ServerTrailPrefs.db.on) {
                db.println("Error getting EntityModel");
            }
            return linkedList;
        }
        if (this.isLoTrail()) {
            LoCircuitEnd loCircuitEnd = NetCircuitManager.instance().getAutoAssignedLoCktEnd(iNodeModel, iEntityModel);
            if (loCircuitEnd == null) {
                IHoLoNum iHoLoNum = bl ? (IHoLoNum)this.getSrcPoolStart() : (IHoLoNum)this.getDestPoolStart();
                for (int i = 0; i < this.getNx(); ++i) {
                    IHoLoNum iHoLoNum2 = HoLoFactory.addNeBasedOffset(iHoLoNum, i);
                    loCircuitEnd = new LoCircuitEnd(iNodeModel, iEntityModel, iHoLoNum2.getHoNum(), iHoLoNum2.getLoNum(), false);
                    linkedList.add(loCircuitEnd);
                }
            } else {
                linkedList.add(loCircuitEnd);
            }
        } else {
            HoCircuitEnd hoCircuitEnd = NetCircuitManager.instance().getAutoAssignedHoCktEnd(iNodeModel, iEntityModel);
            if (hoCircuitEnd == null) {
                IHoNum iHoNum = bl ? (IHoNum)this.getSrcPoolStart() : (IHoNum)this.getDestPoolStart();
                ICircuitSize iCircuitSize = this.getCircuitSize();
                short s = iCircuitSize.size2widthOfHoCircuit();
                int n = iNodeModel.getFramingType();
                IFramingType iFramingType = FramingType.getFramingType((int)n);
                int n2 = iFramingType.getFramingTypeHoPathWidth((int)s);
                for (int i = 0; i < this.getNx(); ++i) {
                    IHoNum iHoNum2 = HoLoFactory.addOffset(iHoNum, i * n2);
                    hoCircuitEnd = new HoCircuitEnd(iNodeModel, iEntityModel, iHoNum2, null, false);
                    linkedList.add(hoCircuitEnd);
                }
            } else {
                linkedList.add(hoCircuitEnd);
            }
        }
        return linkedList;
    }

    protected IHoNum getSrcEndHoNum() {
        ILabel iLabel = this.getSrcPoolEnd();
        if (this.isLoTrail()) {
            return ((IHoLoNum)iLabel).getHoNum();
        }
        return (IHoNum)iLabel;
    }

    protected IHoNum getDstEndHoNum() {
        ILabel iLabel = this.getDestPoolEnd();
        if (this.isLoTrail()) {
            return ((IHoLoNum)iLabel).getHoNum();
        }
        return (IHoNum)iLabel;
    }

    protected IHoNum getSrcStartHoNum() {
        ILabel iLabel = this.getSrcPoolStart();
        if (iLabel instanceof IHoNum) {
            return (IHoNum)iLabel;
        }
        if (iLabel instanceof IHoLoNum) {
            return ((IHoLoNum)iLabel).getHoNum();
        }
        return null;
    }

    protected IHoNum getDstStartHoNum() {
        ILabel iLabel = this.getDestPoolStart();
        if (iLabel instanceof IHoNum) {
            return (IHoNum)iLabel;
        }
        if (iLabel instanceof IHoLoNum) {
            return ((IHoLoNum)iLabel).getHoNum();
        }
        return null;
    }

    protected boolean validateTrailCktEnds() {
        NetCircuitEnd netCircuitEnd;
        IEntityModel iEntityModel = null;
        IEntityModel iEntityModel2 = null;
        INodeModel iNodeModel = this.getSrc().getNodeModel();
        INodeModel iNodeModel2 = this.getDest().getNodeModel();
        try {
            iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(this.srcEntityIndex);
            iEntityModel2 = iNodeModel2.getEntityTable().getEntityModelByIndex(this.destEntityIndex);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (db.on()) {
                db.println("ServerTrailPrefs: Src or Dst entity index invalid");
            }
            return false;
        }
        List list = Network.instance().getAvailServerTrailPoints(iNodeModel, iEntityModel, this);
        List list2 = this.getCktEnds(this.getSrc());
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (list.contains(netCircuitEnd)) continue;
            if (db.on()) {
                db.println("SvTrail srcCktEnd not available " + netCircuitEnd.prettyString());
            }
            return false;
        }
        List list3 = Network.instance().getAvailServerTrailPoints(iNodeModel2, iEntityModel2, this);
        List list4 = this.getCktEnds(this.getDest());
        iterator = list4.iterator();
        while (iterator.hasNext()) {
            netCircuitEnd = (NetCircuitEnd)iterator.next();
            if (list3.contains(netCircuitEnd)) continue;
            if (db.on()) {
                db.println("SvTrail dstCktEnd not available " + netCircuitEnd.prettyString());
            }
            return false;
        }
        return true;
    }

    protected boolean validateLoNums() {
        ILoNum iLoNum;
        ILoNum iLoNum2;
        return !(this.srcPoolStart instanceof IHoLoNum) || !(this.destPoolStart instanceof IHoLoNum) || hoLoComp.compare(iLoNum2 = ((IHoLoNum)this.srcPoolStart).getLoNum(), iLoNum = ((IHoLoNum)this.destPoolStart).getLoNum()) == 0;
    }

    public IHoNum getDstHo(IHoNum iHoNum) {
        if (this.isLoTrail()) {
            return null;
        }
        IHoNum iHoNum2 = (IHoNum)this.getSrcPoolStart();
        IHoNum iHoNum3 = (IHoNum)this.getDestPoolStart();
        IHoNum iHoNum4 = null;
        int n = 0;
        for (int i = 0; i < this.getNx(); ++i) {
            iHoNum4 = HoLoFactory.addOffset(iHoNum2, i);
            if (hoLoComp.compare(iHoNum, iHoNum4) != 0) continue;
            n = i;
            break;
        }
        return HoLoFactory.addOffset(iHoNum3, n);
    }

    public IHoLoNum getDstHoLo(IHoNum iHoNum, ILoNum iLoNum) {
        if (!this.isLoTrail()) {
            return null;
        }
        IHoLoNum iHoLoNum = (IHoLoNum)this.getSrcPoolStart();
        IHoLoNum iHoLoNum2 = (IHoLoNum)this.getDestPoolStart();
        IHoLoNum iHoLoNum3 = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
        IHoLoNum iHoLoNum4 = null;
        int n = 0;
        for (int i = 0; i < this.getNx(); ++i) {
            iHoLoNum4 = HoLoFactory.addNeBasedOffset(iHoLoNum, i);
            if (hoLoComp.compare(iHoLoNum3, iHoLoNum4) != 0) continue;
            n = i;
            break;
        }
        return HoLoFactory.addNeBasedOffset(iHoLoNum2, n);
    }

    public boolean isValidHoLoNum(IHoNum iHoNum, ILoNum iLoNum, boolean bl) {
        if (!this.isLoTrail()) {
            return false;
        }
        IHoLoNum iHoLoNum = bl ? (IHoLoNum)this.getSrcPoolStart() : (IHoLoNum)this.getDestPoolStart();
        IHoLoNum iHoLoNum2 = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
        IHoLoNum iHoLoNum3 = iHoLoNum;
        for (int i = 0; i < this.getNx(); ++i) {
            if (hoLoComp.compare(iHoLoNum2, iHoLoNum3) == 0) {
                return true;
            }
            iHoLoNum3 = HoLoFactory.addNeBasedOffset(iHoLoNum, i);
        }
        return false;
    }

    protected List getAllLoLabels(ICircuitSize iCircuitSize, INetElement iNetElement) {
        LinkedList<IHoLoNum> linkedList = new LinkedList<IHoLoNum>();
        int n = this.getSrc().getNodeModel().getFramingType();
        boolean bl = false;
        bl = iNetElement.equals(this.getSrc());
        if (this.isLoTrail()) {
            IHoLoNum iHoLoNum = null;
            IHoLoNum iHoLoNum2 = null;
            iHoLoNum = bl ? (IHoLoNum)this.getSrcPoolStart() : (IHoLoNum)this.getDestPoolStart();
            if (iCircuitSize.getEnum() == this.getCircuitSize().getEnum()) {
                linkedList.add(iHoLoNum);
                for (int i = 1; i < this.getNx(); ++i) {
                    iHoLoNum2 = HoLoFactory.addNeBasedOffset(iHoLoNum, i);
                    if (iHoLoNum2 == null) continue;
                    linkedList.add(iHoLoNum2);
                }
                if (db.on()) {
                    db.println("SvTrPrefs: Returning " + linkedList.size() + " loLabels " + this.prettyString());
                }
            } else if (iCircuitSize.getEnum() == 10 && this.getCircuitSize().getEnum() == 11) {
                for (int i = 0; i < this.getNx(); ++i) {
                    iHoLoNum2 = HoLoFactory.addNeBasedOffset(iHoLoNum, i);
                    short s = iHoLoNum2.getLoNum().getVc3OrSts1();
                    IHoNum iHoNum = iHoLoNum2.getHoNum();
                    ILoNum iLoNum = HoLoFactory.idlVtStruct2LoNum(n, 10, s, 1, 1);
                    IHoLoNum iHoLoNum3 = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
                    IHoLoNum iHoLoNum4 = null;
                    for (int j = 0; j < 21; ++j) {
                        iHoLoNum4 = HoLoFactory.addNeBasedOffset(iHoLoNum3, j);
                        if (iHoLoNum4 == null) continue;
                        linkedList.add(iHoLoNum4);
                    }
                }
                if (db.on()) {
                    db.println("SvTrPrefs: Returning " + linkedList.size() + " VC12-loLabels in link " + this.prettyString());
                }
            } else if (iCircuitSize.getEnum() == 11 && this.getCircuitSize().getEnum() == 10) {
                for (int i = 0; i < this.getNx(); ++i) {
                    ILoNum iLoNum;
                    iHoLoNum2 = HoLoFactory.addNeBasedOffset(iHoLoNum, i);
                    short s = iHoLoNum2.getLoNum().getVc3OrSts1();
                    IHoNum iHoNum = iHoLoNum2.getHoNum();
                    IHoLoNum iHoLoNum5 = HoLoFactory.createHoLoNum(iHoNum, iLoNum = HoLoFactory.idlVtStruct2LoNum(n, 11, s, 1, 1));
                    if (linkedList.contains(iHoLoNum5)) continue;
                    linkedList.add(iHoLoNum5);
                }
                if (db.on()) {
                    db.println("SvTrPrefs: Returning " + linkedList.size() + " VC3-loLabels in ServerTrailPrefs " + this.prettyString());
                }
            }
        } else {
            IHoNum iHoNum = null;
            IHoNum iHoNum2 = null;
            iHoNum = bl ? (IHoNum)this.getSrcPoolStart() : (IHoNum)this.getDestPoolStart();
            for (int i = 0; i < this.getNx(); ++i) {
                iHoNum2 = HoLoFactory.addOffset(iHoNum, i);
                List list = HoLoFactory.getAllLoNums(n, iCircuitSize.getEnum());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ILoNum iLoNum = (ILoNum)iterator.next();
                    IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum2, iLoNum);
                    linkedList.add(iHoLoNum);
                }
            }
            if (db.on()) {
                db.println("SvTrPrefs: Returning " + linkedList.size() + " LoLabels of type " + iCircuitSize.getCircuitSizeString() + " in prefs " + this.prettyString());
            }
        }
        return linkedList;
    }

    protected static List getAllLoLabels(ICircuitSize iCircuitSize, IServerTrailEnd iServerTrailEnd) {
        LinkedList<IHoLoNum> linkedList = new LinkedList<IHoLoNum>();
        boolean bl = false;
        if (iServerTrailEnd instanceof ILoServerTrailEnd) {
            ILoServerTrailEnd iLoServerTrailEnd = (ILoServerTrailEnd)iServerTrailEnd;
            int n = iLoServerTrailEnd.getTrailStart().getLoAdit().getHo().getNodeModel().getFramingType();
            IHoNum iHoNum = null;
            ILoNum iLoNum = null;
            IHoLoNum iHoLoNum = null;
            iHoNum = iLoServerTrailEnd.getTrailStart().getLoAdit().getHo().getStartingHo();
            iLoNum = iLoServerTrailEnd.getTrailStart().getLoNum();
            iHoLoNum = HoLoFactory.createHoLoNum(iHoNum, iLoNum);
            IHoNum iHoNum2 = null;
            ILoNum iLoNum2 = null;
            IHoLoNum iHoLoNum2 = null;
            IHoLoNum iHoLoNum3 = null;
            iHoNum2 = iLoServerTrailEnd.getTrailEnd().getLoAdit().getHo().getStartingHo();
            iLoNum2 = iLoServerTrailEnd.getTrailEnd().getLoNum();
            iHoLoNum2 = HoLoFactory.createHoLoNum(iHoNum2, iLoNum2);
            if (iCircuitSize.getEnum() == iServerTrailEnd.getTrailSize()) {
                linkedList.add(iHoLoNum);
                iHoLoNum3 = iHoLoNum;
                while (!iHoLoNum3.equals(iHoLoNum2)) {
                    if ((iHoLoNum3 = HoLoFactory.addNeBasedOffset(iHoLoNum3, 1)) == null || iHoLoNum3.getHoNum().getHoNum() > iHoLoNum2.getHoNum().getHoNum()) {
                        if (db.on()) {
                            db.println("SvTrPrefs: ERROR calculating lolabels ");
                        }
                        return linkedList;
                    }
                    linkedList.add(iHoLoNum3);
                }
                if (db.on()) {
                    db.println("SvTrPrefs: Returning " + linkedList.size() + " loLabels ");
                }
            } else if (iCircuitSize.getEnum() == 10 && iServerTrailEnd.getTrailSize() == 11) {
                iHoLoNum3 = iHoLoNum;
                while (!iHoLoNum3.equals(iHoLoNum2)) {
                    short s = iHoLoNum3.getLoNum().getVc3OrSts1();
                    IHoNum iHoNum3 = iHoLoNum3.getHoNum();
                    ILoNum iLoNum3 = HoLoFactory.idlVtStruct2LoNum(n, 10, s, 1, 1);
                    IHoLoNum iHoLoNum4 = HoLoFactory.createHoLoNum(iHoNum3, iLoNum3);
                    IHoLoNum iHoLoNum5 = null;
                    for (int i = 0; i < 21; ++i) {
                        iHoLoNum5 = HoLoFactory.addNeBasedOffset(iHoLoNum4, i);
                        if (iHoLoNum5 == null) continue;
                        linkedList.add(iHoLoNum5);
                    }
                    if ((iHoLoNum3 = HoLoFactory.addNeBasedOffset(iHoLoNum3, 1)) != null && iHoLoNum3.getHoNum().getHoNum() <= iHoLoNum2.getHoNum().getHoNum()) continue;
                    if (db.on()) {
                        db.println("SvTrPrefs: ERROR converting Lolabels ");
                    }
                    return linkedList;
                }
                if (db.on()) {
                    db.println("SvTrPrefs: Returning " + linkedList.size() + " VC12-loLabels in ctp");
                }
            } else if (iCircuitSize.getEnum() == 11 && iServerTrailEnd.getTrailSize() == 10) {
                iHoLoNum3 = iHoLoNum;
                while (!iHoLoNum3.equals(iHoLoNum2)) {
                    ILoNum iLoNum4;
                    short s = iHoLoNum3.getLoNum().getVc3OrSts1();
                    IHoNum iHoNum4 = iHoLoNum3.getHoNum();
                    IHoLoNum iHoLoNum6 = HoLoFactory.createHoLoNum(iHoNum4, iLoNum4 = HoLoFactory.idlVtStruct2LoNum(n, 11, s, 1, 1));
                    if (!linkedList.contains(iHoLoNum6)) {
                        linkedList.add(iHoLoNum6);
                    }
                    if ((iHoLoNum3 = HoLoFactory.addNeBasedOffset(iHoLoNum3, 1)) != null && iHoLoNum3.getHoNum().getHoNum() <= iHoLoNum2.getHoNum().getHoNum()) continue;
                    if (db.on()) {
                        db.println("SvTrPrefs: ERROR converting Lolabels ");
                    }
                    return linkedList;
                }
                if (db.on()) {
                    db.println("SvTrPrefs: Returning " + linkedList.size() + " VC3-loLabels in ctp");
                }
            }
        } else if (iServerTrailEnd instanceof IHoServerTrailEnd) {
            IHoServerTrailEnd iHoServerTrailEnd = (IHoServerTrailEnd)iServerTrailEnd;
            int n = iHoServerTrailEnd.getTrailStart().getNodeModel().getFramingType();
            IHoNum iHoNum = iHoServerTrailEnd.getTrailStart().getStartingHo();
            IHoNum iHoNum5 = iHoServerTrailEnd.getTrailEnd().getStartingHo();
            IHoNum iHoNum6 = iHoNum;
            while (iHoNum6.getHoNum() <= iHoNum5.getHoNum()) {
                List list = HoLoFactory.getAllLoNums(n, iCircuitSize.getEnum());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ILoNum iLoNum = (ILoNum)iterator.next();
                    IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(iHoNum6, iLoNum);
                    linkedList.add(iHoLoNum);
                }
                iHoNum6 = HoLoFactory.addOffset(iHoNum6, 1);
            }
            if (db.on()) {
                db.println("SvTrPrefs: Returning " + linkedList.size() + " LoLabels of type " + iCircuitSize.getCircuitSizeString());
            }
        }
        return linkedList;
    }

    public void setTrailId(IServerTrailLinkId iServerTrailLinkId) {
        this.svId = iServerTrailLinkId;
    }

    public IServerTrailLinkId getTrailId() {
        return this.svId;
    }

    public String getTrailIdString() {
        String string = "";
        IServerTrailLinkId iServerTrailLinkId = this.getTrailId();
        if (iServerTrailLinkId == null) {
            return string;
        }
        int n = iServerTrailLinkId.getNodeId();
        INetElement iNetElement = Network.instance().getNetElem(n);
        if (iNetElement == null) {
            return string;
        }
        int n2 = iServerTrailLinkId.getUniqueId();
        string = string + iNetElement.getName() + ":" + n2;
        return string;
    }

    public String getCircuitSizeString() {
        return this.trailCktSize.getCircuitSizeString();
    }

    public void setDiscovered() {
        this.discovered = true;
    }

    public boolean isDiscovered() {
        return this.discovered;
    }

    public void checkLoAdits() {
        ILoAditModel iLoAditModel;
        if (!this.isLoTrail()) {
            return;
        }
        IHoNum iHoNum = ((IHoLoNum)this.getSrcPoolStart()).getHoNum();
        IHoNum iHoNum2 = ((IHoLoNum)this.getSrcPoolEnd()).getHoNum();
        IHoNum iHoNum3 = iHoNum;
        while (iHoNum3.getHoNum() <= iHoNum2.getHoNum()) {
            iLoAditModel = ServerTrailPrefs.getLoAdit(iHoNum3, this.getSrc().getNodeModel(), this.getSrcEntity());
            if (iLoAditModel == null) {
                iLoAditModel = this.createLoAdit(this.getSrc(), iHoNum3, this.getSrcEntity());
            }
            iHoNum3 = HoLoFactory.addOffset(iHoNum3, 1);
        }
        IHoNum iHoNum4 = ((IHoLoNum)this.getDestPoolStart()).getHoNum();
        IHoNum iHoNum5 = ((IHoLoNum)this.getDestPoolEnd()).getHoNum();
        iHoNum3 = iHoNum4;
        while (iHoNum3.getHoNum() <= iHoNum5.getHoNum()) {
            iLoAditModel = ServerTrailPrefs.getLoAdit(iHoNum3, this.getDest().getNodeModel(), this.getDestEntity());
            if (iLoAditModel == null) {
                iLoAditModel = this.createLoAdit(this.getDest(), iHoNum3, this.getDestEntity());
            }
            iHoNum3 = HoLoFactory.addOffset(iHoNum3, 1);
        }
    }

    protected static ILoAditModel getLoAdit(IHoNum iHoNum, INodeModel iNodeModel, int n) {
        IPoolModel iPoolModel = iNodeModel.getPoolModels().getPoolModel(n);
        ILoAditModel[] iLoAditModelArray = iNodeModel.getConnectionModels().getLoAditsInPool(iPoolModel);
        if (iLoAditModelArray != null) {
            for (int i = 0; i < iLoAditModelArray.length; ++i) {
                try {
                    ILoAditModel iLoAditModel = iLoAditModelArray[i];
                    if (iLoAditModel != null && HoPathDefModel.physicalHo(iLoAditModel.getHo()).equals(iHoNum)) {
                        return iLoAditModel;
                    }
                    continue;
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private ILoAditModel createLoAdit(INetElement iNetElement, IHoNum iHoNum, int n) {
        block6: {
            INodeModel iNodeModel = ((NetElement)iNetElement).getNodeModel();
            HoPathDefModel hoPathDefModel = null;
            IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
            IPoolModel iPoolModel = iNodeModel.getPoolModels().getPoolModel(n);
            int n2 = CircuitSize.getLoTunnelSize((int)iNodeModel.getFramingType()).getEnum();
            short s = CircuitSize.getCircuitSize((int)n2).size2widthOfHoCircuit();
            IHoNum iHoNum2 = iPoolModel.includedPath().getStartingHo();
            IHoNum iHoNum3 = iHoNum;
            IHoNum iHoNum4 = HoLoFactory.removeOffset(iHoNum3, iHoNum2);
            hoPathDefModel = new HoPathDefModel(iPoolModel, s, iHoNum4, 0);
            try {
                CircuitId circuitId = new CircuitId(iNetElement.getNodeId(), 0);
                return iConnectionModels.createLoAdit((ICircuitId)circuitId, (IHoPathDefModel)hoPathDefModel, 3);
            }
            catch (PathInUse pathInUse) {
                if (db.on()) {
                    db.println("SVTrail: Failure to create LoAdit at ho " + iHoNum.prettyString() + " pathInUse ");
                }
            }
            catch (InvalidPath invalidPath) {
                if (db.on()) {
                    db.println("SVTrail: Failure to create LoAdit at ho " + iHoNum.prettyString() + " InvalidPath ");
                }
            }
            catch (NoMoreLoCapableHo noMoreLoCapableHo) {
                if (!db.on()) break block6;
                db.println("SVTrail: Failure to create LoAdit at ho " + iHoNum.prettyString() + " NoMoreLoCapableHo ");
            }
        }
        return null;
    }

    private boolean aditInUseByAnotherCTP(ILoAditModel iLoAditModel, IServerTrailEnd iServerTrailEnd) {
        LinkedList linkedList;
        IServerTrailLinkId iServerTrailLinkId = null;
        if (iLoAditModel == null) {
            return false;
        }
        if (iServerTrailEnd != null) {
            if (!(iServerTrailEnd instanceof ILoServerTrailEnd)) {
                return false;
            }
            iServerTrailLinkId = iServerTrailEnd.getServerTrailLinkId();
        }
        short s = iLoAditModel.getHo().getStartingHo().getHoNum();
        try {
            linkedList = (LinkedList)Network.instance().findCTPs(iLoAditModel.getHo().getPool().getEntityModel());
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (ServerTrailPrefs.db.on) {
                db.println("Error getting EntityModel");
            }
            return false;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            IServerTrailLinkId iServerTrailLinkId2;
            IServerTrailEnd iServerTrailEnd2 = (IServerTrailEnd)iterator.next();
            if (!(iServerTrailEnd2 instanceof ILoServerTrailEnd)) continue;
            ILoServerTrailEnd iLoServerTrailEnd = (ILoServerTrailEnd)iServerTrailEnd2;
            if (iServerTrailEnd != null && (iServerTrailLinkId2 = iLoServerTrailEnd.getServerTrailLinkId()).getNodeId() == iServerTrailLinkId.getNodeId() && iServerTrailLinkId2.getUniqueId() == iServerTrailLinkId.getUniqueId()) continue;
            short s2 = iLoServerTrailEnd.getTrailStart().getLoAdit().getHo().getStartingHo().getHoNum();
            short s3 = iLoServerTrailEnd.getTrailEnd().getLoAdit().getHo().getStartingHo().getHoNum();
            if (s != s2 && s != s3 && (s <= s2 || s >= s3)) continue;
            return true;
        }
        return false;
    }

    public void cleanupLoAdits(IServerTrailEnd iServerTrailEnd) {
        if (!(iServerTrailEnd instanceof ILoServerTrailEnd)) {
            return;
        }
        ILoServerTrailEnd iLoServerTrailEnd = (ILoServerTrailEnd)iServerTrailEnd;
        IHoNum iHoNum = iLoServerTrailEnd.getTrailStart().getLoAdit().getHo().getStartingHo();
        IHoNum iHoNum2 = iLoServerTrailEnd.getTrailEnd().getLoAdit().getHo().getStartingHo();
        IHoNum iHoNum3 = iHoNum;
        while (iHoNum3.getHoNum() <= iHoNum2.getHoNum()) {
            ILoAditModel iLoAditModel = ServerTrailPrefs.getLoAdit(iHoNum3, iLoServerTrailEnd.getTrailStart().getLoAdit().getHo().getNodeModel(), iLoServerTrailEnd.getTrailStart().getLoAdit().getHo().getPool().getEntityIndex());
            if (iLoAditModel != null) {
                if (db.on()) {
                    db.println(" Checking LoAdit at Ho : " + iLoAditModel.getHo().getStartingHo().prettyString());
                }
                if (!this.aditInUseByAnotherCTP(iLoAditModel, iServerTrailEnd) && !iLoAditModel.inUse()) {
                    try {
                        if (db.on()) {
                            db.println(" Removing LoAdit at Ho : " + iLoAditModel.getHo().getStartingHo().prettyString());
                        }
                        iLoAditModel.localDestroy();
                    }
                    catch (Busy busy) {
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        if (db.on()) {
                            db.println("LoAdit already deleted");
                        }
                    }
                } else if (db.on()) {
                    db.println("LoAdit is in Use");
                }
            }
            iHoNum3 = HoLoFactory.addOffset(iHoNum3, 1);
        }
    }

    public void cleanupLoAdits() {
        ILoAditModel iLoAditModel;
        if (!this.isLoTrail()) {
            return;
        }
        IHoNum iHoNum = ((IHoLoNum)this.getSrcPoolStart()).getHoNum();
        IHoNum iHoNum2 = ((IHoLoNum)this.getSrcPoolEnd()).getHoNum();
        IHoNum iHoNum3 = iHoNum;
        while (iHoNum3.getHoNum() <= iHoNum2.getHoNum()) {
            block15: {
                iLoAditModel = ServerTrailPrefs.getLoAdit(iHoNum3, this.getSrc().getNodeModel(), this.getSrcEntity());
                iHoNum3 = HoLoFactory.addOffset(iHoNum3, 1);
                if (iLoAditModel == null) continue;
                if (this.aditInUseByAnotherCTP(iLoAditModel, null)) {
                    if (!db.on()) continue;
                    db.println("Another CTP using LoAdit at Ho : " + iLoAditModel.getHo().getStartingHo().prettyString());
                    continue;
                }
                if (db.on()) {
                    db.println(" Removing LoAdit at Ho : " + iLoAditModel.getHo().getStartingHo().prettyString());
                }
                if (!iLoAditModel.inUse()) {
                    try {
                        iLoAditModel.localDestroy();
                    }
                    catch (Busy busy) {
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        if (!db.on()) break block15;
                        db.println("LoAdit deleted");
                    }
                }
            }
            if (!db.on()) continue;
            db.println("LoAdit is in Use");
        }
        IHoNum iHoNum4 = ((IHoLoNum)this.getDestPoolStart()).getHoNum();
        IHoNum iHoNum5 = ((IHoLoNum)this.getDestPoolEnd()).getHoNum();
        iHoNum3 = iHoNum4;
        while (iHoNum3.getHoNum() <= iHoNum5.getHoNum()) {
            block16: {
                iLoAditModel = ServerTrailPrefs.getLoAdit(iHoNum3, this.getDest().getNodeModel(), this.getDestEntity());
                iHoNum3 = HoLoFactory.addOffset(iHoNum3, 1);
                if (iLoAditModel == null) continue;
                if (this.aditInUseByAnotherCTP(iLoAditModel, null)) {
                    if (!db.on()) continue;
                    db.println("Another CTP using LoAdit at Ho : " + iLoAditModel.getHo().getStartingHo().prettyString());
                    continue;
                }
                if (db.on()) {
                    db.println(" Removing LoAdit at Ho : " + iLoAditModel.getHo().getStartingHo().prettyString());
                }
                if (!iLoAditModel.inUse()) {
                    try {
                        iLoAditModel.localDestroy();
                    }
                    catch (Busy busy) {
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        if (!db.on()) break block16;
                        db.println("LoAdit deleted");
                    }
                }
            }
            if (!db.on()) continue;
            db.println("LoAdit is in Use");
        }
    }

    public static boolean isServerTrailPort(IEntityModel iEntityModel) {
        int n;
        ITdmPortModel iTdmPortModel;
        if (iEntityModel == null) {
            return false;
        }
        return iEntityModel instanceof ITdmPortModel ? (iTdmPortModel = (ITdmPortModel)iEntityModel).isOptical() && !iTdmPortModel.isSonetDccTermination() : (n = iEntityModel.getEqType()) == 4 || n == 5 || n == 6 || n == 7 || n == 12 || n == 13 || n == 31 || n == 32 || n == 34 || n == 47 || n == 50 || n == 57 || n == 58 || n == 64 || n == 65 || n == 68 || n == 69 || n == 83 || n == 108 || n == 109 || n == 113 || n == 114 || n == 185 || n == 201 || n == 202 || n == 203 || n == 207 || n == 208 || n == 209 || n == 233 || n == 234 || n == 235;
    }

    public String prettyString() {
        String string = "\n\tServerTrail Preferences: ";
        string = string + " Src " + this.source.prettyString() + "(" + Integer.toHexString(this.srcEntityIndex) + ")" + "->" + " Dst " + this.dest.prettyString() + "(" + Integer.toHexString(this.destEntityIndex) + "). ";
        string = string + "SourcePool Start: ";
        if (this.getSrcPoolStart() != null) {
            string = this.getSrcPoolStart() instanceof IHoNum ? string + ((IHoNum)this.getSrcPoolStart()).prettyString() : (this.getSrcPoolStart() instanceof IHoLoNum ? string + ((IHoLoNum)this.getSrcPoolStart()).prettyString() : string + " WRONG type of SourceStart Label");
        }
        string = string + "SourcePool End: ";
        if (this.getSrcPoolEnd() != null) {
            string = this.getSrcPoolEnd() instanceof IHoNum ? string + ((IHoNum)this.getSrcPoolEnd()).prettyString() : (this.getSrcPoolEnd() instanceof IHoLoNum ? string + ((IHoLoNum)this.getSrcPoolEnd()).prettyString() : string + " WRONG type of SourceEnd Label");
        }
        string = string + "DestPool Start: ";
        if (this.getDestPoolStart() != null) {
            string = this.getDestPoolStart() instanceof IHoNum ? string + ((IHoNum)this.getDestPoolStart()).prettyString() : (this.getDestPoolStart() instanceof IHoLoNum ? string + ((IHoLoNum)this.getDestPoolStart()).prettyString() : string + " WRONG type of DestStart Label");
        }
        string = string + "DestPool End: ";
        if (this.getDestPoolEnd() != null) {
            string = this.getDestPoolEnd() instanceof IHoNum ? string + ((IHoNum)this.getDestPoolEnd()).prettyString() : (this.getDestPoolEnd() instanceof IHoLoNum ? string + ((IHoLoNum)this.getDestPoolEnd()).prettyString() : string + " WRONG type of DestEnd Label");
        }
        string = string + "TrailCktSize: ";
        string = string + EnumStrings.getString((Class)ICircuitSize.class, (int)this.getCircuitSize().getEnum());
        string = string + "ProtectionType: " + this.protType;
        string = string + "SRLG: " + this.srlg;
        string = string + "Cost: " + this.cost;
        string = string + "isLo: " + this.isLoTrail;
        string = string + "Nx : " + this.Nx;
        string = string + this.getTrailIdString();
        string = string + " ======================== ";
        return string;
    }
}

